"""Polynomial manipulation algorithms and algebraic objects. """

from polytools import (
    Poly, PurePoly, poly,
    poly_from_expr,
    parallel_poly_from_expr,
    degree, degree_list,
    LC, LM, LT,
    pdiv, prem, pquo, pexquo,
    div, rem, quo, exquo,
    half_gcdex, gcdex, invert,
    subresultants,
    resultant, discriminant,
    terms_gcd, cofactors,
    gcd, gcd_list,
    lcm, lcm_list,
    trunc,
    monic, content, primitive,
    compose, decompose,
    sturm,
    gff_list, gff,
    sqf_norm, sqf_part, sqf_list, sqf,
    factor_list, factor,
    intervals, refine_root, count_roots,
    real_roots, nroots, ground_roots,
    nth_power_roots_poly,
    cancel,
    reduced, groebner,
)

from polyfuncs import (
    symmetrize, horner, interpolate, viete,
)

from rationaltools import (
    together,
)

from polyerrors import (
    OperationNotSupported,
    ExactQuotientFailed,
    ComputationFailed,
    UnificationFailed,
    GeneratorsNeeded,
    RefinementFailed,
    PolynomialError,
    CoercionFailed,
    NotInvertible,
    NotReversible,
    NotAlgebraic,
    DomainError,
)

from numberfields import (
    minimal_polynomial, minpoly,
    primitive_element, primelt,
    field_isomorphism,
    to_number_field,
    AlgebraicNumber,
    isolate,
)

from monomialtools import (
    Monomial, monomials, monomial_count,
)

from rootoftools import (
    RootOf, RootSum,
)

from polyroots import (
    roots,
)

from domains import (
    FF, GF, ZZ, QQ, RR, EX,
)

from constructor import (
    construct_domain,
)

from specialpolys import (
    swinnerton_dyer_poly,
    interpolating_poly,
    cyclotomic_poly,
    symmetric_poly,
    random_poly,
)

from orthopolys import (
    chebyshevt_poly,
    chebyshevu_poly,
    hermite_poly,
    legendre_poly,
    laguerre_poly,
)

from partfrac import (
    apart,
)

from polyoptions import Options
import polycontext as ctx

