/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.ArityException;
import org.javia.arity.EvalCase;
import org.javia.arity.Function;
import org.javia.arity.FunctionAndName;
import org.javia.arity.Symbols;
import org.javia.arity.SyntaxException;
import org.javia.arity.Util;

class TestEval {
    static EvalCase[] cases = new EvalCase[]{new EvalCase(".", 0.0), new EvalCase("1+.", 1.0), new EvalCase("1", 1.0), new EvalCase("\u03c0", Math.PI), new EvalCase("2\u00d73", 6.0), new EvalCase("1+\u221a9*2", 7.0), new EvalCase("3\u221a 4", 6.0), new EvalCase("\u221a16sin(2\u03c0/4)", 4.0), new EvalCase("1+", -2.0), new EvalCase("1+1", 2.0), new EvalCase("1+-1", 0.0), new EvalCase("-0.5", -0.5), new EvalCase("+1e2", 100.0), new EvalCase("-2^3!", -64.0), new EvalCase("(-2)^3!", 64.0), new EvalCase("-2^1^2", -2.0), new EvalCase("--1", 1.0), new EvalCase("-3^--2", -9.0), new EvalCase("1+2)(2+3", 15.0), new EvalCase("1+2)!^-2", 0.027777777777777776), new EvalCase("sin(0)", 0.0), new EvalCase("cos(0)", 1.0), new EvalCase("sin(-1--1)", 0.0), new EvalCase("-(2+1)*-(4/2)", 6.0), new EvalCase("-.5E-1", -0.05), new EvalCase("1E1.5", -2.0), new EvalCase("2 3 4", 24.0), new EvalCase("pi", Math.PI), new EvalCase("e", Math.E), new EvalCase("sin(pi/2)", 1.0), new EvalCase("f=sin(2x)", -3.0), new EvalCase("f(pi/2)", 0.0), new EvalCase("a=3", 3.0), new EvalCase("b=a+1", 4.0), new EvalCase("f(x, y) = x*(y+1)", -3.0), new EvalCase("f(a, b-a)", 6.0), new EvalCase(" f(a pi/4)", -1.0), new EvalCase("f (  1  +  1  , a+1)", 10.0), new EvalCase("g(foo) = f (f(foo, 1)pi/2)", -3.0), new EvalCase("g(.5*2)", 0.0), new EvalCase("NaN", Double.NaN), new EvalCase("Inf", Double.POSITIVE_INFINITY), new EvalCase("Infinity", Double.POSITIVE_INFINITY), new EvalCase("-Inf", Double.NEGATIVE_INFINITY), new EvalCase("0/0", Double.NaN)};

    TestEval() {
    }

    private static boolean equal(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-15 || Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    static boolean testEval() throws ArityException {
        boolean bl = true;
        Symbols symbols = new Symbols();
        for (int i = 0; i < cases.length; ++i) {
            boolean bl2;
            String string;
            EvalCase evalCase = cases[i];
            try {
                double d;
                if (Symbols.isDefinition(evalCase.expr)) {
                    FunctionAndName functionAndName = symbols.compile(evalCase.expr);
                    symbols.define(functionAndName);
                    Function function = functionAndName.function;
                    d = function.arity() == 0 ? function.eval() : -3.0;
                    string = function.arity() == 0 ? Util.doubleToString(d, 1) : function.toString();
                } else {
                    d = symbols.eval(evalCase.expr);
                    string = Util.doubleToString(d, 1);
                }
                bl2 = TestEval.equal(evalCase.result, d);
            }
            catch (SyntaxException syntaxException) {
                string = syntaxException.toString();
                bl2 = evalCase.result == -2.0;
            }
            System.out.println((bl2 ? "" : "failed (expected " + evalCase.result + "): ") + evalCase.expr + "                                           ".substring(0, Math.max(15 - evalCase.expr.length(), 0)) + " = " + string);
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }
}

