/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.StringTokenizer;

class Text
extends DiagramItem {
    String text;
    StringBuffer buffer;

    Text() {
        this.y = 0;
        this.x = 0;
        this.buffer = new StringBuffer();
        this.text = this.buffer.toString().concat("_");
    }

    Text(StringTokenizer stringTokenizer) throws Exception {
        if (stringTokenizer.countTokens() < 1) {
            throw new IllegalArgumentException();
        }
        this.x = new Integer(stringTokenizer.nextToken());
        this.y = new Integer(stringTokenizer.nextToken());
        this.text = stringTokenizer.nextToken("\n\r").trim();
    }

    void create() {
        super.create();
        this.diagram.editor.controls.disable();
        this.diagram.editor.showStatus(VrijeInvulVeld.t_press);
        ++VrijeInvulVeld.textcounter;
    }

    public void yield() {
        super.yield();
        this.diagram.editor.controls.enable();
        this.text = this.buffer.toString();
    }

    String describe() {
        return "text," + this.x + "," + this.y + "," + this.text;
    }

    String specify_text() {
        return this.text;
    }

    int specify_text_x() {
        return this.x;
    }

    int specify_text_y() {
        return this.y;
    }

    int specify_line_x1() {
        return -1;
    }

    int specify_line_y1() {
        return -1;
    }

    int specify_line_x2() {
        return -1;
    }

    int specify_line_y2() {
        return -1;
    }

    void draw(Graphics graphics) {
        if (!VrijeInvulVeld.original) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = VrijeInvulVeld.ysize / VrijeInvulVeld.ygrid;
            int n2 = VrijeInvulVeld.xsize / VrijeInvulVeld.ygrid;
            if (this.state == 1 || this.state == 2) {
                graphics2D.setColor(VrijeInvulVeld.drawcolor);
                graphics2D.setStroke(new BasicStroke(1.0f));
                if (VrijeInvulVeld.textalign) {
                    for (int i = 0; i < VrijeInvulVeld.ysize; i += n) {
                        graphics2D.drawLine(0, i, VrijeInvulVeld.xsize, i);
                    }
                } else {
                    for (int i = 0; i < VrijeInvulVeld.xsize; i += n2) {
                        graphics2D.drawLine(i, 0, i, VrijeInvulVeld.ysize);
                    }
                }
                graphics2D.setFont(VrijeInvulVeld.penfont);
            } else {
                graphics2D.setFont(VrijeInvulVeld.penfont);
            }
            if (this.state != 2 && VrijeInvulVeld.ygrid < 50 && VrijeInvulVeld.ygrid > 1) {
                if (VrijeInvulVeld.textalign) {
                    this.y = n * Math.round(this.y / n);
                    if (this.y < n) {
                        this.y = n;
                    }
                    if (this.y > VrijeInvulVeld.ysize - n) {
                        this.y = VrijeInvulVeld.ysize - n;
                    }
                } else {
                    this.x = n2 * Math.round(this.x / n2);
                    if (this.x < n2) {
                        this.x = n2;
                    }
                    if (this.x > VrijeInvulVeld.xsize - n2) {
                        this.x = VrijeInvulVeld.xsize - n2;
                    }
                }
            }
            graphics2D.setColor(VrijeInvulVeld.textcolor);
            graphics2D.setStroke(new BasicStroke(VrijeInvulVeld.thickness));
            graphics2D.drawString(this.text, this.x, this.y);
            graphics2D.setColor(VrijeInvulVeld.drawcolor);
        } else {
            graphics.drawString(this.text, this.x, this.y);
        }
    }

    double distance(int n, int n2) {
        FontMetrics fontMetrics = this.diagram.editor.display.getGraphics().getFontMetrics();
        int n3 = this.y - fontMetrics.getAscent() / 2;
        if (n < this.x) {
            return Misc.distance(this.x, n3, n, n2);
        }
        int n4 = this.x + fontMetrics.stringWidth(this.text);
        if (n > n4) {
            return Misc.distance(n4, n3, n, n2);
        }
        return Math.abs(n2 - n3);
    }

    public boolean down(int n, int n2) {
        switch (this.state) {
            case 1: {
                this.x = n;
                this.y = n2;
                return true;
            }
            case 2: {
                return super.down(n, n2);
            }
        }
        return false;
    }

    public boolean up(int n, int n2) {
        switch (this.state) {
            case 1: {
                this.x = n;
                this.y = n2;
                return true;
            }
            case 2: {
                return super.up(n, n2);
            }
        }
        return false;
    }

    public boolean drag(int n, int n2) {
        switch (this.state) {
            case 1: {
                this.x = n;
                this.y = n2;
                return true;
            }
            case 2: {
                return super.drag(n, n2);
            }
        }
        return false;
    }

    public boolean key(int n) {
        char[] cArray = new char[1];
        switch (this.state) {
            case 1: {
                switch (n) {
                    case 10: 
                    case 13: {
                        this.yield();
                        if (this.text.equals("")) {
                            this.diagram.removeElement(this);
                            this.destroy();
                            this.diagram.editor.showStatus("String was empty");
                        } else {
                            this.diagram.editor.showStatus("");
                        }
                        return true;
                    }
                    case 8: 
                    case 127: {
                        int n2 = this.buffer.length();
                        if (n2 <= 0) break;
                        this.buffer.setLength(n2 - 1);
                        break;
                    }
                    default: {
                        this.buffer.append((char)n);
                    }
                }
                this.text = this.buffer.toString().concat("_");
                return true;
            }
        }
        return false;
    }
}

