target = divelem1 divelem2 quotient surjectif

#if #TARGET(divelem1)
\title{Diviseurs lmentaires et base associe}
#elif #TARGET(divelem2)
\title{Diviseurs lmentaires}
#elif #TARGET(quotient)
\title{Quotient de deux Z-modules}
#elif #TARGET(surjectif)
\title{Surjectivit}
#endif 


\language{fr}
\range{1..5}
\author{Bernadette Perrin-Riou, Wolfgang Steimle}
\email{bpr@math.u-psud.fr}
\computeanswer{no}
\format{html}
\precision{10000}

\integer{N=\confparm1 iswordof 2 3 4 5  ? \confparm1 : randint(2..3)}//dimension de l'espace
#if #TARGET(surjectif)
\integer{M=\N} //nombre de vecteurs engendrant le rseau
#else
\integer{M=randint(1..\N)} //nombre de vecteurs engendrant le rseau
#endif

//produire un systme de gnrateurs du rseau

\text{U = slib(matrix/unimodular \N,4)}
\text{V = slib(matrix/unimodular \N,4)}
\text{w = slib(matrix/non0 1,\N,3)}

#if #TARGET(surjectif)
\text{w=\w
wims(makelist 1 for x = 1 to \N)}
\text{w=randomrow(\w)}
#endif
\text{D = pari(
  v = vector(\N);
  w1 = Vec([\w]);
  v[\N]=abs(w1[\N]);
  for(X=1,\N-1,v[\N-X]=v[\N-X+1]*abs(w1[X]));
  D = matdiagonal(v)
)}  
  
\text{reseau = pari(
  d=Mat([\D]); 
  u=Mat([\U]); 
  v=Mat([\V]); 
  r=u^(-1)*d*v^(-1);
  reseau=matrix(\N,\M,X,Y,r[X,Y])
)}

\text{reseaucarre = pari(
  r=Mat([\reseau]); 
  reseaucarre=matrix(\N,\N,X,Y,if(Y<=\M,r[X,Y],0))
)}


//matrice des diviseurs lmentaires
\text{demat = pari(
  r = Mat([\reseaucarre]);
  demat = matsnf(r,1)[3]
)}

//vecteur des diviseurs lmentaires
\text{devec = pari(
  r = Mat([\reseaucarre]);
  s = matsnf(r);
  devec = vector(\M,X,s[\N-\M+X])
)}
#if #TARGET(surjectif)
\integer{devec=wims(replace , by * in \devec)}
\text{devec=\devec <>1 or \devec =0 ? 2:1}
\text{ouinon=oui,non}
#endif


#if #TARGET(surjectif)
\statement{L'application linaire de \ZZ-modules \(f : \ZZ^\M\to \ZZ^\N ) 
dont la matrice dans les bases canoniques est
<p style="text-align:center">\([\reseau])</p> 
est-elle surjective ?   
<p style="text-align:center">\embed{reply 1}</p>
}
\answer{}{\devec;\ouinon}{type=radio}


#endif
#if #TARGET(divelem1) ||  #TARGET(divelem2)

//nonc

\statement{

\if{\M=1}{Le vecteur}{Les vecteurs colonnes de la matrice } 
<p style="text-align:center">\([\reseau])</p>
\if{\M=1}{est le gnrateur}{sont les gnrateurs} d'un sous-\ZZ-module \(M)
de \(\ZZ^\N).
<p>
\if{\M=1}{Le diviseur lmentaire}{Les diviseurs lmentaires}
de \(M), considr comme sous-module de \(\ZZ^\N),
\if{\M=1}{est}{sont, du plus grand au plus petit,}
<p style="text-align:center">\embed{reply 1,10}.</p>
#endif
#if #TARGET(divelem1)
<p>Donner une base  de \(\ZZ^\N) associe  \(M) :
<p style="text-align:center">\embed{reply 2}</p>
<br>
<font size=-1>S'il y a plusieurs diviseurs lmentaires, sparez-les par des virgules. <br>
Entrer la base associe en forme d'une matrice o les vecteurs 
colonnes forment la base associe. Donner d'abord les vecteurs 
associs aux diviseurs lmentaires dans le mme ordre que ceux-l, 
puis le reste de la base.</font>
</p>
#endif
#if #TARGET(divelem1) ||  #TARGET(divelem2)
}
//fin de l'nonc

\answer{}{\devec}{type=vector}
#endif
#if #TARGET(divelem1)
\answer{}{\matrice}{type=matrix}
\matrix{U=\reply2}

//tester si U=(x1,...,xn) forme une base de ZZ^n
\integer{det = pari(mat=Mat([\U]); det=matdet(mat))}
\integer{result1 = \det=1 or \det=-1 ? 1 : 0}

//tester si U est une base associe : Les ai*xi doivent tre une base du rseau
\text{result2 = pari(
  mat1=Mat([\U]);
  U1 = matrix(\N,\M,X,Y,mat1[X,Y]);
  V = U1 * matdiagonal([\devec]);
  E = Mat([\reseau]);
  if((mathnf(V)==mathnf(E))|(mathnf(V)==-mathnf(E)),
    result2=1,result2=0)
)}


  
\condition{Les vecteurs forment une base du rseau }{\result1=1}
\condition{C'est une base associe aux diviseurs lmentaires }{\result2=1}
#endif

#if #TARGET(quotient)

\text{STEPS=wims(makelist r x for x=1 to \M+1)}
\steps{\STEPS}
\integer{reponse1 = \N-\M}

//nonc
\statement{Soit \(M) le sous-\ZZ-module de \(\ZZ^\N) engendr 
par \if{\M=1}{le vecteur}{les vecteurs colonnes de la matrice} 
<p style="text-align:center">\([\reseau]).</p>
Calculer la dcomposition du module quotient \(\ZZ^\N/M) 
en somme directe d'une partie libre \(\ZZ^r) et de sous-modules de torsion \ZZ/\(d_i)\ZZ, 
o \(d_i) est divisible par \(d_(i-1)).<br>
<p align=center>
\(\ZZ^\N/M) = \ZZ<sup><sup>\embed{reply 1,2}</sup></sup> 
\for{k=2 to \M+1}{\oplus \ZZ/\embed{r \k,2} \ZZ}
</p>
}
//fin de l'nonc

\answer{}{\reponse1}{type=numeric}
\answer{}{\devec[1]}{type=numeric}
\answer{}{\devec[2]}{type=numeric}
\answer{}{\devec[3]}{type=numeric}

#endif

\help{Les diviseurs lmentaires (invariants de similitude)
du sous-\ZZ-module \(M \subset \ZZ^N) sont dfinis de la manire suivante : 
<p>Il existe une base \(e_i) (\(i = 1, ... , N)) de \(\ZZ^N) 
et des entiers \(a_i) (\(i = 1, ... , d)), o \(d \le N) est le rang de \(M), tels que 
<ul>
<li>\(a_i*e_i) (\(i = 1 ... d)) est une base
du \ZZ-module  \(M),</li>
<li>\(a_(i+1)) divise \(a_i) pour tous \(1 \le i \leq d-1). </li>
</ul>
La base \((e_i)) (\(i = 1, ..., N))  est dite associe  \(M).

Les diviseurs lmentaires peuvent se calculer  l'aide du pgcd des 
dterminants des mineurs d'ordre \(k) : par exemple,
\(d_N) est le pgcd des lments des vecteurs colonnes d'un systme 
gnrateur, \(d_N d_(N-1)) est le pgcd des mineurs d'ordre 2 ...}
