target=couleur chromatic

\integer{n=\confparm1=1?randint(4..7)}
\integer{n=\confparm1=2?randint(7..8)}
\integer{n=\confparm1=3?randint(9..10)}
\integer{n=\confparm1=?randint(6..9)}

\text{couleur=green,red,blue,yellow,orange,brown,gray,black,white,olive,magenta,navy,skyblue}


\language{fr}
\range{-5..5}
\computeanswer{no}
\format{html}
\precision{10000}

#if #TARGET (couleur)
 \title{Colorier un graphe}
#endif

#if #TARGET (chromatic)
 \title{Nombre chromatique}
#endif

\integer{N=\n-1}
\integer{M=max(\N/3,3)}
\integer{s=randint(\M..\N)}
\matrix{G=pari(n=\n;
  M=matrix(n,n,i,j,1);
  for(i=2,\s,M[i-1,i]=0);
  M=matrix(n,n,i,j,if(M[i,j], random\(2), 0));
  for(i=1,n,M[i,i]=0);matrix(n,n,i,j,M[min(i,j),max(i,j)]))}

\matrix{p=shuffle(\n)}
\matrix{G=pari(p=[\p];G=Mat([\G]);matrix(n,n,i,j,G[p[i],p[j]]))}

\text{abscord = wims(makelist cos(2*Pi*x/\n),sin(2*Pi*x/\n) for x = 1 to \n)}
\text{abscord=pari([\abscord])}
\text{SIZE=300,300}
\text{range=-1.5,1.5}
\text{dessin=slib(graph/draw [\G])}

\text{degre=}
\for{s=1 to \n}{
  \text{adj = position(1,\G[\s;])}
  \text{degre= wims(append item wims(replace internal , by + in \G[\s;]) to \degre)}
}
\text{degre=pari([\degre])}
\text{maxdeg=pari(vecmax([\degre]) + 1)}
\text{color=wims(makelist x for x=1 to \n)}
\text{sommet=wims(makelist x for x=1 to \n)}
\text{C1 = wims(makelist 0 for x = 1 to \n)}

text{ord =pari(vecsort([\degre],,4))}
text{LL =pari(vecsort([\degre],,5))}

#include "complet.inc"
comp est l'ordre du sous graphe complet maximal. 

#include "chromatic.inc"

\text{dessin1=\dessin}
 \for{j = 1 to \n}{
   \text{dessin1=\dessin1
   disk \abscord[\2*\j-1,\2*\j],13,\couleur[\chromatique[\j]]
   } 
}

\text{dessin=draw(\SIZE
\dessin)}
\text{dessin1=draw(\SIZE
\dessin1)}

\matrix{pos=}
\for{j=1 to \n}{
  \text{POS1=slib(draw/convpixel \abscord[\2*\j-1,\2*\j],\SIZE,\range,\range,10,pixels) }
  \matrix{pos=\pos
  r \j,\POS1[1] x \POS1[2]} 
}
\text{taille=20 x 20}
\text{Co=}
\for{i=1 to items(\couleur)}{
\text{Co = \Co, <table width=100% bgcolor=\couleur[\i]><tr><td>&nbsp;</td></tr></table>}
}
\text{Co=wims(nonempty items \Co)}


#if #TARGET (couleur)
\text{STEP=wims(makelist r x for x = 1 to \n)}


\steps{\STEP}
\statement{
\special{help colorier,Colorier} le graphe avec le moins de couleurs possibles
<p align="center">
\special{imagefill \dessin,\SIZE[1] x \SIZE[2],\taille
  \pos}
  </p>
}

\answer{}{\rep1;\Co[1]}{type=clickfill}
\answer{}{\rep2;\Co[2]}{type=clickfill}
\answer{}{\rep3;\Co[3]}{type=clickfill}
\answer{}{\rep4;\Co[4]}{type=clickfill}
\answer{}{\rep5;\Co[5]}{type=clickfill}
\answer{}{\rep6;\Co[6]}{type=clickfill}
\answer{}{\rep7;\Co[7]}{type=clickfill}
\answer{}{\rep8;\Co[8]}{type=clickfill}
\answer{}{\rep9;\Co[9]}{type=clickfill}
\answer{}{\rep10;\Co[10]}{type=clickfill}
\answer{}{\rep11;\Co[11]}{type=clickfill}
\answer{}{\rep12;\Co[12]}{type=clickfill}
\answer{}{\rep13;\Co[10]}{type=clickfill}
\answer{}{\rep14;\Co[11]}{type=clickfill}
\answer{}{\rep15;\Co[12]}{type=clickfill}

\text{H =\reply1,\reply2,\reply3,\reply4}
\text{H=position(\reply1,\Co),position(\reply2,\Co),position(\reply3,\Co),position(\reply4,\Co),position(\reply5,\Co),
position(\reply6,\Co),position(\reply7,\Co),position(\reply8,\Co),position(\reply9,\Co),position(\reply10,\Co),position(\reply11,\Co),
position(\reply12,\Co)}
\text{H = \H[1..\n]}

Verification : meme couleur sur deux cotes adjacents
\text{conflit=}
\text{degr=}
\for{s=1 to \n}{
  \text{h = \H[\i]}
  \text{adj = position(1,\G[\s;])}
  \text{degr= wims(append item wims(replace internal , by + in \G[\s;]) to \degr)}
  \for{ j in \adj}{
    \if{\H[\s]=\H[\j] and \s < \j }{\matrix{conflit= \conflit
       \s,\j}
    }
  }
}

\text{couleur_diff=wims(listuniq \H)}
\text{couleur_cnt=items(\couleur_diff)}

\integer{borne=min(\chromat_cnt,\maxdeg)}

\condition{Vous avez  bien colori le graphe}{\conflit issametext}
\condition{Peu de couleurs}{\conflit issametext and \couleur_cnt <= \chromat_cnt}{option=hide}
\feedback{\conflit notsametext }{ Les sommets \conflit[1;1] et 
\conflit[1;2] sont adjacents et vous les avez colori tous deux 
de la mme couleur.
}
\feedback{\couleur_cnt > \borne or \conflit notsametext}{ 
Vous auriez pu colorier ce graphe avec  \borne couleurs.
<p align="center"><img src="\dessin1"></p>
}

#endif

#if #TARGET (chromatic)
\statement{Calculer le \special{help colorier,nombre chromatique} du graphe suivant

<p align="center"><img src="\dessin"></p>
}
\answer{Nombre chromatique}{\chromat_cnt}


\feedback{1=1}{
<p align="center"><img src="\dessin1"></p>
}

#endif

\help{\if{\help_subject issametext or  \help_subject issametext colorier}{
<font color=green><b>Colorier</b></font>un graphe,
c'est colorier les sommets de telle faon que deux sommets distincts et adjacents 
aient toujours des couleurs diffrentes.
<p>
Le <font color=green><b>nombre chromatique</b></font> est le plus petit nombre de couleurs ncessaires 
pour colorier le graphe.
}
}
