target=upperlower xcase batch1 batch2 batchw xletter tablemod posmod markmod1 markmod2

#include "header.inc"
#include "confparm.inc"
#define TRANS 1
\text{sizelim1=5}
\text{sizelim2=1999}

#if #TARGET (upperlower)
 \title{Transformer : Minuscule / majuscule}
 \text{data=randrow(
	majuscules,1
	minuscules,2
)}
 \text{result=transforme les caractres alphabtiques de <tt>\ll</tt>
	en \data[1].}
#endif

#if #TARGET (xcase)
 \title{Transformer : Echange de type}
 \text{result=transforme les caractres minuscules en majuscules et majuscules
   en minuscules.}
#endif

#if #TARGET (batch1)
 \title{Transformer : Modif-batch I}
 \text{chars=\allchars}
 \text{c=wims(charcnt \alpha)}
 \text{c=wims(char randint(1..\c) of \alpha)}
 \text{data=randomrow(
   toutes les lettres majuscules,\upper
   toutes les lettres minuscules,\lower
   tous les caractres alphabtiques,\alpha
   tous les caractres numriques (0,1,...,9),\digits
   tous les caractres d&#39;espace (espaces, tabs, sauts de ligne),\space
)}
 \text{result=transforme \data[1] dans la chaine en <tt>'\c'</tt>.}
#endif

#if #TARGET (batch2)
 \title{Transformer : Modif-batch II}
 \text{chars=\allchars}
 \text{c=wims(charcnt \alpha)}
 \text{c=wims(char randint(1..\c) of \alpha)}
 \text{data=randomrow(
   toutes les lettres voyelles (majuscules et minuscules),aeiouyAEIOUY
   toutes les lettres voyelles majuscules,AEIOUY
   toutes les lettres voyelles minuscules,aeiouy
   toutes les lettres consonnes (majuscules et minuscules),bcdfghjklmnpqrstvwxzBCDFGHJKLMNPQRSTVWXZ
   toutes les lettres consonnes majuscules,BCDFGHJKLMNPQRSTVWXZ
   toutes les lettres consonnes minuscules,bcdfghjklmnpqrstvwxz
   tous les caractres numriques impairs,13579
   tous les caractres numriques pairs,02468
   tous les oprateurs mathmatiques (<tt>\mathop</tt>),\mathop
)}
 \text{result=transforme \data[1] dans la chaine en <tt>'\c'</tt>.}
#endif

#if #TARGET (batchw)
 \title{Transformer : Modif-batch par mot}
 \text{chars=\allchars}
 \text{c=wims(charcnt \alpha)}
 \text{c=wims(char randint(1..\c) of \alpha)}
 \text{word=wims(exec randic randint(8..14))}
 \text{word=wims(deaccent \word)}
 \text{wordl=wims(tolower \word)}
 \text{wordu=wims(toupper \word)}
 \integer{dir=random(0,1)}
 \text{data=randrow(
   minuscules et majuscules,\wordl\wordu
   minuscules uniquement,\wordl
   majuscules uniquement,\wordu
)}
 \text{result=transforme tous les caractres dans la chaine qui
	font partie du mot <tt>\word</tt> (\data[1]) en
	<tt>'\c'</tt>.}
#endif

#if #TARGET (xletter)
 \title{Transformer : Echange de lettres}
 \text{c=wims(charcnt \alpha)}
 \text{sh=shuffle(\c)}
 \text{c1=wims(char \sh[1] of \alpha)}
 \text{c2=wims(char \sh[2] of \alpha)}
 \text{result=transforme la chaine en remplaant la lettre <tt>'\c1'</tt>
	par <tt>'\c2'</tt>, et vice versa.}
#endif

#if #TARGET (tablemod)
 \title{Transformer : Par tableau}
 \text{cc=wims(text delete \space in \chars)}
 \text{cc=wims(words2items wims(text expand \cc using 10))}
 \text{c2=item(1..10,shuffle(\cc))}
 \text{c1=wims(sort items \c2)}
 \text{tab1=wims(nospace wims(items2words \c1))}
 \text{tab2=wims(nospace wims(items2words \c2))}
 \text{C1=wims(replace internal , by </tt></td><td align=center><tt>
		in <td align=center><tt>\c1</tt></td>)}
 \text{C2=wims(replace internal , by </tt></td><td align=center><tt>
		in <td align=center><tt>\c2</tt></td>)}
 \text{result=modifie des caractres de la chaine selon le tableau suivant.
    <p><center><table border=1>
    <tr><th>Caractre de dpart\C1</tr>
    <tr><th>Transform en\C2</tr>
    </table></center>}
#endif

#if #TARGET (posmod)
 \title{Transformer : Modif. positionnelle}
 \integer{start=randint(1..10)}
 \integer{period=randint(2..8)}
 \text{str=wims(values \start+\period*x for x in 0,1,2,3,4)}
 \text{c=wims(charcnt \alpha)}
 \text{c=wims(char randint(1..\c) of \alpha)}
 \text{result=remplace les caractres en positions numro \str,... de la chaine
	par <tt>'\c'</tt>. (Rptition tous les \period caractres,  partir
	du numro \start.)}
#endif

#if #TARGET (markmod1)
 \title{Transformer : Repre I}
 \integer{markcnt=1}
 #define MARK 1
#endif
#if #TARGET (markmod2)
 \title{Transformer : Repre II}
 \integer{markcnt=randitem(2,3,-1)}
 #define MARK 1
#endif

#ifdef MARK
 \text{chars=\allchars}
 \text{c=wims(charcnt \alpha)}
 \text{c=wims(char randint(1..\c) of \alpha)}
 #include "mark.inc"
 \text{result=transforme \data[1] de la chaine en <tt>'\c'</tt>.}
#endif

\text{compare=}
\text{listsc=}
\integer{shift=randint(0..10)}
\text{ns=wims(values x for x in 0,1,2,3,4,5,
	  8,10,10+\shift,21+\shift,33+\shift,
	  42+\shift,51+\shift,72+\shift,83+\shift,100+\shift,
	  randint(150..200),randint(200..300),randint(500..800),
	  randint(\sizelim2-100..\sizelim2-1)
)}
\for{n in \ns}{
 #include "list.inc"
 \text{listsc=wims(append item "\list" to \listsc)}
#if #TARGET (upperlower)
 \text{list1=\data[2]=1?wims(toupper \list):wims(tolower \list)}
#endif
#if #TARGET (xcase)
 \text{list1=wims(translate internal \upper\lower to \lower\upper in \list)}
#endif
#if #TARGET (batch1) || #TARGET (batch2) || #TARGET (batchw)
 \text{nn=wims(charcnt \data[2])}
 \text{cc=wims(makelist \c for x=1 to \nn)}
 \text{cc=wims(text select \c in \cc)}
 \text{list1=wims(translate internal \data[2] to \cc in \list)}
#endif
#if #TARGET (xletter)
 \text{list1=wims(translate internal \c1\c2 to \c2\c1 in \list)}
#endif
#if #TARGET (tablemod)
 \text{list1=wims(translate internal \tab1 to \tab2 in \list)}
#endif
#if #TARGET (posmod)
 \text{cand=wims(text repeat \c to \n)}
 \text{mask=wims(char 1 to \period of 1000000000000000000000000000)}
 \text{header=\start>1?wims(char 1 to \start-1 of \list):}
 \text{body=wims(char \start to -1 of \list)}
 \text{list1=wims(text insert \cand into \body mask \mask)}
 \text{list1=\header\list1}
#endif
#ifdef MARK
 \text{mask=wims(text mark \data[2] in \list)}
 \text{appear=item(\markcnt,wims(positionof char 1 in \mask))}
 \text{list1=\appear notsametext ?wims(replace char number \appear by \c in \list):\list}
#endif
 \text{compare=\compare(\list1),}
}

#include "src.inc"
#include "example.inc"
#include "main.inc"

