/**
 * GraphCol.java
 *
 * Created on Jul 3, 2006
 */
package graphe;

import java.awt.Color;

/**
 * Cette interface represente un furniseur de couleurs pour un graphe <code>CompGraphe</code>.
 *
 * @author Nicolae
 */
public interface GraphCol {	
	
	/**
	 * Etablie les couleurs utilisees. Les deux vecteurs doivent
	 * avoir la meme longueur, au moins <code>2</code>. De plus,
	 * <code>vals</code> doit contenir de valeurs en ordre croissant.
	 *
	 * @param cols les couleurs.
	 * @param vals les valeurs correspondentes.
	 */
	public void setColors(Color[] cols, int[] vals);	
	
	/**
	 * Renvoie la couleur qui correspond a la valeur <code>val</code>,
	 * en format <code>0xRRGGBB</code>.
	 *
	 * @param val la valuer.
	 * @return la couleur en format <code>0xRRGGBB</code>.
	 */
	public int getCol(int val);
}
