/*
 * Copyright (C) 2002-2004, 2006-2008 by the Widelands Development Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#ifndef EDITOR_PLACE_IMMOVABLE_TOOL_H
#define EDITOR_PLACE_IMMOVABLE_TOOL_H

#include "editor/tools/editor_delete_immovable_tool.h"
#include "editor/tools/multi_select.h"

/**
 * This places immovables on the map
*/
struct Editor_Place_Immovable_Tool : public Editor_Tool, public MultiSelect {
	Editor_Place_Immovable_Tool(Editor_Delete_Immovable_Tool & tool)
		: Editor_Tool(tool, tool)
	{}

	int32_t handle_click_impl
		(Widelands::Map & map, Widelands::Node_and_Triangle<> center,
		 Editor_Interactive & parent, Editor_Action_Args & args);

	int32_t handle_undo_impl
		(Widelands::Map & map, Widelands::Node_and_Triangle<> center,
		 Editor_Interactive & parent, Editor_Action_Args & args);

	Editor_Action_Args format_args_impl(Editor_Interactive & parent);

	char const * get_sel_impl() const {
		return "pics/fsel_editor_place_immovable.png";
	}
};

#endif
