// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQSUB_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SQSUB_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_sqsub_8H[] = {
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xcd4c, 0xddde, 0xd558, 0xffff, 0xffff, 0x7fff, 0xffff,
  0xcd4b, 0xab2a, 0xb336, 0xd557, 0xfffe, 0x7ffe, 0x7ffe, 0xfffe,
  0xab29, 0x8082, 0xb335, 0xd556, 0x7ffd, 0x7ffd, 0x7ffd, 0xfff0,
  0x8081, 0x8081, 0xb334, 0x5555, 0x7ffc, 0x7ffc, 0x7fef, 0xff83,
  0x8080, 0x8080, 0x3333, 0x5554, 0x7ffb, 0x7fee, 0x7f82, 0xff82,
  0x807f, 0x007f, 0x3332, 0x5553, 0x7fed, 0x7f81, 0x7f81, 0xff81,
  0x007e, 0x007e, 0x3331, 0x5545, 0x7f80, 0x7f80, 0x7f80, 0xcccd,
  0x007d, 0x007d, 0x3323, 0x54d8, 0x7f7f, 0x7f7f, 0x4ccc, 0xaaab,
  0x007c, 0x006f, 0x32b6, 0x54d7, 0x7f7e, 0x4ccb, 0x2aaa, 0x8003,
  0x006e, 0x0002, 0x32b5, 0x54d6, 0x4cca, 0x2aa9, 0x0002, 0x8002,
  0x0001, 0x0001, 0x32b4, 0x2222, 0x2aa8, 0x0001, 0x0001, 0x8001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7fff,
  0xffff, 0xcd4c, 0xddde, 0xd558, 0xffff, 0xffff, 0x7fff, 0x7fff,
  0xcd4b, 0xab2a, 0xb336, 0xd557, 0xfffe, 0x7fff, 0x7fff, 0x5556,
  0xab29, 0x8082, 0xb335, 0xd556, 0x7fff, 0x7fff, 0x7fff, 0x3334,
  0x8081, 0x8081, 0xb334, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0080,
  0x8080, 0x8080, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x007f,
  0x807f, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x007e,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x007d,
  0x7fff, 0x55d5, 0x6667, 0x55d5, 0x7fff, 0x7fff, 0x7fff, 0x0010,
  0x55d4, 0x33b3, 0x33b3, 0x55d4, 0x7fff, 0x7fff, 0x7fff, 0x0003,
  0x33b2, 0x00ff, 0x33b2, 0x55d3, 0x7fff, 0x7fff, 0x7fff, 0x0002,
  0x00fe, 0x00fe, 0x33b1, 0x55d2, 0x7fff, 0x7fff, 0x7fff, 0x0001,
  0x00fe, 0x33b1, 0x55d2, 0x7fff, 0x7fff, 0x7fff, 0x0001, 0x0001,
  0x00fd, 0x33b0, 0x5565, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000,
  0x00fc, 0x3343, 0x5558, 0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff,
  0x008f, 0x3336, 0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0xfffe, 0xfff1,
  0x0082, 0x3335, 0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0xfff0, 0xff84,
  0x0081, 0x3334, 0x5555, 0x7ffc, 0x7ffc, 0x7fef, 0xff83, 0xff83,
  0x0080, 0x3333, 0x5554, 0x7ffb, 0x7fee, 0x7f82, 0xff82, 0xff82,
  0x007f, 0x3332, 0x5553, 0x7fed, 0x7f81, 0x7f81, 0xff81, 0xccce,
  0x007e, 0x3331, 0x5545, 0x7f80, 0x7f80, 0x7f80, 0xcccd, 0xaaac,
  0x007d, 0x3323, 0x54d8, 0x7f7f, 0x7f7f, 0x4ccc, 0xaaab, 0x8004,
  0x006f, 0x32b6, 0x54d7, 0x7f7e, 0x4ccb, 0x2aaa, 0x8003, 0x8003,
  0x0002, 0x32b5, 0x54d6, 0x4cca, 0x2aa9, 0x0002, 0x8002, 0x8002,
  0x0001, 0x32b4, 0x2222, 0x2aa8, 0x0001, 0x0001, 0x8001, 0x7fff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7fff, 0x7fff,
  0xcd4c, 0xddde, 0xd558, 0xffff, 0xffff, 0x7fff, 0x7fff, 0x5557,
  0xab2a, 0xb336, 0xd557, 0xfffe, 0x7fff, 0x7fff, 0x5556, 0x3335,
  0x8082, 0xb335, 0xd556, 0x7fff, 0x7fff, 0x7fff, 0x3334, 0x0081,
  0x8081, 0xb334, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0080, 0x0080,
  0x8080, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x007f, 0x007f,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x007e, 0x007e,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x007d, 0x0011,
  0x55d5, 0x6667, 0x55d5, 0x7fff, 0x7fff, 0x7fff, 0x0010, 0x0004,
  0x33b3, 0x33b3, 0x55d4, 0x7fff, 0x7fff, 0x7fff, 0x0003, 0x0003,
  0x00ff, 0x33b2, 0x55d3, 0x7fff, 0x7fff, 0x7fff, 0x0002, 0x0002,
  0x33b2, 0x55d3, 0x7fff, 0x7fff, 0x7fff, 0x0002, 0x0002, 0x0002,
  0x33b1, 0x55d2, 0x7fff, 0x7fff, 0x7fff, 0x0001, 0x0001, 0x0001,
  0x33b0, 0x5565, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000,
  0x3343, 0x5558, 0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff, 0xfff2,
  0x3336, 0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0xfffe, 0xfff1, 0xff85,
  0x3335, 0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0xfff0, 0xff84, 0xff84,
  0x3334, 0x5555, 0x7ffc, 0x7ffc, 0x7fef, 0xff83, 0xff83, 0xff83,
  0x3333, 0x5554, 0x7ffb, 0x7fee, 0x7f82, 0xff82, 0xff82, 0xcccf,
  0x3332, 0x5553, 0x7fed, 0x7f81, 0x7f81, 0xff81, 0xccce, 0xaaad,
  0x3331, 0x5545, 0x7f80, 0x7f80, 0x7f80, 0xcccd, 0xaaac, 0x8005,
  0x3323, 0x54d8, 0x7f7f, 0x7f7f, 0x4ccc, 0xaaab, 0x8004, 0x8004,
  0x32b6, 0x54d7, 0x7f7e, 0x4ccb, 0x2aaa, 0x8003, 0x8003, 0x8003,
  0x32b5, 0x54d6, 0x4cca, 0x2aa9, 0x0002, 0x8002, 0x8002, 0x7fff,
  0x32b4, 0x2222, 0x2aa8, 0x0001, 0x0001, 0x8001, 0x7fff, 0x7fff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7fff, 0x7fff, 0x5558,
  0xddde, 0xd558, 0xffff, 0xffff, 0x7fff, 0x7fff, 0x5557, 0x3336,
  0xb336, 0xd557, 0xfffe, 0x7fff, 0x7fff, 0x5556, 0x3335, 0x0082,
  0xb335, 0xd556, 0x7fff, 0x7fff, 0x7fff, 0x3334, 0x0081, 0x0081,
  0xb334, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0080, 0x0080, 0x0080,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x007f, 0x007f, 0x007f,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x007e, 0x007e, 0x0012,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x007d, 0x0011, 0x0005,
  0x6667, 0x55d5, 0x7fff, 0x7fff, 0x7fff, 0x0010, 0x0004, 0x0004,
  0x33b3, 0x55d4, 0x7fff, 0x7fff, 0x7fff, 0x0003, 0x0003, 0x0003,
  0x55d4, 0x7fff, 0x7fff, 0x7fff, 0x0003, 0x0003, 0x0003, 0x0010,
  0x55d3, 0x7fff, 0x7fff, 0x7fff, 0x0002, 0x0002, 0x0002, 0x000f,
  0x55d2, 0x7fff, 0x7fff, 0x7fff, 0x0001, 0x0001, 0x0001, 0x000e,
  0x5565, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5558, 0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff, 0xfff2, 0xff93,
  0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0xfffe, 0xfff1, 0xff85, 0xff92,
  0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0xfff0, 0xff84, 0xff84, 0xff91,
  0x5555, 0x7ffc, 0x7ffc, 0x7fef, 0xff83, 0xff83, 0xff83, 0xccdd,
  0x5554, 0x7ffb, 0x7fee, 0x7f82, 0xff82, 0xff82, 0xcccf, 0xaabb,
  0x5553, 0x7fed, 0x7f81, 0x7f81, 0xff81, 0xccce, 0xaaad, 0x8013,
  0x5545, 0x7f80, 0x7f80, 0x7f80, 0xcccd, 0xaaac, 0x8005, 0x8012,
  0x54d8, 0x7f7f, 0x7f7f, 0x4ccc, 0xaaab, 0x8004, 0x8004, 0x8011,
  0x54d7, 0x7f7e, 0x4ccb, 0x2aaa, 0x8003, 0x8003, 0x8003, 0x7fff,
  0x54d6, 0x4cca, 0x2aa9, 0x0002, 0x8002, 0x8002, 0x7fff, 0x7fff,
  0x2222, 0x2aa8, 0x0001, 0x0001, 0x8001, 0x7fff, 0x7fff, 0x5566,
  0x0000, 0x0000, 0x0000, 0x0000, 0x7fff, 0x7fff, 0x5558, 0x3344,
  0xd558, 0xffff, 0xffff, 0x7fff, 0x7fff, 0x5557, 0x3336, 0x0090,
  0xd557, 0xfffe, 0x7fff, 0x7fff, 0x5556, 0x3335, 0x0082, 0x008f,
  0xd556, 0x7fff, 0x7fff, 0x7fff, 0x3334, 0x0081, 0x0081, 0x008e,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0080, 0x0080, 0x0080, 0x008d,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x007f, 0x007f, 0x007f, 0x0020,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x007e, 0x007e, 0x0012, 0x0013,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x007d, 0x0011, 0x0005, 0x0012,
  0x55d5, 0x7fff, 0x7fff, 0x7fff, 0x0010, 0x0004, 0x0004, 0x0011,
  0x7fff, 0x7fff, 0x7fff, 0x0010, 0x0004, 0x0004, 0x0011, 0x007d,
  0x7fff, 0x7fff, 0x7fff, 0x0003, 0x0003, 0x0003, 0x0010, 0x007c,
  0x7fff, 0x7fff, 0x7fff, 0x0002, 0x0002, 0x0002, 0x000f, 0x007b,
  0x7fff, 0x7fff, 0x7fff, 0x0001, 0x0001, 0x0001, 0x000e, 0x006d,
  0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff, 0xfff2, 0xff93, 0xffff,
  0x7ffe, 0x7ffe, 0x7ffe, 0xfffe, 0xfff1, 0xff85, 0xff92, 0xfffe,
  0x7ffd, 0x7ffd, 0x7ffd, 0xfff0, 0xff84, 0xff84, 0xff91, 0xcd4a,
  0x7ffc, 0x7ffc, 0x7fef, 0xff83, 0xff83, 0xff83, 0xccdd, 0xab28,
  0x7ffb, 0x7fee, 0x7f82, 0xff82, 0xff82, 0xcccf, 0xaabb, 0x8080,
  0x7fed, 0x7f81, 0x7f81, 0xff81, 0xccce, 0xaaad, 0x8013, 0x807f,
  0x7f80, 0x7f80, 0x7f80, 0xcccd, 0xaaac, 0x8005, 0x8012, 0x807e,
  0x7f7f, 0x7f7f, 0x4ccc, 0xaaab, 0x8004, 0x8004, 0x8011, 0x7fff,
  0x7f7e, 0x4ccb, 0x2aaa, 0x8003, 0x8003, 0x8003, 0x7fff, 0x7fff,
  0x4cca, 0x2aa9, 0x0002, 0x8002, 0x8002, 0x7fff, 0x7fff, 0x55d3,
  0x2aa8, 0x0001, 0x0001, 0x8001, 0x7fff, 0x7fff, 0x5566, 0x33b1,
  0x0000, 0x0000, 0x0000, 0x7fff, 0x7fff, 0x5558, 0x3344, 0x00fd,
  0xffff, 0xffff, 0x7fff, 0x7fff, 0x5557, 0x3336, 0x0090, 0x00fc,
  0xfffe, 0x7fff, 0x7fff, 0x5556, 0x3335, 0x0082, 0x008f, 0x00fb,
  0x7fff, 0x7fff, 0x7fff, 0x3334, 0x0081, 0x0081, 0x008e, 0x00fa,
  0x7fff, 0x7fff, 0x7fff, 0x0080, 0x0080, 0x0080, 0x008d, 0x008d,
  0x7fff, 0x7fff, 0x7fff, 0x007f, 0x007f, 0x007f, 0x0020, 0x0080,
  0x7fff, 0x7fff, 0x7fff, 0x007e, 0x007e, 0x0012, 0x0013, 0x007f,
  0x7fff, 0x7fff, 0x7fff, 0x007d, 0x0011, 0x0005, 0x0012, 0x007e,
  0x7fff, 0x7fff, 0x007d, 0x0011, 0x0005, 0x0012, 0x007e, 0x007e,
  0x7fff, 0x7fff, 0x0010, 0x0004, 0x0004, 0x0011, 0x007d, 0x007d,
  0x7fff, 0x7fff, 0x0003, 0x0003, 0x0003, 0x0010, 0x007c, 0x007c,
  0x7fff, 0x7fff, 0x0002, 0x0002, 0x0002, 0x000f, 0x007b, 0x006e,
  0x7fff, 0x7fff, 0x0001, 0x0001, 0x0001, 0x000e, 0x006d, 0x0001,
  0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x7fff, 0xffff, 0xffff, 0xfff2, 0xff93, 0xffff, 0xffff,
  0x7ffe, 0x7ffe, 0xfffe, 0xfff1, 0xff85, 0xff92, 0xfffe, 0xcd4b,
  0x7ffd, 0x7ffd, 0xfff0, 0xff84, 0xff84, 0xff91, 0xcd4a, 0xab29,
  0x7ffc, 0x7fef, 0xff83, 0xff83, 0xff83, 0xccdd, 0xab28, 0x8081,
  0x7fee, 0x7f82, 0xff82, 0xff82, 0xcccf, 0xaabb, 0x8080, 0x8080,
  0x7f81, 0x7f81, 0xff81, 0xccce, 0xaaad, 0x8013, 0x807f, 0x807f,
  0x7f80, 0x7f80, 0xcccd, 0xaaac, 0x8005, 0x8012, 0x807e, 0x7fff,
  0x7f7f, 0x4ccc, 0xaaab, 0x8004, 0x8004, 0x8011, 0x7fff, 0x7fff,
  0x4ccb, 0x2aaa, 0x8003, 0x8003, 0x8003, 0x7fff, 0x7fff, 0x55d4,
  0x2aa9, 0x0002, 0x8002, 0x8002, 0x7fff, 0x7fff, 0x55d3, 0x33b2,
  0x0001, 0x0001, 0x8001, 0x7fff, 0x7fff, 0x5566, 0x33b1, 0x00fe,
  0x0000, 0x0000, 0x7fff, 0x7fff, 0x5558, 0x3344, 0x00fd, 0x00fd,
  0xffff, 0x7fff, 0x7fff, 0x5557, 0x3336, 0x0090, 0x00fc, 0x00fc,
  0x7fff, 0x7fff, 0x5556, 0x3335, 0x0082, 0x008f, 0x00fb, 0x00fb,
  0x7fff, 0x7fff, 0x3334, 0x0081, 0x0081, 0x008e, 0x00fa, 0x008e,
  0x7fff, 0x7fff, 0x0080, 0x0080, 0x0080, 0x008d, 0x008d, 0x0081,
  0x7fff, 0x7fff, 0x007f, 0x007f, 0x007f, 0x0020, 0x0080, 0x0080,
  0x7fff, 0x7fff, 0x007e, 0x007e, 0x0012, 0x0013, 0x007f, 0x007f,
  0x7fff, 0x007e, 0x007e, 0x0012, 0x0013, 0x007f, 0x007f, 0x007f,
  0x7fff, 0x007d, 0x0011, 0x0005, 0x0012, 0x007e, 0x007e, 0x007e,
  0x7fff, 0x0010, 0x0004, 0x0004, 0x0011, 0x007d, 0x007d, 0x007d,
  0x7fff, 0x0003, 0x0003, 0x0003, 0x0010, 0x007c, 0x007c, 0x006f,
  0x7fff, 0x0002, 0x0002, 0x0002, 0x000f, 0x007b, 0x006e, 0x0002,
  0x7fff, 0x0001, 0x0001, 0x0001, 0x000e, 0x006d, 0x0001, 0x0001,
  0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xffff, 0xffff, 0xfff2, 0xff93, 0xffff, 0xffff, 0xcd4c,
  0x7ffe, 0xfffe, 0xfff1, 0xff85, 0xff92, 0xfffe, 0xcd4b, 0xab2a,
  0x7ffd, 0xfff0, 0xff84, 0xff84, 0xff91, 0xcd4a, 0xab29, 0x8082,
  0x7fef, 0xff83, 0xff83, 0xff83, 0xccdd, 0xab28, 0x8081, 0x8081,
  0x7f82, 0xff82, 0xff82, 0xcccf, 0xaabb, 0x8080, 0x8080, 0x8080,
  0x7f81, 0xff81, 0xccce, 0xaaad, 0x8013, 0x807f, 0x807f, 0x7fff,
  0x7f80, 0xcccd, 0xaaac, 0x8005, 0x8012, 0x807e, 0x7fff, 0x7fff,
  0x4ccc, 0xaaab, 0x8004, 0x8004, 0x8011, 0x7fff, 0x7fff, 0x55d5,
  0x2aaa, 0x8003, 0x8003, 0x8003, 0x7fff, 0x7fff, 0x55d4, 0x33b3,
  0x0002, 0x8002, 0x8002, 0x7fff, 0x7fff, 0x55d3, 0x33b2, 0x00ff,
  0x0001, 0x8001, 0x7fff, 0x7fff, 0x5566, 0x33b1, 0x00fe, 0x00fe,
  0x0000, 0x7fff, 0x7fff, 0x5558, 0x3344, 0x00fd, 0x00fd, 0x00fd,
  0x7fff, 0x7fff, 0x5557, 0x3336, 0x0090, 0x00fc, 0x00fc, 0x00fc,
  0x7fff, 0x5556, 0x3335, 0x0082, 0x008f, 0x00fb, 0x00fb, 0x008f,
  0x7fff, 0x3334, 0x0081, 0x0081, 0x008e, 0x00fa, 0x008e, 0x0082,
  0x7fff, 0x0080, 0x0080, 0x0080, 0x008d, 0x008d, 0x0081, 0x0081,
  0x7fff, 0x007f, 0x007f, 0x007f, 0x0020, 0x0080, 0x0080, 0x0080,
  0x007f, 0x007f, 0x007f, 0x0020, 0x0080, 0x0080, 0x0080, 0x3333,
  0x007e, 0x007e, 0x0012, 0x0013, 0x007f, 0x007f, 0x007f, 0x3332,
  0x007d, 0x0011, 0x0005, 0x0012, 0x007e, 0x007e, 0x007e, 0x3331,
  0x0010, 0x0004, 0x0004, 0x0011, 0x007d, 0x007d, 0x007d, 0x3323,
  0x0003, 0x0003, 0x0003, 0x0010, 0x007c, 0x007c, 0x006f, 0x32b6,
  0x0002, 0x0002, 0x0002, 0x000f, 0x007b, 0x006e, 0x0002, 0x32b5,
  0x0001, 0x0001, 0x0001, 0x000e, 0x006d, 0x0001, 0x0001, 0x32b4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfff2, 0xff93, 0xffff, 0xffff, 0xcd4c, 0xddde,
  0xfffe, 0xfff1, 0xff85, 0xff92, 0xfffe, 0xcd4b, 0xab2a, 0xb336,
  0xfff0, 0xff84, 0xff84, 0xff91, 0xcd4a, 0xab29, 0x8082, 0xb335,
  0xff83, 0xff83, 0xff83, 0xccdd, 0xab28, 0x8081, 0x8081, 0xb334,
  0xff82, 0xff82, 0xcccf, 0xaabb, 0x8080, 0x8080, 0x8080, 0x7fff,
  0xff81, 0xccce, 0xaaad, 0x8013, 0x807f, 0x807f, 0x7fff, 0x7fff,
  0xcccd, 0xaaac, 0x8005, 0x8012, 0x807e, 0x7fff, 0x7fff, 0x7fff,
  0xaaab, 0x8004, 0x8004, 0x8011, 0x7fff, 0x7fff, 0x55d5, 0x6667,
  0x8003, 0x8003, 0x8003, 0x7fff, 0x7fff, 0x55d4, 0x33b3, 0x33b3,
  0x8002, 0x8002, 0x7fff, 0x7fff, 0x55d3, 0x33b2, 0x00ff, 0x33b2,
  0x8001, 0x7fff, 0x7fff, 0x5566, 0x33b1, 0x00fe, 0x00fe, 0x33b1,
  0x7fff, 0x7fff, 0x5558, 0x3344, 0x00fd, 0x00fd, 0x00fd, 0x33b0,
  0x7fff, 0x5557, 0x3336, 0x0090, 0x00fc, 0x00fc, 0x00fc, 0x3343,
  0x5556, 0x3335, 0x0082, 0x008f, 0x00fb, 0x00fb, 0x008f, 0x3336,
  0x3334, 0x0081, 0x0081, 0x008e, 0x00fa, 0x008e, 0x0082, 0x3335,
  0x0080, 0x0080, 0x0080, 0x008d, 0x008d, 0x0081, 0x0081, 0x3334,
  0x0080, 0x0080, 0x008d, 0x008d, 0x0081, 0x0081, 0x3334, 0x5555,
  0x007f, 0x007f, 0x0020, 0x0080, 0x0080, 0x0080, 0x3333, 0x5554,
  0x007e, 0x0012, 0x0013, 0x007f, 0x007f, 0x007f, 0x3332, 0x5553,
  0x0011, 0x0005, 0x0012, 0x007e, 0x007e, 0x007e, 0x3331, 0x5545,
  0x0004, 0x0004, 0x0011, 0x007d, 0x007d, 0x007d, 0x3323, 0x54d8,
  0x0003, 0x0003, 0x0010, 0x007c, 0x007c, 0x006f, 0x32b6, 0x54d7,
  0x0002, 0x0002, 0x000f, 0x007b, 0x006e, 0x0002, 0x32b5, 0x54d6,
  0x0001, 0x0001, 0x000e, 0x006d, 0x0001, 0x0001, 0x32b4, 0x2222,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfff2, 0xff93, 0xffff, 0xffff, 0xcd4c, 0xddde, 0xd558,
  0xfff1, 0xff85, 0xff92, 0xfffe, 0xcd4b, 0xab2a, 0xb336, 0xd557,
  0xff84, 0xff84, 0xff91, 0xcd4a, 0xab29, 0x8082, 0xb335, 0xd556,
  0xff83, 0xff83, 0xccdd, 0xab28, 0x8081, 0x8081, 0xb334, 0x7fff,
  0xff82, 0xcccf, 0xaabb, 0x8080, 0x8080, 0x8080, 0x7fff, 0x7fff,
  0xccce, 0xaaad, 0x8013, 0x807f, 0x807f, 0x7fff, 0x7fff, 0x7fff,
  0xaaac, 0x8005, 0x8012, 0x807e, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x8004, 0x8004, 0x8011, 0x7fff, 0x7fff, 0x55d5, 0x6667, 0x55d5,
  0x8003, 0x8003, 0x7fff, 0x7fff, 0x55d4, 0x33b3, 0x33b3, 0x55d4,
  0x8002, 0x7fff, 0x7fff, 0x55d3, 0x33b2, 0x00ff, 0x33b2, 0x55d3,
  0x7fff, 0x7fff, 0x5566, 0x33b1, 0x00fe, 0x00fe, 0x33b1, 0x55d2,
  0x7fff, 0x5558, 0x3344, 0x00fd, 0x00fd, 0x00fd, 0x33b0, 0x5565,
  0x5557, 0x3336, 0x0090, 0x00fc, 0x00fc, 0x00fc, 0x3343, 0x5558,
  0x3335, 0x0082, 0x008f, 0x00fb, 0x00fb, 0x008f, 0x3336, 0x5557,
  0x0081, 0x0081, 0x008e, 0x00fa, 0x008e, 0x0082, 0x3335, 0x5556,
  0x0081, 0x008e, 0x00fa, 0x008e, 0x0082, 0x3335, 0x5556, 0x7ffd,
  0x0080, 0x008d, 0x008d, 0x0081, 0x0081, 0x3334, 0x5555, 0x7ffc,
  0x007f, 0x0020, 0x0080, 0x0080, 0x0080, 0x3333, 0x5554, 0x7ffb,
  0x0012, 0x0013, 0x007f, 0x007f, 0x007f, 0x3332, 0x5553, 0x7fed,
  0x0005, 0x0012, 0x007e, 0x007e, 0x007e, 0x3331, 0x5545, 0x7f80,
  0x0004, 0x0011, 0x007d, 0x007d, 0x007d, 0x3323, 0x54d8, 0x7f7f,
  0x0003, 0x0010, 0x007c, 0x007c, 0x006f, 0x32b6, 0x54d7, 0x7f7e,
  0x0002, 0x000f, 0x007b, 0x006e, 0x0002, 0x32b5, 0x54d6, 0x4cca,
  0x0001, 0x000e, 0x006d, 0x0001, 0x0001, 0x32b4, 0x2222, 0x2aa8,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff2, 0xff93, 0xffff, 0xffff, 0xcd4c, 0xddde, 0xd558, 0xffff,
  0xff85, 0xff92, 0xfffe, 0xcd4b, 0xab2a, 0xb336, 0xd557, 0xfffe,
  0xff84, 0xff91, 0xcd4a, 0xab29, 0x8082, 0xb335, 0xd556, 0x7fff,
  0xff83, 0xccdd, 0xab28, 0x8081, 0x8081, 0xb334, 0x7fff, 0x7fff,
  0xcccf, 0xaabb, 0x8080, 0x8080, 0x8080, 0x7fff, 0x7fff, 0x7fff,
  0xaaad, 0x8013, 0x807f, 0x807f, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x8005, 0x8012, 0x807e, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x8004, 0x8011, 0x7fff, 0x7fff, 0x55d5, 0x6667, 0x55d5, 0x7fff,
  0x8003, 0x7fff, 0x7fff, 0x55d4, 0x33b3, 0x33b3, 0x55d4, 0x7fff,
  0x7fff, 0x7fff, 0x55d3, 0x33b2, 0x00ff, 0x33b2, 0x55d3, 0x7fff,
  0x7fff, 0x5566, 0x33b1, 0x00fe, 0x00fe, 0x33b1, 0x55d2, 0x7fff,
  0x5558, 0x3344, 0x00fd, 0x00fd, 0x00fd, 0x33b0, 0x5565, 0x7fff,
  0x3336, 0x0090, 0x00fc, 0x00fc, 0x00fc, 0x3343, 0x5558, 0x7fff,
  0x0082, 0x008f, 0x00fb, 0x00fb, 0x008f, 0x3336, 0x5557, 0x7ffe,
  0x008f, 0x00fb, 0x00fb, 0x008f, 0x3336, 0x5557, 0x7ffe, 0x7ffe,
  0x008e, 0x00fa, 0x008e, 0x0082, 0x3335, 0x5556, 0x7ffd, 0x7ffd,
  0x008d, 0x008d, 0x0081, 0x0081, 0x3334, 0x5555, 0x7ffc, 0x7ffc,
  0x0020, 0x0080, 0x0080, 0x0080, 0x3333, 0x5554, 0x7ffb, 0x7fee,
  0x0013, 0x007f, 0x007f, 0x007f, 0x3332, 0x5553, 0x7fed, 0x7f81,
  0x0012, 0x007e, 0x007e, 0x007e, 0x3331, 0x5545, 0x7f80, 0x7f80,
  0x0011, 0x007d, 0x007d, 0x007d, 0x3323, 0x54d8, 0x7f7f, 0x7f7f,
  0x0010, 0x007c, 0x007c, 0x006f, 0x32b6, 0x54d7, 0x7f7e, 0x4ccb,
  0x000f, 0x007b, 0x006e, 0x0002, 0x32b5, 0x54d6, 0x4cca, 0x2aa9,
  0x000e, 0x006d, 0x0001, 0x0001, 0x32b4, 0x2222, 0x2aa8, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff93, 0xffff, 0xffff, 0xcd4c, 0xddde, 0xd558, 0xffff, 0xffff,
  0xff92, 0xfffe, 0xcd4b, 0xab2a, 0xb336, 0xd557, 0xfffe, 0x7fff,
  0xff91, 0xcd4a, 0xab29, 0x8082, 0xb335, 0xd556, 0x7fff, 0x7fff,
  0xccdd, 0xab28, 0x8081, 0x8081, 0xb334, 0x7fff, 0x7fff, 0x7fff,
  0xaabb, 0x8080, 0x8080, 0x8080, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x8013, 0x807f, 0x807f, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x8012, 0x807e, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x8011, 0x7fff, 0x7fff, 0x55d5, 0x6667, 0x55d5, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x55d4, 0x33b3, 0x33b3, 0x55d4, 0x7fff, 0x7fff,
  0x7fff, 0x55d3, 0x33b2, 0x00ff, 0x33b2, 0x55d3, 0x7fff, 0x7fff,
  0x5566, 0x33b1, 0x00fe, 0x00fe, 0x33b1, 0x55d2, 0x7fff, 0x7fff,
  0x3344, 0x00fd, 0x00fd, 0x00fd, 0x33b0, 0x5565, 0x7fff, 0x7fff,
  0x0090, 0x00fc, 0x00fc, 0x00fc, 0x3343, 0x5558, 0x7fff, 0x7fff,
  0x00fc, 0x00fc, 0x00fc, 0x3343, 0x5558, 0x7fff, 0x7fff, 0x7fff,
  0x00fb, 0x00fb, 0x008f, 0x3336, 0x5557, 0x7ffe, 0x7ffe, 0x7ffe,
  0x00fa, 0x008e, 0x0082, 0x3335, 0x5556, 0x7ffd, 0x7ffd, 0x7ffd,
  0x008d, 0x0081, 0x0081, 0x3334, 0x5555, 0x7ffc, 0x7ffc, 0x7fef,
  0x0080, 0x0080, 0x0080, 0x3333, 0x5554, 0x7ffb, 0x7fee, 0x7f82,
  0x007f, 0x007f, 0x007f, 0x3332, 0x5553, 0x7fed, 0x7f81, 0x7f81,
  0x007e, 0x007e, 0x007e, 0x3331, 0x5545, 0x7f80, 0x7f80, 0x7f80,
  0x007d, 0x007d, 0x007d, 0x3323, 0x54d8, 0x7f7f, 0x7f7f, 0x4ccc,
  0x007c, 0x007c, 0x006f, 0x32b6, 0x54d7, 0x7f7e, 0x4ccb, 0x2aaa,
  0x007b, 0x006e, 0x0002, 0x32b5, 0x54d6, 0x4cca, 0x2aa9, 0x0002,
  0x006d, 0x0001, 0x0001, 0x32b4, 0x2222, 0x2aa8, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xcd4c, 0xddde, 0xd558, 0xffff, 0xffff, 0x7fff,
  0xfffe, 0xcd4b, 0xab2a, 0xb336, 0xd557, 0xfffe, 0x7fff, 0x7fff,
  0xcd4a, 0xab29, 0x8082, 0xb335, 0xd556, 0x7fff, 0x7fff, 0x7fff,
  0xab28, 0x8081, 0x8081, 0xb334, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x8080, 0x8080, 0x8080, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x807f, 0x807f, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x807e, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x55d5, 0x6667, 0x55d5, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x55d4, 0x33b3, 0x33b3, 0x55d4, 0x7fff, 0x7fff, 0x7fff,
  0x55d3, 0x33b2, 0x00ff, 0x33b2, 0x55d3, 0x7fff, 0x7fff, 0x7fff,
  0x33b1, 0x00fe, 0x00fe, 0x33b1, 0x55d2, 0x7fff, 0x7fff, 0x7fff,
  0x00fd, 0x00fd, 0x00fd, 0x33b0, 0x5565, 0x7fff, 0x7fff, 0x7fff,
  0x00fd, 0x00fd, 0x33b0, 0x5565, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x00fc, 0x00fc, 0x3343, 0x5558, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x00fb, 0x008f, 0x3336, 0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0x8000,
  0x008e, 0x0082, 0x3335, 0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0x8000,
  0x0081, 0x0081, 0x3334, 0x5555, 0x7ffc, 0x7ffc, 0x7fef, 0x8000,
  0x0080, 0x0080, 0x3333, 0x5554, 0x7ffb, 0x7fee, 0x7f82, 0x8000,
  0x007f, 0x007f, 0x3332, 0x5553, 0x7fed, 0x7f81, 0x7f81, 0x8000,
  0x007e, 0x007e, 0x3331, 0x5545, 0x7f80, 0x7f80, 0x7f80, 0x8000,
  0x007d, 0x007d, 0x3323, 0x54d8, 0x7f7f, 0x7f7f, 0x4ccc, 0x8000,
  0x007c, 0x006f, 0x32b6, 0x54d7, 0x7f7e, 0x4ccb, 0x2aaa, 0x8000,
  0x006e, 0x0002, 0x32b5, 0x54d6, 0x4cca, 0x2aa9, 0x0002, 0x8000,
  0x0001, 0x0001, 0x32b4, 0x2222, 0x2aa8, 0x0001, 0x0001, 0x8000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xcd4c, 0xddde, 0xd558, 0xffff, 0xffff, 0x7fff, 0xffff,
  0xcd4b, 0xab2a, 0xb336, 0xd557, 0xfffe, 0x7fff, 0x7fff, 0xd556,
  0xab29, 0x8082, 0xb335, 0xd556, 0x7fff, 0x7fff, 0x7fff, 0xb334,
  0x8081, 0x8081, 0xb334, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8080,
  0x8080, 0x8080, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x807f,
  0x807f, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x807e,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x807d,
  0x7fff, 0x55d5, 0x6667, 0x55d5, 0x7fff, 0x7fff, 0x7fff, 0x8010,
  0x55d4, 0x33b3, 0x33b3, 0x55d4, 0x7fff, 0x7fff, 0x7fff, 0x8003,
  0x33b2, 0x00ff, 0x33b2, 0x55d3, 0x7fff, 0x7fff, 0x7fff, 0x8002,
  0x00fe, 0x00fe, 0x33b1, 0x55d2, 0x7fff, 0x7fff, 0x7fff, 0x8001,
  0x00fe, 0x33b1, 0x55d2, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001,
  0x00fd, 0x33b0, 0x5565, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x00fc, 0x3343, 0x5558, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x008f, 0x3336, 0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0x8000, 0x8000,
  0x0082, 0x3335, 0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0x8000, 0x8000,
  0x0081, 0x3334, 0x5555, 0x7ffc, 0x7ffc, 0x7fef, 0x8000, 0x8000,
  0x0080, 0x3333, 0x5554, 0x7ffb, 0x7fee, 0x7f82, 0x8000, 0x8000,
  0x007f, 0x3332, 0x5553, 0x7fed, 0x7f81, 0x7f81, 0x8000, 0x8000,
  0x007e, 0x3331, 0x5545, 0x7f80, 0x7f80, 0x7f80, 0x8000, 0x8000,
  0x007d, 0x3323, 0x54d8, 0x7f7f, 0x7f7f, 0x4ccc, 0x8000, 0x8000,
  0x006f, 0x32b6, 0x54d7, 0x7f7e, 0x4ccb, 0x2aaa, 0x8000, 0x8000,
  0x0002, 0x32b5, 0x54d6, 0x4cca, 0x2aa9, 0x0002, 0x8000, 0x8000,
  0x0001, 0x32b4, 0x2222, 0x2aa8, 0x0001, 0x0001, 0x8000, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcd4c, 0xddde, 0xd558, 0xffff, 0xffff, 0x7fff, 0xffff, 0xd557,
  0xab2a, 0xb336, 0xd557, 0xfffe, 0x7fff, 0x7fff, 0xd556, 0xb335,
  0x8082, 0xb335, 0xd556, 0x7fff, 0x7fff, 0x7fff, 0xb334, 0x8081,
  0x8081, 0xb334, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8080, 0x8080,
  0x8080, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x807f, 0x807f,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x807e, 0x807e,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x807d, 0x8011,
  0x55d5, 0x6667, 0x55d5, 0x7fff, 0x7fff, 0x7fff, 0x8010, 0x8004,
  0x33b3, 0x33b3, 0x55d4, 0x7fff, 0x7fff, 0x7fff, 0x8003, 0x8003,
  0x00ff, 0x33b2, 0x55d3, 0x7fff, 0x7fff, 0x7fff, 0x8002, 0x8002,
  0x33b2, 0x55d3, 0x7fff, 0x7fff, 0x7fff, 0x8002, 0x8002, 0xaaaa,
  0x33b1, 0x55d2, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0xaaa9,
  0x33b0, 0x5565, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0xaaa8,
  0x3343, 0x5558, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0xaa9a,
  0x3336, 0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0x8000, 0x8000, 0xaa2d,
  0x3335, 0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0x8000, 0x8000, 0xaa2c,
  0x3334, 0x5555, 0x7ffc, 0x7ffc, 0x7fef, 0x8000, 0x8000, 0xaa2b,
  0x3333, 0x5554, 0x7ffb, 0x7fee, 0x7f82, 0x8000, 0x8000, 0x8000,
  0x3332, 0x5553, 0x7fed, 0x7f81, 0x7f81, 0x8000, 0x8000, 0x8000,
  0x3331, 0x5545, 0x7f80, 0x7f80, 0x7f80, 0x8000, 0x8000, 0x8000,
  0x3323, 0x54d8, 0x7f7f, 0x7f7f, 0x4ccc, 0x8000, 0x8000, 0x8000,
  0x32b6, 0x54d7, 0x7f7e, 0x4ccb, 0x2aaa, 0x8000, 0x8000, 0x8000,
  0x32b5, 0x54d6, 0x4cca, 0x2aa9, 0x0002, 0x8000, 0x8000, 0x2aaa,
  0x32b4, 0x2222, 0x2aa8, 0x0001, 0x0001, 0x8000, 0x0001, 0x2aa9,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xddde, 0xd558, 0xffff, 0xffff, 0x7fff, 0xffff, 0xd557, 0xddde,
  0xb336, 0xd557, 0xfffe, 0x7fff, 0x7fff, 0xd556, 0xb335, 0xab2a,
  0xb335, 0xd556, 0x7fff, 0x7fff, 0x7fff, 0xb334, 0x8081, 0xab29,
  0xb334, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8080, 0x8080, 0xab28,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x807f, 0x807f, 0xab27,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x807e, 0x807e, 0xaaba,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x807d, 0x8011, 0xaaad,
  0x6667, 0x55d5, 0x7fff, 0x7fff, 0x7fff, 0x8010, 0x8004, 0xaaac,
  0x33b3, 0x55d4, 0x7fff, 0x7fff, 0x7fff, 0x8003, 0x8003, 0xaaab,
  0x55d4, 0x7fff, 0x7fff, 0x7fff, 0x8003, 0x8003, 0xaaab, 0xcccc,
  0x55d3, 0x7fff, 0x7fff, 0x7fff, 0x8002, 0x8002, 0xaaaa, 0xcccb,
  0x55d2, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0xaaa9, 0xccca,
  0x5565, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0xaaa8, 0xccbc,
  0x5558, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0xaa9a, 0xcc4f,
  0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0x8000, 0x8000, 0xaa2d, 0xcc4e,
  0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0x8000, 0x8000, 0xaa2c, 0xcc4d,
  0x5555, 0x7ffc, 0x7ffc, 0x7fef, 0x8000, 0x8000, 0xaa2b, 0x9999,
  0x5554, 0x7ffb, 0x7fee, 0x7f82, 0x8000, 0x8000, 0x8000, 0x8000,
  0x5553, 0x7fed, 0x7f81, 0x7f81, 0x8000, 0x8000, 0x8000, 0x8000,
  0x5545, 0x7f80, 0x7f80, 0x7f80, 0x8000, 0x8000, 0x8000, 0x8000,
  0x54d8, 0x7f7f, 0x7f7f, 0x4ccc, 0x8000, 0x8000, 0x8000, 0x8000,
  0x54d7, 0x7f7e, 0x4ccb, 0x2aaa, 0x8000, 0x8000, 0x8000, 0x4ccc,
  0x54d6, 0x4cca, 0x2aa9, 0x0002, 0x8000, 0x8000, 0x2aaa, 0x4ccb,
  0x2222, 0x2aa8, 0x0001, 0x0001, 0x8000, 0x0001, 0x2aa9, 0x2222,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd558, 0xffff, 0xffff, 0x7fff, 0xffff, 0xd557, 0xddde, 0xcd4c,
  0xd557, 0xfffe, 0x7fff, 0x7fff, 0xd556, 0xb335, 0xab2a, 0xcd4b,
  0xd556, 0x7fff, 0x7fff, 0x7fff, 0xb334, 0x8081, 0xab29, 0xcd4a,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8080, 0x8080, 0xab28, 0xcd49,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x807f, 0x807f, 0xab27, 0xccdc,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x807e, 0x807e, 0xaaba, 0xcccf,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x807d, 0x8011, 0xaaad, 0xccce,
  0x55d5, 0x7fff, 0x7fff, 0x7fff, 0x8010, 0x8004, 0xaaac, 0xcccd,
  0x7fff, 0x7fff, 0x7fff, 0x8010, 0x8004, 0xaaac, 0xcccd, 0xff80,
  0x7fff, 0x7fff, 0x7fff, 0x8003, 0x8003, 0xaaab, 0xcccc, 0xff7f,
  0x7fff, 0x7fff, 0x7fff, 0x8002, 0x8002, 0xaaaa, 0xcccb, 0xff7e,
  0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0xaaa9, 0xccca, 0xff70,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0xaaa8, 0xccbc, 0xff03,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0xaa9a, 0xcc4f, 0xff02,
  0x7ffe, 0x7ffe, 0x7ffe, 0x8000, 0x8000, 0xaa2d, 0xcc4e, 0xff01,
  0x7ffd, 0x7ffd, 0x7ffd, 0x8000, 0x8000, 0xaa2c, 0xcc4d, 0xcc4d,
  0x7ffc, 0x7ffc, 0x7fef, 0x8000, 0x8000, 0xaa2b, 0x9999, 0xaa2b,
  0x7ffb, 0x7fee, 0x7f82, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fed, 0x7f81, 0x7f81, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7f80, 0x7f80, 0x7f80, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7f7f, 0x7f7f, 0x4ccc, 0x8000, 0x8000, 0x8000, 0x8000, 0x7f80,
  0x7f7e, 0x4ccb, 0x2aaa, 0x8000, 0x8000, 0x8000, 0x4ccc, 0x7f7f,
  0x4cca, 0x2aa9, 0x0002, 0x8000, 0x8000, 0x2aaa, 0x4ccb, 0x54d6,
  0x2aa8, 0x0001, 0x0001, 0x8000, 0x0001, 0x2aa9, 0x2222, 0x32b4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x7fff, 0xffff, 0xd557, 0xddde, 0xcd4c, 0xffff,
  0xfffe, 0x7fff, 0x7fff, 0xd556, 0xb335, 0xab2a, 0xcd4b, 0xfffe,
  0x7fff, 0x7fff, 0x7fff, 0xb334, 0x8081, 0xab29, 0xcd4a, 0xfffd,
  0x7fff, 0x7fff, 0x7fff, 0x8080, 0x8080, 0xab28, 0xcd49, 0xff90,
  0x7fff, 0x7fff, 0x7fff, 0x807f, 0x807f, 0xab27, 0xccdc, 0xff83,
  0x7fff, 0x7fff, 0x7fff, 0x807e, 0x807e, 0xaaba, 0xcccf, 0xff82,
  0x7fff, 0x7fff, 0x7fff, 0x807d, 0x8011, 0xaaad, 0xccce, 0xff81,
  0x7fff, 0x7fff, 0x807d, 0x8011, 0xaaad, 0xccce, 0xff81, 0xff81,
  0x7fff, 0x7fff, 0x8010, 0x8004, 0xaaac, 0xcccd, 0xff80, 0xff80,
  0x7fff, 0x7fff, 0x8003, 0x8003, 0xaaab, 0xcccc, 0xff7f, 0xff7f,
  0x7fff, 0x7fff, 0x8002, 0x8002, 0xaaaa, 0xcccb, 0xff7e, 0xff71,
  0x7fff, 0x7fff, 0x8001, 0x8001, 0xaaa9, 0xccca, 0xff70, 0xff04,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0xaaa8, 0xccbc, 0xff03, 0xff03,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0xaa9a, 0xcc4f, 0xff02, 0xff02,
  0x7ffe, 0x7ffe, 0x8000, 0x8000, 0xaa2d, 0xcc4e, 0xff01, 0xcc4e,
  0x7ffd, 0x7ffd, 0x8000, 0x8000, 0xaa2c, 0xcc4d, 0xcc4d, 0xaa2c,
  0x7ffc, 0x7fef, 0x8000, 0x8000, 0xaa2b, 0x9999, 0xaa2b, 0x8000,
  0x7fee, 0x7f82, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7f81, 0x7f81, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7f80, 0x7f80, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x7f81,
  0x7f7f, 0x4ccc, 0x8000, 0x8000, 0x8000, 0x8000, 0x7f80, 0x7f80,
  0x4ccb, 0x2aaa, 0x8000, 0x8000, 0x8000, 0x4ccc, 0x7f7f, 0x54d7,
  0x2aa9, 0x0002, 0x8000, 0x8000, 0x2aaa, 0x4ccb, 0x54d6, 0x32b5,
  0x0001, 0x0001, 0x8000, 0x0001, 0x2aa9, 0x2222, 0x32b4, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x7fff, 0xffff, 0xd557, 0xddde, 0xcd4c, 0xffff, 0xffff,
  0x7fff, 0x7fff, 0xd556, 0xb335, 0xab2a, 0xcd4b, 0xfffe, 0xfffe,
  0x7fff, 0x7fff, 0xb334, 0x8081, 0xab29, 0xcd4a, 0xfffd, 0xff91,
  0x7fff, 0x7fff, 0x8080, 0x8080, 0xab28, 0xcd49, 0xff90, 0xff84,
  0x7fff, 0x7fff, 0x807f, 0x807f, 0xab27, 0xccdc, 0xff83, 0xff83,
  0x7fff, 0x7fff, 0x807e, 0x807e, 0xaaba, 0xcccf, 0xff82, 0xff82,
  0x7fff, 0x807e, 0x807e, 0xaaba, 0xcccf, 0xff82, 0xff82, 0xff82,
  0x7fff, 0x807d, 0x8011, 0xaaad, 0xccce, 0xff81, 0xff81, 0xff81,
  0x7fff, 0x8010, 0x8004, 0xaaac, 0xcccd, 0xff80, 0xff80, 0xff80,
  0x7fff, 0x8003, 0x8003, 0xaaab, 0xcccc, 0xff7f, 0xff7f, 0xff72,
  0x7fff, 0x8002, 0x8002, 0xaaaa, 0xcccb, 0xff7e, 0xff71, 0xff05,
  0x7fff, 0x8001, 0x8001, 0xaaa9, 0xccca, 0xff70, 0xff04, 0xff04,
  0x7fff, 0x8000, 0x8000, 0xaaa8, 0xccbc, 0xff03, 0xff03, 0xff03,
  0x7fff, 0x8000, 0x8000, 0xaa9a, 0xcc4f, 0xff02, 0xff02, 0xcc4f,
  0x7ffe, 0x8000, 0x8000, 0xaa2d, 0xcc4e, 0xff01, 0xcc4e, 0xaa2d,
  0x7ffd, 0x8000, 0x8000, 0xaa2c, 0xcc4d, 0xcc4d, 0xaa2c, 0x8000,
  0x7fef, 0x8000, 0x8000, 0xaa2b, 0x9999, 0xaa2b, 0x8000, 0x8000,
  0x7f82, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7f81, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x7f82,
  0x7f80, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x7f81, 0x7f81,
  0x4ccc, 0x8000, 0x8000, 0x8000, 0x8000, 0x7f80, 0x7f80, 0x54d8,
  0x2aaa, 0x8000, 0x8000, 0x8000, 0x4ccc, 0x7f7f, 0x54d7, 0x32b6,
  0x0002, 0x8000, 0x8000, 0x2aaa, 0x4ccb, 0x54d6, 0x32b5, 0x0002,
  0x0001, 0x8000, 0x0001, 0x2aa9, 0x2222, 0x32b4, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xffff, 0xd557, 0xddde, 0xcd4c, 0xffff, 0xffff, 0xffff,
  0x7fff, 0xd556, 0xb335, 0xab2a, 0xcd4b, 0xfffe, 0xfffe, 0xff92,
  0x7fff, 0xb334, 0x8081, 0xab29, 0xcd4a, 0xfffd, 0xff91, 0xff85,
  0x7fff, 0x8080, 0x8080, 0xab28, 0xcd49, 0xff90, 0xff84, 0xff84,
  0x7fff, 0x807f, 0x807f, 0xab27, 0xccdc, 0xff83, 0xff83, 0xff83,
  0x807f, 0x807f, 0xab27, 0xccdc, 0xff83, 0xff83, 0xff83, 0xff83,
  0x807e, 0x807e, 0xaaba, 0xcccf, 0xff82, 0xff82, 0xff82, 0xff82,
  0x807d, 0x8011, 0xaaad, 0xccce, 0xff81, 0xff81, 0xff81, 0xff81,
  0x8010, 0x8004, 0xaaac, 0xcccd, 0xff80, 0xff80, 0xff80, 0xff73,
  0x8003, 0x8003, 0xaaab, 0xcccc, 0xff7f, 0xff7f, 0xff72, 0xff06,
  0x8002, 0x8002, 0xaaaa, 0xcccb, 0xff7e, 0xff71, 0xff05, 0xff05,
  0x8001, 0x8001, 0xaaa9, 0xccca, 0xff70, 0xff04, 0xff04, 0xff04,
  0x8000, 0x8000, 0xaaa8, 0xccbc, 0xff03, 0xff03, 0xff03, 0xcc50,
  0x8000, 0x8000, 0xaa9a, 0xcc4f, 0xff02, 0xff02, 0xcc4f, 0xaa2e,
  0x8000, 0x8000, 0xaa2d, 0xcc4e, 0xff01, 0xcc4e, 0xaa2d, 0x8000,
  0x8000, 0x8000, 0xaa2c, 0xcc4d, 0xcc4d, 0xaa2c, 0x8000, 0x8000,
  0x8000, 0x8000, 0xaa2b, 0x9999, 0xaa2b, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x7f83,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x7f82, 0x7f82,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x7f81, 0x7f81, 0x54d9,
  0x8000, 0x8000, 0x8000, 0x8000, 0x7f80, 0x7f80, 0x54d8, 0x32b7,
  0x8000, 0x8000, 0x8000, 0x4ccc, 0x7f7f, 0x54d7, 0x32b6, 0x0003,
  0x8000, 0x8000, 0x2aaa, 0x4ccb, 0x54d6, 0x32b5, 0x0002, 0x0002,
  0x8000, 0x0001, 0x2aa9, 0x2222, 0x32b4, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xd557, 0xddde, 0xcd4c, 0xffff, 0xffff, 0xffff, 0xff93,
  0xd556, 0xb335, 0xab2a, 0xcd4b, 0xfffe, 0xfffe, 0xff92, 0xff86,
  0xb334, 0x8081, 0xab29, 0xcd4a, 0xfffd, 0xff91, 0xff85, 0xff85,
  0x8080, 0x8080, 0xab28, 0xcd49, 0xff90, 0xff84, 0xff84, 0xff84,
  0x8080, 0xab28, 0xcd49, 0xff90, 0xff84, 0xff84, 0xff84, 0xfff0,
  0x807f, 0xab27, 0xccdc, 0xff83, 0xff83, 0xff83, 0xff83, 0xffef,
  0x807e, 0xaaba, 0xcccf, 0xff82, 0xff82, 0xff82, 0xff82, 0xffee,
  0x8011, 0xaaad, 0xccce, 0xff81, 0xff81, 0xff81, 0xff81, 0xffe0,
  0x8004, 0xaaac, 0xcccd, 0xff80, 0xff80, 0xff80, 0xff73, 0xff73,
  0x8003, 0xaaab, 0xcccc, 0xff7f, 0xff7f, 0xff72, 0xff06, 0xff72,
  0x8002, 0xaaaa, 0xcccb, 0xff7e, 0xff71, 0xff05, 0xff05, 0xff71,
  0x8001, 0xaaa9, 0xccca, 0xff70, 0xff04, 0xff04, 0xff04, 0xccbd,
  0x8000, 0xaaa8, 0xccbc, 0xff03, 0xff03, 0xff03, 0xcc50, 0xaa9b,
  0x8000, 0xaa9a, 0xcc4f, 0xff02, 0xff02, 0xcc4f, 0xaa2e, 0x8000,
  0x8000, 0xaa2d, 0xcc4e, 0xff01, 0xcc4e, 0xaa2d, 0x8000, 0x8000,
  0x8000, 0xaa2c, 0xcc4d, 0xcc4d, 0xaa2c, 0x8000, 0x8000, 0x8000,
  0x8000, 0xaa2b, 0x9999, 0xaa2b, 0x8000, 0x8000, 0x8000, 0x7ff0,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x7f83, 0x7fef,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x7f82, 0x7f82, 0x5546,
  0x8000, 0x8000, 0x8000, 0x8000, 0x7f81, 0x7f81, 0x54d9, 0x3324,
  0x8000, 0x8000, 0x8000, 0x7f80, 0x7f80, 0x54d8, 0x32b7, 0x0070,
  0x8000, 0x8000, 0x4ccc, 0x7f7f, 0x54d7, 0x32b6, 0x0003, 0x006f,
  0x8000, 0x2aaa, 0x4ccb, 0x54d6, 0x32b5, 0x0002, 0x0002, 0x006e,
  0x0001, 0x2aa9, 0x2222, 0x32b4, 0x0001, 0x0001, 0x0001, 0x006d,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd557, 0xddde, 0xcd4c, 0xffff, 0xffff, 0xffff, 0xff93, 0xfff3,
  0xb335, 0xab2a, 0xcd4b, 0xfffe, 0xfffe, 0xff92, 0xff86, 0xfff2,
  0x8081, 0xab29, 0xcd4a, 0xfffd, 0xff91, 0xff85, 0xff85, 0xfff1,
  0xab29, 0xcd4a, 0xfffd, 0xff91, 0xff85, 0xff85, 0xfff1, 0xfffd,
  0xab28, 0xcd49, 0xff90, 0xff84, 0xff84, 0xff84, 0xfff0, 0xfffc,
  0xab27, 0xccdc, 0xff83, 0xff83, 0xff83, 0xff83, 0xffef, 0xfffb,
  0xaaba, 0xcccf, 0xff82, 0xff82, 0xff82, 0xff82, 0xffee, 0xffed,
  0xaaad, 0xccce, 0xff81, 0xff81, 0xff81, 0xff81, 0xffe0, 0xff80,
  0xaaac, 0xcccd, 0xff80, 0xff80, 0xff80, 0xff73, 0xff73, 0xff7f,
  0xaaab, 0xcccc, 0xff7f, 0xff7f, 0xff72, 0xff06, 0xff72, 0xff7e,
  0xaaaa, 0xcccb, 0xff7e, 0xff71, 0xff05, 0xff05, 0xff71, 0xccca,
  0xaaa9, 0xccca, 0xff70, 0xff04, 0xff04, 0xff04, 0xccbd, 0xaaa8,
  0xaaa8, 0xccbc, 0xff03, 0xff03, 0xff03, 0xcc50, 0xaa9b, 0x8000,
  0xaa9a, 0xcc4f, 0xff02, 0xff02, 0xcc4f, 0xaa2e, 0x8000, 0x8000,
  0xaa2d, 0xcc4e, 0xff01, 0xcc4e, 0xaa2d, 0x8000, 0x8000, 0x8000,
  0xaa2c, 0xcc4d, 0xcc4d, 0xaa2c, 0x8000, 0x8000, 0x8000, 0x7ffd,
  0xaa2b, 0x9999, 0xaa2b, 0x8000, 0x8000, 0x8000, 0x7ff0, 0x7ffc,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x7f83, 0x7fef, 0x5553,
  0x8000, 0x8000, 0x8000, 0x8000, 0x7f82, 0x7f82, 0x5546, 0x3331,
  0x8000, 0x8000, 0x8000, 0x7f81, 0x7f81, 0x54d9, 0x3324, 0x007d,
  0x8000, 0x8000, 0x7f80, 0x7f80, 0x54d8, 0x32b7, 0x0070, 0x007c,
  0x8000, 0x4ccc, 0x7f7f, 0x54d7, 0x32b6, 0x0003, 0x006f, 0x007b,
  0x2aaa, 0x4ccb, 0x54d6, 0x32b5, 0x0002, 0x0002, 0x006e, 0x007a,
  0x2aa9, 0x2222, 0x32b4, 0x0001, 0x0001, 0x0001, 0x006d, 0x000d,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xddde, 0xcd4c, 0xffff, 0xffff, 0xffff, 0xff93, 0xfff3, 0xffff,
  0xab2a, 0xcd4b, 0xfffe, 0xfffe, 0xff92, 0xff86, 0xfff2, 0xfffe,
  0xcd4b, 0xfffe, 0xfffe, 0xff92, 0xff86, 0xfff2, 0xfffe, 0xfffe,
  0xcd4a, 0xfffd, 0xff91, 0xff85, 0xff85, 0xfff1, 0xfffd, 0xfffd,
  0xcd49, 0xff90, 0xff84, 0xff84, 0xff84, 0xfff0, 0xfffc, 0xfffc,
  0xccdc, 0xff83, 0xff83, 0xff83, 0xff83, 0xffef, 0xfffb, 0xffee,
  0xcccf, 0xff82, 0xff82, 0xff82, 0xff82, 0xffee, 0xffed, 0xff81,
  0xccce, 0xff81, 0xff81, 0xff81, 0xff81, 0xffe0, 0xff80, 0xff80,
  0xcccd, 0xff80, 0xff80, 0xff80, 0xff73, 0xff73, 0xff7f, 0xff7f,
  0xcccc, 0xff7f, 0xff7f, 0xff72, 0xff06, 0xff72, 0xff7e, 0xcccb,
  0xcccb, 0xff7e, 0xff71, 0xff05, 0xff05, 0xff71, 0xccca, 0xaaa9,
  0xccca, 0xff70, 0xff04, 0xff04, 0xff04, 0xccbd, 0xaaa8, 0x8001,
  0xccbc, 0xff03, 0xff03, 0xff03, 0xcc50, 0xaa9b, 0x8000, 0x8000,
  0xcc4f, 0xff02, 0xff02, 0xcc4f, 0xaa2e, 0x8000, 0x8000, 0x8000,
  0xcc4e, 0xff01, 0xcc4e, 0xaa2d, 0x8000, 0x8000, 0x8000, 0x7ffe,
  0xcc4d, 0xcc4d, 0xaa2c, 0x8000, 0x8000, 0x8000, 0x7ffd, 0x7ffd,
  0x9999, 0xaa2b, 0x8000, 0x8000, 0x8000, 0x7ff0, 0x7ffc, 0x5554,
  0x8000, 0x8000, 0x8000, 0x8000, 0x7f83, 0x7fef, 0x5553, 0x3332,
  0x8000, 0x8000, 0x8000, 0x7f82, 0x7f82, 0x5546, 0x3331, 0x007e,
  0x8000, 0x8000, 0x7f81, 0x7f81, 0x54d9, 0x3324, 0x007d, 0x007d,
  0x8000, 0x7f80, 0x7f80, 0x54d8, 0x32b7, 0x0070, 0x007c, 0x007c,
  0x4ccc, 0x7f7f, 0x54d7, 0x32b6, 0x0003, 0x006f, 0x007b, 0x007b,
  0x4ccb, 0x54d6, 0x32b5, 0x0002, 0x0002, 0x006e, 0x007a, 0x000e,
  0x2222, 0x32b4, 0x0001, 0x0001, 0x0001, 0x006d, 0x000d, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcd4c, 0xffff, 0xffff, 0xffff, 0xff93, 0xfff3, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xff93, 0xfff3, 0xffff, 0xffff, 0xffff,
  0xfffe, 0xfffe, 0xff92, 0xff86, 0xfff2, 0xfffe, 0xfffe, 0xfffe,
  0xfffd, 0xff91, 0xff85, 0xff85, 0xfff1, 0xfffd, 0xfffd, 0xfffd,
  0xff90, 0xff84, 0xff84, 0xff84, 0xfff0, 0xfffc, 0xfffc, 0xffef,
  0xff83, 0xff83, 0xff83, 0xff83, 0xffef, 0xfffb, 0xffee, 0xff82,
  0xff82, 0xff82, 0xff82, 0xff82, 0xffee, 0xffed, 0xff81, 0xff81,
  0xff81, 0xff81, 0xff81, 0xff81, 0xffe0, 0xff80, 0xff80, 0xff80,
  0xff80, 0xff80, 0xff80, 0xff73, 0xff73, 0xff7f, 0xff7f, 0xcccc,
  0xff7f, 0xff7f, 0xff72, 0xff06, 0xff72, 0xff7e, 0xcccb, 0xaaaa,
  0xff7e, 0xff71, 0xff05, 0xff05, 0xff71, 0xccca, 0xaaa9, 0x8002,
  0xff70, 0xff04, 0xff04, 0xff04, 0xccbd, 0xaaa8, 0x8001, 0x8001,
  0xff03, 0xff03, 0xff03, 0xcc50, 0xaa9b, 0x8000, 0x8000, 0x8000,
  0xff02, 0xff02, 0xcc4f, 0xaa2e, 0x8000, 0x8000, 0x8000, 0x7fff,
  0xff01, 0xcc4e, 0xaa2d, 0x8000, 0x8000, 0x8000, 0x7ffe, 0x7ffe,
  0xcc4d, 0xaa2c, 0x8000, 0x8000, 0x8000, 0x7ffd, 0x7ffd, 0x5555,
  0xaa2b, 0x8000, 0x8000, 0x8000, 0x7ff0, 0x7ffc, 0x5554, 0x3333,
  0x8000, 0x8000, 0x8000, 0x7f83, 0x7fef, 0x5553, 0x3332, 0x007f,
  0x8000, 0x8000, 0x7f82, 0x7f82, 0x5546, 0x3331, 0x007e, 0x007e,
  0x8000, 0x7f81, 0x7f81, 0x54d9, 0x3324, 0x007d, 0x007d, 0x007d,
  0x7f80, 0x7f80, 0x54d8, 0x32b7, 0x0070, 0x007c, 0x007c, 0x007c,
  0x7f7f, 0x54d7, 0x32b6, 0x0003, 0x006f, 0x007b, 0x007b, 0x000f,
  0x54d6, 0x32b5, 0x0002, 0x0002, 0x006e, 0x007a, 0x000e, 0x0002,
  0x32b4, 0x0001, 0x0001, 0x0001, 0x006d, 0x000d, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_sqsub_8H = 576;

#endif  // VIXL_SIM_SQSUB_8H_TRACE_AARCH64_H_
