// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SMLSL_2D_2S_S_TRACE_AARCH64_H_
#define VIXL_SIM_SMLSL_2D_2S_S_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_smlsl_2D_2S_S[] = {
  0xffffffffc1fc0000, 0xffffffffc17e0001,
  0xffffffff837a0000, 0xffffffff827d0001,
  0xffffffc084f40000, 0xffffffc003fa0001,
  0xffffffc084f40000, 0xffffffc003fa0001,
  0xffffffffc17e0000, 0xffffffffc0ff0001,
  0xffffffc0c2f80000, 0xffffffc0427c0001,
  0xffffffc0c2f80000, 0xffffffc0427c0001,
  0xffffffc0c2f78200, 0xffffffc0427b8101,
  0xffffffc1017a0000, 0xffffffc0817d0001,
  0xffffffc1017a0000, 0xffffffc0817d0001,
  0xffffffc101798200, 0xffffffc0817c8101,
  0xffffffc101788600, 0xffffffc0817b8301,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff8200, 0xffffffffffff8101,
  0xfffffffffffe8600, 0xfffffffffffe8301,
  0xffffffffffeec600, 0xffffffffffeea301,
  0xffffffffffff8200, 0xffffffffffff8101,
  0xfffffffffffe8600, 0xfffffffffffe8301,
  0xffffffffffeec600, 0xffffffffffeea301,
  0xffffffffffb14000, 0xffffffffffb0a001,
  0xffffffffffff0400, 0xffffffffffff0201,
  0xffffffffffef4400, 0xffffffffffef2201,
  0xffffffffffb1be00, 0xffffffffffb11f01,
  0xffffffffff73ba00, 0xffffffffff729d01,
  0xfffffffffff04000, 0xfffffffffff02001,
  0xffffffffffb2ba00, 0xffffffffffb21d01,
  0xffffffffff74b600, 0xffffffffff739b01,
  0xffffffffff363400, 0xffffffffff349a01,
  0xffffffffffc27a00, 0xffffffffffc1fd01,
  0xffffffffff847600, 0xffffffffff837b01,
  0xffffffffff45f400, 0xffffffffff447a01,
  0xffffffffc0476e00, 0xffffffffbfc5f701,
  0xffffffffffc1fc00, 0xffffffffffc17e01,
  0xffffffffff837a00, 0xffffffffff827d01,
  0xffffffffc084f400, 0xffffffffc003fa01,
  0xffffffff8185f000, 0xffffffff8084f801,
  0xffffffffffc17e00, 0xffffffffffc0ff01,
  0xffffffffc0c2f800, 0xffffffffc0427c01,
  0xffffffff81c3f400, 0xffffffff80c37a01,
  0xffffffff42c47200, 0xffffffff4143f901,
  0xffffffffc1017a00, 0xffffffffc0817d01,
  0xffffffff82027600, 0xffffffff81027b01,
  0xffffffff4302f400, 0xffffffff4182fa01,
  0xffffe6cc0fcfda00, 0xffffe698db1cad01,
  0xffffffffc100fc00, 0xffffffffc080fe01,
  0xffffffff82017a00, 0xffffffff81017d01,
  0xffffe6cc4ece6000, 0xffffe6991a9b3001,
  0xffffbccc4ece8a00, 0xffffbc43c5460501,
  0xffffffffc1007e00, 0xffffffffc0807f01,
  0xffffe6cc8dcd6400, 0xffffe6995a1a3201,
  0xffffbccc8dcd8e00, 0xffffbc4404c50701,
  0xffff7dcc8dcf0800, 0xffff7cc404c68401,
  0xffffe6cccccce600, 0xffffe6999999b301,
  0xffffbccccccd1000, 0xffffbc4444448801,
  0xffff7dccccce8a00, 0xffff7cc444460501,
  0xffff3ecccccf8600, 0xffff3d4444470301,
  0xffffd60000002a00, 0xffffd5aaaaaad501,
  0xffff97000001a400, 0xffff962aaaac5201,
  0xffff58000002a000, 0xffff56aaaaad5001,
  0xffff190000031e00, 0xffff172aaaadcf01,
  0xffffc10000017a00, 0xffffc08000017d01,
  0xffff820000027600, 0xffff810000027b01,
  0xffff43000002f400, 0xffff41800002fa01,
  0xffff82000002f400, 0xffff81000002fa01,
  0xffffc1000000fc00, 0xffffc0800000fe01,
  0xffff820000017a00, 0xffff810000017d01,
  0xffffc10000017a00, 0xffffc08000017d01,
  0x000000000000fc00, 0x000000000000fe01,
  0xffffc10000007e00, 0xffffc08000007f01,
  0x0000000000007e00, 0x0000000000007f01,
  0x00003f0000000000, 0x00003f8000000001,
  0x0000690000005400, 0x000069d55555aa01,
  0x00003f0000000000, 0x00003f8000000001,
  0x00007dffffff8200, 0x00007effffff8101,
  0x0000a7ffffffd600, 0x0000a95555552b01,
  0x0000c13333336e00, 0x0000c2bbbbbbf701,
  0x00003effffff8200, 0x00003f7fffff8101,
  0x000068ffffffd600, 0x000069d555552b01,
  0x0000823333336e00, 0x0000833bbbbbf701,
  0x0000823372336e00, 0x0000833bfb3bf701,
  0x00002a0000005400, 0x00002a555555aa01,
  0x000043333333ec00, 0x000043bbbbbc7601,
  0x000043337233ec00, 0x000043bbfb3c7601,
  0x00004333b1336e00, 0x000043bc3abbf701,
  0x0000193333339800, 0x000019666666cc01,
  0x0000193372339800, 0x00001966a5e6cc01,
  0x00001933b1331a00, 0x00001966e5664d01,
  0x00001933f0321e00, 0x0000196724e54f01,
  0x000000003f000000, 0x000000003f800001,
  0x000000007dff8200, 0x000000007eff8101,
  0x00000000bcfe8600, 0x00000000be7e8301,
  0x00000000fbfd0c00, 0x00000000fdfd0601,
  0x000000003eff8200, 0x000000003f7f8101,
  0x000000007dfe8600, 0x000000007efe8301,
  0x00000000bcfd0c00, 0x00000000be7d0601,
  0x00000000bd3c0c00, 0x00000000bebc8601,
  0x000000003eff0400, 0x000000003f7f0201,
  0x000000007dfd8a00, 0x000000007efd8501,
  0x000000007e3c8a00, 0x000000007f3d0501,
  0x000000007e7b0c00, 0x000000007f7c0601,
  0x000000003efe8600, 0x000000003f7e8301,
  0x000000003f3d8600, 0x000000003fbe0301,
  0x000000003f7c0800, 0x000000003ffd0401,
  0x000000003fba0c00, 0x00000000403b8601,
  0x00000000003f0000, 0x00000000003f8001,
  0x00000000007d8200, 0x00000000007e8101,
  0x0000000000bb8600, 0x0000000000bd0301,
  0x0000000000f90c00, 0x0000000000fb0601,
  0x00000000003e8200, 0x00000000003f0101,
  0x00000000007c8600, 0x00000000007d8301,
  0x0000000000ba0c00, 0x0000000000bb8601,
  0x0000000000c9cc00, 0x0000000000cb6601,
  0x00000000003e0400, 0x00000000003e8201,
  0x00000000007b8a00, 0x00000000007c8501,
  0x00000000008b4a00, 0x00000000008c6501,
  0x00000000008cc400, 0x00000000008de201,
  0x00000000003d8600, 0x00000000003e0301,
  0x00000000004d4600, 0x00000000004de301,
  0x00000000004ec000, 0x00000000004f6001,
  0x00000000004fbc00, 0x0000000000505e01,
  0x00000000000fc000, 0x00000000000fe001,
  0x0000000000113a00, 0x0000000000115d01,
  0x0000000000123600, 0x0000000000125b01,
  0x000000000012b400, 0x000000000012da01,
  0x0000000000017d00, 0x00000000017ff701,
  0x0000000000027b00, 0x00000000027ff101,
  0x000000000002fa00, 0x0000000002ffee01,
  0x000000000002fa00, 0x0000000002ffee01,
  0x000000000000fe00, 0x0000000000fffa01,
  0x0000000000017d00, 0x00000000017ff701,
  0x0000000000017d00, 0x00000000017ff701,
  0x000000000000fe00, 0x0000000000fffa01,
  0x0000000000007f00, 0x00000000007ffd01,
  0x0000000000007f00, 0x00000000007ffd01,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff0200, 0xffffffffff000601,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff8100, 0xffffffffff800301,
  0xfffffffffffe8300, 0xfffffffffe800901,
  0xffffffffffeea300, 0xffffffffee806901,
  0xffffffffffff8100, 0xffffffffff800301,
  0xfffffffffffe8300, 0xfffffffffe800901,
  0xffffffffffeea300, 0xffffffffee806901,
  0xffffffffffb0a000, 0xffffffffb001e001,
  0xffffffffffff0200, 0xffffffffff000601,
  0xffffffffffef2200, 0xffffffffef006601,
  0xffffffffffb11f00, 0xffffffffb081dd01,
  0xffffffffff729d00, 0xffffffff71835701,
  0xfffffffffff02000, 0xfffffffff0006001,
  0xffffffffffb21d00, 0xffffffffb181d701,
  0xffffffffff739b00, 0xffffffff72835101,
  0xffffffffff349a00, 0xffffffff3304ce01,
  0xffffffffffc1fd00, 0xffffffffc1817701,
  0xffffffffff837b00, 0xffffffff8282f101,
  0xffffffffff447a00, 0xffffffff43046e01,
  0xffffffffbfc5f700, 0xffffffbf46046501,
  0xffffffffffc17e00, 0xffffffffc1017a01,
  0xffffffffff827d00, 0xffffffff8182f701,
  0xffffffffc003fa00, 0xffffffbf8482ee01,
  0xffffffff8084f800, 0xffffff7f8702e801,
  0xffffffffffc0ff00, 0xffffffffc0817d01,
  0xffffffffc0427c00, 0xffffffbfc3817401,
  0xffffffff80c37a00, 0xffffff7fc6016e01,
  0xffffffff4143f900, 0xffffff3fc8016b01,
  0xffffffffc0817d00, 0xffffffc002fff701,
  0xffffffff81027b00, 0xffffff80057ff101,
  0xffffffff4182fa00, 0xffffff40077fee01,
  0xffffe698db1cad00, 0xffe6664007998701,
  0xffffffffc080fe00, 0xffffffc0027ffa01,
  0xffffffff81017d00, 0xffffff80047ff701,
  0xffffe6991a9b3000, 0xffe6668004999001,
  0xffffbc43c5460500, 0xffbbbcd55a198f01,
  0xffffffffc0807f00, 0xffffffc001fffd01,
  0xffffe6995a1a3200, 0xffe666c002199601,
  0xffffbc4404c50700, 0xffbbbd1557999501,
  0xffff7cc404c68400, 0xff7bbe9559198c01,
  0xffffe6999999b300, 0xffe6670000199901,
  0xffffbc4444448800, 0xffbbbd5555999801,
  0xffff7cc444460500, 0xff7bbed557198f01,
  0xffff3d4444470300, 0xff3bc05558198901,
  0xffffd5aaaaaad500, 0xffd55655557fff01,
  0xffff962aaaac5200, 0xff9557d556fff601,
  0xffff56aaaaad5000, 0xff55595557fff001,
  0xffff172aaaadcf00, 0xff155ad5587fed01,
  0xffffc08000017d00, 0xffc00180017ff701,
  0xffff810000027b00, 0xff800300027ff101,
  0xffff41800002fa00, 0xff40048002ffee01,
  0xffff81000002fa00, 0xff80030002ffee01,
  0xffffc0800000fe00, 0xffc0018000fffa01,
  0xffff810000017d00, 0xff800300017ff701,
  0xffffc08000017d00, 0xffc00180017ff701,
  0x000000000000fe00, 0x0000000000fffa01,
  0xffffc08000007f00, 0xffc00180007ffd01,
  0x0000000000007f00, 0x00000000007ffd01,
  0x00003f8000000000, 0x003ffe8000000001,
  0x000069d55555aa00, 0x006aa82aaafffe01,
  0x00003f8000000000, 0x003ffe8000000001,
  0x00007effffff8100, 0x007ffcffff800301,
  0x0000a95555552b00, 0x00aaa6aaaa800101,
  0x0000c2bbbbbbf700, 0x00c43faaaae66501,
  0x00003f7fffff8100, 0x003ffe7fff800301,
  0x000069d555552b00, 0x006aa82aaa800101,
  0x0000833bbbbbf700, 0x0084412aaae66501,
  0x0000833bfb3bf700, 0x0084416aa9666501,
  0x00002a555555aa00, 0x002aa9aaaafffe01,
  0x000043bbbbbc7600, 0x004442aaab666201,
  0x000043bbfb3c7600, 0x004442eaa9e66201,
  0x000043bc3abbf700, 0x0044432aa7e66501,
  0x000019666666cc00, 0x0019990000666401,
  0x00001966a5e6cc00, 0x0019993ffee66401,
  0x00001966e5664d00, 0x0019997ffce66701,
  0x0000196724e54f00, 0x001999bffa666d01,
  0x000000003f800000, 0x0000003ffe800001,
  0x000000007eff8100, 0x0000007ffc800301,
  0x00000000be7e8300, 0x000000bffa000901,
  0x00000000fdfd0600, 0x000000fff7001201,
  0x000000003f7f8100, 0x0000003ffe000301,
  0x000000007efe8300, 0x0000007ffb800901,
  0x00000000be7d0600, 0x000000bff8801201,
  0x00000000bebc8600, 0x000000c0387e9201,
  0x000000003f7f0200, 0x0000003ffd800601,
  0x000000007efd8500, 0x0000007ffa800f01,
  0x000000007f3d0500, 0x000000803a7e8f01,
  0x000000007f7c0600, 0x0000008079fd1201,
  0x000000003f7e8300, 0x0000003ffd000901,
  0x000000003fbe0300, 0x000000403cfe8901,
  0x000000003ffd0400, 0x000000407c7d0c01,
  0x00000000403b8600, 0x00000040bb7b9201,
  0x00000000003f8000, 0x000000003ffe8001,
  0x00000000007e8100, 0x000000007f7d0301,
  0x0000000000bd0300, 0x00000000be7b8901,
  0x0000000000fb0600, 0x00000000fcfa1201,
  0x00000000003f0100, 0x000000003f7e8301,
  0x00000000007d8300, 0x000000007e7d0901,
  0x0000000000bb8600, 0x00000000bcfb9201,
  0x0000000000cb6600, 0x00000000ccfb3201,
  0x00000000003e8200, 0x000000003efe8601,
  0x00000000007c8500, 0x000000007d7d0f01,
  0x00000000008c6500, 0x000000008d7caf01,
  0x00000000008de200, 0x000000008efca601,
  0x00000000003e0300, 0x000000003e7e8901,
  0x00000000004de300, 0x000000004e7e2901,
  0x00000000004f6000, 0x000000004ffe2001,
  0x0000000000505e00, 0x0000000050fe1a01,
  0x00000000000fe000, 0x000000000fffa001,
  0x0000000000115d00, 0x00000000117f9701,
  0x0000000000125b00, 0x00000000127f9101,
  0x000000000012da00, 0x0000000012ff8e01,
  0x00000000017ff700, 0x0000000000000001,
  0x00000000027ff100, 0x0000000000000001,
  0x0000000002ffee00, 0x0000000000000001,
  0x0000000002ffee00, 0x0000000000000001,
  0x0000000000fffa00, 0x0000000000000001,
  0x00000000017ff700, 0x0000000000000001,
  0x00000000017ff700, 0x0000000000000001,
  0x0000000000fffa00, 0x0000000000000001,
  0x00000000007ffd00, 0x0000000000000001,
  0x00000000007ffd00, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffff000600, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffff800300, 0x0000000000000001,
  0xfffffffffe800900, 0x0000000000000001,
  0xffffffffee806900, 0x0000000000000001,
  0xffffffffff800300, 0x0000000000000001,
  0xfffffffffe800900, 0x0000000000000001,
  0xffffffffee806900, 0x0000000000000001,
  0xffffffffb001e000, 0x0000000000000001,
  0xffffffffff000600, 0x0000000000000001,
  0xffffffffef006600, 0x0000000000000001,
  0xffffffffb081dd00, 0x0000000000000001,
  0xffffffff71835700, 0x0000000000000001,
  0xfffffffff0006000, 0x0000000000000001,
  0xffffffffb181d700, 0x0000000000000001,
  0xffffffff72835100, 0x0000000000000001,
  0xffffffff3304ce00, 0x0000000000000001,
  0xffffffffc1817700, 0x0000000000000001,
  0xffffffff8282f100, 0x0000000000000001,
  0xffffffff43046e00, 0x0000000000000001,
  0xffffffbf46046500, 0x0000000000000001,
  0xffffffffc1017a00, 0x0000000000000001,
  0xffffffff8182f700, 0x0000000000000001,
  0xffffffbf8482ee00, 0x0000000000000001,
  0xffffff7f8702e800, 0x0000000000000001,
  0xffffffffc0817d00, 0x0000000000000001,
  0xffffffbfc3817400, 0x0000000000000001,
  0xffffff7fc6016e00, 0x0000000000000001,
  0xffffff3fc8016b00, 0x0000000000000001,
  0xffffffc002fff700, 0x0000000000000001,
  0xffffff80057ff100, 0x0000000000000001,
  0xffffff40077fee00, 0x0000000000000001,
  0xffe6664007998700, 0x0000000000000001,
  0xffffffc0027ffa00, 0x0000000000000001,
  0xffffff80047ff700, 0x0000000000000001,
  0xffe6668004999000, 0x0000000000000001,
  0xffbbbcd55a198f00, 0x0000000000000001,
  0xffffffc001fffd00, 0x0000000000000001,
  0xffe666c002199600, 0x0000000000000001,
  0xffbbbd1557999500, 0x0000000000000001,
  0xff7bbe9559198c00, 0x0000000000000001,
  0xffe6670000199900, 0x0000000000000001,
  0xffbbbd5555999800, 0x0000000000000001,
  0xff7bbed557198f00, 0x0000000000000001,
  0xff3bc05558198900, 0x0000000000000001,
  0xffd55655557fff00, 0x0000000000000001,
  0xff9557d556fff600, 0x0000000000000001,
  0xff55595557fff000, 0x0000000000000001,
  0xff155ad5587fed00, 0x0000000000000001,
  0xffc00180017ff700, 0x0000000000000001,
  0xff800300027ff100, 0x0000000000000001,
  0xff40048002ffee00, 0x0000000000000001,
  0xff80030002ffee00, 0x0000000000000001,
  0xffc0018000fffa00, 0x0000000000000001,
  0xff800300017ff700, 0x0000000000000001,
  0xffc00180017ff700, 0x0000000000000001,
  0x0000000000fffa00, 0x0000000000000001,
  0xffc00180007ffd00, 0x0000000000000001,
  0x00000000007ffd00, 0x0000000000000001,
  0x003ffe8000000000, 0x0000000000000001,
  0x006aa82aaafffe00, 0x0000000000000001,
  0x003ffe8000000000, 0x0000000000000001,
  0x007ffcffff800300, 0x0000000000000001,
  0x00aaa6aaaa800100, 0x0000000000000001,
  0x00c43faaaae66500, 0x0000000000000001,
  0x003ffe7fff800300, 0x0000000000000001,
  0x006aa82aaa800100, 0x0000000000000001,
  0x0084412aaae66500, 0x0000000000000001,
  0x0084416aa9666500, 0x0000000000000001,
  0x002aa9aaaafffe00, 0x0000000000000001,
  0x004442aaab666200, 0x0000000000000001,
  0x004442eaa9e66200, 0x0000000000000001,
  0x0044432aa7e66500, 0x0000000000000001,
  0x0019990000666400, 0x0000000000000001,
  0x0019993ffee66400, 0x0000000000000001,
  0x0019997ffce66700, 0x0000000000000001,
  0x001999bffa666d00, 0x0000000000000001,
  0x0000003ffe800000, 0x0000000000000001,
  0x0000007ffc800300, 0x0000000000000001,
  0x000000bffa000900, 0x0000000000000001,
  0x000000fff7001200, 0x0000000000000001,
  0x0000003ffe000300, 0x0000000000000001,
  0x0000007ffb800900, 0x0000000000000001,
  0x000000bff8801200, 0x0000000000000001,
  0x000000c0387e9200, 0x0000000000000001,
  0x0000003ffd800600, 0x0000000000000001,
  0x0000007ffa800f00, 0x0000000000000001,
  0x000000803a7e8f00, 0x0000000000000001,
  0x0000008079fd1200, 0x0000000000000001,
  0x0000003ffd000900, 0x0000000000000001,
  0x000000403cfe8900, 0x0000000000000001,
  0x000000407c7d0c00, 0x0000000000000001,
  0x00000040bb7b9200, 0x0000000000000001,
  0x000000003ffe8000, 0x0000000000000001,
  0x000000007f7d0300, 0x0000000000000001,
  0x00000000be7b8900, 0x0000000000000001,
  0x00000000fcfa1200, 0x0000000000000001,
  0x000000003f7e8300, 0x0000000000000001,
  0x000000007e7d0900, 0x0000000000000001,
  0x00000000bcfb9200, 0x0000000000000001,
  0x00000000ccfb3200, 0x0000000000000001,
  0x000000003efe8600, 0x0000000000000001,
  0x000000007d7d0f00, 0x0000000000000001,
  0x000000008d7caf00, 0x0000000000000001,
  0x000000008efca600, 0x0000000000000001,
  0x000000003e7e8900, 0x0000000000000001,
  0x000000004e7e2900, 0x0000000000000001,
  0x000000004ffe2000, 0x0000000000000001,
  0x0000000050fe1a00, 0x0000000000000001,
  0x000000000fffa000, 0x0000000000000001,
  0x00000000117f9700, 0x0000000000000001,
  0x00000000127f9100, 0x0000000000000001,
  0x0000000012ff8e00, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000006,
  0x0000000000000000, 0x0000000000000007,
  0x0000000000000000, 0x0000000000000007,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffffe,
  0x0000000000000000, 0xffffffffffffffde,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffffe,
  0x0000000000000000, 0xffffffffffffffde,
  0x0000000000000000, 0xffffffffffffff61,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xffffffffffffffdf,
  0x0000000000000000, 0xffffffffffffff62,
  0x0000000000000000, 0xfffffffffffffee4,
  0x0000000000000000, 0xffffffffffffffe1,
  0x0000000000000000, 0xffffffffffffff64,
  0x0000000000000000, 0xfffffffffffffee6,
  0x0000000000000000, 0xfffffffffffffe67,
  0x0000000000000000, 0xffffffffffffff84,
  0x0000000000000000, 0xffffffffffffff06,
  0x0000000000000000, 0xfffffffffffffe87,
  0x0000000000000000, 0xffffffffffff7e8a,
  0x0000000000000000, 0xffffffffffffff83,
  0x0000000000000000, 0xffffffffffffff04,
  0x0000000000000000, 0xffffffffffff7f07,
  0x0000000000000000, 0xfffffffffffeff09,
  0x0000000000000000, 0xffffffffffffff82,
  0x0000000000000000, 0xffffffffffff7f85,
  0x0000000000000000, 0xfffffffffffeff87,
  0x0000000000000000, 0xfffffffffffe7f88,
  0x0000000000000000, 0xffffffffffff8004,
  0x0000000000000000, 0xffffffffffff0006,
  0x0000000000000000, 0xfffffffffffe8007,
  0x0000000000000000, 0xffffffffcccb4cd4,
  0x0000000000000000, 0xffffffffffff8003,
  0x0000000000000000, 0xffffffffffff0004,
  0x0000000000000000, 0xffffffffcccbccd1,
  0x0000000000000000, 0xffffffff7776777c,
  0x0000000000000000, 0xffffffffffff8002,
  0x0000000000000000, 0xffffffffcccc4ccf,
  0x0000000000000000, 0xffffffff7776f77a,
  0x0000000000000000, 0xfffffffef776f77d,
  0x0000000000000000, 0xffffffffccccccce,
  0x0000000000000000, 0xffffffff77777779,
  0x0000000000000000, 0xfffffffef777777c,
  0x0000000000000000, 0xfffffffe7777777e,
  0x0000000000000000, 0xffffffffaaaaaaac,
  0x0000000000000000, 0xffffffff2aaaaaaf,
  0x0000000000000000, 0xfffffffeaaaaaab1,
  0x0000000000000000, 0xfffffffe2aaaaab2,
  0x0000000000000000, 0xffffffff80000004,
  0x0000000000000000, 0xffffffff00000006,
  0x0000000000000000, 0xfffffffe80000007,
  0x0000000000000000, 0xffffffff00000007,
  0x0000000000000000, 0xffffffff80000003,
  0x0000000000000000, 0xffffffff00000004,
  0x0000000000000000, 0xffffffff80000004,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000000, 0xffffffff80000002,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000080000001,
  0x0000000000000000, 0x00000000d5555557,
  0x0000000000000000, 0x0000000080000001,
  0x0000000000000000, 0x0000000100000000,
  0x0000000000000000, 0x0000000155555556,
  0x0000000000000000, 0x000000018888888a,
  0x0000000000000000, 0x0000000080000000,
  0x0000000000000000, 0x00000000d5555556,
  0x0000000000000000, 0x000000010888888a,
  0x0000000000000000, 0x000000010889088a,
  0x0000000000000000, 0x0000000055555557,
  0x0000000000000000, 0x000000008888888b,
  0x0000000000000000, 0x000000008889088b,
  0x0000000000000000, 0x000000008889888a,
  0x0000000000000000, 0x0000000033333335,
  0x0000000000000000, 0x000000003333b335,
  0x0000000000000000, 0x0000000033343334,
  0x0000000000000000, 0x000000003334b332,
  0x0000000000000000, 0x0000000000008001,
  0x0000000000000000, 0x0000000000010000,
  0x0000000000000000, 0x0000000000017ffe,
  0x0000000000000000, 0x000000000001fffb,
  0x0000000000000000, 0x0000000000008000,
  0x0000000000000000, 0x000000000000fffe,
  0x0000000000000000, 0x0000000000017ffb,
  0x0000000000000000, 0x000000000001807b,
  0x0000000000000000, 0x0000000000007fff,
  0x0000000000000000, 0x000000000000fffc,
  0x0000000000000000, 0x000000000001007c,
  0x0000000000000000, 0x00000000000100fb,
  0x0000000000000000, 0x0000000000007ffe,
  0x0000000000000000, 0x000000000000807e,
  0x0000000000000000, 0x00000000000080fd,
  0x0000000000000000, 0x000000000000817b,
  0x0000000000000000, 0x0000000000000081,
  0x0000000000000000, 0x0000000000000100,
  0x0000000000000000, 0x000000000000017e,
  0x0000000000000000, 0x00000000000001fb,
  0x0000000000000000, 0x0000000000000080,
  0x0000000000000000, 0x00000000000000fe,
  0x0000000000000000, 0x000000000000017b,
  0x0000000000000000, 0x000000000000019b,
  0x0000000000000000, 0x000000000000007f,
  0x0000000000000000, 0x00000000000000fc,
  0x0000000000000000, 0x000000000000011c,
  0x0000000000000000, 0x000000000000011f,
  0x0000000000000000, 0x000000000000007e,
  0x0000000000000000, 0x000000000000009e,
  0x0000000000000000, 0x00000000000000a1,
  0x0000000000000000, 0x00000000000000a3,
  0x0000000000000000, 0x0000000000000021,
  0x0000000000000000, 0x0000000000000024,
  0x0000000000000000, 0x0000000000000026,
  0x0000000000000000, 0x0000000000000027,
  0x0000000000000003, 0x0000000000000007,
  0x0000000000000005, 0x000000000000000b,
  0x0000000000000006, 0x000000000000000d,
  0x0000000000000006, 0x000000000000000d,
  0x0000000000000002, 0x0000000000000005,
  0x0000000000000003, 0x0000000000000007,
  0x0000000000000003, 0x0000000000000007,
  0x0000000000000002, 0x0000000000000005,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffffe, 0xfffffffffffffffd,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffd, 0xfffffffffffffffb,
  0xffffffffffffffdd, 0xffffffffffffffbb,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffd, 0xfffffffffffffffb,
  0xffffffffffffffdd, 0xffffffffffffffbb,
  0xffffffffffffff60, 0xfffffffffffffec1,
  0xfffffffffffffffe, 0xfffffffffffffffd,
  0xffffffffffffffde, 0xffffffffffffffbd,
  0xffffffffffffff61, 0xfffffffffffffec3,
  0xfffffffffffffee3, 0xfffffffffffffdc7,
  0xffffffffffffffe0, 0xffffffffffffffc1,
  0xffffffffffffff63, 0xfffffffffffffec7,
  0xfffffffffffffee5, 0xfffffffffffffdcb,
  0xfffffffffffffe66, 0xfffffffffffffccd,
  0xffffffffffffff83, 0xffffffffffffff07,
  0xffffffffffffff05, 0xfffffffffffffe0b,
  0xfffffffffffffe86, 0xfffffffffffffd0d,
  0xffffffffffff7e89, 0xfffffffffffefd13,
  0xffffffffffffff82, 0xffffffffffffff05,
  0xffffffffffffff03, 0xfffffffffffffe07,
  0xffffffffffff7f06, 0xfffffffffffefe0d,
  0xfffffffffffeff08, 0xfffffffffffdfe11,
  0xffffffffffffff81, 0xffffffffffffff03,
  0xffffffffffff7f84, 0xfffffffffffeff09,
  0xfffffffffffeff86, 0xfffffffffffdff0d,
  0xfffffffffffe7f87, 0xfffffffffffcff0f,
  0xffffffffffff8003, 0xffffffffffff0007,
  0xffffffffffff0005, 0xfffffffffffe000b,
  0xfffffffffffe8006, 0xfffffffffffd000d,
  0xffffffffcccb4cd3, 0xffffffff999699a7,
  0xffffffffffff8002, 0xffffffffffff0005,
  0xffffffffffff0003, 0xfffffffffffe0007,
  0xffffffffcccbccd0, 0xffffffff999799a1,
  0xffffffff7776777b, 0xfffffffeeeeceef7,
  0xffffffffffff8001, 0xffffffffffff0003,
  0xffffffffcccc4cce, 0xffffffff9998999d,
  0xffffffff7776f779, 0xfffffffeeeedeef3,
  0xfffffffef776f77c, 0xfffffffdeeedeef9,
  0xffffffffcccccccd, 0xffffffff9999999b,
  0xffffffff77777778, 0xfffffffeeeeeeef1,
  0xfffffffef777777b, 0xfffffffdeeeeeef7,
  0xfffffffe7777777d, 0xfffffffceeeeeefb,
  0xffffffffaaaaaaab, 0xffffffff55555557,
  0xffffffff2aaaaaae, 0xfffffffe5555555d,
  0xfffffffeaaaaaab0, 0xfffffffd55555561,
  0xfffffffe2aaaaab1, 0xfffffffc55555563,
  0xffffffff80000003, 0xffffffff00000007,
  0xffffffff00000005, 0xfffffffe0000000b,
  0xfffffffe80000006, 0xfffffffd0000000d,
  0xffffffff00000006, 0xfffffffe0000000d,
  0xffffffff80000002, 0xffffffff00000005,
  0xffffffff00000003, 0xfffffffe00000007,
  0xffffffff80000003, 0xffffffff00000007,
  0x0000000000000002, 0x0000000000000005,
  0xffffffff80000001, 0xffffffff00000003,
  0x0000000000000001, 0x0000000000000003,
  0x0000000080000000, 0x0000000100000001,
  0x00000000d5555556, 0x00000001aaaaaaad,
  0x0000000080000000, 0x0000000100000001,
  0x00000000ffffffff, 0x00000001ffffffff,
  0x0000000155555555, 0x00000002aaaaaaab,
  0x0000000188888889, 0x0000000311111113,
  0x000000007fffffff, 0x00000000ffffffff,
  0x00000000d5555555, 0x00000001aaaaaaab,
  0x0000000108888889, 0x0000000211111113,
  0x0000000108890889, 0x0000000211121113,
  0x0000000055555556, 0x00000000aaaaaaad,
  0x000000008888888a, 0x0000000111111115,
  0x000000008889088a, 0x0000000111121115,
  0x0000000088898889, 0x0000000111131113,
  0x0000000033333334, 0x0000000066666669,
  0x000000003333b334, 0x0000000066676669,
  0x0000000033343333, 0x0000000066686667,
  0x000000003334b331, 0x0000000066696663,
  0x0000000000008000, 0x0000000000010001,
  0x000000000000ffff, 0x000000000001ffff,
  0x0000000000017ffd, 0x000000000002fffb,
  0x000000000001fffa, 0x000000000003fff5,
  0x0000000000007fff, 0x000000000000ffff,
  0x000000000000fffd, 0x000000000001fffb,
  0x0000000000017ffa, 0x000000000002fff5,
  0x000000000001807a, 0x00000000000300f5,
  0x0000000000007ffe, 0x000000000000fffd,
  0x000000000000fffb, 0x000000000001fff7,
  0x000000000001007b, 0x00000000000200f7,
  0x00000000000100fa, 0x00000000000201f5,
  0x0000000000007ffd, 0x000000000000fffb,
  0x000000000000807d, 0x00000000000100fb,
  0x00000000000080fc, 0x00000000000101f9,
  0x000000000000817a, 0x00000000000102f5,
  0x0000000000000080, 0x0000000000000101,
  0x00000000000000ff, 0x00000000000001ff,
  0x000000000000017d, 0x00000000000002fb,
  0x00000000000001fa, 0x00000000000003f5,
  0x000000000000007f, 0x00000000000000ff,
  0x00000000000000fd, 0x00000000000001fb,
  0x000000000000017a, 0x00000000000002f5,
  0x000000000000019a, 0x0000000000000335,
  0x000000000000007e, 0x00000000000000fd,
  0x00000000000000fb, 0x00000000000001f7,
  0x000000000000011b, 0x0000000000000237,
  0x000000000000011e, 0x000000000000023d,
  0x000000000000007d, 0x00000000000000fb,
  0x000000000000009d, 0x000000000000013b,
  0x00000000000000a0, 0x0000000000000141,
  0x00000000000000a2, 0x0000000000000145,
  0x0000000000000020, 0x0000000000000041,
  0x0000000000000023, 0x0000000000000047,
  0x0000000000000025, 0x000000000000004b,
  0x0000000000000026, 0x000000000000004d,
  0x0000000000000006, 0x0000000000000061,
  0x000000000000000a, 0x00000000000000a1,
  0x000000000000000c, 0x00000000000000c1,
  0x000000000000000c, 0x00000000000000c1,
  0x0000000000000004, 0x0000000000000041,
  0x0000000000000006, 0x0000000000000061,
  0x0000000000000006, 0x0000000000000061,
  0x0000000000000004, 0x0000000000000041,
  0x0000000000000002, 0x0000000000000021,
  0x0000000000000002, 0x0000000000000021,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffffc, 0xffffffffffffffc1,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffffe, 0xffffffffffffffe1,
  0xfffffffffffffffa, 0xffffffffffffffa1,
  0xffffffffffffffba, 0xfffffffffffffba1,
  0xfffffffffffffffe, 0xffffffffffffffe1,
  0xfffffffffffffffa, 0xffffffffffffffa1,
  0xffffffffffffffba, 0xfffffffffffffba1,
  0xfffffffffffffec0, 0xffffffffffffec01,
  0xfffffffffffffffc, 0xffffffffffffffc1,
  0xffffffffffffffbc, 0xfffffffffffffbc1,
  0xfffffffffffffec2, 0xffffffffffffec21,
  0xfffffffffffffdc6, 0xffffffffffffdc61,
  0xffffffffffffffc0, 0xfffffffffffffc01,
  0xfffffffffffffec6, 0xffffffffffffec61,
  0xfffffffffffffdca, 0xffffffffffffdca1,
  0xfffffffffffffccc, 0xffffffffffffccc1,
  0xffffffffffffff06, 0xfffffffffffff061,
  0xfffffffffffffe0a, 0xffffffffffffe0a1,
  0xfffffffffffffd0c, 0xffffffffffffd0c1,
  0xfffffffffffefd12, 0xffffffffffefd121,
  0xffffffffffffff04, 0xfffffffffffff041,
  0xfffffffffffffe06, 0xffffffffffffe061,
  0xfffffffffffefe0c, 0xffffffffffefe0c1,
  0xfffffffffffdfe10, 0xffffffffffdfe101,
  0xffffffffffffff02, 0xfffffffffffff021,
  0xfffffffffffeff08, 0xffffffffffeff081,
  0xfffffffffffdff0c, 0xffffffffffdff0c1,
  0xfffffffffffcff0e, 0xffffffffffcff0e1,
  0xffffffffffff0006, 0xfffffffffff00061,
  0xfffffffffffe000a, 0xffffffffffe000a1,
  0xfffffffffffd000c, 0xffffffffffd000c1,
  0xffffffff999699a6, 0xfffffff999699a61,
  0xffffffffffff0004, 0xfffffffffff00041,
  0xfffffffffffe0006, 0xffffffffffe00061,
  0xffffffff999799a0, 0xfffffff999799a01,
  0xfffffffeeeeceef6, 0xffffffeeeeceef61,
  0xffffffffffff0002, 0xfffffffffff00021,
  0xffffffff9998999c, 0xfffffff9998999c1,
  0xfffffffeeeedeef2, 0xffffffeeeedeef21,
  0xfffffffdeeedeef8, 0xffffffdeeedeef81,
  0xffffffff9999999a, 0xfffffff9999999a1,
  0xfffffffeeeeeeef0, 0xffffffeeeeeeef01,
  0xfffffffdeeeeeef6, 0xffffffdeeeeeef61,
  0xfffffffceeeeeefa, 0xffffffceeeeeefa1,
  0xffffffff55555556, 0xfffffff555555561,
  0xfffffffe5555555c, 0xffffffe5555555c1,
  0xfffffffd55555560, 0xffffffd555555601,
  0xfffffffc55555562, 0xffffffc555555621,
  0xffffffff00000006, 0xfffffff000000061,
  0xfffffffe0000000a, 0xffffffe0000000a1,
  0xfffffffd0000000c, 0xffffffd0000000c1,
  0xfffffffe0000000c, 0xffffffe0000000c1,
  0xffffffff00000004, 0xfffffff000000041,
  0xfffffffe00000006, 0xffffffe000000061,
  0xffffffff00000006, 0xfffffff000000061,
  0x0000000000000004, 0x0000000000000041,
  0xffffffff00000002, 0xfffffff000000021,
  0x0000000000000002, 0x0000000000000021,
  0x0000000100000000, 0x0000001000000001,
  0x00000001aaaaaaac, 0x0000001aaaaaaac1,
  0x0000000100000000, 0x0000001000000001,
  0x00000001fffffffe, 0x0000001fffffffe1,
  0x00000002aaaaaaaa, 0x0000002aaaaaaaa1,
  0x0000000311111112, 0x0000003111111121,
  0x00000000fffffffe, 0x0000000fffffffe1,
  0x00000001aaaaaaaa, 0x0000001aaaaaaaa1,
  0x0000000211111112, 0x0000002111111121,
  0x0000000211121112, 0x0000002111211121,
  0x00000000aaaaaaac, 0x0000000aaaaaaac1,
  0x0000000111111114, 0x0000001111111141,
  0x0000000111121114, 0x0000001111211141,
  0x0000000111131112, 0x0000001111311121,
  0x0000000066666668, 0x0000000666666681,
  0x0000000066676668, 0x0000000666766681,
  0x0000000066686666, 0x0000000666866661,
  0x0000000066696662, 0x0000000666966621,
  0x0000000000010000, 0x0000000000100001,
  0x000000000001fffe, 0x00000000001fffe1,
  0x000000000002fffa, 0x00000000002fffa1,
  0x000000000003fff4, 0x00000000003fff41,
  0x000000000000fffe, 0x00000000000fffe1,
  0x000000000001fffa, 0x00000000001fffa1,
  0x000000000002fff4, 0x00000000002fff41,
  0x00000000000300f4, 0x0000000000300f41,
  0x000000000000fffc, 0x00000000000fffc1,
  0x000000000001fff6, 0x00000000001fff61,
  0x00000000000200f6, 0x0000000000200f61,
  0x00000000000201f4, 0x0000000000201f41,
  0x000000000000fffa, 0x00000000000fffa1,
  0x00000000000100fa, 0x0000000000100fa1,
  0x00000000000101f8, 0x0000000000101f81,
  0x00000000000102f4, 0x0000000000102f41,
  0x0000000000000100, 0x0000000000001001,
  0x00000000000001fe, 0x0000000000001fe1,
  0x00000000000002fa, 0x0000000000002fa1,
  0x00000000000003f4, 0x0000000000003f41,
  0x00000000000000fe, 0x0000000000000fe1,
  0x00000000000001fa, 0x0000000000001fa1,
  0x00000000000002f4, 0x0000000000002f41,
  0x0000000000000334, 0x0000000000003341,
  0x00000000000000fc, 0x0000000000000fc1,
  0x00000000000001f6, 0x0000000000001f61,
  0x0000000000000236, 0x0000000000002361,
  0x000000000000023c, 0x00000000000023c1,
  0x00000000000000fa, 0x0000000000000fa1,
  0x000000000000013a, 0x00000000000013a1,
  0x0000000000000140, 0x0000000000001401,
  0x0000000000000144, 0x0000000000001441,
  0x0000000000000040, 0x0000000000000401,
  0x0000000000000046, 0x0000000000000461,
  0x000000000000004a, 0x00000000000004a1,
  0x000000000000004c, 0x00000000000004c1,
  0x0000000000000060, 0x0000000000000178,
  0x00000000000000a0, 0x0000000000000272,
  0x00000000000000c0, 0x00000000000002ef,
  0x00000000000000c0, 0x00000000000002ef,
  0x0000000000000040, 0x00000000000000fb,
  0x0000000000000060, 0x0000000000000178,
  0x0000000000000060, 0x0000000000000178,
  0x0000000000000040, 0x00000000000000fb,
  0x0000000000000020, 0x000000000000007e,
  0x0000000000000020, 0x000000000000007e,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffffc0, 0xffffffffffffff07,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffffe0, 0xffffffffffffff84,
  0xffffffffffffffa0, 0xfffffffffffffe8a,
  0xfffffffffffffba0, 0xffffffffffffeeea,
  0xffffffffffffffe0, 0xffffffffffffff84,
  0xffffffffffffffa0, 0xfffffffffffffe8a,
  0xfffffffffffffba0, 0xffffffffffffeeea,
  0xffffffffffffec00, 0xffffffffffffb1e1,
  0xffffffffffffffc0, 0xffffffffffffff07,
  0xfffffffffffffbc0, 0xffffffffffffef67,
  0xffffffffffffec20, 0xffffffffffffb25e,
  0xffffffffffffdc60, 0xffffffffffff74d8,
  0xfffffffffffffc00, 0xfffffffffffff061,
  0xffffffffffffec60, 0xffffffffffffb358,
  0xffffffffffffdca0, 0xffffffffffff75d2,
  0xffffffffffffccc0, 0xffffffffffff37cf,
  0xfffffffffffff060, 0xffffffffffffc2f8,
  0xffffffffffffe0a0, 0xffffffffffff8572,
  0xffffffffffffd0c0, 0xffffffffffff476f,
  0xffffffffffefd120, 0xffffffffffc0c8e6,
  0xfffffffffffff040, 0xffffffffffffc27b,
  0xffffffffffffe060, 0xffffffffffff8478,
  0xffffffffffefe0c0, 0xffffffffffc105ef,
  0xffffffffffdfe100, 0xffffffffff8286e9,
  0xfffffffffffff020, 0xffffffffffffc1fe,
  0xffffffffffeff080, 0xffffffffffc14375,
  0xffffffffffdff0c0, 0xffffffffff82c46f,
  0xffffffffffcff0e0, 0xffffffffff4444ec,
  0xfffffffffff00060, 0xffffffffffc18178,
  0xffffffffffe000a0, 0xffffffffff830272,
  0xffffffffffd000c0, 0xffffffffff4482ef,
  0xfffffff999699a60, 0xffffffe6ff448308,
  0xfffffffffff00040, 0xffffffffffc180fb,
  0xffffffffffe00060, 0xffffffffff830178,
  0xfffffff999799a00, 0xffffffe6ff830191,
  0xffffffeeeeceef60, 0xffffffbd54d85710,
  0xfffffffffff00020, 0xffffffffffc1807e,
  0xfffffff9998999c0, 0xffffffe6ffc18097,
  0xffffffeeeedeef20, 0xffffffbd5516d616,
  0xffffffdeeedeef80, 0xffffff7ed516d78d,
  0xfffffff9999999a0, 0xffffffe70000001a,
  0xffffffeeeeeeef00, 0xffffffbd55555599,
  0xffffffdeeeeeef60, 0xffffff7ed5555710,
  0xffffffceeeeeefa0, 0xffffff405555580a,
  0xfffffff555555560, 0xffffffd655555580,
  0xffffffe5555555c0, 0xffffff97d55556f7,
  0xffffffd555555600, 0xffffff59555557f1,
  0xffffffc555555620, 0xffffff1ad555586e,
  0xfffffff000000060, 0xffffffc180000178,
  0xffffffe0000000a0, 0xffffff8300000272,
  0xffffffd0000000c0, 0xffffff44800002ef,
  0xffffffe0000000c0, 0xffffff83000002ef,
  0xfffffff000000040, 0xffffffc1800000fb,
  0xffffffe000000060, 0xffffff8300000178,
  0xfffffff000000060, 0xffffffc180000178,
  0x0000000000000040, 0x00000000000000fb,
  0xfffffff000000020, 0xffffffc18000007e,
  0x0000000000000020, 0x000000000000007e,
  0x0000001000000000, 0x0000003e80000001,
  0x0000001aaaaaaac0, 0x000000682aaaaaff,
  0x0000001000000000, 0x0000003e80000001,
  0x0000001fffffffe0, 0x0000007cffffff84,
  0x0000002aaaaaaaa0, 0x000000a6aaaaaa82,
  0x0000003111111120, 0x000000bfaaaaaae6,
  0x0000000fffffffe0, 0x0000003e7fffff84,
  0x0000001aaaaaaaa0, 0x000000682aaaaa82,
  0x0000002111111120, 0x000000812aaaaae6,
  0x0000002111211120, 0x000000812ae92ae6,
  0x0000000aaaaaaac0, 0x00000029aaaaaaff,
  0x0000001111111140, 0x00000042aaaaab63,
  0x0000001111211140, 0x00000042aae92b63,
  0x0000001111311120, 0x00000042ab27aae6,
  0x0000000666666680, 0x0000001900000065,
  0x0000000666766680, 0x00000019003e8065,
  0x0000000666866660, 0x00000019007cffe8,
  0x0000000666966620, 0x0000001900bb7eee,
  0x0000000000100000, 0x00000000003e8001,
  0x00000000001fffe0, 0x00000000007cff84,
  0x00000000002fffa0, 0x0000000000bb7e8a,
  0x00000000003fff40, 0x0000000000f9fd13,
  0x00000000000fffe0, 0x00000000003e7f84,
  0x00000000001fffa0, 0x00000000007cfe8a,
  0x00000000002fff40, 0x0000000000bb7d13,
  0x0000000000300f40, 0x0000000000bbbb93,
  0x00000000000fffc0, 0x00000000003e7f07,
  0x00000000001fff60, 0x00000000007cfd90,
  0x0000000000200f60, 0x00000000007d3c10,
  0x0000000000201f40, 0x00000000007d7a13,
  0x00000000000fffa0, 0x00000000003e7e8a,
  0x0000000000100fa0, 0x00000000003ebd0a,
  0x0000000000101f80, 0x00000000003efb0d,
  0x0000000000102f40, 0x00000000003f3893,
  0x0000000000001000, 0x0000000000003e81,
  0x0000000000001fe0, 0x0000000000007c84,
  0x0000000000002fa0, 0x000000000000ba0a,
  0x0000000000003f40, 0x000000000000f713,
  0x0000000000000fe0, 0x0000000000003e04,
  0x0000000000001fa0, 0x0000000000007b8a,
  0x0000000000002f40, 0x000000000000b893,
  0x0000000000003340, 0x000000000000c833,
  0x0000000000000fc0, 0x0000000000003d87,
  0x0000000000001f60, 0x0000000000007a90,
  0x0000000000002360, 0x0000000000008a30,
  0x00000000000023c0, 0x0000000000008ba7,
  0x0000000000000fa0, 0x0000000000003d0a,
  0x00000000000013a0, 0x0000000000004caa,
  0x0000000000001400, 0x0000000000004e21,
  0x0000000000001440, 0x0000000000004f1b,
  0x0000000000000400, 0x0000000000000fa1,
  0x0000000000000460, 0x0000000000001118,
  0x00000000000004a0, 0x0000000000001212,
  0x00000000000004c0, 0x000000000000128f,
  0x0000000000000177, 0x000000000000017b,
  0x0000000000000271, 0x0000000000000277,
  0x00000000000002ee, 0x00000000000002f5,
  0x00000000000002ee, 0x00000000000002f5,
  0x00000000000000fa, 0x00000000000000fd,
  0x0000000000000177, 0x000000000000017b,
  0x0000000000000177, 0x000000000000017b,
  0x00000000000000fa, 0x00000000000000fd,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007d, 0x000000000000007f,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff06, 0xffffffffffffff05,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff83, 0xffffffffffffff83,
  0xfffffffffffffe89, 0xfffffffffffffe87,
  0xffffffffffffeee9, 0xffffffffffffeec7,
  0xffffffffffffff83, 0xffffffffffffff83,
  0xfffffffffffffe89, 0xfffffffffffffe87,
  0xffffffffffffeee9, 0xffffffffffffeec7,
  0xffffffffffffb1e0, 0xffffffffffffb141,
  0xffffffffffffff06, 0xffffffffffffff05,
  0xffffffffffffef66, 0xffffffffffffef45,
  0xffffffffffffb25d, 0xffffffffffffb1bf,
  0xffffffffffff74d7, 0xffffffffffff73bb,
  0xfffffffffffff060, 0xfffffffffffff041,
  0xffffffffffffb357, 0xffffffffffffb2bb,
  0xffffffffffff75d1, 0xffffffffffff74b7,
  0xffffffffffff37ce, 0xffffffffffff3635,
  0xffffffffffffc2f7, 0xffffffffffffc27b,
  0xffffffffffff8571, 0xffffffffffff8477,
  0xffffffffffff476e, 0xffffffffffff45f5,
  0xffffffffffc0c8e5, 0xffffffffffc0476f,
  0xffffffffffffc27a, 0xffffffffffffc1fd,
  0xffffffffffff8477, 0xffffffffffff837b,
  0xffffffffffc105ee, 0xffffffffffc084f5,
  0xffffffffff8286e8, 0xffffffffff8185f1,
  0xffffffffffffc1fd, 0xffffffffffffc17f,
  0xffffffffffc14374, 0xffffffffffc0c2f9,
  0xffffffffff82c46e, 0xffffffffff81c3f5,
  0xffffffffff4444eb, 0xffffffffff42c473,
  0xffffffffffc18177, 0xffffffffffc1017b,
  0xffffffffff830271, 0xffffffffff820277,
  0xffffffffff4482ee, 0xffffffffff4302f5,
  0xffffffe6ff448307, 0xffffffe6cc0fcfdb,
  0xffffffffffc180fa, 0xffffffffffc100fd,
  0xffffffffff830177, 0xffffffffff82017b,
  0xffffffe6ff830190, 0xffffffe6cc4ece61,
  0xffffffbd54d8570f, 0xffffffbccc4ece8b,
  0xffffffffffc1807d, 0xffffffffffc1007f,
  0xffffffe6ffc18096, 0xffffffe6cc8dcd65,
  0xffffffbd5516d615, 0xffffffbccc8dcd8f,
  0xffffff7ed516d78c, 0xffffff7dcc8dcf09,
  0xffffffe700000019, 0xffffffe6cccccce7,
  0xffffffbd55555598, 0xffffffbccccccd11,
  0xffffff7ed555570f, 0xffffff7dccccce8b,
  0xffffff4055555809, 0xffffff3ecccccf87,
  0xffffffd65555557f, 0xffffffd60000002b,
  0xffffff97d55556f6, 0xffffff97000001a5,
  0xffffff59555557f0, 0xffffff58000002a1,
  0xffffff1ad555586d, 0xffffff190000031f,
  0xffffffc180000177, 0xffffffc10000017b,
  0xffffff8300000271, 0xffffff8200000277,
  0xffffff44800002ee, 0xffffff43000002f5,
  0xffffff83000002ee, 0xffffff82000002f5,
  0xffffffc1800000fa, 0xffffffc1000000fd,
  0xffffff8300000177, 0xffffff820000017b,
  0xffffffc180000177, 0xffffffc10000017b,
  0x00000000000000fa, 0x00000000000000fd,
  0xffffffc18000007d, 0xffffffc10000007f,
  0x000000000000007d, 0x000000000000007f,
  0x0000003e80000000, 0x0000003f00000001,
  0x000000682aaaaafe, 0x0000006900000055,
  0x0000003e80000000, 0x0000003f00000001,
  0x0000007cffffff83, 0x0000007dffffff83,
  0x000000a6aaaaaa81, 0x000000a7ffffffd7,
  0x000000bfaaaaaae5, 0x000000c13333336f,
  0x0000003e7fffff83, 0x0000003effffff83,
  0x000000682aaaaa81, 0x00000068ffffffd7,
  0x000000812aaaaae5, 0x000000823333336f,
  0x000000812ae92ae5, 0x000000823372336f,
  0x00000029aaaaaafe, 0x0000002a00000055,
  0x00000042aaaaab62, 0x00000043333333ed,
  0x00000042aae92b62, 0x00000043337233ed,
  0x00000042ab27aae5, 0x0000004333b1336f,
  0x0000001900000064, 0x0000001933333399,
  0x00000019003e8064, 0x0000001933723399,
  0x00000019007cffe7, 0x0000001933b1331b,
  0x0000001900bb7eed, 0x0000001933f0321f,
  0x00000000003e8000, 0x00000000003f0001,
  0x00000000007cff83, 0x00000000007dff83,
  0x0000000000bb7e89, 0x0000000000bcfe87,
  0x0000000000f9fd12, 0x0000000000fbfd0d,
  0x00000000003e7f83, 0x00000000003eff83,
  0x00000000007cfe89, 0x00000000007dfe87,
  0x0000000000bb7d12, 0x0000000000bcfd0d,
  0x0000000000bbbb92, 0x0000000000bd3c0d,
  0x00000000003e7f06, 0x00000000003eff05,
  0x00000000007cfd8f, 0x00000000007dfd8b,
  0x00000000007d3c0f, 0x00000000007e3c8b,
  0x00000000007d7a12, 0x00000000007e7b0d,
  0x00000000003e7e89, 0x00000000003efe87,
  0x00000000003ebd09, 0x00000000003f3d87,
  0x00000000003efb0c, 0x00000000003f7c09,
  0x00000000003f3892, 0x00000000003fba0d,
  0x0000000000003e80, 0x0000000000003f01,
  0x0000000000007c83, 0x0000000000007d83,
  0x000000000000ba09, 0x000000000000bb87,
  0x000000000000f712, 0x000000000000f90d,
  0x0000000000003e03, 0x0000000000003e83,
  0x0000000000007b89, 0x0000000000007c87,
  0x000000000000b892, 0x000000000000ba0d,
  0x000000000000c832, 0x000000000000c9cd,
  0x0000000000003d86, 0x0000000000003e05,
  0x0000000000007a8f, 0x0000000000007b8b,
  0x0000000000008a2f, 0x0000000000008b4b,
  0x0000000000008ba6, 0x0000000000008cc5,
  0x0000000000003d09, 0x0000000000003d87,
  0x0000000000004ca9, 0x0000000000004d47,
  0x0000000000004e20, 0x0000000000004ec1,
  0x0000000000004f1a, 0x0000000000004fbd,
  0x0000000000000fa0, 0x0000000000000fc1,
  0x0000000000001117, 0x000000000000113b,
  0x0000000000001211, 0x0000000000001237,
  0x000000000000128e, 0x00000000000012b5,
  0x000000000000017a, 0x000000000000017e,
  0x0000000000000276, 0x000000000000027c,
  0x00000000000002f4, 0x00000000000002fb,
  0x00000000000002f4, 0x00000000000002fb,
  0x00000000000000fc, 0x00000000000000ff,
  0x000000000000017a, 0x000000000000017e,
  0x000000000000017a, 0x000000000000017e,
  0x00000000000000fc, 0x00000000000000ff,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007e, 0x0000000000000080,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff04, 0xffffffffffffff03,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff82, 0xffffffffffffff82,
  0xfffffffffffffe86, 0xfffffffffffffe84,
  0xffffffffffffeec6, 0xffffffffffffeea4,
  0xffffffffffffff82, 0xffffffffffffff82,
  0xfffffffffffffe86, 0xfffffffffffffe84,
  0xffffffffffffeec6, 0xffffffffffffeea4,
  0xffffffffffffb140, 0xffffffffffffb0a1,
  0xffffffffffffff04, 0xffffffffffffff03,
  0xffffffffffffef44, 0xffffffffffffef23,
  0xffffffffffffb1be, 0xffffffffffffb120,
  0xffffffffffff73ba, 0xffffffffffff729e,
  0xfffffffffffff040, 0xfffffffffffff021,
  0xffffffffffffb2ba, 0xffffffffffffb21e,
  0xffffffffffff74b6, 0xffffffffffff739c,
  0xffffffffffff3634, 0xffffffffffff349b,
  0xffffffffffffc27a, 0xffffffffffffc1fe,
  0xffffffffffff8476, 0xffffffffffff837c,
  0xffffffffffff45f4, 0xffffffffffff447b,
  0xffffffffffc0476e, 0xffffffffffbfc5f8,
  0xffffffffffffc1fc, 0xffffffffffffc17f,
  0xffffffffffff837a, 0xffffffffffff827e,
  0xffffffffffc084f4, 0xffffffffffc003fb,
  0xffffffffff8185f0, 0xffffffffff8084f9,
  0xffffffffffffc17e, 0xffffffffffffc100,
  0xffffffffffc0c2f8, 0xffffffffffc0427d,
  0xffffffffff81c3f4, 0xffffffffff80c37b,
  0xffffffffff42c472, 0xffffffffff4143fa,
  0xffffffffffc1017a, 0xffffffffffc0817e,
  0xffffffffff820276, 0xffffffffff81027c,
  0xffffffffff4302f4, 0xffffffffff4182fb,
  0xffffffe6cc0fcfda, 0xffffffe698db1cae,
  0xffffffffffc100fc, 0xffffffffffc080ff,
  0xffffffffff82017a, 0xffffffffff81017e,
  0xffffffe6cc4ece60, 0xffffffe6991a9b31,
  0xffffffbccc4ece8a, 0xffffffbc43c54606,
  0xffffffffffc1007e, 0xffffffffffc08080,
  0xffffffe6cc8dcd64, 0xffffffe6995a1a33,
  0xffffffbccc8dcd8e, 0xffffffbc4404c508,
  0xffffff7dcc8dcf08, 0xffffff7cc404c685,
  0xffffffe6cccccce6, 0xffffffe6999999b4,
  0xffffffbccccccd10, 0xffffffbc44444489,
  0xffffff7dccccce8a, 0xffffff7cc4444606,
  0xffffff3ecccccf86, 0xffffff3d44444704,
  0xffffffd60000002a, 0xffffffd5aaaaaad6,
  0xffffff97000001a4, 0xffffff962aaaac53,
  0xffffff58000002a0, 0xffffff56aaaaad51,
  0xffffff190000031e, 0xffffff172aaaadd0,
  0xffffffc10000017a, 0xffffffc08000017e,
  0xffffff8200000276, 0xffffff810000027c,
  0xffffff43000002f4, 0xffffff41800002fb,
  0xffffff82000002f4, 0xffffff81000002fb,
  0xffffffc1000000fc, 0xffffffc0800000ff,
  0xffffff820000017a, 0xffffff810000017e,
  0xffffffc10000017a, 0xffffffc08000017e,
  0x00000000000000fc, 0x00000000000000ff,
  0xffffffc10000007e, 0xffffffc080000080,
  0x000000000000007e, 0x0000000000000080,
  0x0000003f00000000, 0x0000003f80000001,
  0x0000006900000054, 0x00000069d55555ab,
  0x0000003f00000000, 0x0000003f80000001,
  0x0000007dffffff82, 0x0000007effffff82,
  0x000000a7ffffffd6, 0x000000a95555552c,
  0x000000c13333336e, 0x000000c2bbbbbbf8,
  0x0000003effffff82, 0x0000003f7fffff82,
  0x00000068ffffffd6, 0x00000069d555552c,
  0x000000823333336e, 0x000000833bbbbbf8,
  0x000000823372336e, 0x000000833bfb3bf8,
  0x0000002a00000054, 0x0000002a555555ab,
  0x00000043333333ec, 0x00000043bbbbbc77,
  0x00000043337233ec, 0x00000043bbfb3c77,
  0x0000004333b1336e, 0x00000043bc3abbf8,
  0x0000001933333398, 0x00000019666666cd,
  0x0000001933723398, 0x0000001966a5e6cd,
  0x0000001933b1331a, 0x0000001966e5664e,
  0x0000001933f0321e, 0x000000196724e550,
  0x00000000003f0000, 0x00000000003f8001,
  0x00000000007dff82, 0x00000000007eff82,
  0x0000000000bcfe86, 0x0000000000be7e84,
  0x0000000000fbfd0c, 0x0000000000fdfd07,
  0x00000000003eff82, 0x00000000003f7f82,
  0x00000000007dfe86, 0x00000000007efe84,
  0x0000000000bcfd0c, 0x0000000000be7d07,
  0x0000000000bd3c0c, 0x0000000000bebc87,
  0x00000000003eff04, 0x00000000003f7f03,
  0x00000000007dfd8a, 0x00000000007efd86,
  0x00000000007e3c8a, 0x00000000007f3d06,
  0x00000000007e7b0c, 0x00000000007f7c07,
  0x00000000003efe86, 0x00000000003f7e84,
  0x00000000003f3d86, 0x00000000003fbe04,
  0x00000000003f7c08, 0x00000000003ffd05,
  0x00000000003fba0c, 0x0000000000403b87,
  0x0000000000003f00, 0x0000000000003f81,
  0x0000000000007d82, 0x0000000000007e82,
  0x000000000000bb86, 0x000000000000bd04,
  0x000000000000f90c, 0x000000000000fb07,
  0x0000000000003e82, 0x0000000000003f02,
  0x0000000000007c86, 0x0000000000007d84,
  0x000000000000ba0c, 0x000000000000bb87,
  0x000000000000c9cc, 0x000000000000cb67,
  0x0000000000003e04, 0x0000000000003e83,
  0x0000000000007b8a, 0x0000000000007c86,
  0x0000000000008b4a, 0x0000000000008c66,
  0x0000000000008cc4, 0x0000000000008de3,
  0x0000000000003d86, 0x0000000000003e04,
  0x0000000000004d46, 0x0000000000004de4,
  0x0000000000004ec0, 0x0000000000004f61,
  0x0000000000004fbc, 0x000000000000505f,
  0x0000000000000fc0, 0x0000000000000fe1,
  0x000000000000113a, 0x000000000000115e,
  0x0000000000001236, 0x000000000000125c,
  0x00000000000012b4, 0x00000000000012db,
  0x000000000000017d, 0x0000000000017ff8,
  0x000000000000027b, 0x0000000000027ff2,
  0x00000000000002fa, 0x000000000002ffef,
  0x00000000000002fa, 0x000000000002ffef,
  0x00000000000000fe, 0x000000000000fffb,
  0x000000000000017d, 0x0000000000017ff8,
  0x000000000000017d, 0x0000000000017ff8,
  0x00000000000000fe, 0x000000000000fffb,
  0x000000000000007f, 0x0000000000007ffe,
  0x000000000000007f, 0x0000000000007ffe,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff02, 0xffffffffffff0007,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff81, 0xffffffffffff8004,
  0xfffffffffffffe83, 0xfffffffffffe800a,
  0xffffffffffffeea3, 0xffffffffffee806a,
  0xffffffffffffff81, 0xffffffffffff8004,
  0xfffffffffffffe83, 0xfffffffffffe800a,
  0xffffffffffffeea3, 0xffffffffffee806a,
  0xffffffffffffb0a0, 0xffffffffffb001e1,
  0xffffffffffffff02, 0xffffffffffff0007,
  0xffffffffffffef22, 0xffffffffffef0067,
  0xffffffffffffb11f, 0xffffffffffb081de,
  0xffffffffffff729d, 0xffffffffff718358,
  0xfffffffffffff020, 0xfffffffffff00061,
  0xffffffffffffb21d, 0xffffffffffb181d8,
  0xffffffffffff739b, 0xffffffffff728352,
  0xffffffffffff349a, 0xffffffffff3304cf,
  0xffffffffffffc1fd, 0xffffffffffc18178,
  0xffffffffffff837b, 0xffffffffff8282f2,
  0xffffffffffff447a, 0xffffffffff43046f,
  0xffffffffffbfc5f7, 0xffffffffbf460466,
  0xffffffffffffc17e, 0xffffffffffc1017b,
  0xffffffffffff827d, 0xffffffffff8182f8,
  0xffffffffffc003fa, 0xffffffffbf8482ef,
  0xffffffffff8084f8, 0xffffffff7f8702e9,
  0xffffffffffffc0ff, 0xffffffffffc0817e,
  0xffffffffffc0427c, 0xffffffffbfc38175,
  0xffffffffff80c37a, 0xffffffff7fc6016f,
  0xffffffffff4143f9, 0xffffffff3fc8016c,
  0xffffffffffc0817d, 0xffffffffc002fff8,
  0xffffffffff81027b, 0xffffffff80057ff2,
  0xffffffffff4182fa, 0xffffffff40077fef,
  0xffffffe698db1cad, 0xffffe66640079988,
  0xffffffffffc080fe, 0xffffffffc0027ffb,
  0xffffffffff81017d, 0xffffffff80047ff8,
  0xffffffe6991a9b30, 0xffffe66680049991,
  0xffffffbc43c54605, 0xffffbbbcd55a1990,
  0xffffffffffc0807f, 0xffffffffc001fffe,
  0xffffffe6995a1a32, 0xffffe666c0021997,
  0xffffffbc4404c507, 0xffffbbbd15579996,
  0xffffff7cc404c684, 0xffff7bbe9559198d,
  0xffffffe6999999b3, 0xffffe6670000199a,
  0xffffffbc44444488, 0xffffbbbd55559999,
  0xffffff7cc4444605, 0xffff7bbed5571990,
  0xffffff3d44444703, 0xffff3bc05558198a,
  0xffffffd5aaaaaad5, 0xffffd55655558000,
  0xffffff962aaaac52, 0xffff9557d556fff7,
  0xffffff56aaaaad50, 0xffff55595557fff1,
  0xffffff172aaaadcf, 0xffff155ad5587fee,
  0xffffffc08000017d, 0xffffc00180017ff8,
  0xffffff810000027b, 0xffff800300027ff2,
  0xffffff41800002fa, 0xffff40048002ffef,
  0xffffff81000002fa, 0xffff80030002ffef,
  0xffffffc0800000fe, 0xffffc0018000fffb,
  0xffffff810000017d, 0xffff800300017ff8,
  0xffffffc08000017d, 0xffffc00180017ff8,
  0x00000000000000fe, 0x000000000000fffb,
  0xffffffc08000007f, 0xffffc00180007ffe,
  0x000000000000007f, 0x0000000000007ffe,
  0x0000003f80000000, 0x00003ffe80000001,
  0x00000069d55555aa, 0x00006aa82aaaffff,
  0x0000003f80000000, 0x00003ffe80000001,
  0x0000007effffff81, 0x00007ffcffff8004,
  0x000000a95555552b, 0x0000aaa6aaaa8002,
  0x000000c2bbbbbbf7, 0x0000c43faaaae666,
  0x0000003f7fffff81, 0x00003ffe7fff8004,
  0x00000069d555552b, 0x00006aa82aaa8002,
  0x000000833bbbbbf7, 0x000084412aaae666,
  0x000000833bfb3bf7, 0x000084416aa96666,
  0x0000002a555555aa, 0x00002aa9aaaaffff,
  0x00000043bbbbbc76, 0x00004442aaab6663,
  0x00000043bbfb3c76, 0x00004442eaa9e663,
  0x00000043bc3abbf7, 0x000044432aa7e666,
  0x00000019666666cc, 0x0000199900006665,
  0x0000001966a5e6cc, 0x000019993ffee665,
  0x0000001966e5664d, 0x000019997ffce668,
  0x000000196724e54f, 0x00001999bffa666e,
  0x00000000003f8000, 0x000000003ffe8001,
  0x00000000007eff81, 0x000000007ffc8004,
  0x0000000000be7e83, 0x00000000bffa000a,
  0x0000000000fdfd06, 0x00000000fff70013,
  0x00000000003f7f81, 0x000000003ffe0004,
  0x00000000007efe83, 0x000000007ffb800a,
  0x0000000000be7d06, 0x00000000bff88013,
  0x0000000000bebc86, 0x00000000c0387e93,
  0x00000000003f7f02, 0x000000003ffd8007,
  0x00000000007efd85, 0x000000007ffa8010,
  0x00000000007f3d05, 0x00000000803a7e90,
  0x00000000007f7c06, 0x000000008079fd13,
  0x00000000003f7e83, 0x000000003ffd000a,
  0x00000000003fbe03, 0x00000000403cfe8a,
  0x00000000003ffd04, 0x00000000407c7d0d,
  0x0000000000403b86, 0x0000000040bb7b93,
  0x0000000000003f80, 0x00000000003ffe81,
  0x0000000000007e81, 0x00000000007f7d04,
  0x000000000000bd03, 0x0000000000be7b8a,
  0x000000000000fb06, 0x0000000000fcfa13,
  0x0000000000003f01, 0x00000000003f7e84,
  0x0000000000007d83, 0x00000000007e7d0a,
  0x000000000000bb86, 0x0000000000bcfb93,
  0x000000000000cb66, 0x0000000000ccfb33,
  0x0000000000003e82, 0x00000000003efe87,
  0x0000000000007c85, 0x00000000007d7d10,
  0x0000000000008c65, 0x00000000008d7cb0,
  0x0000000000008de2, 0x00000000008efca7,
  0x0000000000003e03, 0x00000000003e7e8a,
  0x0000000000004de3, 0x00000000004e7e2a,
  0x0000000000004f60, 0x00000000004ffe21,
  0x000000000000505e, 0x000000000050fe1b,
  0x0000000000000fe0, 0x00000000000fffa1,
  0x000000000000115d, 0x0000000000117f98,
  0x000000000000125b, 0x0000000000127f92,
  0x00000000000012da, 0x000000000012ff8f,
  0x0000000000017ff7, 0x0000000000017ffb,
  0x0000000000027ff1, 0x0000000000027ff7,
  0x000000000002ffee, 0x000000000002fff5,
  0x000000000002ffee, 0x000000000002fff5,
  0x000000000000fffa, 0x000000000000fffd,
  0x0000000000017ff7, 0x0000000000017ffb,
  0x0000000000017ff7, 0x0000000000017ffb,
  0x000000000000fffa, 0x000000000000fffd,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff0006, 0xffffffffffff0005,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff8003, 0xffffffffffff8003,
  0xfffffffffffe8009, 0xfffffffffffe8007,
  0xffffffffffee8069, 0xffffffffffee8047,
  0xffffffffffff8003, 0xffffffffffff8003,
  0xfffffffffffe8009, 0xfffffffffffe8007,
  0xffffffffffee8069, 0xffffffffffee8047,
  0xffffffffffb001e0, 0xffffffffffb00141,
  0xffffffffffff0006, 0xffffffffffff0005,
  0xffffffffffef0066, 0xffffffffffef0045,
  0xffffffffffb081dd, 0xffffffffffb0813f,
  0xffffffffff718357, 0xffffffffff71823b,
  0xfffffffffff00060, 0xfffffffffff00041,
  0xffffffffffb181d7, 0xffffffffffb1813b,
  0xffffffffff728351, 0xffffffffff728237,
  0xffffffffff3304ce, 0xffffffffff330335,
  0xffffffffffc18177, 0xffffffffffc180fb,
  0xffffffffff8282f1, 0xffffffffff8281f7,
  0xffffffffff43046e, 0xffffffffff4302f5,
  0xffffffffbf460465, 0xffffffffbf4582ef,
  0xffffffffffc1017a, 0xffffffffffc100fd,
  0xffffffffff8182f7, 0xffffffffff8181fb,
  0xffffffffbf8482ee, 0xffffffffbf8401f5,
  0xffffffff7f8702e8, 0xffffffff7f8601f1,
  0xffffffffffc0817d, 0xffffffffffc080ff,
  0xffffffffbfc38174, 0xffffffffbfc300f9,
  0xffffffff7fc6016e, 0xffffffff7fc500f5,
  0xffffffff3fc8016b, 0xffffffff3fc680f3,
  0xffffffffc002fff7, 0xffffffffc0027ffb,
  0xffffffff80057ff1, 0xffffffff80047ff7,
  0xffffffff40077fee, 0xffffffff4005fff5,
  0xffffe66640079987, 0xffffe6660cd2e65b,
  0xffffffffc0027ffa, 0xffffffffc001fffd,
  0xffffffff80047ff7, 0xffffffff80037ffb,
  0xffffe66680049990, 0xffffe6664cd06661,
  0xffffbbbcd55a198f, 0xffffbbbc4cd0910b,
  0xffffffffc001fffd, 0xffffffffc0017fff,
  0xffffe666c0021996, 0xffffe6668cce6665,
  0xffffbbbd15579995, 0xffffbbbc8cce910f,
  0xffff7bbe9559198c, 0xffff7bbd8cd01109,
  0xffffe66700001999, 0xffffe666cccce667,
  0xffffbbbd55559998, 0xffffbbbccccd1111,
  0xffff7bbed557198f, 0xffff7bbdccce910b,
  0xffff3bc055581989, 0xffff3bbecccf9107,
  0xffffd55655557fff, 0xffffd55600002aab,
  0xffff9557d556fff6, 0xffff95570001aaa5,
  0xffff55595557fff0, 0xffff55580002aaa1,
  0xffff155ad5587fed, 0xffff155900032a9f,
  0xffffc00180017ff7, 0xffffc00100017ffb,
  0xffff800300027ff1, 0xffff800200027ff7,
  0xffff40048002ffee, 0xffff40030002fff5,
  0xffff80030002ffee, 0xffff80020002fff5,
  0xffffc0018000fffa, 0xffffc0010000fffd,
  0xffff800300017ff7, 0xffff800200017ffb,
  0xffffc00180017ff7, 0xffffc00100017ffb,
  0x000000000000fffa, 0x000000000000fffd,
  0xffffc00180007ffd, 0xffffc00100007fff,
  0x0000000000007ffd, 0x0000000000007fff,
  0x00003ffe80000000, 0x00003fff00000001,
  0x00006aa82aaafffe, 0x00006aa900005555,
  0x00003ffe80000000, 0x00003fff00000001,
  0x00007ffcffff8003, 0x00007ffdffff8003,
  0x0000aaa6aaaa8001, 0x0000aaa7ffffd557,
  0x0000c43faaaae665, 0x0000c44133336eef,
  0x00003ffe7fff8003, 0x00003ffeffff8003,
  0x00006aa82aaa8001, 0x00006aa8ffffd557,
  0x000084412aaae665, 0x0000844233336eef,
  0x000084416aa96665, 0x0000844273326eef,
  0x00002aa9aaaafffe, 0x00002aaa00005555,
  0x00004442aaab6662, 0x000044433333eeed,
  0x00004442eaa9e662, 0x000044437332eeed,
  0x000044432aa7e665, 0x00004443b3316eef,
  0x0000199900006664, 0x0000199933339999,
  0x000019993ffee664, 0x0000199973329999,
  0x000019997ffce667, 0x00001999b331199b,
  0x00001999bffa666d, 0x00001999f32f199f,
  0x000000003ffe8000, 0x000000003fff0001,
  0x000000007ffc8003, 0x000000007ffd8003,
  0x00000000bffa0009, 0x00000000bffb8007,
  0x00000000fff70012, 0x00000000fff9000d,
  0x000000003ffe0003, 0x000000003ffe8003,
  0x000000007ffb8009, 0x000000007ffc8007,
  0x00000000bff88012, 0x00000000bffa000d,
  0x00000000c0387e92, 0x00000000c039ff0d,
  0x000000003ffd8006, 0x000000003ffe0005,
  0x000000007ffa800f, 0x000000007ffb800b,
  0x00000000803a7e8f, 0x00000000803b7f0b,
  0x000000008079fd12, 0x00000000807afe0d,
  0x000000003ffd0009, 0x000000003ffd8007,
  0x00000000403cfe89, 0x00000000403d7f07,
  0x00000000407c7d0c, 0x00000000407cfe09,
  0x0000000040bb7b92, 0x0000000040bbfd0d,
  0x00000000003ffe80, 0x00000000003fff01,
  0x00000000007f7d03, 0x00000000007f7e03,
  0x0000000000be7b89, 0x0000000000be7d07,
  0x0000000000fcfa12, 0x0000000000fcfc0d,
  0x00000000003f7e83, 0x00000000003f7f03,
  0x00000000007e7d09, 0x00000000007e7e07,
  0x0000000000bcfb92, 0x0000000000bcfd0d,
  0x0000000000ccfb32, 0x0000000000ccfccd,
  0x00000000003efe86, 0x00000000003eff05,
  0x00000000007d7d0f, 0x00000000007d7e0b,
  0x00000000008d7caf, 0x00000000008d7dcb,
  0x00000000008efca6, 0x00000000008efdc5,
  0x00000000003e7e89, 0x00000000003e7f07,
  0x00000000004e7e29, 0x00000000004e7ec7,
  0x00000000004ffe20, 0x00000000004ffec1,
  0x000000000050fe1a, 0x000000000050febd,
  0x00000000000fffa0, 0x00000000000fffc1,
  0x0000000000117f97, 0x0000000000117fbb,
  0x0000000000127f91, 0x0000000000127fb7,
  0x000000000012ff8e, 0x000000000012ffb5,
  0x0000000000017ffa, 0x0000000000017ffe,
  0x0000000000027ff6, 0x0000000000027ffc,
  0x000000000002fff4, 0x000000000002fffb,
  0x000000000002fff4, 0x000000000002fffb,
  0x000000000000fffc, 0x000000000000ffff,
  0x0000000000017ffa, 0x0000000000017ffe,
  0x0000000000017ffa, 0x0000000000017ffe,
  0x000000000000fffc, 0x000000000000ffff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff0004, 0xffffffffffff0003,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff8002, 0xffffffffffff8002,
  0xfffffffffffe8006, 0xfffffffffffe8004,
  0xffffffffffee8046, 0xffffffffffee8024,
  0xffffffffffff8002, 0xffffffffffff8002,
  0xfffffffffffe8006, 0xfffffffffffe8004,
  0xffffffffffee8046, 0xffffffffffee8024,
  0xffffffffffb00140, 0xffffffffffb000a1,
  0xffffffffffff0004, 0xffffffffffff0003,
  0xffffffffffef0044, 0xffffffffffef0023,
  0xffffffffffb0813e, 0xffffffffffb080a0,
  0xffffffffff71823a, 0xffffffffff71811e,
  0xfffffffffff00040, 0xfffffffffff00021,
  0xffffffffffb1813a, 0xffffffffffb1809e,
  0xffffffffff728236, 0xffffffffff72811c,
  0xffffffffff330334, 0xffffffffff33019b,
  0xffffffffffc180fa, 0xffffffffffc1807e,
  0xffffffffff8281f6, 0xffffffffff8280fc,
  0xffffffffff4302f4, 0xffffffffff43017b,
  0xffffffffbf4582ee, 0xffffffffbf450178,
  0xffffffffffc100fc, 0xffffffffffc1007f,
  0xffffffffff8181fa, 0xffffffffff8180fe,
  0xffffffffbf8401f4, 0xffffffffbf8380fb,
  0xffffffff7f8601f0, 0xffffffff7f8500f9,
  0xffffffffffc080fe, 0xffffffffffc08080,
  0xffffffffbfc300f8, 0xffffffffbfc2807d,
  0xffffffff7fc500f4, 0xffffffff7fc4007b,
  0xffffffff3fc680f2, 0xffffffff3fc5007a,
  0xffffffffc0027ffa, 0xffffffffc001fffe,
  0xffffffff80047ff6, 0xffffffff80037ffc,
  0xffffffff4005fff4, 0xffffffff40047ffb,
  0xffffe6660cd2e65a, 0xffffe665d99e332e,
  0xffffffffc001fffc, 0xffffffffc0017fff,
  0xffffffff80037ffa, 0xffffffff80027ffe,
  0xffffe6664cd06660, 0xffffe666199c3331,
  0xffffbbbc4cd0910a, 0xffffbbbbc4470886,
  0xffffffffc0017ffe, 0xffffffffc0010000,
  0xffffe6668cce6664, 0xffffe666599ab333,
  0xffffbbbc8cce910e, 0xffffbbbc04458888,
  0xffff7bbd8cd01108, 0xffff7bbc84470885,
  0xffffe666cccce666, 0xffffe6669999b334,
  0xffffbbbccccd1110, 0xffffbbbc44448889,
  0xffff7bbdccce910a, 0xffff7bbcc4460886,
  0xffff3bbecccf9106, 0xffff3bbd44470884,
  0xffffd55600002aaa, 0xffffd555aaaad556,
  0xffff95570001aaa4, 0xffff95562aac5553,
  0xffff55580002aaa0, 0xffff5556aaad5551,
  0xffff155900032a9e, 0xffff15572aadd550,
  0xffffc00100017ffa, 0xffffc00080017ffe,
  0xffff800200027ff6, 0xffff800100027ffc,
  0xffff40030002fff4, 0xffff40018002fffb,
  0xffff80020002fff4, 0xffff80010002fffb,
  0xffffc0010000fffc, 0xffffc0008000ffff,
  0xffff800200017ffa, 0xffff800100017ffe,
  0xffffc00100017ffa, 0xffffc00080017ffe,
  0x000000000000fffc, 0x000000000000ffff,
  0xffffc00100007ffe, 0xffffc00080008000,
  0x0000000000007ffe, 0x0000000000008000,
  0x00003fff00000000, 0x00003fff80000001,
  0x00006aa900005554, 0x00006aa9d555aaab,
  0x00003fff00000000, 0x00003fff80000001,
  0x00007ffdffff8002, 0x00007ffeffff8002,
  0x0000aaa7ffffd556, 0x0000aaa955552aac,
  0x0000c44133336eee, 0x0000c442bbbbf778,
  0x00003ffeffff8002, 0x00003fff7fff8002,
  0x00006aa8ffffd556, 0x00006aa9d5552aac,
  0x0000844233336eee, 0x000084433bbbf778,
  0x0000844273326eee, 0x000084437bbb7778,
  0x00002aaa00005554, 0x00002aaa5555aaab,
  0x000044433333eeec, 0x00004443bbbc7777,
  0x000044437332eeec, 0x00004443fbbbf777,
  0x00004443b3316eee, 0x000044443bbaf778,
  0x0000199933339998, 0x000019996666cccd,
  0x0000199973329998, 0x00001999a6664ccd,
  0x00001999b331199a, 0x00001999e6654cce,
  0x00001999f32f199e, 0x0000199a2663ccd0,
  0x000000003fff0000, 0x000000003fff8001,
  0x000000007ffd8002, 0x000000007ffe8002,
  0x00000000bffb8006, 0x00000000bffd0004,
  0x00000000fff9000c, 0x00000000fffb0007,
  0x000000003ffe8002, 0x000000003fff0002,
  0x000000007ffc8006, 0x000000007ffd8004,
  0x00000000bffa000c, 0x00000000bffb8007,
  0x00000000c039ff0c, 0x00000000c03b7f87,
  0x000000003ffe0004, 0x000000003ffe8003,
  0x000000007ffb800a, 0x000000007ffc8006,
  0x00000000803b7f0a, 0x00000000803c7f86,
  0x00000000807afe0c, 0x00000000807bff07,
  0x000000003ffd8006, 0x000000003ffe0004,
  0x00000000403d7f06, 0x00000000403dff84,
  0x00000000407cfe08, 0x00000000407d7f05,
  0x0000000040bbfd0c, 0x0000000040bc7e87,
  0x00000000003fff00, 0x00000000003fff81,
  0x00000000007f7e02, 0x00000000007f7f02,
  0x0000000000be7d06, 0x0000000000be7e84,
  0x0000000000fcfc0c, 0x0000000000fcfe07,
  0x00000000003f7f02, 0x00000000003f7f82,
  0x00000000007e7e06, 0x00000000007e7f04,
  0x0000000000bcfd0c, 0x0000000000bcfe87,
  0x0000000000ccfccc, 0x0000000000ccfe67,
  0x00000000003eff04, 0x00000000003eff83,
  0x00000000007d7e0a, 0x00000000007d7f06,
  0x00000000008d7dca, 0x00000000008d7ee6,
  0x00000000008efdc4, 0x00000000008efee3,
  0x00000000003e7f06, 0x00000000003e7f84,
  0x00000000004e7ec6, 0x00000000004e7f64,
  0x00000000004ffec0, 0x00000000004fff61,
  0x000000000050febc, 0x000000000050ff5f,
  0x00000000000fffc0, 0x00000000000fffe1,
  0x0000000000117fba, 0x0000000000117fde,
  0x0000000000127fb6, 0x0000000000127fdc,
  0x000000000012ffb4, 0x000000000012ffdb,
  0x0000000000017ffd, 0x000000009999999a,
  0x0000000000027ffb, 0x0000000100000000,
  0x000000000002fffa, 0x0000000133333333,
  0x000000000002fffa, 0x0000000133333333,
  0x000000000000fffe, 0x0000000066666667,
  0x0000000000017ffd, 0x000000009999999a,
  0x0000000000017ffd, 0x000000009999999a,
  0x000000000000fffe, 0x0000000066666667,
  0x0000000000007fff, 0x0000000033333334,
  0x0000000000007fff, 0x0000000033333334,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff0002, 0xffffffff9999999b,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff8001, 0xffffffffccccccce,
  0xfffffffffffe8003, 0xffffffff66666668,
  0xffffffffffee8023, 0xfffffff900000008,
  0xffffffffffff8001, 0xffffffffccccccce,
  0xfffffffffffe8003, 0xffffffff66666668,
  0xffffffffffee8023, 0xfffffff900000008,
  0xffffffffffb000a0, 0xffffffe000000021,
  0xffffffffffff0002, 0xffffffff9999999b,
  0xffffffffffef0022, 0xfffffff93333333b,
  0xffffffffffb0809f, 0xffffffe033333354,
  0xffffffffff71811d, 0xffffffc70000003a,
  0xfffffffffff00020, 0xfffffff9999999a1,
  0xffffffffffb1809d, 0xffffffe0999999ba,
  0xffffffffff72811b, 0xffffffc7666666a0,
  0xffffffffff33019a, 0xffffffae00000053,
  0xffffffffffc1807d, 0xffffffe70000001a,
  0xffffffffff8280fb, 0xffffffcdcccccd00,
  0xffffffffff43017a, 0xffffffb4666666b3,
  0xffffffffbf450177, 0xffffe61b6666804c,
  0xffffffffffc1007e, 0xffffffe6cccccce7,
  0xffffffffff8180fd, 0xffffffcd6666669a,
  0xffffffffbf8380fa, 0xffffe63466668033,
  0xffffffff7f8500f8, 0xffffcc9b33336699,
  0xffffffffffc0807f, 0xffffffe6999999b4,
  0xffffffffbfc2807c, 0xffffe64d9999b34d,
  0xffffffff7fc4007a, 0xffffccb4666699b3,
  0xffffffff3fc50079, 0xffffb31b00004ce6,
  0xffffffffc001fffd, 0xffffe6670000199a,
  0xffffffff80037ffb, 0xffffcccdcccd0000,
  0xffffffff40047ffa, 0xffffb3346666b333,
  0xffffe665d99e332d, 0xf5c24290a3d7570a,
  0xffffffffc0017ffe, 0xffffe666cccce667,
  0xffffffff80027ffd, 0xffffcccd6666999a,
  0xffffe666199c3330, 0xf5c25c29a3d73d71,
  0xffffbbbbc4470885, 0xe4b14b18b4e84e82,
  0xffffffffc000ffff, 0xffffe6669999b334,
  0xffffe666599ab332, 0xf5c275c2d70a570b,
  0xffffbbbc04458887, 0xe4b164b1e81b681c,
  0xffff7bbc84470884, 0xcb17cb1901b501b5,
  0xffffe6669999b333, 0xf5c28f5c3d70a3d8,
  0xffffbbbc44448888, 0xe4b17e4b4e81b4e9,
  0xffff7bbcc4460885, 0xcb17e4b2681b4e82,
  0xffff3bbd44470883, 0xb17e4b194e81b4e8,
  0xffffd555aaaad555, 0xeeeeeeef11111112,
  0xffff95562aac5552, 0xd55555562aaaaaab,
  0xffff5556aaad5550, 0xbbbbbbbd11111111,
  0xffff15572aadd54f, 0xa2222223c4444444,
  0xffffc00080017ffd, 0xe66666671999999a,
  0xffff800100027ffb, 0xccccccce00000000,
  0xffff40018002fffa, 0xb3333334b3333333,
  0xffff80010002fffa, 0xccccccce33333333,
  0xffffc0008000fffe, 0xe6666666e6666667,
  0xffff800100017ffd, 0xcccccccd9999999a,
  0xffffc00080017ffd, 0xe66666671999999a,
  0x000000000000fffe, 0x0000000066666667,
  0xffffc00080007fff, 0xe6666666b3333334,
  0x0000000000007fff, 0x0000000033333334,
  0x00003fff80000000, 0x1999999980000001,
  0x00006aa9d555aaaa, 0x2aaaaaaaa2222223,
  0x00003fff80000000, 0x1999999980000001,
  0x00007ffeffff8001, 0x33333332ccccccce,
  0x0000aaa955552aab, 0x44444443eeeeeef0,
  0x0000c442bbbbf777, 0x4e81b4e7e4b17e4c,
  0x00003fff7fff8001, 0x199999994cccccce,
  0x00006aa9d5552aab, 0x2aaaaaaa6eeeeef0,
  0x000084433bbbf777, 0x34e81b4e64b17e4c,
  0x000084437bbb7777, 0x34e834e7fe4afe4c,
  0x00002aaa5555aaaa, 0x1111111122222223,
  0x00004443bbbc7776, 0x1b4e81b517e4b17f,
  0x00004443fbbbf776, 0x1b4e9b4eb17e317f,
  0x000044443bbaf777, 0x1b4eb4e817e47e4c,
  0x000019996666cccc, 0x0a3d70a3f5c28f5d,
  0x00001999a6664ccc, 0x0a3d8a3d8f5c0f5d,
  0x00001999e6654ccd, 0x0a3da3d6f5c25c2a,
  0x0000199a2663cccf, 0x0a3dbd7028f575c4,
  0x000000003fff8000, 0x0000199999998001,
  0x000000007ffe8001, 0x00003332ffffccce,
  0x00000000bffd0003, 0x00004ccc3332e668,
  0x00000000fffb0006, 0x000066653332cccf,
  0x000000003fff0001, 0x0000199966664cce,
  0x000000007ffd8003, 0x0000333299996668,
  0x00000000bffb8006, 0x00004ccb99994ccf,
  0x00000000c03b7f86, 0x00004ce53332e64f,
  0x000000003ffe8002, 0x000019993333199b,
  0x000000007ffc8005, 0x0000333233330002,
  0x00000000803c7f85, 0x0000334bcccc9982,
  0x00000000807bff06, 0x000033653332ffcf,
  0x000000003ffe0003, 0x00001998ffffe668,
  0x00000000403dff83, 0x000019b299997fe8,
  0x00000000407d7f04, 0x000019cbffffe635,
  0x0000000040bc7e86, 0x000019e53333194f,
  0x00000000003fff80, 0x0000001999999981,
  0x00000000007f7f01, 0x00000032ffffffce,
  0x0000000000be7e83, 0x0000004c333332e8,
  0x0000000000fcfe06, 0x00000065333332cf,
  0x00000000003f7f81, 0x000000196666664e,
  0x00000000007e7f03, 0x0000003299999968,
  0x0000000000bcfe86, 0x0000004b9999994f,
  0x0000000000ccfe66, 0x00000051ffffffaf,
  0x00000000003eff82, 0x000000193333331b,
  0x00000000007d7f05, 0x0000003233333302,
  0x00000000008d7ee5, 0x0000003899999962,
  0x00000000008efee2, 0x00000039333332fb,
  0x00000000003e7f83, 0x00000018ffffffe8,
  0x00000000004e7f63, 0x0000001f66666648,
  0x00000000004fff60, 0x0000001fffffffe1,
  0x000000000050ff5e, 0x0000002066666647,
  0x00000000000fffe0, 0x0000000666666661,
  0x0000000000117fdd, 0x00000006fffffffa,
  0x0000000000127fdb, 0x0000000766666660,
  0x000000000012ffda, 0x0000000799999993,
  0x0000000099999999, 0x0000000100000000,
  0x00000000ffffffff, 0x00000001aaaaaaaa,
  0x0000000133333332, 0x00000001ffffffff,
  0x0000000133333332, 0x00000001ffffffff,
  0x0000000066666666, 0x00000000aaaaaaab,
  0x0000000099999999, 0x0000000100000000,
  0x0000000099999999, 0x0000000100000000,
  0x0000000066666666, 0x00000000aaaaaaab,
  0x0000000033333333, 0x0000000055555556,
  0x0000000033333333, 0x0000000055555556,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff9999999a, 0xffffffff55555557,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffcccccccd, 0xffffffffaaaaaaac,
  0xffffffff66666667, 0xffffffff00000002,
  0xfffffff900000007, 0xfffffff455555562,
  0xffffffffcccccccd, 0xffffffffaaaaaaac,
  0xffffffff66666667, 0xffffffff00000002,
  0xfffffff900000007, 0xfffffff455555562,
  0xffffffe000000020, 0xffffffcaaaaaaae1,
  0xffffffff9999999a, 0xffffffff55555557,
  0xfffffff93333333a, 0xfffffff4aaaaaab7,
  0xffffffe033333353, 0xffffffcb00000036,
  0xffffffc700000039, 0xffffffa100000060,
  0xfffffff9999999a0, 0xfffffff555555561,
  0xffffffe0999999b9, 0xffffffcbaaaaaae0,
  0xffffffc76666669f, 0xffffffa1aaaaab0a,
  0xffffffae00000052, 0xffffff77555555df,
  0xffffffe700000019, 0xffffffd655555580,
  0xffffffcdccccccff, 0xffffffac555555aa,
  0xffffffb4666666b2, 0xffffff820000007f,
  0xffffe61b6666804b, 0xffffd4d85555807e,
  0xffffffe6cccccce6, 0xffffffd60000002b,
  0xffffffcd66666699, 0xffffffabaaaaab00,
  0xffffe63466668032, 0xffffd50200002aff,
  0xffffcc9b33336698, 0xffffaa58000055a9,
  0xffffffe6999999b3, 0xffffffd5aaaaaad6,
  0xffffe64d9999b34c, 0xffffd52c00002ad5,
  0xffffccb4666699b2, 0xffffaa820000557f,
  0xffffb31b00004ce5, 0xffff7fd7aaab2ad4,
  0xffffe66700001999, 0xffffd55655558000,
  0xffffcccdccccffff, 0xffffaaac5555aaaa,
  0xffffb3346666b332, 0xffff800200007fff,
  0xf5c24290a3d75709, 0xeeee6ef111119110,
  0xffffe666cccce666, 0xffffd55600002aab,
  0xffffcccd66669999, 0xffffaaabaaab0000,
  0xf5c25c29a3d73d70, 0xeeee999abbbc1111,
  0xe4b14b18b4e84e81, 0xd27cd27e82d882d8,
  0xffffe6669999b333, 0xffffd555aaaad556,
  0xf5c275c2d70a570a, 0xeeeec444bbbbe667,
  0xe4b164b1e81b681b, 0xd27cfd2882d8582e,
  0xcb17cb1901b501b4, 0xa7d2527f02d8582d,
  0xf5c28f5c3d70a3d7, 0xeeeeeeef11111112,
  0xe4b17e4b4e81b4e8, 0xd27d27d2d82d82d9,
  0xcb17e4b2681b4e81, 0xa7d27d29582d82d8,
  0xb17e4b194e81b4e7, 0x7d27d27f82d82d82,
  0xeeeeeeef11111111, 0xe38e38e3c71c71c8,
  0xd55555562aaaaaaa, 0xb8e38e3a471c71c7,
  0xbbbbbbbd11111110, 0x8e38e39071c71c71,
  0xa2222223c4444443, 0x638e38e6471c71c6,
  0xe666666719999999, 0xd555555680000000,
  0xcccccccdffffffff, 0xaaaaaaacaaaaaaaa,
  0xb3333334b3333332, 0x800000027fffffff,
  0xccccccce33333332, 0xaaaaaaacffffffff,
  0xe6666666e6666666, 0xd55555562aaaaaab,
  0xcccccccd99999999, 0xaaaaaaac00000000,
  0xe666666719999999, 0xd555555680000000,
  0x0000000066666666, 0x00000000aaaaaaab,
  0xe6666666b3333333, 0xd5555555d5555556,
  0x0000000033333333, 0x0000000055555556,
  0x1999999980000000, 0x2aaaaaaa80000001,
  0x2aaaaaaaa2222222, 0x471c71c70e38e38f,
  0x1999999980000000, 0x2aaaaaaa80000001,
  0x33333332cccccccd, 0x55555554aaaaaaac,
  0x44444443eeeeeeef, 0x71c71c7138e38e3a,
  0x4e81b4e7e4b17e4b, 0x82d82d827d27d27e,
  0x199999994ccccccd, 0x2aaaaaaa2aaaaaac,
  0x2aaaaaaa6eeeeeef, 0x471c71c6b8e38e3a,
  0x34e81b4e64b17e4b, 0x582d82d7fd27d27e,
  0x34e834e7fe4afe4b, 0x582dad82a7d2527e,
  0x1111111122222222, 0x1c71c71c8e38e38f,
  0x1b4e81b517e4b17e, 0x2d82d82dd27d27d3,
  0x1b4e9b4eb17e317e, 0x2d8302d87d27a7d3,
  0x1b4eb4e817e47e4b, 0x2d832d82d27cd27e,
  0x0a3d70a3f5c28f5c, 0x1111111144444445,
  0x0a3d8a3d8f5c0f5c, 0x11113bbbeeeec445,
  0x0a3da3d6f5c25c29, 0x111166664443eef0,
  0x0a3dbd7028f575c3, 0x111191104443c446,
  0x0000199999998000, 0x00002aaaaaaa8001,
  0x00003332ffffcccd, 0x00005554ffffaaac,
  0x00004ccc3332e667, 0x00007ffeffff8002,
  0x000066653332ccce, 0x0000aaa8aaaa0003,
  0x0000199966664ccd, 0x00002aaa55552aac,
  0x0000333299996667, 0x0000555455550002,
  0x00004ccb99994cce, 0x00007ffdffff8003,
  0x00004ce53332e64e, 0x00008028aaaa2a83,
  0x000019993333199a, 0x00002aa9ffffd557,
  0x0000333233330001, 0x00005553aaaa5558,
  0x0000334bcccc9981, 0x0000557e5554ffd8,
  0x000033653332ffce, 0x000055a8aaaa5503,
  0x00001998ffffe667, 0x00002aa9aaaa8002,
  0x000019b299997fe7, 0x00002ad455552a82,
  0x000019cbffffe634, 0x00002afeaaaa7fad,
  0x000019e53333194e, 0x00002b28aaaa7f83,
  0x0000001999999980, 0x0000002aaaaaaa81,
  0x00000032ffffffcd, 0x00000054ffffffac,
  0x0000004c333332e7, 0x0000007effffff82,
  0x00000065333332ce, 0x000000a8aaaaaa03,
  0x000000196666664d, 0x0000002a5555552c,
  0x0000003299999967, 0x0000005455555502,
  0x0000004b9999994e, 0x0000007dffffff83,
  0x00000051ffffffae, 0x00000088aaaaaa23,
  0x000000193333331a, 0x00000029ffffffd7,
  0x0000003233333301, 0x00000053aaaaaa58,
  0x0000003899999961, 0x0000005e555554f8,
  0x00000039333332fa, 0x0000005f555554f7,
  0x00000018ffffffe7, 0x00000029aaaaaa82,
  0x0000001f66666647, 0x0000003455555522,
  0x0000001fffffffe0, 0x0000003555555521,
  0x0000002066666646, 0x00000035ffffffcb,
  0x0000000666666660, 0x0000000aaaaaaaa1,
  0x00000006fffffff9, 0x0000000baaaaaaa0,
  0x000000076666665f, 0x0000000c5555554a,
  0x0000000799999992, 0x0000000caaaaaa9f,
  0x00000000ffffffff, 0x000000017ffffff8,
  0x00000001aaaaaaa9, 0x000000027ffffff2,
  0x00000001fffffffe, 0x00000002ffffffef,
  0x00000001fffffffe, 0x00000002ffffffef,
  0x00000000aaaaaaaa, 0x00000000fffffffb,
  0x00000000ffffffff, 0x000000017ffffff8,
  0x00000000ffffffff, 0x000000017ffffff8,
  0x00000000aaaaaaaa, 0x00000000fffffffb,
  0x0000000055555555, 0x000000007ffffffe,
  0x0000000055555555, 0x000000007ffffffe,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff55555556, 0xffffffff00000007,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffaaaaaaab, 0xffffffff80000004,
  0xffffffff00000001, 0xfffffffe8000000a,
  0xfffffff455555561, 0xffffffee8000006a,
  0xffffffffaaaaaaab, 0xffffffff80000004,
  0xffffffff00000001, 0xfffffffe8000000a,
  0xfffffff455555561, 0xffffffee8000006a,
  0xffffffcaaaaaaae0, 0xffffffb0000001e1,
  0xffffffff55555556, 0xffffffff00000007,
  0xfffffff4aaaaaab6, 0xffffffef00000067,
  0xffffffcb00000035, 0xffffffb0800001de,
  0xffffffa10000005f, 0xffffff7180000358,
  0xfffffff555555560, 0xfffffff000000061,
  0xffffffcbaaaaaadf, 0xffffffb1800001d8,
  0xffffffa1aaaaab09, 0xffffff7280000352,
  0xffffff77555555de, 0xffffff33000004cf,
  0xffffffd65555557f, 0xffffffc180000178,
  0xffffffac555555a9, 0xffffff82800002f2,
  0xffffff820000007e, 0xffffff430000046f,
  0xffffd4d85555807d, 0xffffbf4480018466,
  0xffffffd60000002a, 0xffffffc10000017b,
  0xffffffabaaaaaaff, 0xffffff81800002f8,
  0xffffd50200002afe, 0xffffbf83000182ef,
  0xffffaa58000055a8, 0xffff7f84000302e9,
  0xffffffd5aaaaaad5, 0xffffffc08000017e,
  0xffffd52c00002ad4, 0xffffbfc200018175,
  0xffffaa820000557e, 0xffff7fc30003016f,
  0xffff7fd7aaab2ad3, 0xffff3fc38004816c,
  0xffffd55655557fff, 0xffffc00180017ff8,
  0xffffaaac5555aaa9, 0xffff80028002fff2,
  0xffff800200007ffe, 0xffff400300047fef,
  0xeeee6ef11111910f, 0xe665a66a199e1988,
  0xffffd55600002aaa, 0xffffc00100017ffb,
  0xffffaaabaaaaffff, 0xffff80018002fff8,
  0xeeee999abbbc1110, 0xe665e668999c9991,
  0xd27cd27e82d882d7, 0xbbbb3bbf199c9990,
  0xffffd555aaaad555, 0xffffc00080017ffe,
  0xeeeec444bbbbe666, 0xe6662667999b1997,
  0xd27cfd2882d8582d, 0xbbbb7bbe199b1996,
  0xa7d2527f02d8582c, 0x7bbb7bc1199b198d,
  0xeeeeeeef11111111, 0xe66666671999999a,
  0xd27d27d2d82d82d8, 0xbbbbbbbd99999999,
  0xa7d27d29582d82d7, 0x7bbbbbc099999990,
  0x7d27d27f82d82d81, 0x3bbbbbc31999998a,
  0xe38e38e3c71c71c7, 0xd555555680000000,
  0xb8e38e3a471c71c6, 0x955555597ffffff7,
  0x8e38e39071c71c70, 0x5555555bfffffff1,
  0x638e38e6471c71c5, 0x1555555dffffffee,
  0xd55555567fffffff, 0xc0000002fffffff8,
  0xaaaaaaacaaaaaaa9, 0x800000057ffffff2,
  0x800000027ffffffe, 0x400000077fffffef,
  0xaaaaaaacfffffffe, 0x80000005ffffffef,
  0xd55555562aaaaaaa, 0xc00000027ffffffb,
  0xaaaaaaabffffffff, 0x800000047ffffff8,
  0xd55555567fffffff, 0xc0000002fffffff8,
  0x00000000aaaaaaaa, 0x00000000fffffffb,
  0xd5555555d5555555, 0xc0000001fffffffe,
  0x0000000055555555, 0x000000007ffffffe,
  0x2aaaaaaa80000000, 0x3ffffffe80000001,
  0x471c71c70e38e38e, 0x6aaaaaa87fffffff,
  0x2aaaaaaa80000000, 0x3ffffffe80000001,
  0x55555554aaaaaaab, 0x7ffffffc80000004,
  0x71c71c7138e38e39, 0xaaaaaaa680000002,
  0x82d82d827d27d27d, 0xc444443fe6666666,
  0x2aaaaaaa2aaaaaab, 0x3ffffffe00000004,
  0x471c71c6b8e38e39, 0x6aaaaaa800000002,
  0x582d82d7fd27d27d, 0x8444444166666666,
  0x582dad82a7d2527d, 0x844484416664e666,
  0x1c71c71c8e38e38e, 0x2aaaaaa9ffffffff,
  0x2d82d82dd27d27d2, 0x4444444366666663,
  0x2d8302d87d27a7d2, 0x444484436664e663,
  0x2d832d82d27cd27d, 0x4444c442e6636666,
  0x1111111144444444, 0x1999999966666665,
  0x11113bbbeeeec444, 0x1999d9996664e665,
  0x111166664443eeef, 0x199a1998e6636668,
  0x111191104443c445, 0x199a5997e661e66e,
  0x00002aaaaaaa8000, 0x00003ffffffe8001,
  0x00005554ffffaaab, 0x00007fff7ffd0004,
  0x00007ffeffff8001, 0x0000bffe7ffb800a,
  0x0000aaa8aaaa0002, 0x0000fffcfffa0013,
  0x00002aaa55552aab, 0x00003fff7ffe8004,
  0x0000555455550001, 0x00007ffe7ffd000a,
  0x00007ffdffff8002, 0x0000bffcfffb8013,
  0x00008028aaaa2a82, 0x0000c03cfffb7e93,
  0x00002aa9ffffd556, 0x00003ffefffe8007,
  0x00005553aaaa5557, 0x00007ffd7ffd0010,
  0x0000557e5554ffd7, 0x0000803d7ffcfe90,
  0x000055a8aaaa5502, 0x0000807cfffcfd13,
  0x00002aa9aaaa8001, 0x00003ffe7ffe800a,
  0x00002ad455552a81, 0x0000403e7ffe7e8a,
  0x00002afeaaaa7fac, 0x0000407dfffe7d0d,
  0x00002b28aaaa7f82, 0x000040bcfffe7b93,
  0x0000002aaaaaaa80, 0x0000003ffffffe81,
  0x00000054ffffffab, 0x0000007f7ffffd04,
  0x0000007effffff81, 0x000000be7ffffb8a,
  0x000000a8aaaaaa02, 0x000000fcfffffa13,
  0x0000002a5555552b, 0x0000003f7ffffe84,
  0x0000005455555501, 0x0000007e7ffffd0a,
  0x0000007dffffff82, 0x000000bcfffffb93,
  0x00000088aaaaaa22, 0x000000ccfffffb33,
  0x00000029ffffffd6, 0x0000003efffffe87,
  0x00000053aaaaaa57, 0x0000007d7ffffd10,
  0x0000005e555554f7, 0x0000008d7ffffcb0,
  0x0000005f555554f6, 0x0000008efffffca7,
  0x00000029aaaaaa81, 0x0000003e7ffffe8a,
  0x0000003455555521, 0x0000004e7ffffe2a,
  0x0000003555555520, 0x0000004ffffffe21,
  0x00000035ffffffca, 0x00000050fffffe1b,
  0x0000000aaaaaaaa0, 0x0000000fffffffa1,
  0x0000000baaaaaa9f, 0x000000117fffff98,
  0x0000000c55555549, 0x000000127fffff92,
  0x0000000caaaaaa9e, 0x00000012ffffff8f,
  0x000000017ffffff7, 0x000000017ffffffb,
  0x000000027ffffff1, 0x000000027ffffff7,
  0x00000002ffffffee, 0x00000002fffffff5,
  0x00000002ffffffee, 0x00000002fffffff5,
  0x00000000fffffffa, 0x00000000fffffffd,
  0x000000017ffffff7, 0x000000017ffffffb,
  0x000000017ffffff7, 0x000000017ffffffb,
  0x00000000fffffffa, 0x00000000fffffffd,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffd, 0x000000007fffffff,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00000006, 0xffffffff00000005,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff80000003, 0xffffffff80000003,
  0xfffffffe80000009, 0xfffffffe80000007,
  0xffffffee80000069, 0xffffffee80000047,
  0xffffffff80000003, 0xffffffff80000003,
  0xfffffffe80000009, 0xfffffffe80000007,
  0xffffffee80000069, 0xffffffee80000047,
  0xffffffb0000001e0, 0xffffffb000000141,
  0xffffffff00000006, 0xffffffff00000005,
  0xffffffef00000066, 0xffffffef00000045,
  0xffffffb0800001dd, 0xffffffb08000013f,
  0xffffff7180000357, 0xffffff718000023b,
  0xfffffff000000060, 0xfffffff000000041,
  0xffffffb1800001d7, 0xffffffb18000013b,
  0xffffff7280000351, 0xffffff7280000237,
  0xffffff33000004ce, 0xffffff3300000335,
  0xffffffc180000177, 0xffffffc1800000fb,
  0xffffff82800002f1, 0xffffff82800001f7,
  0xffffff430000046e, 0xffffff43000002f5,
  0xffffbf4480018465, 0xffffbf44800102ef,
  0xffffffc10000017a, 0xffffffc1000000fd,
  0xffffff81800002f7, 0xffffff81800001fb,
  0xffffbf83000182ee, 0xffffbf83000101f5,
  0xffff7f84000302e8, 0xffff7f84000201f1,
  0xffffffc08000017d, 0xffffffc0800000ff,
  0xffffbfc200018174, 0xffffbfc2000100f9,
  0xffff7fc30003016e, 0xffff7fc3000200f5,
  0xffff3fc38004816b, 0xffff3fc3800300f3,
  0xffffc00180017ff7, 0xffffc0018000fffb,
  0xffff80028002fff1, 0xffff80028001fff7,
  0xffff400300047fee, 0xffff40030002fff5,
  0xe665a66a199e1987, 0xe665a669e669665b,
  0xffffc00100017ffa, 0xffffc0010000fffd,
  0xffff80018002fff7, 0xffff80018001fffb,
  0xe665e668999c9990, 0xe665e66866686661,
  0xbbbb3bbf199c998f, 0xbbbb3bbe9113110b,
  0xffffc00080017ffd, 0xffffc0008000ffff,
  0xe6662667999b1996, 0xe666266766676665,
  0xbbbb7bbe199b1995, 0xbbbb7bbd9112110f,
  0x7bbb7bc1199b198c, 0x7bbb7bc011121109,
  0xe666666719999999, 0xe6666666e6666667,
  0xbbbbbbbd99999998, 0xbbbbbbbd11111111,
  0x7bbbbbc09999998f, 0x7bbbbbbf9111110b,
  0x3bbbbbc319999989, 0x3bbbbbc191111107,
  0xd55555567fffffff, 0xd55555562aaaaaab,
  0x955555597ffffff6, 0x95555558aaaaaaa5,
  0x5555555bfffffff0, 0x5555555aaaaaaaa1,
  0x1555555dffffffed, 0x1555555c2aaaaa9f,
  0xc0000002fffffff7, 0xc00000027ffffffb,
  0x800000057ffffff1, 0x800000047ffffff7,
  0x400000077fffffee, 0x40000005fffffff5,
  0x80000005ffffffee, 0x80000004fffffff5,
  0xc00000027ffffffa, 0xc0000001fffffffd,
  0x800000047ffffff7, 0x800000037ffffffb,
  0xc0000002fffffff7, 0xc00000027ffffffb,
  0x00000000fffffffa, 0x00000000fffffffd,
  0xc0000001fffffffd, 0xc00000017fffffff,
  0x000000007ffffffd, 0x000000007fffffff,
  0x3ffffffe80000000, 0x3fffffff00000001,
  0x6aaaaaa87ffffffe, 0x6aaaaaa955555555,
  0x3ffffffe80000000, 0x3fffffff00000001,
  0x7ffffffc80000003, 0x7ffffffd80000003,
  0xaaaaaaa680000001, 0xaaaaaaa7d5555557,
  0xc444443fe6666665, 0xc44444416eeeeeef,
  0x3ffffffe00000003, 0x3ffffffe80000003,
  0x6aaaaaa800000001, 0x6aaaaaa8d5555557,
  0x8444444166666665, 0x844444426eeeeeef,
  0x844484416664e665, 0x844484426eedeeef,
  0x2aaaaaa9fffffffe, 0x2aaaaaaa55555555,
  0x4444444366666662, 0x44444443eeeeeeed,
  0x444484436664e662, 0x44448443eeedeeed,
  0x4444c442e6636665, 0x4444c4436eeceeef,
  0x1999999966666664, 0x1999999999999999,
  0x1999d9996664e664, 0x1999d99999989999,
  0x199a1998e6636667, 0x199a19991997999b,
  0x199a5997e661e66d, 0x199a59981996999f,
  0x00003ffffffe8000, 0x00003fffffff0001,
  0x00007fff7ffd0003, 0x00007fff7ffe0003,
  0x0000bffe7ffb8009, 0x0000bffe7ffd0007,
  0x0000fffcfffa0012, 0x0000fffcfffc000d,
  0x00003fff7ffe8003, 0x00003fff7fff0003,
  0x00007ffe7ffd0009, 0x00007ffe7ffe0007,
  0x0000bffcfffb8012, 0x0000bffcfffd000d,
  0x0000c03cfffb7e92, 0x0000c03cfffcff0d,
  0x00003ffefffe8006, 0x00003ffeffff0005,
  0x00007ffd7ffd000f, 0x00007ffd7ffe000b,
  0x0000803d7ffcfe8f, 0x0000803d7ffdff0b,
  0x0000807cfffcfd12, 0x0000807cfffdfe0d,
  0x00003ffe7ffe8009, 0x00003ffe7fff0007,
  0x0000403e7ffe7e89, 0x0000403e7ffeff07,
  0x0000407dfffe7d0c, 0x0000407dfffefe09,
  0x000040bcfffe7b92, 0x000040bcfffefd0d,
  0x0000003ffffffe80, 0x0000003fffffff01,
  0x0000007f7ffffd03, 0x0000007f7ffffe03,
  0x000000be7ffffb89, 0x000000be7ffffd07,
  0x000000fcfffffa12, 0x000000fcfffffc0d,
  0x0000003f7ffffe83, 0x0000003f7fffff03,
  0x0000007e7ffffd09, 0x0000007e7ffffe07,
  0x000000bcfffffb92, 0x000000bcfffffd0d,
  0x000000ccfffffb32, 0x000000ccfffffccd,
  0x0000003efffffe86, 0x0000003effffff05,
  0x0000007d7ffffd0f, 0x0000007d7ffffe0b,
  0x0000008d7ffffcaf, 0x0000008d7ffffdcb,
  0x0000008efffffca6, 0x0000008efffffdc5,
  0x0000003e7ffffe89, 0x0000003e7fffff07,
  0x0000004e7ffffe29, 0x0000004e7ffffec7,
  0x0000004ffffffe20, 0x0000004ffffffec1,
  0x00000050fffffe1a, 0x00000050fffffebd,
  0x0000000fffffffa0, 0x0000000fffffffc1,
  0x000000117fffff97, 0x000000117fffffbb,
  0x000000127fffff91, 0x000000127fffffb7,
  0x00000012ffffff8e, 0x00000012ffffffb5,
  0x000000017ffffffa, 0x000000017ffffffe,
  0x000000027ffffff6, 0x000000027ffffffc,
  0x00000002fffffff4, 0x00000002fffffffb,
  0x00000002fffffff4, 0x00000002fffffffb,
  0x00000000fffffffc, 0x00000000ffffffff,
  0x000000017ffffffa, 0x000000017ffffffe,
  0x000000017ffffffa, 0x000000017ffffffe,
  0x00000000fffffffc, 0x00000000ffffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007ffffffe, 0x0000000080000000,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00000004, 0xffffffff00000003,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff80000002, 0xffffffff80000002,
  0xfffffffe80000006, 0xfffffffe80000004,
  0xffffffee80000046, 0xffffffee80000024,
  0xffffffff80000002, 0xffffffff80000002,
  0xfffffffe80000006, 0xfffffffe80000004,
  0xffffffee80000046, 0xffffffee80000024,
  0xffffffb000000140, 0xffffffb0000000a1,
  0xffffffff00000004, 0xffffffff00000003,
  0xffffffef00000044, 0xffffffef00000023,
  0xffffffb08000013e, 0xffffffb0800000a0,
  0xffffff718000023a, 0xffffff718000011e,
  0xfffffff000000040, 0xfffffff000000021,
  0xffffffb18000013a, 0xffffffb18000009e,
  0xffffff7280000236, 0xffffff728000011c,
  0xffffff3300000334, 0xffffff330000019b,
  0xffffffc1800000fa, 0xffffffc18000007e,
  0xffffff82800001f6, 0xffffff82800000fc,
  0xffffff43000002f4, 0xffffff430000017b,
  0xffffbf44800102ee, 0xffffbf4480008178,
  0xffffffc1000000fc, 0xffffffc10000007f,
  0xffffff81800001fa, 0xffffff81800000fe,
  0xffffbf83000101f4, 0xffffbf83000080fb,
  0xffff7f84000201f0, 0xffff7f84000100f9,
  0xffffffc0800000fe, 0xffffffc080000080,
  0xffffbfc2000100f8, 0xffffbfc20000807d,
  0xffff7fc3000200f4, 0xffff7fc30001007b,
  0xffff3fc3800300f2, 0xffff3fc38001807a,
  0xffffc0018000fffa, 0xffffc00180007ffe,
  0xffff80028001fff6, 0xffff80028000fffc,
  0xffff40030002fff4, 0xffff400300017ffb,
  0xe665a669e669665a, 0xe665a669b334b32e,
  0xffffc0010000fffc, 0xffffc00100007fff,
  0xffff80018001fffa, 0xffff80018000fffe,
  0xe665e66866686660, 0xe665e66833343331,
  0xbbbb3bbe9113110a, 0xbbbb3bbe08898886,
  0xffffc0008000fffe, 0xffffc00080008000,
  0xe666266766676664, 0xe66626673333b333,
  0xbbbb7bbd9112110e, 0xbbbb7bbd08890888,
  0x7bbb7bc011121108, 0x7bbb7bbf08890885,
  0xe6666666e6666666, 0xe6666666b3333334,
  0xbbbbbbbd11111110, 0xbbbbbbbc88888889,
  0x7bbbbbbf9111110a, 0x7bbbbbbe88888886,
  0x3bbbbbc191111106, 0x3bbbbbc008888884,
  0xd55555562aaaaaaa, 0xd5555555d5555556,
  0x95555558aaaaaaa4, 0x95555557d5555553,
  0x5555555aaaaaaaa0, 0x5555555955555551,
  0x1555555c2aaaaa9e, 0x1555555a55555550,
  0xc00000027ffffffa, 0xc0000001fffffffe,
  0x800000047ffffff6, 0x800000037ffffffc,
  0x40000005fffffff4, 0x400000047ffffffb,
  0x80000004fffffff4, 0x80000003fffffffb,
  0xc0000001fffffffc, 0xc00000017fffffff,
  0x800000037ffffffa, 0x800000027ffffffe,
  0xc00000027ffffffa, 0xc0000001fffffffe,
  0x00000000fffffffc, 0x00000000ffffffff,
  0xc00000017ffffffe, 0xc000000100000000,
  0x000000007ffffffe, 0x0000000080000000,
  0x3fffffff00000000, 0x3fffffff80000001,
  0x6aaaaaa955555554, 0x6aaaaaaa2aaaaaab,
  0x3fffffff00000000, 0x3fffffff80000001,
  0x7ffffffd80000002, 0x7ffffffe80000002,
  0xaaaaaaa7d5555556, 0xaaaaaaa92aaaaaac,
  0xc44444416eeeeeee, 0xc4444442f7777778,
  0x3ffffffe80000002, 0x3fffffff00000002,
  0x6aaaaaa8d5555556, 0x6aaaaaa9aaaaaaac,
  0x844444426eeeeeee, 0x8444444377777778,
  0x844484426eedeeee, 0x844484437776f778,
  0x2aaaaaaa55555554, 0x2aaaaaaaaaaaaaab,
  0x44444443eeeeeeec, 0x4444444477777777,
  0x44448443eeedeeec, 0x444484447776f777,
  0x4444c4436eeceeee, 0x4444c443f7767778,
  0x1999999999999998, 0x19999999cccccccd,
  0x1999d99999989998, 0x1999d999cccc4ccd,
  0x199a19991997999a, 0x199a19994ccbccce,
  0x199a59981996999e, 0x199a59984ccb4cd0,
  0x00003fffffff0000, 0x00003fffffff8001,
  0x00007fff7ffe0002, 0x00007fff7fff0002,
  0x0000bffe7ffd0006, 0x0000bffe7ffe8004,
  0x0000fffcfffc000c, 0x0000fffcfffe0007,
  0x00003fff7fff0002, 0x00003fff7fff8002,
  0x00007ffe7ffe0006, 0x00007ffe7fff0004,
  0x0000bffcfffd000c, 0x0000bffcfffe8007,
  0x0000c03cfffcff0c, 0x0000c03cfffe7f87,
  0x00003ffeffff0004, 0x00003ffeffff8003,
  0x00007ffd7ffe000a, 0x00007ffd7fff0006,
  0x0000803d7ffdff0a, 0x0000803d7ffeff86,
  0x0000807cfffdfe0c, 0x0000807cfffeff07,
  0x00003ffe7fff0006, 0x00003ffe7fff8004,
  0x0000403e7ffeff06, 0x0000403e7fff7f84,
  0x0000407dfffefe08, 0x0000407dffff7f05,
  0x000040bcfffefd0c, 0x000040bcffff7e87,
  0x0000003fffffff00, 0x0000003fffffff81,
  0x0000007f7ffffe02, 0x0000007f7fffff02,
  0x000000be7ffffd06, 0x000000be7ffffe84,
  0x000000fcfffffc0c, 0x000000fcfffffe07,
  0x0000003f7fffff02, 0x0000003f7fffff82,
  0x0000007e7ffffe06, 0x0000007e7fffff04,
  0x000000bcfffffd0c, 0x000000bcfffffe87,
  0x000000ccfffffccc, 0x000000ccfffffe67,
  0x0000003effffff04, 0x0000003effffff83,
  0x0000007d7ffffe0a, 0x0000007d7fffff06,
  0x0000008d7ffffdca, 0x0000008d7ffffee6,
  0x0000008efffffdc4, 0x0000008efffffee3,
  0x0000003e7fffff06, 0x0000003e7fffff84,
  0x0000004e7ffffec6, 0x0000004e7fffff64,
  0x0000004ffffffec0, 0x0000004fffffff61,
  0x00000050fffffebc, 0x00000050ffffff5f,
  0x0000000fffffffc0, 0x0000000fffffffe1,
  0x000000117fffffba, 0x000000117fffffde,
  0x000000127fffffb6, 0x000000127fffffdc,
  0x00000012ffffffb4, 0x00000012ffffffdb,
  0x000000017ffffffd, 0xfffffffe80000001,
  0x000000027ffffffb, 0xfffffffd80000001,
  0x00000002fffffffa, 0xfffffffd00000001,
  0x00000002fffffffa, 0xfffffffd00000001,
  0x00000000fffffffe, 0xffffffff00000001,
  0x000000017ffffffd, 0xfffffffe80000001,
  0x000000017ffffffd, 0xfffffffe80000001,
  0x00000000fffffffe, 0xffffffff00000001,
  0x000000007fffffff, 0xffffffff80000001,
  0x000000007fffffff, 0xffffffff80000001,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00000002, 0x0000000100000001,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff80000001, 0x0000000080000001,
  0xfffffffe80000003, 0x0000000180000001,
  0xffffffee80000023, 0x0000001180000001,
  0xffffffff80000001, 0x0000000080000001,
  0xfffffffe80000003, 0x0000000180000001,
  0xffffffee80000023, 0x0000001180000001,
  0xffffffb0000000a0, 0x0000005000000001,
  0xffffffff00000002, 0x0000000100000001,
  0xffffffef00000022, 0x0000001100000001,
  0xffffffb08000009f, 0x0000004f80000001,
  0xffffff718000011d, 0x0000008e80000001,
  0xfffffff000000020, 0x0000001000000001,
  0xffffffb18000009d, 0x0000004e80000001,
  0xffffff728000011b, 0x0000008d80000001,
  0xffffff330000019a, 0x000000cd00000001,
  0xffffffc18000007d, 0x0000003e80000001,
  0xffffff82800000fb, 0x0000007d80000001,
  0xffffff430000017a, 0x000000bd00000001,
  0xffffbf4480008177, 0x000040bb80000001,
  0xffffffc10000007e, 0x0000003f00000001,
  0xffffff81800000fd, 0x0000007e80000001,
  0xffffbf83000080fa, 0x0000407d00000001,
  0xffff7f84000100f8, 0x0000807c00000001,
  0xffffffc08000007f, 0x0000003f80000001,
  0xffffbfc20000807c, 0x0000403e00000001,
  0xffff7fc30001007a, 0x0000803d00000001,
  0xffff3fc380018079, 0x0000c03c80000001,
  0xffffc00180007ffd, 0x00003ffe80000001,
  0xffff80028000fffb, 0x00007ffd80000001,
  0xffff400300017ffa, 0x0000bffd00000001,
  0xe665a669b334b32d, 0x199a599680000001,
  0xffffc00100007ffe, 0x00003fff00000001,
  0xffff80018000fffd, 0x00007ffe80000001,
  0xe665e66833343330, 0x199a199800000001,
  0xbbbb3bbe08898885, 0x4444c44280000001,
  0xffffc00080007fff, 0x00003fff80000001,
  0xe66626673333b332, 0x1999d99900000001,
  0xbbbb7bbd08890887, 0x4444844380000001,
  0x7bbb7bbf08890884, 0x8444844200000001,
  0xe6666666b3333333, 0x1999999980000001,
  0xbbbbbbbc88888888, 0x4444444400000001,
  0x7bbbbbbe88888885, 0x8444444280000001,
  0x3bbbbbc008888883, 0xc444444180000001,
  0xd5555555d5555555, 0x2aaaaaaa80000001,
  0x95555557d5555552, 0x6aaaaaa900000001,
  0x5555555955555550, 0xaaaaaaa800000001,
  0x1555555a5555554f, 0xeaaaaaa780000001,
  0xc0000001fffffffd, 0x3ffffffe80000001,
  0x800000037ffffffb, 0x7ffffffd80000001,
  0x400000047ffffffa, 0xbffffffd00000001,
  0x80000003fffffffa, 0x7ffffffd00000001,
  0xc00000017ffffffe, 0x3fffffff00000001,
  0x800000027ffffffd, 0x7ffffffe80000001,
  0xc0000001fffffffd, 0x3ffffffe80000001,
  0x00000000fffffffe, 0xffffffff00000001,
  0xc0000000ffffffff, 0x3fffffff80000001,
  0x000000007fffffff, 0xffffffff80000001,
  0x3fffffff80000000, 0xc000000000000001,
  0x6aaaaaaa2aaaaaaa, 0x9555555500000001,
  0x3fffffff80000000, 0xc000000000000001,
  0x7ffffffe80000001, 0x8000000080000001,
  0xaaaaaaa92aaaaaab, 0x5555555580000001,
  0xc4444442f7777777, 0x3bbbbbbb80000001,
  0x3fffffff00000001, 0xc000000080000001,
  0x6aaaaaa9aaaaaaab, 0x9555555580000001,
  0x8444444377777777, 0x7bbbbbbb80000001,
  0x844484437776f777, 0x7bbb7bbb80000001,
  0x2aaaaaaaaaaaaaaa, 0xd555555500000001,
  0x4444444477777776, 0xbbbbbbbb00000001,
  0x444484447776f776, 0xbbbb7bbb00000001,
  0x4444c443f7767777, 0xbbbb3bbb80000001,
  0x19999999cccccccc, 0xe666666600000001,
  0x1999d999cccc4ccc, 0xe666266600000001,
  0x199a19994ccbcccd, 0xe665e66680000001,
  0x199a59984ccb4ccf, 0xe665a66780000001,
  0x00003fffffff8000, 0xffffc00000000001,
  0x00007fff7fff0001, 0xffff800080000001,
  0x0000bffe7ffe8003, 0xffff400180000001,
  0x0000fffcfffe0006, 0xffff000300000001,
  0x00003fff7fff8001, 0xffffc00080000001,
  0x00007ffe7fff0003, 0xffff800180000001,
  0x0000bffcfffe8006, 0xffff400300000001,
  0x0000c03cfffe7f86, 0xffff3fc300000001,
  0x00003ffeffff8002, 0xffffc00100000001,
  0x00007ffd7fff0005, 0xffff800280000001,
  0x0000803d7ffeff85, 0xffff7fc280000001,
  0x0000807cfffeff06, 0xffff7f8300000001,
  0x00003ffe7fff8003, 0xffffc00180000001,
  0x0000403e7fff7f83, 0xffffbfc180000001,
  0x0000407dffff7f04, 0xffffbf8200000001,
  0x000040bcffff7e86, 0xffffbf4300000001,
  0x0000003fffffff80, 0xffffffc000000001,
  0x0000007f7fffff01, 0xffffff8080000001,
  0x000000be7ffffe83, 0xffffff4180000001,
  0x000000fcfffffe06, 0xffffff0300000001,
  0x0000003f7fffff81, 0xffffffc080000001,
  0x0000007e7fffff03, 0xffffff8180000001,
  0x000000bcfffffe86, 0xffffff4300000001,
  0x000000ccfffffe66, 0xffffff3300000001,
  0x0000003effffff82, 0xffffffc100000001,
  0x0000007d7fffff05, 0xffffff8280000001,
  0x0000008d7ffffee5, 0xffffff7280000001,
  0x0000008efffffee2, 0xffffff7100000001,
  0x0000003e7fffff83, 0xffffffc180000001,
  0x0000004e7fffff63, 0xffffffb180000001,
  0x0000004fffffff60, 0xffffffb000000001,
  0x00000050ffffff5e, 0xffffffaf00000001,
  0x0000000fffffffe0, 0xfffffff000000001,
  0x000000117fffffdd, 0xffffffee80000001,
  0x000000127fffffdb, 0xffffffed80000001,
  0x00000012ffffffda, 0xffffffed00000001,
  0xfffffffe80000000, 0xfffffffe80000004,
  0xfffffffd80000000, 0xfffffffd80000006,
  0xfffffffd00000000, 0xfffffffd00000007,
  0xfffffffd00000000, 0xfffffffd00000007,
  0xffffffff00000000, 0xffffffff00000003,
  0xfffffffe80000000, 0xfffffffe80000004,
  0xfffffffe80000000, 0xfffffffe80000004,
  0xffffffff00000000, 0xffffffff00000003,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000000, 0xffffffff80000002,
  0x0000000000000000, 0x0000000000000001,
  0x0000000100000000, 0x00000000ffffffff,
  0x0000000000000000, 0x0000000000000001,
  0x0000000080000000, 0x0000000080000000,
  0x0000000180000000, 0x000000017ffffffe,
  0x0000001180000000, 0x000000117fffffde,
  0x0000000080000000, 0x0000000080000000,
  0x0000000180000000, 0x000000017ffffffe,
  0x0000001180000000, 0x000000117fffffde,
  0x0000005000000000, 0x0000004fffffff61,
  0x0000000100000000, 0x00000000ffffffff,
  0x0000001100000000, 0x00000010ffffffdf,
  0x0000004f80000000, 0x0000004f7fffff62,
  0x0000008e80000000, 0x0000008e7ffffee4,
  0x0000001000000000, 0x0000000fffffffe1,
  0x0000004e80000000, 0x0000004e7fffff64,
  0x0000008d80000000, 0x0000008d7ffffee6,
  0x000000cd00000000, 0x000000ccfffffe67,
  0x0000003e80000000, 0x0000003e7fffff84,
  0x0000007d80000000, 0x0000007d7fffff06,
  0x000000bd00000000, 0x000000bcfffffe87,
  0x000040bb80000000, 0x000040bb7fff7e8a,
  0x0000003f00000000, 0x0000003effffff83,
  0x0000007e80000000, 0x0000007e7fffff04,
  0x0000407d00000000, 0x0000407cffff7f07,
  0x0000807c00000000, 0x0000807bfffeff09,
  0x0000003f80000000, 0x0000003f7fffff82,
  0x0000403e00000000, 0x0000403dffff7f85,
  0x0000803d00000000, 0x0000803cfffeff87,
  0x0000c03c80000000, 0x0000c03c7ffe7f88,
  0x00003ffe80000000, 0x00003ffe7fff8004,
  0x00007ffd80000000, 0x00007ffd7fff0006,
  0x0000bffd00000000, 0x0000bffcfffe8007,
  0x199a599680000000, 0x199a59964ccb4cd4,
  0x00003fff00000000, 0x00003ffeffff8003,
  0x00007ffe80000000, 0x00007ffe7fff0004,
  0x199a199800000000, 0x199a1997cccbccd1,
  0x4444c44280000000, 0x4444c441f776777c,
  0x00003fff80000000, 0x00003fff7fff8002,
  0x1999d99900000000, 0x1999d998cccc4ccf,
  0x4444844380000000, 0x44448442f776f77a,
  0x8444844200000000, 0x84448440f776f77d,
  0x1999999980000000, 0x199999994cccccce,
  0x4444444400000000, 0x4444444377777779,
  0x8444444280000000, 0x844444417777777c,
  0xc444444180000000, 0xc444443ff777777e,
  0x2aaaaaaa80000000, 0x2aaaaaaa2aaaaaac,
  0x6aaaaaa900000000, 0x6aaaaaa82aaaaaaf,
  0xaaaaaaa800000000, 0xaaaaaaa6aaaaaab1,
  0xeaaaaaa780000000, 0xeaaaaaa5aaaaaab2,
  0x3ffffffe80000000, 0x3ffffffe00000004,
  0x7ffffffd80000000, 0x7ffffffc80000006,
  0xbffffffd00000000, 0xbffffffb80000007,
  0x7ffffffd00000000, 0x7ffffffc00000007,
  0x3fffffff00000000, 0x3ffffffe80000003,
  0x7ffffffe80000000, 0x7ffffffd80000004,
  0x3ffffffe80000000, 0x3ffffffe00000004,
  0xffffffff00000000, 0xffffffff00000003,
  0x3fffffff80000000, 0x3fffffff00000002,
  0xffffffff80000000, 0xffffffff80000002,
  0xc000000000000000, 0xc000000080000001,
  0x9555555500000000, 0x95555555d5555557,
  0xc000000000000000, 0xc000000080000001,
  0x8000000080000000, 0x8000000180000000,
  0x5555555580000000, 0x55555556d5555556,
  0x3bbbbbbb80000000, 0x3bbbbbbd0888888a,
  0xc000000080000000, 0xc000000100000000,
  0x9555555580000000, 0x9555555655555556,
  0x7bbbbbbb80000000, 0x7bbbbbbc8888888a,
  0x7bbb7bbb80000000, 0x7bbb7bbc8889088a,
  0xd555555500000000, 0xd555555555555557,
  0xbbbbbbbb00000000, 0xbbbbbbbb8888888b,
  0xbbbb7bbb00000000, 0xbbbb7bbb8889088b,
  0xbbbb3bbb80000000, 0xbbbb3bbc0889888a,
  0xe666666600000000, 0xe666666633333335,
  0xe666266600000000, 0xe66626663333b335,
  0xe665e66680000000, 0xe665e666b3343334,
  0xe665a66780000000, 0xe665a667b334b332,
  0xffffc00000000000, 0xffffc00000008001,
  0xffff800080000000, 0xffff800080010000,
  0xffff400180000000, 0xffff400180017ffe,
  0xffff000300000000, 0xffff00030001fffb,
  0xffffc00080000000, 0xffffc00080008000,
  0xffff800180000000, 0xffff80018000fffe,
  0xffff400300000000, 0xffff400300017ffb,
  0xffff3fc300000000, 0xffff3fc30001807b,
  0xffffc00100000000, 0xffffc00100007fff,
  0xffff800280000000, 0xffff80028000fffc,
  0xffff7fc280000000, 0xffff7fc28001007c,
  0xffff7f8300000000, 0xffff7f83000100fb,
  0xffffc00180000000, 0xffffc00180007ffe,
  0xffffbfc180000000, 0xffffbfc18000807e,
  0xffffbf8200000000, 0xffffbf82000080fd,
  0xffffbf4300000000, 0xffffbf430000817b,
  0xffffffc000000000, 0xffffffc000000081,
  0xffffff8080000000, 0xffffff8080000100,
  0xffffff4180000000, 0xffffff418000017e,
  0xffffff0300000000, 0xffffff03000001fb,
  0xffffffc080000000, 0xffffffc080000080,
  0xffffff8180000000, 0xffffff81800000fe,
  0xffffff4300000000, 0xffffff430000017b,
  0xffffff3300000000, 0xffffff330000019b,
  0xffffffc100000000, 0xffffffc10000007f,
  0xffffff8280000000, 0xffffff82800000fc,
  0xffffff7280000000, 0xffffff728000011c,
  0xffffff7100000000, 0xffffff710000011f,
  0xffffffc180000000, 0xffffffc18000007e,
  0xffffffb180000000, 0xffffffb18000009e,
  0xffffffb000000000, 0xffffffb0000000a1,
  0xffffffaf00000000, 0xffffffaf000000a3,
  0xfffffff000000000, 0xfffffff000000021,
  0xffffffee80000000, 0xffffffee80000024,
  0xffffffed80000000, 0xffffffed80000026,
  0xffffffed00000000, 0xffffffed00000027,
  0xfffffffe80000003, 0xfffffffeffffffff,
  0xfffffffd80000005, 0xfffffffe55555553,
  0xfffffffd00000006, 0xfffffffdfffffffd,
  0xfffffffd00000006, 0xfffffffdfffffffd,
  0xffffffff00000002, 0xffffffff55555555,
  0xfffffffe80000003, 0xfffffffeffffffff,
  0xfffffffe80000003, 0xfffffffeffffffff,
  0xffffffff00000002, 0xffffffff55555555,
  0xffffffff80000001, 0xffffffffaaaaaaab,
  0xffffffff80000001, 0xffffffffaaaaaaab,
  0x0000000000000000, 0x0000000000000001,
  0x00000000fffffffe, 0x00000000aaaaaaad,
  0x0000000000000000, 0x0000000000000001,
  0x000000007fffffff, 0x0000000055555557,
  0x000000017ffffffd, 0x0000000100000003,
  0x000000117fffffdd, 0x0000000baaaaaac3,
  0x000000007fffffff, 0x0000000055555557,
  0x000000017ffffffd, 0x0000000100000003,
  0x000000117fffffdd, 0x0000000baaaaaac3,
  0x0000004fffffff60, 0x00000035555555c1,
  0x00000000fffffffe, 0x00000000aaaaaaad,
  0x00000010ffffffde, 0x0000000b5555556d,
  0x0000004f7fffff61, 0x000000350000006b,
  0x0000008e7ffffee3, 0x0000005f000000bf,
  0x0000000fffffffe0, 0x0000000aaaaaaac1,
  0x0000004e7fffff63, 0x00000034555555bf,
  0x0000008d7ffffee5, 0x0000005e55555613,
  0x000000ccfffffe66, 0x00000088aaaaabbd,
  0x0000003e7fffff83, 0x00000029aaaaaaff,
  0x0000007d7fffff05, 0x00000053aaaaab53,
  0x000000bcfffffe86, 0x0000007e000000fd,
  0x000040bb7fff7e89, 0x00002b27aaab00fb,
  0x0000003effffff82, 0x0000002a00000055,
  0x0000007e7fffff03, 0x00000054555555ff,
  0x0000407cffff7f06, 0x00002afe000055fd,
  0x0000807bfffeff08, 0x000055a80000ab51,
  0x0000003f7fffff81, 0x0000002a555555ab,
  0x0000403dffff7f84, 0x00002ad4000055a9,
  0x0000803cfffeff86, 0x0000557e0000aafd,
  0x0000c03c7ffe7f87, 0x00008028555655a7,
  0x00003ffe7fff8003, 0x00002aa9aaaaffff,
  0x00007ffd7fff0005, 0x00005553aaab5553,
  0x0000bffcfffe8006, 0x00007ffe0000fffd,
  0x199a59964ccb4cd3, 0x1111910f2223221f,
  0x00003ffeffff8002, 0x00002aaa00005555,
  0x00007ffe7fff0003, 0x000055545555ffff,
  0x199a1997cccbccd0, 0x1111666577782221,
  0x4444c441f776777b, 0x2d832d8205b105af,
  0x00003fff7fff8001, 0x00002aaa5555aaab,
  0x1999d998cccc4cce, 0x11113bbb7777cccd,
  0x44448442f776f779, 0x2d8302d805b0b05b,
  0x84448440f776f77c, 0x582dad8205b0b059,
  0x199999994ccccccd, 0x1111111122222223,
  0x4444444377777778, 0x2d82d82db05b05b1,
  0x844444417777777b, 0x582d82d7b05b05af,
  0xc444443ff777777d, 0x82d82d8205b05b03,
  0x2aaaaaaa2aaaaaab, 0x1c71c71c8e38e38f,
  0x6aaaaaa82aaaaaae, 0x471c71c68e38e38d,
  0xaaaaaaa6aaaaaab0, 0x71c71c70e38e38e1,
  0xeaaaaaa5aaaaaab1, 0x9c71c71b8e38e38b,
  0x3ffffffe00000003, 0x2aaaaaa9ffffffff,
  0x7ffffffc80000005, 0x5555555455555553,
  0xbffffffb80000006, 0x7ffffffefffffffd,
  0x7ffffffc00000006, 0x55555553fffffffd,
  0x3ffffffe80000002, 0x2aaaaaaa55555555,
  0x7ffffffd80000003, 0x55555554ffffffff,
  0x3ffffffe00000003, 0x2aaaaaa9ffffffff,
  0xffffffff00000002, 0xffffffff55555555,
  0x3fffffff00000001, 0x2aaaaaaaaaaaaaab,
  0xffffffff80000001, 0xffffffffaaaaaaab,
  0xc000000080000000, 0xd555555500000001,
  0x95555555d5555556, 0xb8e38e381c71c71d,
  0xc000000080000000, 0xd555555500000001,
  0x800000017fffffff, 0xaaaaaaaa55555557,
  0x55555556d5555555, 0x8e38e38d71c71c73,
  0x3bbbbbbd08888889, 0x7d27d27bfa4fa4fb,
  0xc0000000ffffffff, 0xd555555555555557,
  0x9555555655555555, 0xb8e38e3871c71c73,
  0x7bbbbbbc88888889, 0xa7d27d26fa4fa4fb,
  0x7bbb7bbc88890889, 0xa7d2527c4fa4a4fb,
  0xd555555555555556, 0xe38e38e31c71c71d,
  0xbbbbbbbb8888888a, 0xd27d27d1a4fa4fa5,
  0xbbbb7bbb8889088a, 0xd27cfd26fa4f4fa5,
  0xbbbb3bbc08898889, 0xd27cd27ca4f9a4fb,
  0xe666666633333334, 0xeeeeeeee88888889,
  0xe66626663333b334, 0xeeeec443dddd8889,
  0xe665e666b3343333, 0xeeee99998887dddf,
  0xe665a667b334b331, 0xeeee6eef8887888b,
  0xffffc00000008000, 0xffffd55555550001,
  0xffff80008000ffff, 0xffffaaaaffff5557,
  0xffff400180017ffd, 0xffff8000ffff0003,
  0xffff00030001fffa, 0xffff555755540005,
  0xffffc00080007fff, 0xffffd555aaaa5557,
  0xffff80018000fffd, 0xffffaaabaaaa0003,
  0xffff400300017ffa, 0xffff8001ffff0005,
  0xffff3fc30001807a, 0xffff7fd755545505,
  0xffffc00100007ffe, 0xffffd555ffffaaad,
  0xffff80028000fffb, 0xffffaaac5554aaaf,
  0xffff7fc28001007b, 0xffffaa81aaa9ffaf,
  0xffff7f83000100fa, 0xffffaa575554aa05,
  0xffffc00180007ffd, 0xffffd55655550003,
  0xffffbfc18000807d, 0xffffd52baaaa5503,
  0xffffbf82000080fc, 0xffffd5015554ff59,
  0xffffbf430000817a, 0xffffd4d75554ff05,
  0xffffffc000000080, 0xffffffd555555501,
  0xffffff80800000ff, 0xffffffaaffffff57,
  0xffffff418000017d, 0xffffff80ffffff03,
  0xffffff03000001fa, 0xffffff5755555405,
  0xffffffc08000007f, 0xffffffd5aaaaaa57,
  0xffffff81800000fd, 0xffffffabaaaaaa03,
  0xffffff430000017a, 0xffffff81ffffff05,
  0xffffff330000019a, 0xffffff7755555445,
  0xffffffc10000007e, 0xffffffd5ffffffad,
  0xffffff82800000fb, 0xffffffac555554af,
  0xffffff728000011b, 0xffffffa1aaaaa9ef,
  0xffffff710000011e, 0xffffffa0aaaaa9ed,
  0xffffffc18000007d, 0xffffffd655555503,
  0xffffffb18000009d, 0xffffffcbaaaaaa43,
  0xffffffb0000000a0, 0xffffffcaaaaaaa41,
  0xffffffaf000000a2, 0xffffffc9ffffff95,
  0xfffffff000000020, 0xfffffff555555541,
  0xffffffee80000023, 0xfffffff45555553f,
  0xffffffed80000025, 0xfffffff3aaaaaa93,
  0xffffffed00000026, 0xfffffff35555553d,
  0xfffffffefffffffe, 0xffffffff66666665,
  0xfffffffe55555552, 0xfffffffefffffffd,
  0xfffffffdfffffffc, 0xfffffffeccccccc9,
  0xfffffffdfffffffc, 0xfffffffeccccccc9,
  0xffffffff55555554, 0xffffffff99999999,
  0xfffffffefffffffe, 0xffffffff66666665,
  0xfffffffefffffffe, 0xffffffff66666665,
  0xffffffff55555554, 0xffffffff99999999,
  0xffffffffaaaaaaaa, 0xffffffffcccccccd,
  0xffffffffaaaaaaaa, 0xffffffffcccccccd,
  0x0000000000000000, 0x0000000000000001,
  0x00000000aaaaaaac, 0x0000000066666669,
  0x0000000000000000, 0x0000000000000001,
  0x0000000055555556, 0x0000000033333335,
  0x0000000100000002, 0x000000009999999d,
  0x0000000baaaaaac2, 0x000000070000001d,
  0x0000000055555556, 0x0000000033333335,
  0x0000000100000002, 0x000000009999999d,
  0x0000000baaaaaac2, 0x000000070000001d,
  0x00000035555555c0, 0x0000002000000081,
  0x00000000aaaaaaac, 0x0000000066666669,
  0x0000000b5555556c, 0x00000006cccccce9,
  0x000000350000006a, 0x0000001fcccccd4d,
  0x0000005f000000be, 0x00000039000000e5,
  0x0000000aaaaaaac0, 0x0000000666666681,
  0x00000034555555be, 0x0000001f666666e5,
  0x0000005e55555612, 0x0000003899999a7d,
  0x00000088aaaaabbc, 0x0000005200000149,
  0x00000029aaaaaafe, 0x0000001900000065,
  0x00000053aaaaab52, 0x00000032333333fd,
  0x0000007e000000fc, 0x0000004b99999ac9,
  0x00002b27aaab00fa, 0x000019e4999a012d,
  0x0000002a00000054, 0x0000001933333399,
  0x00000054555555fe, 0x0000003299999a65,
  0x00002afe000055fc, 0x000019cb999a00c9,
  0x000055a80000ab50, 0x00003364cccd9a61,
  0x0000002a555555aa, 0x00000019666666cd,
  0x00002ad4000055a8, 0x000019b26666cd31,
  0x0000557e0000aafc, 0x0000334b999a66c9,
  0x00008028555655a6, 0x00004ce500013395,
  0x00002aa9aaaafffe, 0x0000199900006665,
  0x00005553aaab5552, 0x000033323333fffd,
  0x00007ffe0000fffc, 0x00004ccb999accc9,
  0x1111910f2223221e, 0x0a3dbd6f8f5d5c25,
  0x00002aaa00005554, 0x0000199933339999,
  0x000055545555fffe, 0x00003332999a6665,
  0x1111666577782220, 0x0a3da3d68f5cf5c1,
  0x2d832d8205b105ae, 0x1b4eb4e7d3a13a05,
  0x00002aaa5555aaaa, 0x000019996666cccd,
  0x11113bbb7777cccc, 0x0a3d8a3d5c295c29,
  0x2d8302d805b0b05a, 0x1b4e9b4ea06da06d,
  0x582dad8205b0b058, 0x34e834e806d406d1,
  0x1111111122222222, 0x0a3d70a3f5c28f5d,
  0x2d82d82db05b05b0, 0x1b4e81b53a06d3a1,
  0x582d82d7b05b05ae, 0x34e81b4ea06d3a05,
  0x82d82d8205b05b02, 0x4e81b4e83a06d39d,
  0x1c71c71c8e38e38e, 0x1111111144444445,
  0x471c71c68e38e38c, 0x2aaaaaaaaaaaaaa9,
  0x71c71c70e38e38e0, 0x4444444444444441,
  0x9c71c71b8e38e38a, 0x5dddddde1111110d,
  0x2aaaaaa9fffffffe, 0x1999999966666665,
  0x5555555455555552, 0x33333332fffffffd,
  0x7ffffffefffffffc, 0x4cccccccccccccc9,
  0x55555553fffffffc, 0x33333332ccccccc9,
  0x2aaaaaaa55555554, 0x1999999999999999,
  0x55555554fffffffe, 0x3333333366666665,
  0x2aaaaaa9fffffffe, 0x1999999966666665,
  0xffffffff55555554, 0xffffffff99999999,
  0x2aaaaaaaaaaaaaaa, 0x19999999cccccccd,
  0xffffffffaaaaaaaa, 0xffffffffcccccccd,
  0xd555555500000000, 0xe666666600000001,
  0xb8e38e381c71c71c, 0xd555555488888889,
  0xd555555500000000, 0xe666666600000001,
  0xaaaaaaaa55555556, 0xcccccccc33333335,
  0x8e38e38d71c71c72, 0xbbbbbbbabbbbbbbd,
  0x7d27d27bfa4fa4fa, 0xb17e4b1692c5f92d,
  0xd555555555555556, 0xe666666633333335,
  0xb8e38e3871c71c72, 0xd5555554bbbbbbbd,
  0xa7d27d26fa4fa4fa, 0xcb17e4b092c5f92d,
  0xa7d2527c4fa4a4fa, 0xcb17cb16f92bf92d,
  0xe38e38e31c71c71c, 0xeeeeeeee88888889,
  0xd27d27d1a4fa4fa4, 0xe4b17e4a5f92c5f9,
  0xd27cfd26fa4f4fa4, 0xe4b164b0c5f8c5f9,
  0xd27cd27ca4f9a4fa, 0xe4b14b175f91f92d,
  0xeeeeeeee88888888, 0xf5c28f5bd70a3d71,
  0xeeeec443dddd8888, 0xf5c275c23d703d71,
  0xeeee99998887ddde, 0xf5c25c28d70970a5,
  0xeeee6eef8887888a, 0xf5c2428fa3d5d70d,
  0xffffd55555550000, 0xffffe66666660001,
  0xffffaaaaffff5556, 0xffffccccffff3335,
  0xffff8000ffff0002, 0xffffb333cccb999d,
  0xffff555755540004, 0xffff999acccb3339,
  0xffffd555aaaa5556, 0xffffe66699993335,
  0xffffaaabaaaa0002, 0xffffcccd6665999d,
  0xffff8001ffff0004, 0xffffb33466653339,
  0xffff7fd755545504, 0xffffb31acccb9939,
  0xffffd555ffffaaac, 0xffffe666cccc6669,
  0xffffaaac5554aaae, 0xffffcccdcccc0005,
  0xffffaa81aaa9ffae, 0xffffccb433326605,
  0xffffaa575554aa04, 0xffffcc9acccbff39,
  0xffffd55655550002, 0xffffe666ffff999d,
  0xffffd52baaaa5502, 0xffffe64d6665ff9d,
  0xffffd5015554ff58, 0xffffe633ffff98d1,
  0xffffd4d75554ff04, 0xffffe61acccc6539,
  0xffffffd555555500, 0xffffffe666666601,
  0xffffffaaffffff56, 0xffffffccffffff35,
  0xffffff80ffffff02, 0xffffffb3cccccb9d,
  0xffffff5755555404, 0xffffff9acccccb39,
  0xffffffd5aaaaaa56, 0xffffffe699999935,
  0xffffffabaaaaaa02, 0xffffffcd6666659d,
  0xffffff81ffffff04, 0xffffffb466666539,
  0xffffff7755555444, 0xffffffadfffffeb9,
  0xffffffd5ffffffac, 0xffffffe6cccccc69,
  0xffffffac555554ae, 0xffffffcdcccccc05,
  0xffffffa1aaaaa9ee, 0xffffffc766666585,
  0xffffffa0aaaaa9ec, 0xffffffc6cccccbe9,
  0xffffffd655555502, 0xffffffe6ffffff9d,
  0xffffffcbaaaaaa42, 0xffffffe09999991d,
  0xffffffcaaaaaaa40, 0xffffffdfffffff81,
  0xffffffc9ffffff94, 0xffffffdf99999919,
  0xfffffff555555540, 0xfffffff999999981,
  0xfffffff45555553e, 0xfffffff8ffffffe5,
  0xfffffff3aaaaaa92, 0xfffffff89999997d,
  0xfffffff35555553c, 0xfffffff866666649,
  0xffffffff66666664, 0xfffffffffffe8001,
  0xfffffffefffffffc, 0xfffffffffffd8001,
  0xfffffffeccccccc8, 0xfffffffffffd0001,
  0xfffffffeccccccc8, 0xfffffffffffd0001,
  0xffffffff99999998, 0xffffffffffff0001,
  0xffffffff66666664, 0xfffffffffffe8001,
  0xffffffff66666664, 0xfffffffffffe8001,
  0xffffffff99999998, 0xffffffffffff0001,
  0xffffffffcccccccc, 0xffffffffffff8001,
  0xffffffffcccccccc, 0xffffffffffff8001,
  0x0000000000000000, 0x0000000000000001,
  0x0000000066666668, 0x0000000000010001,
  0x0000000000000000, 0x0000000000000001,
  0x0000000033333334, 0x0000000000008001,
  0x000000009999999c, 0x0000000000018001,
  0x000000070000001c, 0x0000000000118001,
  0x0000000033333334, 0x0000000000008001,
  0x000000009999999c, 0x0000000000018001,
  0x000000070000001c, 0x0000000000118001,
  0x0000002000000080, 0x0000000000500001,
  0x0000000066666668, 0x0000000000010001,
  0x00000006cccccce8, 0x0000000000110001,
  0x0000001fcccccd4c, 0x00000000004f8001,
  0x00000039000000e4, 0x00000000008e8001,
  0x0000000666666680, 0x0000000000100001,
  0x0000001f666666e4, 0x00000000004e8001,
  0x0000003899999a7c, 0x00000000008d8001,
  0x0000005200000148, 0x0000000000cd0001,
  0x0000001900000064, 0x00000000003e8001,
  0x00000032333333fc, 0x00000000007d8001,
  0x0000004b99999ac8, 0x0000000000bd0001,
  0x000019e4999a012c, 0x0000000040bb8001,
  0x0000001933333398, 0x00000000003f0001,
  0x0000003299999a64, 0x00000000007e8001,
  0x000019cb999a00c8, 0x00000000407d0001,
  0x00003364cccd9a60, 0x00000000807c0001,
  0x00000019666666cc, 0x00000000003f8001,
  0x000019b26666cd30, 0x00000000403e0001,
  0x0000334b999a66c8, 0x00000000803d0001,
  0x00004ce500013394, 0x00000000c03c8001,
  0x0000199900006664, 0x000000003ffe8001,
  0x000033323333fffc, 0x000000007ffd8001,
  0x00004ccb999accc8, 0x00000000bffd0001,
  0x0a3dbd6f8f5d5c24, 0x0000199a59968001,
  0x0000199933339998, 0x000000003fff0001,
  0x00003332999a6664, 0x000000007ffe8001,
  0x0a3da3d68f5cf5c0, 0x0000199a19980001,
  0x1b4eb4e7d3a13a04, 0x00004444c4428001,
  0x000019996666cccc, 0x000000003fff8001,
  0x0a3d8a3d5c295c28, 0x00001999d9990001,
  0x1b4e9b4ea06da06c, 0x0000444484438001,
  0x34e834e806d406d0, 0x0000844484420001,
  0x0a3d70a3f5c28f5c, 0x0000199999998001,
  0x1b4e81b53a06d3a0, 0x0000444444440001,
  0x34e81b4ea06d3a04, 0x0000844444428001,
  0x4e81b4e83a06d39c, 0x0000c44444418001,
  0x1111111144444444, 0x00002aaaaaaa8001,
  0x2aaaaaaaaaaaaaa8, 0x00006aaaaaa90001,
  0x4444444444444440, 0x0000aaaaaaa80001,
  0x5dddddde1111110c, 0x0000eaaaaaa78001,
  0x1999999966666664, 0x00003ffffffe8001,
  0x33333332fffffffc, 0x00007ffffffd8001,
  0x4cccccccccccccc8, 0x0000bffffffd0001,
  0x33333332ccccccc8, 0x00007ffffffd0001,
  0x1999999999999998, 0x00003fffffff0001,
  0x3333333366666664, 0x00007ffffffe8001,
  0x1999999966666664, 0x00003ffffffe8001,
  0xffffffff99999998, 0xffffffffffff0001,
  0x19999999cccccccc, 0x00003fffffff8001,
  0xffffffffcccccccc, 0xffffffffffff8001,
  0xe666666600000000, 0xffffc00000000001,
  0xd555555488888888, 0xffff955555550001,
  0xe666666600000000, 0xffffc00000000001,
  0xcccccccc33333334, 0xffff800000008001,
  0xbbbbbbbabbbbbbbc, 0xffff555555558001,
  0xb17e4b1692c5f92c, 0xffff3bbbbbbb8001,
  0xe666666633333334, 0xffffc00000008001,
  0xd5555554bbbbbbbc, 0xffff955555558001,
  0xcb17e4b092c5f92c, 0xffff7bbbbbbb8001,
  0xcb17cb16f92bf92c, 0xffff7bbb7bbb8001,
  0xeeeeeeee88888888, 0xffffd55555550001,
  0xe4b17e4a5f92c5f8, 0xffffbbbbbbbb0001,
  0xe4b164b0c5f8c5f8, 0xffffbbbb7bbb0001,
  0xe4b14b175f91f92c, 0xffffbbbb3bbb8001,
  0xf5c28f5bd70a3d70, 0xffffe66666660001,
  0xf5c275c23d703d70, 0xffffe66626660001,
  0xf5c25c28d70970a4, 0xffffe665e6668001,
  0xf5c2428fa3d5d70c, 0xffffe665a6678001,
  0xffffe66666660000, 0xffffffffc0000001,
  0xffffccccffff3334, 0xffffffff80008001,
  0xffffb333cccb999c, 0xffffffff40018001,
  0xffff999acccb3338, 0xffffffff00030001,
  0xffffe66699993334, 0xffffffffc0008001,
  0xffffcccd6665999c, 0xffffffff80018001,
  0xffffb33466653338, 0xffffffff40030001,
  0xffffb31acccb9938, 0xffffffff3fc30001,
  0xffffe666cccc6668, 0xffffffffc0010001,
  0xffffcccdcccc0004, 0xffffffff80028001,
  0xffffccb433326604, 0xffffffff7fc28001,
  0xffffcc9acccbff38, 0xffffffff7f830001,
  0xffffe666ffff999c, 0xffffffffc0018001,
  0xffffe64d6665ff9c, 0xffffffffbfc18001,
  0xffffe633ffff98d0, 0xffffffffbf820001,
  0xffffe61acccc6538, 0xffffffffbf430001,
  0xffffffe666666600, 0xffffffffffc00001,
  0xffffffccffffff34, 0xffffffffff808001,
  0xffffffb3cccccb9c, 0xffffffffff418001,
  0xffffff9acccccb38, 0xffffffffff030001,
  0xffffffe699999934, 0xffffffffffc08001,
  0xffffffcd6666659c, 0xffffffffff818001,
  0xffffffb466666538, 0xffffffffff430001,
  0xffffffadfffffeb8, 0xffffffffff330001,
  0xffffffe6cccccc68, 0xffffffffffc10001,
  0xffffffcdcccccc04, 0xffffffffff828001,
  0xffffffc766666584, 0xffffffffff728001,
  0xffffffc6cccccbe8, 0xffffffffff710001,
  0xffffffe6ffffff9c, 0xffffffffffc18001,
  0xffffffe09999991c, 0xffffffffffb18001,
  0xffffffdfffffff80, 0xffffffffffb00001,
  0xffffffdf99999918, 0xffffffffffaf0001,
  0xfffffff999999980, 0xfffffffffff00001,
  0xfffffff8ffffffe4, 0xffffffffffee8001,
  0xfffffff89999997c, 0xffffffffffed8001,
  0xfffffff866666648, 0xffffffffffed0001,
  0xfffffffffffe8000, 0xfffffffffffe8004,
  0xfffffffffffd8000, 0xfffffffffffd8006,
  0xfffffffffffd0000, 0xfffffffffffd0007,
  0xfffffffffffd0000, 0xfffffffffffd0007,
  0xffffffffffff0000, 0xffffffffffff0003,
  0xfffffffffffe8000, 0xfffffffffffe8004,
  0xfffffffffffe8000, 0xfffffffffffe8004,
  0xffffffffffff0000, 0xffffffffffff0003,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8000, 0xffffffffffff8002,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000010000, 0x000000000000ffff,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000018000, 0x0000000000017ffe,
  0x0000000000118000, 0x0000000000117fde,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000018000, 0x0000000000017ffe,
  0x0000000000118000, 0x0000000000117fde,
  0x0000000000500000, 0x00000000004fff61,
  0x0000000000010000, 0x000000000000ffff,
  0x0000000000110000, 0x000000000010ffdf,
  0x00000000004f8000, 0x00000000004f7f62,
  0x00000000008e8000, 0x00000000008e7ee4,
  0x0000000000100000, 0x00000000000fffe1,
  0x00000000004e8000, 0x00000000004e7f64,
  0x00000000008d8000, 0x00000000008d7ee6,
  0x0000000000cd0000, 0x0000000000ccfe67,
  0x00000000003e8000, 0x00000000003e7f84,
  0x00000000007d8000, 0x00000000007d7f06,
  0x0000000000bd0000, 0x0000000000bcfe87,
  0x0000000040bb8000, 0x0000000040bafe8a,
  0x00000000003f0000, 0x00000000003eff83,
  0x00000000007e8000, 0x00000000007e7f04,
  0x00000000407d0000, 0x00000000407c7f07,
  0x00000000807c0000, 0x00000000807aff09,
  0x00000000003f8000, 0x00000000003f7f82,
  0x00000000403e0000, 0x00000000403d7f85,
  0x00000000803d0000, 0x00000000803bff87,
  0x00000000c03c8000, 0x00000000c03aff88,
  0x000000003ffe8000, 0x000000003ffe0004,
  0x000000007ffd8000, 0x000000007ffc8006,
  0x00000000bffd0000, 0x00000000bffb8007,
  0x0000199a59968000, 0x0000199a2661ccd4,
  0x000000003fff0000, 0x000000003ffe8003,
  0x000000007ffe8000, 0x000000007ffd8004,
  0x0000199a19980000, 0x00001999e663ccd1,
  0x00004444c4428000, 0x000044443bb8f77c,
  0x000000003fff8000, 0x000000003fff0002,
  0x00001999d9990000, 0x00001999a6654ccf,
  0x0000444484438000, 0x00004443fbba777a,
  0x0000844484420000, 0x000084437bb8f77d,
  0x0000199999998000, 0x0000199966664cce,
  0x0000444444440000, 0x00004443bbbb7779,
  0x0000844444428000, 0x000084433bb9f77c,
  0x0000c44444418000, 0x0000c442bbb8f77e,
  0x00002aaaaaaa8000, 0x00002aaa55552aac,
  0x00006aaaaaa90000, 0x00006aa9d553aaaf,
  0x0000aaaaaaa80000, 0x0000aaa95552aab1,
  0x0000eaaaaaa78000, 0x0000eaa8d5522ab2,
  0x00003ffffffe8000, 0x00003fff7ffe8004,
  0x00007ffffffd8000, 0x00007ffefffd8006,
  0x0000bffffffd0000, 0x0000bffe7ffd0007,
  0x00007ffffffd0000, 0x00007ffefffd0007,
  0x00003fffffff0000, 0x00003fff7fff0003,
  0x00007ffffffe8000, 0x00007ffefffe8004,
  0x00003ffffffe8000, 0x00003fff7ffe8004,
  0xffffffffffff0000, 0xffffffffffff0003,
  0x00003fffffff8000, 0x00003fff7fff8002,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffc00000000000, 0xffffc00080000001,
  0xffff955555550000, 0xffff95562aaa5557,
  0xffffc00000000000, 0xffffc00080000001,
  0xffff800000008000, 0xffff800100008000,
  0xffff555555558000, 0xffff5556aaaad556,
  0xffff3bbbbbbb8000, 0xffff3bbd4444088a,
  0xffffc00000008000, 0xffffc00080008000,
  0xffff955555558000, 0xffff95562aaad556,
  0xffff7bbbbbbb8000, 0xffff7bbcc444088a,
  0xffff7bbb7bbb8000, 0xffff7bbc8444888a,
  0xffffd55555550000, 0xffffd555aaaa5557,
  0xffffbbbbbbbb0000, 0xffffbbbc4443888b,
  0xffffbbbb7bbb0000, 0xffffbbbc0444088b,
  0xffffbbbb3bbb8000, 0xffffbbbbc445088a,
  0xffffe66666660000, 0xffffe66699993335,
  0xffffe66626660000, 0xffffe6665999b335,
  0xffffe665e6668000, 0xffffe666199ab334,
  0xffffe665a6678000, 0xffffe665d99c3332,
  0xffffffffc0000000, 0xffffffffc0008001,
  0xffffffff80008000, 0xffffffff80018000,
  0xffffffff40018000, 0xffffffff4002fffe,
  0xffffffff00030000, 0xffffffff0004fffb,
  0xffffffffc0008000, 0xffffffffc0010000,
  0xffffffff80018000, 0xffffffff80027ffe,
  0xffffffff40030000, 0xffffffff40047ffb,
  0xffffffff3fc30000, 0xffffffff3fc4807b,
  0xffffffffc0010000, 0xffffffffc0017fff,
  0xffffffff80028000, 0xffffffff80037ffc,
  0xffffffff7fc28000, 0xffffffff7fc3807c,
  0xffffffff7f830000, 0xffffffff7f8400fb,
  0xffffffffc0018000, 0xffffffffc001fffe,
  0xffffffffbfc18000, 0xffffffffbfc2007e,
  0xffffffffbf820000, 0xffffffffbf8280fd,
  0xffffffffbf430000, 0xffffffffbf43817b,
  0xffffffffffc00000, 0xffffffffffc00081,
  0xffffffffff808000, 0xffffffffff808100,
  0xffffffffff418000, 0xffffffffff41817e,
  0xffffffffff030000, 0xffffffffff0301fb,
  0xffffffffffc08000, 0xffffffffffc08080,
  0xffffffffff818000, 0xffffffffff8180fe,
  0xffffffffff430000, 0xffffffffff43017b,
  0xffffffffff330000, 0xffffffffff33019b,
  0xffffffffffc10000, 0xffffffffffc1007f,
  0xffffffffff828000, 0xffffffffff8280fc,
  0xffffffffff728000, 0xffffffffff72811c,
  0xffffffffff710000, 0xffffffffff71011f,
  0xffffffffffc18000, 0xffffffffffc1807e,
  0xffffffffffb18000, 0xffffffffffb1809e,
  0xffffffffffb00000, 0xffffffffffb000a1,
  0xffffffffffaf0000, 0xffffffffffaf00a3,
  0xfffffffffff00000, 0xfffffffffff00021,
  0xffffffffffee8000, 0xffffffffffee8024,
  0xffffffffffed8000, 0xffffffffffed8026,
  0xffffffffffed0000, 0xffffffffffed0027,
  0xfffffffffffe8003, 0xfffffffffffe8007,
  0xfffffffffffd8005, 0xfffffffffffd800b,
  0xfffffffffffd0006, 0xfffffffffffd000d,
  0xfffffffffffd0006, 0xfffffffffffd000d,
  0xffffffffffff0002, 0xffffffffffff0005,
  0xfffffffffffe8003, 0xfffffffffffe8007,
  0xfffffffffffe8003, 0xfffffffffffe8007,
  0xffffffffffff0002, 0xffffffffffff0005,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8001, 0xffffffffffff8003,
  0x0000000000000000, 0x0000000000000001,
  0x000000000000fffe, 0x000000000000fffd,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000017ffd, 0x0000000000017ffb,
  0x0000000000117fdd, 0x0000000000117fbb,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000017ffd, 0x0000000000017ffb,
  0x0000000000117fdd, 0x0000000000117fbb,
  0x00000000004fff60, 0x00000000004ffec1,
  0x000000000000fffe, 0x000000000000fffd,
  0x000000000010ffde, 0x000000000010ffbd,
  0x00000000004f7f61, 0x00000000004f7ec3,
  0x00000000008e7ee3, 0x00000000008e7dc7,
  0x00000000000fffe0, 0x00000000000fffc1,
  0x00000000004e7f63, 0x00000000004e7ec7,
  0x00000000008d7ee5, 0x00000000008d7dcb,
  0x0000000000ccfe66, 0x0000000000ccfccd,
  0x00000000003e7f83, 0x00000000003e7f07,
  0x00000000007d7f05, 0x00000000007d7e0b,
  0x0000000000bcfe86, 0x0000000000bcfd0d,
  0x0000000040bafe89, 0x0000000040ba7d13,
  0x00000000003eff82, 0x00000000003eff05,
  0x00000000007e7f03, 0x00000000007e7e07,
  0x00000000407c7f06, 0x00000000407bfe0d,
  0x00000000807aff08, 0x000000008079fe11,
  0x00000000003f7f81, 0x00000000003f7f03,
  0x00000000403d7f84, 0x00000000403cff09,
  0x00000000803bff86, 0x00000000803aff0d,
  0x00000000c03aff87, 0x00000000c0397f0f,
  0x000000003ffe0003, 0x000000003ffd8007,
  0x000000007ffc8005, 0x000000007ffb800b,
  0x00000000bffb8006, 0x00000000bffa000d,
  0x0000199a2661ccd3, 0x00001999f32d19a7,
  0x000000003ffe8002, 0x000000003ffe0005,
  0x000000007ffd8003, 0x000000007ffc8007,
  0x00001999e663ccd0, 0x00001999b32f99a1,
  0x000044443bb8f77b, 0x00004443b32f6ef7,
  0x000000003fff0001, 0x000000003ffe8003,
  0x00001999a6654cce, 0x000019997331999d,
  0x00004443fbba7779, 0x0000444373316ef3,
  0x000084437bb8f77c, 0x00008442732feef9,
  0x0000199966664ccd, 0x000019993333199b,
  0x00004443bbbb7778, 0x000044433332eef1,
  0x000084433bb9f77b, 0x0000844233316ef7,
  0x0000c442bbb8f77d, 0x0000c44133306efb,
  0x00002aaa55552aab, 0x00002aa9ffffd557,
  0x00006aa9d553aaae, 0x00006aa8fffe555d,
  0x0000aaa95552aab0, 0x0000aaa7fffd5561,
  0x0000eaa8d5522ab1, 0x0000eaa6fffcd563,
  0x00003fff7ffe8003, 0x00003ffefffe8007,
  0x00007ffefffd8005, 0x00007ffdfffd800b,
  0x0000bffe7ffd0006, 0x0000bffcfffd000d,
  0x00007ffefffd0006, 0x00007ffdfffd000d,
  0x00003fff7fff0002, 0x00003ffeffff0005,
  0x00007ffefffe8003, 0x00007ffdfffe8007,
  0x00003fff7ffe8003, 0x00003ffefffe8007,
  0xffffffffffff0002, 0xffffffffffff0005,
  0x00003fff7fff8001, 0x00003ffeffff8003,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffc00080000000, 0xffffc00100000001,
  0xffff95562aaa5556, 0xffff9556ffffaaad,
  0xffffc00080000000, 0xffffc00100000001,
  0xffff800100007fff, 0xffff800200007fff,
  0xffff5556aaaad555, 0xffff555800002aab,
  0xffff3bbd44440889, 0xffff3bbecccc9113,
  0xffffc00080007fff, 0xffffc00100007fff,
  0xffff95562aaad555, 0xffff955700002aab,
  0xffff7bbcc4440889, 0xffff7bbdcccc9113,
  0xffff7bbc84448889, 0xffff7bbd8ccd9113,
  0xffffd555aaaa5556, 0xffffd555ffffaaad,
  0xffffbbbc4443888a, 0xffffbbbccccc1115,
  0xffffbbbc0444088a, 0xffffbbbc8ccd1115,
  0xffffbbbbc4450889, 0xffffbbbc4cce9113,
  0xffffe66699993334, 0xffffe666cccc6669,
  0xffffe6665999b334, 0xffffe6668ccd6669,
  0xffffe666199ab333, 0xffffe6664ccee667,
  0xffffe665d99c3331, 0xffffe6660cd0e663,
  0xffffffffc0008000, 0xffffffffc0010001,
  0xffffffff80017fff, 0xffffffff80027fff,
  0xffffffff4002fffd, 0xffffffff40047ffb,
  0xffffffff0004fffa, 0xffffffff0006fff5,
  0xffffffffc000ffff, 0xffffffffc0017fff,
  0xffffffff80027ffd, 0xffffffff80037ffb,
  0xffffffff40047ffa, 0xffffffff4005fff5,
  0xffffffff3fc4807a, 0xffffffff3fc600f5,
  0xffffffffc0017ffe, 0xffffffffc001fffd,
  0xffffffff80037ffb, 0xffffffff80047ff7,
  0xffffffff7fc3807b, 0xffffffff7fc480f7,
  0xffffffff7f8400fa, 0xffffffff7f8501f5,
  0xffffffffc001fffd, 0xffffffffc0027ffb,
  0xffffffffbfc2007d, 0xffffffffbfc280fb,
  0xffffffffbf8280fc, 0xffffffffbf8301f9,
  0xffffffffbf43817a, 0xffffffffbf4402f5,
  0xffffffffffc00080, 0xffffffffffc00101,
  0xffffffffff8080ff, 0xffffffffff8081ff,
  0xffffffffff41817d, 0xffffffffff4182fb,
  0xffffffffff0301fa, 0xffffffffff0303f5,
  0xffffffffffc0807f, 0xffffffffffc080ff,
  0xffffffffff8180fd, 0xffffffffff8181fb,
  0xffffffffff43017a, 0xffffffffff4302f5,
  0xffffffffff33019a, 0xffffffffff330335,
  0xffffffffffc1007e, 0xffffffffffc100fd,
  0xffffffffff8280fb, 0xffffffffff8281f7,
  0xffffffffff72811b, 0xffffffffff728237,
  0xffffffffff71011e, 0xffffffffff71023d,
  0xffffffffffc1807d, 0xffffffffffc180fb,
  0xffffffffffb1809d, 0xffffffffffb1813b,
  0xffffffffffb000a0, 0xffffffffffb00141,
  0xffffffffffaf00a2, 0xffffffffffaf0145,
  0xfffffffffff00020, 0xfffffffffff00041,
  0xffffffffffee8023, 0xffffffffffee8047,
  0xffffffffffed8025, 0xffffffffffed804b,
  0xffffffffffed0026, 0xffffffffffed004d,
  0xfffffffffffe8006, 0xfffffffffffe800a,
  0xfffffffffffd800a, 0xfffffffffffd8010,
  0xfffffffffffd000c, 0xfffffffffffd0013,
  0xfffffffffffd000c, 0xfffffffffffd0013,
  0xffffffffffff0004, 0xffffffffffff0007,
  0xfffffffffffe8006, 0xfffffffffffe800a,
  0xfffffffffffe8006, 0xfffffffffffe800a,
  0xffffffffffff0004, 0xffffffffffff0007,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8002, 0xffffffffffff8004,
  0x0000000000000000, 0x0000000000000001,
  0x000000000000fffc, 0x000000000000fffb,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000017ffa, 0x0000000000017ff8,
  0x0000000000117fba, 0x0000000000117f98,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000017ffa, 0x0000000000017ff8,
  0x0000000000117fba, 0x0000000000117f98,
  0x00000000004ffec0, 0x00000000004ffe21,
  0x000000000000fffc, 0x000000000000fffb,
  0x000000000010ffbc, 0x000000000010ff9b,
  0x00000000004f7ec2, 0x00000000004f7e24,
  0x00000000008e7dc6, 0x00000000008e7caa,
  0x00000000000fffc0, 0x00000000000fffa1,
  0x00000000004e7ec6, 0x00000000004e7e2a,
  0x00000000008d7dca, 0x00000000008d7cb0,
  0x0000000000ccfccc, 0x0000000000ccfb33,
  0x00000000003e7f06, 0x00000000003e7e8a,
  0x00000000007d7e0a, 0x00000000007d7d10,
  0x0000000000bcfd0c, 0x0000000000bcfb93,
  0x0000000040ba7d12, 0x0000000040b9fb9c,
  0x00000000003eff04, 0x00000000003efe87,
  0x00000000007e7e06, 0x00000000007e7d0a,
  0x00000000407bfe0c, 0x00000000407b7d13,
  0x000000008079fe10, 0x000000008078fd19,
  0x00000000003f7f02, 0x00000000003f7e84,
  0x00000000403cff08, 0x00000000403c7e8d,
  0x00000000803aff0c, 0x000000008039fe93,
  0x00000000c0397f0e, 0x00000000c037fe96,
  0x000000003ffd8006, 0x000000003ffd000a,
  0x000000007ffb800a, 0x000000007ffa8010,
  0x00000000bffa000c, 0x00000000bff88013,
  0x00001999f32d19a6, 0x00001999bff8667a,
  0x000000003ffe0004, 0x000000003ffd8007,
  0x000000007ffc8006, 0x000000007ffb800a,
  0x00001999b32f99a0, 0x000019997ffb6671,
  0x00004443b32f6ef6, 0x000044432aa5e672,
  0x000000003ffe8002, 0x000000003ffe0004,
  0x000019997331999c, 0x000019993ffde66b,
  0x0000444373316ef2, 0x00004442eaa8666c,
  0x00008442732feef8, 0x000084416aa6e675,
  0x000019993333199a, 0x00001998ffffe668,
  0x000044433332eef0, 0x00004442aaaa6669,
  0x0000844233316ef6, 0x000084412aa8e672,
  0x0000c44133306efa, 0x0000c43faaa7e678,
  0x00002aa9ffffd556, 0x00002aa9aaaa8002,
  0x00006aa8fffe555c, 0x00006aa82aa9000b,
  0x0000aaa7fffd5560, 0x0000aaa6aaa80011,
  0x0000eaa6fffcd562, 0x0000eaa52aa78014,
  0x00003ffefffe8006, 0x00003ffe7ffe800a,
  0x00007ffdfffd800a, 0x00007ffcfffd8010,
  0x0000bffcfffd000c, 0x0000bffb7ffd0013,
  0x00007ffdfffd000c, 0x00007ffcfffd0013,
  0x00003ffeffff0004, 0x00003ffe7fff0007,
  0x00007ffdfffe8006, 0x00007ffcfffe800a,
  0x00003ffefffe8006, 0x00003ffe7ffe800a,
  0xffffffffffff0004, 0xffffffffffff0007,
  0x00003ffeffff8002, 0x00003ffe7fff8004,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffc00100000000, 0xffffc00180000001,
  0xffff9556ffffaaac, 0xffff9557d5550003,
  0xffffc00100000000, 0xffffc00180000001,
  0xffff800200007ffe, 0xffff800300007ffe,
  0xffff555800002aaa, 0xffff555955558000,
  0xffff3bbecccc9112, 0xffff3bc05555199c,
  0xffffc00100007ffe, 0xffffc00180007ffe,
  0xffff955700002aaa, 0xffff9557d5558000,
  0xffff7bbdcccc9112, 0xffff7bbed555199c,
  0xffff7bbd8ccd9112, 0xffff7bbe9556999c,
  0xffffd555ffffaaac, 0xffffd55655550003,
  0xffffbbbccccc1114, 0xffffbbbd5554999f,
  0xffffbbbc8ccd1114, 0xffffbbbd1556199f,
  0xffffbbbc4cce9112, 0xffffbbbcd558199c,
  0xffffe666cccc6668, 0xffffe666ffff999d,
  0xffffe6668ccd6668, 0xffffe666c001199d,
  0xffffe6664ccee666, 0xffffe6668003199a,
  0xffffe6660cd0e662, 0xffffe66640059994,
  0xffffffffc0010000, 0xffffffffc0018001,
  0xffffffff80027ffe, 0xffffffff80037ffe,
  0xffffffff40047ffa, 0xffffffff4005fff8,
  0xffffffff0006fff4, 0xffffffff0008ffef,
  0xffffffffc0017ffe, 0xffffffffc001fffe,
  0xffffffff80037ffa, 0xffffffff80047ff8,
  0xffffffff4005fff4, 0xffffffff40077fef,
  0xffffffff3fc600f4, 0xffffffff3fc7816f,
  0xffffffffc001fffc, 0xffffffffc0027ffb,
  0xffffffff80047ff6, 0xffffffff80057ff2,
  0xffffffff7fc480f6, 0xffffffff7fc58172,
  0xffffffff7f8501f4, 0xffffffff7f8602ef,
  0xffffffffc0027ffa, 0xffffffffc002fff8,
  0xffffffffbfc280fa, 0xffffffffbfc30178,
  0xffffffffbf8301f8, 0xffffffffbf8382f5,
  0xffffffffbf4402f4, 0xffffffffbf44846f,
  0xffffffffffc00100, 0xffffffffffc00181,
  0xffffffffff8081fe, 0xffffffffff8082fe,
  0xffffffffff4182fa, 0xffffffffff418478,
  0xffffffffff0303f4, 0xffffffffff0305ef,
  0xffffffffffc080fe, 0xffffffffffc0817e,
  0xffffffffff8181fa, 0xffffffffff8182f8,
  0xffffffffff4302f4, 0xffffffffff43046f,
  0xffffffffff330334, 0xffffffffff3304cf,
  0xffffffffffc100fc, 0xffffffffffc1017b,
  0xffffffffff8281f6, 0xffffffffff8282f2,
  0xffffffffff728236, 0xffffffffff728352,
  0xffffffffff71023c, 0xffffffffff71035b,
  0xffffffffffc180fa, 0xffffffffffc18178,
  0xffffffffffb1813a, 0xffffffffffb181d8,
  0xffffffffffb00140, 0xffffffffffb001e1,
  0xffffffffffaf0144, 0xffffffffffaf01e7,
  0xfffffffffff00040, 0xfffffffffff00061,
  0xffffffffffee8046, 0xffffffffffee806a,
  0xffffffffffed804a, 0xffffffffffed8070,
  0xffffffffffed004c, 0xffffffffffed0073,
  0xfffffffffffe8009, 0xfffffffffffffe81,
  0xfffffffffffd800f, 0xfffffffffffffd81,
  0xfffffffffffd0012, 0xfffffffffffffd01,
  0xfffffffffffd0012, 0xfffffffffffffd01,
  0xffffffffffff0006, 0xffffffffffffff01,
  0xfffffffffffe8009, 0xfffffffffffffe81,
  0xfffffffffffe8009, 0xfffffffffffffe81,
  0xffffffffffff0006, 0xffffffffffffff01,
  0xffffffffffff8003, 0xffffffffffffff81,
  0xffffffffffff8003, 0xffffffffffffff81,
  0x0000000000000000, 0x0000000000000001,
  0x000000000000fffa, 0x0000000000000101,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000007ffd, 0x0000000000000081,
  0x0000000000017ff7, 0x0000000000000181,
  0x0000000000117f97, 0x0000000000001181,
  0x0000000000007ffd, 0x0000000000000081,
  0x0000000000017ff7, 0x0000000000000181,
  0x0000000000117f97, 0x0000000000001181,
  0x00000000004ffe20, 0x0000000000005001,
  0x000000000000fffa, 0x0000000000000101,
  0x000000000010ff9a, 0x0000000000001101,
  0x00000000004f7e23, 0x0000000000004f81,
  0x00000000008e7ca9, 0x0000000000008e81,
  0x00000000000fffa0, 0x0000000000001001,
  0x00000000004e7e29, 0x0000000000004e81,
  0x00000000008d7caf, 0x0000000000008d81,
  0x0000000000ccfb32, 0x000000000000cd01,
  0x00000000003e7e89, 0x0000000000003e81,
  0x00000000007d7d0f, 0x0000000000007d81,
  0x0000000000bcfb92, 0x000000000000bd01,
  0x0000000040b9fb9b, 0x000000000040bb81,
  0x00000000003efe86, 0x0000000000003f01,
  0x00000000007e7d09, 0x0000000000007e81,
  0x00000000407b7d12, 0x0000000000407d01,
  0x000000008078fd18, 0x0000000000807c01,
  0x00000000003f7e83, 0x0000000000003f81,
  0x00000000403c7e8c, 0x0000000000403e01,
  0x000000008039fe92, 0x0000000000803d01,
  0x00000000c037fe95, 0x0000000000c03c81,
  0x000000003ffd0009, 0x00000000003ffe81,
  0x000000007ffa800f, 0x00000000007ffd81,
  0x00000000bff88012, 0x0000000000bffd01,
  0x00001999bff86679, 0x000000199a599681,
  0x000000003ffd8006, 0x00000000003fff01,
  0x000000007ffb8009, 0x00000000007ffe81,
  0x000019997ffb6670, 0x000000199a199801,
  0x000044432aa5e671, 0x0000004444c44281,
  0x000000003ffe0003, 0x00000000003fff81,
  0x000019993ffde66a, 0x0000001999d99901,
  0x00004442eaa8666b, 0x0000004444844381,
  0x000084416aa6e674, 0x0000008444844201,
  0x00001998ffffe667, 0x0000001999999981,
  0x00004442aaaa6668, 0x0000004444444401,
  0x000084412aa8e671, 0x0000008444444281,
  0x0000c43faaa7e677, 0x000000c444444181,
  0x00002aa9aaaa8001, 0x0000002aaaaaaa81,
  0x00006aa82aa9000a, 0x0000006aaaaaa901,
  0x0000aaa6aaa80010, 0x000000aaaaaaa801,
  0x0000eaa52aa78013, 0x000000eaaaaaa781,
  0x00003ffe7ffe8009, 0x0000003ffffffe81,
  0x00007ffcfffd800f, 0x0000007ffffffd81,
  0x0000bffb7ffd0012, 0x000000bffffffd01,
  0x00007ffcfffd0012, 0x0000007ffffffd01,
  0x00003ffe7fff0006, 0x0000003fffffff01,
  0x00007ffcfffe8009, 0x0000007ffffffe81,
  0x00003ffe7ffe8009, 0x0000003ffffffe81,
  0xffffffffffff0006, 0xffffffffffffff01,
  0x00003ffe7fff8003, 0x0000003fffffff81,
  0xffffffffffff8003, 0xffffffffffffff81,
  0xffffc00180000000, 0xffffffc000000001,
  0xffff9557d5550002, 0xffffff9555555501,
  0xffffc00180000000, 0xffffffc000000001,
  0xffff800300007ffd, 0xffffff8000000081,
  0xffff555955557fff, 0xffffff5555555581,
  0xffff3bc05555199b, 0xffffff3bbbbbbb81,
  0xffffc00180007ffd, 0xffffffc000000081,
  0xffff9557d5557fff, 0xffffff9555555581,
  0xffff7bbed555199b, 0xffffff7bbbbbbb81,
  0xffff7bbe9556999b, 0xffffff7bbb7bbb81,
  0xffffd55655550002, 0xffffffd555555501,
  0xffffbbbd5554999e, 0xffffffbbbbbbbb01,
  0xffffbbbd1556199e, 0xffffffbbbb7bbb01,
  0xffffbbbcd558199b, 0xffffffbbbb3bbb81,
  0xffffe666ffff999c, 0xffffffe666666601,
  0xffffe666c001199c, 0xffffffe666266601,
  0xffffe66680031999, 0xffffffe665e66681,
  0xffffe66640059993, 0xffffffe665a66781,
  0xffffffffc0018000, 0xffffffffffc00001,
  0xffffffff80037ffd, 0xffffffffff800081,
  0xffffffff4005fff7, 0xffffffffff400181,
  0xffffffff0008ffee, 0xffffffffff000301,
  0xffffffffc001fffd, 0xffffffffffc00081,
  0xffffffff80047ff7, 0xffffffffff800181,
  0xffffffff40077fee, 0xffffffffff400301,
  0xffffffff3fc7816e, 0xffffffffff3fc301,
  0xffffffffc0027ffa, 0xffffffffffc00101,
  0xffffffff80057ff1, 0xffffffffff800281,
  0xffffffff7fc58171, 0xffffffffff7fc281,
  0xffffffff7f8602ee, 0xffffffffff7f8301,
  0xffffffffc002fff7, 0xffffffffffc00181,
  0xffffffffbfc30177, 0xffffffffffbfc181,
  0xffffffffbf8382f4, 0xffffffffffbf8201,
  0xffffffffbf44846e, 0xffffffffffbf4301,
  0xffffffffffc00180, 0xffffffffffffc001,
  0xffffffffff8082fd, 0xffffffffffff8081,
  0xffffffffff418477, 0xffffffffffff4181,
  0xffffffffff0305ee, 0xffffffffffff0301,
  0xffffffffffc0817d, 0xffffffffffffc081,
  0xffffffffff8182f7, 0xffffffffffff8181,
  0xffffffffff43046e, 0xffffffffffff4301,
  0xffffffffff3304ce, 0xffffffffffff3301,
  0xffffffffffc1017a, 0xffffffffffffc101,
  0xffffffffff8282f1, 0xffffffffffff8281,
  0xffffffffff728351, 0xffffffffffff7281,
  0xffffffffff71035a, 0xffffffffffff7101,
  0xffffffffffc18177, 0xffffffffffffc181,
  0xffffffffffb181d7, 0xffffffffffffb181,
  0xffffffffffb001e0, 0xffffffffffffb001,
  0xffffffffffaf01e6, 0xffffffffffffaf01,
  0xfffffffffff00060, 0xfffffffffffff001,
  0xffffffffffee8069, 0xffffffffffffee81,
  0xffffffffffed806f, 0xffffffffffffed81,
  0xffffffffffed0072, 0xffffffffffffed01,
  0xfffffffffffffe80, 0xfffffffffffffe84,
  0xfffffffffffffd80, 0xfffffffffffffd86,
  0xfffffffffffffd00, 0xfffffffffffffd07,
  0xfffffffffffffd00, 0xfffffffffffffd07,
  0xffffffffffffff00, 0xffffffffffffff03,
  0xfffffffffffffe80, 0xfffffffffffffe84,
  0xfffffffffffffe80, 0xfffffffffffffe84,
  0xffffffffffffff00, 0xffffffffffffff03,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff80, 0xffffffffffffff82,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000100, 0x00000000000000ff,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000180, 0x000000000000017e,
  0x0000000000001180, 0x000000000000115e,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000180, 0x000000000000017e,
  0x0000000000001180, 0x000000000000115e,
  0x0000000000005000, 0x0000000000004f61,
  0x0000000000000100, 0x00000000000000ff,
  0x0000000000001100, 0x00000000000010df,
  0x0000000000004f80, 0x0000000000004ee2,
  0x0000000000008e80, 0x0000000000008d64,
  0x0000000000001000, 0x0000000000000fe1,
  0x0000000000004e80, 0x0000000000004de4,
  0x0000000000008d80, 0x0000000000008c66,
  0x000000000000cd00, 0x000000000000cb67,
  0x0000000000003e80, 0x0000000000003e04,
  0x0000000000007d80, 0x0000000000007c86,
  0x000000000000bd00, 0x000000000000bb87,
  0x000000000040bb80, 0x0000000000403a0a,
  0x0000000000003f00, 0x0000000000003e83,
  0x0000000000007e80, 0x0000000000007d84,
  0x0000000000407d00, 0x00000000003ffc07,
  0x0000000000807c00, 0x00000000007f7b09,
  0x0000000000003f80, 0x0000000000003f02,
  0x0000000000403e00, 0x00000000003fbd85,
  0x0000000000803d00, 0x00000000007f3c87,
  0x0000000000c03c80, 0x0000000000bebc08,
  0x00000000003ffe80, 0x00000000003f7e84,
  0x00000000007ffd80, 0x00000000007efd86,
  0x0000000000bffd00, 0x0000000000be7d07,
  0x000000199a599680, 0x000000196724e354,
  0x00000000003fff00, 0x00000000003f7f03,
  0x00000000007ffe80, 0x00000000007efe84,
  0x000000199a199800, 0x0000001966e564d1,
  0x0000004444c44280, 0x00000043bc3ab9fc,
  0x00000000003fff80, 0x00000000003f7f82,
  0x0000001999d99900, 0x0000001966a5e5cf,
  0x0000004444844380, 0x00000043bbfb3afa,
  0x0000008444844200, 0x000000833bfb397d,
  0x0000001999999980, 0x000000196666664e,
  0x0000004444444400, 0x00000043bbbbbb79,
  0x0000008444444280, 0x000000833bbbb9fc,
  0x000000c444444180, 0x000000c2bbbbb8fe,
  0x0000002aaaaaaa80, 0x0000002a5555552c,
  0x0000006aaaaaa900, 0x00000069d55553af,
  0x000000aaaaaaa800, 0x000000a9555552b1,
  0x000000eaaaaaa780, 0x000000e8d5555232,
  0x0000003ffffffe80, 0x0000003f7ffffe84,
  0x0000007ffffffd80, 0x0000007efffffd86,
  0x000000bffffffd00, 0x000000be7ffffd07,
  0x0000007ffffffd00, 0x0000007efffffd07,
  0x0000003fffffff00, 0x0000003f7fffff03,
  0x0000007ffffffe80, 0x0000007efffffe84,
  0x0000003ffffffe80, 0x0000003f7ffffe84,
  0xffffffffffffff00, 0xffffffffffffff03,
  0x0000003fffffff80, 0x0000003f7fffff82,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffc000000000, 0xffffffc080000001,
  0xffffff9555555500, 0xffffff962aaaaa57,
  0xffffffc000000000, 0xffffffc080000001,
  0xffffff8000000080, 0xffffff8100000080,
  0xffffff5555555580, 0xffffff56aaaaaad6,
  0xffffff3bbbbbbb80, 0xffffff3d4444440a,
  0xffffffc000000080, 0xffffffc080000080,
  0xffffff9555555580, 0xffffff962aaaaad6,
  0xffffff7bbbbbbb80, 0xffffff7cc444440a,
  0xffffff7bbb7bbb80, 0xffffff7cc404c40a,
  0xffffffd555555500, 0xffffffd5aaaaaa57,
  0xffffffbbbbbbbb00, 0xffffffbc4444438b,
  0xffffffbbbb7bbb00, 0xffffffbc4404c38b,
  0xffffffbbbb3bbb80, 0xffffffbc43c5440a,
  0xffffffe666666600, 0xffffffe699999935,
  0xffffffe666266600, 0xffffffe6995a1935,
  0xffffffe665e66680, 0xffffffe6991a99b4,
  0xffffffe665a66780, 0xffffffe698db1ab2,
  0xffffffffffc00000, 0xffffffffffc08001,
  0xffffffffff800080, 0xffffffffff810080,
  0xffffffffff400180, 0xffffffffff41817e,
  0xffffffffff000300, 0xffffffffff0202fb,
  0xffffffffffc00080, 0xffffffffffc08080,
  0xffffffffff800180, 0xffffffffff81017e,
  0xffffffffff400300, 0xffffffffff4182fb,
  0xffffffffff3fc300, 0xffffffffff41437b,
  0xffffffffffc00100, 0xffffffffffc080ff,
  0xffffffffff800280, 0xffffffffff81027c,
  0xffffffffff7fc280, 0xffffffffff80c2fc,
  0xffffffffff7f8300, 0xffffffffff8083fb,
  0xffffffffffc00180, 0xffffffffffc0817e,
  0xffffffffffbfc180, 0xffffffffffc041fe,
  0xffffffffffbf8200, 0xffffffffffc002fd,
  0xffffffffffbf4300, 0xffffffffffbfc47b,
  0xffffffffffffc000, 0xffffffffffffc081,
  0xffffffffffff8080, 0xffffffffffff8180,
  0xffffffffffff4180, 0xffffffffffff42fe,
  0xffffffffffff0300, 0xffffffffffff04fb,
  0xffffffffffffc080, 0xffffffffffffc100,
  0xffffffffffff8180, 0xffffffffffff827e,
  0xffffffffffff4300, 0xffffffffffff447b,
  0xffffffffffff3300, 0xffffffffffff349b,
  0xffffffffffffc100, 0xffffffffffffc17f,
  0xffffffffffff8280, 0xffffffffffff837c,
  0xffffffffffff7280, 0xffffffffffff739c,
  0xffffffffffff7100, 0xffffffffffff721f,
  0xffffffffffffc180, 0xffffffffffffc1fe,
  0xffffffffffffb180, 0xffffffffffffb21e,
  0xffffffffffffb000, 0xffffffffffffb0a1,
  0xffffffffffffaf00, 0xffffffffffffafa3,
  0xfffffffffffff000, 0xfffffffffffff021,
  0xffffffffffffee80, 0xffffffffffffeea4,
  0xffffffffffffed80, 0xffffffffffffeda6,
  0xffffffffffffed00, 0xffffffffffffed27,
  0xfffffffffffffe83, 0xfffffffffffffe87,
  0xfffffffffffffd85, 0xfffffffffffffd8b,
  0xfffffffffffffd06, 0xfffffffffffffd0d,
  0xfffffffffffffd06, 0xfffffffffffffd0d,
  0xffffffffffffff02, 0xffffffffffffff05,
  0xfffffffffffffe83, 0xfffffffffffffe87,
  0xfffffffffffffe83, 0xfffffffffffffe87,
  0xffffffffffffff02, 0xffffffffffffff05,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff81, 0xffffffffffffff83,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000000fe, 0x00000000000000fd,
  0x0000000000000000, 0x0000000000000001,
  0x000000000000007f, 0x000000000000007f,
  0x000000000000017d, 0x000000000000017b,
  0x000000000000115d, 0x000000000000113b,
  0x000000000000007f, 0x000000000000007f,
  0x000000000000017d, 0x000000000000017b,
  0x000000000000115d, 0x000000000000113b,
  0x0000000000004f60, 0x0000000000004ec1,
  0x00000000000000fe, 0x00000000000000fd,
  0x00000000000010de, 0x00000000000010bd,
  0x0000000000004ee1, 0x0000000000004e43,
  0x0000000000008d63, 0x0000000000008c47,
  0x0000000000000fe0, 0x0000000000000fc1,
  0x0000000000004de3, 0x0000000000004d47,
  0x0000000000008c65, 0x0000000000008b4b,
  0x000000000000cb66, 0x000000000000c9cd,
  0x0000000000003e03, 0x0000000000003d87,
  0x0000000000007c85, 0x0000000000007b8b,
  0x000000000000bb86, 0x000000000000ba0d,
  0x0000000000403a09, 0x00000000003fb893,
  0x0000000000003e82, 0x0000000000003e05,
  0x0000000000007d83, 0x0000000000007c87,
  0x00000000003ffc06, 0x00000000003f7b0d,
  0x00000000007f7b08, 0x00000000007e7a11,
  0x0000000000003f01, 0x0000000000003e83,
  0x00000000003fbd84, 0x00000000003f3d09,
  0x00000000007f3c86, 0x00000000007e3c0d,
  0x0000000000bebc07, 0x0000000000bd3b8f,
  0x00000000003f7e83, 0x00000000003efe87,
  0x00000000007efd85, 0x00000000007dfd8b,
  0x0000000000be7d06, 0x0000000000bcfd0d,
  0x000000196724e353, 0x0000001933f03027,
  0x00000000003f7f02, 0x00000000003eff05,
  0x00000000007efe83, 0x00000000007dfe87,
  0x0000001966e564d0, 0x0000001933b131a1,
  0x00000043bc3ab9fb, 0x0000004333b13177,
  0x00000000003f7f81, 0x00000000003eff83,
  0x0000001966a5e5ce, 0x000000193372329d,
  0x00000043bbfb3af9, 0x0000004333723273,
  0x000000833bfb397c, 0x00000082337230f9,
  0x000000196666664d, 0x000000193333331b,
  0x00000043bbbbbb78, 0x00000043333332f1,
  0x000000833bbbb9fb, 0x0000008233333177,
  0x000000c2bbbbb8fd, 0x000000c13333307b,
  0x0000002a5555552b, 0x00000029ffffffd7,
  0x00000069d55553ae, 0x00000068fffffe5d,
  0x000000a9555552b0, 0x000000a7fffffd61,
  0x000000e8d5555231, 0x000000e6fffffce3,
  0x0000003f7ffffe83, 0x0000003efffffe87,
  0x0000007efffffd85, 0x0000007dfffffd8b,
  0x000000be7ffffd06, 0x000000bcfffffd0d,
  0x0000007efffffd06, 0x0000007dfffffd0d,
  0x0000003f7fffff02, 0x0000003effffff05,
  0x0000007efffffe83, 0x0000007dfffffe87,
  0x0000003f7ffffe83, 0x0000003efffffe87,
  0xffffffffffffff02, 0xffffffffffffff05,
  0x0000003f7fffff81, 0x0000003effffff83,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffc080000000, 0xffffffc100000001,
  0xffffff962aaaaa56, 0xffffff96ffffffad,
  0xffffffc080000000, 0xffffffc100000001,
  0xffffff810000007f, 0xffffff820000007f,
  0xffffff56aaaaaad5, 0xffffff580000002b,
  0xffffff3d44444409, 0xffffff3ecccccc93,
  0xffffffc08000007f, 0xffffffc10000007f,
  0xffffff962aaaaad5, 0xffffff970000002b,
  0xffffff7cc4444409, 0xffffff7dcccccc93,
  0xffffff7cc404c409, 0xffffff7dcc8dcc93,
  0xffffffd5aaaaaa56, 0xffffffd5ffffffad,
  0xffffffbc4444438a, 0xffffffbccccccc15,
  0xffffffbc4404c38a, 0xffffffbccc8dcc15,
  0xffffffbc43c54409, 0xffffffbccc4ecc93,
  0xffffffe699999934, 0xffffffe6cccccc69,
  0xffffffe6995a1934, 0xffffffe6cc8dcc69,
  0xffffffe6991a99b3, 0xffffffe6cc4ecce7,
  0xffffffe698db1ab1, 0xffffffe6cc0fcde3,
  0xffffffffffc08000, 0xffffffffffc10001,
  0xffffffffff81007f, 0xffffffffff82007f,
  0xffffffffff41817d, 0xffffffffff43017b,
  0xffffffffff0202fa, 0xffffffffff0402f5,
  0xffffffffffc0807f, 0xffffffffffc1007f,
  0xffffffffff81017d, 0xffffffffff82017b,
  0xffffffffff4182fa, 0xffffffffff4302f5,
  0xffffffffff41437a, 0xffffffffff42c3f5,
  0xffffffffffc080fe, 0xffffffffffc100fd,
  0xffffffffff81027b, 0xffffffffff820277,
  0xffffffffff80c2fb, 0xffffffffff81c377,
  0xffffffffff8083fa, 0xffffffffff8184f5,
  0xffffffffffc0817d, 0xffffffffffc1017b,
  0xffffffffffc041fd, 0xffffffffffc0c27b,
  0xffffffffffc002fc, 0xffffffffffc083f9,
  0xffffffffffbfc47a, 0xffffffffffc045f5,
  0xffffffffffffc080, 0xffffffffffffc101,
  0xffffffffffff817f, 0xffffffffffff827f,
  0xffffffffffff42fd, 0xffffffffffff447b,
  0xffffffffffff04fa, 0xffffffffffff06f5,
  0xffffffffffffc0ff, 0xffffffffffffc17f,
  0xffffffffffff827d, 0xffffffffffff837b,
  0xffffffffffff447a, 0xffffffffffff45f5,
  0xffffffffffff349a, 0xffffffffffff3635,
  0xffffffffffffc17e, 0xffffffffffffc1fd,
  0xffffffffffff837b, 0xffffffffffff8477,
  0xffffffffffff739b, 0xffffffffffff74b7,
  0xffffffffffff721e, 0xffffffffffff733d,
  0xffffffffffffc1fd, 0xffffffffffffc27b,
  0xffffffffffffb21d, 0xffffffffffffb2bb,
  0xffffffffffffb0a0, 0xffffffffffffb141,
  0xffffffffffffafa2, 0xffffffffffffb045,
  0xfffffffffffff020, 0xfffffffffffff041,
  0xffffffffffffeea3, 0xffffffffffffeec7,
  0xffffffffffffeda5, 0xffffffffffffedcb,
  0xffffffffffffed26, 0xffffffffffffed4d,
  0xfffffffffffffe86, 0xfffffffffffffe8a,
  0xfffffffffffffd8a, 0xfffffffffffffd90,
  0xfffffffffffffd0c, 0xfffffffffffffd13,
  0xfffffffffffffd0c, 0xfffffffffffffd13,
  0xffffffffffffff04, 0xffffffffffffff07,
  0xfffffffffffffe86, 0xfffffffffffffe8a,
  0xfffffffffffffe86, 0xfffffffffffffe8a,
  0xffffffffffffff04, 0xffffffffffffff07,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff82, 0xffffffffffffff84,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000000fc, 0x00000000000000fb,
  0x0000000000000000, 0x0000000000000001,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000017a, 0x0000000000000178,
  0x000000000000113a, 0x0000000000001118,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000017a, 0x0000000000000178,
  0x000000000000113a, 0x0000000000001118,
  0x0000000000004ec0, 0x0000000000004e21,
  0x00000000000000fc, 0x00000000000000fb,
  0x00000000000010bc, 0x000000000000109b,
  0x0000000000004e42, 0x0000000000004da4,
  0x0000000000008c46, 0x0000000000008b2a,
  0x0000000000000fc0, 0x0000000000000fa1,
  0x0000000000004d46, 0x0000000000004caa,
  0x0000000000008b4a, 0x0000000000008a30,
  0x000000000000c9cc, 0x000000000000c833,
  0x0000000000003d86, 0x0000000000003d0a,
  0x0000000000007b8a, 0x0000000000007a90,
  0x000000000000ba0c, 0x000000000000b893,
  0x00000000003fb892, 0x00000000003f371c,
  0x0000000000003e04, 0x0000000000003d87,
  0x0000000000007c86, 0x0000000000007b8a,
  0x00000000003f7b0c, 0x00000000003efa13,
  0x00000000007e7a10, 0x00000000007d7919,
  0x0000000000003e82, 0x0000000000003e04,
  0x00000000003f3d08, 0x00000000003ebc8d,
  0x00000000007e3c0c, 0x00000000007d3b93,
  0x0000000000bd3b8e, 0x0000000000bbbb16,
  0x00000000003efe86, 0x00000000003e7e8a,
  0x00000000007dfd8a, 0x00000000007cfd90,
  0x0000000000bcfd0c, 0x0000000000bb7d13,
  0x0000001933f03026, 0x0000001900bb7cfa,
  0x00000000003eff04, 0x00000000003e7f07,
  0x00000000007dfe86, 0x00000000007cfe8a,
  0x0000001933b131a0, 0x00000019007cfe71,
  0x0000004333b13176, 0x00000042ab27a8f2,
  0x00000000003eff82, 0x00000000003e7f84,
  0x000000193372329c, 0x00000019003e7f6b,
  0x0000004333723272, 0x00000042aae929ec,
  0x00000082337230f8, 0x000000812ae92875,
  0x000000193333331a, 0x00000018ffffffe8,
  0x00000043333332f0, 0x00000042aaaaaa69,
  0x0000008233333176, 0x000000812aaaa8f2,
  0x000000c13333307a, 0x000000bfaaaaa7f8,
  0x00000029ffffffd6, 0x00000029aaaaaa82,
  0x00000068fffffe5c, 0x000000682aaaa90b,
  0x000000a7fffffd60, 0x000000a6aaaaa811,
  0x000000e6fffffce2, 0x000000e52aaaa794,
  0x0000003efffffe86, 0x0000003e7ffffe8a,
  0x0000007dfffffd8a, 0x0000007cfffffd90,
  0x000000bcfffffd0c, 0x000000bb7ffffd13,
  0x0000007dfffffd0c, 0x0000007cfffffd13,
  0x0000003effffff04, 0x0000003e7fffff07,
  0x0000007dfffffe86, 0x0000007cfffffe8a,
  0x0000003efffffe86, 0x0000003e7ffffe8a,
  0xffffffffffffff04, 0xffffffffffffff07,
  0x0000003effffff82, 0x0000003e7fffff84,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffc100000000, 0xffffffc180000001,
  0xffffff96ffffffac, 0xffffff97d5555503,
  0xffffffc100000000, 0xffffffc180000001,
  0xffffff820000007e, 0xffffff830000007e,
  0xffffff580000002a, 0xffffff5955555580,
  0xffffff3ecccccc92, 0xffffff405555551c,
  0xffffffc10000007e, 0xffffffc18000007e,
  0xffffff970000002a, 0xffffff97d5555580,
  0xffffff7dcccccc92, 0xffffff7ed555551c,
  0xffffff7dcc8dcc92, 0xffffff7ed516d51c,
  0xffffffd5ffffffac, 0xffffffd655555503,
  0xffffffbccccccc14, 0xffffffbd5555549f,
  0xffffffbccc8dcc14, 0xffffffbd5516d49f,
  0xffffffbccc4ecc92, 0xffffffbd54d8551c,
  0xffffffe6cccccc68, 0xffffffe6ffffff9d,
  0xffffffe6cc8dcc68, 0xffffffe6ffc17f9d,
  0xffffffe6cc4ecce6, 0xffffffe6ff83001a,
  0xffffffe6cc0fcde2, 0xffffffe6ff448114,
  0xffffffffffc10000, 0xffffffffffc18001,
  0xffffffffff82007e, 0xffffffffff83007e,
  0xffffffffff43017a, 0xffffffffff448178,
  0xffffffffff0402f4, 0xffffffffff0602ef,
  0xffffffffffc1007e, 0xffffffffffc1807e,
  0xffffffffff82017a, 0xffffffffff830178,
  0xffffffffff4302f4, 0xffffffffff4482ef,
  0xffffffffff42c3f4, 0xffffffffff44446f,
  0xffffffffffc100fc, 0xffffffffffc180fb,
  0xffffffffff820276, 0xffffffffff830272,
  0xffffffffff81c376, 0xffffffffff82c3f2,
  0xffffffffff8184f4, 0xffffffffff8285ef,
  0xffffffffffc1017a, 0xffffffffffc18178,
  0xffffffffffc0c27a, 0xffffffffffc142f8,
  0xffffffffffc083f8, 0xffffffffffc104f5,
  0xffffffffffc045f4, 0xffffffffffc0c76f,
  0xffffffffffffc100, 0xffffffffffffc181,
  0xffffffffffff827e, 0xffffffffffff837e,
  0xffffffffffff447a, 0xffffffffffff45f8,
  0xffffffffffff06f4, 0xffffffffffff08ef,
  0xffffffffffffc17e, 0xffffffffffffc1fe,
  0xffffffffffff837a, 0xffffffffffff8478,
  0xffffffffffff45f4, 0xffffffffffff476f,
  0xffffffffffff3634, 0xffffffffffff37cf,
  0xffffffffffffc1fc, 0xffffffffffffc27b,
  0xffffffffffff8476, 0xffffffffffff8572,
  0xffffffffffff74b6, 0xffffffffffff75d2,
  0xffffffffffff733c, 0xffffffffffff745b,
  0xffffffffffffc27a, 0xffffffffffffc2f8,
  0xffffffffffffb2ba, 0xffffffffffffb358,
  0xffffffffffffb140, 0xffffffffffffb1e1,
  0xffffffffffffb044, 0xffffffffffffb0e7,
  0xfffffffffffff040, 0xfffffffffffff061,
  0xffffffffffffeec6, 0xffffffffffffeeea,
  0xffffffffffffedca, 0xffffffffffffedf0,
  0xffffffffffffed4c, 0xffffffffffffed73,
  0xfffffffffffffe89, 0xffffffffffffffa1,
  0xfffffffffffffd8f, 0xffffffffffffff61,
  0xfffffffffffffd12, 0xffffffffffffff41,
  0xfffffffffffffd12, 0xffffffffffffff41,
  0xffffffffffffff06, 0xffffffffffffffc1,
  0xfffffffffffffe89, 0xffffffffffffffa1,
  0xfffffffffffffe89, 0xffffffffffffffa1,
  0xffffffffffffff06, 0xffffffffffffffc1,
  0xffffffffffffff83, 0xffffffffffffffe1,
  0xffffffffffffff83, 0xffffffffffffffe1,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000000fa, 0x0000000000000041,
  0x0000000000000000, 0x0000000000000001,
  0x000000000000007d, 0x0000000000000021,
  0x0000000000000177, 0x0000000000000061,
  0x0000000000001117, 0x0000000000000461,
  0x000000000000007d, 0x0000000000000021,
  0x0000000000000177, 0x0000000000000061,
  0x0000000000001117, 0x0000000000000461,
  0x0000000000004e20, 0x0000000000001401,
  0x00000000000000fa, 0x0000000000000041,
  0x000000000000109a, 0x0000000000000441,
  0x0000000000004da3, 0x00000000000013e1,
  0x0000000000008b29, 0x00000000000023a1,
  0x0000000000000fa0, 0x0000000000000401,
  0x0000000000004ca9, 0x00000000000013a1,
  0x0000000000008a2f, 0x0000000000002361,
  0x000000000000c832, 0x0000000000003341,
  0x0000000000003d09, 0x0000000000000fa1,
  0x0000000000007a8f, 0x0000000000001f61,
  0x000000000000b892, 0x0000000000002f41,
  0x00000000003f371b, 0x0000000000102ee1,
  0x0000000000003d86, 0x0000000000000fc1,
  0x0000000000007b89, 0x0000000000001fa1,
  0x00000000003efa12, 0x0000000000101f41,
  0x00000000007d7918, 0x0000000000201f01,
  0x0000000000003e03, 0x0000000000000fe1,
  0x00000000003ebc8c, 0x0000000000100f81,
  0x00000000007d3b92, 0x0000000000200f41,
  0x0000000000bbbb15, 0x0000000000300f21,
  0x00000000003e7e89, 0x00000000000fffa1,
  0x00000000007cfd8f, 0x00000000001fff61,
  0x0000000000bb7d12, 0x00000000002fff41,
  0x0000001900bb7cf9, 0x00000006669665a1,
  0x00000000003e7f06, 0x00000000000fffc1,
  0x00000000007cfe89, 0x00000000001fffa1,
  0x00000019007cfe70, 0x0000000666866601,
  0x00000042ab27a8f1, 0x00000011113110a1,
  0x00000000003e7f83, 0x00000000000fffe1,
  0x00000019003e7f6a, 0x0000000666766641,
  0x00000042aae929eb, 0x00000011112110e1,
  0x000000812ae92874, 0x0000002111211081,
  0x00000018ffffffe7, 0x0000000666666661,
  0x00000042aaaaaa68, 0x0000001111111101,
  0x000000812aaaa8f1, 0x00000021111110a1,
  0x000000bfaaaaa7f7, 0x0000003111111061,
  0x00000029aaaaaa81, 0x0000000aaaaaaaa1,
  0x000000682aaaa90a, 0x0000001aaaaaaa41,
  0x000000a6aaaaa810, 0x0000002aaaaaaa01,
  0x000000e52aaaa793, 0x0000003aaaaaa9e1,
  0x0000003e7ffffe89, 0x0000000fffffffa1,
  0x0000007cfffffd8f, 0x0000001fffffff61,
  0x000000bb7ffffd12, 0x0000002fffffff41,
  0x0000007cfffffd12, 0x0000001fffffff41,
  0x0000003e7fffff06, 0x0000000fffffffc1,
  0x0000007cfffffe89, 0x0000001fffffffa1,
  0x0000003e7ffffe89, 0x0000000fffffffa1,
  0xffffffffffffff06, 0xffffffffffffffc1,
  0x0000003e7fffff83, 0x0000000fffffffe1,
  0xffffffffffffff83, 0xffffffffffffffe1,
  0xffffffc180000000, 0xfffffff000000001,
  0xffffff97d5555502, 0xffffffe555555541,
  0xffffffc180000000, 0xfffffff000000001,
  0xffffff830000007d, 0xffffffe000000021,
  0xffffff595555557f, 0xffffffd555555561,
  0xffffff405555551b, 0xffffffceeeeeeee1,
  0xffffffc18000007d, 0xfffffff000000021,
  0xffffff97d555557f, 0xffffffe555555561,
  0xffffff7ed555551b, 0xffffffdeeeeeeee1,
  0xffffff7ed516d51b, 0xffffffdeeedeeee1,
  0xffffffd655555502, 0xfffffff555555541,
  0xffffffbd5555549e, 0xffffffeeeeeeeec1,
  0xffffffbd5516d49e, 0xffffffeeeedeeec1,
  0xffffffbd54d8551b, 0xffffffeeeeceeee1,
  0xffffffe6ffffff9c, 0xfffffff999999981,
  0xffffffe6ffc17f9c, 0xfffffff999899981,
  0xffffffe6ff830019, 0xfffffff9997999a1,
  0xffffffe6ff448113, 0xfffffff9996999e1,
  0xffffffffffc18000, 0xfffffffffff00001,
  0xffffffffff83007d, 0xffffffffffe00021,
  0xffffffffff448177, 0xffffffffffd00061,
  0xffffffffff0602ee, 0xffffffffffc000c1,
  0xffffffffffc1807d, 0xfffffffffff00021,
  0xffffffffff830177, 0xffffffffffe00061,
  0xffffffffff4482ee, 0xffffffffffd000c1,
  0xffffffffff44446e, 0xffffffffffcff0c1,
  0xffffffffffc180fa, 0xfffffffffff00041,
  0xffffffffff830271, 0xffffffffffe000a1,
  0xffffffffff82c3f1, 0xffffffffffdff0a1,
  0xffffffffff8285ee, 0xffffffffffdfe0c1,
  0xffffffffffc18177, 0xfffffffffff00061,
  0xffffffffffc142f7, 0xffffffffffeff061,
  0xffffffffffc104f4, 0xffffffffffefe081,
  0xffffffffffc0c76e, 0xffffffffffefd0c1,
  0xffffffffffffc180, 0xfffffffffffff001,
  0xffffffffffff837d, 0xffffffffffffe021,
  0xffffffffffff45f7, 0xffffffffffffd061,
  0xffffffffffff08ee, 0xffffffffffffc0c1,
  0xffffffffffffc1fd, 0xfffffffffffff021,
  0xffffffffffff8477, 0xffffffffffffe061,
  0xffffffffffff476e, 0xffffffffffffd0c1,
  0xffffffffffff37ce, 0xffffffffffffccc1,
  0xffffffffffffc27a, 0xfffffffffffff041,
  0xffffffffffff8571, 0xffffffffffffe0a1,
  0xffffffffffff75d1, 0xffffffffffffdca1,
  0xffffffffffff745a, 0xffffffffffffdc41,
  0xffffffffffffc2f7, 0xfffffffffffff061,
  0xffffffffffffb357, 0xffffffffffffec61,
  0xffffffffffffb1e0, 0xffffffffffffec01,
  0xffffffffffffb0e6, 0xffffffffffffebc1,
  0xfffffffffffff060, 0xfffffffffffffc01,
  0xffffffffffffeee9, 0xfffffffffffffba1,
  0xffffffffffffedef, 0xfffffffffffffb61,
  0xffffffffffffed72, 0xfffffffffffffb41,
  0xffffffffffffffa0, 0xfffffffffffffff8,
  0xffffffffffffff60, 0xfffffffffffffff2,
  0xffffffffffffff40, 0xffffffffffffffef,
  0xffffffffffffff40, 0xffffffffffffffef,
  0xffffffffffffffc0, 0xfffffffffffffffb,
  0xffffffffffffffa0, 0xfffffffffffffff8,
  0xffffffffffffffa0, 0xfffffffffffffff8,
  0xffffffffffffffc0, 0xfffffffffffffffb,
  0xffffffffffffffe0, 0xfffffffffffffffe,
  0xffffffffffffffe0, 0xfffffffffffffffe,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000040, 0x0000000000000007,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000020, 0x0000000000000004,
  0x0000000000000060, 0x000000000000000a,
  0x0000000000000460, 0x000000000000006a,
  0x0000000000000020, 0x0000000000000004,
  0x0000000000000060, 0x000000000000000a,
  0x0000000000000460, 0x000000000000006a,
  0x0000000000001400, 0x00000000000001e1,
  0x0000000000000040, 0x0000000000000007,
  0x0000000000000440, 0x0000000000000067,
  0x00000000000013e0, 0x00000000000001de,
  0x00000000000023a0, 0x0000000000000358,
  0x0000000000000400, 0x0000000000000061,
  0x00000000000013a0, 0x00000000000001d8,
  0x0000000000002360, 0x0000000000000352,
  0x0000000000003340, 0x00000000000004cf,
  0x0000000000000fa0, 0x0000000000000178,
  0x0000000000001f60, 0x00000000000002f2,
  0x0000000000002f40, 0x000000000000046f,
  0x0000000000102ee0, 0x0000000000018466,
  0x0000000000000fc0, 0x000000000000017b,
  0x0000000000001fa0, 0x00000000000002f8,
  0x0000000000101f40, 0x00000000000182ef,
  0x0000000000201f00, 0x00000000000302e9,
  0x0000000000000fe0, 0x000000000000017e,
  0x0000000000100f80, 0x0000000000018175,
  0x0000000000200f40, 0x000000000003016f,
  0x0000000000300f20, 0x000000000004816c,
  0x00000000000fffa0, 0x0000000000017ff8,
  0x00000000001fff60, 0x000000000002fff2,
  0x00000000002fff40, 0x0000000000047fef,
  0x00000006669665a0, 0x00000000999e1988,
  0x00000000000fffc0, 0x0000000000017ffb,
  0x00000000001fffa0, 0x000000000002fff8,
  0x0000000666866600, 0x00000000999c9991,
  0x00000011113110a0, 0x00000001999c9990,
  0x00000000000fffe0, 0x0000000000017ffe,
  0x0000000666766640, 0x00000000999b1997,
  0x00000011112110e0, 0x00000001999b1996,
  0x0000002111211080, 0x00000003199b198d,
  0x0000000666666660, 0x000000009999999a,
  0x0000001111111100, 0x0000000199999999,
  0x00000021111110a0, 0x0000000319999990,
  0x0000003111111060, 0x000000049999998a,
  0x0000000aaaaaaaa0, 0x0000000100000000,
  0x0000001aaaaaaa40, 0x000000027ffffff7,
  0x0000002aaaaaaa00, 0x00000003fffffff1,
  0x0000003aaaaaa9e0, 0x000000057fffffee,
  0x0000000fffffffa0, 0x000000017ffffff8,
  0x0000001fffffff60, 0x00000002fffffff2,
  0x0000002fffffff40, 0x000000047fffffef,
  0x0000001fffffff40, 0x00000002ffffffef,
  0x0000000fffffffc0, 0x000000017ffffffb,
  0x0000001fffffffa0, 0x00000002fffffff8,
  0x0000000fffffffa0, 0x000000017ffffff8,
  0xffffffffffffffc0, 0xfffffffffffffffb,
  0x0000000fffffffe0, 0x000000017ffffffe,
  0xffffffffffffffe0, 0xfffffffffffffffe,
  0xfffffff000000000, 0xfffffffe80000001,
  0xffffffe555555540, 0xfffffffd7fffffff,
  0xfffffff000000000, 0xfffffffe80000001,
  0xffffffe000000020, 0xfffffffd00000004,
  0xffffffd555555560, 0xfffffffc00000002,
  0xffffffceeeeeeee0, 0xfffffffb66666666,
  0xfffffff000000020, 0xfffffffe80000004,
  0xffffffe555555560, 0xfffffffd80000002,
  0xffffffdeeeeeeee0, 0xfffffffce6666666,
  0xffffffdeeedeeee0, 0xfffffffce664e666,
  0xfffffff555555540, 0xfffffffeffffffff,
  0xffffffeeeeeeeec0, 0xfffffffe66666663,
  0xffffffeeeedeeec0, 0xfffffffe6664e663,
  0xffffffeeeeceeee0, 0xfffffffe66636666,
  0xfffffff999999980, 0xffffffff66666665,
  0xfffffff999899980, 0xffffffff6664e665,
  0xfffffff9997999a0, 0xffffffff66636668,
  0xfffffff9996999e0, 0xffffffff6661e66e,
  0xfffffffffff00000, 0xfffffffffffe8001,
  0xffffffffffe00020, 0xfffffffffffd0004,
  0xffffffffffd00060, 0xfffffffffffb800a,
  0xffffffffffc000c0, 0xfffffffffffa0013,
  0xfffffffffff00020, 0xfffffffffffe8004,
  0xffffffffffe00060, 0xfffffffffffd000a,
  0xffffffffffd000c0, 0xfffffffffffb8013,
  0xffffffffffcff0c0, 0xfffffffffffb7e93,
  0xfffffffffff00040, 0xfffffffffffe8007,
  0xffffffffffe000a0, 0xfffffffffffd0010,
  0xffffffffffdff0a0, 0xfffffffffffcfe90,
  0xffffffffffdfe0c0, 0xfffffffffffcfd13,
  0xfffffffffff00060, 0xfffffffffffe800a,
  0xffffffffffeff060, 0xfffffffffffe7e8a,
  0xffffffffffefe080, 0xfffffffffffe7d0d,
  0xffffffffffefd0c0, 0xfffffffffffe7b93,
  0xfffffffffffff000, 0xfffffffffffffe81,
  0xffffffffffffe020, 0xfffffffffffffd04,
  0xffffffffffffd060, 0xfffffffffffffb8a,
  0xffffffffffffc0c0, 0xfffffffffffffa13,
  0xfffffffffffff020, 0xfffffffffffffe84,
  0xffffffffffffe060, 0xfffffffffffffd0a,
  0xffffffffffffd0c0, 0xfffffffffffffb93,
  0xffffffffffffccc0, 0xfffffffffffffb33,
  0xfffffffffffff040, 0xfffffffffffffe87,
  0xffffffffffffe0a0, 0xfffffffffffffd10,
  0xffffffffffffdca0, 0xfffffffffffffcb0,
  0xffffffffffffdc40, 0xfffffffffffffca7,
  0xfffffffffffff060, 0xfffffffffffffe8a,
  0xffffffffffffec60, 0xfffffffffffffe2a,
  0xffffffffffffec00, 0xfffffffffffffe21,
  0xffffffffffffebc0, 0xfffffffffffffe1b,
  0xfffffffffffffc00, 0xffffffffffffffa1,
  0xfffffffffffffba0, 0xffffffffffffff98,
  0xfffffffffffffb60, 0xffffffffffffff92,
  0xfffffffffffffb40, 0xffffffffffffff8f,
};
const unsigned kExpectedCount_NEON_smlsl_2D_2S_S = 3844;

#endif  // VIXL_SIM_SMLSL_2D_2S_S_TRACE_AARCH64_H_
