// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_ADD_8H_TRACE_AARCH64_H_
#define VIXL_SIM_ADD_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_add_8H[] = {
  0x00fc, 0x00fe, 0x6666, 0xaaaa, 0xfffa, 0xfffc, 0xfffe, 0x0000,
  0x00fd, 0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd, 0x7fff, 0x0001,
  0x33b1, 0x55d4, 0xb330, 0xd553, 0xfffc, 0x7ffe, 0x8000, 0x0002,
  0x55d3, 0x807c, 0xb331, 0xd554, 0x7ffd, 0x7fff, 0x8001, 0x0010,
  0x807b, 0x807d, 0xb332, 0x5555, 0x7ffe, 0x8000, 0x800f, 0x007d,
  0x807c, 0x807e, 0x3333, 0x5556, 0x7fff, 0x800e, 0x807c, 0x007e,
  0x807d, 0x007f, 0x3334, 0x5557, 0x800d, 0x807b, 0x807d, 0x007f,
  0x007e, 0x0080, 0x3335, 0x5565, 0x807a, 0x807c, 0x807e, 0x3333,
  0x007f, 0x0081, 0x3343, 0x55d2, 0x807b, 0x807d, 0xb332, 0x5555,
  0x0080, 0x008f, 0x33b0, 0x55d3, 0x807c, 0xb331, 0xd554, 0x7ffd,
  0x008e, 0x00fc, 0x33b1, 0x55d4, 0xb330, 0xd553, 0xfffc, 0x7ffe,
  0x00fb, 0x00fd, 0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd, 0x7fff,
  0x00fc, 0x00fe, 0x6666, 0xaaaa, 0xfffa, 0xfffc, 0xfffe, 0x8000,
  0x00fd, 0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd, 0xffff, 0x8001,
  0x33b1, 0x55d4, 0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000, 0xaaaa,
  0x55d3, 0x807c, 0xb331, 0xd554, 0xfffd, 0xffff, 0x2aa9, 0xcccc,
  0x807b, 0x807d, 0xb332, 0xd555, 0xfffe, 0x2aa8, 0x4ccb, 0xff80,
  0x807c, 0x807e, 0xb333, 0xd556, 0x2aa7, 0x4cca, 0x7f7f, 0xff81,
  0x807d, 0x807f, 0xb334, 0xffff, 0x4cc9, 0x7f7e, 0x7f80, 0xff82,
  0x807e, 0x8080, 0xdddd, 0x2221, 0x7f7d, 0x7f7f, 0x7f81, 0xff83,
  0x807f, 0xab29, 0xffff, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0xfff0,
  0xab28, 0xcd4b, 0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fef, 0xfffd,
  0xcd4a, 0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fee, 0x7ffc, 0xfffe,
  0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fed, 0x7ffb, 0x7ffd, 0xffff,
  0x0000, 0x32b5, 0x54d8, 0x7fed, 0x7ffb, 0x7ffd, 0xffff, 0x0001,
  0x0001, 0x32b6, 0x5545, 0x7ffa, 0x7ffc, 0x7ffe, 0x0000, 0x0002,
  0x0002, 0x3323, 0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x0001, 0x0003,
  0x006f, 0x3330, 0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x0002, 0x0011,
  0x007c, 0x3331, 0x5554, 0x7ffd, 0x7fff, 0x8001, 0x0010, 0x007e,
  0x007d, 0x3332, 0x5555, 0x7ffe, 0x8000, 0x800f, 0x007d, 0x007f,
  0x007e, 0x3333, 0x5556, 0x7fff, 0x800e, 0x807c, 0x007e, 0x0080,
  0x007f, 0x3334, 0x5557, 0x800d, 0x807b, 0x807d, 0x007f, 0x3334,
  0x0080, 0x3335, 0x5565, 0x807a, 0x807c, 0x807e, 0x3333, 0x5556,
  0x0081, 0x3343, 0x55d2, 0x807b, 0x807d, 0xb332, 0x5555, 0x7ffe,
  0x008f, 0x33b0, 0x55d3, 0x807c, 0xb331, 0xd554, 0x7ffd, 0x7fff,
  0x00fc, 0x33b1, 0x55d4, 0xb330, 0xd553, 0xfffc, 0x7ffe, 0x8000,
  0x00fd, 0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd, 0x7fff, 0x8001,
  0x00fe, 0x6666, 0xaaaa, 0xfffa, 0xfffc, 0xfffe, 0x8000, 0x8002,
  0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd, 0xffff, 0x8001, 0xaaab,
  0x55d4, 0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000, 0xaaaa, 0xcccd,
  0x807c, 0xb331, 0xd554, 0xfffd, 0xffff, 0x2aa9, 0xcccc, 0xff81,
  0x807d, 0xb332, 0xd555, 0xfffe, 0x2aa8, 0x4ccb, 0xff80, 0xff82,
  0x807e, 0xb333, 0xd556, 0x2aa7, 0x4cca, 0x7f7f, 0xff81, 0xff83,
  0x807f, 0xb334, 0xffff, 0x4cc9, 0x7f7e, 0x7f80, 0xff82, 0xff84,
  0x8080, 0xdddd, 0x2221, 0x7f7d, 0x7f7f, 0x7f81, 0xff83, 0xfff1,
  0xab29, 0xffff, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0xfff0, 0xfffe,
  0xcd4b, 0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fef, 0xfffd, 0xffff,
  0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fee, 0x7ffc, 0xfffe, 0x0000,
  0x32b4, 0x54d7, 0x7f80, 0x7fee, 0x7ffc, 0xfffe, 0x0000, 0x0002,
  0x32b5, 0x54d8, 0x7fed, 0x7ffb, 0x7ffd, 0xffff, 0x0001, 0x0003,
  0x32b6, 0x5545, 0x7ffa, 0x7ffc, 0x7ffe, 0x0000, 0x0002, 0x0004,
  0x3323, 0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x0001, 0x0003, 0x0012,
  0x3330, 0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x0002, 0x0011, 0x007f,
  0x3331, 0x5554, 0x7ffd, 0x7fff, 0x8001, 0x0010, 0x007e, 0x0080,
  0x3332, 0x5555, 0x7ffe, 0x8000, 0x800f, 0x007d, 0x007f, 0x0081,
  0x3333, 0x5556, 0x7fff, 0x800e, 0x807c, 0x007e, 0x0080, 0x3335,
  0x3334, 0x5557, 0x800d, 0x807b, 0x807d, 0x007f, 0x3334, 0x5557,
  0x3335, 0x5565, 0x807a, 0x807c, 0x807e, 0x3333, 0x5556, 0x7fff,
  0x3343, 0x55d2, 0x807b, 0x807d, 0xb332, 0x5555, 0x7ffe, 0x8000,
  0x33b0, 0x55d3, 0x807c, 0xb331, 0xd554, 0x7ffd, 0x7fff, 0x8001,
  0x33b1, 0x55d4, 0xb330, 0xd553, 0xfffc, 0x7ffe, 0x8000, 0x8002,
  0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd, 0x7fff, 0x8001, 0x8003,
  0x6666, 0xaaaa, 0xfffa, 0xfffc, 0xfffe, 0x8000, 0x8002, 0xaaac,
  0x8888, 0xd552, 0xfffb, 0xfffd, 0xffff, 0x8001, 0xaaab, 0xccce,
  0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000, 0xaaaa, 0xcccd, 0xff82,
  0xb331, 0xd554, 0xfffd, 0xffff, 0x2aa9, 0xcccc, 0xff81, 0xff83,
  0xb332, 0xd555, 0xfffe, 0x2aa8, 0x4ccb, 0xff80, 0xff82, 0xff84,
  0xb333, 0xd556, 0x2aa7, 0x4cca, 0x7f7f, 0xff81, 0xff83, 0xff85,
  0xb334, 0xffff, 0x4cc9, 0x7f7e, 0x7f80, 0xff82, 0xff84, 0xfff2,
  0xdddd, 0x2221, 0x7f7d, 0x7f7f, 0x7f81, 0xff83, 0xfff1, 0xffff,
  0xffff, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0xfff0, 0xfffe, 0x0000,
  0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fef, 0xfffd, 0xffff, 0x0001,
  0x54d6, 0x7f7f, 0x7f81, 0x7fef, 0xfffd, 0xffff, 0x0001, 0x0010,
  0x54d7, 0x7f80, 0x7fee, 0x7ffc, 0xfffe, 0x0000, 0x0002, 0x0011,
  0x54d8, 0x7fed, 0x7ffb, 0x7ffd, 0xffff, 0x0001, 0x0003, 0x0012,
  0x5545, 0x7ffa, 0x7ffc, 0x7ffe, 0x0000, 0x0002, 0x0004, 0x0020,
  0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x0001, 0x0003, 0x0012, 0x008d,
  0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x0002, 0x0011, 0x007f, 0x008e,
  0x5554, 0x7ffd, 0x7fff, 0x8001, 0x0010, 0x007e, 0x0080, 0x008f,
  0x5555, 0x7ffe, 0x8000, 0x800f, 0x007d, 0x007f, 0x0081, 0x3343,
  0x5556, 0x7fff, 0x800e, 0x807c, 0x007e, 0x0080, 0x3335, 0x5565,
  0x5557, 0x800d, 0x807b, 0x807d, 0x007f, 0x3334, 0x5557, 0x800d,
  0x5565, 0x807a, 0x807c, 0x807e, 0x3333, 0x5556, 0x7fff, 0x800e,
  0x55d2, 0x807b, 0x807d, 0xb332, 0x5555, 0x7ffe, 0x8000, 0x800f,
  0x55d3, 0x807c, 0xb331, 0xd554, 0x7ffd, 0x7fff, 0x8001, 0x8010,
  0x55d4, 0xb330, 0xd553, 0xfffc, 0x7ffe, 0x8000, 0x8002, 0x8011,
  0x8888, 0xd552, 0xfffb, 0xfffd, 0x7fff, 0x8001, 0x8003, 0xaaba,
  0xaaaa, 0xfffa, 0xfffc, 0xfffe, 0x8000, 0x8002, 0xaaac, 0xccdc,
  0xd552, 0xfffb, 0xfffd, 0xffff, 0x8001, 0xaaab, 0xccce, 0xff90,
  0xd553, 0xfffc, 0xfffe, 0x0000, 0xaaaa, 0xcccd, 0xff82, 0xff91,
  0xd554, 0xfffd, 0xffff, 0x2aa9, 0xcccc, 0xff81, 0xff83, 0xff92,
  0xd555, 0xfffe, 0x2aa8, 0x4ccb, 0xff80, 0xff82, 0xff84, 0xff93,
  0xd556, 0x2aa7, 0x4cca, 0x7f7f, 0xff81, 0xff83, 0xff85, 0x0000,
  0xffff, 0x4cc9, 0x7f7e, 0x7f80, 0xff82, 0xff84, 0xfff2, 0x000d,
  0x2221, 0x7f7d, 0x7f7f, 0x7f81, 0xff83, 0xfff1, 0xffff, 0x000e,
  0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0xfff0, 0xfffe, 0x0000, 0x000f,
  0x7f7e, 0x7f80, 0x7f82, 0xfff0, 0xfffe, 0x0000, 0x000f, 0x007d,
  0x7f7f, 0x7f81, 0x7fef, 0xfffd, 0xffff, 0x0001, 0x0010, 0x007e,
  0x7f80, 0x7fee, 0x7ffc, 0xfffe, 0x0000, 0x0002, 0x0011, 0x007f,
  0x7fed, 0x7ffb, 0x7ffd, 0xffff, 0x0001, 0x0003, 0x0012, 0x008d,
  0x7ffa, 0x7ffc, 0x7ffe, 0x0000, 0x0002, 0x0004, 0x0020, 0x00fa,
  0x7ffb, 0x7ffd, 0x7fff, 0x0001, 0x0003, 0x0012, 0x008d, 0x00fb,
  0x7ffc, 0x7ffe, 0x8000, 0x0002, 0x0011, 0x007f, 0x008e, 0x00fc,
  0x7ffd, 0x7fff, 0x8001, 0x0010, 0x007e, 0x0080, 0x008f, 0x33b0,
  0x7ffe, 0x8000, 0x800f, 0x007d, 0x007f, 0x0081, 0x3343, 0x55d2,
  0x7fff, 0x800e, 0x807c, 0x007e, 0x0080, 0x3335, 0x5565, 0x807a,
  0x800d, 0x807b, 0x807d, 0x007f, 0x3334, 0x5557, 0x800d, 0x807b,
  0x807a, 0x807c, 0x807e, 0x3333, 0x5556, 0x7fff, 0x800e, 0x807c,
  0x807b, 0x807d, 0xb332, 0x5555, 0x7ffe, 0x8000, 0x800f, 0x807d,
  0x807c, 0xb331, 0xd554, 0x7ffd, 0x7fff, 0x8001, 0x8010, 0x807e,
  0xb330, 0xd553, 0xfffc, 0x7ffe, 0x8000, 0x8002, 0x8011, 0xab27,
  0xd552, 0xfffb, 0xfffd, 0x7fff, 0x8001, 0x8003, 0xaaba, 0xcd49,
  0xfffa, 0xfffc, 0xfffe, 0x8000, 0x8002, 0xaaac, 0xccdc, 0xfffd,
  0xfffb, 0xfffd, 0xffff, 0x8001, 0xaaab, 0xccce, 0xff90, 0xfffe,
  0xfffc, 0xfffe, 0x0000, 0xaaaa, 0xcccd, 0xff82, 0xff91, 0xffff,
  0xfffd, 0xffff, 0x2aa9, 0xcccc, 0xff81, 0xff83, 0xff92, 0x0000,
  0xfffe, 0x2aa8, 0x4ccb, 0xff80, 0xff82, 0xff84, 0xff93, 0x006d,
  0x2aa7, 0x4cca, 0x7f7f, 0xff81, 0xff83, 0xff85, 0x0000, 0x007a,
  0x4cc9, 0x7f7e, 0x7f80, 0xff82, 0xff84, 0xfff2, 0x000d, 0x007b,
  0x7f7d, 0x7f7f, 0x7f81, 0xff83, 0xfff1, 0xffff, 0x000e, 0x007c,
  0x7f7f, 0x7f81, 0xff83, 0xfff1, 0xffff, 0x000e, 0x007c, 0x007e,
  0x7f80, 0x7f82, 0xfff0, 0xfffe, 0x0000, 0x000f, 0x007d, 0x007f,
  0x7f81, 0x7fef, 0xfffd, 0xffff, 0x0001, 0x0010, 0x007e, 0x0080,
  0x7fee, 0x7ffc, 0xfffe, 0x0000, 0x0002, 0x0011, 0x007f, 0x008e,
  0x7ffb, 0x7ffd, 0xffff, 0x0001, 0x0003, 0x0012, 0x008d, 0x00fb,
  0x7ffc, 0x7ffe, 0x0000, 0x0002, 0x0004, 0x0020, 0x00fa, 0x00fc,
  0x7ffd, 0x7fff, 0x0001, 0x0003, 0x0012, 0x008d, 0x00fb, 0x00fd,
  0x7ffe, 0x8000, 0x0002, 0x0011, 0x007f, 0x008e, 0x00fc, 0x33b1,
  0x7fff, 0x8001, 0x0010, 0x007e, 0x0080, 0x008f, 0x33b0, 0x55d3,
  0x8000, 0x800f, 0x007d, 0x007f, 0x0081, 0x3343, 0x55d2, 0x807b,
  0x800e, 0x807c, 0x007e, 0x0080, 0x3335, 0x5565, 0x807a, 0x807c,
  0x807b, 0x807d, 0x007f, 0x3334, 0x5557, 0x800d, 0x807b, 0x807d,
  0x807c, 0x807e, 0x3333, 0x5556, 0x7fff, 0x800e, 0x807c, 0x807e,
  0x807d, 0xb332, 0x5555, 0x7ffe, 0x8000, 0x800f, 0x807d, 0x807f,
  0xb331, 0xd554, 0x7ffd, 0x7fff, 0x8001, 0x8010, 0x807e, 0xab28,
  0xd553, 0xfffc, 0x7ffe, 0x8000, 0x8002, 0x8011, 0xab27, 0xcd4a,
  0xfffb, 0xfffd, 0x7fff, 0x8001, 0x8003, 0xaaba, 0xcd49, 0xfffe,
  0xfffc, 0xfffe, 0x8000, 0x8002, 0xaaac, 0xccdc, 0xfffd, 0xffff,
  0xfffd, 0xffff, 0x8001, 0xaaab, 0xccce, 0xff90, 0xfffe, 0x0000,
  0xfffe, 0x0000, 0xaaaa, 0xcccd, 0xff82, 0xff91, 0xffff, 0x0001,
  0xffff, 0x2aa9, 0xcccc, 0xff81, 0xff83, 0xff92, 0x0000, 0x006e,
  0x2aa8, 0x4ccb, 0xff80, 0xff82, 0xff84, 0xff93, 0x006d, 0x007b,
  0x4cca, 0x7f7f, 0xff81, 0xff83, 0xff85, 0x0000, 0x007a, 0x007c,
  0x7f7e, 0x7f80, 0xff82, 0xff84, 0xfff2, 0x000d, 0x007b, 0x007d,
  0x7f80, 0xff82, 0xff84, 0xfff2, 0x000d, 0x007b, 0x007d, 0x007f,
  0x7f81, 0xff83, 0xfff1, 0xffff, 0x000e, 0x007c, 0x007e, 0x0080,
  0x7f82, 0xfff0, 0xfffe, 0x0000, 0x000f, 0x007d, 0x007f, 0x0081,
  0x7fef, 0xfffd, 0xffff, 0x0001, 0x0010, 0x007e, 0x0080, 0x008f,
  0x7ffc, 0xfffe, 0x0000, 0x0002, 0x0011, 0x007f, 0x008e, 0x00fc,
  0x7ffd, 0xffff, 0x0001, 0x0003, 0x0012, 0x008d, 0x00fb, 0x00fd,
  0x7ffe, 0x0000, 0x0002, 0x0004, 0x0020, 0x00fa, 0x00fc, 0x00fe,
  0x7fff, 0x0001, 0x0003, 0x0012, 0x008d, 0x00fb, 0x00fd, 0x33b2,
  0x8000, 0x0002, 0x0011, 0x007f, 0x008e, 0x00fc, 0x33b1, 0x55d4,
  0x8001, 0x0010, 0x007e, 0x0080, 0x008f, 0x33b0, 0x55d3, 0x807c,
  0x800f, 0x007d, 0x007f, 0x0081, 0x3343, 0x55d2, 0x807b, 0x807d,
  0x807c, 0x007e, 0x0080, 0x3335, 0x5565, 0x807a, 0x807c, 0x807e,
  0x807d, 0x007f, 0x3334, 0x5557, 0x800d, 0x807b, 0x807d, 0x807f,
  0x807e, 0x3333, 0x5556, 0x7fff, 0x800e, 0x807c, 0x807e, 0x8080,
  0xb332, 0x5555, 0x7ffe, 0x8000, 0x800f, 0x807d, 0x807f, 0xab29,
  0xd554, 0x7ffd, 0x7fff, 0x8001, 0x8010, 0x807e, 0xab28, 0xcd4b,
  0xfffc, 0x7ffe, 0x8000, 0x8002, 0x8011, 0xab27, 0xcd4a, 0xffff,
  0xfffd, 0x7fff, 0x8001, 0x8003, 0xaaba, 0xcd49, 0xfffe, 0x0000,
  0xfffe, 0x8000, 0x8002, 0xaaac, 0xccdc, 0xfffd, 0xffff, 0x0001,
  0xffff, 0x8001, 0xaaab, 0xccce, 0xff90, 0xfffe, 0x0000, 0x0002,
  0x0000, 0xaaaa, 0xcccd, 0xff82, 0xff91, 0xffff, 0x0001, 0x006f,
  0x2aa9, 0xcccc, 0xff81, 0xff83, 0xff92, 0x0000, 0x006e, 0x007c,
  0x4ccb, 0xff80, 0xff82, 0xff84, 0xff93, 0x006d, 0x007b, 0x007d,
  0x7f7f, 0xff81, 0xff83, 0xff85, 0x0000, 0x007a, 0x007c, 0x007e,
  0xff81, 0xff83, 0xff85, 0x0000, 0x007a, 0x007c, 0x007e, 0x3333,
  0xff82, 0xff84, 0xfff2, 0x000d, 0x007b, 0x007d, 0x007f, 0x3334,
  0xff83, 0xfff1, 0xffff, 0x000e, 0x007c, 0x007e, 0x0080, 0x3335,
  0xfff0, 0xfffe, 0x0000, 0x000f, 0x007d, 0x007f, 0x0081, 0x3343,
  0xfffd, 0xffff, 0x0001, 0x0010, 0x007e, 0x0080, 0x008f, 0x33b0,
  0xfffe, 0x0000, 0x0002, 0x0011, 0x007f, 0x008e, 0x00fc, 0x33b1,
  0xffff, 0x0001, 0x0003, 0x0012, 0x008d, 0x00fb, 0x00fd, 0x33b2,
  0x0000, 0x0002, 0x0004, 0x0020, 0x00fa, 0x00fc, 0x00fe, 0x6666,
  0x0001, 0x0003, 0x0012, 0x008d, 0x00fb, 0x00fd, 0x33b2, 0x8888,
  0x0002, 0x0011, 0x007f, 0x008e, 0x00fc, 0x33b1, 0x55d4, 0xb330,
  0x0010, 0x007e, 0x0080, 0x008f, 0x33b0, 0x55d3, 0x807c, 0xb331,
  0x007d, 0x007f, 0x0081, 0x3343, 0x55d2, 0x807b, 0x807d, 0xb332,
  0x007e, 0x0080, 0x3335, 0x5565, 0x807a, 0x807c, 0x807e, 0xb333,
  0x007f, 0x3334, 0x5557, 0x800d, 0x807b, 0x807d, 0x807f, 0xb334,
  0x3333, 0x5556, 0x7fff, 0x800e, 0x807c, 0x807e, 0x8080, 0xdddd,
  0x5555, 0x7ffe, 0x8000, 0x800f, 0x807d, 0x807f, 0xab29, 0xffff,
  0x7ffd, 0x7fff, 0x8001, 0x8010, 0x807e, 0xab28, 0xcd4b, 0x32b3,
  0x7ffe, 0x8000, 0x8002, 0x8011, 0xab27, 0xcd4a, 0xffff, 0x32b4,
  0x7fff, 0x8001, 0x8003, 0xaaba, 0xcd49, 0xfffe, 0x0000, 0x32b5,
  0x8000, 0x8002, 0xaaac, 0xccdc, 0xfffd, 0xffff, 0x0001, 0x32b6,
  0x8001, 0xaaab, 0xccce, 0xff90, 0xfffe, 0x0000, 0x0002, 0x3323,
  0xaaaa, 0xcccd, 0xff82, 0xff91, 0xffff, 0x0001, 0x006f, 0x3330,
  0xcccc, 0xff81, 0xff83, 0xff92, 0x0000, 0x006e, 0x007c, 0x3331,
  0xff80, 0xff82, 0xff84, 0xff93, 0x006d, 0x007b, 0x007d, 0x3332,
  0xff82, 0xff84, 0xff93, 0x006d, 0x007b, 0x007d, 0x3332, 0x5555,
  0xff83, 0xff85, 0x0000, 0x007a, 0x007c, 0x007e, 0x3333, 0x5556,
  0xff84, 0xfff2, 0x000d, 0x007b, 0x007d, 0x007f, 0x3334, 0x5557,
  0xfff1, 0xffff, 0x000e, 0x007c, 0x007e, 0x0080, 0x3335, 0x5565,
  0xfffe, 0x0000, 0x000f, 0x007d, 0x007f, 0x0081, 0x3343, 0x55d2,
  0xffff, 0x0001, 0x0010, 0x007e, 0x0080, 0x008f, 0x33b0, 0x55d3,
  0x0000, 0x0002, 0x0011, 0x007f, 0x008e, 0x00fc, 0x33b1, 0x55d4,
  0x0001, 0x0003, 0x0012, 0x008d, 0x00fb, 0x00fd, 0x33b2, 0x8888,
  0x0002, 0x0004, 0x0020, 0x00fa, 0x00fc, 0x00fe, 0x6666, 0xaaaa,
  0x0003, 0x0012, 0x008d, 0x00fb, 0x00fd, 0x33b2, 0x8888, 0xd552,
  0x0011, 0x007f, 0x008e, 0x00fc, 0x33b1, 0x55d4, 0xb330, 0xd553,
  0x007e, 0x0080, 0x008f, 0x33b0, 0x55d3, 0x807c, 0xb331, 0xd554,
  0x007f, 0x0081, 0x3343, 0x55d2, 0x807b, 0x807d, 0xb332, 0xd555,
  0x0080, 0x3335, 0x5565, 0x807a, 0x807c, 0x807e, 0xb333, 0xd556,
  0x3334, 0x5557, 0x800d, 0x807b, 0x807d, 0x807f, 0xb334, 0xffff,
  0x5556, 0x7fff, 0x800e, 0x807c, 0x807e, 0x8080, 0xdddd, 0x2221,
  0x7ffe, 0x8000, 0x800f, 0x807d, 0x807f, 0xab29, 0xffff, 0x54d5,
  0x7fff, 0x8001, 0x8010, 0x807e, 0xab28, 0xcd4b, 0x32b3, 0x54d6,
  0x8000, 0x8002, 0x8011, 0xab27, 0xcd4a, 0xffff, 0x32b4, 0x54d7,
  0x8001, 0x8003, 0xaaba, 0xcd49, 0xfffe, 0x0000, 0x32b5, 0x54d8,
  0x8002, 0xaaac, 0xccdc, 0xfffd, 0xffff, 0x0001, 0x32b6, 0x5545,
  0xaaab, 0xccce, 0xff90, 0xfffe, 0x0000, 0x0002, 0x3323, 0x5552,
  0xcccd, 0xff82, 0xff91, 0xffff, 0x0001, 0x006f, 0x3330, 0x5553,
  0xff81, 0xff83, 0xff92, 0x0000, 0x006e, 0x007c, 0x3331, 0x5554,
  0xff83, 0xff92, 0x0000, 0x006e, 0x007c, 0x3331, 0x5554, 0x7ffd,
  0xff84, 0xff93, 0x006d, 0x007b, 0x007d, 0x3332, 0x5555, 0x7ffe,
  0xff85, 0x0000, 0x007a, 0x007c, 0x007e, 0x3333, 0x5556, 0x7fff,
  0xfff2, 0x000d, 0x007b, 0x007d, 0x007f, 0x3334, 0x5557, 0x800d,
  0xffff, 0x000e, 0x007c, 0x007e, 0x0080, 0x3335, 0x5565, 0x807a,
  0x0000, 0x000f, 0x007d, 0x007f, 0x0081, 0x3343, 0x55d2, 0x807b,
  0x0001, 0x0010, 0x007e, 0x0080, 0x008f, 0x33b0, 0x55d3, 0x807c,
  0x0002, 0x0011, 0x007f, 0x008e, 0x00fc, 0x33b1, 0x55d4, 0xb330,
  0x0003, 0x0012, 0x008d, 0x00fb, 0x00fd, 0x33b2, 0x8888, 0xd552,
  0x0004, 0x0020, 0x00fa, 0x00fc, 0x00fe, 0x6666, 0xaaaa, 0xfffa,
  0x0012, 0x008d, 0x00fb, 0x00fd, 0x33b2, 0x8888, 0xd552, 0xfffb,
  0x007f, 0x008e, 0x00fc, 0x33b1, 0x55d4, 0xb330, 0xd553, 0xfffc,
  0x0080, 0x008f, 0x33b0, 0x55d3, 0x807c, 0xb331, 0xd554, 0xfffd,
  0x0081, 0x3343, 0x55d2, 0x807b, 0x807d, 0xb332, 0xd555, 0xfffe,
  0x3335, 0x5565, 0x807a, 0x807c, 0x807e, 0xb333, 0xd556, 0x2aa7,
  0x5557, 0x800d, 0x807b, 0x807d, 0x807f, 0xb334, 0xffff, 0x4cc9,
  0x7fff, 0x800e, 0x807c, 0x807e, 0x8080, 0xdddd, 0x2221, 0x7f7d,
  0x8000, 0x800f, 0x807d, 0x807f, 0xab29, 0xffff, 0x54d5, 0x7f7e,
  0x8001, 0x8010, 0x807e, 0xab28, 0xcd4b, 0x32b3, 0x54d6, 0x7f7f,
  0x8002, 0x8011, 0xab27, 0xcd4a, 0xffff, 0x32b4, 0x54d7, 0x7f80,
  0x8003, 0xaaba, 0xcd49, 0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fed,
  0xaaac, 0xccdc, 0xfffd, 0xffff, 0x0001, 0x32b6, 0x5545, 0x7ffa,
  0xccce, 0xff90, 0xfffe, 0x0000, 0x0002, 0x3323, 0x5552, 0x7ffb,
  0xff82, 0xff91, 0xffff, 0x0001, 0x006f, 0x3330, 0x5553, 0x7ffc,
  0xff91, 0xffff, 0x0001, 0x006f, 0x3330, 0x5553, 0x7ffc, 0x7ffe,
  0xff92, 0x0000, 0x006e, 0x007c, 0x3331, 0x5554, 0x7ffd, 0x7fff,
  0xff93, 0x006d, 0x007b, 0x007d, 0x3332, 0x5555, 0x7ffe, 0x8000,
  0x0000, 0x007a, 0x007c, 0x007e, 0x3333, 0x5556, 0x7fff, 0x800e,
  0x000d, 0x007b, 0x007d, 0x007f, 0x3334, 0x5557, 0x800d, 0x807b,
  0x000e, 0x007c, 0x007e, 0x0080, 0x3335, 0x5565, 0x807a, 0x807c,
  0x000f, 0x007d, 0x007f, 0x0081, 0x3343, 0x55d2, 0x807b, 0x807d,
  0x0010, 0x007e, 0x0080, 0x008f, 0x33b0, 0x55d3, 0x807c, 0xb331,
  0x0011, 0x007f, 0x008e, 0x00fc, 0x33b1, 0x55d4, 0xb330, 0xd553,
  0x0012, 0x008d, 0x00fb, 0x00fd, 0x33b2, 0x8888, 0xd552, 0xfffb,
  0x0020, 0x00fa, 0x00fc, 0x00fe, 0x6666, 0xaaaa, 0xfffa, 0xfffc,
  0x008d, 0x00fb, 0x00fd, 0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd,
  0x008e, 0x00fc, 0x33b1, 0x55d4, 0xb330, 0xd553, 0xfffc, 0xfffe,
  0x008f, 0x33b0, 0x55d3, 0x807c, 0xb331, 0xd554, 0xfffd, 0xffff,
  0x3343, 0x55d2, 0x807b, 0x807d, 0xb332, 0xd555, 0xfffe, 0x2aa8,
  0x5565, 0x807a, 0x807c, 0x807e, 0xb333, 0xd556, 0x2aa7, 0x4cca,
  0x800d, 0x807b, 0x807d, 0x807f, 0xb334, 0xffff, 0x4cc9, 0x7f7e,
  0x800e, 0x807c, 0x807e, 0x8080, 0xdddd, 0x2221, 0x7f7d, 0x7f7f,
  0x800f, 0x807d, 0x807f, 0xab29, 0xffff, 0x54d5, 0x7f7e, 0x7f80,
  0x8010, 0x807e, 0xab28, 0xcd4b, 0x32b3, 0x54d6, 0x7f7f, 0x7f81,
  0x8011, 0xab27, 0xcd4a, 0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fee,
  0xaaba, 0xcd49, 0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fed, 0x7ffb,
  0xccdc, 0xfffd, 0xffff, 0x0001, 0x32b6, 0x5545, 0x7ffa, 0x7ffc,
  0xff90, 0xfffe, 0x0000, 0x0002, 0x3323, 0x5552, 0x7ffb, 0x7ffd,
  0xfffe, 0x0000, 0x0002, 0x3323, 0x5552, 0x7ffb, 0x7ffd, 0x7fff,
  0xffff, 0x0001, 0x006f, 0x3330, 0x5553, 0x7ffc, 0x7ffe, 0x8000,
  0x0000, 0x006e, 0x007c, 0x3331, 0x5554, 0x7ffd, 0x7fff, 0x8001,
  0x006d, 0x007b, 0x007d, 0x3332, 0x5555, 0x7ffe, 0x8000, 0x800f,
  0x007a, 0x007c, 0x007e, 0x3333, 0x5556, 0x7fff, 0x800e, 0x807c,
  0x007b, 0x007d, 0x007f, 0x3334, 0x5557, 0x800d, 0x807b, 0x807d,
  0x007c, 0x007e, 0x0080, 0x3335, 0x5565, 0x807a, 0x807c, 0x807e,
  0x007d, 0x007f, 0x0081, 0x3343, 0x55d2, 0x807b, 0x807d, 0xb332,
  0x007e, 0x0080, 0x008f, 0x33b0, 0x55d3, 0x807c, 0xb331, 0xd554,
  0x007f, 0x008e, 0x00fc, 0x33b1, 0x55d4, 0xb330, 0xd553, 0xfffc,
  0x008d, 0x00fb, 0x00fd, 0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd,
  0x00fa, 0x00fc, 0x00fe, 0x6666, 0xaaaa, 0xfffa, 0xfffc, 0xfffe,
  0x00fb, 0x00fd, 0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd, 0xffff,
  0x00fc, 0x33b1, 0x55d4, 0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000,
  0x33b0, 0x55d3, 0x807c, 0xb331, 0xd554, 0xfffd, 0xffff, 0x2aa9,
  0x55d2, 0x807b, 0x807d, 0xb332, 0xd555, 0xfffe, 0x2aa8, 0x4ccb,
  0x807a, 0x807c, 0x807e, 0xb333, 0xd556, 0x2aa7, 0x4cca, 0x7f7f,
  0x807b, 0x807d, 0x807f, 0xb334, 0xffff, 0x4cc9, 0x7f7e, 0x7f80,
  0x807c, 0x807e, 0x8080, 0xdddd, 0x2221, 0x7f7d, 0x7f7f, 0x7f81,
  0x807d, 0x807f, 0xab29, 0xffff, 0x54d5, 0x7f7e, 0x7f80, 0x7f82,
  0x807e, 0xab28, 0xcd4b, 0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fef,
  0xab27, 0xcd4a, 0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fee, 0x7ffc,
  0xcd49, 0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fed, 0x7ffb, 0x7ffd,
  0xfffd, 0xffff, 0x0001, 0x32b6, 0x5545, 0x7ffa, 0x7ffc, 0x7ffe,
  0xffff, 0x0001, 0x32b6, 0x5545, 0x7ffa, 0x7ffc, 0x7ffe, 0x8000,
  0x0000, 0x0002, 0x3323, 0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x8001,
  0x0001, 0x006f, 0x3330, 0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x8002,
  0x006e, 0x007c, 0x3331, 0x5554, 0x7ffd, 0x7fff, 0x8001, 0x8010,
  0x007b, 0x007d, 0x3332, 0x5555, 0x7ffe, 0x8000, 0x800f, 0x807d,
  0x007c, 0x007e, 0x3333, 0x5556, 0x7fff, 0x800e, 0x807c, 0x807e,
  0x007d, 0x007f, 0x3334, 0x5557, 0x800d, 0x807b, 0x807d, 0x807f,
  0x007e, 0x0080, 0x3335, 0x5565, 0x807a, 0x807c, 0x807e, 0xb333,
  0x007f, 0x0081, 0x3343, 0x55d2, 0x807b, 0x807d, 0xb332, 0xd555,
  0x0080, 0x008f, 0x33b0, 0x55d3, 0x807c, 0xb331, 0xd554, 0xfffd,
  0x008e, 0x00fc, 0x33b1, 0x55d4, 0xb330, 0xd553, 0xfffc, 0xfffe,
  0x00fb, 0x00fd, 0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd, 0xffff,
  0x00fc, 0x00fe, 0x6666, 0xaaaa, 0xfffa, 0xfffc, 0xfffe, 0x0000,
  0x00fd, 0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd, 0xffff, 0x0001,
  0x33b1, 0x55d4, 0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000, 0x2aaa,
  0x55d3, 0x807c, 0xb331, 0xd554, 0xfffd, 0xffff, 0x2aa9, 0x4ccc,
  0x807b, 0x807d, 0xb332, 0xd555, 0xfffe, 0x2aa8, 0x4ccb, 0x7f80,
  0x807c, 0x807e, 0xb333, 0xd556, 0x2aa7, 0x4cca, 0x7f7f, 0x7f81,
  0x807d, 0x807f, 0xb334, 0xffff, 0x4cc9, 0x7f7e, 0x7f80, 0x7f82,
  0x807e, 0x8080, 0xdddd, 0x2221, 0x7f7d, 0x7f7f, 0x7f81, 0x7f83,
  0x807f, 0xab29, 0xffff, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0x7ff0,
  0xab28, 0xcd4b, 0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fef, 0x7ffd,
  0xcd4a, 0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fee, 0x7ffc, 0x7ffe,
  0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fed, 0x7ffb, 0x7ffd, 0x7fff,
  0x0000, 0x32b5, 0x54d8, 0x7fed, 0x7ffb, 0x7ffd, 0x7fff, 0x8001,
  0x0001, 0x32b6, 0x5545, 0x7ffa, 0x7ffc, 0x7ffe, 0x8000, 0x8002,
  0x0002, 0x3323, 0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0x8003,
  0x006f, 0x3330, 0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x8002, 0x8011,
  0x007c, 0x3331, 0x5554, 0x7ffd, 0x7fff, 0x8001, 0x8010, 0x807e,
  0x007d, 0x3332, 0x5555, 0x7ffe, 0x8000, 0x800f, 0x807d, 0x807f,
  0x007e, 0x3333, 0x5556, 0x7fff, 0x800e, 0x807c, 0x807e, 0x8080,
  0x007f, 0x3334, 0x5557, 0x800d, 0x807b, 0x807d, 0x807f, 0xb334,
  0x0080, 0x3335, 0x5565, 0x807a, 0x807c, 0x807e, 0xb333, 0xd556,
  0x0081, 0x3343, 0x55d2, 0x807b, 0x807d, 0xb332, 0xd555, 0xfffe,
  0x008f, 0x33b0, 0x55d3, 0x807c, 0xb331, 0xd554, 0xfffd, 0xffff,
  0x00fc, 0x33b1, 0x55d4, 0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000,
  0x00fd, 0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd, 0xffff, 0x0001,
  0x00fe, 0x6666, 0xaaaa, 0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0002,
  0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd, 0xffff, 0x0001, 0x2aab,
  0x55d4, 0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000, 0x2aaa, 0x4ccd,
  0x807c, 0xb331, 0xd554, 0xfffd, 0xffff, 0x2aa9, 0x4ccc, 0x7f81,
  0x807d, 0xb332, 0xd555, 0xfffe, 0x2aa8, 0x4ccb, 0x7f80, 0x7f82,
  0x807e, 0xb333, 0xd556, 0x2aa7, 0x4cca, 0x7f7f, 0x7f81, 0x7f83,
  0x807f, 0xb334, 0xffff, 0x4cc9, 0x7f7e, 0x7f80, 0x7f82, 0x7f84,
  0x8080, 0xdddd, 0x2221, 0x7f7d, 0x7f7f, 0x7f81, 0x7f83, 0x7ff1,
  0xab29, 0xffff, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0x7ff0, 0x7ffe,
  0xcd4b, 0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fef, 0x7ffd, 0x7fff,
  0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fee, 0x7ffc, 0x7ffe, 0x8000,
  0x32b4, 0x54d7, 0x7f80, 0x7fee, 0x7ffc, 0x7ffe, 0x8000, 0xaaaa,
  0x32b5, 0x54d8, 0x7fed, 0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0xaaab,
  0x32b6, 0x5545, 0x7ffa, 0x7ffc, 0x7ffe, 0x8000, 0x8002, 0xaaac,
  0x3323, 0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0x8003, 0xaaba,
  0x3330, 0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x8002, 0x8011, 0xab27,
  0x3331, 0x5554, 0x7ffd, 0x7fff, 0x8001, 0x8010, 0x807e, 0xab28,
  0x3332, 0x5555, 0x7ffe, 0x8000, 0x800f, 0x807d, 0x807f, 0xab29,
  0x3333, 0x5556, 0x7fff, 0x800e, 0x807c, 0x807e, 0x8080, 0xdddd,
  0x3334, 0x5557, 0x800d, 0x807b, 0x807d, 0x807f, 0xb334, 0xffff,
  0x3335, 0x5565, 0x807a, 0x807c, 0x807e, 0xb333, 0xd556, 0x2aa7,
  0x3343, 0x55d2, 0x807b, 0x807d, 0xb332, 0xd555, 0xfffe, 0x2aa8,
  0x33b0, 0x55d3, 0x807c, 0xb331, 0xd554, 0xfffd, 0xffff, 0x2aa9,
  0x33b1, 0x55d4, 0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000, 0x2aaa,
  0x33b2, 0x8888, 0xd552, 0xfffb, 0xfffd, 0xffff, 0x0001, 0x2aab,
  0x6666, 0xaaaa, 0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x5554,
  0x8888, 0xd552, 0xfffb, 0xfffd, 0xffff, 0x0001, 0x2aab, 0x7776,
  0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000, 0x2aaa, 0x4ccd, 0xaa2a,
  0xb331, 0xd554, 0xfffd, 0xffff, 0x2aa9, 0x4ccc, 0x7f81, 0xaa2b,
  0xb332, 0xd555, 0xfffe, 0x2aa8, 0x4ccb, 0x7f80, 0x7f82, 0xaa2c,
  0xb333, 0xd556, 0x2aa7, 0x4cca, 0x7f7f, 0x7f81, 0x7f83, 0xaa2d,
  0xb334, 0xffff, 0x4cc9, 0x7f7e, 0x7f80, 0x7f82, 0x7f84, 0xaa9a,
  0xdddd, 0x2221, 0x7f7d, 0x7f7f, 0x7f81, 0x7f83, 0x7ff1, 0xaaa7,
  0xffff, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0x7ff0, 0x7ffe, 0xaaa8,
  0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fef, 0x7ffd, 0x7fff, 0xaaa9,
  0x54d6, 0x7f7f, 0x7f81, 0x7fef, 0x7ffd, 0x7fff, 0xaaa9, 0xcccc,
  0x54d7, 0x7f80, 0x7fee, 0x7ffc, 0x7ffe, 0x8000, 0xaaaa, 0xcccd,
  0x54d8, 0x7fed, 0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0xaaab, 0xccce,
  0x5545, 0x7ffa, 0x7ffc, 0x7ffe, 0x8000, 0x8002, 0xaaac, 0xccdc,
  0x5552, 0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0x8003, 0xaaba, 0xcd49,
  0x5553, 0x7ffc, 0x7ffe, 0x8000, 0x8002, 0x8011, 0xab27, 0xcd4a,
  0x5554, 0x7ffd, 0x7fff, 0x8001, 0x8010, 0x807e, 0xab28, 0xcd4b,
  0x5555, 0x7ffe, 0x8000, 0x800f, 0x807d, 0x807f, 0xab29, 0xffff,
  0x5556, 0x7fff, 0x800e, 0x807c, 0x807e, 0x8080, 0xdddd, 0x2221,
  0x5557, 0x800d, 0x807b, 0x807d, 0x807f, 0xb334, 0xffff, 0x4cc9,
  0x5565, 0x807a, 0x807c, 0x807e, 0xb333, 0xd556, 0x2aa7, 0x4cca,
  0x55d2, 0x807b, 0x807d, 0xb332, 0xd555, 0xfffe, 0x2aa8, 0x4ccb,
  0x55d3, 0x807c, 0xb331, 0xd554, 0xfffd, 0xffff, 0x2aa9, 0x4ccc,
  0x55d4, 0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000, 0x2aaa, 0x4ccd,
  0x8888, 0xd552, 0xfffb, 0xfffd, 0xffff, 0x0001, 0x2aab, 0x7776,
  0xaaaa, 0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x5554, 0x9998,
  0xd552, 0xfffb, 0xfffd, 0xffff, 0x0001, 0x2aab, 0x7776, 0xcc4c,
  0xd553, 0xfffc, 0xfffe, 0x0000, 0x2aaa, 0x4ccd, 0xaa2a, 0xcc4d,
  0xd554, 0xfffd, 0xffff, 0x2aa9, 0x4ccc, 0x7f81, 0xaa2b, 0xcc4e,
  0xd555, 0xfffe, 0x2aa8, 0x4ccb, 0x7f80, 0x7f82, 0xaa2c, 0xcc4f,
  0xd556, 0x2aa7, 0x4cca, 0x7f7f, 0x7f81, 0x7f83, 0xaa2d, 0xccbc,
  0xffff, 0x4cc9, 0x7f7e, 0x7f80, 0x7f82, 0x7f84, 0xaa9a, 0xccc9,
  0x2221, 0x7f7d, 0x7f7f, 0x7f81, 0x7f83, 0x7ff1, 0xaaa7, 0xccca,
  0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0x7ff0, 0x7ffe, 0xaaa8, 0xcccb,
  0x7f7e, 0x7f80, 0x7f82, 0x7ff0, 0x7ffe, 0xaaa8, 0xcccb, 0xff80,
  0x7f7f, 0x7f81, 0x7fef, 0x7ffd, 0x7fff, 0xaaa9, 0xcccc, 0xff81,
  0x7f80, 0x7fee, 0x7ffc, 0x7ffe, 0x8000, 0xaaaa, 0xcccd, 0xff82,
  0x7fed, 0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0xaaab, 0xccce, 0xff90,
  0x7ffa, 0x7ffc, 0x7ffe, 0x8000, 0x8002, 0xaaac, 0xccdc, 0xfffd,
  0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0x8003, 0xaaba, 0xcd49, 0xfffe,
  0x7ffc, 0x7ffe, 0x8000, 0x8002, 0x8011, 0xab27, 0xcd4a, 0xffff,
  0x7ffd, 0x7fff, 0x8001, 0x8010, 0x807e, 0xab28, 0xcd4b, 0x32b3,
  0x7ffe, 0x8000, 0x800f, 0x807d, 0x807f, 0xab29, 0xffff, 0x54d5,
  0x7fff, 0x800e, 0x807c, 0x807e, 0x8080, 0xdddd, 0x2221, 0x7f7d,
  0x800d, 0x807b, 0x807d, 0x807f, 0xb334, 0xffff, 0x4cc9, 0x7f7e,
  0x807a, 0x807c, 0x807e, 0xb333, 0xd556, 0x2aa7, 0x4cca, 0x7f7f,
  0x807b, 0x807d, 0xb332, 0xd555, 0xfffe, 0x2aa8, 0x4ccb, 0x7f80,
  0x807c, 0xb331, 0xd554, 0xfffd, 0xffff, 0x2aa9, 0x4ccc, 0x7f81,
  0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000, 0x2aaa, 0x4ccd, 0xaa2a,
  0xd552, 0xfffb, 0xfffd, 0xffff, 0x0001, 0x2aab, 0x7776, 0xcc4c,
  0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x5554, 0x9998, 0xff00,
  0xfffb, 0xfffd, 0xffff, 0x0001, 0x2aab, 0x7776, 0xcc4c, 0xff01,
  0xfffc, 0xfffe, 0x0000, 0x2aaa, 0x4ccd, 0xaa2a, 0xcc4d, 0xff02,
  0xfffd, 0xffff, 0x2aa9, 0x4ccc, 0x7f81, 0xaa2b, 0xcc4e, 0xff03,
  0xfffe, 0x2aa8, 0x4ccb, 0x7f80, 0x7f82, 0xaa2c, 0xcc4f, 0xff70,
  0x2aa7, 0x4cca, 0x7f7f, 0x7f81, 0x7f83, 0xaa2d, 0xccbc, 0xff7d,
  0x4cc9, 0x7f7e, 0x7f80, 0x7f82, 0x7f84, 0xaa9a, 0xccc9, 0xff7e,
  0x7f7d, 0x7f7f, 0x7f81, 0x7f83, 0x7ff1, 0xaaa7, 0xccca, 0xff7f,
  0x7f7f, 0x7f81, 0x7f83, 0x7ff1, 0xaaa7, 0xccca, 0xff7f, 0xff81,
  0x7f80, 0x7f82, 0x7ff0, 0x7ffe, 0xaaa8, 0xcccb, 0xff80, 0xff82,
  0x7f81, 0x7fef, 0x7ffd, 0x7fff, 0xaaa9, 0xcccc, 0xff81, 0xff83,
  0x7fee, 0x7ffc, 0x7ffe, 0x8000, 0xaaaa, 0xcccd, 0xff82, 0xff91,
  0x7ffb, 0x7ffd, 0x7fff, 0x8001, 0xaaab, 0xccce, 0xff90, 0xfffe,
  0x7ffc, 0x7ffe, 0x8000, 0x8002, 0xaaac, 0xccdc, 0xfffd, 0xffff,
  0x7ffd, 0x7fff, 0x8001, 0x8003, 0xaaba, 0xcd49, 0xfffe, 0x0000,
  0x7ffe, 0x8000, 0x8002, 0x8011, 0xab27, 0xcd4a, 0xffff, 0x32b4,
  0x7fff, 0x8001, 0x8010, 0x807e, 0xab28, 0xcd4b, 0x32b3, 0x54d6,
  0x8000, 0x800f, 0x807d, 0x807f, 0xab29, 0xffff, 0x54d5, 0x7f7e,
  0x800e, 0x807c, 0x807e, 0x8080, 0xdddd, 0x2221, 0x7f7d, 0x7f7f,
  0x807b, 0x807d, 0x807f, 0xb334, 0xffff, 0x4cc9, 0x7f7e, 0x7f80,
  0x807c, 0x807e, 0xb333, 0xd556, 0x2aa7, 0x4cca, 0x7f7f, 0x7f81,
  0x807d, 0xb332, 0xd555, 0xfffe, 0x2aa8, 0x4ccb, 0x7f80, 0x7f82,
  0xb331, 0xd554, 0xfffd, 0xffff, 0x2aa9, 0x4ccc, 0x7f81, 0xaa2b,
  0xd553, 0xfffc, 0xfffe, 0x0000, 0x2aaa, 0x4ccd, 0xaa2a, 0xcc4d,
  0xfffb, 0xfffd, 0xffff, 0x0001, 0x2aab, 0x7776, 0xcc4c, 0xff01,
  0xfffc, 0xfffe, 0x0000, 0x0002, 0x5554, 0x9998, 0xff00, 0xff02,
  0xfffd, 0xffff, 0x0001, 0x2aab, 0x7776, 0xcc4c, 0xff01, 0xff03,
  0xfffe, 0x0000, 0x2aaa, 0x4ccd, 0xaa2a, 0xcc4d, 0xff02, 0xff04,
  0xffff, 0x2aa9, 0x4ccc, 0x7f81, 0xaa2b, 0xcc4e, 0xff03, 0xff71,
  0x2aa8, 0x4ccb, 0x7f80, 0x7f82, 0xaa2c, 0xcc4f, 0xff70, 0xff7e,
  0x4cca, 0x7f7f, 0x7f81, 0x7f83, 0xaa2d, 0xccbc, 0xff7d, 0xff7f,
  0x7f7e, 0x7f80, 0x7f82, 0x7f84, 0xaa9a, 0xccc9, 0xff7e, 0xff80,
  0x7f80, 0x7f82, 0x7f84, 0xaa9a, 0xccc9, 0xff7e, 0xff80, 0xff82,
  0x7f81, 0x7f83, 0x7ff1, 0xaaa7, 0xccca, 0xff7f, 0xff81, 0xff83,
  0x7f82, 0x7ff0, 0x7ffe, 0xaaa8, 0xcccb, 0xff80, 0xff82, 0xff84,
  0x7fef, 0x7ffd, 0x7fff, 0xaaa9, 0xcccc, 0xff81, 0xff83, 0xff92,
  0x7ffc, 0x7ffe, 0x8000, 0xaaaa, 0xcccd, 0xff82, 0xff91, 0xffff,
  0x7ffd, 0x7fff, 0x8001, 0xaaab, 0xccce, 0xff90, 0xfffe, 0x0000,
  0x7ffe, 0x8000, 0x8002, 0xaaac, 0xccdc, 0xfffd, 0xffff, 0x0001,
  0x7fff, 0x8001, 0x8003, 0xaaba, 0xcd49, 0xfffe, 0x0000, 0x32b5,
  0x8000, 0x8002, 0x8011, 0xab27, 0xcd4a, 0xffff, 0x32b4, 0x54d7,
  0x8001, 0x8010, 0x807e, 0xab28, 0xcd4b, 0x32b3, 0x54d6, 0x7f7f,
  0x800f, 0x807d, 0x807f, 0xab29, 0xffff, 0x54d5, 0x7f7e, 0x7f80,
  0x807c, 0x807e, 0x8080, 0xdddd, 0x2221, 0x7f7d, 0x7f7f, 0x7f81,
  0x807d, 0x807f, 0xb334, 0xffff, 0x4cc9, 0x7f7e, 0x7f80, 0x7f82,
  0x807e, 0xb333, 0xd556, 0x2aa7, 0x4cca, 0x7f7f, 0x7f81, 0x7f83,
  0xb332, 0xd555, 0xfffe, 0x2aa8, 0x4ccb, 0x7f80, 0x7f82, 0xaa2c,
  0xd554, 0xfffd, 0xffff, 0x2aa9, 0x4ccc, 0x7f81, 0xaa2b, 0xcc4e,
  0xfffc, 0xfffe, 0x0000, 0x2aaa, 0x4ccd, 0xaa2a, 0xcc4d, 0xff02,
  0xfffd, 0xffff, 0x0001, 0x2aab, 0x7776, 0xcc4c, 0xff01, 0xff03,
  0xfffe, 0x0000, 0x0002, 0x5554, 0x9998, 0xff00, 0xff02, 0xff04,
  0xffff, 0x0001, 0x2aab, 0x7776, 0xcc4c, 0xff01, 0xff03, 0xff05,
  0x0000, 0x2aaa, 0x4ccd, 0xaa2a, 0xcc4d, 0xff02, 0xff04, 0xff72,
  0x2aa9, 0x4ccc, 0x7f81, 0xaa2b, 0xcc4e, 0xff03, 0xff71, 0xff7f,
  0x4ccb, 0x7f80, 0x7f82, 0xaa2c, 0xcc4f, 0xff70, 0xff7e, 0xff80,
  0x7f7f, 0x7f81, 0x7f83, 0xaa2d, 0xccbc, 0xff7d, 0xff7f, 0xff81,
  0x7f81, 0x7f83, 0xaa2d, 0xccbc, 0xff7d, 0xff7f, 0xff81, 0xff83,
  0x7f82, 0x7f84, 0xaa9a, 0xccc9, 0xff7e, 0xff80, 0xff82, 0xff84,
  0x7f83, 0x7ff1, 0xaaa7, 0xccca, 0xff7f, 0xff81, 0xff83, 0xff85,
  0x7ff0, 0x7ffe, 0xaaa8, 0xcccb, 0xff80, 0xff82, 0xff84, 0xff93,
  0x7ffd, 0x7fff, 0xaaa9, 0xcccc, 0xff81, 0xff83, 0xff92, 0x0000,
  0x7ffe, 0x8000, 0xaaaa, 0xcccd, 0xff82, 0xff91, 0xffff, 0x0001,
  0x7fff, 0x8001, 0xaaab, 0xccce, 0xff90, 0xfffe, 0x0000, 0x0002,
  0x8000, 0x8002, 0xaaac, 0xccdc, 0xfffd, 0xffff, 0x0001, 0x32b6,
  0x8001, 0x8003, 0xaaba, 0xcd49, 0xfffe, 0x0000, 0x32b5, 0x54d8,
  0x8002, 0x8011, 0xab27, 0xcd4a, 0xffff, 0x32b4, 0x54d7, 0x7f80,
  0x8010, 0x807e, 0xab28, 0xcd4b, 0x32b3, 0x54d6, 0x7f7f, 0x7f81,
  0x807d, 0x807f, 0xab29, 0xffff, 0x54d5, 0x7f7e, 0x7f80, 0x7f82,
  0x807e, 0x8080, 0xdddd, 0x2221, 0x7f7d, 0x7f7f, 0x7f81, 0x7f83,
  0x807f, 0xb334, 0xffff, 0x4cc9, 0x7f7e, 0x7f80, 0x7f82, 0x7f84,
  0xb333, 0xd556, 0x2aa7, 0x4cca, 0x7f7f, 0x7f81, 0x7f83, 0xaa2d,
  0xd555, 0xfffe, 0x2aa8, 0x4ccb, 0x7f80, 0x7f82, 0xaa2c, 0xcc4f,
  0xfffd, 0xffff, 0x2aa9, 0x4ccc, 0x7f81, 0xaa2b, 0xcc4e, 0xff03,
  0xfffe, 0x0000, 0x2aaa, 0x4ccd, 0xaa2a, 0xcc4d, 0xff02, 0xff04,
  0xffff, 0x0001, 0x2aab, 0x7776, 0xcc4c, 0xff01, 0xff03, 0xff05,
  0x0000, 0x0002, 0x5554, 0x9998, 0xff00, 0xff02, 0xff04, 0xff06,
  0x0001, 0x2aab, 0x7776, 0xcc4c, 0xff01, 0xff03, 0xff05, 0xff73,
  0x2aaa, 0x4ccd, 0xaa2a, 0xcc4d, 0xff02, 0xff04, 0xff72, 0xff80,
  0x4ccc, 0x7f81, 0xaa2b, 0xcc4e, 0xff03, 0xff71, 0xff7f, 0xff81,
  0x7f80, 0x7f82, 0xaa2c, 0xcc4f, 0xff70, 0xff7e, 0xff80, 0xff82,
  0x7f82, 0xaa2c, 0xcc4f, 0xff70, 0xff7e, 0xff80, 0xff82, 0xfff0,
  0x7f83, 0xaa2d, 0xccbc, 0xff7d, 0xff7f, 0xff81, 0xff83, 0xfff1,
  0x7f84, 0xaa9a, 0xccc9, 0xff7e, 0xff80, 0xff82, 0xff84, 0xfff2,
  0x7ff1, 0xaaa7, 0xccca, 0xff7f, 0xff81, 0xff83, 0xff85, 0x0000,
  0x7ffe, 0xaaa8, 0xcccb, 0xff80, 0xff82, 0xff84, 0xff93, 0x006d,
  0x7fff, 0xaaa9, 0xcccc, 0xff81, 0xff83, 0xff92, 0x0000, 0x006e,
  0x8000, 0xaaaa, 0xcccd, 0xff82, 0xff91, 0xffff, 0x0001, 0x006f,
  0x8001, 0xaaab, 0xccce, 0xff90, 0xfffe, 0x0000, 0x0002, 0x3323,
  0x8002, 0xaaac, 0xccdc, 0xfffd, 0xffff, 0x0001, 0x32b6, 0x5545,
  0x8003, 0xaaba, 0xcd49, 0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fed,
  0x8011, 0xab27, 0xcd4a, 0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fee,
  0x807e, 0xab28, 0xcd4b, 0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fef,
  0x807f, 0xab29, 0xffff, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0x7ff0,
  0x8080, 0xdddd, 0x2221, 0x7f7d, 0x7f7f, 0x7f81, 0x7f83, 0x7ff1,
  0xb334, 0xffff, 0x4cc9, 0x7f7e, 0x7f80, 0x7f82, 0x7f84, 0xaa9a,
  0xd556, 0x2aa7, 0x4cca, 0x7f7f, 0x7f81, 0x7f83, 0xaa2d, 0xccbc,
  0xfffe, 0x2aa8, 0x4ccb, 0x7f80, 0x7f82, 0xaa2c, 0xcc4f, 0xff70,
  0xffff, 0x2aa9, 0x4ccc, 0x7f81, 0xaa2b, 0xcc4e, 0xff03, 0xff71,
  0x0000, 0x2aaa, 0x4ccd, 0xaa2a, 0xcc4d, 0xff02, 0xff04, 0xff72,
  0x0001, 0x2aab, 0x7776, 0xcc4c, 0xff01, 0xff03, 0xff05, 0xff73,
  0x0002, 0x5554, 0x9998, 0xff00, 0xff02, 0xff04, 0xff06, 0xffe0,
  0x2aab, 0x7776, 0xcc4c, 0xff01, 0xff03, 0xff05, 0xff73, 0xffed,
  0x4ccd, 0xaa2a, 0xcc4d, 0xff02, 0xff04, 0xff72, 0xff80, 0xffee,
  0x7f81, 0xaa2b, 0xcc4e, 0xff03, 0xff71, 0xff7f, 0xff81, 0xffef,
  0xaa2b, 0xcc4e, 0xff03, 0xff71, 0xff7f, 0xff81, 0xffef, 0xfffd,
  0xaa2c, 0xcc4f, 0xff70, 0xff7e, 0xff80, 0xff82, 0xfff0, 0xfffe,
  0xaa2d, 0xccbc, 0xff7d, 0xff7f, 0xff81, 0xff83, 0xfff1, 0xffff,
  0xaa9a, 0xccc9, 0xff7e, 0xff80, 0xff82, 0xff84, 0xfff2, 0x000d,
  0xaaa7, 0xccca, 0xff7f, 0xff81, 0xff83, 0xff85, 0x0000, 0x007a,
  0xaaa8, 0xcccb, 0xff80, 0xff82, 0xff84, 0xff93, 0x006d, 0x007b,
  0xaaa9, 0xcccc, 0xff81, 0xff83, 0xff92, 0x0000, 0x006e, 0x007c,
  0xaaaa, 0xcccd, 0xff82, 0xff91, 0xffff, 0x0001, 0x006f, 0x3330,
  0xaaab, 0xccce, 0xff90, 0xfffe, 0x0000, 0x0002, 0x3323, 0x5552,
  0xaaac, 0xccdc, 0xfffd, 0xffff, 0x0001, 0x32b6, 0x5545, 0x7ffa,
  0xaaba, 0xcd49, 0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fed, 0x7ffb,
  0xab27, 0xcd4a, 0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fee, 0x7ffc,
  0xab28, 0xcd4b, 0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fef, 0x7ffd,
  0xab29, 0xffff, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0x7ff0, 0x7ffe,
  0xdddd, 0x2221, 0x7f7d, 0x7f7f, 0x7f81, 0x7f83, 0x7ff1, 0xaaa7,
  0xffff, 0x4cc9, 0x7f7e, 0x7f80, 0x7f82, 0x7f84, 0xaa9a, 0xccc9,
  0x2aa7, 0x4cca, 0x7f7f, 0x7f81, 0x7f83, 0xaa2d, 0xccbc, 0xff7d,
  0x2aa8, 0x4ccb, 0x7f80, 0x7f82, 0xaa2c, 0xcc4f, 0xff70, 0xff7e,
  0x2aa9, 0x4ccc, 0x7f81, 0xaa2b, 0xcc4e, 0xff03, 0xff71, 0xff7f,
  0x2aaa, 0x4ccd, 0xaa2a, 0xcc4d, 0xff02, 0xff04, 0xff72, 0xff80,
  0x2aab, 0x7776, 0xcc4c, 0xff01, 0xff03, 0xff05, 0xff73, 0xffed,
  0x5554, 0x9998, 0xff00, 0xff02, 0xff04, 0xff06, 0xffe0, 0xfffa,
  0x7776, 0xcc4c, 0xff01, 0xff03, 0xff05, 0xff73, 0xffed, 0xfffb,
  0xaa2a, 0xcc4d, 0xff02, 0xff04, 0xff72, 0xff80, 0xffee, 0xfffc,
  0xcc4d, 0xff02, 0xff04, 0xff72, 0xff80, 0xffee, 0xfffc, 0xfffe,
  0xcc4e, 0xff03, 0xff71, 0xff7f, 0xff81, 0xffef, 0xfffd, 0xffff,
  0xcc4f, 0xff70, 0xff7e, 0xff80, 0xff82, 0xfff0, 0xfffe, 0x0000,
  0xccbc, 0xff7d, 0xff7f, 0xff81, 0xff83, 0xfff1, 0xffff, 0x000e,
  0xccc9, 0xff7e, 0xff80, 0xff82, 0xff84, 0xfff2, 0x000d, 0x007b,
  0xccca, 0xff7f, 0xff81, 0xff83, 0xff85, 0x0000, 0x007a, 0x007c,
  0xcccb, 0xff80, 0xff82, 0xff84, 0xff93, 0x006d, 0x007b, 0x007d,
  0xcccc, 0xff81, 0xff83, 0xff92, 0x0000, 0x006e, 0x007c, 0x3331,
  0xcccd, 0xff82, 0xff91, 0xffff, 0x0001, 0x006f, 0x3330, 0x5553,
  0xccce, 0xff90, 0xfffe, 0x0000, 0x0002, 0x3323, 0x5552, 0x7ffb,
  0xccdc, 0xfffd, 0xffff, 0x0001, 0x32b6, 0x5545, 0x7ffa, 0x7ffc,
  0xcd49, 0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fed, 0x7ffb, 0x7ffd,
  0xcd4a, 0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fee, 0x7ffc, 0x7ffe,
  0xcd4b, 0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fef, 0x7ffd, 0x7fff,
  0xffff, 0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0x7ff0, 0x7ffe, 0xaaa8,
  0x2221, 0x7f7d, 0x7f7f, 0x7f81, 0x7f83, 0x7ff1, 0xaaa7, 0xccca,
  0x4cc9, 0x7f7e, 0x7f80, 0x7f82, 0x7f84, 0xaa9a, 0xccc9, 0xff7e,
  0x4cca, 0x7f7f, 0x7f81, 0x7f83, 0xaa2d, 0xccbc, 0xff7d, 0xff7f,
  0x4ccb, 0x7f80, 0x7f82, 0xaa2c, 0xcc4f, 0xff70, 0xff7e, 0xff80,
  0x4ccc, 0x7f81, 0xaa2b, 0xcc4e, 0xff03, 0xff71, 0xff7f, 0xff81,
  0x4ccd, 0xaa2a, 0xcc4d, 0xff02, 0xff04, 0xff72, 0xff80, 0xffee,
  0x7776, 0xcc4c, 0xff01, 0xff03, 0xff05, 0xff73, 0xffed, 0xfffb,
  0x9998, 0xff00, 0xff02, 0xff04, 0xff06, 0xffe0, 0xfffa, 0xfffc,
  0xcc4c, 0xff01, 0xff03, 0xff05, 0xff73, 0xffed, 0xfffb, 0xfffd,
  0xff01, 0xff03, 0xff05, 0xff73, 0xffed, 0xfffb, 0xfffd, 0xffff,
  0xff02, 0xff04, 0xff72, 0xff80, 0xffee, 0xfffc, 0xfffe, 0x0000,
  0xff03, 0xff71, 0xff7f, 0xff81, 0xffef, 0xfffd, 0xffff, 0x0001,
  0xff70, 0xff7e, 0xff80, 0xff82, 0xfff0, 0xfffe, 0x0000, 0x000f,
  0xff7d, 0xff7f, 0xff81, 0xff83, 0xfff1, 0xffff, 0x000e, 0x007c,
  0xff7e, 0xff80, 0xff82, 0xff84, 0xfff2, 0x000d, 0x007b, 0x007d,
  0xff7f, 0xff81, 0xff83, 0xff85, 0x0000, 0x007a, 0x007c, 0x007e,
  0xff80, 0xff82, 0xff84, 0xff93, 0x006d, 0x007b, 0x007d, 0x3332,
  0xff81, 0xff83, 0xff92, 0x0000, 0x006e, 0x007c, 0x3331, 0x5554,
  0xff82, 0xff91, 0xffff, 0x0001, 0x006f, 0x3330, 0x5553, 0x7ffc,
  0xff90, 0xfffe, 0x0000, 0x0002, 0x3323, 0x5552, 0x7ffb, 0x7ffd,
  0xfffd, 0xffff, 0x0001, 0x32b6, 0x5545, 0x7ffa, 0x7ffc, 0x7ffe,
  0xfffe, 0x0000, 0x32b5, 0x54d8, 0x7fed, 0x7ffb, 0x7ffd, 0x7fff,
  0xffff, 0x32b4, 0x54d7, 0x7f80, 0x7fee, 0x7ffc, 0x7ffe, 0x8000,
  0x32b3, 0x54d6, 0x7f7f, 0x7f81, 0x7fef, 0x7ffd, 0x7fff, 0xaaa9,
  0x54d5, 0x7f7e, 0x7f80, 0x7f82, 0x7ff0, 0x7ffe, 0xaaa8, 0xcccb,
  0x7f7d, 0x7f7f, 0x7f81, 0x7f83, 0x7ff1, 0xaaa7, 0xccca, 0xff7f,
  0x7f7e, 0x7f80, 0x7f82, 0x7f84, 0xaa9a, 0xccc9, 0xff7e, 0xff80,
  0x7f7f, 0x7f81, 0x7f83, 0xaa2d, 0xccbc, 0xff7d, 0xff7f, 0xff81,
  0x7f80, 0x7f82, 0xaa2c, 0xcc4f, 0xff70, 0xff7e, 0xff80, 0xff82,
  0x7f81, 0xaa2b, 0xcc4e, 0xff03, 0xff71, 0xff7f, 0xff81, 0xffef,
  0xaa2a, 0xcc4d, 0xff02, 0xff04, 0xff72, 0xff80, 0xffee, 0xfffc,
  0xcc4c, 0xff01, 0xff03, 0xff05, 0xff73, 0xffed, 0xfffb, 0xfffd,
  0xff00, 0xff02, 0xff04, 0xff06, 0xffe0, 0xfffa, 0xfffc, 0xfffe,
};
const unsigned kExpectedCount_NEON_add_8H = 576;

#endif  // VIXL_SIM_ADD_8H_TRACE_AARCH64_H_
