// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UHADD_4H_TRACE_AARCH64_H_
#define VIXL_SIM_UHADD_4H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_uhadd_4H[] = {
  0x007e, 0x007f, 0x3333, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x19d9, 0x4444, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d8, 0x2aea, 0x5998, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ae9, 0x403e, 0x5998, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x5999, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x1999, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x003f, 0x199a, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x199a, 0x2ab2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x19a1, 0x2ae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x0047, 0x19d8, 0x2ae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0047, 0x007e, 0x19d8, 0x2aea, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x19d9, 0x4444, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x3333, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x19d9, 0x4444, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d8, 0x2aea, 0x5998, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ae9, 0x403e, 0x5998, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x5999, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x5999, 0x6aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x599a, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x4040, 0x6eee, 0x9110, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x5594, 0x7fff, 0xaa6a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5594, 0x66a5, 0x9959, 0xaa6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x66a5, 0x7fff, 0x995a, 0xaa6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x995a, 0xaa6c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x995a, 0xaa6c, 0xbff6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x995b, 0xaaa2, 0xbffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x9991, 0xaaa9, 0xbffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8037, 0x9998, 0xaaa9, 0xbffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803e, 0x9998, 0xaaaa, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803e, 0x9999, 0x2aaa, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803f, 0x1999, 0x2aab, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x199a, 0x2aab, 0x4006, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x199a, 0x2ab2, 0x403d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x19a1, 0x2ae9, 0x403d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0047, 0x19d8, 0x2ae9, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x19d8, 0x2aea, 0x5998, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x19d9, 0x4444, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d9, 0x4444, 0x6aa9, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aea, 0x5998, 0x6aa9, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x5998, 0x6aaa, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x5999, 0x6aaa, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x5999, 0x6aab, 0x9553, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x599a, 0x7fff, 0xa664, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4040, 0x6eee, 0x9110, 0xbfbe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5594, 0x7fff, 0xaa6a, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x66a5, 0x9959, 0xaa6b, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x995a, 0xaa6b, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x995a, 0xaa6b, 0xbfc0, 0xbff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x995a, 0xaa6c, 0xbff6, 0xbffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x995b, 0xaaa2, 0xbffd, 0xbffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9991, 0xaaa9, 0xbffd, 0xbffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9998, 0xaaa9, 0xbffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9998, 0xaaaa, 0x3ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9999, 0x2aaa, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1999, 0x2aab, 0x3fff, 0x4007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2aab, 0x4006, 0x403d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2ab2, 0x403d, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19a1, 0x2ae9, 0x403d, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d8, 0x2ae9, 0x403e, 0x5998, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d8, 0x2aea, 0x5998, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d9, 0x4444, 0x6aa9, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4444, 0x6aa9, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5998, 0x6aa9, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0x6aaa, 0x7fff, 0x9554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0x6aab, 0x9553, 0xa665, 0x0000, 0x0000, 0x0000, 0x0000,
  0x599a, 0x7fff, 0xa664, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6eee, 0x9110, 0xbfbe, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xaa6a, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9959, 0xaa6b, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa6b, 0xbfbf, 0xbfc0, 0xbff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa6b, 0xbfc0, 0xbff7, 0xbffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa6c, 0xbff6, 0xbffd, 0xbffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa2, 0xbffd, 0xbffe, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa9, 0xbffd, 0xbffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa9, 0xbffe, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0x3ffe, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x3fff, 0x4000, 0x4007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x3fff, 0x4007, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x4006, 0x403d, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ab2, 0x403d, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ae9, 0x403d, 0x403e, 0x5999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ae9, 0x403e, 0x5998, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aea, 0x5998, 0x6aa9, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4444, 0x6aa9, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aa9, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0x7ffe, 0x7fff, 0x9554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0x7fff, 0x9554, 0xa665, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aab, 0x9553, 0xa665, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xa664, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9110, 0xbfbe, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa6a, 0xbfbf, 0xbfc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbf, 0xbfc0, 0xbfc1, 0x7ff8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbf, 0xbfc0, 0xbff7, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xbff7, 0xbffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbff6, 0xbffd, 0xbffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffd, 0xbffe, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffd, 0xbffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffe, 0x3fff, 0x4000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3fff, 0x4000, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4007, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4007, 0x403e, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4006, 0x403d, 0x403e, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x403f, 0x1999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x5999, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x5998, 0x6aaa, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5998, 0x6aa9, 0x7ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aa9, 0x7ffd, 0x7ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x9554, 0x6666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x9554, 0xa665, 0x7fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9553, 0xa665, 0xbfbf, 0x7fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa664, 0xbfbf, 0xbfc0, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbe, 0xbfbf, 0xbfc0, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbf, 0xbfc0, 0x7fc1, 0x7ff8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xbfc1, 0x7ff8, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xbff7, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbff7, 0xbffe, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffd, 0xbffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffe, 0xbfff, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffe, 0x3fff, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x0001, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x0008, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4007, 0x003e, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4007, 0x403e, 0x003f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x003f, 0x199a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x1999, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x5999, 0x2aaa, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5998, 0x6aaa, 0x3ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aa9, 0x7ffe, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x4000, 0x4001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x4000, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x5555, 0x6666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x9554, 0x6666, 0x7fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9554, 0xa665, 0x7fc0, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa665, 0xbfbf, 0x7fc0, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbf, 0xbfc0, 0x7fc1, 0x7fc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0x7fc1, 0x7fc2, 0x7ff9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0x7fc1, 0x7ff8, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc1, 0x7ff8, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbff7, 0x7ffe, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffe, 0x7fff, 0x8000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffe, 0x7fff, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0x0000, 0x0001, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x0000, 0x0001, 0x0009, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x0001, 0x0008, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x0008, 0x003f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4007, 0x003e, 0x003f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x003f, 0x0040, 0x199a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x003f, 0x199a, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x1999, 0x2aab, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0x2aaa, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0x3ffe, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x3fff, 0x4000, 0x4001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x3fff, 0x4000, 0x4001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x4000, 0x4001, 0x5556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x4000, 0x5555, 0x6667, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x5555, 0x6666, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9554, 0x6666, 0x7fc0, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa665, 0x7fc0, 0x7fc1, 0x7fc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbf, 0x7fc0, 0x7fc1, 0x7fc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc0, 0x7fc1, 0x7fc2, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc1, 0x7fc2, 0x7ff9, 0x8006, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc1, 0x7ff8, 0x7fff, 0x8007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff8, 0x7fff, 0x8000, 0x8007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x0001, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0000, 0x0001, 0x0009, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0009, 0x0046, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0008, 0x003f, 0x0047, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0008, 0x003f, 0x0040, 0x0047, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x003f, 0x0040, 0x19a1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x199a, 0x2ab2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x199a, 0x2aab, 0x4006, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1999, 0x2aab, 0x3fff, 0x4007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x3fff, 0x4000, 0x4007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3fff, 0x4000, 0x4008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4001, 0x4008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4001, 0x555d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4001, 0x5556, 0x666e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x5555, 0x6667, 0x7fc8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x6666, 0x7fc1, 0x7fc8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6666, 0x7fc0, 0x7fc1, 0x7fc9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc0, 0x7fc1, 0x7fc2, 0x7fc9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc1, 0x7fc2, 0x7fc9, 0x8036, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc1, 0x7fc2, 0x8000, 0x803d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc2, 0x7ff9, 0x8006, 0x803d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff8, 0x7fff, 0x8007, 0x803e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x8007, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x0008, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x0001, 0x0008, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0009, 0x0046, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0010, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0009, 0x0046, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0008, 0x003f, 0x0047, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x0047, 0x19d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x19a1, 0x2ae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x199a, 0x2ab2, 0x403d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2aab, 0x4006, 0x403d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x3fff, 0x4007, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4007, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4008, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4001, 0x4008, 0x5593, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4001, 0x555d, 0x66a4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4001, 0x5556, 0x666e, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x6667, 0x7fc8, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6666, 0x7fc1, 0x7fc8, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc0, 0x7fc1, 0x7fc9, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc1, 0x7fc9, 0x8000, 0x8037, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc2, 0x7fc9, 0x8036, 0x803d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc2, 0x8000, 0x803d, 0x803e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ff9, 0x8006, 0x803d, 0x803e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8007, 0x803e, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8007, 0x003e, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x0008, 0x003f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0008, 0x003f, 0x0047, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0009, 0x0046, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0010, 0x007d, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0009, 0x0046, 0x007d, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0047, 0x007e, 0x19d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x0047, 0x19d8, 0x2ae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x19a1, 0x2ae9, 0x403d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2ab2, 0x403d, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x4006, 0x403d, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4007, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4007, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4008, 0x403f, 0x5594, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4001, 0x4008, 0x5593, 0x66a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4001, 0x555d, 0x66a4, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x666e, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6667, 0x7fc8, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc1, 0x7fc8, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc8, 0x7fff, 0x8000, 0x8037, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc9, 0x8000, 0x8037, 0x803e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc9, 0x8036, 0x803d, 0x803e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x803d, 0x803e, 0x803f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8006, 0x803d, 0x803e, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8007, 0x803e, 0x003f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8007, 0x003e, 0x003f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0008, 0x003f, 0x0040, 0x0047, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0008, 0x003f, 0x0047, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0009, 0x0046, 0x007d, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x007d, 0x007e, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0046, 0x007d, 0x007e, 0x19d9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0047, 0x007e, 0x19d8, 0x2aea, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0047, 0x19d8, 0x2ae9, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19a1, 0x2ae9, 0x403d, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ab2, 0x403d, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4006, 0x403d, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4007, 0x403e, 0x403f, 0x4040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4007, 0x403e, 0x403f, 0x5594, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4008, 0x403f, 0x5594, 0x66a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4008, 0x5593, 0x66a5, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x555d, 0x66a4, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x666e, 0x7ffe, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc8, 0x7fff, 0x8000, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x8001, 0x9991, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x8037, 0x9998, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8037, 0x803e, 0x9998, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8036, 0x803d, 0x803e, 0x9999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803d, 0x803e, 0x803f, 0x1999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803d, 0x803e, 0x003f, 0x199a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803e, 0x003f, 0x0040, 0x199a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x003f, 0x0040, 0x19a1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x0047, 0x19d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0047, 0x007e, 0x19d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0046, 0x007d, 0x007e, 0x19d9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x007f, 0x3333, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x19d9, 0x4444, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x19d8, 0x2aea, 0x5998, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d8, 0x2ae9, 0x403e, 0x5998, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ae9, 0x403d, 0x403e, 0x5999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x403f, 0x5999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x403f, 0x599a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x4040, 0x6eee, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x5594, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x5594, 0x66a5, 0x9959, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5593, 0x66a5, 0x7fff, 0x995a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x66a4, 0x7fff, 0x8000, 0x995a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x995b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x995b, 0xaaa2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0x9991, 0xaaa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8037, 0x9998, 0xaaa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8037, 0x803e, 0x9998, 0xaaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803d, 0x803e, 0x9999, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803e, 0x803f, 0x1999, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803e, 0x003f, 0x199a, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x199a, 0x2ab2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x19a1, 0x2ae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x0047, 0x19d8, 0x2ae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0047, 0x007e, 0x19d8, 0x2aea, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x19d9, 0x4444, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x3333, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x19d9, 0x4444, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d8, 0x2aea, 0x5998, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ae9, 0x403e, 0x5998, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x5999, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x5999, 0x6aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x599a, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x4040, 0x6eee, 0x9110, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x5594, 0x7fff, 0xaa6a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5594, 0x66a5, 0x9959, 0xaa6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x66a5, 0x7fff, 0x995a, 0xaa6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x995a, 0xaa6c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x995a, 0xaa6c, 0xbff6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x995b, 0xaaa2, 0xbffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x9991, 0xaaa9, 0xbffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8037, 0x9998, 0xaaa9, 0xbffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803e, 0x9998, 0xaaaa, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803e, 0x9999, 0x2aaa, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803f, 0x1999, 0x2aab, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x199a, 0x2aab, 0x4006, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x199a, 0x2ab2, 0x403d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x19a1, 0x2ae9, 0x403d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0047, 0x19d8, 0x2ae9, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x19d8, 0x2aea, 0x5998, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x19d9, 0x4444, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d9, 0x4444, 0x6aa9, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aea, 0x5998, 0x6aa9, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x5998, 0x6aaa, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x5999, 0x6aaa, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x5999, 0x6aab, 0x9553, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x599a, 0x7fff, 0xa664, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4040, 0x6eee, 0x9110, 0xbfbe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5594, 0x7fff, 0xaa6a, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x66a5, 0x9959, 0xaa6b, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x995a, 0xaa6b, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x995a, 0xaa6b, 0xbfc0, 0xbff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x995a, 0xaa6c, 0xbff6, 0xbffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x995b, 0xaaa2, 0xbffd, 0xbffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9991, 0xaaa9, 0xbffd, 0xbffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9998, 0xaaa9, 0xbffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9998, 0xaaaa, 0x3ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9999, 0x2aaa, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1999, 0x2aab, 0x3fff, 0x4007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2aab, 0x4006, 0x403d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2ab2, 0x403d, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19a1, 0x2ae9, 0x403d, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d8, 0x2ae9, 0x403e, 0x5998, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d8, 0x2aea, 0x5998, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d9, 0x4444, 0x6aa9, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4444, 0x6aa9, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5998, 0x6aa9, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0x6aaa, 0x7fff, 0x9554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0x6aab, 0x9553, 0xa665, 0x0000, 0x0000, 0x0000, 0x0000,
  0x599a, 0x7fff, 0xa664, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6eee, 0x9110, 0xbfbe, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xaa6a, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9959, 0xaa6b, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa6b, 0xbfbf, 0xbfc0, 0xbff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa6b, 0xbfc0, 0xbff7, 0xbffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa6c, 0xbff6, 0xbffd, 0xbffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa2, 0xbffd, 0xbffe, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa9, 0xbffd, 0xbffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaa9, 0xbffe, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0x3ffe, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x3fff, 0x4000, 0x4007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x3fff, 0x4007, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x4006, 0x403d, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ab2, 0x403d, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ae9, 0x403d, 0x403e, 0x5999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ae9, 0x403e, 0x5998, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aea, 0x5998, 0x6aa9, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4444, 0x6aa9, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aa9, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0x7ffe, 0x7fff, 0x9554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0x7fff, 0x9554, 0xa665, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aab, 0x9553, 0xa665, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xa664, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9110, 0xbfbe, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa6a, 0xbfbf, 0xbfc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbf, 0xbfc0, 0xbfc1, 0xbff8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbf, 0xbfc0, 0xbff7, 0xbffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xbff7, 0xbffe, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbff6, 0xbffd, 0xbffe, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffd, 0xbffe, 0xbfff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffd, 0xbffe, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffe, 0x3fff, 0x4000, 0x4001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3fff, 0x4000, 0x4008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4007, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4007, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4006, 0x403d, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x403f, 0x5999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x5999, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x5998, 0x6aaa, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5998, 0x6aa9, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aa9, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x9555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x9554, 0xa666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x9554, 0xa665, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9553, 0xa665, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa664, 0xbfbf, 0xbfc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbe, 0xbfbf, 0xbfc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbf, 0xbfc0, 0xbfc1, 0xbff8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xbfc1, 0xbff8, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xbff7, 0xbffe, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbff7, 0xbffe, 0xbfff, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffd, 0xbffe, 0xbfff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffe, 0xbfff, 0x4000, 0x4001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffe, 0x3fff, 0x4000, 0x4001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4001, 0x4008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4008, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4007, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4007, 0x403e, 0x403f, 0x4040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x403f, 0x599a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x5999, 0x6aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x5999, 0x6aaa, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x9555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x9555, 0xa666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x9554, 0xa666, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9554, 0xa665, 0xbfc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa665, 0xbfbf, 0xbfc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xbfc1, 0xbfc2, 0xd54d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xbfc1, 0xbff8, 0xd553, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc1, 0xbff8, 0xbfff, 0xd554, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbff7, 0xbffe, 0xbfff, 0xd554, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffe, 0xbfff, 0xc000, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffe, 0xbfff, 0x4000, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0x4000, 0x4001, 0x5556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4001, 0x555d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4001, 0x4008, 0x5593, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4008, 0x403f, 0x5594, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4007, 0x403e, 0x403f, 0x5594, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x4040, 0x6eee, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x599a, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x5999, 0x6aab, 0x9553, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0x6aaa, 0x7fff, 0x9554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0x7ffe, 0x7fff, 0x9554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x9555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x9555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x8001, 0xaaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x9555, 0xbbbb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x9555, 0xa666, 0xd515, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9554, 0xa666, 0xbfc0, 0xd515, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa665, 0xbfc0, 0xbfc1, 0xd516, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbf, 0xbfc0, 0xbfc1, 0xd516, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xbfc1, 0xd516, 0xe65e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc1, 0xbfc2, 0xd54d, 0xe664, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc1, 0xbff8, 0xd553, 0xe665, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbff8, 0xbfff, 0xd554, 0xe665, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbffe, 0xbfff, 0xd554, 0x6666, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0xc000, 0x5555, 0x6666, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0x4000, 0x5555, 0x6667, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4001, 0x5556, 0x666e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4001, 0x555d, 0x66a4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4001, 0x4008, 0x5593, 0x66a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4008, 0x403f, 0x5594, 0x66a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x5594, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x4040, 0x6eee, 0x9110, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x599a, 0x7fff, 0xa664, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0x6aab, 0x9553, 0xa665, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0x7fff, 0x9554, 0xa665, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x9554, 0xa666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x9555, 0xa666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x9555, 0xbbbb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0xaaaa, 0xcccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x9555, 0xbbbb, 0xe626, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9555, 0xa666, 0xd515, 0xe626, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa666, 0xbfc0, 0xd515, 0xe627, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xbfc1, 0xd516, 0xe627, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc1, 0xd516, 0xe627, 0xffb8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc1, 0xd516, 0xe65e, 0xffbe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc2, 0xd54d, 0xe664, 0xffbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbff8, 0xd553, 0xe665, 0xffbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0xd554, 0xe665, 0x7fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0xd554, 0x6666, 0x7fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0x5555, 0x6666, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x5555, 0x6667, 0x7fc8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4001, 0x5556, 0x666e, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4001, 0x555d, 0x66a4, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4008, 0x5593, 0x66a5, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x5594, 0x66a5, 0x9959, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x5594, 0x7fff, 0xaa6a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4040, 0x6eee, 0x9110, 0xbfbe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x599a, 0x7fff, 0xa664, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aab, 0x9553, 0xa665, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x9554, 0xa665, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x9554, 0xa666, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x9555, 0xa666, 0xd515, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x9555, 0xbbbb, 0xe626, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0xaaaa, 0xcccc, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9555, 0xbbbb, 0xe626, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa666, 0xd515, 0xe626, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xd515, 0xe627, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd515, 0xe627, 0xff81, 0xffb8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd516, 0xe627, 0xffb8, 0xffbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd516, 0xe65e, 0xffbe, 0xffbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd54d, 0xe664, 0xffbf, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd553, 0xe665, 0xffbf, 0x7fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0xe665, 0x7fc0, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0x6666, 0x7fc0, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x6666, 0x7fc1, 0x7fc8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x6667, 0x7fc8, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x666e, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x555d, 0x66a4, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5593, 0x66a5, 0x7fff, 0x995a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5594, 0x66a5, 0x9959, 0xaa6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5594, 0x7fff, 0xaa6a, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6eee, 0x9110, 0xbfbe, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xa664, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9553, 0xa665, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9554, 0xa665, 0xbfc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9554, 0xa666, 0xbfc0, 0xd515, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9555, 0xa666, 0xd515, 0xe626, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9555, 0xbbbb, 0xe626, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xcccc, 0xff80, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbbbb, 0xe626, 0xff80, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd515, 0xe626, 0xff81, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe626, 0xff81, 0xff82, 0xffb9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe627, 0xff81, 0xffb8, 0xffbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe627, 0xffb8, 0xffbf, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe65e, 0xffbe, 0xffbf, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe664, 0xffbf, 0xffc0, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe665, 0xffbf, 0x7fc0, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe665, 0x7fc0, 0x7fc1, 0x7fc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6666, 0x7fc0, 0x7fc1, 0x7fc9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6666, 0x7fc1, 0x7fc8, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6667, 0x7fc8, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x666e, 0x7ffe, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x66a4, 0x7fff, 0x8000, 0x995a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x66a5, 0x7fff, 0x995a, 0xaa6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x66a5, 0x9959, 0xaa6b, 0xbfbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xaa6a, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9110, 0xbfbe, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa664, 0xbfbf, 0xbfc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa665, 0xbfbf, 0xbfc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa665, 0xbfc0, 0xbfc1, 0xd516, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa666, 0xbfc0, 0xd515, 0xe627, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa666, 0xd515, 0xe626, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbbbb, 0xe626, 0xff80, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xff80, 0xff81, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe626, 0xff80, 0xff81, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff81, 0xff82, 0xffb9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff82, 0xffb9, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xffb8, 0xffbf, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffb8, 0xffbf, 0xffc0, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffbe, 0xffbf, 0xffc0, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffbf, 0xffc0, 0x7fc1, 0x7fc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffbf, 0x7fc0, 0x7fc1, 0x7fc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc0, 0x7fc1, 0x7fc2, 0x7fc9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc0, 0x7fc1, 0x7fc9, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc1, 0x7fc8, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc8, 0x7fff, 0x8000, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x995b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x995a, 0xaa6c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x995a, 0xaa6b, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9959, 0xaa6b, 0xbfbf, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaa6a, 0xbfbf, 0xbfc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbe, 0xbfbf, 0xbfc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfbf, 0xbfc0, 0xbfc1, 0xd516, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xbfc1, 0xd516, 0xe627, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xd515, 0xe627, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd515, 0xe626, 0xff81, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe626, 0xff80, 0xff81, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff81, 0xff82, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_uhadd_4H = 576;

#endif  // VIXL_SIM_UHADD_4H_TRACE_AARCH64_H_
