// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQDMLAL_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SQDMLAL_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_sqdmlal_4S[] = {
  0x00007c08, 0x00007e03, 0x147ab854, 0x38e31c92,
  0x00007d04, 0x0032cc9b, 0x2221dde0, 0x55530022,
  0x00326634, 0x0054aa57, 0x3331ccd0, 0x5553aacc,
  0x0053ffac, 0x007efd07, 0x33323336, 0x55545576,
  0x007dfd0c, 0x007efe05, 0x3332999c, 0x00000020,
  0x007dfe08, 0x007eff03, 0x00000002, 0x0000aaca,
  0x007dff04, 0x00000001, 0x00006668, 0x00015574,
  0x00000000, 0x000000ff, 0x0000ccce, 0x000aaac0,
  0x000000fc, 0x000001fd, 0x00066662, 0x00535522,
  0x000001f8, 0x00000fe1, 0x0031ffd0, 0x0053ffcc,
  0x00000fc0, 0x00007c07, 0x00326636, 0x0054aa76,
  0x00007b0c, 0x00007d05, 0x0032cc9c, 0x2221ddfe,
  0x00007c08, 0x00007e03, 0x147ab854, 0x38e31c92,
  0x00007d04, 0x0032cc9b, 0x2221dde0, 0x55530022,
  0x00326634, 0x0054aa57, 0x3331ccd0, 0x5553aacc,
  0x0053ffac, 0x007efd07, 0x33323336, 0x55545576,
  0x007dfd0c, 0x007efe05, 0x3332999c, 0xaaab0020,
  0x007dfe08, 0x007eff03, 0xcccd0002, 0xaaabaaca,
  0x007dff04, 0xff810001, 0xcccd6668, 0xc71c3904,
  0xff820000, 0xff8100ff, 0xddddbbbe, 0xdddd7798,
  0xff8200fc, 0xffab54ad, 0xeb84e14a, 0xffaaab20,
  0xffabff58, 0xffcd3269, 0xffcccd02, 0xffab55ca,
  0xffcd98d0, 0xffff8101, 0xffcd3368, 0xffac0074,
  0xffff8200, 0xffff81ff, 0xffcd99ce, 0xffacab1e,
  0xffff81fe, 0xffcd99cd, 0xffacab00, 0xfff00080,
  0xffff82fc, 0xffce0033, 0xfff55562, 0xfffd0032,
  0xffff83fa, 0xfff999a1, 0xfffe0004, 0xfffe002c,
  0xfffff020, 0xfffecccf, 0xfffeaaae, 0xffff0026,
  0xfffffd06, 0xffff3335, 0xffff5558, 0x00000020,
  0xfffffe04, 0xffff999b, 0x00000002, 0x0001001a,
  0xffffff02, 0x00000001, 0x0000aaac, 0x00020014,
  0x00000000, 0x00006667, 0x00015556, 0x000fffc0,
  0x000000fe, 0x0000cccd, 0x000aaaa2, 0x007cfd32,
  0x000001fc, 0x00066661, 0x00535504, 0x007dfd2c,
  0x00000fe0, 0x0031ffcf, 0x0053ffae, 0x007efd26,
  0x00007c06, 0x00326635, 0x0054aa58, 0x3331ccee,
  0x00007d04, 0x0032cc9b, 0x2221dde0, 0x55530022,
  0x00007e02, 0x147ab853, 0x38e31c74, 0x7ffa0032,
  0x0032cc9a, 0x2221dddf, 0x55530004, 0x7ffb002c,
  0x0054aa56, 0x3331cccf, 0x5553aaae, 0x7ffc0026,
  0x007efd06, 0x33323335, 0x55545558, 0x80030020,
  0x007efe04, 0x3332999b, 0xaaab0002, 0x8004001a,
  0x007eff02, 0xcccd0001, 0xaaabaaac, 0xaaac0024,
  0xff810000, 0xcccd6667, 0xc71c38e6, 0xcccd3358,
  0xff8100fe, 0xddddbbbd, 0xdddd777a, 0xff800320,
  0xffab54ac, 0xeb84e149, 0xffaaab02, 0xff81031a,
  0xffcd3268, 0xffcccd01, 0xffab55ac, 0xff820314,
  0xffff8100, 0xffcd3367, 0xffac0056, 0xff83030e,
  0xffcd3366, 0xffac0055, 0xff8302f0, 0xfff00060,
  0xffcd99cc, 0xffacaaff, 0xfff00062, 0xfffd002c,
  0xffce0032, 0xfff55561, 0xfffd0014, 0xfffe0028,
  0xfff999a0, 0xfffe0003, 0xfffe000e, 0xffff0024,
  0xfffeccce, 0xfffeaaad, 0xffff0008, 0x00000020,
  0xffff3334, 0xffff5557, 0x00000002, 0x0001001c,
  0xffff999a, 0x00000001, 0x0000fffc, 0x00020018,
  0x00000000, 0x0000aaab, 0x0001fff6, 0x000fffe0,
  0x00006666, 0x00015555, 0x000fffa2, 0x007cfe2c,
  0x0000cccc, 0x000aaaa1, 0x007cfd14, 0x007dfe28,
  0x00066660, 0x00535503, 0x007dfd0e, 0x007efe24,
  0x0031ffce, 0x0053ffad, 0x007efd08, 0x33323354,
  0x00326634, 0x0054aa57, 0x3331ccd0, 0x5553aacc,
  0x0032cc9a, 0x2221dddf, 0x55530004, 0x7ffb002c,
  0x147ab852, 0x38e31c73, 0x7ffa0014, 0x7ffc0028,
  0x2221ddde, 0x55530003, 0x7ffb000e, 0x7ffd0024,
  0x3331ccce, 0x5553aaad, 0x7ffc0008, 0x80020020,
  0x33323334, 0x55545557, 0x80030002, 0x8003001c,
  0x3332999a, 0xaaab0001, 0x8003fffc, 0xaaab5578,
  0xcccd0000, 0xaaabaaab, 0xaaac0006, 0xccccccf0,
  0xcccd6666, 0xc71c38e5, 0xcccd333a, 0xff800220,
  0xddddbbbc, 0xdddd7779, 0xff800302, 0xff81021c,
  0xeb84e148, 0xffaaab01, 0xff8102fc, 0xff820218,
  0xffcccd00, 0xffab55ab, 0xff8202f6, 0xff830214,
  0xffab55aa, 0xff8202f5, 0xff8301f6, 0xfff00040,
  0xffac0054, 0xff8302ef, 0xfff00042, 0xfffd0026,
  0xffacaafe, 0xfff00061, 0xfffd000e, 0xfffe0024,
  0xfff55560, 0xfffd0013, 0xfffe000a, 0xffff0022,
  0xfffe0002, 0xfffe000d, 0xffff0006, 0x00000020,
  0xfffeaaac, 0xffff0007, 0x00000002, 0x0001001e,
  0xffff5556, 0x00000001, 0x0000fffe, 0x0002001c,
  0x00000000, 0x0000fffb, 0x0001fffa, 0x00100000,
  0x0000aaaa, 0x0001fff5, 0x000fffc2, 0x007cff26,
  0x00015554, 0x000fffa1, 0x007cfe0e, 0x007dff24,
  0x000aaaa0, 0x007cfd13, 0x007dfe0a, 0x007eff22,
  0x00535502, 0x007dfd0d, 0x007efe06, 0x333299ba,
  0x0053ffac, 0x007efd07, 0x33323336, 0x55545576,
  0x0054aa56, 0x3331cccf, 0x5553aaae, 0x7ffc0026,
  0x2221ddde, 0x55530003, 0x7ffb000e, 0x7ffd0024,
  0x38e31c72, 0x7ffa0013, 0x7ffc000a, 0x7ffe0022,
  0x55530002, 0x7ffb000d, 0x7ffd0006, 0x80010020,
  0x5553aaac, 0x7ffc0007, 0x80020002, 0x8002001e,
  0x55545556, 0x80030001, 0x8002fffe, 0xaaaaaacc,
  0xaaab0000, 0x8003fffb, 0xaaab555a, 0xcccc6688,
  0xaaabaaaa, 0xaaac0005, 0xccccccd2, 0xff800120,
  0xc71c38e4, 0xcccd3339, 0xff800202, 0xff81011e,
  0xdddd7778, 0xff800301, 0xff8101fe, 0xff82011c,
  0xffaaab00, 0xff8102fb, 0xff8201fa, 0xff83011a,
  0xff8102fa, 0xff8201f9, 0xff8300fc, 0x00000020,
  0xff8202f4, 0xff8301f5, 0xfff00022, 0x00000020,
  0xff8302ee, 0xfff00041, 0xfffd0008, 0x00000020,
  0xfff00060, 0xfffd000d, 0xfffe0006, 0x00000020,
  0xfffd0012, 0xfffe0009, 0xffff0004, 0x00000020,
  0xfffe000c, 0xffff0005, 0x00000002, 0x00000020,
  0xffff0006, 0x00000001, 0x00010000, 0x00000020,
  0x00000000, 0x0000fffd, 0x0001fffe, 0x00000020,
  0x0000fffa, 0x0001fff9, 0x000fffe2, 0x00000020,
  0x0001fff4, 0x000fffc1, 0x007cff08, 0x00000020,
  0x000fffa0, 0x007cfe0d, 0x007dff06, 0x00000020,
  0x007cfd12, 0x007dfe09, 0x007eff04, 0x00000020,
  0x007dfd0c, 0x007efe05, 0x3332999c, 0x00000020,
  0x007efd06, 0x33323335, 0x55545558, 0x00000020,
  0x3331ccce, 0x5553aaad, 0x7ffc0008, 0x00000020,
  0x55530002, 0x7ffb000d, 0x7ffd0006, 0x00000020,
  0x7ffa0012, 0x7ffc0009, 0x7ffe0004, 0x00000020,
  0x7ffb000c, 0x7ffd0005, 0x80010002, 0x00000020,
  0x7ffc0006, 0x80020001, 0x80020000, 0x00000020,
  0x80030000, 0x8002fffd, 0xaaaaaaae, 0x00000020,
  0x8003fffa, 0xaaab5559, 0xcccc666a, 0x00000020,
  0xaaac0004, 0xccccccd1, 0xff800102, 0x00000020,
  0xcccd3338, 0xff800201, 0xff810100, 0x00000020,
  0xff800300, 0xff8101fd, 0xff8200fe, 0x00000020,
  0xff8101fc, 0xff8200fd, 0x00000002, 0x00000000,
  0xff8201f8, 0xff8300fb, 0x00000002, 0x0000001a,
  0xff8301f4, 0xfff00021, 0x00000002, 0x0000001c,
  0xfff00040, 0xfffd0007, 0x00000002, 0x0000001e,
  0xfffd000c, 0xfffe0005, 0x00000002, 0x00000020,
  0xfffe0008, 0xffff0003, 0x00000002, 0x00000022,
  0xffff0004, 0x00000001, 0x00000002, 0x00000024,
  0x00000000, 0x0000ffff, 0x00000002, 0x00000040,
  0x0000fffc, 0x0001fffd, 0x00000002, 0x0000011a,
  0x0001fff8, 0x000fffe1, 0x00000002, 0x0000011c,
  0x000fffc0, 0x007cff07, 0x00000002, 0x0000011e,
  0x007cfe0c, 0x007dff05, 0x00000002, 0x00006686,
  0x007dfe08, 0x007eff03, 0x00000002, 0x0000aaca,
  0x007efe04, 0x3332999b, 0x00000002, 0x0001001a,
  0x33323334, 0x55545557, 0x00000002, 0x0001001c,
  0x5553aaac, 0x7ffc0007, 0x00000002, 0x0001001e,
  0x7ffb000c, 0x7ffd0005, 0x00000002, 0xffff0020,
  0x7ffc0008, 0x7ffe0003, 0x00000002, 0xffff0022,
  0x7ffd0004, 0x80010001, 0x00000002, 0xffff5574,
  0x80020000, 0x8001ffff, 0x00000002, 0xffff99b8,
  0x8002fffc, 0xaaaaaaad, 0x00000002, 0xffffff20,
  0xaaab5558, 0xcccc6669, 0x00000002, 0xffffff22,
  0xccccccd0, 0xff800101, 0x00000002, 0xffffff24,
  0xff800200, 0xff8100ff, 0x00000002, 0xffffff26,
  0xff8100fe, 0x00000001, 0xffffff08, 0xffffffe0,
  0xff8200fc, 0x00000001, 0xffffffe2, 0x00000014,
  0xff8300fa, 0x00000001, 0xfffffffc, 0x00000018,
  0xfff00020, 0x00000001, 0xfffffffe, 0x0000001c,
  0xfffd0006, 0x00000001, 0x00000000, 0x00000020,
  0xfffe0004, 0x00000001, 0x00000002, 0x00000024,
  0xffff0002, 0x00000001, 0x00000004, 0x00000028,
  0x00000000, 0x00000001, 0x00000006, 0x00000060,
  0x0000fffe, 0x00000001, 0x00000022, 0x00000214,
  0x0001fffc, 0x00000001, 0x000000fc, 0x00000218,
  0x000fffe0, 0x00000001, 0x000000fe, 0x0000021c,
  0x007cff06, 0x00000001, 0x00000100, 0x0000ccec,
  0x007dff04, 0x00000001, 0x00006668, 0x00015574,
  0x007eff02, 0x00000001, 0x0000aaac, 0x00020014,
  0x3332999a, 0x00000001, 0x0000fffc, 0x00020018,
  0x55545556, 0x00000001, 0x0000fffe, 0x0002001c,
  0x7ffc0006, 0x00000001, 0x00010000, 0xfffe0020,
  0x7ffd0004, 0x00000001, 0xffff0002, 0xfffe0024,
  0x7ffe0002, 0x00000001, 0xffff0004, 0xfffeaac8,
  0x80010000, 0x00000001, 0xffff5556, 0xffff3350,
  0x8001fffe, 0x00000001, 0xffff999a, 0xfffffe20,
  0xaaaaaaac, 0x00000001, 0xffffff02, 0xfffffe24,
  0xcccc6668, 0x00000001, 0xffffff04, 0xfffffe28,
  0xff800100, 0x00000001, 0xffffff06, 0xfffffe2c,
  0x00000000, 0xffffff05, 0xfffffe0e, 0xfffffe20,
  0x00000000, 0xffffff07, 0xffffffc2, 0xffffffc0,
  0x00000000, 0xffffffe1, 0xfffffff6, 0xffffffe0,
  0x00000000, 0xfffffffb, 0xfffffffa, 0x00000000,
  0x00000000, 0xfffffffd, 0xfffffffe, 0x00000020,
  0x00000000, 0xffffffff, 0x00000002, 0x00000040,
  0x00000000, 0x00000001, 0x00000006, 0x00000060,
  0x00000000, 0x00000003, 0x0000000a, 0x00000220,
  0x00000000, 0x00000005, 0x00000042, 0x00000fc0,
  0x00000000, 0x00000021, 0x000001f6, 0x00000fe0,
  0x00000000, 0x000000fb, 0x000001fa, 0x00001000,
  0x00000000, 0x000000fd, 0x000001fe, 0x00066680,
  0x00000000, 0x000000ff, 0x0000ccce, 0x000aaac0,
  0x00000000, 0x00006667, 0x00015556, 0x000fffc0,
  0x00000000, 0x0000aaab, 0x0001fff6, 0x000fffe0,
  0x00000000, 0x0000fffb, 0x0001fffa, 0x00100000,
  0x00000000, 0x0000fffd, 0x0001fffe, 0xfff00020,
  0x00000000, 0x0000ffff, 0xfffe0002, 0xfff00040,
  0x00000000, 0xffff0001, 0xfffe0006, 0xfff55560,
  0x00000000, 0xffff0003, 0xfffeaaaa, 0xfff999a0,
  0x00000000, 0xffff5555, 0xffff3332, 0xfffff020,
  0x00000000, 0xffff9999, 0xfffffe02, 0xfffff040,
  0x00000000, 0xffffff01, 0xfffffe06, 0xfffff060,
  0x00000000, 0xffffff03, 0xfffffe0a, 0xfffff080,
  0xffffff02, 0xfffffe09, 0xfffff062, 0xfffff080,
  0xffffff04, 0xfffffe0d, 0xfffffe02, 0xfffffd32,
  0xffffff06, 0xffffffc1, 0xffffffa2, 0xfffffe2c,
  0xffffffe0, 0xfffffff5, 0xffffffc2, 0xffffff26,
  0xfffffffa, 0xfffffff9, 0xffffffe2, 0x00000020,
  0xfffffffc, 0xfffffffd, 0x00000002, 0x0000011a,
  0xfffffffe, 0x00000001, 0x00000022, 0x00000214,
  0x00000000, 0x00000005, 0x00000042, 0x00000fc0,
  0x00000002, 0x00000009, 0x00000202, 0x00007a32,
  0x00000004, 0x00000041, 0x00000fa2, 0x00007b2c,
  0x00000020, 0x000001f5, 0x00000fc2, 0x00007c26,
  0x000000fa, 0x000001f9, 0x00000fe2, 0x0031ffee,
  0x000000fc, 0x000001fd, 0x00066662, 0x00535522,
  0x000000fe, 0x0000cccd, 0x000aaaa2, 0x007cfd32,
  0x00006666, 0x00015555, 0x000fffa2, 0x007cfe2c,
  0x0000aaaa, 0x0001fff5, 0x000fffc2, 0x007cff26,
  0x0000fffa, 0x0001fff9, 0x000fffe2, 0xff830020,
  0x0000fffc, 0x0001fffd, 0xfff00002, 0xff83011a,
  0x0000fffe, 0xfffe0001, 0xfff00022, 0xffacaa24,
  0xffff0000, 0xfffe0005, 0xfff55542, 0xffcdff58,
  0xffff0002, 0xfffeaaa9, 0xfff99982, 0xffff8320,
  0xffff5554, 0xffff3331, 0xfffff002, 0xffff841a,
  0xffff9998, 0xfffffe01, 0xfffff022, 0xffff8514,
  0xffffff00, 0xfffffe05, 0xfffff042, 0xffff860e,
  0xfffffe04, 0xfffff041, 0xffff85f0, 0xfffff060,
  0xfffffe08, 0xfffff061, 0xfffff062, 0xfffffd2c,
  0xfffffe0c, 0xfffffe01, 0xfffffd14, 0xfffffe28,
  0xffffffc0, 0xffffffa1, 0xfffffe0e, 0xffffff24,
  0xfffffff4, 0xffffffc1, 0xffffff08, 0x00000020,
  0xfffffff8, 0xffffffe1, 0x00000002, 0x0000011c,
  0xfffffffc, 0x00000001, 0x000000fc, 0x00000218,
  0x00000000, 0x00000021, 0x000001f6, 0x00000fe0,
  0x00000004, 0x00000041, 0x00000fa2, 0x00007b2c,
  0x00000008, 0x00000201, 0x00007a14, 0x00007c28,
  0x00000040, 0x00000fa1, 0x00007b0e, 0x00007d24,
  0x000001f4, 0x00000fc1, 0x00007c08, 0x00326654,
  0x000001f8, 0x00000fe1, 0x0031ffd0, 0x0053ffcc,
  0x000001fc, 0x00066661, 0x00535504, 0x007dfd2c,
  0x0000cccc, 0x000aaaa1, 0x007cfd14, 0x007dfe28,
  0x00015554, 0x000fffa1, 0x007cfe0e, 0x007dff24,
  0x0001fff4, 0x000fffc1, 0x007cff08, 0xff820020,
  0x0001fff8, 0x000fffe1, 0xff830002, 0xff82011c,
  0x0001fffc, 0xfff00001, 0xff8300fc, 0xffabff78,
  0xfffe0000, 0xfff00021, 0xffacaa06, 0xffcd98f0,
  0xfffe0004, 0xfff55541, 0xffcdff3a, 0xffff8220,
  0xfffeaaa8, 0xfff99981, 0xffff8302, 0xffff831c,
  0xffff3330, 0xfffff001, 0xffff83fc, 0xffff8418,
  0xfffffe00, 0xfffff021, 0xffff84f6, 0xffff8514,
  0xfffff020, 0xffff84f5, 0xffff84f6, 0xfffff040,
  0xfffff040, 0xffff85ef, 0xfffff042, 0xfffffd26,
  0xfffff060, 0xfffff061, 0xfffffd0e, 0xfffffe24,
  0xfffffe00, 0xfffffd13, 0xfffffe0a, 0xffffff22,
  0xffffffa0, 0xfffffe0d, 0xffffff06, 0x00000020,
  0xffffffc0, 0xffffff07, 0x00000002, 0x0000011e,
  0xffffffe0, 0x00000001, 0x000000fe, 0x0000021c,
  0x00000000, 0x000000fb, 0x000001fa, 0x00001000,
  0x00000020, 0x000001f5, 0x00000fc2, 0x00007c26,
  0x00000040, 0x00000fa1, 0x00007b0e, 0x00007d24,
  0x00000200, 0x00007a13, 0x00007c0a, 0x00007e22,
  0x00000fa0, 0x00007b0d, 0x00007d06, 0x0032ccba,
  0x00000fc0, 0x00007c07, 0x00326636, 0x0054aa76,
  0x00000fe0, 0x0031ffcf, 0x0053ffae, 0x007efd26,
  0x00066660, 0x00535503, 0x007dfd0e, 0x007efe24,
  0x000aaaa0, 0x007cfd13, 0x007dfe0a, 0x007eff22,
  0x000fffa0, 0x007cfe0d, 0x007dff06, 0xff810020,
  0x000fffc0, 0x007cff07, 0xff820002, 0xff81011e,
  0x000fffe0, 0xff830001, 0xff8200fe, 0xffab54cc,
  0xfff00000, 0xff8300fb, 0xffabff5a, 0xffcd3288,
  0xfff00020, 0xffacaa05, 0xffcd98d2, 0xffff8120,
  0xfff55540, 0xffcdff39, 0xffff8202, 0xffff821e,
  0xfff99980, 0xffff8301, 0xffff82fe, 0xffff831c,
  0xfffff000, 0xffff83fb, 0xffff83fa, 0xffff841a,
  0xffff83fa, 0xffff83f9, 0xffff83fc, 0xfff999c0,
  0xffff84f4, 0xffff84f5, 0xfffff022, 0xfffeccee,
  0xffff85ee, 0xfffff041, 0xfffffd08, 0xffff3354,
  0xfffff060, 0xfffffd0d, 0xfffffe06, 0xffff99ba,
  0xfffffd12, 0xfffffe09, 0xffffff04, 0x00000020,
  0xfffffe0c, 0xffffff05, 0x00000002, 0x00006686,
  0xffffff06, 0x00000001, 0x00000100, 0x0000ccec,
  0x00000000, 0x000000fd, 0x000001fe, 0x00066680,
  0x000000fa, 0x000001f9, 0x00000fe2, 0x0031ffee,
  0x000001f4, 0x00000fc1, 0x00007c08, 0x00326654,
  0x00000fa0, 0x00007b0d, 0x00007d06, 0x0032ccba,
  0x00007a12, 0x00007c09, 0x00007e04, 0x147ab872,
  0x00007b0c, 0x00007d05, 0x0032cc9c, 0x2221ddfe,
  0x00007c06, 0x00326635, 0x0054aa58, 0x3331ccee,
  0x0031ffce, 0x0053ffad, 0x007efd08, 0x33323354,
  0x00535502, 0x007dfd0d, 0x007efe06, 0x333299ba,
  0x007cfd12, 0x007dfe09, 0x007eff04, 0xcccd0020,
  0x007cfe0c, 0x007dff05, 0xff810002, 0xcccd6686,
  0x007cff06, 0xff820001, 0xff810100, 0xddddbbdc,
  0xff830000, 0xff8200fd, 0xffab54ae, 0xeb84e168,
  0xff8300fa, 0xffabff59, 0xffcd326a, 0xffcccd20,
  0xffacaa04, 0xffcd98d1, 0xffff8102, 0xffcd3386,
  0xffcdff38, 0xffff8201, 0xffff8200, 0xffcd99ec,
  0xffff8300, 0xffff82fd, 0xffff82fe, 0xffce0052,
  0xffff82fc, 0xffff82fd, 0xffce0034, 0xfff55580,
  0xffff83f8, 0xffff83fb, 0xfff999a2, 0xfffe0022,
  0xffff84f4, 0xfffff021, 0xfffeccd0, 0xfffeaacc,
  0xfffff040, 0xfffffd07, 0xffff3336, 0xffff5576,
  0xfffffd0c, 0xfffffe05, 0xffff999c, 0x00000020,
  0xfffffe08, 0xffffff03, 0x00000002, 0x0000aaca,
  0xffffff04, 0x00000001, 0x00006668, 0x00015574,
  0x00000000, 0x000000ff, 0x0000ccce, 0x000aaac0,
  0x000000fc, 0x000001fd, 0x00066662, 0x00535522,
  0x000001f8, 0x00000fe1, 0x0031ffd0, 0x0053ffcc,
  0x00000fc0, 0x00007c07, 0x00326636, 0x0054aa76,
  0x00007b0c, 0x00007d05, 0x0032cc9c, 0x2221ddfe,
  0x00007c08, 0x00007e03, 0x147ab854, 0x38e31c92,
  0x00007d04, 0x0032cc9b, 0x2221dde0, 0x55530022,
  0x00326634, 0x0054aa57, 0x3331ccd0, 0x5553aacc,
  0x0053ffac, 0x007efd07, 0x33323336, 0x55545576,
  0x007dfd0c, 0x007efe05, 0x3332999c, 0xaaab0020,
  0x007dfe08, 0x007eff03, 0xcccd0002, 0xaaabaaca,
  0x007dff04, 0xff810001, 0xcccd6668, 0xc71c3904,
  0xff820000, 0xff8100ff, 0xddddbbbe, 0xdddd7798,
  0xff8200fc, 0xffab54ad, 0xeb84e14a, 0xffaaab20,
  0xffabff58, 0xffcd3269, 0xffcccd02, 0xffab55ca,
  0xffcd98d0, 0xffff8101, 0xffcd3368, 0xffac0074,
  0xffff8200, 0xffff81ff, 0xffcd99ce, 0xffacab1e,
  0xffff81fe, 0xffcd99cd, 0xffacab00, 0xfff00080,
  0xffff82fc, 0xffce0033, 0xfff55562, 0xfffd0032,
  0xffff83fa, 0xfff999a1, 0xfffe0004, 0xfffe002c,
  0xfffff020, 0xfffecccf, 0xfffeaaae, 0xffff0026,
  0xfffffd06, 0xffff3335, 0xffff5558, 0x00000020,
  0xfffffe04, 0xffff999b, 0x00000002, 0x0001001a,
  0xffffff02, 0x00000001, 0x0000aaac, 0x00020014,
  0x00000000, 0x00006667, 0x00015556, 0x000fffc0,
  0x000000fe, 0x0000cccd, 0x000aaaa2, 0x007cfd32,
  0x000001fc, 0x00066661, 0x00535504, 0x007dfd2c,
  0x00000fe0, 0x0031ffcf, 0x0053ffae, 0x007efd26,
  0x00007c06, 0x00326635, 0x0054aa58, 0x3331ccee,
  0x00007d04, 0x0032cc9b, 0x2221dde0, 0x55530022,
  0x00007e02, 0x147ab853, 0x38e31c74, 0x7ffa0032,
  0x0032cc9a, 0x2221dddf, 0x55530004, 0x7ffb002c,
  0x0054aa56, 0x3331cccf, 0x5553aaae, 0x7ffc0026,
  0x007efd06, 0x33323335, 0x55545558, 0x80030020,
  0x007efe04, 0x3332999b, 0xaaab0002, 0x8004001a,
  0x007eff02, 0xcccd0001, 0xaaabaaac, 0xaaac0024,
  0xff810000, 0xcccd6667, 0xc71c38e6, 0xcccd3358,
  0xff8100fe, 0xddddbbbd, 0xdddd777a, 0xff800320,
  0xffab54ac, 0xeb84e149, 0xffaaab02, 0xff81031a,
  0xffcd3268, 0xffcccd01, 0xffab55ac, 0xff820314,
  0xffff8100, 0xffcd3367, 0xffac0056, 0xff83030e,
  0xffcd3366, 0xffac0055, 0xff8302f0, 0xfff00060,
  0xffcd99cc, 0xffacaaff, 0xfff00062, 0xfffd002c,
  0xffce0032, 0xfff55561, 0xfffd0014, 0xfffe0028,
  0xfff999a0, 0xfffe0003, 0xfffe000e, 0xffff0024,
  0xfffeccce, 0xfffeaaad, 0xffff0008, 0x00000020,
  0xffff3334, 0xffff5557, 0x00000002, 0x0001001c,
  0xffff999a, 0x00000001, 0x0000fffc, 0x00020018,
  0x00000000, 0x0000aaab, 0x0001fff6, 0x000fffe0,
  0x00006666, 0x00015555, 0x000fffa2, 0x007cfe2c,
  0x0000cccc, 0x000aaaa1, 0x007cfd14, 0x007dfe28,
  0x00066660, 0x00535503, 0x007dfd0e, 0x007efe24,
  0x0031ffce, 0x0053ffad, 0x007efd08, 0x33323354,
  0x00326634, 0x0054aa57, 0x3331ccd0, 0x5553aacc,
  0x0032cc9a, 0x2221dddf, 0x55530004, 0x7ffb002c,
  0x147ab852, 0x38e31c73, 0x7ffa0014, 0x7ffc0028,
  0x2221ddde, 0x55530003, 0x7ffb000e, 0x7ffd0024,
  0x3331ccce, 0x5553aaad, 0x7ffc0008, 0x80020020,
  0x33323334, 0x55545557, 0x80030002, 0x8003001c,
  0x3332999a, 0xaaab0001, 0x8003fffc, 0xaaab5578,
  0xcccd0000, 0xaaabaaab, 0xaaac0006, 0xccccccf0,
  0xcccd6666, 0xc71c38e5, 0xcccd333a, 0xff800220,
  0xddddbbbc, 0xdddd7779, 0xff800302, 0xff81021c,
  0xeb84e148, 0xffaaab01, 0xff8102fc, 0xff820218,
  0xffcccd00, 0xffab55ab, 0xff8202f6, 0xff830214,
  0xffab55aa, 0xff8202f5, 0xff8301f6, 0xfff00040,
  0xffac0054, 0xff8302ef, 0xfff00042, 0xfffd0026,
  0xffacaafe, 0xfff00061, 0xfffd000e, 0xfffe0024,
  0xfff55560, 0xfffd0013, 0xfffe000a, 0xffff0022,
  0xfffe0002, 0xfffe000d, 0xffff0006, 0x00000020,
  0xfffeaaac, 0xffff0007, 0x00000002, 0x0001001e,
  0xffff5556, 0x00000001, 0x0000fffe, 0x0002001c,
  0x00000000, 0x0000fffb, 0x0001fffa, 0x00100000,
  0x0000aaaa, 0x0001fff5, 0x000fffc2, 0x007cff26,
  0x00015554, 0x000fffa1, 0x007cfe0e, 0x007dff24,
  0x000aaaa0, 0x007cfd13, 0x007dfe0a, 0x007eff22,
  0x00535502, 0x007dfd0d, 0x007efe06, 0x333299ba,
  0x0053ffac, 0x007efd07, 0x33323336, 0x55545576,
  0x0054aa56, 0x3331cccf, 0x5553aaae, 0x7ffc0026,
  0x2221ddde, 0x55530003, 0x7ffb000e, 0x7ffd0024,
  0x38e31c72, 0x7ffa0013, 0x7ffc000a, 0x7ffe0022,
  0x55530002, 0x7ffb000d, 0x7ffd0006, 0x80010020,
  0x5553aaac, 0x7ffc0007, 0x80020002, 0x8002001e,
  0x55545556, 0x80030001, 0x8002fffe, 0xaaaaaacc,
  0xaaab0000, 0x8003fffb, 0xaaab555a, 0xcccc6688,
  0xaaabaaaa, 0xaaac0005, 0xccccccd2, 0xff800120,
  0xc71c38e4, 0xcccd3339, 0xff800202, 0xff81011e,
  0xdddd7778, 0xff800301, 0xff8101fe, 0xff82011c,
  0xffaaab00, 0xff8102fb, 0xff8201fa, 0xff83011a,
  0xff8102fa, 0xff8201f9, 0xff8300fc, 0x00100020,
  0xff8202f4, 0xff8301f5, 0xfff00022, 0x00030020,
  0xff8302ee, 0xfff00041, 0xfffd0008, 0x00020020,
  0xfff00060, 0xfffd000d, 0xfffe0006, 0x00010020,
  0xfffd0012, 0xfffe0009, 0xffff0004, 0x00000020,
  0xfffe000c, 0xffff0005, 0x00000002, 0xffff0020,
  0xffff0006, 0x00000001, 0x00010000, 0xfffe0020,
  0x00000000, 0x0000fffd, 0x0001fffe, 0xfff00020,
  0x0000fffa, 0x0001fff9, 0x000fffe2, 0xff830020,
  0x0001fff4, 0x000fffc1, 0x007cff08, 0xff820020,
  0x000fffa0, 0x007cfe0d, 0x007dff06, 0xff810020,
  0x007cfd12, 0x007dfe09, 0x007eff04, 0xcccd0020,
  0x007dfd0c, 0x007efe05, 0x3332999c, 0xaaab0020,
  0x007efd06, 0x33323335, 0x55545558, 0x80030020,
  0x3331ccce, 0x5553aaad, 0x7ffc0008, 0x80020020,
  0x55530002, 0x7ffb000d, 0x7ffd0006, 0x80010020,
  0x7ffa0012, 0x7ffc0009, 0x7ffe0004, 0x7fffffff,
  0x7ffb000c, 0x7ffd0005, 0x80010002, 0x7fff0020,
  0x7ffc0006, 0x80020001, 0x80020000, 0x55560020,
  0x80030000, 0x8002fffd, 0xaaaaaaae, 0x33340020,
  0x8003fffa, 0xaaab5559, 0xcccc666a, 0x00800020,
  0xaaac0004, 0xccccccd1, 0xff800102, 0x007f0020,
  0xcccd3338, 0xff800201, 0xff810100, 0x007e0020,
  0xff800300, 0xff8101fd, 0xff8200fe, 0x007d0020,
  0xff8101fc, 0xff8200fd, 0x007d0002, 0x00100000,
  0xff8201f8, 0xff8300fb, 0x00100002, 0x0003001a,
  0xff8301f4, 0xfff00021, 0x00030002, 0x0002001c,
  0xfff00040, 0xfffd0007, 0x00020002, 0x0001001e,
  0xfffd000c, 0xfffe0005, 0x00010002, 0x00000020,
  0xfffe0008, 0xffff0003, 0x00000002, 0xffff0022,
  0xffff0004, 0x00000001, 0xffff0002, 0xfffe0024,
  0x00000000, 0x0000ffff, 0xfffe0002, 0xfff00040,
  0x0000fffc, 0x0001fffd, 0xfff00002, 0xff83011a,
  0x0001fff8, 0x000fffe1, 0xff830002, 0xff82011c,
  0x000fffc0, 0x007cff07, 0xff820002, 0xff81011e,
  0x007cfe0c, 0x007dff05, 0xff810002, 0xcccd6686,
  0x007dfe08, 0x007eff03, 0xcccd0002, 0xaaabaaca,
  0x007efe04, 0x3332999b, 0xaaab0002, 0x8004001a,
  0x33323334, 0x55545557, 0x80030002, 0x8003001c,
  0x5553aaac, 0x7ffc0007, 0x80020002, 0x8002001e,
  0x7ffb000c, 0x7ffd0005, 0x80010002, 0x7fff0020,
  0x7ffc0008, 0x7ffe0003, 0x7fffffff, 0x7ffe0022,
  0x7ffd0004, 0x80010001, 0x7fff0002, 0x55555574,
  0x80020000, 0x8001ffff, 0x55560002, 0x333399b8,
  0x8002fffc, 0xaaaaaaad, 0x33340002, 0x007fff20,
  0xaaab5558, 0xcccc6669, 0x00800002, 0x007eff22,
  0xccccccd0, 0xff800101, 0x007f0002, 0x007dff24,
  0xff800200, 0xff8100ff, 0x007e0002, 0x007cff26,
  0xff8100fe, 0x007e0001, 0x007cff08, 0x000aaae0,
  0xff8200fc, 0x007d0001, 0x000fffe2, 0x00020024,
  0xff8300fa, 0x00100001, 0x0002fffc, 0x00015578,
  0xfff00020, 0x00030001, 0x0001fffe, 0x0000aacc,
  0xfffd0006, 0x00020001, 0x00010000, 0x00000020,
  0xfffe0004, 0x00010001, 0x00000002, 0xffff5574,
  0xffff0002, 0x00000001, 0xffff0004, 0xfffeaac8,
  0x00000000, 0xffff0001, 0xfffe0006, 0xfff55560,
  0x0000fffe, 0xfffe0001, 0xfff00022, 0xffacaa24,
  0x0001fffc, 0xfff00001, 0xff8300fc, 0xffabff78,
  0x000fffe0, 0xff830001, 0xff8200fe, 0xffab54cc,
  0x007cff06, 0xff820001, 0xff810100, 0xddddbbdc,
  0x007dff04, 0xff810001, 0xcccd6668, 0xc71c3904,
  0x007eff02, 0xcccd0001, 0xaaabaaac, 0xaaac0024,
  0x3332999a, 0xaaab0001, 0x8003fffc, 0xaaab5578,
  0x55545556, 0x80030001, 0x8002fffe, 0xaaaaaacc,
  0x7ffc0006, 0x80020001, 0x80020000, 0x55560020,
  0x7ffd0004, 0x80010001, 0x7fff0002, 0x55555574,
  0x7ffe0002, 0x7fffffff, 0x7ffe0004, 0x38e471e8,
  0x80010000, 0x7fff0001, 0x55555556, 0x2222ef10,
  0x8001fffe, 0x55560001, 0x3333999a, 0x00555620,
  0xaaaaaaac, 0x33340001, 0x007fff02, 0x0054ab74,
  0xcccc6668, 0x00800001, 0x007eff04, 0x005400c8,
  0xff800100, 0x007f0001, 0x007dff06, 0x0053561c,
  0x007f0000, 0x007dff05, 0x005355fe, 0x000666a0,
  0x007e0000, 0x007cff07, 0x000aaac2, 0x00013358,
  0x007d0000, 0x000fffe1, 0x00020006, 0x0000ccf0,
  0x00100000, 0x0002fffb, 0x0001555a, 0x00006688,
  0x00030000, 0x0001fffd, 0x0000aaae, 0x00000020,
  0x00020000, 0x0000ffff, 0x00000002, 0xffff99b8,
  0x00010000, 0x00000001, 0xffff5556, 0xffff3350,
  0x00000000, 0xffff0003, 0xfffeaaaa, 0xfff999a0,
  0xffff0000, 0xfffe0005, 0xfff55542, 0xffcdff58,
  0xfffe0000, 0xfff00021, 0xffacaa06, 0xffcd98f0,
  0xfff00000, 0xff8300fb, 0xffabff5a, 0xffcd3288,
  0xff830000, 0xff8200fd, 0xffab54ae, 0xeb84e168,
  0xff820000, 0xff8100ff, 0xddddbbbe, 0xdddd7798,
  0xff810000, 0xcccd6667, 0xc71c38e6, 0xcccd3358,
  0xcccd0000, 0xaaabaaab, 0xaaac0006, 0xccccccf0,
  0xaaab0000, 0x8003fffb, 0xaaab555a, 0xcccc6688,
  0x80030000, 0x8002fffd, 0xaaaaaaae, 0x33340020,
  0x80020000, 0x8001ffff, 0x55560002, 0x333399b8,
  0x80010000, 0x7fff0001, 0x55555556, 0x2222ef10,
  0x7fffffff, 0x7ffe0003, 0x38e471ca, 0x147b8540,
  0x7fff0000, 0x55555555, 0x2222eef2, 0x00333420,
  0x55560000, 0x33339999, 0x00555602, 0x0032cdb8,
  0x33340000, 0x007fff01, 0x0054ab56, 0x00326750,
  0x00800000, 0x007eff03, 0x005400aa, 0x003200e8,
  0x007eff02, 0x005400a9, 0x003200ca, 0x00001020,
  0x007dff04, 0x005355fd, 0x00066682, 0x00000320,
  0x007cff06, 0x000aaac1, 0x0001333a, 0x00000220,
  0x000fffe0, 0x00020005, 0x0000ccd2, 0x00000120,
  0x0002fffa, 0x00015559, 0x0000666a, 0x00000020,
  0x0001fffc, 0x0000aaad, 0x00000002, 0xffffff20,
  0x0000fffe, 0x00000001, 0xffff999a, 0xfffffe20,
  0x00000000, 0xffff5555, 0xffff3332, 0xfffff020,
  0xffff0002, 0xfffeaaa9, 0xfff99982, 0xffff8320,
  0xfffe0004, 0xfff55541, 0xffcdff3a, 0xffff8220,
  0xfff00020, 0xffacaa05, 0xffcd98d2, 0xffff8120,
  0xff8300fa, 0xffabff59, 0xffcd326a, 0xffcccd20,
  0xff8200fc, 0xffab54ad, 0xeb84e14a, 0xffaaab20,
  0xff8100fe, 0xddddbbbd, 0xdddd777a, 0xff800320,
  0xcccd6666, 0xc71c38e5, 0xcccd333a, 0xff800220,
  0xaaabaaaa, 0xaaac0005, 0xccccccd2, 0xff800120,
  0x8003fffa, 0xaaab5559, 0xcccc666a, 0x00800020,
  0x8002fffc, 0xaaaaaaad, 0x33340002, 0x007fff20,
  0x8001fffe, 0x55560001, 0x3333999a, 0x00555620,
  0x7fff0000, 0x55555555, 0x2222eef2, 0x00333420,
  0x7ffe0002, 0x38e471c9, 0x147b8522, 0x00008020,
  0x55555554, 0x2222eef1, 0x00333402, 0x00007f20,
  0x33339998, 0x00555601, 0x0032cd9a, 0x00007e20,
  0x007fff00, 0x0054ab55, 0x00326732, 0x00007d20,
  0x0054ab54, 0x00326731, 0x00007d02, 0x00001000,
  0x005400a8, 0x003200c9, 0x00001002, 0x0000031a,
  0x005355fc, 0x00066681, 0x00000302, 0x0000021c,
  0x000aaac0, 0x00013339, 0x00000202, 0x0000011e,
  0x00020004, 0x0000ccd1, 0x00000102, 0x00000020,
  0x00015558, 0x00006669, 0x00000002, 0xffffff22,
  0x0000aaac, 0x00000001, 0xffffff02, 0xfffffe24,
  0x00000000, 0xffff9999, 0xfffffe02, 0xfffff040,
  0xffff5554, 0xffff3331, 0xfffff002, 0xffff841a,
  0xfffeaaa8, 0xfff99981, 0xffff8302, 0xffff831c,
  0xfff55540, 0xffcdff39, 0xffff8202, 0xffff821e,
  0xffacaa04, 0xffcd98d1, 0xffff8102, 0xffcd3386,
  0xffabff58, 0xffcd3269, 0xffcccd02, 0xffab55ca,
  0xffab54ac, 0xeb84e149, 0xffaaab02, 0xff81031a,
  0xddddbbbc, 0xdddd7779, 0xff800302, 0xff81021c,
  0xc71c38e4, 0xcccd3339, 0xff800202, 0xff81011e,
  0xaaac0004, 0xccccccd1, 0xff800102, 0x007f0020,
  0xaaab5558, 0xcccc6669, 0x00800002, 0x007eff22,
  0xaaaaaaac, 0x33340001, 0x007fff02, 0x0054ab74,
  0x55560000, 0x33339999, 0x00555602, 0x0032cdb8,
  0x55555554, 0x2222eef1, 0x00333402, 0x00007f20,
  0x38e471c8, 0x147b8521, 0x00008002, 0x00007e22,
  0x2222eef0, 0x00333401, 0x00007f02, 0x00007d24,
  0x00555600, 0x0032cd99, 0x00007e02, 0x00007c26,
  0x0032cd98, 0x00007e01, 0x00007c08, 0x00000fe0,
  0x00326730, 0x00007d01, 0x00000fe2, 0x00000314,
  0x003200c8, 0x00001001, 0x000002fc, 0x00000218,
  0x00066680, 0x00000301, 0x000001fe, 0x0000011c,
  0x00013338, 0x00000201, 0x00000100, 0x00000020,
  0x0000ccd0, 0x00000101, 0x00000002, 0xffffff24,
  0x00006668, 0x00000001, 0xffffff04, 0xfffffe28,
  0x00000000, 0xffffff01, 0xfffffe06, 0xfffff060,
  0xffff9998, 0xfffffe01, 0xfffff022, 0xffff8514,
  0xffff3330, 0xfffff001, 0xffff83fc, 0xffff8418,
  0xfff99980, 0xffff8301, 0xffff82fe, 0xffff831c,
  0xffcdff38, 0xffff8201, 0xffff8200, 0xffcd99ec,
  0xffcd98d0, 0xffff8101, 0xffcd3368, 0xffac0074,
  0xffcd3268, 0xffcccd01, 0xffab55ac, 0xff820314,
  0xeb84e148, 0xffaaab01, 0xff8102fc, 0xff820218,
  0xdddd7778, 0xff800301, 0xff8101fe, 0xff82011c,
  0xcccd3338, 0xff800201, 0xff810100, 0x007e0020,
  0xccccccd0, 0xff800101, 0x007f0002, 0x007dff24,
  0xcccc6668, 0x00800001, 0x007eff04, 0x005400c8,
  0x33340000, 0x007fff01, 0x0054ab56, 0x00326750,
  0x33339998, 0x00555601, 0x0032cd9a, 0x00007e20,
  0x2222eef0, 0x00333401, 0x00007f02, 0x00007d24,
  0x147b8520, 0x00008001, 0x00007e04, 0x00007c28,
  0x00333400, 0x00007f01, 0x00007d06, 0x00007b2c,
  0x00007f00, 0x00007d05, 0x00007b0e, 0x00000fc0,
  0x00007e00, 0x00007c07, 0x00000fc2, 0x0000030e,
  0x00007d00, 0x00000fe1, 0x000002f6, 0x00000214,
  0x00001000, 0x000002fb, 0x000001fa, 0x0000011a,
  0x00000300, 0x000001fd, 0x000000fe, 0x00000020,
  0x00000200, 0x000000ff, 0x00000002, 0xffffff26,
  0x00000100, 0x00000001, 0xffffff06, 0xfffffe2c,
  0x00000000, 0xffffff03, 0xfffffe0a, 0xfffff080,
  0xffffff00, 0xfffffe05, 0xfffff042, 0xffff860e,
  0xfffffe00, 0xfffff021, 0xffff84f6, 0xffff8514,
  0xfffff000, 0xffff83fb, 0xffff83fa, 0xffff841a,
  0xffff8300, 0xffff82fd, 0xffff82fe, 0xffce0052,
  0xffff8200, 0xffff81ff, 0xffcd99ce, 0xffacab1e,
  0xffff8100, 0xffcd3367, 0xffac0056, 0xff83030e,
  0xffcccd00, 0xffab55ab, 0xff8202f6, 0xff830214,
  0xffaaab00, 0xff8102fb, 0xff8201fa, 0xff83011a,
  0xff800300, 0xff8101fd, 0xff8200fe, 0x007d0020,
  0xff800200, 0xff8100ff, 0x007e0002, 0x007cff26,
  0xff800100, 0x007f0001, 0x007dff06, 0x0053561c,
  0x00800000, 0x007eff03, 0x005400aa, 0x003200e8,
  0x007fff00, 0x0054ab55, 0x00326732, 0x00007d20,
  0x00555600, 0x0032cd99, 0x00007e02, 0x00007c26,
  0x00333400, 0x00007f01, 0x00007d06, 0x00007b2c,
  0x00008000, 0x00007e03, 0x00007c0a, 0x00007a32,
};
const unsigned kExpectedCount_NEON_sqdmlal_4S = 576;

#endif  // VIXL_SIM_SQDMLAL_4S_TRACE_AARCH64_H_
