// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(cmp)                       \
  M(mov)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anomymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_T32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] =
    {{{eq, r0, r0}, true, eq, "eq r0 r0", "eq_r0_r0"},
     {{eq, r0, r1}, true, eq, "eq r0 r1", "eq_r0_r1"},
     {{eq, r0, r2}, true, eq, "eq r0 r2", "eq_r0_r2"},
     {{eq, r0, r3}, true, eq, "eq r0 r3", "eq_r0_r3"},
     {{eq, r0, r4}, true, eq, "eq r0 r4", "eq_r0_r4"},
     {{eq, r0, r5}, true, eq, "eq r0 r5", "eq_r0_r5"},
     {{eq, r0, r6}, true, eq, "eq r0 r6", "eq_r0_r6"},
     {{eq, r0, r7}, true, eq, "eq r0 r7", "eq_r0_r7"},
     {{eq, r0, r8}, true, eq, "eq r0 r8", "eq_r0_r8"},
     {{eq, r0, r9}, true, eq, "eq r0 r9", "eq_r0_r9"},
     {{eq, r0, r10}, true, eq, "eq r0 r10", "eq_r0_r10"},
     {{eq, r0, r11}, true, eq, "eq r0 r11", "eq_r0_r11"},
     {{eq, r0, r12}, true, eq, "eq r0 r12", "eq_r0_r12"},
     {{eq, r0, r13}, true, eq, "eq r0 r13", "eq_r0_r13"},
     {{eq, r0, r14}, true, eq, "eq r0 r14", "eq_r0_r14"},
     {{eq, r1, r0}, true, eq, "eq r1 r0", "eq_r1_r0"},
     {{eq, r1, r1}, true, eq, "eq r1 r1", "eq_r1_r1"},
     {{eq, r1, r2}, true, eq, "eq r1 r2", "eq_r1_r2"},
     {{eq, r1, r3}, true, eq, "eq r1 r3", "eq_r1_r3"},
     {{eq, r1, r4}, true, eq, "eq r1 r4", "eq_r1_r4"},
     {{eq, r1, r5}, true, eq, "eq r1 r5", "eq_r1_r5"},
     {{eq, r1, r6}, true, eq, "eq r1 r6", "eq_r1_r6"},
     {{eq, r1, r7}, true, eq, "eq r1 r7", "eq_r1_r7"},
     {{eq, r1, r8}, true, eq, "eq r1 r8", "eq_r1_r8"},
     {{eq, r1, r9}, true, eq, "eq r1 r9", "eq_r1_r9"},
     {{eq, r1, r10}, true, eq, "eq r1 r10", "eq_r1_r10"},
     {{eq, r1, r11}, true, eq, "eq r1 r11", "eq_r1_r11"},
     {{eq, r1, r12}, true, eq, "eq r1 r12", "eq_r1_r12"},
     {{eq, r1, r13}, true, eq, "eq r1 r13", "eq_r1_r13"},
     {{eq, r1, r14}, true, eq, "eq r1 r14", "eq_r1_r14"},
     {{eq, r2, r0}, true, eq, "eq r2 r0", "eq_r2_r0"},
     {{eq, r2, r1}, true, eq, "eq r2 r1", "eq_r2_r1"},
     {{eq, r2, r2}, true, eq, "eq r2 r2", "eq_r2_r2"},
     {{eq, r2, r3}, true, eq, "eq r2 r3", "eq_r2_r3"},
     {{eq, r2, r4}, true, eq, "eq r2 r4", "eq_r2_r4"},
     {{eq, r2, r5}, true, eq, "eq r2 r5", "eq_r2_r5"},
     {{eq, r2, r6}, true, eq, "eq r2 r6", "eq_r2_r6"},
     {{eq, r2, r7}, true, eq, "eq r2 r7", "eq_r2_r7"},
     {{eq, r2, r8}, true, eq, "eq r2 r8", "eq_r2_r8"},
     {{eq, r2, r9}, true, eq, "eq r2 r9", "eq_r2_r9"},
     {{eq, r2, r10}, true, eq, "eq r2 r10", "eq_r2_r10"},
     {{eq, r2, r11}, true, eq, "eq r2 r11", "eq_r2_r11"},
     {{eq, r2, r12}, true, eq, "eq r2 r12", "eq_r2_r12"},
     {{eq, r2, r13}, true, eq, "eq r2 r13", "eq_r2_r13"},
     {{eq, r2, r14}, true, eq, "eq r2 r14", "eq_r2_r14"},
     {{eq, r3, r0}, true, eq, "eq r3 r0", "eq_r3_r0"},
     {{eq, r3, r1}, true, eq, "eq r3 r1", "eq_r3_r1"},
     {{eq, r3, r2}, true, eq, "eq r3 r2", "eq_r3_r2"},
     {{eq, r3, r3}, true, eq, "eq r3 r3", "eq_r3_r3"},
     {{eq, r3, r4}, true, eq, "eq r3 r4", "eq_r3_r4"},
     {{eq, r3, r5}, true, eq, "eq r3 r5", "eq_r3_r5"},
     {{eq, r3, r6}, true, eq, "eq r3 r6", "eq_r3_r6"},
     {{eq, r3, r7}, true, eq, "eq r3 r7", "eq_r3_r7"},
     {{eq, r3, r8}, true, eq, "eq r3 r8", "eq_r3_r8"},
     {{eq, r3, r9}, true, eq, "eq r3 r9", "eq_r3_r9"},
     {{eq, r3, r10}, true, eq, "eq r3 r10", "eq_r3_r10"},
     {{eq, r3, r11}, true, eq, "eq r3 r11", "eq_r3_r11"},
     {{eq, r3, r12}, true, eq, "eq r3 r12", "eq_r3_r12"},
     {{eq, r3, r13}, true, eq, "eq r3 r13", "eq_r3_r13"},
     {{eq, r3, r14}, true, eq, "eq r3 r14", "eq_r3_r14"},
     {{eq, r4, r0}, true, eq, "eq r4 r0", "eq_r4_r0"},
     {{eq, r4, r1}, true, eq, "eq r4 r1", "eq_r4_r1"},
     {{eq, r4, r2}, true, eq, "eq r4 r2", "eq_r4_r2"},
     {{eq, r4, r3}, true, eq, "eq r4 r3", "eq_r4_r3"},
     {{eq, r4, r4}, true, eq, "eq r4 r4", "eq_r4_r4"},
     {{eq, r4, r5}, true, eq, "eq r4 r5", "eq_r4_r5"},
     {{eq, r4, r6}, true, eq, "eq r4 r6", "eq_r4_r6"},
     {{eq, r4, r7}, true, eq, "eq r4 r7", "eq_r4_r7"},
     {{eq, r4, r8}, true, eq, "eq r4 r8", "eq_r4_r8"},
     {{eq, r4, r9}, true, eq, "eq r4 r9", "eq_r4_r9"},
     {{eq, r4, r10}, true, eq, "eq r4 r10", "eq_r4_r10"},
     {{eq, r4, r11}, true, eq, "eq r4 r11", "eq_r4_r11"},
     {{eq, r4, r12}, true, eq, "eq r4 r12", "eq_r4_r12"},
     {{eq, r4, r13}, true, eq, "eq r4 r13", "eq_r4_r13"},
     {{eq, r4, r14}, true, eq, "eq r4 r14", "eq_r4_r14"},
     {{eq, r5, r0}, true, eq, "eq r5 r0", "eq_r5_r0"},
     {{eq, r5, r1}, true, eq, "eq r5 r1", "eq_r5_r1"},
     {{eq, r5, r2}, true, eq, "eq r5 r2", "eq_r5_r2"},
     {{eq, r5, r3}, true, eq, "eq r5 r3", "eq_r5_r3"},
     {{eq, r5, r4}, true, eq, "eq r5 r4", "eq_r5_r4"},
     {{eq, r5, r5}, true, eq, "eq r5 r5", "eq_r5_r5"},
     {{eq, r5, r6}, true, eq, "eq r5 r6", "eq_r5_r6"},
     {{eq, r5, r7}, true, eq, "eq r5 r7", "eq_r5_r7"},
     {{eq, r5, r8}, true, eq, "eq r5 r8", "eq_r5_r8"},
     {{eq, r5, r9}, true, eq, "eq r5 r9", "eq_r5_r9"},
     {{eq, r5, r10}, true, eq, "eq r5 r10", "eq_r5_r10"},
     {{eq, r5, r11}, true, eq, "eq r5 r11", "eq_r5_r11"},
     {{eq, r5, r12}, true, eq, "eq r5 r12", "eq_r5_r12"},
     {{eq, r5, r13}, true, eq, "eq r5 r13", "eq_r5_r13"},
     {{eq, r5, r14}, true, eq, "eq r5 r14", "eq_r5_r14"},
     {{eq, r6, r0}, true, eq, "eq r6 r0", "eq_r6_r0"},
     {{eq, r6, r1}, true, eq, "eq r6 r1", "eq_r6_r1"},
     {{eq, r6, r2}, true, eq, "eq r6 r2", "eq_r6_r2"},
     {{eq, r6, r3}, true, eq, "eq r6 r3", "eq_r6_r3"},
     {{eq, r6, r4}, true, eq, "eq r6 r4", "eq_r6_r4"},
     {{eq, r6, r5}, true, eq, "eq r6 r5", "eq_r6_r5"},
     {{eq, r6, r6}, true, eq, "eq r6 r6", "eq_r6_r6"},
     {{eq, r6, r7}, true, eq, "eq r6 r7", "eq_r6_r7"},
     {{eq, r6, r8}, true, eq, "eq r6 r8", "eq_r6_r8"},
     {{eq, r6, r9}, true, eq, "eq r6 r9", "eq_r6_r9"},
     {{eq, r6, r10}, true, eq, "eq r6 r10", "eq_r6_r10"},
     {{eq, r6, r11}, true, eq, "eq r6 r11", "eq_r6_r11"},
     {{eq, r6, r12}, true, eq, "eq r6 r12", "eq_r6_r12"},
     {{eq, r6, r13}, true, eq, "eq r6 r13", "eq_r6_r13"},
     {{eq, r6, r14}, true, eq, "eq r6 r14", "eq_r6_r14"},
     {{eq, r7, r0}, true, eq, "eq r7 r0", "eq_r7_r0"},
     {{eq, r7, r1}, true, eq, "eq r7 r1", "eq_r7_r1"},
     {{eq, r7, r2}, true, eq, "eq r7 r2", "eq_r7_r2"},
     {{eq, r7, r3}, true, eq, "eq r7 r3", "eq_r7_r3"},
     {{eq, r7, r4}, true, eq, "eq r7 r4", "eq_r7_r4"},
     {{eq, r7, r5}, true, eq, "eq r7 r5", "eq_r7_r5"},
     {{eq, r7, r6}, true, eq, "eq r7 r6", "eq_r7_r6"},
     {{eq, r7, r7}, true, eq, "eq r7 r7", "eq_r7_r7"},
     {{eq, r7, r8}, true, eq, "eq r7 r8", "eq_r7_r8"},
     {{eq, r7, r9}, true, eq, "eq r7 r9", "eq_r7_r9"},
     {{eq, r7, r10}, true, eq, "eq r7 r10", "eq_r7_r10"},
     {{eq, r7, r11}, true, eq, "eq r7 r11", "eq_r7_r11"},
     {{eq, r7, r12}, true, eq, "eq r7 r12", "eq_r7_r12"},
     {{eq, r7, r13}, true, eq, "eq r7 r13", "eq_r7_r13"},
     {{eq, r7, r14}, true, eq, "eq r7 r14", "eq_r7_r14"},
     {{eq, r8, r0}, true, eq, "eq r8 r0", "eq_r8_r0"},
     {{eq, r8, r1}, true, eq, "eq r8 r1", "eq_r8_r1"},
     {{eq, r8, r2}, true, eq, "eq r8 r2", "eq_r8_r2"},
     {{eq, r8, r3}, true, eq, "eq r8 r3", "eq_r8_r3"},
     {{eq, r8, r4}, true, eq, "eq r8 r4", "eq_r8_r4"},
     {{eq, r8, r5}, true, eq, "eq r8 r5", "eq_r8_r5"},
     {{eq, r8, r6}, true, eq, "eq r8 r6", "eq_r8_r6"},
     {{eq, r8, r7}, true, eq, "eq r8 r7", "eq_r8_r7"},
     {{eq, r8, r8}, true, eq, "eq r8 r8", "eq_r8_r8"},
     {{eq, r8, r9}, true, eq, "eq r8 r9", "eq_r8_r9"},
     {{eq, r8, r10}, true, eq, "eq r8 r10", "eq_r8_r10"},
     {{eq, r8, r11}, true, eq, "eq r8 r11", "eq_r8_r11"},
     {{eq, r8, r12}, true, eq, "eq r8 r12", "eq_r8_r12"},
     {{eq, r8, r13}, true, eq, "eq r8 r13", "eq_r8_r13"},
     {{eq, r8, r14}, true, eq, "eq r8 r14", "eq_r8_r14"},
     {{eq, r9, r0}, true, eq, "eq r9 r0", "eq_r9_r0"},
     {{eq, r9, r1}, true, eq, "eq r9 r1", "eq_r9_r1"},
     {{eq, r9, r2}, true, eq, "eq r9 r2", "eq_r9_r2"},
     {{eq, r9, r3}, true, eq, "eq r9 r3", "eq_r9_r3"},
     {{eq, r9, r4}, true, eq, "eq r9 r4", "eq_r9_r4"},
     {{eq, r9, r5}, true, eq, "eq r9 r5", "eq_r9_r5"},
     {{eq, r9, r6}, true, eq, "eq r9 r6", "eq_r9_r6"},
     {{eq, r9, r7}, true, eq, "eq r9 r7", "eq_r9_r7"},
     {{eq, r9, r8}, true, eq, "eq r9 r8", "eq_r9_r8"},
     {{eq, r9, r9}, true, eq, "eq r9 r9", "eq_r9_r9"},
     {{eq, r9, r10}, true, eq, "eq r9 r10", "eq_r9_r10"},
     {{eq, r9, r11}, true, eq, "eq r9 r11", "eq_r9_r11"},
     {{eq, r9, r12}, true, eq, "eq r9 r12", "eq_r9_r12"},
     {{eq, r9, r13}, true, eq, "eq r9 r13", "eq_r9_r13"},
     {{eq, r9, r14}, true, eq, "eq r9 r14", "eq_r9_r14"},
     {{eq, r10, r0}, true, eq, "eq r10 r0", "eq_r10_r0"},
     {{eq, r10, r1}, true, eq, "eq r10 r1", "eq_r10_r1"},
     {{eq, r10, r2}, true, eq, "eq r10 r2", "eq_r10_r2"},
     {{eq, r10, r3}, true, eq, "eq r10 r3", "eq_r10_r3"},
     {{eq, r10, r4}, true, eq, "eq r10 r4", "eq_r10_r4"},
     {{eq, r10, r5}, true, eq, "eq r10 r5", "eq_r10_r5"},
     {{eq, r10, r6}, true, eq, "eq r10 r6", "eq_r10_r6"},
     {{eq, r10, r7}, true, eq, "eq r10 r7", "eq_r10_r7"},
     {{eq, r10, r8}, true, eq, "eq r10 r8", "eq_r10_r8"},
     {{eq, r10, r9}, true, eq, "eq r10 r9", "eq_r10_r9"},
     {{eq, r10, r10}, true, eq, "eq r10 r10", "eq_r10_r10"},
     {{eq, r10, r11}, true, eq, "eq r10 r11", "eq_r10_r11"},
     {{eq, r10, r12}, true, eq, "eq r10 r12", "eq_r10_r12"},
     {{eq, r10, r13}, true, eq, "eq r10 r13", "eq_r10_r13"},
     {{eq, r10, r14}, true, eq, "eq r10 r14", "eq_r10_r14"},
     {{eq, r11, r0}, true, eq, "eq r11 r0", "eq_r11_r0"},
     {{eq, r11, r1}, true, eq, "eq r11 r1", "eq_r11_r1"},
     {{eq, r11, r2}, true, eq, "eq r11 r2", "eq_r11_r2"},
     {{eq, r11, r3}, true, eq, "eq r11 r3", "eq_r11_r3"},
     {{eq, r11, r4}, true, eq, "eq r11 r4", "eq_r11_r4"},
     {{eq, r11, r5}, true, eq, "eq r11 r5", "eq_r11_r5"},
     {{eq, r11, r6}, true, eq, "eq r11 r6", "eq_r11_r6"},
     {{eq, r11, r7}, true, eq, "eq r11 r7", "eq_r11_r7"},
     {{eq, r11, r8}, true, eq, "eq r11 r8", "eq_r11_r8"},
     {{eq, r11, r9}, true, eq, "eq r11 r9", "eq_r11_r9"},
     {{eq, r11, r10}, true, eq, "eq r11 r10", "eq_r11_r10"},
     {{eq, r11, r11}, true, eq, "eq r11 r11", "eq_r11_r11"},
     {{eq, r11, r12}, true, eq, "eq r11 r12", "eq_r11_r12"},
     {{eq, r11, r13}, true, eq, "eq r11 r13", "eq_r11_r13"},
     {{eq, r11, r14}, true, eq, "eq r11 r14", "eq_r11_r14"},
     {{eq, r12, r0}, true, eq, "eq r12 r0", "eq_r12_r0"},
     {{eq, r12, r1}, true, eq, "eq r12 r1", "eq_r12_r1"},
     {{eq, r12, r2}, true, eq, "eq r12 r2", "eq_r12_r2"},
     {{eq, r12, r3}, true, eq, "eq r12 r3", "eq_r12_r3"},
     {{eq, r12, r4}, true, eq, "eq r12 r4", "eq_r12_r4"},
     {{eq, r12, r5}, true, eq, "eq r12 r5", "eq_r12_r5"},
     {{eq, r12, r6}, true, eq, "eq r12 r6", "eq_r12_r6"},
     {{eq, r12, r7}, true, eq, "eq r12 r7", "eq_r12_r7"},
     {{eq, r12, r8}, true, eq, "eq r12 r8", "eq_r12_r8"},
     {{eq, r12, r9}, true, eq, "eq r12 r9", "eq_r12_r9"},
     {{eq, r12, r10}, true, eq, "eq r12 r10", "eq_r12_r10"},
     {{eq, r12, r11}, true, eq, "eq r12 r11", "eq_r12_r11"},
     {{eq, r12, r12}, true, eq, "eq r12 r12", "eq_r12_r12"},
     {{eq, r12, r13}, true, eq, "eq r12 r13", "eq_r12_r13"},
     {{eq, r12, r14}, true, eq, "eq r12 r14", "eq_r12_r14"},
     {{eq, r13, r0}, true, eq, "eq r13 r0", "eq_r13_r0"},
     {{eq, r13, r1}, true, eq, "eq r13 r1", "eq_r13_r1"},
     {{eq, r13, r2}, true, eq, "eq r13 r2", "eq_r13_r2"},
     {{eq, r13, r3}, true, eq, "eq r13 r3", "eq_r13_r3"},
     {{eq, r13, r4}, true, eq, "eq r13 r4", "eq_r13_r4"},
     {{eq, r13, r5}, true, eq, "eq r13 r5", "eq_r13_r5"},
     {{eq, r13, r6}, true, eq, "eq r13 r6", "eq_r13_r6"},
     {{eq, r13, r7}, true, eq, "eq r13 r7", "eq_r13_r7"},
     {{eq, r13, r8}, true, eq, "eq r13 r8", "eq_r13_r8"},
     {{eq, r13, r9}, true, eq, "eq r13 r9", "eq_r13_r9"},
     {{eq, r13, r10}, true, eq, "eq r13 r10", "eq_r13_r10"},
     {{eq, r13, r11}, true, eq, "eq r13 r11", "eq_r13_r11"},
     {{eq, r13, r12}, true, eq, "eq r13 r12", "eq_r13_r12"},
     {{eq, r13, r13}, true, eq, "eq r13 r13", "eq_r13_r13"},
     {{eq, r13, r14}, true, eq, "eq r13 r14", "eq_r13_r14"},
     {{eq, r14, r0}, true, eq, "eq r14 r0", "eq_r14_r0"},
     {{eq, r14, r1}, true, eq, "eq r14 r1", "eq_r14_r1"},
     {{eq, r14, r2}, true, eq, "eq r14 r2", "eq_r14_r2"},
     {{eq, r14, r3}, true, eq, "eq r14 r3", "eq_r14_r3"},
     {{eq, r14, r4}, true, eq, "eq r14 r4", "eq_r14_r4"},
     {{eq, r14, r5}, true, eq, "eq r14 r5", "eq_r14_r5"},
     {{eq, r14, r6}, true, eq, "eq r14 r6", "eq_r14_r6"},
     {{eq, r14, r7}, true, eq, "eq r14 r7", "eq_r14_r7"},
     {{eq, r14, r8}, true, eq, "eq r14 r8", "eq_r14_r8"},
     {{eq, r14, r9}, true, eq, "eq r14 r9", "eq_r14_r9"},
     {{eq, r14, r10}, true, eq, "eq r14 r10", "eq_r14_r10"},
     {{eq, r14, r11}, true, eq, "eq r14 r11", "eq_r14_r11"},
     {{eq, r14, r12}, true, eq, "eq r14 r12", "eq_r14_r12"},
     {{eq, r14, r13}, true, eq, "eq r14 r13", "eq_r14_r13"},
     {{eq, r14, r14}, true, eq, "eq r14 r14", "eq_r14_r14"},
     {{ne, r0, r0}, true, ne, "ne r0 r0", "ne_r0_r0"},
     {{ne, r0, r1}, true, ne, "ne r0 r1", "ne_r0_r1"},
     {{ne, r0, r2}, true, ne, "ne r0 r2", "ne_r0_r2"},
     {{ne, r0, r3}, true, ne, "ne r0 r3", "ne_r0_r3"},
     {{ne, r0, r4}, true, ne, "ne r0 r4", "ne_r0_r4"},
     {{ne, r0, r5}, true, ne, "ne r0 r5", "ne_r0_r5"},
     {{ne, r0, r6}, true, ne, "ne r0 r6", "ne_r0_r6"},
     {{ne, r0, r7}, true, ne, "ne r0 r7", "ne_r0_r7"},
     {{ne, r0, r8}, true, ne, "ne r0 r8", "ne_r0_r8"},
     {{ne, r0, r9}, true, ne, "ne r0 r9", "ne_r0_r9"},
     {{ne, r0, r10}, true, ne, "ne r0 r10", "ne_r0_r10"},
     {{ne, r0, r11}, true, ne, "ne r0 r11", "ne_r0_r11"},
     {{ne, r0, r12}, true, ne, "ne r0 r12", "ne_r0_r12"},
     {{ne, r0, r13}, true, ne, "ne r0 r13", "ne_r0_r13"},
     {{ne, r0, r14}, true, ne, "ne r0 r14", "ne_r0_r14"},
     {{ne, r1, r0}, true, ne, "ne r1 r0", "ne_r1_r0"},
     {{ne, r1, r1}, true, ne, "ne r1 r1", "ne_r1_r1"},
     {{ne, r1, r2}, true, ne, "ne r1 r2", "ne_r1_r2"},
     {{ne, r1, r3}, true, ne, "ne r1 r3", "ne_r1_r3"},
     {{ne, r1, r4}, true, ne, "ne r1 r4", "ne_r1_r4"},
     {{ne, r1, r5}, true, ne, "ne r1 r5", "ne_r1_r5"},
     {{ne, r1, r6}, true, ne, "ne r1 r6", "ne_r1_r6"},
     {{ne, r1, r7}, true, ne, "ne r1 r7", "ne_r1_r7"},
     {{ne, r1, r8}, true, ne, "ne r1 r8", "ne_r1_r8"},
     {{ne, r1, r9}, true, ne, "ne r1 r9", "ne_r1_r9"},
     {{ne, r1, r10}, true, ne, "ne r1 r10", "ne_r1_r10"},
     {{ne, r1, r11}, true, ne, "ne r1 r11", "ne_r1_r11"},
     {{ne, r1, r12}, true, ne, "ne r1 r12", "ne_r1_r12"},
     {{ne, r1, r13}, true, ne, "ne r1 r13", "ne_r1_r13"},
     {{ne, r1, r14}, true, ne, "ne r1 r14", "ne_r1_r14"},
     {{ne, r2, r0}, true, ne, "ne r2 r0", "ne_r2_r0"},
     {{ne, r2, r1}, true, ne, "ne r2 r1", "ne_r2_r1"},
     {{ne, r2, r2}, true, ne, "ne r2 r2", "ne_r2_r2"},
     {{ne, r2, r3}, true, ne, "ne r2 r3", "ne_r2_r3"},
     {{ne, r2, r4}, true, ne, "ne r2 r4", "ne_r2_r4"},
     {{ne, r2, r5}, true, ne, "ne r2 r5", "ne_r2_r5"},
     {{ne, r2, r6}, true, ne, "ne r2 r6", "ne_r2_r6"},
     {{ne, r2, r7}, true, ne, "ne r2 r7", "ne_r2_r7"},
     {{ne, r2, r8}, true, ne, "ne r2 r8", "ne_r2_r8"},
     {{ne, r2, r9}, true, ne, "ne r2 r9", "ne_r2_r9"},
     {{ne, r2, r10}, true, ne, "ne r2 r10", "ne_r2_r10"},
     {{ne, r2, r11}, true, ne, "ne r2 r11", "ne_r2_r11"},
     {{ne, r2, r12}, true, ne, "ne r2 r12", "ne_r2_r12"},
     {{ne, r2, r13}, true, ne, "ne r2 r13", "ne_r2_r13"},
     {{ne, r2, r14}, true, ne, "ne r2 r14", "ne_r2_r14"},
     {{ne, r3, r0}, true, ne, "ne r3 r0", "ne_r3_r0"},
     {{ne, r3, r1}, true, ne, "ne r3 r1", "ne_r3_r1"},
     {{ne, r3, r2}, true, ne, "ne r3 r2", "ne_r3_r2"},
     {{ne, r3, r3}, true, ne, "ne r3 r3", "ne_r3_r3"},
     {{ne, r3, r4}, true, ne, "ne r3 r4", "ne_r3_r4"},
     {{ne, r3, r5}, true, ne, "ne r3 r5", "ne_r3_r5"},
     {{ne, r3, r6}, true, ne, "ne r3 r6", "ne_r3_r6"},
     {{ne, r3, r7}, true, ne, "ne r3 r7", "ne_r3_r7"},
     {{ne, r3, r8}, true, ne, "ne r3 r8", "ne_r3_r8"},
     {{ne, r3, r9}, true, ne, "ne r3 r9", "ne_r3_r9"},
     {{ne, r3, r10}, true, ne, "ne r3 r10", "ne_r3_r10"},
     {{ne, r3, r11}, true, ne, "ne r3 r11", "ne_r3_r11"},
     {{ne, r3, r12}, true, ne, "ne r3 r12", "ne_r3_r12"},
     {{ne, r3, r13}, true, ne, "ne r3 r13", "ne_r3_r13"},
     {{ne, r3, r14}, true, ne, "ne r3 r14", "ne_r3_r14"},
     {{ne, r4, r0}, true, ne, "ne r4 r0", "ne_r4_r0"},
     {{ne, r4, r1}, true, ne, "ne r4 r1", "ne_r4_r1"},
     {{ne, r4, r2}, true, ne, "ne r4 r2", "ne_r4_r2"},
     {{ne, r4, r3}, true, ne, "ne r4 r3", "ne_r4_r3"},
     {{ne, r4, r4}, true, ne, "ne r4 r4", "ne_r4_r4"},
     {{ne, r4, r5}, true, ne, "ne r4 r5", "ne_r4_r5"},
     {{ne, r4, r6}, true, ne, "ne r4 r6", "ne_r4_r6"},
     {{ne, r4, r7}, true, ne, "ne r4 r7", "ne_r4_r7"},
     {{ne, r4, r8}, true, ne, "ne r4 r8", "ne_r4_r8"},
     {{ne, r4, r9}, true, ne, "ne r4 r9", "ne_r4_r9"},
     {{ne, r4, r10}, true, ne, "ne r4 r10", "ne_r4_r10"},
     {{ne, r4, r11}, true, ne, "ne r4 r11", "ne_r4_r11"},
     {{ne, r4, r12}, true, ne, "ne r4 r12", "ne_r4_r12"},
     {{ne, r4, r13}, true, ne, "ne r4 r13", "ne_r4_r13"},
     {{ne, r4, r14}, true, ne, "ne r4 r14", "ne_r4_r14"},
     {{ne, r5, r0}, true, ne, "ne r5 r0", "ne_r5_r0"},
     {{ne, r5, r1}, true, ne, "ne r5 r1", "ne_r5_r1"},
     {{ne, r5, r2}, true, ne, "ne r5 r2", "ne_r5_r2"},
     {{ne, r5, r3}, true, ne, "ne r5 r3", "ne_r5_r3"},
     {{ne, r5, r4}, true, ne, "ne r5 r4", "ne_r5_r4"},
     {{ne, r5, r5}, true, ne, "ne r5 r5", "ne_r5_r5"},
     {{ne, r5, r6}, true, ne, "ne r5 r6", "ne_r5_r6"},
     {{ne, r5, r7}, true, ne, "ne r5 r7", "ne_r5_r7"},
     {{ne, r5, r8}, true, ne, "ne r5 r8", "ne_r5_r8"},
     {{ne, r5, r9}, true, ne, "ne r5 r9", "ne_r5_r9"},
     {{ne, r5, r10}, true, ne, "ne r5 r10", "ne_r5_r10"},
     {{ne, r5, r11}, true, ne, "ne r5 r11", "ne_r5_r11"},
     {{ne, r5, r12}, true, ne, "ne r5 r12", "ne_r5_r12"},
     {{ne, r5, r13}, true, ne, "ne r5 r13", "ne_r5_r13"},
     {{ne, r5, r14}, true, ne, "ne r5 r14", "ne_r5_r14"},
     {{ne, r6, r0}, true, ne, "ne r6 r0", "ne_r6_r0"},
     {{ne, r6, r1}, true, ne, "ne r6 r1", "ne_r6_r1"},
     {{ne, r6, r2}, true, ne, "ne r6 r2", "ne_r6_r2"},
     {{ne, r6, r3}, true, ne, "ne r6 r3", "ne_r6_r3"},
     {{ne, r6, r4}, true, ne, "ne r6 r4", "ne_r6_r4"},
     {{ne, r6, r5}, true, ne, "ne r6 r5", "ne_r6_r5"},
     {{ne, r6, r6}, true, ne, "ne r6 r6", "ne_r6_r6"},
     {{ne, r6, r7}, true, ne, "ne r6 r7", "ne_r6_r7"},
     {{ne, r6, r8}, true, ne, "ne r6 r8", "ne_r6_r8"},
     {{ne, r6, r9}, true, ne, "ne r6 r9", "ne_r6_r9"},
     {{ne, r6, r10}, true, ne, "ne r6 r10", "ne_r6_r10"},
     {{ne, r6, r11}, true, ne, "ne r6 r11", "ne_r6_r11"},
     {{ne, r6, r12}, true, ne, "ne r6 r12", "ne_r6_r12"},
     {{ne, r6, r13}, true, ne, "ne r6 r13", "ne_r6_r13"},
     {{ne, r6, r14}, true, ne, "ne r6 r14", "ne_r6_r14"},
     {{ne, r7, r0}, true, ne, "ne r7 r0", "ne_r7_r0"},
     {{ne, r7, r1}, true, ne, "ne r7 r1", "ne_r7_r1"},
     {{ne, r7, r2}, true, ne, "ne r7 r2", "ne_r7_r2"},
     {{ne, r7, r3}, true, ne, "ne r7 r3", "ne_r7_r3"},
     {{ne, r7, r4}, true, ne, "ne r7 r4", "ne_r7_r4"},
     {{ne, r7, r5}, true, ne, "ne r7 r5", "ne_r7_r5"},
     {{ne, r7, r6}, true, ne, "ne r7 r6", "ne_r7_r6"},
     {{ne, r7, r7}, true, ne, "ne r7 r7", "ne_r7_r7"},
     {{ne, r7, r8}, true, ne, "ne r7 r8", "ne_r7_r8"},
     {{ne, r7, r9}, true, ne, "ne r7 r9", "ne_r7_r9"},
     {{ne, r7, r10}, true, ne, "ne r7 r10", "ne_r7_r10"},
     {{ne, r7, r11}, true, ne, "ne r7 r11", "ne_r7_r11"},
     {{ne, r7, r12}, true, ne, "ne r7 r12", "ne_r7_r12"},
     {{ne, r7, r13}, true, ne, "ne r7 r13", "ne_r7_r13"},
     {{ne, r7, r14}, true, ne, "ne r7 r14", "ne_r7_r14"},
     {{ne, r8, r0}, true, ne, "ne r8 r0", "ne_r8_r0"},
     {{ne, r8, r1}, true, ne, "ne r8 r1", "ne_r8_r1"},
     {{ne, r8, r2}, true, ne, "ne r8 r2", "ne_r8_r2"},
     {{ne, r8, r3}, true, ne, "ne r8 r3", "ne_r8_r3"},
     {{ne, r8, r4}, true, ne, "ne r8 r4", "ne_r8_r4"},
     {{ne, r8, r5}, true, ne, "ne r8 r5", "ne_r8_r5"},
     {{ne, r8, r6}, true, ne, "ne r8 r6", "ne_r8_r6"},
     {{ne, r8, r7}, true, ne, "ne r8 r7", "ne_r8_r7"},
     {{ne, r8, r8}, true, ne, "ne r8 r8", "ne_r8_r8"},
     {{ne, r8, r9}, true, ne, "ne r8 r9", "ne_r8_r9"},
     {{ne, r8, r10}, true, ne, "ne r8 r10", "ne_r8_r10"},
     {{ne, r8, r11}, true, ne, "ne r8 r11", "ne_r8_r11"},
     {{ne, r8, r12}, true, ne, "ne r8 r12", "ne_r8_r12"},
     {{ne, r8, r13}, true, ne, "ne r8 r13", "ne_r8_r13"},
     {{ne, r8, r14}, true, ne, "ne r8 r14", "ne_r8_r14"},
     {{ne, r9, r0}, true, ne, "ne r9 r0", "ne_r9_r0"},
     {{ne, r9, r1}, true, ne, "ne r9 r1", "ne_r9_r1"},
     {{ne, r9, r2}, true, ne, "ne r9 r2", "ne_r9_r2"},
     {{ne, r9, r3}, true, ne, "ne r9 r3", "ne_r9_r3"},
     {{ne, r9, r4}, true, ne, "ne r9 r4", "ne_r9_r4"},
     {{ne, r9, r5}, true, ne, "ne r9 r5", "ne_r9_r5"},
     {{ne, r9, r6}, true, ne, "ne r9 r6", "ne_r9_r6"},
     {{ne, r9, r7}, true, ne, "ne r9 r7", "ne_r9_r7"},
     {{ne, r9, r8}, true, ne, "ne r9 r8", "ne_r9_r8"},
     {{ne, r9, r9}, true, ne, "ne r9 r9", "ne_r9_r9"},
     {{ne, r9, r10}, true, ne, "ne r9 r10", "ne_r9_r10"},
     {{ne, r9, r11}, true, ne, "ne r9 r11", "ne_r9_r11"},
     {{ne, r9, r12}, true, ne, "ne r9 r12", "ne_r9_r12"},
     {{ne, r9, r13}, true, ne, "ne r9 r13", "ne_r9_r13"},
     {{ne, r9, r14}, true, ne, "ne r9 r14", "ne_r9_r14"},
     {{ne, r10, r0}, true, ne, "ne r10 r0", "ne_r10_r0"},
     {{ne, r10, r1}, true, ne, "ne r10 r1", "ne_r10_r1"},
     {{ne, r10, r2}, true, ne, "ne r10 r2", "ne_r10_r2"},
     {{ne, r10, r3}, true, ne, "ne r10 r3", "ne_r10_r3"},
     {{ne, r10, r4}, true, ne, "ne r10 r4", "ne_r10_r4"},
     {{ne, r10, r5}, true, ne, "ne r10 r5", "ne_r10_r5"},
     {{ne, r10, r6}, true, ne, "ne r10 r6", "ne_r10_r6"},
     {{ne, r10, r7}, true, ne, "ne r10 r7", "ne_r10_r7"},
     {{ne, r10, r8}, true, ne, "ne r10 r8", "ne_r10_r8"},
     {{ne, r10, r9}, true, ne, "ne r10 r9", "ne_r10_r9"},
     {{ne, r10, r10}, true, ne, "ne r10 r10", "ne_r10_r10"},
     {{ne, r10, r11}, true, ne, "ne r10 r11", "ne_r10_r11"},
     {{ne, r10, r12}, true, ne, "ne r10 r12", "ne_r10_r12"},
     {{ne, r10, r13}, true, ne, "ne r10 r13", "ne_r10_r13"},
     {{ne, r10, r14}, true, ne, "ne r10 r14", "ne_r10_r14"},
     {{ne, r11, r0}, true, ne, "ne r11 r0", "ne_r11_r0"},
     {{ne, r11, r1}, true, ne, "ne r11 r1", "ne_r11_r1"},
     {{ne, r11, r2}, true, ne, "ne r11 r2", "ne_r11_r2"},
     {{ne, r11, r3}, true, ne, "ne r11 r3", "ne_r11_r3"},
     {{ne, r11, r4}, true, ne, "ne r11 r4", "ne_r11_r4"},
     {{ne, r11, r5}, true, ne, "ne r11 r5", "ne_r11_r5"},
     {{ne, r11, r6}, true, ne, "ne r11 r6", "ne_r11_r6"},
     {{ne, r11, r7}, true, ne, "ne r11 r7", "ne_r11_r7"},
     {{ne, r11, r8}, true, ne, "ne r11 r8", "ne_r11_r8"},
     {{ne, r11, r9}, true, ne, "ne r11 r9", "ne_r11_r9"},
     {{ne, r11, r10}, true, ne, "ne r11 r10", "ne_r11_r10"},
     {{ne, r11, r11}, true, ne, "ne r11 r11", "ne_r11_r11"},
     {{ne, r11, r12}, true, ne, "ne r11 r12", "ne_r11_r12"},
     {{ne, r11, r13}, true, ne, "ne r11 r13", "ne_r11_r13"},
     {{ne, r11, r14}, true, ne, "ne r11 r14", "ne_r11_r14"},
     {{ne, r12, r0}, true, ne, "ne r12 r0", "ne_r12_r0"},
     {{ne, r12, r1}, true, ne, "ne r12 r1", "ne_r12_r1"},
     {{ne, r12, r2}, true, ne, "ne r12 r2", "ne_r12_r2"},
     {{ne, r12, r3}, true, ne, "ne r12 r3", "ne_r12_r3"},
     {{ne, r12, r4}, true, ne, "ne r12 r4", "ne_r12_r4"},
     {{ne, r12, r5}, true, ne, "ne r12 r5", "ne_r12_r5"},
     {{ne, r12, r6}, true, ne, "ne r12 r6", "ne_r12_r6"},
     {{ne, r12, r7}, true, ne, "ne r12 r7", "ne_r12_r7"},
     {{ne, r12, r8}, true, ne, "ne r12 r8", "ne_r12_r8"},
     {{ne, r12, r9}, true, ne, "ne r12 r9", "ne_r12_r9"},
     {{ne, r12, r10}, true, ne, "ne r12 r10", "ne_r12_r10"},
     {{ne, r12, r11}, true, ne, "ne r12 r11", "ne_r12_r11"},
     {{ne, r12, r12}, true, ne, "ne r12 r12", "ne_r12_r12"},
     {{ne, r12, r13}, true, ne, "ne r12 r13", "ne_r12_r13"},
     {{ne, r12, r14}, true, ne, "ne r12 r14", "ne_r12_r14"},
     {{ne, r13, r0}, true, ne, "ne r13 r0", "ne_r13_r0"},
     {{ne, r13, r1}, true, ne, "ne r13 r1", "ne_r13_r1"},
     {{ne, r13, r2}, true, ne, "ne r13 r2", "ne_r13_r2"},
     {{ne, r13, r3}, true, ne, "ne r13 r3", "ne_r13_r3"},
     {{ne, r13, r4}, true, ne, "ne r13 r4", "ne_r13_r4"},
     {{ne, r13, r5}, true, ne, "ne r13 r5", "ne_r13_r5"},
     {{ne, r13, r6}, true, ne, "ne r13 r6", "ne_r13_r6"},
     {{ne, r13, r7}, true, ne, "ne r13 r7", "ne_r13_r7"},
     {{ne, r13, r8}, true, ne, "ne r13 r8", "ne_r13_r8"},
     {{ne, r13, r9}, true, ne, "ne r13 r9", "ne_r13_r9"},
     {{ne, r13, r10}, true, ne, "ne r13 r10", "ne_r13_r10"},
     {{ne, r13, r11}, true, ne, "ne r13 r11", "ne_r13_r11"},
     {{ne, r13, r12}, true, ne, "ne r13 r12", "ne_r13_r12"},
     {{ne, r13, r13}, true, ne, "ne r13 r13", "ne_r13_r13"},
     {{ne, r13, r14}, true, ne, "ne r13 r14", "ne_r13_r14"},
     {{ne, r14, r0}, true, ne, "ne r14 r0", "ne_r14_r0"},
     {{ne, r14, r1}, true, ne, "ne r14 r1", "ne_r14_r1"},
     {{ne, r14, r2}, true, ne, "ne r14 r2", "ne_r14_r2"},
     {{ne, r14, r3}, true, ne, "ne r14 r3", "ne_r14_r3"},
     {{ne, r14, r4}, true, ne, "ne r14 r4", "ne_r14_r4"},
     {{ne, r14, r5}, true, ne, "ne r14 r5", "ne_r14_r5"},
     {{ne, r14, r6}, true, ne, "ne r14 r6", "ne_r14_r6"},
     {{ne, r14, r7}, true, ne, "ne r14 r7", "ne_r14_r7"},
     {{ne, r14, r8}, true, ne, "ne r14 r8", "ne_r14_r8"},
     {{ne, r14, r9}, true, ne, "ne r14 r9", "ne_r14_r9"},
     {{ne, r14, r10}, true, ne, "ne r14 r10", "ne_r14_r10"},
     {{ne, r14, r11}, true, ne, "ne r14 r11", "ne_r14_r11"},
     {{ne, r14, r12}, true, ne, "ne r14 r12", "ne_r14_r12"},
     {{ne, r14, r13}, true, ne, "ne r14 r13", "ne_r14_r13"},
     {{ne, r14, r14}, true, ne, "ne r14 r14", "ne_r14_r14"},
     {{cs, r0, r0}, true, cs, "cs r0 r0", "cs_r0_r0"},
     {{cs, r0, r1}, true, cs, "cs r0 r1", "cs_r0_r1"},
     {{cs, r0, r2}, true, cs, "cs r0 r2", "cs_r0_r2"},
     {{cs, r0, r3}, true, cs, "cs r0 r3", "cs_r0_r3"},
     {{cs, r0, r4}, true, cs, "cs r0 r4", "cs_r0_r4"},
     {{cs, r0, r5}, true, cs, "cs r0 r5", "cs_r0_r5"},
     {{cs, r0, r6}, true, cs, "cs r0 r6", "cs_r0_r6"},
     {{cs, r0, r7}, true, cs, "cs r0 r7", "cs_r0_r7"},
     {{cs, r0, r8}, true, cs, "cs r0 r8", "cs_r0_r8"},
     {{cs, r0, r9}, true, cs, "cs r0 r9", "cs_r0_r9"},
     {{cs, r0, r10}, true, cs, "cs r0 r10", "cs_r0_r10"},
     {{cs, r0, r11}, true, cs, "cs r0 r11", "cs_r0_r11"},
     {{cs, r0, r12}, true, cs, "cs r0 r12", "cs_r0_r12"},
     {{cs, r0, r13}, true, cs, "cs r0 r13", "cs_r0_r13"},
     {{cs, r0, r14}, true, cs, "cs r0 r14", "cs_r0_r14"},
     {{cs, r1, r0}, true, cs, "cs r1 r0", "cs_r1_r0"},
     {{cs, r1, r1}, true, cs, "cs r1 r1", "cs_r1_r1"},
     {{cs, r1, r2}, true, cs, "cs r1 r2", "cs_r1_r2"},
     {{cs, r1, r3}, true, cs, "cs r1 r3", "cs_r1_r3"},
     {{cs, r1, r4}, true, cs, "cs r1 r4", "cs_r1_r4"},
     {{cs, r1, r5}, true, cs, "cs r1 r5", "cs_r1_r5"},
     {{cs, r1, r6}, true, cs, "cs r1 r6", "cs_r1_r6"},
     {{cs, r1, r7}, true, cs, "cs r1 r7", "cs_r1_r7"},
     {{cs, r1, r8}, true, cs, "cs r1 r8", "cs_r1_r8"},
     {{cs, r1, r9}, true, cs, "cs r1 r9", "cs_r1_r9"},
     {{cs, r1, r10}, true, cs, "cs r1 r10", "cs_r1_r10"},
     {{cs, r1, r11}, true, cs, "cs r1 r11", "cs_r1_r11"},
     {{cs, r1, r12}, true, cs, "cs r1 r12", "cs_r1_r12"},
     {{cs, r1, r13}, true, cs, "cs r1 r13", "cs_r1_r13"},
     {{cs, r1, r14}, true, cs, "cs r1 r14", "cs_r1_r14"},
     {{cs, r2, r0}, true, cs, "cs r2 r0", "cs_r2_r0"},
     {{cs, r2, r1}, true, cs, "cs r2 r1", "cs_r2_r1"},
     {{cs, r2, r2}, true, cs, "cs r2 r2", "cs_r2_r2"},
     {{cs, r2, r3}, true, cs, "cs r2 r3", "cs_r2_r3"},
     {{cs, r2, r4}, true, cs, "cs r2 r4", "cs_r2_r4"},
     {{cs, r2, r5}, true, cs, "cs r2 r5", "cs_r2_r5"},
     {{cs, r2, r6}, true, cs, "cs r2 r6", "cs_r2_r6"},
     {{cs, r2, r7}, true, cs, "cs r2 r7", "cs_r2_r7"},
     {{cs, r2, r8}, true, cs, "cs r2 r8", "cs_r2_r8"},
     {{cs, r2, r9}, true, cs, "cs r2 r9", "cs_r2_r9"},
     {{cs, r2, r10}, true, cs, "cs r2 r10", "cs_r2_r10"},
     {{cs, r2, r11}, true, cs, "cs r2 r11", "cs_r2_r11"},
     {{cs, r2, r12}, true, cs, "cs r2 r12", "cs_r2_r12"},
     {{cs, r2, r13}, true, cs, "cs r2 r13", "cs_r2_r13"},
     {{cs, r2, r14}, true, cs, "cs r2 r14", "cs_r2_r14"},
     {{cs, r3, r0}, true, cs, "cs r3 r0", "cs_r3_r0"},
     {{cs, r3, r1}, true, cs, "cs r3 r1", "cs_r3_r1"},
     {{cs, r3, r2}, true, cs, "cs r3 r2", "cs_r3_r2"},
     {{cs, r3, r3}, true, cs, "cs r3 r3", "cs_r3_r3"},
     {{cs, r3, r4}, true, cs, "cs r3 r4", "cs_r3_r4"},
     {{cs, r3, r5}, true, cs, "cs r3 r5", "cs_r3_r5"},
     {{cs, r3, r6}, true, cs, "cs r3 r6", "cs_r3_r6"},
     {{cs, r3, r7}, true, cs, "cs r3 r7", "cs_r3_r7"},
     {{cs, r3, r8}, true, cs, "cs r3 r8", "cs_r3_r8"},
     {{cs, r3, r9}, true, cs, "cs r3 r9", "cs_r3_r9"},
     {{cs, r3, r10}, true, cs, "cs r3 r10", "cs_r3_r10"},
     {{cs, r3, r11}, true, cs, "cs r3 r11", "cs_r3_r11"},
     {{cs, r3, r12}, true, cs, "cs r3 r12", "cs_r3_r12"},
     {{cs, r3, r13}, true, cs, "cs r3 r13", "cs_r3_r13"},
     {{cs, r3, r14}, true, cs, "cs r3 r14", "cs_r3_r14"},
     {{cs, r4, r0}, true, cs, "cs r4 r0", "cs_r4_r0"},
     {{cs, r4, r1}, true, cs, "cs r4 r1", "cs_r4_r1"},
     {{cs, r4, r2}, true, cs, "cs r4 r2", "cs_r4_r2"},
     {{cs, r4, r3}, true, cs, "cs r4 r3", "cs_r4_r3"},
     {{cs, r4, r4}, true, cs, "cs r4 r4", "cs_r4_r4"},
     {{cs, r4, r5}, true, cs, "cs r4 r5", "cs_r4_r5"},
     {{cs, r4, r6}, true, cs, "cs r4 r6", "cs_r4_r6"},
     {{cs, r4, r7}, true, cs, "cs r4 r7", "cs_r4_r7"},
     {{cs, r4, r8}, true, cs, "cs r4 r8", "cs_r4_r8"},
     {{cs, r4, r9}, true, cs, "cs r4 r9", "cs_r4_r9"},
     {{cs, r4, r10}, true, cs, "cs r4 r10", "cs_r4_r10"},
     {{cs, r4, r11}, true, cs, "cs r4 r11", "cs_r4_r11"},
     {{cs, r4, r12}, true, cs, "cs r4 r12", "cs_r4_r12"},
     {{cs, r4, r13}, true, cs, "cs r4 r13", "cs_r4_r13"},
     {{cs, r4, r14}, true, cs, "cs r4 r14", "cs_r4_r14"},
     {{cs, r5, r0}, true, cs, "cs r5 r0", "cs_r5_r0"},
     {{cs, r5, r1}, true, cs, "cs r5 r1", "cs_r5_r1"},
     {{cs, r5, r2}, true, cs, "cs r5 r2", "cs_r5_r2"},
     {{cs, r5, r3}, true, cs, "cs r5 r3", "cs_r5_r3"},
     {{cs, r5, r4}, true, cs, "cs r5 r4", "cs_r5_r4"},
     {{cs, r5, r5}, true, cs, "cs r5 r5", "cs_r5_r5"},
     {{cs, r5, r6}, true, cs, "cs r5 r6", "cs_r5_r6"},
     {{cs, r5, r7}, true, cs, "cs r5 r7", "cs_r5_r7"},
     {{cs, r5, r8}, true, cs, "cs r5 r8", "cs_r5_r8"},
     {{cs, r5, r9}, true, cs, "cs r5 r9", "cs_r5_r9"},
     {{cs, r5, r10}, true, cs, "cs r5 r10", "cs_r5_r10"},
     {{cs, r5, r11}, true, cs, "cs r5 r11", "cs_r5_r11"},
     {{cs, r5, r12}, true, cs, "cs r5 r12", "cs_r5_r12"},
     {{cs, r5, r13}, true, cs, "cs r5 r13", "cs_r5_r13"},
     {{cs, r5, r14}, true, cs, "cs r5 r14", "cs_r5_r14"},
     {{cs, r6, r0}, true, cs, "cs r6 r0", "cs_r6_r0"},
     {{cs, r6, r1}, true, cs, "cs r6 r1", "cs_r6_r1"},
     {{cs, r6, r2}, true, cs, "cs r6 r2", "cs_r6_r2"},
     {{cs, r6, r3}, true, cs, "cs r6 r3", "cs_r6_r3"},
     {{cs, r6, r4}, true, cs, "cs r6 r4", "cs_r6_r4"},
     {{cs, r6, r5}, true, cs, "cs r6 r5", "cs_r6_r5"},
     {{cs, r6, r6}, true, cs, "cs r6 r6", "cs_r6_r6"},
     {{cs, r6, r7}, true, cs, "cs r6 r7", "cs_r6_r7"},
     {{cs, r6, r8}, true, cs, "cs r6 r8", "cs_r6_r8"},
     {{cs, r6, r9}, true, cs, "cs r6 r9", "cs_r6_r9"},
     {{cs, r6, r10}, true, cs, "cs r6 r10", "cs_r6_r10"},
     {{cs, r6, r11}, true, cs, "cs r6 r11", "cs_r6_r11"},
     {{cs, r6, r12}, true, cs, "cs r6 r12", "cs_r6_r12"},
     {{cs, r6, r13}, true, cs, "cs r6 r13", "cs_r6_r13"},
     {{cs, r6, r14}, true, cs, "cs r6 r14", "cs_r6_r14"},
     {{cs, r7, r0}, true, cs, "cs r7 r0", "cs_r7_r0"},
     {{cs, r7, r1}, true, cs, "cs r7 r1", "cs_r7_r1"},
     {{cs, r7, r2}, true, cs, "cs r7 r2", "cs_r7_r2"},
     {{cs, r7, r3}, true, cs, "cs r7 r3", "cs_r7_r3"},
     {{cs, r7, r4}, true, cs, "cs r7 r4", "cs_r7_r4"},
     {{cs, r7, r5}, true, cs, "cs r7 r5", "cs_r7_r5"},
     {{cs, r7, r6}, true, cs, "cs r7 r6", "cs_r7_r6"},
     {{cs, r7, r7}, true, cs, "cs r7 r7", "cs_r7_r7"},
     {{cs, r7, r8}, true, cs, "cs r7 r8", "cs_r7_r8"},
     {{cs, r7, r9}, true, cs, "cs r7 r9", "cs_r7_r9"},
     {{cs, r7, r10}, true, cs, "cs r7 r10", "cs_r7_r10"},
     {{cs, r7, r11}, true, cs, "cs r7 r11", "cs_r7_r11"},
     {{cs, r7, r12}, true, cs, "cs r7 r12", "cs_r7_r12"},
     {{cs, r7, r13}, true, cs, "cs r7 r13", "cs_r7_r13"},
     {{cs, r7, r14}, true, cs, "cs r7 r14", "cs_r7_r14"},
     {{cs, r8, r0}, true, cs, "cs r8 r0", "cs_r8_r0"},
     {{cs, r8, r1}, true, cs, "cs r8 r1", "cs_r8_r1"},
     {{cs, r8, r2}, true, cs, "cs r8 r2", "cs_r8_r2"},
     {{cs, r8, r3}, true, cs, "cs r8 r3", "cs_r8_r3"},
     {{cs, r8, r4}, true, cs, "cs r8 r4", "cs_r8_r4"},
     {{cs, r8, r5}, true, cs, "cs r8 r5", "cs_r8_r5"},
     {{cs, r8, r6}, true, cs, "cs r8 r6", "cs_r8_r6"},
     {{cs, r8, r7}, true, cs, "cs r8 r7", "cs_r8_r7"},
     {{cs, r8, r8}, true, cs, "cs r8 r8", "cs_r8_r8"},
     {{cs, r8, r9}, true, cs, "cs r8 r9", "cs_r8_r9"},
     {{cs, r8, r10}, true, cs, "cs r8 r10", "cs_r8_r10"},
     {{cs, r8, r11}, true, cs, "cs r8 r11", "cs_r8_r11"},
     {{cs, r8, r12}, true, cs, "cs r8 r12", "cs_r8_r12"},
     {{cs, r8, r13}, true, cs, "cs r8 r13", "cs_r8_r13"},
     {{cs, r8, r14}, true, cs, "cs r8 r14", "cs_r8_r14"},
     {{cs, r9, r0}, true, cs, "cs r9 r0", "cs_r9_r0"},
     {{cs, r9, r1}, true, cs, "cs r9 r1", "cs_r9_r1"},
     {{cs, r9, r2}, true, cs, "cs r9 r2", "cs_r9_r2"},
     {{cs, r9, r3}, true, cs, "cs r9 r3", "cs_r9_r3"},
     {{cs, r9, r4}, true, cs, "cs r9 r4", "cs_r9_r4"},
     {{cs, r9, r5}, true, cs, "cs r9 r5", "cs_r9_r5"},
     {{cs, r9, r6}, true, cs, "cs r9 r6", "cs_r9_r6"},
     {{cs, r9, r7}, true, cs, "cs r9 r7", "cs_r9_r7"},
     {{cs, r9, r8}, true, cs, "cs r9 r8", "cs_r9_r8"},
     {{cs, r9, r9}, true, cs, "cs r9 r9", "cs_r9_r9"},
     {{cs, r9, r10}, true, cs, "cs r9 r10", "cs_r9_r10"},
     {{cs, r9, r11}, true, cs, "cs r9 r11", "cs_r9_r11"},
     {{cs, r9, r12}, true, cs, "cs r9 r12", "cs_r9_r12"},
     {{cs, r9, r13}, true, cs, "cs r9 r13", "cs_r9_r13"},
     {{cs, r9, r14}, true, cs, "cs r9 r14", "cs_r9_r14"},
     {{cs, r10, r0}, true, cs, "cs r10 r0", "cs_r10_r0"},
     {{cs, r10, r1}, true, cs, "cs r10 r1", "cs_r10_r1"},
     {{cs, r10, r2}, true, cs, "cs r10 r2", "cs_r10_r2"},
     {{cs, r10, r3}, true, cs, "cs r10 r3", "cs_r10_r3"},
     {{cs, r10, r4}, true, cs, "cs r10 r4", "cs_r10_r4"},
     {{cs, r10, r5}, true, cs, "cs r10 r5", "cs_r10_r5"},
     {{cs, r10, r6}, true, cs, "cs r10 r6", "cs_r10_r6"},
     {{cs, r10, r7}, true, cs, "cs r10 r7", "cs_r10_r7"},
     {{cs, r10, r8}, true, cs, "cs r10 r8", "cs_r10_r8"},
     {{cs, r10, r9}, true, cs, "cs r10 r9", "cs_r10_r9"},
     {{cs, r10, r10}, true, cs, "cs r10 r10", "cs_r10_r10"},
     {{cs, r10, r11}, true, cs, "cs r10 r11", "cs_r10_r11"},
     {{cs, r10, r12}, true, cs, "cs r10 r12", "cs_r10_r12"},
     {{cs, r10, r13}, true, cs, "cs r10 r13", "cs_r10_r13"},
     {{cs, r10, r14}, true, cs, "cs r10 r14", "cs_r10_r14"},
     {{cs, r11, r0}, true, cs, "cs r11 r0", "cs_r11_r0"},
     {{cs, r11, r1}, true, cs, "cs r11 r1", "cs_r11_r1"},
     {{cs, r11, r2}, true, cs, "cs r11 r2", "cs_r11_r2"},
     {{cs, r11, r3}, true, cs, "cs r11 r3", "cs_r11_r3"},
     {{cs, r11, r4}, true, cs, "cs r11 r4", "cs_r11_r4"},
     {{cs, r11, r5}, true, cs, "cs r11 r5", "cs_r11_r5"},
     {{cs, r11, r6}, true, cs, "cs r11 r6", "cs_r11_r6"},
     {{cs, r11, r7}, true, cs, "cs r11 r7", "cs_r11_r7"},
     {{cs, r11, r8}, true, cs, "cs r11 r8", "cs_r11_r8"},
     {{cs, r11, r9}, true, cs, "cs r11 r9", "cs_r11_r9"},
     {{cs, r11, r10}, true, cs, "cs r11 r10", "cs_r11_r10"},
     {{cs, r11, r11}, true, cs, "cs r11 r11", "cs_r11_r11"},
     {{cs, r11, r12}, true, cs, "cs r11 r12", "cs_r11_r12"},
     {{cs, r11, r13}, true, cs, "cs r11 r13", "cs_r11_r13"},
     {{cs, r11, r14}, true, cs, "cs r11 r14", "cs_r11_r14"},
     {{cs, r12, r0}, true, cs, "cs r12 r0", "cs_r12_r0"},
     {{cs, r12, r1}, true, cs, "cs r12 r1", "cs_r12_r1"},
     {{cs, r12, r2}, true, cs, "cs r12 r2", "cs_r12_r2"},
     {{cs, r12, r3}, true, cs, "cs r12 r3", "cs_r12_r3"},
     {{cs, r12, r4}, true, cs, "cs r12 r4", "cs_r12_r4"},
     {{cs, r12, r5}, true, cs, "cs r12 r5", "cs_r12_r5"},
     {{cs, r12, r6}, true, cs, "cs r12 r6", "cs_r12_r6"},
     {{cs, r12, r7}, true, cs, "cs r12 r7", "cs_r12_r7"},
     {{cs, r12, r8}, true, cs, "cs r12 r8", "cs_r12_r8"},
     {{cs, r12, r9}, true, cs, "cs r12 r9", "cs_r12_r9"},
     {{cs, r12, r10}, true, cs, "cs r12 r10", "cs_r12_r10"},
     {{cs, r12, r11}, true, cs, "cs r12 r11", "cs_r12_r11"},
     {{cs, r12, r12}, true, cs, "cs r12 r12", "cs_r12_r12"},
     {{cs, r12, r13}, true, cs, "cs r12 r13", "cs_r12_r13"},
     {{cs, r12, r14}, true, cs, "cs r12 r14", "cs_r12_r14"},
     {{cs, r13, r0}, true, cs, "cs r13 r0", "cs_r13_r0"},
     {{cs, r13, r1}, true, cs, "cs r13 r1", "cs_r13_r1"},
     {{cs, r13, r2}, true, cs, "cs r13 r2", "cs_r13_r2"},
     {{cs, r13, r3}, true, cs, "cs r13 r3", "cs_r13_r3"},
     {{cs, r13, r4}, true, cs, "cs r13 r4", "cs_r13_r4"},
     {{cs, r13, r5}, true, cs, "cs r13 r5", "cs_r13_r5"},
     {{cs, r13, r6}, true, cs, "cs r13 r6", "cs_r13_r6"},
     {{cs, r13, r7}, true, cs, "cs r13 r7", "cs_r13_r7"},
     {{cs, r13, r8}, true, cs, "cs r13 r8", "cs_r13_r8"},
     {{cs, r13, r9}, true, cs, "cs r13 r9", "cs_r13_r9"},
     {{cs, r13, r10}, true, cs, "cs r13 r10", "cs_r13_r10"},
     {{cs, r13, r11}, true, cs, "cs r13 r11", "cs_r13_r11"},
     {{cs, r13, r12}, true, cs, "cs r13 r12", "cs_r13_r12"},
     {{cs, r13, r13}, true, cs, "cs r13 r13", "cs_r13_r13"},
     {{cs, r13, r14}, true, cs, "cs r13 r14", "cs_r13_r14"},
     {{cs, r14, r0}, true, cs, "cs r14 r0", "cs_r14_r0"},
     {{cs, r14, r1}, true, cs, "cs r14 r1", "cs_r14_r1"},
     {{cs, r14, r2}, true, cs, "cs r14 r2", "cs_r14_r2"},
     {{cs, r14, r3}, true, cs, "cs r14 r3", "cs_r14_r3"},
     {{cs, r14, r4}, true, cs, "cs r14 r4", "cs_r14_r4"},
     {{cs, r14, r5}, true, cs, "cs r14 r5", "cs_r14_r5"},
     {{cs, r14, r6}, true, cs, "cs r14 r6", "cs_r14_r6"},
     {{cs, r14, r7}, true, cs, "cs r14 r7", "cs_r14_r7"},
     {{cs, r14, r8}, true, cs, "cs r14 r8", "cs_r14_r8"},
     {{cs, r14, r9}, true, cs, "cs r14 r9", "cs_r14_r9"},
     {{cs, r14, r10}, true, cs, "cs r14 r10", "cs_r14_r10"},
     {{cs, r14, r11}, true, cs, "cs r14 r11", "cs_r14_r11"},
     {{cs, r14, r12}, true, cs, "cs r14 r12", "cs_r14_r12"},
     {{cs, r14, r13}, true, cs, "cs r14 r13", "cs_r14_r13"},
     {{cs, r14, r14}, true, cs, "cs r14 r14", "cs_r14_r14"},
     {{cc, r0, r0}, true, cc, "cc r0 r0", "cc_r0_r0"},
     {{cc, r0, r1}, true, cc, "cc r0 r1", "cc_r0_r1"},
     {{cc, r0, r2}, true, cc, "cc r0 r2", "cc_r0_r2"},
     {{cc, r0, r3}, true, cc, "cc r0 r3", "cc_r0_r3"},
     {{cc, r0, r4}, true, cc, "cc r0 r4", "cc_r0_r4"},
     {{cc, r0, r5}, true, cc, "cc r0 r5", "cc_r0_r5"},
     {{cc, r0, r6}, true, cc, "cc r0 r6", "cc_r0_r6"},
     {{cc, r0, r7}, true, cc, "cc r0 r7", "cc_r0_r7"},
     {{cc, r0, r8}, true, cc, "cc r0 r8", "cc_r0_r8"},
     {{cc, r0, r9}, true, cc, "cc r0 r9", "cc_r0_r9"},
     {{cc, r0, r10}, true, cc, "cc r0 r10", "cc_r0_r10"},
     {{cc, r0, r11}, true, cc, "cc r0 r11", "cc_r0_r11"},
     {{cc, r0, r12}, true, cc, "cc r0 r12", "cc_r0_r12"},
     {{cc, r0, r13}, true, cc, "cc r0 r13", "cc_r0_r13"},
     {{cc, r0, r14}, true, cc, "cc r0 r14", "cc_r0_r14"},
     {{cc, r1, r0}, true, cc, "cc r1 r0", "cc_r1_r0"},
     {{cc, r1, r1}, true, cc, "cc r1 r1", "cc_r1_r1"},
     {{cc, r1, r2}, true, cc, "cc r1 r2", "cc_r1_r2"},
     {{cc, r1, r3}, true, cc, "cc r1 r3", "cc_r1_r3"},
     {{cc, r1, r4}, true, cc, "cc r1 r4", "cc_r1_r4"},
     {{cc, r1, r5}, true, cc, "cc r1 r5", "cc_r1_r5"},
     {{cc, r1, r6}, true, cc, "cc r1 r6", "cc_r1_r6"},
     {{cc, r1, r7}, true, cc, "cc r1 r7", "cc_r1_r7"},
     {{cc, r1, r8}, true, cc, "cc r1 r8", "cc_r1_r8"},
     {{cc, r1, r9}, true, cc, "cc r1 r9", "cc_r1_r9"},
     {{cc, r1, r10}, true, cc, "cc r1 r10", "cc_r1_r10"},
     {{cc, r1, r11}, true, cc, "cc r1 r11", "cc_r1_r11"},
     {{cc, r1, r12}, true, cc, "cc r1 r12", "cc_r1_r12"},
     {{cc, r1, r13}, true, cc, "cc r1 r13", "cc_r1_r13"},
     {{cc, r1, r14}, true, cc, "cc r1 r14", "cc_r1_r14"},
     {{cc, r2, r0}, true, cc, "cc r2 r0", "cc_r2_r0"},
     {{cc, r2, r1}, true, cc, "cc r2 r1", "cc_r2_r1"},
     {{cc, r2, r2}, true, cc, "cc r2 r2", "cc_r2_r2"},
     {{cc, r2, r3}, true, cc, "cc r2 r3", "cc_r2_r3"},
     {{cc, r2, r4}, true, cc, "cc r2 r4", "cc_r2_r4"},
     {{cc, r2, r5}, true, cc, "cc r2 r5", "cc_r2_r5"},
     {{cc, r2, r6}, true, cc, "cc r2 r6", "cc_r2_r6"},
     {{cc, r2, r7}, true, cc, "cc r2 r7", "cc_r2_r7"},
     {{cc, r2, r8}, true, cc, "cc r2 r8", "cc_r2_r8"},
     {{cc, r2, r9}, true, cc, "cc r2 r9", "cc_r2_r9"},
     {{cc, r2, r10}, true, cc, "cc r2 r10", "cc_r2_r10"},
     {{cc, r2, r11}, true, cc, "cc r2 r11", "cc_r2_r11"},
     {{cc, r2, r12}, true, cc, "cc r2 r12", "cc_r2_r12"},
     {{cc, r2, r13}, true, cc, "cc r2 r13", "cc_r2_r13"},
     {{cc, r2, r14}, true, cc, "cc r2 r14", "cc_r2_r14"},
     {{cc, r3, r0}, true, cc, "cc r3 r0", "cc_r3_r0"},
     {{cc, r3, r1}, true, cc, "cc r3 r1", "cc_r3_r1"},
     {{cc, r3, r2}, true, cc, "cc r3 r2", "cc_r3_r2"},
     {{cc, r3, r3}, true, cc, "cc r3 r3", "cc_r3_r3"},
     {{cc, r3, r4}, true, cc, "cc r3 r4", "cc_r3_r4"},
     {{cc, r3, r5}, true, cc, "cc r3 r5", "cc_r3_r5"},
     {{cc, r3, r6}, true, cc, "cc r3 r6", "cc_r3_r6"},
     {{cc, r3, r7}, true, cc, "cc r3 r7", "cc_r3_r7"},
     {{cc, r3, r8}, true, cc, "cc r3 r8", "cc_r3_r8"},
     {{cc, r3, r9}, true, cc, "cc r3 r9", "cc_r3_r9"},
     {{cc, r3, r10}, true, cc, "cc r3 r10", "cc_r3_r10"},
     {{cc, r3, r11}, true, cc, "cc r3 r11", "cc_r3_r11"},
     {{cc, r3, r12}, true, cc, "cc r3 r12", "cc_r3_r12"},
     {{cc, r3, r13}, true, cc, "cc r3 r13", "cc_r3_r13"},
     {{cc, r3, r14}, true, cc, "cc r3 r14", "cc_r3_r14"},
     {{cc, r4, r0}, true, cc, "cc r4 r0", "cc_r4_r0"},
     {{cc, r4, r1}, true, cc, "cc r4 r1", "cc_r4_r1"},
     {{cc, r4, r2}, true, cc, "cc r4 r2", "cc_r4_r2"},
     {{cc, r4, r3}, true, cc, "cc r4 r3", "cc_r4_r3"},
     {{cc, r4, r4}, true, cc, "cc r4 r4", "cc_r4_r4"},
     {{cc, r4, r5}, true, cc, "cc r4 r5", "cc_r4_r5"},
     {{cc, r4, r6}, true, cc, "cc r4 r6", "cc_r4_r6"},
     {{cc, r4, r7}, true, cc, "cc r4 r7", "cc_r4_r7"},
     {{cc, r4, r8}, true, cc, "cc r4 r8", "cc_r4_r8"},
     {{cc, r4, r9}, true, cc, "cc r4 r9", "cc_r4_r9"},
     {{cc, r4, r10}, true, cc, "cc r4 r10", "cc_r4_r10"},
     {{cc, r4, r11}, true, cc, "cc r4 r11", "cc_r4_r11"},
     {{cc, r4, r12}, true, cc, "cc r4 r12", "cc_r4_r12"},
     {{cc, r4, r13}, true, cc, "cc r4 r13", "cc_r4_r13"},
     {{cc, r4, r14}, true, cc, "cc r4 r14", "cc_r4_r14"},
     {{cc, r5, r0}, true, cc, "cc r5 r0", "cc_r5_r0"},
     {{cc, r5, r1}, true, cc, "cc r5 r1", "cc_r5_r1"},
     {{cc, r5, r2}, true, cc, "cc r5 r2", "cc_r5_r2"},
     {{cc, r5, r3}, true, cc, "cc r5 r3", "cc_r5_r3"},
     {{cc, r5, r4}, true, cc, "cc r5 r4", "cc_r5_r4"},
     {{cc, r5, r5}, true, cc, "cc r5 r5", "cc_r5_r5"},
     {{cc, r5, r6}, true, cc, "cc r5 r6", "cc_r5_r6"},
     {{cc, r5, r7}, true, cc, "cc r5 r7", "cc_r5_r7"},
     {{cc, r5, r8}, true, cc, "cc r5 r8", "cc_r5_r8"},
     {{cc, r5, r9}, true, cc, "cc r5 r9", "cc_r5_r9"},
     {{cc, r5, r10}, true, cc, "cc r5 r10", "cc_r5_r10"},
     {{cc, r5, r11}, true, cc, "cc r5 r11", "cc_r5_r11"},
     {{cc, r5, r12}, true, cc, "cc r5 r12", "cc_r5_r12"},
     {{cc, r5, r13}, true, cc, "cc r5 r13", "cc_r5_r13"},
     {{cc, r5, r14}, true, cc, "cc r5 r14", "cc_r5_r14"},
     {{cc, r6, r0}, true, cc, "cc r6 r0", "cc_r6_r0"},
     {{cc, r6, r1}, true, cc, "cc r6 r1", "cc_r6_r1"},
     {{cc, r6, r2}, true, cc, "cc r6 r2", "cc_r6_r2"},
     {{cc, r6, r3}, true, cc, "cc r6 r3", "cc_r6_r3"},
     {{cc, r6, r4}, true, cc, "cc r6 r4", "cc_r6_r4"},
     {{cc, r6, r5}, true, cc, "cc r6 r5", "cc_r6_r5"},
     {{cc, r6, r6}, true, cc, "cc r6 r6", "cc_r6_r6"},
     {{cc, r6, r7}, true, cc, "cc r6 r7", "cc_r6_r7"},
     {{cc, r6, r8}, true, cc, "cc r6 r8", "cc_r6_r8"},
     {{cc, r6, r9}, true, cc, "cc r6 r9", "cc_r6_r9"},
     {{cc, r6, r10}, true, cc, "cc r6 r10", "cc_r6_r10"},
     {{cc, r6, r11}, true, cc, "cc r6 r11", "cc_r6_r11"},
     {{cc, r6, r12}, true, cc, "cc r6 r12", "cc_r6_r12"},
     {{cc, r6, r13}, true, cc, "cc r6 r13", "cc_r6_r13"},
     {{cc, r6, r14}, true, cc, "cc r6 r14", "cc_r6_r14"},
     {{cc, r7, r0}, true, cc, "cc r7 r0", "cc_r7_r0"},
     {{cc, r7, r1}, true, cc, "cc r7 r1", "cc_r7_r1"},
     {{cc, r7, r2}, true, cc, "cc r7 r2", "cc_r7_r2"},
     {{cc, r7, r3}, true, cc, "cc r7 r3", "cc_r7_r3"},
     {{cc, r7, r4}, true, cc, "cc r7 r4", "cc_r7_r4"},
     {{cc, r7, r5}, true, cc, "cc r7 r5", "cc_r7_r5"},
     {{cc, r7, r6}, true, cc, "cc r7 r6", "cc_r7_r6"},
     {{cc, r7, r7}, true, cc, "cc r7 r7", "cc_r7_r7"},
     {{cc, r7, r8}, true, cc, "cc r7 r8", "cc_r7_r8"},
     {{cc, r7, r9}, true, cc, "cc r7 r9", "cc_r7_r9"},
     {{cc, r7, r10}, true, cc, "cc r7 r10", "cc_r7_r10"},
     {{cc, r7, r11}, true, cc, "cc r7 r11", "cc_r7_r11"},
     {{cc, r7, r12}, true, cc, "cc r7 r12", "cc_r7_r12"},
     {{cc, r7, r13}, true, cc, "cc r7 r13", "cc_r7_r13"},
     {{cc, r7, r14}, true, cc, "cc r7 r14", "cc_r7_r14"},
     {{cc, r8, r0}, true, cc, "cc r8 r0", "cc_r8_r0"},
     {{cc, r8, r1}, true, cc, "cc r8 r1", "cc_r8_r1"},
     {{cc, r8, r2}, true, cc, "cc r8 r2", "cc_r8_r2"},
     {{cc, r8, r3}, true, cc, "cc r8 r3", "cc_r8_r3"},
     {{cc, r8, r4}, true, cc, "cc r8 r4", "cc_r8_r4"},
     {{cc, r8, r5}, true, cc, "cc r8 r5", "cc_r8_r5"},
     {{cc, r8, r6}, true, cc, "cc r8 r6", "cc_r8_r6"},
     {{cc, r8, r7}, true, cc, "cc r8 r7", "cc_r8_r7"},
     {{cc, r8, r8}, true, cc, "cc r8 r8", "cc_r8_r8"},
     {{cc, r8, r9}, true, cc, "cc r8 r9", "cc_r8_r9"},
     {{cc, r8, r10}, true, cc, "cc r8 r10", "cc_r8_r10"},
     {{cc, r8, r11}, true, cc, "cc r8 r11", "cc_r8_r11"},
     {{cc, r8, r12}, true, cc, "cc r8 r12", "cc_r8_r12"},
     {{cc, r8, r13}, true, cc, "cc r8 r13", "cc_r8_r13"},
     {{cc, r8, r14}, true, cc, "cc r8 r14", "cc_r8_r14"},
     {{cc, r9, r0}, true, cc, "cc r9 r0", "cc_r9_r0"},
     {{cc, r9, r1}, true, cc, "cc r9 r1", "cc_r9_r1"},
     {{cc, r9, r2}, true, cc, "cc r9 r2", "cc_r9_r2"},
     {{cc, r9, r3}, true, cc, "cc r9 r3", "cc_r9_r3"},
     {{cc, r9, r4}, true, cc, "cc r9 r4", "cc_r9_r4"},
     {{cc, r9, r5}, true, cc, "cc r9 r5", "cc_r9_r5"},
     {{cc, r9, r6}, true, cc, "cc r9 r6", "cc_r9_r6"},
     {{cc, r9, r7}, true, cc, "cc r9 r7", "cc_r9_r7"},
     {{cc, r9, r8}, true, cc, "cc r9 r8", "cc_r9_r8"},
     {{cc, r9, r9}, true, cc, "cc r9 r9", "cc_r9_r9"},
     {{cc, r9, r10}, true, cc, "cc r9 r10", "cc_r9_r10"},
     {{cc, r9, r11}, true, cc, "cc r9 r11", "cc_r9_r11"},
     {{cc, r9, r12}, true, cc, "cc r9 r12", "cc_r9_r12"},
     {{cc, r9, r13}, true, cc, "cc r9 r13", "cc_r9_r13"},
     {{cc, r9, r14}, true, cc, "cc r9 r14", "cc_r9_r14"},
     {{cc, r10, r0}, true, cc, "cc r10 r0", "cc_r10_r0"},
     {{cc, r10, r1}, true, cc, "cc r10 r1", "cc_r10_r1"},
     {{cc, r10, r2}, true, cc, "cc r10 r2", "cc_r10_r2"},
     {{cc, r10, r3}, true, cc, "cc r10 r3", "cc_r10_r3"},
     {{cc, r10, r4}, true, cc, "cc r10 r4", "cc_r10_r4"},
     {{cc, r10, r5}, true, cc, "cc r10 r5", "cc_r10_r5"},
     {{cc, r10, r6}, true, cc, "cc r10 r6", "cc_r10_r6"},
     {{cc, r10, r7}, true, cc, "cc r10 r7", "cc_r10_r7"},
     {{cc, r10, r8}, true, cc, "cc r10 r8", "cc_r10_r8"},
     {{cc, r10, r9}, true, cc, "cc r10 r9", "cc_r10_r9"},
     {{cc, r10, r10}, true, cc, "cc r10 r10", "cc_r10_r10"},
     {{cc, r10, r11}, true, cc, "cc r10 r11", "cc_r10_r11"},
     {{cc, r10, r12}, true, cc, "cc r10 r12", "cc_r10_r12"},
     {{cc, r10, r13}, true, cc, "cc r10 r13", "cc_r10_r13"},
     {{cc, r10, r14}, true, cc, "cc r10 r14", "cc_r10_r14"},
     {{cc, r11, r0}, true, cc, "cc r11 r0", "cc_r11_r0"},
     {{cc, r11, r1}, true, cc, "cc r11 r1", "cc_r11_r1"},
     {{cc, r11, r2}, true, cc, "cc r11 r2", "cc_r11_r2"},
     {{cc, r11, r3}, true, cc, "cc r11 r3", "cc_r11_r3"},
     {{cc, r11, r4}, true, cc, "cc r11 r4", "cc_r11_r4"},
     {{cc, r11, r5}, true, cc, "cc r11 r5", "cc_r11_r5"},
     {{cc, r11, r6}, true, cc, "cc r11 r6", "cc_r11_r6"},
     {{cc, r11, r7}, true, cc, "cc r11 r7", "cc_r11_r7"},
     {{cc, r11, r8}, true, cc, "cc r11 r8", "cc_r11_r8"},
     {{cc, r11, r9}, true, cc, "cc r11 r9", "cc_r11_r9"},
     {{cc, r11, r10}, true, cc, "cc r11 r10", "cc_r11_r10"},
     {{cc, r11, r11}, true, cc, "cc r11 r11", "cc_r11_r11"},
     {{cc, r11, r12}, true, cc, "cc r11 r12", "cc_r11_r12"},
     {{cc, r11, r13}, true, cc, "cc r11 r13", "cc_r11_r13"},
     {{cc, r11, r14}, true, cc, "cc r11 r14", "cc_r11_r14"},
     {{cc, r12, r0}, true, cc, "cc r12 r0", "cc_r12_r0"},
     {{cc, r12, r1}, true, cc, "cc r12 r1", "cc_r12_r1"},
     {{cc, r12, r2}, true, cc, "cc r12 r2", "cc_r12_r2"},
     {{cc, r12, r3}, true, cc, "cc r12 r3", "cc_r12_r3"},
     {{cc, r12, r4}, true, cc, "cc r12 r4", "cc_r12_r4"},
     {{cc, r12, r5}, true, cc, "cc r12 r5", "cc_r12_r5"},
     {{cc, r12, r6}, true, cc, "cc r12 r6", "cc_r12_r6"},
     {{cc, r12, r7}, true, cc, "cc r12 r7", "cc_r12_r7"},
     {{cc, r12, r8}, true, cc, "cc r12 r8", "cc_r12_r8"},
     {{cc, r12, r9}, true, cc, "cc r12 r9", "cc_r12_r9"},
     {{cc, r12, r10}, true, cc, "cc r12 r10", "cc_r12_r10"},
     {{cc, r12, r11}, true, cc, "cc r12 r11", "cc_r12_r11"},
     {{cc, r12, r12}, true, cc, "cc r12 r12", "cc_r12_r12"},
     {{cc, r12, r13}, true, cc, "cc r12 r13", "cc_r12_r13"},
     {{cc, r12, r14}, true, cc, "cc r12 r14", "cc_r12_r14"},
     {{cc, r13, r0}, true, cc, "cc r13 r0", "cc_r13_r0"},
     {{cc, r13, r1}, true, cc, "cc r13 r1", "cc_r13_r1"},
     {{cc, r13, r2}, true, cc, "cc r13 r2", "cc_r13_r2"},
     {{cc, r13, r3}, true, cc, "cc r13 r3", "cc_r13_r3"},
     {{cc, r13, r4}, true, cc, "cc r13 r4", "cc_r13_r4"},
     {{cc, r13, r5}, true, cc, "cc r13 r5", "cc_r13_r5"},
     {{cc, r13, r6}, true, cc, "cc r13 r6", "cc_r13_r6"},
     {{cc, r13, r7}, true, cc, "cc r13 r7", "cc_r13_r7"},
     {{cc, r13, r8}, true, cc, "cc r13 r8", "cc_r13_r8"},
     {{cc, r13, r9}, true, cc, "cc r13 r9", "cc_r13_r9"},
     {{cc, r13, r10}, true, cc, "cc r13 r10", "cc_r13_r10"},
     {{cc, r13, r11}, true, cc, "cc r13 r11", "cc_r13_r11"},
     {{cc, r13, r12}, true, cc, "cc r13 r12", "cc_r13_r12"},
     {{cc, r13, r13}, true, cc, "cc r13 r13", "cc_r13_r13"},
     {{cc, r13, r14}, true, cc, "cc r13 r14", "cc_r13_r14"},
     {{cc, r14, r0}, true, cc, "cc r14 r0", "cc_r14_r0"},
     {{cc, r14, r1}, true, cc, "cc r14 r1", "cc_r14_r1"},
     {{cc, r14, r2}, true, cc, "cc r14 r2", "cc_r14_r2"},
     {{cc, r14, r3}, true, cc, "cc r14 r3", "cc_r14_r3"},
     {{cc, r14, r4}, true, cc, "cc r14 r4", "cc_r14_r4"},
     {{cc, r14, r5}, true, cc, "cc r14 r5", "cc_r14_r5"},
     {{cc, r14, r6}, true, cc, "cc r14 r6", "cc_r14_r6"},
     {{cc, r14, r7}, true, cc, "cc r14 r7", "cc_r14_r7"},
     {{cc, r14, r8}, true, cc, "cc r14 r8", "cc_r14_r8"},
     {{cc, r14, r9}, true, cc, "cc r14 r9", "cc_r14_r9"},
     {{cc, r14, r10}, true, cc, "cc r14 r10", "cc_r14_r10"},
     {{cc, r14, r11}, true, cc, "cc r14 r11", "cc_r14_r11"},
     {{cc, r14, r12}, true, cc, "cc r14 r12", "cc_r14_r12"},
     {{cc, r14, r13}, true, cc, "cc r14 r13", "cc_r14_r13"},
     {{cc, r14, r14}, true, cc, "cc r14 r14", "cc_r14_r14"},
     {{mi, r0, r0}, true, mi, "mi r0 r0", "mi_r0_r0"},
     {{mi, r0, r1}, true, mi, "mi r0 r1", "mi_r0_r1"},
     {{mi, r0, r2}, true, mi, "mi r0 r2", "mi_r0_r2"},
     {{mi, r0, r3}, true, mi, "mi r0 r3", "mi_r0_r3"},
     {{mi, r0, r4}, true, mi, "mi r0 r4", "mi_r0_r4"},
     {{mi, r0, r5}, true, mi, "mi r0 r5", "mi_r0_r5"},
     {{mi, r0, r6}, true, mi, "mi r0 r6", "mi_r0_r6"},
     {{mi, r0, r7}, true, mi, "mi r0 r7", "mi_r0_r7"},
     {{mi, r0, r8}, true, mi, "mi r0 r8", "mi_r0_r8"},
     {{mi, r0, r9}, true, mi, "mi r0 r9", "mi_r0_r9"},
     {{mi, r0, r10}, true, mi, "mi r0 r10", "mi_r0_r10"},
     {{mi, r0, r11}, true, mi, "mi r0 r11", "mi_r0_r11"},
     {{mi, r0, r12}, true, mi, "mi r0 r12", "mi_r0_r12"},
     {{mi, r0, r13}, true, mi, "mi r0 r13", "mi_r0_r13"},
     {{mi, r0, r14}, true, mi, "mi r0 r14", "mi_r0_r14"},
     {{mi, r1, r0}, true, mi, "mi r1 r0", "mi_r1_r0"},
     {{mi, r1, r1}, true, mi, "mi r1 r1", "mi_r1_r1"},
     {{mi, r1, r2}, true, mi, "mi r1 r2", "mi_r1_r2"},
     {{mi, r1, r3}, true, mi, "mi r1 r3", "mi_r1_r3"},
     {{mi, r1, r4}, true, mi, "mi r1 r4", "mi_r1_r4"},
     {{mi, r1, r5}, true, mi, "mi r1 r5", "mi_r1_r5"},
     {{mi, r1, r6}, true, mi, "mi r1 r6", "mi_r1_r6"},
     {{mi, r1, r7}, true, mi, "mi r1 r7", "mi_r1_r7"},
     {{mi, r1, r8}, true, mi, "mi r1 r8", "mi_r1_r8"},
     {{mi, r1, r9}, true, mi, "mi r1 r9", "mi_r1_r9"},
     {{mi, r1, r10}, true, mi, "mi r1 r10", "mi_r1_r10"},
     {{mi, r1, r11}, true, mi, "mi r1 r11", "mi_r1_r11"},
     {{mi, r1, r12}, true, mi, "mi r1 r12", "mi_r1_r12"},
     {{mi, r1, r13}, true, mi, "mi r1 r13", "mi_r1_r13"},
     {{mi, r1, r14}, true, mi, "mi r1 r14", "mi_r1_r14"},
     {{mi, r2, r0}, true, mi, "mi r2 r0", "mi_r2_r0"},
     {{mi, r2, r1}, true, mi, "mi r2 r1", "mi_r2_r1"},
     {{mi, r2, r2}, true, mi, "mi r2 r2", "mi_r2_r2"},
     {{mi, r2, r3}, true, mi, "mi r2 r3", "mi_r2_r3"},
     {{mi, r2, r4}, true, mi, "mi r2 r4", "mi_r2_r4"},
     {{mi, r2, r5}, true, mi, "mi r2 r5", "mi_r2_r5"},
     {{mi, r2, r6}, true, mi, "mi r2 r6", "mi_r2_r6"},
     {{mi, r2, r7}, true, mi, "mi r2 r7", "mi_r2_r7"},
     {{mi, r2, r8}, true, mi, "mi r2 r8", "mi_r2_r8"},
     {{mi, r2, r9}, true, mi, "mi r2 r9", "mi_r2_r9"},
     {{mi, r2, r10}, true, mi, "mi r2 r10", "mi_r2_r10"},
     {{mi, r2, r11}, true, mi, "mi r2 r11", "mi_r2_r11"},
     {{mi, r2, r12}, true, mi, "mi r2 r12", "mi_r2_r12"},
     {{mi, r2, r13}, true, mi, "mi r2 r13", "mi_r2_r13"},
     {{mi, r2, r14}, true, mi, "mi r2 r14", "mi_r2_r14"},
     {{mi, r3, r0}, true, mi, "mi r3 r0", "mi_r3_r0"},
     {{mi, r3, r1}, true, mi, "mi r3 r1", "mi_r3_r1"},
     {{mi, r3, r2}, true, mi, "mi r3 r2", "mi_r3_r2"},
     {{mi, r3, r3}, true, mi, "mi r3 r3", "mi_r3_r3"},
     {{mi, r3, r4}, true, mi, "mi r3 r4", "mi_r3_r4"},
     {{mi, r3, r5}, true, mi, "mi r3 r5", "mi_r3_r5"},
     {{mi, r3, r6}, true, mi, "mi r3 r6", "mi_r3_r6"},
     {{mi, r3, r7}, true, mi, "mi r3 r7", "mi_r3_r7"},
     {{mi, r3, r8}, true, mi, "mi r3 r8", "mi_r3_r8"},
     {{mi, r3, r9}, true, mi, "mi r3 r9", "mi_r3_r9"},
     {{mi, r3, r10}, true, mi, "mi r3 r10", "mi_r3_r10"},
     {{mi, r3, r11}, true, mi, "mi r3 r11", "mi_r3_r11"},
     {{mi, r3, r12}, true, mi, "mi r3 r12", "mi_r3_r12"},
     {{mi, r3, r13}, true, mi, "mi r3 r13", "mi_r3_r13"},
     {{mi, r3, r14}, true, mi, "mi r3 r14", "mi_r3_r14"},
     {{mi, r4, r0}, true, mi, "mi r4 r0", "mi_r4_r0"},
     {{mi, r4, r1}, true, mi, "mi r4 r1", "mi_r4_r1"},
     {{mi, r4, r2}, true, mi, "mi r4 r2", "mi_r4_r2"},
     {{mi, r4, r3}, true, mi, "mi r4 r3", "mi_r4_r3"},
     {{mi, r4, r4}, true, mi, "mi r4 r4", "mi_r4_r4"},
     {{mi, r4, r5}, true, mi, "mi r4 r5", "mi_r4_r5"},
     {{mi, r4, r6}, true, mi, "mi r4 r6", "mi_r4_r6"},
     {{mi, r4, r7}, true, mi, "mi r4 r7", "mi_r4_r7"},
     {{mi, r4, r8}, true, mi, "mi r4 r8", "mi_r4_r8"},
     {{mi, r4, r9}, true, mi, "mi r4 r9", "mi_r4_r9"},
     {{mi, r4, r10}, true, mi, "mi r4 r10", "mi_r4_r10"},
     {{mi, r4, r11}, true, mi, "mi r4 r11", "mi_r4_r11"},
     {{mi, r4, r12}, true, mi, "mi r4 r12", "mi_r4_r12"},
     {{mi, r4, r13}, true, mi, "mi r4 r13", "mi_r4_r13"},
     {{mi, r4, r14}, true, mi, "mi r4 r14", "mi_r4_r14"},
     {{mi, r5, r0}, true, mi, "mi r5 r0", "mi_r5_r0"},
     {{mi, r5, r1}, true, mi, "mi r5 r1", "mi_r5_r1"},
     {{mi, r5, r2}, true, mi, "mi r5 r2", "mi_r5_r2"},
     {{mi, r5, r3}, true, mi, "mi r5 r3", "mi_r5_r3"},
     {{mi, r5, r4}, true, mi, "mi r5 r4", "mi_r5_r4"},
     {{mi, r5, r5}, true, mi, "mi r5 r5", "mi_r5_r5"},
     {{mi, r5, r6}, true, mi, "mi r5 r6", "mi_r5_r6"},
     {{mi, r5, r7}, true, mi, "mi r5 r7", "mi_r5_r7"},
     {{mi, r5, r8}, true, mi, "mi r5 r8", "mi_r5_r8"},
     {{mi, r5, r9}, true, mi, "mi r5 r9", "mi_r5_r9"},
     {{mi, r5, r10}, true, mi, "mi r5 r10", "mi_r5_r10"},
     {{mi, r5, r11}, true, mi, "mi r5 r11", "mi_r5_r11"},
     {{mi, r5, r12}, true, mi, "mi r5 r12", "mi_r5_r12"},
     {{mi, r5, r13}, true, mi, "mi r5 r13", "mi_r5_r13"},
     {{mi, r5, r14}, true, mi, "mi r5 r14", "mi_r5_r14"},
     {{mi, r6, r0}, true, mi, "mi r6 r0", "mi_r6_r0"},
     {{mi, r6, r1}, true, mi, "mi r6 r1", "mi_r6_r1"},
     {{mi, r6, r2}, true, mi, "mi r6 r2", "mi_r6_r2"},
     {{mi, r6, r3}, true, mi, "mi r6 r3", "mi_r6_r3"},
     {{mi, r6, r4}, true, mi, "mi r6 r4", "mi_r6_r4"},
     {{mi, r6, r5}, true, mi, "mi r6 r5", "mi_r6_r5"},
     {{mi, r6, r6}, true, mi, "mi r6 r6", "mi_r6_r6"},
     {{mi, r6, r7}, true, mi, "mi r6 r7", "mi_r6_r7"},
     {{mi, r6, r8}, true, mi, "mi r6 r8", "mi_r6_r8"},
     {{mi, r6, r9}, true, mi, "mi r6 r9", "mi_r6_r9"},
     {{mi, r6, r10}, true, mi, "mi r6 r10", "mi_r6_r10"},
     {{mi, r6, r11}, true, mi, "mi r6 r11", "mi_r6_r11"},
     {{mi, r6, r12}, true, mi, "mi r6 r12", "mi_r6_r12"},
     {{mi, r6, r13}, true, mi, "mi r6 r13", "mi_r6_r13"},
     {{mi, r6, r14}, true, mi, "mi r6 r14", "mi_r6_r14"},
     {{mi, r7, r0}, true, mi, "mi r7 r0", "mi_r7_r0"},
     {{mi, r7, r1}, true, mi, "mi r7 r1", "mi_r7_r1"},
     {{mi, r7, r2}, true, mi, "mi r7 r2", "mi_r7_r2"},
     {{mi, r7, r3}, true, mi, "mi r7 r3", "mi_r7_r3"},
     {{mi, r7, r4}, true, mi, "mi r7 r4", "mi_r7_r4"},
     {{mi, r7, r5}, true, mi, "mi r7 r5", "mi_r7_r5"},
     {{mi, r7, r6}, true, mi, "mi r7 r6", "mi_r7_r6"},
     {{mi, r7, r7}, true, mi, "mi r7 r7", "mi_r7_r7"},
     {{mi, r7, r8}, true, mi, "mi r7 r8", "mi_r7_r8"},
     {{mi, r7, r9}, true, mi, "mi r7 r9", "mi_r7_r9"},
     {{mi, r7, r10}, true, mi, "mi r7 r10", "mi_r7_r10"},
     {{mi, r7, r11}, true, mi, "mi r7 r11", "mi_r7_r11"},
     {{mi, r7, r12}, true, mi, "mi r7 r12", "mi_r7_r12"},
     {{mi, r7, r13}, true, mi, "mi r7 r13", "mi_r7_r13"},
     {{mi, r7, r14}, true, mi, "mi r7 r14", "mi_r7_r14"},
     {{mi, r8, r0}, true, mi, "mi r8 r0", "mi_r8_r0"},
     {{mi, r8, r1}, true, mi, "mi r8 r1", "mi_r8_r1"},
     {{mi, r8, r2}, true, mi, "mi r8 r2", "mi_r8_r2"},
     {{mi, r8, r3}, true, mi, "mi r8 r3", "mi_r8_r3"},
     {{mi, r8, r4}, true, mi, "mi r8 r4", "mi_r8_r4"},
     {{mi, r8, r5}, true, mi, "mi r8 r5", "mi_r8_r5"},
     {{mi, r8, r6}, true, mi, "mi r8 r6", "mi_r8_r6"},
     {{mi, r8, r7}, true, mi, "mi r8 r7", "mi_r8_r7"},
     {{mi, r8, r8}, true, mi, "mi r8 r8", "mi_r8_r8"},
     {{mi, r8, r9}, true, mi, "mi r8 r9", "mi_r8_r9"},
     {{mi, r8, r10}, true, mi, "mi r8 r10", "mi_r8_r10"},
     {{mi, r8, r11}, true, mi, "mi r8 r11", "mi_r8_r11"},
     {{mi, r8, r12}, true, mi, "mi r8 r12", "mi_r8_r12"},
     {{mi, r8, r13}, true, mi, "mi r8 r13", "mi_r8_r13"},
     {{mi, r8, r14}, true, mi, "mi r8 r14", "mi_r8_r14"},
     {{mi, r9, r0}, true, mi, "mi r9 r0", "mi_r9_r0"},
     {{mi, r9, r1}, true, mi, "mi r9 r1", "mi_r9_r1"},
     {{mi, r9, r2}, true, mi, "mi r9 r2", "mi_r9_r2"},
     {{mi, r9, r3}, true, mi, "mi r9 r3", "mi_r9_r3"},
     {{mi, r9, r4}, true, mi, "mi r9 r4", "mi_r9_r4"},
     {{mi, r9, r5}, true, mi, "mi r9 r5", "mi_r9_r5"},
     {{mi, r9, r6}, true, mi, "mi r9 r6", "mi_r9_r6"},
     {{mi, r9, r7}, true, mi, "mi r9 r7", "mi_r9_r7"},
     {{mi, r9, r8}, true, mi, "mi r9 r8", "mi_r9_r8"},
     {{mi, r9, r9}, true, mi, "mi r9 r9", "mi_r9_r9"},
     {{mi, r9, r10}, true, mi, "mi r9 r10", "mi_r9_r10"},
     {{mi, r9, r11}, true, mi, "mi r9 r11", "mi_r9_r11"},
     {{mi, r9, r12}, true, mi, "mi r9 r12", "mi_r9_r12"},
     {{mi, r9, r13}, true, mi, "mi r9 r13", "mi_r9_r13"},
     {{mi, r9, r14}, true, mi, "mi r9 r14", "mi_r9_r14"},
     {{mi, r10, r0}, true, mi, "mi r10 r0", "mi_r10_r0"},
     {{mi, r10, r1}, true, mi, "mi r10 r1", "mi_r10_r1"},
     {{mi, r10, r2}, true, mi, "mi r10 r2", "mi_r10_r2"},
     {{mi, r10, r3}, true, mi, "mi r10 r3", "mi_r10_r3"},
     {{mi, r10, r4}, true, mi, "mi r10 r4", "mi_r10_r4"},
     {{mi, r10, r5}, true, mi, "mi r10 r5", "mi_r10_r5"},
     {{mi, r10, r6}, true, mi, "mi r10 r6", "mi_r10_r6"},
     {{mi, r10, r7}, true, mi, "mi r10 r7", "mi_r10_r7"},
     {{mi, r10, r8}, true, mi, "mi r10 r8", "mi_r10_r8"},
     {{mi, r10, r9}, true, mi, "mi r10 r9", "mi_r10_r9"},
     {{mi, r10, r10}, true, mi, "mi r10 r10", "mi_r10_r10"},
     {{mi, r10, r11}, true, mi, "mi r10 r11", "mi_r10_r11"},
     {{mi, r10, r12}, true, mi, "mi r10 r12", "mi_r10_r12"},
     {{mi, r10, r13}, true, mi, "mi r10 r13", "mi_r10_r13"},
     {{mi, r10, r14}, true, mi, "mi r10 r14", "mi_r10_r14"},
     {{mi, r11, r0}, true, mi, "mi r11 r0", "mi_r11_r0"},
     {{mi, r11, r1}, true, mi, "mi r11 r1", "mi_r11_r1"},
     {{mi, r11, r2}, true, mi, "mi r11 r2", "mi_r11_r2"},
     {{mi, r11, r3}, true, mi, "mi r11 r3", "mi_r11_r3"},
     {{mi, r11, r4}, true, mi, "mi r11 r4", "mi_r11_r4"},
     {{mi, r11, r5}, true, mi, "mi r11 r5", "mi_r11_r5"},
     {{mi, r11, r6}, true, mi, "mi r11 r6", "mi_r11_r6"},
     {{mi, r11, r7}, true, mi, "mi r11 r7", "mi_r11_r7"},
     {{mi, r11, r8}, true, mi, "mi r11 r8", "mi_r11_r8"},
     {{mi, r11, r9}, true, mi, "mi r11 r9", "mi_r11_r9"},
     {{mi, r11, r10}, true, mi, "mi r11 r10", "mi_r11_r10"},
     {{mi, r11, r11}, true, mi, "mi r11 r11", "mi_r11_r11"},
     {{mi, r11, r12}, true, mi, "mi r11 r12", "mi_r11_r12"},
     {{mi, r11, r13}, true, mi, "mi r11 r13", "mi_r11_r13"},
     {{mi, r11, r14}, true, mi, "mi r11 r14", "mi_r11_r14"},
     {{mi, r12, r0}, true, mi, "mi r12 r0", "mi_r12_r0"},
     {{mi, r12, r1}, true, mi, "mi r12 r1", "mi_r12_r1"},
     {{mi, r12, r2}, true, mi, "mi r12 r2", "mi_r12_r2"},
     {{mi, r12, r3}, true, mi, "mi r12 r3", "mi_r12_r3"},
     {{mi, r12, r4}, true, mi, "mi r12 r4", "mi_r12_r4"},
     {{mi, r12, r5}, true, mi, "mi r12 r5", "mi_r12_r5"},
     {{mi, r12, r6}, true, mi, "mi r12 r6", "mi_r12_r6"},
     {{mi, r12, r7}, true, mi, "mi r12 r7", "mi_r12_r7"},
     {{mi, r12, r8}, true, mi, "mi r12 r8", "mi_r12_r8"},
     {{mi, r12, r9}, true, mi, "mi r12 r9", "mi_r12_r9"},
     {{mi, r12, r10}, true, mi, "mi r12 r10", "mi_r12_r10"},
     {{mi, r12, r11}, true, mi, "mi r12 r11", "mi_r12_r11"},
     {{mi, r12, r12}, true, mi, "mi r12 r12", "mi_r12_r12"},
     {{mi, r12, r13}, true, mi, "mi r12 r13", "mi_r12_r13"},
     {{mi, r12, r14}, true, mi, "mi r12 r14", "mi_r12_r14"},
     {{mi, r13, r0}, true, mi, "mi r13 r0", "mi_r13_r0"},
     {{mi, r13, r1}, true, mi, "mi r13 r1", "mi_r13_r1"},
     {{mi, r13, r2}, true, mi, "mi r13 r2", "mi_r13_r2"},
     {{mi, r13, r3}, true, mi, "mi r13 r3", "mi_r13_r3"},
     {{mi, r13, r4}, true, mi, "mi r13 r4", "mi_r13_r4"},
     {{mi, r13, r5}, true, mi, "mi r13 r5", "mi_r13_r5"},
     {{mi, r13, r6}, true, mi, "mi r13 r6", "mi_r13_r6"},
     {{mi, r13, r7}, true, mi, "mi r13 r7", "mi_r13_r7"},
     {{mi, r13, r8}, true, mi, "mi r13 r8", "mi_r13_r8"},
     {{mi, r13, r9}, true, mi, "mi r13 r9", "mi_r13_r9"},
     {{mi, r13, r10}, true, mi, "mi r13 r10", "mi_r13_r10"},
     {{mi, r13, r11}, true, mi, "mi r13 r11", "mi_r13_r11"},
     {{mi, r13, r12}, true, mi, "mi r13 r12", "mi_r13_r12"},
     {{mi, r13, r13}, true, mi, "mi r13 r13", "mi_r13_r13"},
     {{mi, r13, r14}, true, mi, "mi r13 r14", "mi_r13_r14"},
     {{mi, r14, r0}, true, mi, "mi r14 r0", "mi_r14_r0"},
     {{mi, r14, r1}, true, mi, "mi r14 r1", "mi_r14_r1"},
     {{mi, r14, r2}, true, mi, "mi r14 r2", "mi_r14_r2"},
     {{mi, r14, r3}, true, mi, "mi r14 r3", "mi_r14_r3"},
     {{mi, r14, r4}, true, mi, "mi r14 r4", "mi_r14_r4"},
     {{mi, r14, r5}, true, mi, "mi r14 r5", "mi_r14_r5"},
     {{mi, r14, r6}, true, mi, "mi r14 r6", "mi_r14_r6"},
     {{mi, r14, r7}, true, mi, "mi r14 r7", "mi_r14_r7"},
     {{mi, r14, r8}, true, mi, "mi r14 r8", "mi_r14_r8"},
     {{mi, r14, r9}, true, mi, "mi r14 r9", "mi_r14_r9"},
     {{mi, r14, r10}, true, mi, "mi r14 r10", "mi_r14_r10"},
     {{mi, r14, r11}, true, mi, "mi r14 r11", "mi_r14_r11"},
     {{mi, r14, r12}, true, mi, "mi r14 r12", "mi_r14_r12"},
     {{mi, r14, r13}, true, mi, "mi r14 r13", "mi_r14_r13"},
     {{mi, r14, r14}, true, mi, "mi r14 r14", "mi_r14_r14"},
     {{pl, r0, r0}, true, pl, "pl r0 r0", "pl_r0_r0"},
     {{pl, r0, r1}, true, pl, "pl r0 r1", "pl_r0_r1"},
     {{pl, r0, r2}, true, pl, "pl r0 r2", "pl_r0_r2"},
     {{pl, r0, r3}, true, pl, "pl r0 r3", "pl_r0_r3"},
     {{pl, r0, r4}, true, pl, "pl r0 r4", "pl_r0_r4"},
     {{pl, r0, r5}, true, pl, "pl r0 r5", "pl_r0_r5"},
     {{pl, r0, r6}, true, pl, "pl r0 r6", "pl_r0_r6"},
     {{pl, r0, r7}, true, pl, "pl r0 r7", "pl_r0_r7"},
     {{pl, r0, r8}, true, pl, "pl r0 r8", "pl_r0_r8"},
     {{pl, r0, r9}, true, pl, "pl r0 r9", "pl_r0_r9"},
     {{pl, r0, r10}, true, pl, "pl r0 r10", "pl_r0_r10"},
     {{pl, r0, r11}, true, pl, "pl r0 r11", "pl_r0_r11"},
     {{pl, r0, r12}, true, pl, "pl r0 r12", "pl_r0_r12"},
     {{pl, r0, r13}, true, pl, "pl r0 r13", "pl_r0_r13"},
     {{pl, r0, r14}, true, pl, "pl r0 r14", "pl_r0_r14"},
     {{pl, r1, r0}, true, pl, "pl r1 r0", "pl_r1_r0"},
     {{pl, r1, r1}, true, pl, "pl r1 r1", "pl_r1_r1"},
     {{pl, r1, r2}, true, pl, "pl r1 r2", "pl_r1_r2"},
     {{pl, r1, r3}, true, pl, "pl r1 r3", "pl_r1_r3"},
     {{pl, r1, r4}, true, pl, "pl r1 r4", "pl_r1_r4"},
     {{pl, r1, r5}, true, pl, "pl r1 r5", "pl_r1_r5"},
     {{pl, r1, r6}, true, pl, "pl r1 r6", "pl_r1_r6"},
     {{pl, r1, r7}, true, pl, "pl r1 r7", "pl_r1_r7"},
     {{pl, r1, r8}, true, pl, "pl r1 r8", "pl_r1_r8"},
     {{pl, r1, r9}, true, pl, "pl r1 r9", "pl_r1_r9"},
     {{pl, r1, r10}, true, pl, "pl r1 r10", "pl_r1_r10"},
     {{pl, r1, r11}, true, pl, "pl r1 r11", "pl_r1_r11"},
     {{pl, r1, r12}, true, pl, "pl r1 r12", "pl_r1_r12"},
     {{pl, r1, r13}, true, pl, "pl r1 r13", "pl_r1_r13"},
     {{pl, r1, r14}, true, pl, "pl r1 r14", "pl_r1_r14"},
     {{pl, r2, r0}, true, pl, "pl r2 r0", "pl_r2_r0"},
     {{pl, r2, r1}, true, pl, "pl r2 r1", "pl_r2_r1"},
     {{pl, r2, r2}, true, pl, "pl r2 r2", "pl_r2_r2"},
     {{pl, r2, r3}, true, pl, "pl r2 r3", "pl_r2_r3"},
     {{pl, r2, r4}, true, pl, "pl r2 r4", "pl_r2_r4"},
     {{pl, r2, r5}, true, pl, "pl r2 r5", "pl_r2_r5"},
     {{pl, r2, r6}, true, pl, "pl r2 r6", "pl_r2_r6"},
     {{pl, r2, r7}, true, pl, "pl r2 r7", "pl_r2_r7"},
     {{pl, r2, r8}, true, pl, "pl r2 r8", "pl_r2_r8"},
     {{pl, r2, r9}, true, pl, "pl r2 r9", "pl_r2_r9"},
     {{pl, r2, r10}, true, pl, "pl r2 r10", "pl_r2_r10"},
     {{pl, r2, r11}, true, pl, "pl r2 r11", "pl_r2_r11"},
     {{pl, r2, r12}, true, pl, "pl r2 r12", "pl_r2_r12"},
     {{pl, r2, r13}, true, pl, "pl r2 r13", "pl_r2_r13"},
     {{pl, r2, r14}, true, pl, "pl r2 r14", "pl_r2_r14"},
     {{pl, r3, r0}, true, pl, "pl r3 r0", "pl_r3_r0"},
     {{pl, r3, r1}, true, pl, "pl r3 r1", "pl_r3_r1"},
     {{pl, r3, r2}, true, pl, "pl r3 r2", "pl_r3_r2"},
     {{pl, r3, r3}, true, pl, "pl r3 r3", "pl_r3_r3"},
     {{pl, r3, r4}, true, pl, "pl r3 r4", "pl_r3_r4"},
     {{pl, r3, r5}, true, pl, "pl r3 r5", "pl_r3_r5"},
     {{pl, r3, r6}, true, pl, "pl r3 r6", "pl_r3_r6"},
     {{pl, r3, r7}, true, pl, "pl r3 r7", "pl_r3_r7"},
     {{pl, r3, r8}, true, pl, "pl r3 r8", "pl_r3_r8"},
     {{pl, r3, r9}, true, pl, "pl r3 r9", "pl_r3_r9"},
     {{pl, r3, r10}, true, pl, "pl r3 r10", "pl_r3_r10"},
     {{pl, r3, r11}, true, pl, "pl r3 r11", "pl_r3_r11"},
     {{pl, r3, r12}, true, pl, "pl r3 r12", "pl_r3_r12"},
     {{pl, r3, r13}, true, pl, "pl r3 r13", "pl_r3_r13"},
     {{pl, r3, r14}, true, pl, "pl r3 r14", "pl_r3_r14"},
     {{pl, r4, r0}, true, pl, "pl r4 r0", "pl_r4_r0"},
     {{pl, r4, r1}, true, pl, "pl r4 r1", "pl_r4_r1"},
     {{pl, r4, r2}, true, pl, "pl r4 r2", "pl_r4_r2"},
     {{pl, r4, r3}, true, pl, "pl r4 r3", "pl_r4_r3"},
     {{pl, r4, r4}, true, pl, "pl r4 r4", "pl_r4_r4"},
     {{pl, r4, r5}, true, pl, "pl r4 r5", "pl_r4_r5"},
     {{pl, r4, r6}, true, pl, "pl r4 r6", "pl_r4_r6"},
     {{pl, r4, r7}, true, pl, "pl r4 r7", "pl_r4_r7"},
     {{pl, r4, r8}, true, pl, "pl r4 r8", "pl_r4_r8"},
     {{pl, r4, r9}, true, pl, "pl r4 r9", "pl_r4_r9"},
     {{pl, r4, r10}, true, pl, "pl r4 r10", "pl_r4_r10"},
     {{pl, r4, r11}, true, pl, "pl r4 r11", "pl_r4_r11"},
     {{pl, r4, r12}, true, pl, "pl r4 r12", "pl_r4_r12"},
     {{pl, r4, r13}, true, pl, "pl r4 r13", "pl_r4_r13"},
     {{pl, r4, r14}, true, pl, "pl r4 r14", "pl_r4_r14"},
     {{pl, r5, r0}, true, pl, "pl r5 r0", "pl_r5_r0"},
     {{pl, r5, r1}, true, pl, "pl r5 r1", "pl_r5_r1"},
     {{pl, r5, r2}, true, pl, "pl r5 r2", "pl_r5_r2"},
     {{pl, r5, r3}, true, pl, "pl r5 r3", "pl_r5_r3"},
     {{pl, r5, r4}, true, pl, "pl r5 r4", "pl_r5_r4"},
     {{pl, r5, r5}, true, pl, "pl r5 r5", "pl_r5_r5"},
     {{pl, r5, r6}, true, pl, "pl r5 r6", "pl_r5_r6"},
     {{pl, r5, r7}, true, pl, "pl r5 r7", "pl_r5_r7"},
     {{pl, r5, r8}, true, pl, "pl r5 r8", "pl_r5_r8"},
     {{pl, r5, r9}, true, pl, "pl r5 r9", "pl_r5_r9"},
     {{pl, r5, r10}, true, pl, "pl r5 r10", "pl_r5_r10"},
     {{pl, r5, r11}, true, pl, "pl r5 r11", "pl_r5_r11"},
     {{pl, r5, r12}, true, pl, "pl r5 r12", "pl_r5_r12"},
     {{pl, r5, r13}, true, pl, "pl r5 r13", "pl_r5_r13"},
     {{pl, r5, r14}, true, pl, "pl r5 r14", "pl_r5_r14"},
     {{pl, r6, r0}, true, pl, "pl r6 r0", "pl_r6_r0"},
     {{pl, r6, r1}, true, pl, "pl r6 r1", "pl_r6_r1"},
     {{pl, r6, r2}, true, pl, "pl r6 r2", "pl_r6_r2"},
     {{pl, r6, r3}, true, pl, "pl r6 r3", "pl_r6_r3"},
     {{pl, r6, r4}, true, pl, "pl r6 r4", "pl_r6_r4"},
     {{pl, r6, r5}, true, pl, "pl r6 r5", "pl_r6_r5"},
     {{pl, r6, r6}, true, pl, "pl r6 r6", "pl_r6_r6"},
     {{pl, r6, r7}, true, pl, "pl r6 r7", "pl_r6_r7"},
     {{pl, r6, r8}, true, pl, "pl r6 r8", "pl_r6_r8"},
     {{pl, r6, r9}, true, pl, "pl r6 r9", "pl_r6_r9"},
     {{pl, r6, r10}, true, pl, "pl r6 r10", "pl_r6_r10"},
     {{pl, r6, r11}, true, pl, "pl r6 r11", "pl_r6_r11"},
     {{pl, r6, r12}, true, pl, "pl r6 r12", "pl_r6_r12"},
     {{pl, r6, r13}, true, pl, "pl r6 r13", "pl_r6_r13"},
     {{pl, r6, r14}, true, pl, "pl r6 r14", "pl_r6_r14"},
     {{pl, r7, r0}, true, pl, "pl r7 r0", "pl_r7_r0"},
     {{pl, r7, r1}, true, pl, "pl r7 r1", "pl_r7_r1"},
     {{pl, r7, r2}, true, pl, "pl r7 r2", "pl_r7_r2"},
     {{pl, r7, r3}, true, pl, "pl r7 r3", "pl_r7_r3"},
     {{pl, r7, r4}, true, pl, "pl r7 r4", "pl_r7_r4"},
     {{pl, r7, r5}, true, pl, "pl r7 r5", "pl_r7_r5"},
     {{pl, r7, r6}, true, pl, "pl r7 r6", "pl_r7_r6"},
     {{pl, r7, r7}, true, pl, "pl r7 r7", "pl_r7_r7"},
     {{pl, r7, r8}, true, pl, "pl r7 r8", "pl_r7_r8"},
     {{pl, r7, r9}, true, pl, "pl r7 r9", "pl_r7_r9"},
     {{pl, r7, r10}, true, pl, "pl r7 r10", "pl_r7_r10"},
     {{pl, r7, r11}, true, pl, "pl r7 r11", "pl_r7_r11"},
     {{pl, r7, r12}, true, pl, "pl r7 r12", "pl_r7_r12"},
     {{pl, r7, r13}, true, pl, "pl r7 r13", "pl_r7_r13"},
     {{pl, r7, r14}, true, pl, "pl r7 r14", "pl_r7_r14"},
     {{pl, r8, r0}, true, pl, "pl r8 r0", "pl_r8_r0"},
     {{pl, r8, r1}, true, pl, "pl r8 r1", "pl_r8_r1"},
     {{pl, r8, r2}, true, pl, "pl r8 r2", "pl_r8_r2"},
     {{pl, r8, r3}, true, pl, "pl r8 r3", "pl_r8_r3"},
     {{pl, r8, r4}, true, pl, "pl r8 r4", "pl_r8_r4"},
     {{pl, r8, r5}, true, pl, "pl r8 r5", "pl_r8_r5"},
     {{pl, r8, r6}, true, pl, "pl r8 r6", "pl_r8_r6"},
     {{pl, r8, r7}, true, pl, "pl r8 r7", "pl_r8_r7"},
     {{pl, r8, r8}, true, pl, "pl r8 r8", "pl_r8_r8"},
     {{pl, r8, r9}, true, pl, "pl r8 r9", "pl_r8_r9"},
     {{pl, r8, r10}, true, pl, "pl r8 r10", "pl_r8_r10"},
     {{pl, r8, r11}, true, pl, "pl r8 r11", "pl_r8_r11"},
     {{pl, r8, r12}, true, pl, "pl r8 r12", "pl_r8_r12"},
     {{pl, r8, r13}, true, pl, "pl r8 r13", "pl_r8_r13"},
     {{pl, r8, r14}, true, pl, "pl r8 r14", "pl_r8_r14"},
     {{pl, r9, r0}, true, pl, "pl r9 r0", "pl_r9_r0"},
     {{pl, r9, r1}, true, pl, "pl r9 r1", "pl_r9_r1"},
     {{pl, r9, r2}, true, pl, "pl r9 r2", "pl_r9_r2"},
     {{pl, r9, r3}, true, pl, "pl r9 r3", "pl_r9_r3"},
     {{pl, r9, r4}, true, pl, "pl r9 r4", "pl_r9_r4"},
     {{pl, r9, r5}, true, pl, "pl r9 r5", "pl_r9_r5"},
     {{pl, r9, r6}, true, pl, "pl r9 r6", "pl_r9_r6"},
     {{pl, r9, r7}, true, pl, "pl r9 r7", "pl_r9_r7"},
     {{pl, r9, r8}, true, pl, "pl r9 r8", "pl_r9_r8"},
     {{pl, r9, r9}, true, pl, "pl r9 r9", "pl_r9_r9"},
     {{pl, r9, r10}, true, pl, "pl r9 r10", "pl_r9_r10"},
     {{pl, r9, r11}, true, pl, "pl r9 r11", "pl_r9_r11"},
     {{pl, r9, r12}, true, pl, "pl r9 r12", "pl_r9_r12"},
     {{pl, r9, r13}, true, pl, "pl r9 r13", "pl_r9_r13"},
     {{pl, r9, r14}, true, pl, "pl r9 r14", "pl_r9_r14"},
     {{pl, r10, r0}, true, pl, "pl r10 r0", "pl_r10_r0"},
     {{pl, r10, r1}, true, pl, "pl r10 r1", "pl_r10_r1"},
     {{pl, r10, r2}, true, pl, "pl r10 r2", "pl_r10_r2"},
     {{pl, r10, r3}, true, pl, "pl r10 r3", "pl_r10_r3"},
     {{pl, r10, r4}, true, pl, "pl r10 r4", "pl_r10_r4"},
     {{pl, r10, r5}, true, pl, "pl r10 r5", "pl_r10_r5"},
     {{pl, r10, r6}, true, pl, "pl r10 r6", "pl_r10_r6"},
     {{pl, r10, r7}, true, pl, "pl r10 r7", "pl_r10_r7"},
     {{pl, r10, r8}, true, pl, "pl r10 r8", "pl_r10_r8"},
     {{pl, r10, r9}, true, pl, "pl r10 r9", "pl_r10_r9"},
     {{pl, r10, r10}, true, pl, "pl r10 r10", "pl_r10_r10"},
     {{pl, r10, r11}, true, pl, "pl r10 r11", "pl_r10_r11"},
     {{pl, r10, r12}, true, pl, "pl r10 r12", "pl_r10_r12"},
     {{pl, r10, r13}, true, pl, "pl r10 r13", "pl_r10_r13"},
     {{pl, r10, r14}, true, pl, "pl r10 r14", "pl_r10_r14"},
     {{pl, r11, r0}, true, pl, "pl r11 r0", "pl_r11_r0"},
     {{pl, r11, r1}, true, pl, "pl r11 r1", "pl_r11_r1"},
     {{pl, r11, r2}, true, pl, "pl r11 r2", "pl_r11_r2"},
     {{pl, r11, r3}, true, pl, "pl r11 r3", "pl_r11_r3"},
     {{pl, r11, r4}, true, pl, "pl r11 r4", "pl_r11_r4"},
     {{pl, r11, r5}, true, pl, "pl r11 r5", "pl_r11_r5"},
     {{pl, r11, r6}, true, pl, "pl r11 r6", "pl_r11_r6"},
     {{pl, r11, r7}, true, pl, "pl r11 r7", "pl_r11_r7"},
     {{pl, r11, r8}, true, pl, "pl r11 r8", "pl_r11_r8"},
     {{pl, r11, r9}, true, pl, "pl r11 r9", "pl_r11_r9"},
     {{pl, r11, r10}, true, pl, "pl r11 r10", "pl_r11_r10"},
     {{pl, r11, r11}, true, pl, "pl r11 r11", "pl_r11_r11"},
     {{pl, r11, r12}, true, pl, "pl r11 r12", "pl_r11_r12"},
     {{pl, r11, r13}, true, pl, "pl r11 r13", "pl_r11_r13"},
     {{pl, r11, r14}, true, pl, "pl r11 r14", "pl_r11_r14"},
     {{pl, r12, r0}, true, pl, "pl r12 r0", "pl_r12_r0"},
     {{pl, r12, r1}, true, pl, "pl r12 r1", "pl_r12_r1"},
     {{pl, r12, r2}, true, pl, "pl r12 r2", "pl_r12_r2"},
     {{pl, r12, r3}, true, pl, "pl r12 r3", "pl_r12_r3"},
     {{pl, r12, r4}, true, pl, "pl r12 r4", "pl_r12_r4"},
     {{pl, r12, r5}, true, pl, "pl r12 r5", "pl_r12_r5"},
     {{pl, r12, r6}, true, pl, "pl r12 r6", "pl_r12_r6"},
     {{pl, r12, r7}, true, pl, "pl r12 r7", "pl_r12_r7"},
     {{pl, r12, r8}, true, pl, "pl r12 r8", "pl_r12_r8"},
     {{pl, r12, r9}, true, pl, "pl r12 r9", "pl_r12_r9"},
     {{pl, r12, r10}, true, pl, "pl r12 r10", "pl_r12_r10"},
     {{pl, r12, r11}, true, pl, "pl r12 r11", "pl_r12_r11"},
     {{pl, r12, r12}, true, pl, "pl r12 r12", "pl_r12_r12"},
     {{pl, r12, r13}, true, pl, "pl r12 r13", "pl_r12_r13"},
     {{pl, r12, r14}, true, pl, "pl r12 r14", "pl_r12_r14"},
     {{pl, r13, r0}, true, pl, "pl r13 r0", "pl_r13_r0"},
     {{pl, r13, r1}, true, pl, "pl r13 r1", "pl_r13_r1"},
     {{pl, r13, r2}, true, pl, "pl r13 r2", "pl_r13_r2"},
     {{pl, r13, r3}, true, pl, "pl r13 r3", "pl_r13_r3"},
     {{pl, r13, r4}, true, pl, "pl r13 r4", "pl_r13_r4"},
     {{pl, r13, r5}, true, pl, "pl r13 r5", "pl_r13_r5"},
     {{pl, r13, r6}, true, pl, "pl r13 r6", "pl_r13_r6"},
     {{pl, r13, r7}, true, pl, "pl r13 r7", "pl_r13_r7"},
     {{pl, r13, r8}, true, pl, "pl r13 r8", "pl_r13_r8"},
     {{pl, r13, r9}, true, pl, "pl r13 r9", "pl_r13_r9"},
     {{pl, r13, r10}, true, pl, "pl r13 r10", "pl_r13_r10"},
     {{pl, r13, r11}, true, pl, "pl r13 r11", "pl_r13_r11"},
     {{pl, r13, r12}, true, pl, "pl r13 r12", "pl_r13_r12"},
     {{pl, r13, r13}, true, pl, "pl r13 r13", "pl_r13_r13"},
     {{pl, r13, r14}, true, pl, "pl r13 r14", "pl_r13_r14"},
     {{pl, r14, r0}, true, pl, "pl r14 r0", "pl_r14_r0"},
     {{pl, r14, r1}, true, pl, "pl r14 r1", "pl_r14_r1"},
     {{pl, r14, r2}, true, pl, "pl r14 r2", "pl_r14_r2"},
     {{pl, r14, r3}, true, pl, "pl r14 r3", "pl_r14_r3"},
     {{pl, r14, r4}, true, pl, "pl r14 r4", "pl_r14_r4"},
     {{pl, r14, r5}, true, pl, "pl r14 r5", "pl_r14_r5"},
     {{pl, r14, r6}, true, pl, "pl r14 r6", "pl_r14_r6"},
     {{pl, r14, r7}, true, pl, "pl r14 r7", "pl_r14_r7"},
     {{pl, r14, r8}, true, pl, "pl r14 r8", "pl_r14_r8"},
     {{pl, r14, r9}, true, pl, "pl r14 r9", "pl_r14_r9"},
     {{pl, r14, r10}, true, pl, "pl r14 r10", "pl_r14_r10"},
     {{pl, r14, r11}, true, pl, "pl r14 r11", "pl_r14_r11"},
     {{pl, r14, r12}, true, pl, "pl r14 r12", "pl_r14_r12"},
     {{pl, r14, r13}, true, pl, "pl r14 r13", "pl_r14_r13"},
     {{pl, r14, r14}, true, pl, "pl r14 r14", "pl_r14_r14"},
     {{vs, r0, r0}, true, vs, "vs r0 r0", "vs_r0_r0"},
     {{vs, r0, r1}, true, vs, "vs r0 r1", "vs_r0_r1"},
     {{vs, r0, r2}, true, vs, "vs r0 r2", "vs_r0_r2"},
     {{vs, r0, r3}, true, vs, "vs r0 r3", "vs_r0_r3"},
     {{vs, r0, r4}, true, vs, "vs r0 r4", "vs_r0_r4"},
     {{vs, r0, r5}, true, vs, "vs r0 r5", "vs_r0_r5"},
     {{vs, r0, r6}, true, vs, "vs r0 r6", "vs_r0_r6"},
     {{vs, r0, r7}, true, vs, "vs r0 r7", "vs_r0_r7"},
     {{vs, r0, r8}, true, vs, "vs r0 r8", "vs_r0_r8"},
     {{vs, r0, r9}, true, vs, "vs r0 r9", "vs_r0_r9"},
     {{vs, r0, r10}, true, vs, "vs r0 r10", "vs_r0_r10"},
     {{vs, r0, r11}, true, vs, "vs r0 r11", "vs_r0_r11"},
     {{vs, r0, r12}, true, vs, "vs r0 r12", "vs_r0_r12"},
     {{vs, r0, r13}, true, vs, "vs r0 r13", "vs_r0_r13"},
     {{vs, r0, r14}, true, vs, "vs r0 r14", "vs_r0_r14"},
     {{vs, r1, r0}, true, vs, "vs r1 r0", "vs_r1_r0"},
     {{vs, r1, r1}, true, vs, "vs r1 r1", "vs_r1_r1"},
     {{vs, r1, r2}, true, vs, "vs r1 r2", "vs_r1_r2"},
     {{vs, r1, r3}, true, vs, "vs r1 r3", "vs_r1_r3"},
     {{vs, r1, r4}, true, vs, "vs r1 r4", "vs_r1_r4"},
     {{vs, r1, r5}, true, vs, "vs r1 r5", "vs_r1_r5"},
     {{vs, r1, r6}, true, vs, "vs r1 r6", "vs_r1_r6"},
     {{vs, r1, r7}, true, vs, "vs r1 r7", "vs_r1_r7"},
     {{vs, r1, r8}, true, vs, "vs r1 r8", "vs_r1_r8"},
     {{vs, r1, r9}, true, vs, "vs r1 r9", "vs_r1_r9"},
     {{vs, r1, r10}, true, vs, "vs r1 r10", "vs_r1_r10"},
     {{vs, r1, r11}, true, vs, "vs r1 r11", "vs_r1_r11"},
     {{vs, r1, r12}, true, vs, "vs r1 r12", "vs_r1_r12"},
     {{vs, r1, r13}, true, vs, "vs r1 r13", "vs_r1_r13"},
     {{vs, r1, r14}, true, vs, "vs r1 r14", "vs_r1_r14"},
     {{vs, r2, r0}, true, vs, "vs r2 r0", "vs_r2_r0"},
     {{vs, r2, r1}, true, vs, "vs r2 r1", "vs_r2_r1"},
     {{vs, r2, r2}, true, vs, "vs r2 r2", "vs_r2_r2"},
     {{vs, r2, r3}, true, vs, "vs r2 r3", "vs_r2_r3"},
     {{vs, r2, r4}, true, vs, "vs r2 r4", "vs_r2_r4"},
     {{vs, r2, r5}, true, vs, "vs r2 r5", "vs_r2_r5"},
     {{vs, r2, r6}, true, vs, "vs r2 r6", "vs_r2_r6"},
     {{vs, r2, r7}, true, vs, "vs r2 r7", "vs_r2_r7"},
     {{vs, r2, r8}, true, vs, "vs r2 r8", "vs_r2_r8"},
     {{vs, r2, r9}, true, vs, "vs r2 r9", "vs_r2_r9"},
     {{vs, r2, r10}, true, vs, "vs r2 r10", "vs_r2_r10"},
     {{vs, r2, r11}, true, vs, "vs r2 r11", "vs_r2_r11"},
     {{vs, r2, r12}, true, vs, "vs r2 r12", "vs_r2_r12"},
     {{vs, r2, r13}, true, vs, "vs r2 r13", "vs_r2_r13"},
     {{vs, r2, r14}, true, vs, "vs r2 r14", "vs_r2_r14"},
     {{vs, r3, r0}, true, vs, "vs r3 r0", "vs_r3_r0"},
     {{vs, r3, r1}, true, vs, "vs r3 r1", "vs_r3_r1"},
     {{vs, r3, r2}, true, vs, "vs r3 r2", "vs_r3_r2"},
     {{vs, r3, r3}, true, vs, "vs r3 r3", "vs_r3_r3"},
     {{vs, r3, r4}, true, vs, "vs r3 r4", "vs_r3_r4"},
     {{vs, r3, r5}, true, vs, "vs r3 r5", "vs_r3_r5"},
     {{vs, r3, r6}, true, vs, "vs r3 r6", "vs_r3_r6"},
     {{vs, r3, r7}, true, vs, "vs r3 r7", "vs_r3_r7"},
     {{vs, r3, r8}, true, vs, "vs r3 r8", "vs_r3_r8"},
     {{vs, r3, r9}, true, vs, "vs r3 r9", "vs_r3_r9"},
     {{vs, r3, r10}, true, vs, "vs r3 r10", "vs_r3_r10"},
     {{vs, r3, r11}, true, vs, "vs r3 r11", "vs_r3_r11"},
     {{vs, r3, r12}, true, vs, "vs r3 r12", "vs_r3_r12"},
     {{vs, r3, r13}, true, vs, "vs r3 r13", "vs_r3_r13"},
     {{vs, r3, r14}, true, vs, "vs r3 r14", "vs_r3_r14"},
     {{vs, r4, r0}, true, vs, "vs r4 r0", "vs_r4_r0"},
     {{vs, r4, r1}, true, vs, "vs r4 r1", "vs_r4_r1"},
     {{vs, r4, r2}, true, vs, "vs r4 r2", "vs_r4_r2"},
     {{vs, r4, r3}, true, vs, "vs r4 r3", "vs_r4_r3"},
     {{vs, r4, r4}, true, vs, "vs r4 r4", "vs_r4_r4"},
     {{vs, r4, r5}, true, vs, "vs r4 r5", "vs_r4_r5"},
     {{vs, r4, r6}, true, vs, "vs r4 r6", "vs_r4_r6"},
     {{vs, r4, r7}, true, vs, "vs r4 r7", "vs_r4_r7"},
     {{vs, r4, r8}, true, vs, "vs r4 r8", "vs_r4_r8"},
     {{vs, r4, r9}, true, vs, "vs r4 r9", "vs_r4_r9"},
     {{vs, r4, r10}, true, vs, "vs r4 r10", "vs_r4_r10"},
     {{vs, r4, r11}, true, vs, "vs r4 r11", "vs_r4_r11"},
     {{vs, r4, r12}, true, vs, "vs r4 r12", "vs_r4_r12"},
     {{vs, r4, r13}, true, vs, "vs r4 r13", "vs_r4_r13"},
     {{vs, r4, r14}, true, vs, "vs r4 r14", "vs_r4_r14"},
     {{vs, r5, r0}, true, vs, "vs r5 r0", "vs_r5_r0"},
     {{vs, r5, r1}, true, vs, "vs r5 r1", "vs_r5_r1"},
     {{vs, r5, r2}, true, vs, "vs r5 r2", "vs_r5_r2"},
     {{vs, r5, r3}, true, vs, "vs r5 r3", "vs_r5_r3"},
     {{vs, r5, r4}, true, vs, "vs r5 r4", "vs_r5_r4"},
     {{vs, r5, r5}, true, vs, "vs r5 r5", "vs_r5_r5"},
     {{vs, r5, r6}, true, vs, "vs r5 r6", "vs_r5_r6"},
     {{vs, r5, r7}, true, vs, "vs r5 r7", "vs_r5_r7"},
     {{vs, r5, r8}, true, vs, "vs r5 r8", "vs_r5_r8"},
     {{vs, r5, r9}, true, vs, "vs r5 r9", "vs_r5_r9"},
     {{vs, r5, r10}, true, vs, "vs r5 r10", "vs_r5_r10"},
     {{vs, r5, r11}, true, vs, "vs r5 r11", "vs_r5_r11"},
     {{vs, r5, r12}, true, vs, "vs r5 r12", "vs_r5_r12"},
     {{vs, r5, r13}, true, vs, "vs r5 r13", "vs_r5_r13"},
     {{vs, r5, r14}, true, vs, "vs r5 r14", "vs_r5_r14"},
     {{vs, r6, r0}, true, vs, "vs r6 r0", "vs_r6_r0"},
     {{vs, r6, r1}, true, vs, "vs r6 r1", "vs_r6_r1"},
     {{vs, r6, r2}, true, vs, "vs r6 r2", "vs_r6_r2"},
     {{vs, r6, r3}, true, vs, "vs r6 r3", "vs_r6_r3"},
     {{vs, r6, r4}, true, vs, "vs r6 r4", "vs_r6_r4"},
     {{vs, r6, r5}, true, vs, "vs r6 r5", "vs_r6_r5"},
     {{vs, r6, r6}, true, vs, "vs r6 r6", "vs_r6_r6"},
     {{vs, r6, r7}, true, vs, "vs r6 r7", "vs_r6_r7"},
     {{vs, r6, r8}, true, vs, "vs r6 r8", "vs_r6_r8"},
     {{vs, r6, r9}, true, vs, "vs r6 r9", "vs_r6_r9"},
     {{vs, r6, r10}, true, vs, "vs r6 r10", "vs_r6_r10"},
     {{vs, r6, r11}, true, vs, "vs r6 r11", "vs_r6_r11"},
     {{vs, r6, r12}, true, vs, "vs r6 r12", "vs_r6_r12"},
     {{vs, r6, r13}, true, vs, "vs r6 r13", "vs_r6_r13"},
     {{vs, r6, r14}, true, vs, "vs r6 r14", "vs_r6_r14"},
     {{vs, r7, r0}, true, vs, "vs r7 r0", "vs_r7_r0"},
     {{vs, r7, r1}, true, vs, "vs r7 r1", "vs_r7_r1"},
     {{vs, r7, r2}, true, vs, "vs r7 r2", "vs_r7_r2"},
     {{vs, r7, r3}, true, vs, "vs r7 r3", "vs_r7_r3"},
     {{vs, r7, r4}, true, vs, "vs r7 r4", "vs_r7_r4"},
     {{vs, r7, r5}, true, vs, "vs r7 r5", "vs_r7_r5"},
     {{vs, r7, r6}, true, vs, "vs r7 r6", "vs_r7_r6"},
     {{vs, r7, r7}, true, vs, "vs r7 r7", "vs_r7_r7"},
     {{vs, r7, r8}, true, vs, "vs r7 r8", "vs_r7_r8"},
     {{vs, r7, r9}, true, vs, "vs r7 r9", "vs_r7_r9"},
     {{vs, r7, r10}, true, vs, "vs r7 r10", "vs_r7_r10"},
     {{vs, r7, r11}, true, vs, "vs r7 r11", "vs_r7_r11"},
     {{vs, r7, r12}, true, vs, "vs r7 r12", "vs_r7_r12"},
     {{vs, r7, r13}, true, vs, "vs r7 r13", "vs_r7_r13"},
     {{vs, r7, r14}, true, vs, "vs r7 r14", "vs_r7_r14"},
     {{vs, r8, r0}, true, vs, "vs r8 r0", "vs_r8_r0"},
     {{vs, r8, r1}, true, vs, "vs r8 r1", "vs_r8_r1"},
     {{vs, r8, r2}, true, vs, "vs r8 r2", "vs_r8_r2"},
     {{vs, r8, r3}, true, vs, "vs r8 r3", "vs_r8_r3"},
     {{vs, r8, r4}, true, vs, "vs r8 r4", "vs_r8_r4"},
     {{vs, r8, r5}, true, vs, "vs r8 r5", "vs_r8_r5"},
     {{vs, r8, r6}, true, vs, "vs r8 r6", "vs_r8_r6"},
     {{vs, r8, r7}, true, vs, "vs r8 r7", "vs_r8_r7"},
     {{vs, r8, r8}, true, vs, "vs r8 r8", "vs_r8_r8"},
     {{vs, r8, r9}, true, vs, "vs r8 r9", "vs_r8_r9"},
     {{vs, r8, r10}, true, vs, "vs r8 r10", "vs_r8_r10"},
     {{vs, r8, r11}, true, vs, "vs r8 r11", "vs_r8_r11"},
     {{vs, r8, r12}, true, vs, "vs r8 r12", "vs_r8_r12"},
     {{vs, r8, r13}, true, vs, "vs r8 r13", "vs_r8_r13"},
     {{vs, r8, r14}, true, vs, "vs r8 r14", "vs_r8_r14"},
     {{vs, r9, r0}, true, vs, "vs r9 r0", "vs_r9_r0"},
     {{vs, r9, r1}, true, vs, "vs r9 r1", "vs_r9_r1"},
     {{vs, r9, r2}, true, vs, "vs r9 r2", "vs_r9_r2"},
     {{vs, r9, r3}, true, vs, "vs r9 r3", "vs_r9_r3"},
     {{vs, r9, r4}, true, vs, "vs r9 r4", "vs_r9_r4"},
     {{vs, r9, r5}, true, vs, "vs r9 r5", "vs_r9_r5"},
     {{vs, r9, r6}, true, vs, "vs r9 r6", "vs_r9_r6"},
     {{vs, r9, r7}, true, vs, "vs r9 r7", "vs_r9_r7"},
     {{vs, r9, r8}, true, vs, "vs r9 r8", "vs_r9_r8"},
     {{vs, r9, r9}, true, vs, "vs r9 r9", "vs_r9_r9"},
     {{vs, r9, r10}, true, vs, "vs r9 r10", "vs_r9_r10"},
     {{vs, r9, r11}, true, vs, "vs r9 r11", "vs_r9_r11"},
     {{vs, r9, r12}, true, vs, "vs r9 r12", "vs_r9_r12"},
     {{vs, r9, r13}, true, vs, "vs r9 r13", "vs_r9_r13"},
     {{vs, r9, r14}, true, vs, "vs r9 r14", "vs_r9_r14"},
     {{vs, r10, r0}, true, vs, "vs r10 r0", "vs_r10_r0"},
     {{vs, r10, r1}, true, vs, "vs r10 r1", "vs_r10_r1"},
     {{vs, r10, r2}, true, vs, "vs r10 r2", "vs_r10_r2"},
     {{vs, r10, r3}, true, vs, "vs r10 r3", "vs_r10_r3"},
     {{vs, r10, r4}, true, vs, "vs r10 r4", "vs_r10_r4"},
     {{vs, r10, r5}, true, vs, "vs r10 r5", "vs_r10_r5"},
     {{vs, r10, r6}, true, vs, "vs r10 r6", "vs_r10_r6"},
     {{vs, r10, r7}, true, vs, "vs r10 r7", "vs_r10_r7"},
     {{vs, r10, r8}, true, vs, "vs r10 r8", "vs_r10_r8"},
     {{vs, r10, r9}, true, vs, "vs r10 r9", "vs_r10_r9"},
     {{vs, r10, r10}, true, vs, "vs r10 r10", "vs_r10_r10"},
     {{vs, r10, r11}, true, vs, "vs r10 r11", "vs_r10_r11"},
     {{vs, r10, r12}, true, vs, "vs r10 r12", "vs_r10_r12"},
     {{vs, r10, r13}, true, vs, "vs r10 r13", "vs_r10_r13"},
     {{vs, r10, r14}, true, vs, "vs r10 r14", "vs_r10_r14"},
     {{vs, r11, r0}, true, vs, "vs r11 r0", "vs_r11_r0"},
     {{vs, r11, r1}, true, vs, "vs r11 r1", "vs_r11_r1"},
     {{vs, r11, r2}, true, vs, "vs r11 r2", "vs_r11_r2"},
     {{vs, r11, r3}, true, vs, "vs r11 r3", "vs_r11_r3"},
     {{vs, r11, r4}, true, vs, "vs r11 r4", "vs_r11_r4"},
     {{vs, r11, r5}, true, vs, "vs r11 r5", "vs_r11_r5"},
     {{vs, r11, r6}, true, vs, "vs r11 r6", "vs_r11_r6"},
     {{vs, r11, r7}, true, vs, "vs r11 r7", "vs_r11_r7"},
     {{vs, r11, r8}, true, vs, "vs r11 r8", "vs_r11_r8"},
     {{vs, r11, r9}, true, vs, "vs r11 r9", "vs_r11_r9"},
     {{vs, r11, r10}, true, vs, "vs r11 r10", "vs_r11_r10"},
     {{vs, r11, r11}, true, vs, "vs r11 r11", "vs_r11_r11"},
     {{vs, r11, r12}, true, vs, "vs r11 r12", "vs_r11_r12"},
     {{vs, r11, r13}, true, vs, "vs r11 r13", "vs_r11_r13"},
     {{vs, r11, r14}, true, vs, "vs r11 r14", "vs_r11_r14"},
     {{vs, r12, r0}, true, vs, "vs r12 r0", "vs_r12_r0"},
     {{vs, r12, r1}, true, vs, "vs r12 r1", "vs_r12_r1"},
     {{vs, r12, r2}, true, vs, "vs r12 r2", "vs_r12_r2"},
     {{vs, r12, r3}, true, vs, "vs r12 r3", "vs_r12_r3"},
     {{vs, r12, r4}, true, vs, "vs r12 r4", "vs_r12_r4"},
     {{vs, r12, r5}, true, vs, "vs r12 r5", "vs_r12_r5"},
     {{vs, r12, r6}, true, vs, "vs r12 r6", "vs_r12_r6"},
     {{vs, r12, r7}, true, vs, "vs r12 r7", "vs_r12_r7"},
     {{vs, r12, r8}, true, vs, "vs r12 r8", "vs_r12_r8"},
     {{vs, r12, r9}, true, vs, "vs r12 r9", "vs_r12_r9"},
     {{vs, r12, r10}, true, vs, "vs r12 r10", "vs_r12_r10"},
     {{vs, r12, r11}, true, vs, "vs r12 r11", "vs_r12_r11"},
     {{vs, r12, r12}, true, vs, "vs r12 r12", "vs_r12_r12"},
     {{vs, r12, r13}, true, vs, "vs r12 r13", "vs_r12_r13"},
     {{vs, r12, r14}, true, vs, "vs r12 r14", "vs_r12_r14"},
     {{vs, r13, r0}, true, vs, "vs r13 r0", "vs_r13_r0"},
     {{vs, r13, r1}, true, vs, "vs r13 r1", "vs_r13_r1"},
     {{vs, r13, r2}, true, vs, "vs r13 r2", "vs_r13_r2"},
     {{vs, r13, r3}, true, vs, "vs r13 r3", "vs_r13_r3"},
     {{vs, r13, r4}, true, vs, "vs r13 r4", "vs_r13_r4"},
     {{vs, r13, r5}, true, vs, "vs r13 r5", "vs_r13_r5"},
     {{vs, r13, r6}, true, vs, "vs r13 r6", "vs_r13_r6"},
     {{vs, r13, r7}, true, vs, "vs r13 r7", "vs_r13_r7"},
     {{vs, r13, r8}, true, vs, "vs r13 r8", "vs_r13_r8"},
     {{vs, r13, r9}, true, vs, "vs r13 r9", "vs_r13_r9"},
     {{vs, r13, r10}, true, vs, "vs r13 r10", "vs_r13_r10"},
     {{vs, r13, r11}, true, vs, "vs r13 r11", "vs_r13_r11"},
     {{vs, r13, r12}, true, vs, "vs r13 r12", "vs_r13_r12"},
     {{vs, r13, r13}, true, vs, "vs r13 r13", "vs_r13_r13"},
     {{vs, r13, r14}, true, vs, "vs r13 r14", "vs_r13_r14"},
     {{vs, r14, r0}, true, vs, "vs r14 r0", "vs_r14_r0"},
     {{vs, r14, r1}, true, vs, "vs r14 r1", "vs_r14_r1"},
     {{vs, r14, r2}, true, vs, "vs r14 r2", "vs_r14_r2"},
     {{vs, r14, r3}, true, vs, "vs r14 r3", "vs_r14_r3"},
     {{vs, r14, r4}, true, vs, "vs r14 r4", "vs_r14_r4"},
     {{vs, r14, r5}, true, vs, "vs r14 r5", "vs_r14_r5"},
     {{vs, r14, r6}, true, vs, "vs r14 r6", "vs_r14_r6"},
     {{vs, r14, r7}, true, vs, "vs r14 r7", "vs_r14_r7"},
     {{vs, r14, r8}, true, vs, "vs r14 r8", "vs_r14_r8"},
     {{vs, r14, r9}, true, vs, "vs r14 r9", "vs_r14_r9"},
     {{vs, r14, r10}, true, vs, "vs r14 r10", "vs_r14_r10"},
     {{vs, r14, r11}, true, vs, "vs r14 r11", "vs_r14_r11"},
     {{vs, r14, r12}, true, vs, "vs r14 r12", "vs_r14_r12"},
     {{vs, r14, r13}, true, vs, "vs r14 r13", "vs_r14_r13"},
     {{vs, r14, r14}, true, vs, "vs r14 r14", "vs_r14_r14"},
     {{vc, r0, r0}, true, vc, "vc r0 r0", "vc_r0_r0"},
     {{vc, r0, r1}, true, vc, "vc r0 r1", "vc_r0_r1"},
     {{vc, r0, r2}, true, vc, "vc r0 r2", "vc_r0_r2"},
     {{vc, r0, r3}, true, vc, "vc r0 r3", "vc_r0_r3"},
     {{vc, r0, r4}, true, vc, "vc r0 r4", "vc_r0_r4"},
     {{vc, r0, r5}, true, vc, "vc r0 r5", "vc_r0_r5"},
     {{vc, r0, r6}, true, vc, "vc r0 r6", "vc_r0_r6"},
     {{vc, r0, r7}, true, vc, "vc r0 r7", "vc_r0_r7"},
     {{vc, r0, r8}, true, vc, "vc r0 r8", "vc_r0_r8"},
     {{vc, r0, r9}, true, vc, "vc r0 r9", "vc_r0_r9"},
     {{vc, r0, r10}, true, vc, "vc r0 r10", "vc_r0_r10"},
     {{vc, r0, r11}, true, vc, "vc r0 r11", "vc_r0_r11"},
     {{vc, r0, r12}, true, vc, "vc r0 r12", "vc_r0_r12"},
     {{vc, r0, r13}, true, vc, "vc r0 r13", "vc_r0_r13"},
     {{vc, r0, r14}, true, vc, "vc r0 r14", "vc_r0_r14"},
     {{vc, r1, r0}, true, vc, "vc r1 r0", "vc_r1_r0"},
     {{vc, r1, r1}, true, vc, "vc r1 r1", "vc_r1_r1"},
     {{vc, r1, r2}, true, vc, "vc r1 r2", "vc_r1_r2"},
     {{vc, r1, r3}, true, vc, "vc r1 r3", "vc_r1_r3"},
     {{vc, r1, r4}, true, vc, "vc r1 r4", "vc_r1_r4"},
     {{vc, r1, r5}, true, vc, "vc r1 r5", "vc_r1_r5"},
     {{vc, r1, r6}, true, vc, "vc r1 r6", "vc_r1_r6"},
     {{vc, r1, r7}, true, vc, "vc r1 r7", "vc_r1_r7"},
     {{vc, r1, r8}, true, vc, "vc r1 r8", "vc_r1_r8"},
     {{vc, r1, r9}, true, vc, "vc r1 r9", "vc_r1_r9"},
     {{vc, r1, r10}, true, vc, "vc r1 r10", "vc_r1_r10"},
     {{vc, r1, r11}, true, vc, "vc r1 r11", "vc_r1_r11"},
     {{vc, r1, r12}, true, vc, "vc r1 r12", "vc_r1_r12"},
     {{vc, r1, r13}, true, vc, "vc r1 r13", "vc_r1_r13"},
     {{vc, r1, r14}, true, vc, "vc r1 r14", "vc_r1_r14"},
     {{vc, r2, r0}, true, vc, "vc r2 r0", "vc_r2_r0"},
     {{vc, r2, r1}, true, vc, "vc r2 r1", "vc_r2_r1"},
     {{vc, r2, r2}, true, vc, "vc r2 r2", "vc_r2_r2"},
     {{vc, r2, r3}, true, vc, "vc r2 r3", "vc_r2_r3"},
     {{vc, r2, r4}, true, vc, "vc r2 r4", "vc_r2_r4"},
     {{vc, r2, r5}, true, vc, "vc r2 r5", "vc_r2_r5"},
     {{vc, r2, r6}, true, vc, "vc r2 r6", "vc_r2_r6"},
     {{vc, r2, r7}, true, vc, "vc r2 r7", "vc_r2_r7"},
     {{vc, r2, r8}, true, vc, "vc r2 r8", "vc_r2_r8"},
     {{vc, r2, r9}, true, vc, "vc r2 r9", "vc_r2_r9"},
     {{vc, r2, r10}, true, vc, "vc r2 r10", "vc_r2_r10"},
     {{vc, r2, r11}, true, vc, "vc r2 r11", "vc_r2_r11"},
     {{vc, r2, r12}, true, vc, "vc r2 r12", "vc_r2_r12"},
     {{vc, r2, r13}, true, vc, "vc r2 r13", "vc_r2_r13"},
     {{vc, r2, r14}, true, vc, "vc r2 r14", "vc_r2_r14"},
     {{vc, r3, r0}, true, vc, "vc r3 r0", "vc_r3_r0"},
     {{vc, r3, r1}, true, vc, "vc r3 r1", "vc_r3_r1"},
     {{vc, r3, r2}, true, vc, "vc r3 r2", "vc_r3_r2"},
     {{vc, r3, r3}, true, vc, "vc r3 r3", "vc_r3_r3"},
     {{vc, r3, r4}, true, vc, "vc r3 r4", "vc_r3_r4"},
     {{vc, r3, r5}, true, vc, "vc r3 r5", "vc_r3_r5"},
     {{vc, r3, r6}, true, vc, "vc r3 r6", "vc_r3_r6"},
     {{vc, r3, r7}, true, vc, "vc r3 r7", "vc_r3_r7"},
     {{vc, r3, r8}, true, vc, "vc r3 r8", "vc_r3_r8"},
     {{vc, r3, r9}, true, vc, "vc r3 r9", "vc_r3_r9"},
     {{vc, r3, r10}, true, vc, "vc r3 r10", "vc_r3_r10"},
     {{vc, r3, r11}, true, vc, "vc r3 r11", "vc_r3_r11"},
     {{vc, r3, r12}, true, vc, "vc r3 r12", "vc_r3_r12"},
     {{vc, r3, r13}, true, vc, "vc r3 r13", "vc_r3_r13"},
     {{vc, r3, r14}, true, vc, "vc r3 r14", "vc_r3_r14"},
     {{vc, r4, r0}, true, vc, "vc r4 r0", "vc_r4_r0"},
     {{vc, r4, r1}, true, vc, "vc r4 r1", "vc_r4_r1"},
     {{vc, r4, r2}, true, vc, "vc r4 r2", "vc_r4_r2"},
     {{vc, r4, r3}, true, vc, "vc r4 r3", "vc_r4_r3"},
     {{vc, r4, r4}, true, vc, "vc r4 r4", "vc_r4_r4"},
     {{vc, r4, r5}, true, vc, "vc r4 r5", "vc_r4_r5"},
     {{vc, r4, r6}, true, vc, "vc r4 r6", "vc_r4_r6"},
     {{vc, r4, r7}, true, vc, "vc r4 r7", "vc_r4_r7"},
     {{vc, r4, r8}, true, vc, "vc r4 r8", "vc_r4_r8"},
     {{vc, r4, r9}, true, vc, "vc r4 r9", "vc_r4_r9"},
     {{vc, r4, r10}, true, vc, "vc r4 r10", "vc_r4_r10"},
     {{vc, r4, r11}, true, vc, "vc r4 r11", "vc_r4_r11"},
     {{vc, r4, r12}, true, vc, "vc r4 r12", "vc_r4_r12"},
     {{vc, r4, r13}, true, vc, "vc r4 r13", "vc_r4_r13"},
     {{vc, r4, r14}, true, vc, "vc r4 r14", "vc_r4_r14"},
     {{vc, r5, r0}, true, vc, "vc r5 r0", "vc_r5_r0"},
     {{vc, r5, r1}, true, vc, "vc r5 r1", "vc_r5_r1"},
     {{vc, r5, r2}, true, vc, "vc r5 r2", "vc_r5_r2"},
     {{vc, r5, r3}, true, vc, "vc r5 r3", "vc_r5_r3"},
     {{vc, r5, r4}, true, vc, "vc r5 r4", "vc_r5_r4"},
     {{vc, r5, r5}, true, vc, "vc r5 r5", "vc_r5_r5"},
     {{vc, r5, r6}, true, vc, "vc r5 r6", "vc_r5_r6"},
     {{vc, r5, r7}, true, vc, "vc r5 r7", "vc_r5_r7"},
     {{vc, r5, r8}, true, vc, "vc r5 r8", "vc_r5_r8"},
     {{vc, r5, r9}, true, vc, "vc r5 r9", "vc_r5_r9"},
     {{vc, r5, r10}, true, vc, "vc r5 r10", "vc_r5_r10"},
     {{vc, r5, r11}, true, vc, "vc r5 r11", "vc_r5_r11"},
     {{vc, r5, r12}, true, vc, "vc r5 r12", "vc_r5_r12"},
     {{vc, r5, r13}, true, vc, "vc r5 r13", "vc_r5_r13"},
     {{vc, r5, r14}, true, vc, "vc r5 r14", "vc_r5_r14"},
     {{vc, r6, r0}, true, vc, "vc r6 r0", "vc_r6_r0"},
     {{vc, r6, r1}, true, vc, "vc r6 r1", "vc_r6_r1"},
     {{vc, r6, r2}, true, vc, "vc r6 r2", "vc_r6_r2"},
     {{vc, r6, r3}, true, vc, "vc r6 r3", "vc_r6_r3"},
     {{vc, r6, r4}, true, vc, "vc r6 r4", "vc_r6_r4"},
     {{vc, r6, r5}, true, vc, "vc r6 r5", "vc_r6_r5"},
     {{vc, r6, r6}, true, vc, "vc r6 r6", "vc_r6_r6"},
     {{vc, r6, r7}, true, vc, "vc r6 r7", "vc_r6_r7"},
     {{vc, r6, r8}, true, vc, "vc r6 r8", "vc_r6_r8"},
     {{vc, r6, r9}, true, vc, "vc r6 r9", "vc_r6_r9"},
     {{vc, r6, r10}, true, vc, "vc r6 r10", "vc_r6_r10"},
     {{vc, r6, r11}, true, vc, "vc r6 r11", "vc_r6_r11"},
     {{vc, r6, r12}, true, vc, "vc r6 r12", "vc_r6_r12"},
     {{vc, r6, r13}, true, vc, "vc r6 r13", "vc_r6_r13"},
     {{vc, r6, r14}, true, vc, "vc r6 r14", "vc_r6_r14"},
     {{vc, r7, r0}, true, vc, "vc r7 r0", "vc_r7_r0"},
     {{vc, r7, r1}, true, vc, "vc r7 r1", "vc_r7_r1"},
     {{vc, r7, r2}, true, vc, "vc r7 r2", "vc_r7_r2"},
     {{vc, r7, r3}, true, vc, "vc r7 r3", "vc_r7_r3"},
     {{vc, r7, r4}, true, vc, "vc r7 r4", "vc_r7_r4"},
     {{vc, r7, r5}, true, vc, "vc r7 r5", "vc_r7_r5"},
     {{vc, r7, r6}, true, vc, "vc r7 r6", "vc_r7_r6"},
     {{vc, r7, r7}, true, vc, "vc r7 r7", "vc_r7_r7"},
     {{vc, r7, r8}, true, vc, "vc r7 r8", "vc_r7_r8"},
     {{vc, r7, r9}, true, vc, "vc r7 r9", "vc_r7_r9"},
     {{vc, r7, r10}, true, vc, "vc r7 r10", "vc_r7_r10"},
     {{vc, r7, r11}, true, vc, "vc r7 r11", "vc_r7_r11"},
     {{vc, r7, r12}, true, vc, "vc r7 r12", "vc_r7_r12"},
     {{vc, r7, r13}, true, vc, "vc r7 r13", "vc_r7_r13"},
     {{vc, r7, r14}, true, vc, "vc r7 r14", "vc_r7_r14"},
     {{vc, r8, r0}, true, vc, "vc r8 r0", "vc_r8_r0"},
     {{vc, r8, r1}, true, vc, "vc r8 r1", "vc_r8_r1"},
     {{vc, r8, r2}, true, vc, "vc r8 r2", "vc_r8_r2"},
     {{vc, r8, r3}, true, vc, "vc r8 r3", "vc_r8_r3"},
     {{vc, r8, r4}, true, vc, "vc r8 r4", "vc_r8_r4"},
     {{vc, r8, r5}, true, vc, "vc r8 r5", "vc_r8_r5"},
     {{vc, r8, r6}, true, vc, "vc r8 r6", "vc_r8_r6"},
     {{vc, r8, r7}, true, vc, "vc r8 r7", "vc_r8_r7"},
     {{vc, r8, r8}, true, vc, "vc r8 r8", "vc_r8_r8"},
     {{vc, r8, r9}, true, vc, "vc r8 r9", "vc_r8_r9"},
     {{vc, r8, r10}, true, vc, "vc r8 r10", "vc_r8_r10"},
     {{vc, r8, r11}, true, vc, "vc r8 r11", "vc_r8_r11"},
     {{vc, r8, r12}, true, vc, "vc r8 r12", "vc_r8_r12"},
     {{vc, r8, r13}, true, vc, "vc r8 r13", "vc_r8_r13"},
     {{vc, r8, r14}, true, vc, "vc r8 r14", "vc_r8_r14"},
     {{vc, r9, r0}, true, vc, "vc r9 r0", "vc_r9_r0"},
     {{vc, r9, r1}, true, vc, "vc r9 r1", "vc_r9_r1"},
     {{vc, r9, r2}, true, vc, "vc r9 r2", "vc_r9_r2"},
     {{vc, r9, r3}, true, vc, "vc r9 r3", "vc_r9_r3"},
     {{vc, r9, r4}, true, vc, "vc r9 r4", "vc_r9_r4"},
     {{vc, r9, r5}, true, vc, "vc r9 r5", "vc_r9_r5"},
     {{vc, r9, r6}, true, vc, "vc r9 r6", "vc_r9_r6"},
     {{vc, r9, r7}, true, vc, "vc r9 r7", "vc_r9_r7"},
     {{vc, r9, r8}, true, vc, "vc r9 r8", "vc_r9_r8"},
     {{vc, r9, r9}, true, vc, "vc r9 r9", "vc_r9_r9"},
     {{vc, r9, r10}, true, vc, "vc r9 r10", "vc_r9_r10"},
     {{vc, r9, r11}, true, vc, "vc r9 r11", "vc_r9_r11"},
     {{vc, r9, r12}, true, vc, "vc r9 r12", "vc_r9_r12"},
     {{vc, r9, r13}, true, vc, "vc r9 r13", "vc_r9_r13"},
     {{vc, r9, r14}, true, vc, "vc r9 r14", "vc_r9_r14"},
     {{vc, r10, r0}, true, vc, "vc r10 r0", "vc_r10_r0"},
     {{vc, r10, r1}, true, vc, "vc r10 r1", "vc_r10_r1"},
     {{vc, r10, r2}, true, vc, "vc r10 r2", "vc_r10_r2"},
     {{vc, r10, r3}, true, vc, "vc r10 r3", "vc_r10_r3"},
     {{vc, r10, r4}, true, vc, "vc r10 r4", "vc_r10_r4"},
     {{vc, r10, r5}, true, vc, "vc r10 r5", "vc_r10_r5"},
     {{vc, r10, r6}, true, vc, "vc r10 r6", "vc_r10_r6"},
     {{vc, r10, r7}, true, vc, "vc r10 r7", "vc_r10_r7"},
     {{vc, r10, r8}, true, vc, "vc r10 r8", "vc_r10_r8"},
     {{vc, r10, r9}, true, vc, "vc r10 r9", "vc_r10_r9"},
     {{vc, r10, r10}, true, vc, "vc r10 r10", "vc_r10_r10"},
     {{vc, r10, r11}, true, vc, "vc r10 r11", "vc_r10_r11"},
     {{vc, r10, r12}, true, vc, "vc r10 r12", "vc_r10_r12"},
     {{vc, r10, r13}, true, vc, "vc r10 r13", "vc_r10_r13"},
     {{vc, r10, r14}, true, vc, "vc r10 r14", "vc_r10_r14"},
     {{vc, r11, r0}, true, vc, "vc r11 r0", "vc_r11_r0"},
     {{vc, r11, r1}, true, vc, "vc r11 r1", "vc_r11_r1"},
     {{vc, r11, r2}, true, vc, "vc r11 r2", "vc_r11_r2"},
     {{vc, r11, r3}, true, vc, "vc r11 r3", "vc_r11_r3"},
     {{vc, r11, r4}, true, vc, "vc r11 r4", "vc_r11_r4"},
     {{vc, r11, r5}, true, vc, "vc r11 r5", "vc_r11_r5"},
     {{vc, r11, r6}, true, vc, "vc r11 r6", "vc_r11_r6"},
     {{vc, r11, r7}, true, vc, "vc r11 r7", "vc_r11_r7"},
     {{vc, r11, r8}, true, vc, "vc r11 r8", "vc_r11_r8"},
     {{vc, r11, r9}, true, vc, "vc r11 r9", "vc_r11_r9"},
     {{vc, r11, r10}, true, vc, "vc r11 r10", "vc_r11_r10"},
     {{vc, r11, r11}, true, vc, "vc r11 r11", "vc_r11_r11"},
     {{vc, r11, r12}, true, vc, "vc r11 r12", "vc_r11_r12"},
     {{vc, r11, r13}, true, vc, "vc r11 r13", "vc_r11_r13"},
     {{vc, r11, r14}, true, vc, "vc r11 r14", "vc_r11_r14"},
     {{vc, r12, r0}, true, vc, "vc r12 r0", "vc_r12_r0"},
     {{vc, r12, r1}, true, vc, "vc r12 r1", "vc_r12_r1"},
     {{vc, r12, r2}, true, vc, "vc r12 r2", "vc_r12_r2"},
     {{vc, r12, r3}, true, vc, "vc r12 r3", "vc_r12_r3"},
     {{vc, r12, r4}, true, vc, "vc r12 r4", "vc_r12_r4"},
     {{vc, r12, r5}, true, vc, "vc r12 r5", "vc_r12_r5"},
     {{vc, r12, r6}, true, vc, "vc r12 r6", "vc_r12_r6"},
     {{vc, r12, r7}, true, vc, "vc r12 r7", "vc_r12_r7"},
     {{vc, r12, r8}, true, vc, "vc r12 r8", "vc_r12_r8"},
     {{vc, r12, r9}, true, vc, "vc r12 r9", "vc_r12_r9"},
     {{vc, r12, r10}, true, vc, "vc r12 r10", "vc_r12_r10"},
     {{vc, r12, r11}, true, vc, "vc r12 r11", "vc_r12_r11"},
     {{vc, r12, r12}, true, vc, "vc r12 r12", "vc_r12_r12"},
     {{vc, r12, r13}, true, vc, "vc r12 r13", "vc_r12_r13"},
     {{vc, r12, r14}, true, vc, "vc r12 r14", "vc_r12_r14"},
     {{vc, r13, r0}, true, vc, "vc r13 r0", "vc_r13_r0"},
     {{vc, r13, r1}, true, vc, "vc r13 r1", "vc_r13_r1"},
     {{vc, r13, r2}, true, vc, "vc r13 r2", "vc_r13_r2"},
     {{vc, r13, r3}, true, vc, "vc r13 r3", "vc_r13_r3"},
     {{vc, r13, r4}, true, vc, "vc r13 r4", "vc_r13_r4"},
     {{vc, r13, r5}, true, vc, "vc r13 r5", "vc_r13_r5"},
     {{vc, r13, r6}, true, vc, "vc r13 r6", "vc_r13_r6"},
     {{vc, r13, r7}, true, vc, "vc r13 r7", "vc_r13_r7"},
     {{vc, r13, r8}, true, vc, "vc r13 r8", "vc_r13_r8"},
     {{vc, r13, r9}, true, vc, "vc r13 r9", "vc_r13_r9"},
     {{vc, r13, r10}, true, vc, "vc r13 r10", "vc_r13_r10"},
     {{vc, r13, r11}, true, vc, "vc r13 r11", "vc_r13_r11"},
     {{vc, r13, r12}, true, vc, "vc r13 r12", "vc_r13_r12"},
     {{vc, r13, r13}, true, vc, "vc r13 r13", "vc_r13_r13"},
     {{vc, r13, r14}, true, vc, "vc r13 r14", "vc_r13_r14"},
     {{vc, r14, r0}, true, vc, "vc r14 r0", "vc_r14_r0"},
     {{vc, r14, r1}, true, vc, "vc r14 r1", "vc_r14_r1"},
     {{vc, r14, r2}, true, vc, "vc r14 r2", "vc_r14_r2"},
     {{vc, r14, r3}, true, vc, "vc r14 r3", "vc_r14_r3"},
     {{vc, r14, r4}, true, vc, "vc r14 r4", "vc_r14_r4"},
     {{vc, r14, r5}, true, vc, "vc r14 r5", "vc_r14_r5"},
     {{vc, r14, r6}, true, vc, "vc r14 r6", "vc_r14_r6"},
     {{vc, r14, r7}, true, vc, "vc r14 r7", "vc_r14_r7"},
     {{vc, r14, r8}, true, vc, "vc r14 r8", "vc_r14_r8"},
     {{vc, r14, r9}, true, vc, "vc r14 r9", "vc_r14_r9"},
     {{vc, r14, r10}, true, vc, "vc r14 r10", "vc_r14_r10"},
     {{vc, r14, r11}, true, vc, "vc r14 r11", "vc_r14_r11"},
     {{vc, r14, r12}, true, vc, "vc r14 r12", "vc_r14_r12"},
     {{vc, r14, r13}, true, vc, "vc r14 r13", "vc_r14_r13"},
     {{vc, r14, r14}, true, vc, "vc r14 r14", "vc_r14_r14"},
     {{hi, r0, r0}, true, hi, "hi r0 r0", "hi_r0_r0"},
     {{hi, r0, r1}, true, hi, "hi r0 r1", "hi_r0_r1"},
     {{hi, r0, r2}, true, hi, "hi r0 r2", "hi_r0_r2"},
     {{hi, r0, r3}, true, hi, "hi r0 r3", "hi_r0_r3"},
     {{hi, r0, r4}, true, hi, "hi r0 r4", "hi_r0_r4"},
     {{hi, r0, r5}, true, hi, "hi r0 r5", "hi_r0_r5"},
     {{hi, r0, r6}, true, hi, "hi r0 r6", "hi_r0_r6"},
     {{hi, r0, r7}, true, hi, "hi r0 r7", "hi_r0_r7"},
     {{hi, r0, r8}, true, hi, "hi r0 r8", "hi_r0_r8"},
     {{hi, r0, r9}, true, hi, "hi r0 r9", "hi_r0_r9"},
     {{hi, r0, r10}, true, hi, "hi r0 r10", "hi_r0_r10"},
     {{hi, r0, r11}, true, hi, "hi r0 r11", "hi_r0_r11"},
     {{hi, r0, r12}, true, hi, "hi r0 r12", "hi_r0_r12"},
     {{hi, r0, r13}, true, hi, "hi r0 r13", "hi_r0_r13"},
     {{hi, r0, r14}, true, hi, "hi r0 r14", "hi_r0_r14"},
     {{hi, r1, r0}, true, hi, "hi r1 r0", "hi_r1_r0"},
     {{hi, r1, r1}, true, hi, "hi r1 r1", "hi_r1_r1"},
     {{hi, r1, r2}, true, hi, "hi r1 r2", "hi_r1_r2"},
     {{hi, r1, r3}, true, hi, "hi r1 r3", "hi_r1_r3"},
     {{hi, r1, r4}, true, hi, "hi r1 r4", "hi_r1_r4"},
     {{hi, r1, r5}, true, hi, "hi r1 r5", "hi_r1_r5"},
     {{hi, r1, r6}, true, hi, "hi r1 r6", "hi_r1_r6"},
     {{hi, r1, r7}, true, hi, "hi r1 r7", "hi_r1_r7"},
     {{hi, r1, r8}, true, hi, "hi r1 r8", "hi_r1_r8"},
     {{hi, r1, r9}, true, hi, "hi r1 r9", "hi_r1_r9"},
     {{hi, r1, r10}, true, hi, "hi r1 r10", "hi_r1_r10"},
     {{hi, r1, r11}, true, hi, "hi r1 r11", "hi_r1_r11"},
     {{hi, r1, r12}, true, hi, "hi r1 r12", "hi_r1_r12"},
     {{hi, r1, r13}, true, hi, "hi r1 r13", "hi_r1_r13"},
     {{hi, r1, r14}, true, hi, "hi r1 r14", "hi_r1_r14"},
     {{hi, r2, r0}, true, hi, "hi r2 r0", "hi_r2_r0"},
     {{hi, r2, r1}, true, hi, "hi r2 r1", "hi_r2_r1"},
     {{hi, r2, r2}, true, hi, "hi r2 r2", "hi_r2_r2"},
     {{hi, r2, r3}, true, hi, "hi r2 r3", "hi_r2_r3"},
     {{hi, r2, r4}, true, hi, "hi r2 r4", "hi_r2_r4"},
     {{hi, r2, r5}, true, hi, "hi r2 r5", "hi_r2_r5"},
     {{hi, r2, r6}, true, hi, "hi r2 r6", "hi_r2_r6"},
     {{hi, r2, r7}, true, hi, "hi r2 r7", "hi_r2_r7"},
     {{hi, r2, r8}, true, hi, "hi r2 r8", "hi_r2_r8"},
     {{hi, r2, r9}, true, hi, "hi r2 r9", "hi_r2_r9"},
     {{hi, r2, r10}, true, hi, "hi r2 r10", "hi_r2_r10"},
     {{hi, r2, r11}, true, hi, "hi r2 r11", "hi_r2_r11"},
     {{hi, r2, r12}, true, hi, "hi r2 r12", "hi_r2_r12"},
     {{hi, r2, r13}, true, hi, "hi r2 r13", "hi_r2_r13"},
     {{hi, r2, r14}, true, hi, "hi r2 r14", "hi_r2_r14"},
     {{hi, r3, r0}, true, hi, "hi r3 r0", "hi_r3_r0"},
     {{hi, r3, r1}, true, hi, "hi r3 r1", "hi_r3_r1"},
     {{hi, r3, r2}, true, hi, "hi r3 r2", "hi_r3_r2"},
     {{hi, r3, r3}, true, hi, "hi r3 r3", "hi_r3_r3"},
     {{hi, r3, r4}, true, hi, "hi r3 r4", "hi_r3_r4"},
     {{hi, r3, r5}, true, hi, "hi r3 r5", "hi_r3_r5"},
     {{hi, r3, r6}, true, hi, "hi r3 r6", "hi_r3_r6"},
     {{hi, r3, r7}, true, hi, "hi r3 r7", "hi_r3_r7"},
     {{hi, r3, r8}, true, hi, "hi r3 r8", "hi_r3_r8"},
     {{hi, r3, r9}, true, hi, "hi r3 r9", "hi_r3_r9"},
     {{hi, r3, r10}, true, hi, "hi r3 r10", "hi_r3_r10"},
     {{hi, r3, r11}, true, hi, "hi r3 r11", "hi_r3_r11"},
     {{hi, r3, r12}, true, hi, "hi r3 r12", "hi_r3_r12"},
     {{hi, r3, r13}, true, hi, "hi r3 r13", "hi_r3_r13"},
     {{hi, r3, r14}, true, hi, "hi r3 r14", "hi_r3_r14"},
     {{hi, r4, r0}, true, hi, "hi r4 r0", "hi_r4_r0"},
     {{hi, r4, r1}, true, hi, "hi r4 r1", "hi_r4_r1"},
     {{hi, r4, r2}, true, hi, "hi r4 r2", "hi_r4_r2"},
     {{hi, r4, r3}, true, hi, "hi r4 r3", "hi_r4_r3"},
     {{hi, r4, r4}, true, hi, "hi r4 r4", "hi_r4_r4"},
     {{hi, r4, r5}, true, hi, "hi r4 r5", "hi_r4_r5"},
     {{hi, r4, r6}, true, hi, "hi r4 r6", "hi_r4_r6"},
     {{hi, r4, r7}, true, hi, "hi r4 r7", "hi_r4_r7"},
     {{hi, r4, r8}, true, hi, "hi r4 r8", "hi_r4_r8"},
     {{hi, r4, r9}, true, hi, "hi r4 r9", "hi_r4_r9"},
     {{hi, r4, r10}, true, hi, "hi r4 r10", "hi_r4_r10"},
     {{hi, r4, r11}, true, hi, "hi r4 r11", "hi_r4_r11"},
     {{hi, r4, r12}, true, hi, "hi r4 r12", "hi_r4_r12"},
     {{hi, r4, r13}, true, hi, "hi r4 r13", "hi_r4_r13"},
     {{hi, r4, r14}, true, hi, "hi r4 r14", "hi_r4_r14"},
     {{hi, r5, r0}, true, hi, "hi r5 r0", "hi_r5_r0"},
     {{hi, r5, r1}, true, hi, "hi r5 r1", "hi_r5_r1"},
     {{hi, r5, r2}, true, hi, "hi r5 r2", "hi_r5_r2"},
     {{hi, r5, r3}, true, hi, "hi r5 r3", "hi_r5_r3"},
     {{hi, r5, r4}, true, hi, "hi r5 r4", "hi_r5_r4"},
     {{hi, r5, r5}, true, hi, "hi r5 r5", "hi_r5_r5"},
     {{hi, r5, r6}, true, hi, "hi r5 r6", "hi_r5_r6"},
     {{hi, r5, r7}, true, hi, "hi r5 r7", "hi_r5_r7"},
     {{hi, r5, r8}, true, hi, "hi r5 r8", "hi_r5_r8"},
     {{hi, r5, r9}, true, hi, "hi r5 r9", "hi_r5_r9"},
     {{hi, r5, r10}, true, hi, "hi r5 r10", "hi_r5_r10"},
     {{hi, r5, r11}, true, hi, "hi r5 r11", "hi_r5_r11"},
     {{hi, r5, r12}, true, hi, "hi r5 r12", "hi_r5_r12"},
     {{hi, r5, r13}, true, hi, "hi r5 r13", "hi_r5_r13"},
     {{hi, r5, r14}, true, hi, "hi r5 r14", "hi_r5_r14"},
     {{hi, r6, r0}, true, hi, "hi r6 r0", "hi_r6_r0"},
     {{hi, r6, r1}, true, hi, "hi r6 r1", "hi_r6_r1"},
     {{hi, r6, r2}, true, hi, "hi r6 r2", "hi_r6_r2"},
     {{hi, r6, r3}, true, hi, "hi r6 r3", "hi_r6_r3"},
     {{hi, r6, r4}, true, hi, "hi r6 r4", "hi_r6_r4"},
     {{hi, r6, r5}, true, hi, "hi r6 r5", "hi_r6_r5"},
     {{hi, r6, r6}, true, hi, "hi r6 r6", "hi_r6_r6"},
     {{hi, r6, r7}, true, hi, "hi r6 r7", "hi_r6_r7"},
     {{hi, r6, r8}, true, hi, "hi r6 r8", "hi_r6_r8"},
     {{hi, r6, r9}, true, hi, "hi r6 r9", "hi_r6_r9"},
     {{hi, r6, r10}, true, hi, "hi r6 r10", "hi_r6_r10"},
     {{hi, r6, r11}, true, hi, "hi r6 r11", "hi_r6_r11"},
     {{hi, r6, r12}, true, hi, "hi r6 r12", "hi_r6_r12"},
     {{hi, r6, r13}, true, hi, "hi r6 r13", "hi_r6_r13"},
     {{hi, r6, r14}, true, hi, "hi r6 r14", "hi_r6_r14"},
     {{hi, r7, r0}, true, hi, "hi r7 r0", "hi_r7_r0"},
     {{hi, r7, r1}, true, hi, "hi r7 r1", "hi_r7_r1"},
     {{hi, r7, r2}, true, hi, "hi r7 r2", "hi_r7_r2"},
     {{hi, r7, r3}, true, hi, "hi r7 r3", "hi_r7_r3"},
     {{hi, r7, r4}, true, hi, "hi r7 r4", "hi_r7_r4"},
     {{hi, r7, r5}, true, hi, "hi r7 r5", "hi_r7_r5"},
     {{hi, r7, r6}, true, hi, "hi r7 r6", "hi_r7_r6"},
     {{hi, r7, r7}, true, hi, "hi r7 r7", "hi_r7_r7"},
     {{hi, r7, r8}, true, hi, "hi r7 r8", "hi_r7_r8"},
     {{hi, r7, r9}, true, hi, "hi r7 r9", "hi_r7_r9"},
     {{hi, r7, r10}, true, hi, "hi r7 r10", "hi_r7_r10"},
     {{hi, r7, r11}, true, hi, "hi r7 r11", "hi_r7_r11"},
     {{hi, r7, r12}, true, hi, "hi r7 r12", "hi_r7_r12"},
     {{hi, r7, r13}, true, hi, "hi r7 r13", "hi_r7_r13"},
     {{hi, r7, r14}, true, hi, "hi r7 r14", "hi_r7_r14"},
     {{hi, r8, r0}, true, hi, "hi r8 r0", "hi_r8_r0"},
     {{hi, r8, r1}, true, hi, "hi r8 r1", "hi_r8_r1"},
     {{hi, r8, r2}, true, hi, "hi r8 r2", "hi_r8_r2"},
     {{hi, r8, r3}, true, hi, "hi r8 r3", "hi_r8_r3"},
     {{hi, r8, r4}, true, hi, "hi r8 r4", "hi_r8_r4"},
     {{hi, r8, r5}, true, hi, "hi r8 r5", "hi_r8_r5"},
     {{hi, r8, r6}, true, hi, "hi r8 r6", "hi_r8_r6"},
     {{hi, r8, r7}, true, hi, "hi r8 r7", "hi_r8_r7"},
     {{hi, r8, r8}, true, hi, "hi r8 r8", "hi_r8_r8"},
     {{hi, r8, r9}, true, hi, "hi r8 r9", "hi_r8_r9"},
     {{hi, r8, r10}, true, hi, "hi r8 r10", "hi_r8_r10"},
     {{hi, r8, r11}, true, hi, "hi r8 r11", "hi_r8_r11"},
     {{hi, r8, r12}, true, hi, "hi r8 r12", "hi_r8_r12"},
     {{hi, r8, r13}, true, hi, "hi r8 r13", "hi_r8_r13"},
     {{hi, r8, r14}, true, hi, "hi r8 r14", "hi_r8_r14"},
     {{hi, r9, r0}, true, hi, "hi r9 r0", "hi_r9_r0"},
     {{hi, r9, r1}, true, hi, "hi r9 r1", "hi_r9_r1"},
     {{hi, r9, r2}, true, hi, "hi r9 r2", "hi_r9_r2"},
     {{hi, r9, r3}, true, hi, "hi r9 r3", "hi_r9_r3"},
     {{hi, r9, r4}, true, hi, "hi r9 r4", "hi_r9_r4"},
     {{hi, r9, r5}, true, hi, "hi r9 r5", "hi_r9_r5"},
     {{hi, r9, r6}, true, hi, "hi r9 r6", "hi_r9_r6"},
     {{hi, r9, r7}, true, hi, "hi r9 r7", "hi_r9_r7"},
     {{hi, r9, r8}, true, hi, "hi r9 r8", "hi_r9_r8"},
     {{hi, r9, r9}, true, hi, "hi r9 r9", "hi_r9_r9"},
     {{hi, r9, r10}, true, hi, "hi r9 r10", "hi_r9_r10"},
     {{hi, r9, r11}, true, hi, "hi r9 r11", "hi_r9_r11"},
     {{hi, r9, r12}, true, hi, "hi r9 r12", "hi_r9_r12"},
     {{hi, r9, r13}, true, hi, "hi r9 r13", "hi_r9_r13"},
     {{hi, r9, r14}, true, hi, "hi r9 r14", "hi_r9_r14"},
     {{hi, r10, r0}, true, hi, "hi r10 r0", "hi_r10_r0"},
     {{hi, r10, r1}, true, hi, "hi r10 r1", "hi_r10_r1"},
     {{hi, r10, r2}, true, hi, "hi r10 r2", "hi_r10_r2"},
     {{hi, r10, r3}, true, hi, "hi r10 r3", "hi_r10_r3"},
     {{hi, r10, r4}, true, hi, "hi r10 r4", "hi_r10_r4"},
     {{hi, r10, r5}, true, hi, "hi r10 r5", "hi_r10_r5"},
     {{hi, r10, r6}, true, hi, "hi r10 r6", "hi_r10_r6"},
     {{hi, r10, r7}, true, hi, "hi r10 r7", "hi_r10_r7"},
     {{hi, r10, r8}, true, hi, "hi r10 r8", "hi_r10_r8"},
     {{hi, r10, r9}, true, hi, "hi r10 r9", "hi_r10_r9"},
     {{hi, r10, r10}, true, hi, "hi r10 r10", "hi_r10_r10"},
     {{hi, r10, r11}, true, hi, "hi r10 r11", "hi_r10_r11"},
     {{hi, r10, r12}, true, hi, "hi r10 r12", "hi_r10_r12"},
     {{hi, r10, r13}, true, hi, "hi r10 r13", "hi_r10_r13"},
     {{hi, r10, r14}, true, hi, "hi r10 r14", "hi_r10_r14"},
     {{hi, r11, r0}, true, hi, "hi r11 r0", "hi_r11_r0"},
     {{hi, r11, r1}, true, hi, "hi r11 r1", "hi_r11_r1"},
     {{hi, r11, r2}, true, hi, "hi r11 r2", "hi_r11_r2"},
     {{hi, r11, r3}, true, hi, "hi r11 r3", "hi_r11_r3"},
     {{hi, r11, r4}, true, hi, "hi r11 r4", "hi_r11_r4"},
     {{hi, r11, r5}, true, hi, "hi r11 r5", "hi_r11_r5"},
     {{hi, r11, r6}, true, hi, "hi r11 r6", "hi_r11_r6"},
     {{hi, r11, r7}, true, hi, "hi r11 r7", "hi_r11_r7"},
     {{hi, r11, r8}, true, hi, "hi r11 r8", "hi_r11_r8"},
     {{hi, r11, r9}, true, hi, "hi r11 r9", "hi_r11_r9"},
     {{hi, r11, r10}, true, hi, "hi r11 r10", "hi_r11_r10"},
     {{hi, r11, r11}, true, hi, "hi r11 r11", "hi_r11_r11"},
     {{hi, r11, r12}, true, hi, "hi r11 r12", "hi_r11_r12"},
     {{hi, r11, r13}, true, hi, "hi r11 r13", "hi_r11_r13"},
     {{hi, r11, r14}, true, hi, "hi r11 r14", "hi_r11_r14"},
     {{hi, r12, r0}, true, hi, "hi r12 r0", "hi_r12_r0"},
     {{hi, r12, r1}, true, hi, "hi r12 r1", "hi_r12_r1"},
     {{hi, r12, r2}, true, hi, "hi r12 r2", "hi_r12_r2"},
     {{hi, r12, r3}, true, hi, "hi r12 r3", "hi_r12_r3"},
     {{hi, r12, r4}, true, hi, "hi r12 r4", "hi_r12_r4"},
     {{hi, r12, r5}, true, hi, "hi r12 r5", "hi_r12_r5"},
     {{hi, r12, r6}, true, hi, "hi r12 r6", "hi_r12_r6"},
     {{hi, r12, r7}, true, hi, "hi r12 r7", "hi_r12_r7"},
     {{hi, r12, r8}, true, hi, "hi r12 r8", "hi_r12_r8"},
     {{hi, r12, r9}, true, hi, "hi r12 r9", "hi_r12_r9"},
     {{hi, r12, r10}, true, hi, "hi r12 r10", "hi_r12_r10"},
     {{hi, r12, r11}, true, hi, "hi r12 r11", "hi_r12_r11"},
     {{hi, r12, r12}, true, hi, "hi r12 r12", "hi_r12_r12"},
     {{hi, r12, r13}, true, hi, "hi r12 r13", "hi_r12_r13"},
     {{hi, r12, r14}, true, hi, "hi r12 r14", "hi_r12_r14"},
     {{hi, r13, r0}, true, hi, "hi r13 r0", "hi_r13_r0"},
     {{hi, r13, r1}, true, hi, "hi r13 r1", "hi_r13_r1"},
     {{hi, r13, r2}, true, hi, "hi r13 r2", "hi_r13_r2"},
     {{hi, r13, r3}, true, hi, "hi r13 r3", "hi_r13_r3"},
     {{hi, r13, r4}, true, hi, "hi r13 r4", "hi_r13_r4"},
     {{hi, r13, r5}, true, hi, "hi r13 r5", "hi_r13_r5"},
     {{hi, r13, r6}, true, hi, "hi r13 r6", "hi_r13_r6"},
     {{hi, r13, r7}, true, hi, "hi r13 r7", "hi_r13_r7"},
     {{hi, r13, r8}, true, hi, "hi r13 r8", "hi_r13_r8"},
     {{hi, r13, r9}, true, hi, "hi r13 r9", "hi_r13_r9"},
     {{hi, r13, r10}, true, hi, "hi r13 r10", "hi_r13_r10"},
     {{hi, r13, r11}, true, hi, "hi r13 r11", "hi_r13_r11"},
     {{hi, r13, r12}, true, hi, "hi r13 r12", "hi_r13_r12"},
     {{hi, r13, r13}, true, hi, "hi r13 r13", "hi_r13_r13"},
     {{hi, r13, r14}, true, hi, "hi r13 r14", "hi_r13_r14"},
     {{hi, r14, r0}, true, hi, "hi r14 r0", "hi_r14_r0"},
     {{hi, r14, r1}, true, hi, "hi r14 r1", "hi_r14_r1"},
     {{hi, r14, r2}, true, hi, "hi r14 r2", "hi_r14_r2"},
     {{hi, r14, r3}, true, hi, "hi r14 r3", "hi_r14_r3"},
     {{hi, r14, r4}, true, hi, "hi r14 r4", "hi_r14_r4"},
     {{hi, r14, r5}, true, hi, "hi r14 r5", "hi_r14_r5"},
     {{hi, r14, r6}, true, hi, "hi r14 r6", "hi_r14_r6"},
     {{hi, r14, r7}, true, hi, "hi r14 r7", "hi_r14_r7"},
     {{hi, r14, r8}, true, hi, "hi r14 r8", "hi_r14_r8"},
     {{hi, r14, r9}, true, hi, "hi r14 r9", "hi_r14_r9"},
     {{hi, r14, r10}, true, hi, "hi r14 r10", "hi_r14_r10"},
     {{hi, r14, r11}, true, hi, "hi r14 r11", "hi_r14_r11"},
     {{hi, r14, r12}, true, hi, "hi r14 r12", "hi_r14_r12"},
     {{hi, r14, r13}, true, hi, "hi r14 r13", "hi_r14_r13"},
     {{hi, r14, r14}, true, hi, "hi r14 r14", "hi_r14_r14"},
     {{ls, r0, r0}, true, ls, "ls r0 r0", "ls_r0_r0"},
     {{ls, r0, r1}, true, ls, "ls r0 r1", "ls_r0_r1"},
     {{ls, r0, r2}, true, ls, "ls r0 r2", "ls_r0_r2"},
     {{ls, r0, r3}, true, ls, "ls r0 r3", "ls_r0_r3"},
     {{ls, r0, r4}, true, ls, "ls r0 r4", "ls_r0_r4"},
     {{ls, r0, r5}, true, ls, "ls r0 r5", "ls_r0_r5"},
     {{ls, r0, r6}, true, ls, "ls r0 r6", "ls_r0_r6"},
     {{ls, r0, r7}, true, ls, "ls r0 r7", "ls_r0_r7"},
     {{ls, r0, r8}, true, ls, "ls r0 r8", "ls_r0_r8"},
     {{ls, r0, r9}, true, ls, "ls r0 r9", "ls_r0_r9"},
     {{ls, r0, r10}, true, ls, "ls r0 r10", "ls_r0_r10"},
     {{ls, r0, r11}, true, ls, "ls r0 r11", "ls_r0_r11"},
     {{ls, r0, r12}, true, ls, "ls r0 r12", "ls_r0_r12"},
     {{ls, r0, r13}, true, ls, "ls r0 r13", "ls_r0_r13"},
     {{ls, r0, r14}, true, ls, "ls r0 r14", "ls_r0_r14"},
     {{ls, r1, r0}, true, ls, "ls r1 r0", "ls_r1_r0"},
     {{ls, r1, r1}, true, ls, "ls r1 r1", "ls_r1_r1"},
     {{ls, r1, r2}, true, ls, "ls r1 r2", "ls_r1_r2"},
     {{ls, r1, r3}, true, ls, "ls r1 r3", "ls_r1_r3"},
     {{ls, r1, r4}, true, ls, "ls r1 r4", "ls_r1_r4"},
     {{ls, r1, r5}, true, ls, "ls r1 r5", "ls_r1_r5"},
     {{ls, r1, r6}, true, ls, "ls r1 r6", "ls_r1_r6"},
     {{ls, r1, r7}, true, ls, "ls r1 r7", "ls_r1_r7"},
     {{ls, r1, r8}, true, ls, "ls r1 r8", "ls_r1_r8"},
     {{ls, r1, r9}, true, ls, "ls r1 r9", "ls_r1_r9"},
     {{ls, r1, r10}, true, ls, "ls r1 r10", "ls_r1_r10"},
     {{ls, r1, r11}, true, ls, "ls r1 r11", "ls_r1_r11"},
     {{ls, r1, r12}, true, ls, "ls r1 r12", "ls_r1_r12"},
     {{ls, r1, r13}, true, ls, "ls r1 r13", "ls_r1_r13"},
     {{ls, r1, r14}, true, ls, "ls r1 r14", "ls_r1_r14"},
     {{ls, r2, r0}, true, ls, "ls r2 r0", "ls_r2_r0"},
     {{ls, r2, r1}, true, ls, "ls r2 r1", "ls_r2_r1"},
     {{ls, r2, r2}, true, ls, "ls r2 r2", "ls_r2_r2"},
     {{ls, r2, r3}, true, ls, "ls r2 r3", "ls_r2_r3"},
     {{ls, r2, r4}, true, ls, "ls r2 r4", "ls_r2_r4"},
     {{ls, r2, r5}, true, ls, "ls r2 r5", "ls_r2_r5"},
     {{ls, r2, r6}, true, ls, "ls r2 r6", "ls_r2_r6"},
     {{ls, r2, r7}, true, ls, "ls r2 r7", "ls_r2_r7"},
     {{ls, r2, r8}, true, ls, "ls r2 r8", "ls_r2_r8"},
     {{ls, r2, r9}, true, ls, "ls r2 r9", "ls_r2_r9"},
     {{ls, r2, r10}, true, ls, "ls r2 r10", "ls_r2_r10"},
     {{ls, r2, r11}, true, ls, "ls r2 r11", "ls_r2_r11"},
     {{ls, r2, r12}, true, ls, "ls r2 r12", "ls_r2_r12"},
     {{ls, r2, r13}, true, ls, "ls r2 r13", "ls_r2_r13"},
     {{ls, r2, r14}, true, ls, "ls r2 r14", "ls_r2_r14"},
     {{ls, r3, r0}, true, ls, "ls r3 r0", "ls_r3_r0"},
     {{ls, r3, r1}, true, ls, "ls r3 r1", "ls_r3_r1"},
     {{ls, r3, r2}, true, ls, "ls r3 r2", "ls_r3_r2"},
     {{ls, r3, r3}, true, ls, "ls r3 r3", "ls_r3_r3"},
     {{ls, r3, r4}, true, ls, "ls r3 r4", "ls_r3_r4"},
     {{ls, r3, r5}, true, ls, "ls r3 r5", "ls_r3_r5"},
     {{ls, r3, r6}, true, ls, "ls r3 r6", "ls_r3_r6"},
     {{ls, r3, r7}, true, ls, "ls r3 r7", "ls_r3_r7"},
     {{ls, r3, r8}, true, ls, "ls r3 r8", "ls_r3_r8"},
     {{ls, r3, r9}, true, ls, "ls r3 r9", "ls_r3_r9"},
     {{ls, r3, r10}, true, ls, "ls r3 r10", "ls_r3_r10"},
     {{ls, r3, r11}, true, ls, "ls r3 r11", "ls_r3_r11"},
     {{ls, r3, r12}, true, ls, "ls r3 r12", "ls_r3_r12"},
     {{ls, r3, r13}, true, ls, "ls r3 r13", "ls_r3_r13"},
     {{ls, r3, r14}, true, ls, "ls r3 r14", "ls_r3_r14"},
     {{ls, r4, r0}, true, ls, "ls r4 r0", "ls_r4_r0"},
     {{ls, r4, r1}, true, ls, "ls r4 r1", "ls_r4_r1"},
     {{ls, r4, r2}, true, ls, "ls r4 r2", "ls_r4_r2"},
     {{ls, r4, r3}, true, ls, "ls r4 r3", "ls_r4_r3"},
     {{ls, r4, r4}, true, ls, "ls r4 r4", "ls_r4_r4"},
     {{ls, r4, r5}, true, ls, "ls r4 r5", "ls_r4_r5"},
     {{ls, r4, r6}, true, ls, "ls r4 r6", "ls_r4_r6"},
     {{ls, r4, r7}, true, ls, "ls r4 r7", "ls_r4_r7"},
     {{ls, r4, r8}, true, ls, "ls r4 r8", "ls_r4_r8"},
     {{ls, r4, r9}, true, ls, "ls r4 r9", "ls_r4_r9"},
     {{ls, r4, r10}, true, ls, "ls r4 r10", "ls_r4_r10"},
     {{ls, r4, r11}, true, ls, "ls r4 r11", "ls_r4_r11"},
     {{ls, r4, r12}, true, ls, "ls r4 r12", "ls_r4_r12"},
     {{ls, r4, r13}, true, ls, "ls r4 r13", "ls_r4_r13"},
     {{ls, r4, r14}, true, ls, "ls r4 r14", "ls_r4_r14"},
     {{ls, r5, r0}, true, ls, "ls r5 r0", "ls_r5_r0"},
     {{ls, r5, r1}, true, ls, "ls r5 r1", "ls_r5_r1"},
     {{ls, r5, r2}, true, ls, "ls r5 r2", "ls_r5_r2"},
     {{ls, r5, r3}, true, ls, "ls r5 r3", "ls_r5_r3"},
     {{ls, r5, r4}, true, ls, "ls r5 r4", "ls_r5_r4"},
     {{ls, r5, r5}, true, ls, "ls r5 r5", "ls_r5_r5"},
     {{ls, r5, r6}, true, ls, "ls r5 r6", "ls_r5_r6"},
     {{ls, r5, r7}, true, ls, "ls r5 r7", "ls_r5_r7"},
     {{ls, r5, r8}, true, ls, "ls r5 r8", "ls_r5_r8"},
     {{ls, r5, r9}, true, ls, "ls r5 r9", "ls_r5_r9"},
     {{ls, r5, r10}, true, ls, "ls r5 r10", "ls_r5_r10"},
     {{ls, r5, r11}, true, ls, "ls r5 r11", "ls_r5_r11"},
     {{ls, r5, r12}, true, ls, "ls r5 r12", "ls_r5_r12"},
     {{ls, r5, r13}, true, ls, "ls r5 r13", "ls_r5_r13"},
     {{ls, r5, r14}, true, ls, "ls r5 r14", "ls_r5_r14"},
     {{ls, r6, r0}, true, ls, "ls r6 r0", "ls_r6_r0"},
     {{ls, r6, r1}, true, ls, "ls r6 r1", "ls_r6_r1"},
     {{ls, r6, r2}, true, ls, "ls r6 r2", "ls_r6_r2"},
     {{ls, r6, r3}, true, ls, "ls r6 r3", "ls_r6_r3"},
     {{ls, r6, r4}, true, ls, "ls r6 r4", "ls_r6_r4"},
     {{ls, r6, r5}, true, ls, "ls r6 r5", "ls_r6_r5"},
     {{ls, r6, r6}, true, ls, "ls r6 r6", "ls_r6_r6"},
     {{ls, r6, r7}, true, ls, "ls r6 r7", "ls_r6_r7"},
     {{ls, r6, r8}, true, ls, "ls r6 r8", "ls_r6_r8"},
     {{ls, r6, r9}, true, ls, "ls r6 r9", "ls_r6_r9"},
     {{ls, r6, r10}, true, ls, "ls r6 r10", "ls_r6_r10"},
     {{ls, r6, r11}, true, ls, "ls r6 r11", "ls_r6_r11"},
     {{ls, r6, r12}, true, ls, "ls r6 r12", "ls_r6_r12"},
     {{ls, r6, r13}, true, ls, "ls r6 r13", "ls_r6_r13"},
     {{ls, r6, r14}, true, ls, "ls r6 r14", "ls_r6_r14"},
     {{ls, r7, r0}, true, ls, "ls r7 r0", "ls_r7_r0"},
     {{ls, r7, r1}, true, ls, "ls r7 r1", "ls_r7_r1"},
     {{ls, r7, r2}, true, ls, "ls r7 r2", "ls_r7_r2"},
     {{ls, r7, r3}, true, ls, "ls r7 r3", "ls_r7_r3"},
     {{ls, r7, r4}, true, ls, "ls r7 r4", "ls_r7_r4"},
     {{ls, r7, r5}, true, ls, "ls r7 r5", "ls_r7_r5"},
     {{ls, r7, r6}, true, ls, "ls r7 r6", "ls_r7_r6"},
     {{ls, r7, r7}, true, ls, "ls r7 r7", "ls_r7_r7"},
     {{ls, r7, r8}, true, ls, "ls r7 r8", "ls_r7_r8"},
     {{ls, r7, r9}, true, ls, "ls r7 r9", "ls_r7_r9"},
     {{ls, r7, r10}, true, ls, "ls r7 r10", "ls_r7_r10"},
     {{ls, r7, r11}, true, ls, "ls r7 r11", "ls_r7_r11"},
     {{ls, r7, r12}, true, ls, "ls r7 r12", "ls_r7_r12"},
     {{ls, r7, r13}, true, ls, "ls r7 r13", "ls_r7_r13"},
     {{ls, r7, r14}, true, ls, "ls r7 r14", "ls_r7_r14"},
     {{ls, r8, r0}, true, ls, "ls r8 r0", "ls_r8_r0"},
     {{ls, r8, r1}, true, ls, "ls r8 r1", "ls_r8_r1"},
     {{ls, r8, r2}, true, ls, "ls r8 r2", "ls_r8_r2"},
     {{ls, r8, r3}, true, ls, "ls r8 r3", "ls_r8_r3"},
     {{ls, r8, r4}, true, ls, "ls r8 r4", "ls_r8_r4"},
     {{ls, r8, r5}, true, ls, "ls r8 r5", "ls_r8_r5"},
     {{ls, r8, r6}, true, ls, "ls r8 r6", "ls_r8_r6"},
     {{ls, r8, r7}, true, ls, "ls r8 r7", "ls_r8_r7"},
     {{ls, r8, r8}, true, ls, "ls r8 r8", "ls_r8_r8"},
     {{ls, r8, r9}, true, ls, "ls r8 r9", "ls_r8_r9"},
     {{ls, r8, r10}, true, ls, "ls r8 r10", "ls_r8_r10"},
     {{ls, r8, r11}, true, ls, "ls r8 r11", "ls_r8_r11"},
     {{ls, r8, r12}, true, ls, "ls r8 r12", "ls_r8_r12"},
     {{ls, r8, r13}, true, ls, "ls r8 r13", "ls_r8_r13"},
     {{ls, r8, r14}, true, ls, "ls r8 r14", "ls_r8_r14"},
     {{ls, r9, r0}, true, ls, "ls r9 r0", "ls_r9_r0"},
     {{ls, r9, r1}, true, ls, "ls r9 r1", "ls_r9_r1"},
     {{ls, r9, r2}, true, ls, "ls r9 r2", "ls_r9_r2"},
     {{ls, r9, r3}, true, ls, "ls r9 r3", "ls_r9_r3"},
     {{ls, r9, r4}, true, ls, "ls r9 r4", "ls_r9_r4"},
     {{ls, r9, r5}, true, ls, "ls r9 r5", "ls_r9_r5"},
     {{ls, r9, r6}, true, ls, "ls r9 r6", "ls_r9_r6"},
     {{ls, r9, r7}, true, ls, "ls r9 r7", "ls_r9_r7"},
     {{ls, r9, r8}, true, ls, "ls r9 r8", "ls_r9_r8"},
     {{ls, r9, r9}, true, ls, "ls r9 r9", "ls_r9_r9"},
     {{ls, r9, r10}, true, ls, "ls r9 r10", "ls_r9_r10"},
     {{ls, r9, r11}, true, ls, "ls r9 r11", "ls_r9_r11"},
     {{ls, r9, r12}, true, ls, "ls r9 r12", "ls_r9_r12"},
     {{ls, r9, r13}, true, ls, "ls r9 r13", "ls_r9_r13"},
     {{ls, r9, r14}, true, ls, "ls r9 r14", "ls_r9_r14"},
     {{ls, r10, r0}, true, ls, "ls r10 r0", "ls_r10_r0"},
     {{ls, r10, r1}, true, ls, "ls r10 r1", "ls_r10_r1"},
     {{ls, r10, r2}, true, ls, "ls r10 r2", "ls_r10_r2"},
     {{ls, r10, r3}, true, ls, "ls r10 r3", "ls_r10_r3"},
     {{ls, r10, r4}, true, ls, "ls r10 r4", "ls_r10_r4"},
     {{ls, r10, r5}, true, ls, "ls r10 r5", "ls_r10_r5"},
     {{ls, r10, r6}, true, ls, "ls r10 r6", "ls_r10_r6"},
     {{ls, r10, r7}, true, ls, "ls r10 r7", "ls_r10_r7"},
     {{ls, r10, r8}, true, ls, "ls r10 r8", "ls_r10_r8"},
     {{ls, r10, r9}, true, ls, "ls r10 r9", "ls_r10_r9"},
     {{ls, r10, r10}, true, ls, "ls r10 r10", "ls_r10_r10"},
     {{ls, r10, r11}, true, ls, "ls r10 r11", "ls_r10_r11"},
     {{ls, r10, r12}, true, ls, "ls r10 r12", "ls_r10_r12"},
     {{ls, r10, r13}, true, ls, "ls r10 r13", "ls_r10_r13"},
     {{ls, r10, r14}, true, ls, "ls r10 r14", "ls_r10_r14"},
     {{ls, r11, r0}, true, ls, "ls r11 r0", "ls_r11_r0"},
     {{ls, r11, r1}, true, ls, "ls r11 r1", "ls_r11_r1"},
     {{ls, r11, r2}, true, ls, "ls r11 r2", "ls_r11_r2"},
     {{ls, r11, r3}, true, ls, "ls r11 r3", "ls_r11_r3"},
     {{ls, r11, r4}, true, ls, "ls r11 r4", "ls_r11_r4"},
     {{ls, r11, r5}, true, ls, "ls r11 r5", "ls_r11_r5"},
     {{ls, r11, r6}, true, ls, "ls r11 r6", "ls_r11_r6"},
     {{ls, r11, r7}, true, ls, "ls r11 r7", "ls_r11_r7"},
     {{ls, r11, r8}, true, ls, "ls r11 r8", "ls_r11_r8"},
     {{ls, r11, r9}, true, ls, "ls r11 r9", "ls_r11_r9"},
     {{ls, r11, r10}, true, ls, "ls r11 r10", "ls_r11_r10"},
     {{ls, r11, r11}, true, ls, "ls r11 r11", "ls_r11_r11"},
     {{ls, r11, r12}, true, ls, "ls r11 r12", "ls_r11_r12"},
     {{ls, r11, r13}, true, ls, "ls r11 r13", "ls_r11_r13"},
     {{ls, r11, r14}, true, ls, "ls r11 r14", "ls_r11_r14"},
     {{ls, r12, r0}, true, ls, "ls r12 r0", "ls_r12_r0"},
     {{ls, r12, r1}, true, ls, "ls r12 r1", "ls_r12_r1"},
     {{ls, r12, r2}, true, ls, "ls r12 r2", "ls_r12_r2"},
     {{ls, r12, r3}, true, ls, "ls r12 r3", "ls_r12_r3"},
     {{ls, r12, r4}, true, ls, "ls r12 r4", "ls_r12_r4"},
     {{ls, r12, r5}, true, ls, "ls r12 r5", "ls_r12_r5"},
     {{ls, r12, r6}, true, ls, "ls r12 r6", "ls_r12_r6"},
     {{ls, r12, r7}, true, ls, "ls r12 r7", "ls_r12_r7"},
     {{ls, r12, r8}, true, ls, "ls r12 r8", "ls_r12_r8"},
     {{ls, r12, r9}, true, ls, "ls r12 r9", "ls_r12_r9"},
     {{ls, r12, r10}, true, ls, "ls r12 r10", "ls_r12_r10"},
     {{ls, r12, r11}, true, ls, "ls r12 r11", "ls_r12_r11"},
     {{ls, r12, r12}, true, ls, "ls r12 r12", "ls_r12_r12"},
     {{ls, r12, r13}, true, ls, "ls r12 r13", "ls_r12_r13"},
     {{ls, r12, r14}, true, ls, "ls r12 r14", "ls_r12_r14"},
     {{ls, r13, r0}, true, ls, "ls r13 r0", "ls_r13_r0"},
     {{ls, r13, r1}, true, ls, "ls r13 r1", "ls_r13_r1"},
     {{ls, r13, r2}, true, ls, "ls r13 r2", "ls_r13_r2"},
     {{ls, r13, r3}, true, ls, "ls r13 r3", "ls_r13_r3"},
     {{ls, r13, r4}, true, ls, "ls r13 r4", "ls_r13_r4"},
     {{ls, r13, r5}, true, ls, "ls r13 r5", "ls_r13_r5"},
     {{ls, r13, r6}, true, ls, "ls r13 r6", "ls_r13_r6"},
     {{ls, r13, r7}, true, ls, "ls r13 r7", "ls_r13_r7"},
     {{ls, r13, r8}, true, ls, "ls r13 r8", "ls_r13_r8"},
     {{ls, r13, r9}, true, ls, "ls r13 r9", "ls_r13_r9"},
     {{ls, r13, r10}, true, ls, "ls r13 r10", "ls_r13_r10"},
     {{ls, r13, r11}, true, ls, "ls r13 r11", "ls_r13_r11"},
     {{ls, r13, r12}, true, ls, "ls r13 r12", "ls_r13_r12"},
     {{ls, r13, r13}, true, ls, "ls r13 r13", "ls_r13_r13"},
     {{ls, r13, r14}, true, ls, "ls r13 r14", "ls_r13_r14"},
     {{ls, r14, r0}, true, ls, "ls r14 r0", "ls_r14_r0"},
     {{ls, r14, r1}, true, ls, "ls r14 r1", "ls_r14_r1"},
     {{ls, r14, r2}, true, ls, "ls r14 r2", "ls_r14_r2"},
     {{ls, r14, r3}, true, ls, "ls r14 r3", "ls_r14_r3"},
     {{ls, r14, r4}, true, ls, "ls r14 r4", "ls_r14_r4"},
     {{ls, r14, r5}, true, ls, "ls r14 r5", "ls_r14_r5"},
     {{ls, r14, r6}, true, ls, "ls r14 r6", "ls_r14_r6"},
     {{ls, r14, r7}, true, ls, "ls r14 r7", "ls_r14_r7"},
     {{ls, r14, r8}, true, ls, "ls r14 r8", "ls_r14_r8"},
     {{ls, r14, r9}, true, ls, "ls r14 r9", "ls_r14_r9"},
     {{ls, r14, r10}, true, ls, "ls r14 r10", "ls_r14_r10"},
     {{ls, r14, r11}, true, ls, "ls r14 r11", "ls_r14_r11"},
     {{ls, r14, r12}, true, ls, "ls r14 r12", "ls_r14_r12"},
     {{ls, r14, r13}, true, ls, "ls r14 r13", "ls_r14_r13"},
     {{ls, r14, r14}, true, ls, "ls r14 r14", "ls_r14_r14"},
     {{ge, r0, r0}, true, ge, "ge r0 r0", "ge_r0_r0"},
     {{ge, r0, r1}, true, ge, "ge r0 r1", "ge_r0_r1"},
     {{ge, r0, r2}, true, ge, "ge r0 r2", "ge_r0_r2"},
     {{ge, r0, r3}, true, ge, "ge r0 r3", "ge_r0_r3"},
     {{ge, r0, r4}, true, ge, "ge r0 r4", "ge_r0_r4"},
     {{ge, r0, r5}, true, ge, "ge r0 r5", "ge_r0_r5"},
     {{ge, r0, r6}, true, ge, "ge r0 r6", "ge_r0_r6"},
     {{ge, r0, r7}, true, ge, "ge r0 r7", "ge_r0_r7"},
     {{ge, r0, r8}, true, ge, "ge r0 r8", "ge_r0_r8"},
     {{ge, r0, r9}, true, ge, "ge r0 r9", "ge_r0_r9"},
     {{ge, r0, r10}, true, ge, "ge r0 r10", "ge_r0_r10"},
     {{ge, r0, r11}, true, ge, "ge r0 r11", "ge_r0_r11"},
     {{ge, r0, r12}, true, ge, "ge r0 r12", "ge_r0_r12"},
     {{ge, r0, r13}, true, ge, "ge r0 r13", "ge_r0_r13"},
     {{ge, r0, r14}, true, ge, "ge r0 r14", "ge_r0_r14"},
     {{ge, r1, r0}, true, ge, "ge r1 r0", "ge_r1_r0"},
     {{ge, r1, r1}, true, ge, "ge r1 r1", "ge_r1_r1"},
     {{ge, r1, r2}, true, ge, "ge r1 r2", "ge_r1_r2"},
     {{ge, r1, r3}, true, ge, "ge r1 r3", "ge_r1_r3"},
     {{ge, r1, r4}, true, ge, "ge r1 r4", "ge_r1_r4"},
     {{ge, r1, r5}, true, ge, "ge r1 r5", "ge_r1_r5"},
     {{ge, r1, r6}, true, ge, "ge r1 r6", "ge_r1_r6"},
     {{ge, r1, r7}, true, ge, "ge r1 r7", "ge_r1_r7"},
     {{ge, r1, r8}, true, ge, "ge r1 r8", "ge_r1_r8"},
     {{ge, r1, r9}, true, ge, "ge r1 r9", "ge_r1_r9"},
     {{ge, r1, r10}, true, ge, "ge r1 r10", "ge_r1_r10"},
     {{ge, r1, r11}, true, ge, "ge r1 r11", "ge_r1_r11"},
     {{ge, r1, r12}, true, ge, "ge r1 r12", "ge_r1_r12"},
     {{ge, r1, r13}, true, ge, "ge r1 r13", "ge_r1_r13"},
     {{ge, r1, r14}, true, ge, "ge r1 r14", "ge_r1_r14"},
     {{ge, r2, r0}, true, ge, "ge r2 r0", "ge_r2_r0"},
     {{ge, r2, r1}, true, ge, "ge r2 r1", "ge_r2_r1"},
     {{ge, r2, r2}, true, ge, "ge r2 r2", "ge_r2_r2"},
     {{ge, r2, r3}, true, ge, "ge r2 r3", "ge_r2_r3"},
     {{ge, r2, r4}, true, ge, "ge r2 r4", "ge_r2_r4"},
     {{ge, r2, r5}, true, ge, "ge r2 r5", "ge_r2_r5"},
     {{ge, r2, r6}, true, ge, "ge r2 r6", "ge_r2_r6"},
     {{ge, r2, r7}, true, ge, "ge r2 r7", "ge_r2_r7"},
     {{ge, r2, r8}, true, ge, "ge r2 r8", "ge_r2_r8"},
     {{ge, r2, r9}, true, ge, "ge r2 r9", "ge_r2_r9"},
     {{ge, r2, r10}, true, ge, "ge r2 r10", "ge_r2_r10"},
     {{ge, r2, r11}, true, ge, "ge r2 r11", "ge_r2_r11"},
     {{ge, r2, r12}, true, ge, "ge r2 r12", "ge_r2_r12"},
     {{ge, r2, r13}, true, ge, "ge r2 r13", "ge_r2_r13"},
     {{ge, r2, r14}, true, ge, "ge r2 r14", "ge_r2_r14"},
     {{ge, r3, r0}, true, ge, "ge r3 r0", "ge_r3_r0"},
     {{ge, r3, r1}, true, ge, "ge r3 r1", "ge_r3_r1"},
     {{ge, r3, r2}, true, ge, "ge r3 r2", "ge_r3_r2"},
     {{ge, r3, r3}, true, ge, "ge r3 r3", "ge_r3_r3"},
     {{ge, r3, r4}, true, ge, "ge r3 r4", "ge_r3_r4"},
     {{ge, r3, r5}, true, ge, "ge r3 r5", "ge_r3_r5"},
     {{ge, r3, r6}, true, ge, "ge r3 r6", "ge_r3_r6"},
     {{ge, r3, r7}, true, ge, "ge r3 r7", "ge_r3_r7"},
     {{ge, r3, r8}, true, ge, "ge r3 r8", "ge_r3_r8"},
     {{ge, r3, r9}, true, ge, "ge r3 r9", "ge_r3_r9"},
     {{ge, r3, r10}, true, ge, "ge r3 r10", "ge_r3_r10"},
     {{ge, r3, r11}, true, ge, "ge r3 r11", "ge_r3_r11"},
     {{ge, r3, r12}, true, ge, "ge r3 r12", "ge_r3_r12"},
     {{ge, r3, r13}, true, ge, "ge r3 r13", "ge_r3_r13"},
     {{ge, r3, r14}, true, ge, "ge r3 r14", "ge_r3_r14"},
     {{ge, r4, r0}, true, ge, "ge r4 r0", "ge_r4_r0"},
     {{ge, r4, r1}, true, ge, "ge r4 r1", "ge_r4_r1"},
     {{ge, r4, r2}, true, ge, "ge r4 r2", "ge_r4_r2"},
     {{ge, r4, r3}, true, ge, "ge r4 r3", "ge_r4_r3"},
     {{ge, r4, r4}, true, ge, "ge r4 r4", "ge_r4_r4"},
     {{ge, r4, r5}, true, ge, "ge r4 r5", "ge_r4_r5"},
     {{ge, r4, r6}, true, ge, "ge r4 r6", "ge_r4_r6"},
     {{ge, r4, r7}, true, ge, "ge r4 r7", "ge_r4_r7"},
     {{ge, r4, r8}, true, ge, "ge r4 r8", "ge_r4_r8"},
     {{ge, r4, r9}, true, ge, "ge r4 r9", "ge_r4_r9"},
     {{ge, r4, r10}, true, ge, "ge r4 r10", "ge_r4_r10"},
     {{ge, r4, r11}, true, ge, "ge r4 r11", "ge_r4_r11"},
     {{ge, r4, r12}, true, ge, "ge r4 r12", "ge_r4_r12"},
     {{ge, r4, r13}, true, ge, "ge r4 r13", "ge_r4_r13"},
     {{ge, r4, r14}, true, ge, "ge r4 r14", "ge_r4_r14"},
     {{ge, r5, r0}, true, ge, "ge r5 r0", "ge_r5_r0"},
     {{ge, r5, r1}, true, ge, "ge r5 r1", "ge_r5_r1"},
     {{ge, r5, r2}, true, ge, "ge r5 r2", "ge_r5_r2"},
     {{ge, r5, r3}, true, ge, "ge r5 r3", "ge_r5_r3"},
     {{ge, r5, r4}, true, ge, "ge r5 r4", "ge_r5_r4"},
     {{ge, r5, r5}, true, ge, "ge r5 r5", "ge_r5_r5"},
     {{ge, r5, r6}, true, ge, "ge r5 r6", "ge_r5_r6"},
     {{ge, r5, r7}, true, ge, "ge r5 r7", "ge_r5_r7"},
     {{ge, r5, r8}, true, ge, "ge r5 r8", "ge_r5_r8"},
     {{ge, r5, r9}, true, ge, "ge r5 r9", "ge_r5_r9"},
     {{ge, r5, r10}, true, ge, "ge r5 r10", "ge_r5_r10"},
     {{ge, r5, r11}, true, ge, "ge r5 r11", "ge_r5_r11"},
     {{ge, r5, r12}, true, ge, "ge r5 r12", "ge_r5_r12"},
     {{ge, r5, r13}, true, ge, "ge r5 r13", "ge_r5_r13"},
     {{ge, r5, r14}, true, ge, "ge r5 r14", "ge_r5_r14"},
     {{ge, r6, r0}, true, ge, "ge r6 r0", "ge_r6_r0"},
     {{ge, r6, r1}, true, ge, "ge r6 r1", "ge_r6_r1"},
     {{ge, r6, r2}, true, ge, "ge r6 r2", "ge_r6_r2"},
     {{ge, r6, r3}, true, ge, "ge r6 r3", "ge_r6_r3"},
     {{ge, r6, r4}, true, ge, "ge r6 r4", "ge_r6_r4"},
     {{ge, r6, r5}, true, ge, "ge r6 r5", "ge_r6_r5"},
     {{ge, r6, r6}, true, ge, "ge r6 r6", "ge_r6_r6"},
     {{ge, r6, r7}, true, ge, "ge r6 r7", "ge_r6_r7"},
     {{ge, r6, r8}, true, ge, "ge r6 r8", "ge_r6_r8"},
     {{ge, r6, r9}, true, ge, "ge r6 r9", "ge_r6_r9"},
     {{ge, r6, r10}, true, ge, "ge r6 r10", "ge_r6_r10"},
     {{ge, r6, r11}, true, ge, "ge r6 r11", "ge_r6_r11"},
     {{ge, r6, r12}, true, ge, "ge r6 r12", "ge_r6_r12"},
     {{ge, r6, r13}, true, ge, "ge r6 r13", "ge_r6_r13"},
     {{ge, r6, r14}, true, ge, "ge r6 r14", "ge_r6_r14"},
     {{ge, r7, r0}, true, ge, "ge r7 r0", "ge_r7_r0"},
     {{ge, r7, r1}, true, ge, "ge r7 r1", "ge_r7_r1"},
     {{ge, r7, r2}, true, ge, "ge r7 r2", "ge_r7_r2"},
     {{ge, r7, r3}, true, ge, "ge r7 r3", "ge_r7_r3"},
     {{ge, r7, r4}, true, ge, "ge r7 r4", "ge_r7_r4"},
     {{ge, r7, r5}, true, ge, "ge r7 r5", "ge_r7_r5"},
     {{ge, r7, r6}, true, ge, "ge r7 r6", "ge_r7_r6"},
     {{ge, r7, r7}, true, ge, "ge r7 r7", "ge_r7_r7"},
     {{ge, r7, r8}, true, ge, "ge r7 r8", "ge_r7_r8"},
     {{ge, r7, r9}, true, ge, "ge r7 r9", "ge_r7_r9"},
     {{ge, r7, r10}, true, ge, "ge r7 r10", "ge_r7_r10"},
     {{ge, r7, r11}, true, ge, "ge r7 r11", "ge_r7_r11"},
     {{ge, r7, r12}, true, ge, "ge r7 r12", "ge_r7_r12"},
     {{ge, r7, r13}, true, ge, "ge r7 r13", "ge_r7_r13"},
     {{ge, r7, r14}, true, ge, "ge r7 r14", "ge_r7_r14"},
     {{ge, r8, r0}, true, ge, "ge r8 r0", "ge_r8_r0"},
     {{ge, r8, r1}, true, ge, "ge r8 r1", "ge_r8_r1"},
     {{ge, r8, r2}, true, ge, "ge r8 r2", "ge_r8_r2"},
     {{ge, r8, r3}, true, ge, "ge r8 r3", "ge_r8_r3"},
     {{ge, r8, r4}, true, ge, "ge r8 r4", "ge_r8_r4"},
     {{ge, r8, r5}, true, ge, "ge r8 r5", "ge_r8_r5"},
     {{ge, r8, r6}, true, ge, "ge r8 r6", "ge_r8_r6"},
     {{ge, r8, r7}, true, ge, "ge r8 r7", "ge_r8_r7"},
     {{ge, r8, r8}, true, ge, "ge r8 r8", "ge_r8_r8"},
     {{ge, r8, r9}, true, ge, "ge r8 r9", "ge_r8_r9"},
     {{ge, r8, r10}, true, ge, "ge r8 r10", "ge_r8_r10"},
     {{ge, r8, r11}, true, ge, "ge r8 r11", "ge_r8_r11"},
     {{ge, r8, r12}, true, ge, "ge r8 r12", "ge_r8_r12"},
     {{ge, r8, r13}, true, ge, "ge r8 r13", "ge_r8_r13"},
     {{ge, r8, r14}, true, ge, "ge r8 r14", "ge_r8_r14"},
     {{ge, r9, r0}, true, ge, "ge r9 r0", "ge_r9_r0"},
     {{ge, r9, r1}, true, ge, "ge r9 r1", "ge_r9_r1"},
     {{ge, r9, r2}, true, ge, "ge r9 r2", "ge_r9_r2"},
     {{ge, r9, r3}, true, ge, "ge r9 r3", "ge_r9_r3"},
     {{ge, r9, r4}, true, ge, "ge r9 r4", "ge_r9_r4"},
     {{ge, r9, r5}, true, ge, "ge r9 r5", "ge_r9_r5"},
     {{ge, r9, r6}, true, ge, "ge r9 r6", "ge_r9_r6"},
     {{ge, r9, r7}, true, ge, "ge r9 r7", "ge_r9_r7"},
     {{ge, r9, r8}, true, ge, "ge r9 r8", "ge_r9_r8"},
     {{ge, r9, r9}, true, ge, "ge r9 r9", "ge_r9_r9"},
     {{ge, r9, r10}, true, ge, "ge r9 r10", "ge_r9_r10"},
     {{ge, r9, r11}, true, ge, "ge r9 r11", "ge_r9_r11"},
     {{ge, r9, r12}, true, ge, "ge r9 r12", "ge_r9_r12"},
     {{ge, r9, r13}, true, ge, "ge r9 r13", "ge_r9_r13"},
     {{ge, r9, r14}, true, ge, "ge r9 r14", "ge_r9_r14"},
     {{ge, r10, r0}, true, ge, "ge r10 r0", "ge_r10_r0"},
     {{ge, r10, r1}, true, ge, "ge r10 r1", "ge_r10_r1"},
     {{ge, r10, r2}, true, ge, "ge r10 r2", "ge_r10_r2"},
     {{ge, r10, r3}, true, ge, "ge r10 r3", "ge_r10_r3"},
     {{ge, r10, r4}, true, ge, "ge r10 r4", "ge_r10_r4"},
     {{ge, r10, r5}, true, ge, "ge r10 r5", "ge_r10_r5"},
     {{ge, r10, r6}, true, ge, "ge r10 r6", "ge_r10_r6"},
     {{ge, r10, r7}, true, ge, "ge r10 r7", "ge_r10_r7"},
     {{ge, r10, r8}, true, ge, "ge r10 r8", "ge_r10_r8"},
     {{ge, r10, r9}, true, ge, "ge r10 r9", "ge_r10_r9"},
     {{ge, r10, r10}, true, ge, "ge r10 r10", "ge_r10_r10"},
     {{ge, r10, r11}, true, ge, "ge r10 r11", "ge_r10_r11"},
     {{ge, r10, r12}, true, ge, "ge r10 r12", "ge_r10_r12"},
     {{ge, r10, r13}, true, ge, "ge r10 r13", "ge_r10_r13"},
     {{ge, r10, r14}, true, ge, "ge r10 r14", "ge_r10_r14"},
     {{ge, r11, r0}, true, ge, "ge r11 r0", "ge_r11_r0"},
     {{ge, r11, r1}, true, ge, "ge r11 r1", "ge_r11_r1"},
     {{ge, r11, r2}, true, ge, "ge r11 r2", "ge_r11_r2"},
     {{ge, r11, r3}, true, ge, "ge r11 r3", "ge_r11_r3"},
     {{ge, r11, r4}, true, ge, "ge r11 r4", "ge_r11_r4"},
     {{ge, r11, r5}, true, ge, "ge r11 r5", "ge_r11_r5"},
     {{ge, r11, r6}, true, ge, "ge r11 r6", "ge_r11_r6"},
     {{ge, r11, r7}, true, ge, "ge r11 r7", "ge_r11_r7"},
     {{ge, r11, r8}, true, ge, "ge r11 r8", "ge_r11_r8"},
     {{ge, r11, r9}, true, ge, "ge r11 r9", "ge_r11_r9"},
     {{ge, r11, r10}, true, ge, "ge r11 r10", "ge_r11_r10"},
     {{ge, r11, r11}, true, ge, "ge r11 r11", "ge_r11_r11"},
     {{ge, r11, r12}, true, ge, "ge r11 r12", "ge_r11_r12"},
     {{ge, r11, r13}, true, ge, "ge r11 r13", "ge_r11_r13"},
     {{ge, r11, r14}, true, ge, "ge r11 r14", "ge_r11_r14"},
     {{ge, r12, r0}, true, ge, "ge r12 r0", "ge_r12_r0"},
     {{ge, r12, r1}, true, ge, "ge r12 r1", "ge_r12_r1"},
     {{ge, r12, r2}, true, ge, "ge r12 r2", "ge_r12_r2"},
     {{ge, r12, r3}, true, ge, "ge r12 r3", "ge_r12_r3"},
     {{ge, r12, r4}, true, ge, "ge r12 r4", "ge_r12_r4"},
     {{ge, r12, r5}, true, ge, "ge r12 r5", "ge_r12_r5"},
     {{ge, r12, r6}, true, ge, "ge r12 r6", "ge_r12_r6"},
     {{ge, r12, r7}, true, ge, "ge r12 r7", "ge_r12_r7"},
     {{ge, r12, r8}, true, ge, "ge r12 r8", "ge_r12_r8"},
     {{ge, r12, r9}, true, ge, "ge r12 r9", "ge_r12_r9"},
     {{ge, r12, r10}, true, ge, "ge r12 r10", "ge_r12_r10"},
     {{ge, r12, r11}, true, ge, "ge r12 r11", "ge_r12_r11"},
     {{ge, r12, r12}, true, ge, "ge r12 r12", "ge_r12_r12"},
     {{ge, r12, r13}, true, ge, "ge r12 r13", "ge_r12_r13"},
     {{ge, r12, r14}, true, ge, "ge r12 r14", "ge_r12_r14"},
     {{ge, r13, r0}, true, ge, "ge r13 r0", "ge_r13_r0"},
     {{ge, r13, r1}, true, ge, "ge r13 r1", "ge_r13_r1"},
     {{ge, r13, r2}, true, ge, "ge r13 r2", "ge_r13_r2"},
     {{ge, r13, r3}, true, ge, "ge r13 r3", "ge_r13_r3"},
     {{ge, r13, r4}, true, ge, "ge r13 r4", "ge_r13_r4"},
     {{ge, r13, r5}, true, ge, "ge r13 r5", "ge_r13_r5"},
     {{ge, r13, r6}, true, ge, "ge r13 r6", "ge_r13_r6"},
     {{ge, r13, r7}, true, ge, "ge r13 r7", "ge_r13_r7"},
     {{ge, r13, r8}, true, ge, "ge r13 r8", "ge_r13_r8"},
     {{ge, r13, r9}, true, ge, "ge r13 r9", "ge_r13_r9"},
     {{ge, r13, r10}, true, ge, "ge r13 r10", "ge_r13_r10"},
     {{ge, r13, r11}, true, ge, "ge r13 r11", "ge_r13_r11"},
     {{ge, r13, r12}, true, ge, "ge r13 r12", "ge_r13_r12"},
     {{ge, r13, r13}, true, ge, "ge r13 r13", "ge_r13_r13"},
     {{ge, r13, r14}, true, ge, "ge r13 r14", "ge_r13_r14"},
     {{ge, r14, r0}, true, ge, "ge r14 r0", "ge_r14_r0"},
     {{ge, r14, r1}, true, ge, "ge r14 r1", "ge_r14_r1"},
     {{ge, r14, r2}, true, ge, "ge r14 r2", "ge_r14_r2"},
     {{ge, r14, r3}, true, ge, "ge r14 r3", "ge_r14_r3"},
     {{ge, r14, r4}, true, ge, "ge r14 r4", "ge_r14_r4"},
     {{ge, r14, r5}, true, ge, "ge r14 r5", "ge_r14_r5"},
     {{ge, r14, r6}, true, ge, "ge r14 r6", "ge_r14_r6"},
     {{ge, r14, r7}, true, ge, "ge r14 r7", "ge_r14_r7"},
     {{ge, r14, r8}, true, ge, "ge r14 r8", "ge_r14_r8"},
     {{ge, r14, r9}, true, ge, "ge r14 r9", "ge_r14_r9"},
     {{ge, r14, r10}, true, ge, "ge r14 r10", "ge_r14_r10"},
     {{ge, r14, r11}, true, ge, "ge r14 r11", "ge_r14_r11"},
     {{ge, r14, r12}, true, ge, "ge r14 r12", "ge_r14_r12"},
     {{ge, r14, r13}, true, ge, "ge r14 r13", "ge_r14_r13"},
     {{ge, r14, r14}, true, ge, "ge r14 r14", "ge_r14_r14"},
     {{lt, r0, r0}, true, lt, "lt r0 r0", "lt_r0_r0"},
     {{lt, r0, r1}, true, lt, "lt r0 r1", "lt_r0_r1"},
     {{lt, r0, r2}, true, lt, "lt r0 r2", "lt_r0_r2"},
     {{lt, r0, r3}, true, lt, "lt r0 r3", "lt_r0_r3"},
     {{lt, r0, r4}, true, lt, "lt r0 r4", "lt_r0_r4"},
     {{lt, r0, r5}, true, lt, "lt r0 r5", "lt_r0_r5"},
     {{lt, r0, r6}, true, lt, "lt r0 r6", "lt_r0_r6"},
     {{lt, r0, r7}, true, lt, "lt r0 r7", "lt_r0_r7"},
     {{lt, r0, r8}, true, lt, "lt r0 r8", "lt_r0_r8"},
     {{lt, r0, r9}, true, lt, "lt r0 r9", "lt_r0_r9"},
     {{lt, r0, r10}, true, lt, "lt r0 r10", "lt_r0_r10"},
     {{lt, r0, r11}, true, lt, "lt r0 r11", "lt_r0_r11"},
     {{lt, r0, r12}, true, lt, "lt r0 r12", "lt_r0_r12"},
     {{lt, r0, r13}, true, lt, "lt r0 r13", "lt_r0_r13"},
     {{lt, r0, r14}, true, lt, "lt r0 r14", "lt_r0_r14"},
     {{lt, r1, r0}, true, lt, "lt r1 r0", "lt_r1_r0"},
     {{lt, r1, r1}, true, lt, "lt r1 r1", "lt_r1_r1"},
     {{lt, r1, r2}, true, lt, "lt r1 r2", "lt_r1_r2"},
     {{lt, r1, r3}, true, lt, "lt r1 r3", "lt_r1_r3"},
     {{lt, r1, r4}, true, lt, "lt r1 r4", "lt_r1_r4"},
     {{lt, r1, r5}, true, lt, "lt r1 r5", "lt_r1_r5"},
     {{lt, r1, r6}, true, lt, "lt r1 r6", "lt_r1_r6"},
     {{lt, r1, r7}, true, lt, "lt r1 r7", "lt_r1_r7"},
     {{lt, r1, r8}, true, lt, "lt r1 r8", "lt_r1_r8"},
     {{lt, r1, r9}, true, lt, "lt r1 r9", "lt_r1_r9"},
     {{lt, r1, r10}, true, lt, "lt r1 r10", "lt_r1_r10"},
     {{lt, r1, r11}, true, lt, "lt r1 r11", "lt_r1_r11"},
     {{lt, r1, r12}, true, lt, "lt r1 r12", "lt_r1_r12"},
     {{lt, r1, r13}, true, lt, "lt r1 r13", "lt_r1_r13"},
     {{lt, r1, r14}, true, lt, "lt r1 r14", "lt_r1_r14"},
     {{lt, r2, r0}, true, lt, "lt r2 r0", "lt_r2_r0"},
     {{lt, r2, r1}, true, lt, "lt r2 r1", "lt_r2_r1"},
     {{lt, r2, r2}, true, lt, "lt r2 r2", "lt_r2_r2"},
     {{lt, r2, r3}, true, lt, "lt r2 r3", "lt_r2_r3"},
     {{lt, r2, r4}, true, lt, "lt r2 r4", "lt_r2_r4"},
     {{lt, r2, r5}, true, lt, "lt r2 r5", "lt_r2_r5"},
     {{lt, r2, r6}, true, lt, "lt r2 r6", "lt_r2_r6"},
     {{lt, r2, r7}, true, lt, "lt r2 r7", "lt_r2_r7"},
     {{lt, r2, r8}, true, lt, "lt r2 r8", "lt_r2_r8"},
     {{lt, r2, r9}, true, lt, "lt r2 r9", "lt_r2_r9"},
     {{lt, r2, r10}, true, lt, "lt r2 r10", "lt_r2_r10"},
     {{lt, r2, r11}, true, lt, "lt r2 r11", "lt_r2_r11"},
     {{lt, r2, r12}, true, lt, "lt r2 r12", "lt_r2_r12"},
     {{lt, r2, r13}, true, lt, "lt r2 r13", "lt_r2_r13"},
     {{lt, r2, r14}, true, lt, "lt r2 r14", "lt_r2_r14"},
     {{lt, r3, r0}, true, lt, "lt r3 r0", "lt_r3_r0"},
     {{lt, r3, r1}, true, lt, "lt r3 r1", "lt_r3_r1"},
     {{lt, r3, r2}, true, lt, "lt r3 r2", "lt_r3_r2"},
     {{lt, r3, r3}, true, lt, "lt r3 r3", "lt_r3_r3"},
     {{lt, r3, r4}, true, lt, "lt r3 r4", "lt_r3_r4"},
     {{lt, r3, r5}, true, lt, "lt r3 r5", "lt_r3_r5"},
     {{lt, r3, r6}, true, lt, "lt r3 r6", "lt_r3_r6"},
     {{lt, r3, r7}, true, lt, "lt r3 r7", "lt_r3_r7"},
     {{lt, r3, r8}, true, lt, "lt r3 r8", "lt_r3_r8"},
     {{lt, r3, r9}, true, lt, "lt r3 r9", "lt_r3_r9"},
     {{lt, r3, r10}, true, lt, "lt r3 r10", "lt_r3_r10"},
     {{lt, r3, r11}, true, lt, "lt r3 r11", "lt_r3_r11"},
     {{lt, r3, r12}, true, lt, "lt r3 r12", "lt_r3_r12"},
     {{lt, r3, r13}, true, lt, "lt r3 r13", "lt_r3_r13"},
     {{lt, r3, r14}, true, lt, "lt r3 r14", "lt_r3_r14"},
     {{lt, r4, r0}, true, lt, "lt r4 r0", "lt_r4_r0"},
     {{lt, r4, r1}, true, lt, "lt r4 r1", "lt_r4_r1"},
     {{lt, r4, r2}, true, lt, "lt r4 r2", "lt_r4_r2"},
     {{lt, r4, r3}, true, lt, "lt r4 r3", "lt_r4_r3"},
     {{lt, r4, r4}, true, lt, "lt r4 r4", "lt_r4_r4"},
     {{lt, r4, r5}, true, lt, "lt r4 r5", "lt_r4_r5"},
     {{lt, r4, r6}, true, lt, "lt r4 r6", "lt_r4_r6"},
     {{lt, r4, r7}, true, lt, "lt r4 r7", "lt_r4_r7"},
     {{lt, r4, r8}, true, lt, "lt r4 r8", "lt_r4_r8"},
     {{lt, r4, r9}, true, lt, "lt r4 r9", "lt_r4_r9"},
     {{lt, r4, r10}, true, lt, "lt r4 r10", "lt_r4_r10"},
     {{lt, r4, r11}, true, lt, "lt r4 r11", "lt_r4_r11"},
     {{lt, r4, r12}, true, lt, "lt r4 r12", "lt_r4_r12"},
     {{lt, r4, r13}, true, lt, "lt r4 r13", "lt_r4_r13"},
     {{lt, r4, r14}, true, lt, "lt r4 r14", "lt_r4_r14"},
     {{lt, r5, r0}, true, lt, "lt r5 r0", "lt_r5_r0"},
     {{lt, r5, r1}, true, lt, "lt r5 r1", "lt_r5_r1"},
     {{lt, r5, r2}, true, lt, "lt r5 r2", "lt_r5_r2"},
     {{lt, r5, r3}, true, lt, "lt r5 r3", "lt_r5_r3"},
     {{lt, r5, r4}, true, lt, "lt r5 r4", "lt_r5_r4"},
     {{lt, r5, r5}, true, lt, "lt r5 r5", "lt_r5_r5"},
     {{lt, r5, r6}, true, lt, "lt r5 r6", "lt_r5_r6"},
     {{lt, r5, r7}, true, lt, "lt r5 r7", "lt_r5_r7"},
     {{lt, r5, r8}, true, lt, "lt r5 r8", "lt_r5_r8"},
     {{lt, r5, r9}, true, lt, "lt r5 r9", "lt_r5_r9"},
     {{lt, r5, r10}, true, lt, "lt r5 r10", "lt_r5_r10"},
     {{lt, r5, r11}, true, lt, "lt r5 r11", "lt_r5_r11"},
     {{lt, r5, r12}, true, lt, "lt r5 r12", "lt_r5_r12"},
     {{lt, r5, r13}, true, lt, "lt r5 r13", "lt_r5_r13"},
     {{lt, r5, r14}, true, lt, "lt r5 r14", "lt_r5_r14"},
     {{lt, r6, r0}, true, lt, "lt r6 r0", "lt_r6_r0"},
     {{lt, r6, r1}, true, lt, "lt r6 r1", "lt_r6_r1"},
     {{lt, r6, r2}, true, lt, "lt r6 r2", "lt_r6_r2"},
     {{lt, r6, r3}, true, lt, "lt r6 r3", "lt_r6_r3"},
     {{lt, r6, r4}, true, lt, "lt r6 r4", "lt_r6_r4"},
     {{lt, r6, r5}, true, lt, "lt r6 r5", "lt_r6_r5"},
     {{lt, r6, r6}, true, lt, "lt r6 r6", "lt_r6_r6"},
     {{lt, r6, r7}, true, lt, "lt r6 r7", "lt_r6_r7"},
     {{lt, r6, r8}, true, lt, "lt r6 r8", "lt_r6_r8"},
     {{lt, r6, r9}, true, lt, "lt r6 r9", "lt_r6_r9"},
     {{lt, r6, r10}, true, lt, "lt r6 r10", "lt_r6_r10"},
     {{lt, r6, r11}, true, lt, "lt r6 r11", "lt_r6_r11"},
     {{lt, r6, r12}, true, lt, "lt r6 r12", "lt_r6_r12"},
     {{lt, r6, r13}, true, lt, "lt r6 r13", "lt_r6_r13"},
     {{lt, r6, r14}, true, lt, "lt r6 r14", "lt_r6_r14"},
     {{lt, r7, r0}, true, lt, "lt r7 r0", "lt_r7_r0"},
     {{lt, r7, r1}, true, lt, "lt r7 r1", "lt_r7_r1"},
     {{lt, r7, r2}, true, lt, "lt r7 r2", "lt_r7_r2"},
     {{lt, r7, r3}, true, lt, "lt r7 r3", "lt_r7_r3"},
     {{lt, r7, r4}, true, lt, "lt r7 r4", "lt_r7_r4"},
     {{lt, r7, r5}, true, lt, "lt r7 r5", "lt_r7_r5"},
     {{lt, r7, r6}, true, lt, "lt r7 r6", "lt_r7_r6"},
     {{lt, r7, r7}, true, lt, "lt r7 r7", "lt_r7_r7"},
     {{lt, r7, r8}, true, lt, "lt r7 r8", "lt_r7_r8"},
     {{lt, r7, r9}, true, lt, "lt r7 r9", "lt_r7_r9"},
     {{lt, r7, r10}, true, lt, "lt r7 r10", "lt_r7_r10"},
     {{lt, r7, r11}, true, lt, "lt r7 r11", "lt_r7_r11"},
     {{lt, r7, r12}, true, lt, "lt r7 r12", "lt_r7_r12"},
     {{lt, r7, r13}, true, lt, "lt r7 r13", "lt_r7_r13"},
     {{lt, r7, r14}, true, lt, "lt r7 r14", "lt_r7_r14"},
     {{lt, r8, r0}, true, lt, "lt r8 r0", "lt_r8_r0"},
     {{lt, r8, r1}, true, lt, "lt r8 r1", "lt_r8_r1"},
     {{lt, r8, r2}, true, lt, "lt r8 r2", "lt_r8_r2"},
     {{lt, r8, r3}, true, lt, "lt r8 r3", "lt_r8_r3"},
     {{lt, r8, r4}, true, lt, "lt r8 r4", "lt_r8_r4"},
     {{lt, r8, r5}, true, lt, "lt r8 r5", "lt_r8_r5"},
     {{lt, r8, r6}, true, lt, "lt r8 r6", "lt_r8_r6"},
     {{lt, r8, r7}, true, lt, "lt r8 r7", "lt_r8_r7"},
     {{lt, r8, r8}, true, lt, "lt r8 r8", "lt_r8_r8"},
     {{lt, r8, r9}, true, lt, "lt r8 r9", "lt_r8_r9"},
     {{lt, r8, r10}, true, lt, "lt r8 r10", "lt_r8_r10"},
     {{lt, r8, r11}, true, lt, "lt r8 r11", "lt_r8_r11"},
     {{lt, r8, r12}, true, lt, "lt r8 r12", "lt_r8_r12"},
     {{lt, r8, r13}, true, lt, "lt r8 r13", "lt_r8_r13"},
     {{lt, r8, r14}, true, lt, "lt r8 r14", "lt_r8_r14"},
     {{lt, r9, r0}, true, lt, "lt r9 r0", "lt_r9_r0"},
     {{lt, r9, r1}, true, lt, "lt r9 r1", "lt_r9_r1"},
     {{lt, r9, r2}, true, lt, "lt r9 r2", "lt_r9_r2"},
     {{lt, r9, r3}, true, lt, "lt r9 r3", "lt_r9_r3"},
     {{lt, r9, r4}, true, lt, "lt r9 r4", "lt_r9_r4"},
     {{lt, r9, r5}, true, lt, "lt r9 r5", "lt_r9_r5"},
     {{lt, r9, r6}, true, lt, "lt r9 r6", "lt_r9_r6"},
     {{lt, r9, r7}, true, lt, "lt r9 r7", "lt_r9_r7"},
     {{lt, r9, r8}, true, lt, "lt r9 r8", "lt_r9_r8"},
     {{lt, r9, r9}, true, lt, "lt r9 r9", "lt_r9_r9"},
     {{lt, r9, r10}, true, lt, "lt r9 r10", "lt_r9_r10"},
     {{lt, r9, r11}, true, lt, "lt r9 r11", "lt_r9_r11"},
     {{lt, r9, r12}, true, lt, "lt r9 r12", "lt_r9_r12"},
     {{lt, r9, r13}, true, lt, "lt r9 r13", "lt_r9_r13"},
     {{lt, r9, r14}, true, lt, "lt r9 r14", "lt_r9_r14"},
     {{lt, r10, r0}, true, lt, "lt r10 r0", "lt_r10_r0"},
     {{lt, r10, r1}, true, lt, "lt r10 r1", "lt_r10_r1"},
     {{lt, r10, r2}, true, lt, "lt r10 r2", "lt_r10_r2"},
     {{lt, r10, r3}, true, lt, "lt r10 r3", "lt_r10_r3"},
     {{lt, r10, r4}, true, lt, "lt r10 r4", "lt_r10_r4"},
     {{lt, r10, r5}, true, lt, "lt r10 r5", "lt_r10_r5"},
     {{lt, r10, r6}, true, lt, "lt r10 r6", "lt_r10_r6"},
     {{lt, r10, r7}, true, lt, "lt r10 r7", "lt_r10_r7"},
     {{lt, r10, r8}, true, lt, "lt r10 r8", "lt_r10_r8"},
     {{lt, r10, r9}, true, lt, "lt r10 r9", "lt_r10_r9"},
     {{lt, r10, r10}, true, lt, "lt r10 r10", "lt_r10_r10"},
     {{lt, r10, r11}, true, lt, "lt r10 r11", "lt_r10_r11"},
     {{lt, r10, r12}, true, lt, "lt r10 r12", "lt_r10_r12"},
     {{lt, r10, r13}, true, lt, "lt r10 r13", "lt_r10_r13"},
     {{lt, r10, r14}, true, lt, "lt r10 r14", "lt_r10_r14"},
     {{lt, r11, r0}, true, lt, "lt r11 r0", "lt_r11_r0"},
     {{lt, r11, r1}, true, lt, "lt r11 r1", "lt_r11_r1"},
     {{lt, r11, r2}, true, lt, "lt r11 r2", "lt_r11_r2"},
     {{lt, r11, r3}, true, lt, "lt r11 r3", "lt_r11_r3"},
     {{lt, r11, r4}, true, lt, "lt r11 r4", "lt_r11_r4"},
     {{lt, r11, r5}, true, lt, "lt r11 r5", "lt_r11_r5"},
     {{lt, r11, r6}, true, lt, "lt r11 r6", "lt_r11_r6"},
     {{lt, r11, r7}, true, lt, "lt r11 r7", "lt_r11_r7"},
     {{lt, r11, r8}, true, lt, "lt r11 r8", "lt_r11_r8"},
     {{lt, r11, r9}, true, lt, "lt r11 r9", "lt_r11_r9"},
     {{lt, r11, r10}, true, lt, "lt r11 r10", "lt_r11_r10"},
     {{lt, r11, r11}, true, lt, "lt r11 r11", "lt_r11_r11"},
     {{lt, r11, r12}, true, lt, "lt r11 r12", "lt_r11_r12"},
     {{lt, r11, r13}, true, lt, "lt r11 r13", "lt_r11_r13"},
     {{lt, r11, r14}, true, lt, "lt r11 r14", "lt_r11_r14"},
     {{lt, r12, r0}, true, lt, "lt r12 r0", "lt_r12_r0"},
     {{lt, r12, r1}, true, lt, "lt r12 r1", "lt_r12_r1"},
     {{lt, r12, r2}, true, lt, "lt r12 r2", "lt_r12_r2"},
     {{lt, r12, r3}, true, lt, "lt r12 r3", "lt_r12_r3"},
     {{lt, r12, r4}, true, lt, "lt r12 r4", "lt_r12_r4"},
     {{lt, r12, r5}, true, lt, "lt r12 r5", "lt_r12_r5"},
     {{lt, r12, r6}, true, lt, "lt r12 r6", "lt_r12_r6"},
     {{lt, r12, r7}, true, lt, "lt r12 r7", "lt_r12_r7"},
     {{lt, r12, r8}, true, lt, "lt r12 r8", "lt_r12_r8"},
     {{lt, r12, r9}, true, lt, "lt r12 r9", "lt_r12_r9"},
     {{lt, r12, r10}, true, lt, "lt r12 r10", "lt_r12_r10"},
     {{lt, r12, r11}, true, lt, "lt r12 r11", "lt_r12_r11"},
     {{lt, r12, r12}, true, lt, "lt r12 r12", "lt_r12_r12"},
     {{lt, r12, r13}, true, lt, "lt r12 r13", "lt_r12_r13"},
     {{lt, r12, r14}, true, lt, "lt r12 r14", "lt_r12_r14"},
     {{lt, r13, r0}, true, lt, "lt r13 r0", "lt_r13_r0"},
     {{lt, r13, r1}, true, lt, "lt r13 r1", "lt_r13_r1"},
     {{lt, r13, r2}, true, lt, "lt r13 r2", "lt_r13_r2"},
     {{lt, r13, r3}, true, lt, "lt r13 r3", "lt_r13_r3"},
     {{lt, r13, r4}, true, lt, "lt r13 r4", "lt_r13_r4"},
     {{lt, r13, r5}, true, lt, "lt r13 r5", "lt_r13_r5"},
     {{lt, r13, r6}, true, lt, "lt r13 r6", "lt_r13_r6"},
     {{lt, r13, r7}, true, lt, "lt r13 r7", "lt_r13_r7"},
     {{lt, r13, r8}, true, lt, "lt r13 r8", "lt_r13_r8"},
     {{lt, r13, r9}, true, lt, "lt r13 r9", "lt_r13_r9"},
     {{lt, r13, r10}, true, lt, "lt r13 r10", "lt_r13_r10"},
     {{lt, r13, r11}, true, lt, "lt r13 r11", "lt_r13_r11"},
     {{lt, r13, r12}, true, lt, "lt r13 r12", "lt_r13_r12"},
     {{lt, r13, r13}, true, lt, "lt r13 r13", "lt_r13_r13"},
     {{lt, r13, r14}, true, lt, "lt r13 r14", "lt_r13_r14"},
     {{lt, r14, r0}, true, lt, "lt r14 r0", "lt_r14_r0"},
     {{lt, r14, r1}, true, lt, "lt r14 r1", "lt_r14_r1"},
     {{lt, r14, r2}, true, lt, "lt r14 r2", "lt_r14_r2"},
     {{lt, r14, r3}, true, lt, "lt r14 r3", "lt_r14_r3"},
     {{lt, r14, r4}, true, lt, "lt r14 r4", "lt_r14_r4"},
     {{lt, r14, r5}, true, lt, "lt r14 r5", "lt_r14_r5"},
     {{lt, r14, r6}, true, lt, "lt r14 r6", "lt_r14_r6"},
     {{lt, r14, r7}, true, lt, "lt r14 r7", "lt_r14_r7"},
     {{lt, r14, r8}, true, lt, "lt r14 r8", "lt_r14_r8"},
     {{lt, r14, r9}, true, lt, "lt r14 r9", "lt_r14_r9"},
     {{lt, r14, r10}, true, lt, "lt r14 r10", "lt_r14_r10"},
     {{lt, r14, r11}, true, lt, "lt r14 r11", "lt_r14_r11"},
     {{lt, r14, r12}, true, lt, "lt r14 r12", "lt_r14_r12"},
     {{lt, r14, r13}, true, lt, "lt r14 r13", "lt_r14_r13"},
     {{lt, r14, r14}, true, lt, "lt r14 r14", "lt_r14_r14"},
     {{gt, r0, r0}, true, gt, "gt r0 r0", "gt_r0_r0"},
     {{gt, r0, r1}, true, gt, "gt r0 r1", "gt_r0_r1"},
     {{gt, r0, r2}, true, gt, "gt r0 r2", "gt_r0_r2"},
     {{gt, r0, r3}, true, gt, "gt r0 r3", "gt_r0_r3"},
     {{gt, r0, r4}, true, gt, "gt r0 r4", "gt_r0_r4"},
     {{gt, r0, r5}, true, gt, "gt r0 r5", "gt_r0_r5"},
     {{gt, r0, r6}, true, gt, "gt r0 r6", "gt_r0_r6"},
     {{gt, r0, r7}, true, gt, "gt r0 r7", "gt_r0_r7"},
     {{gt, r0, r8}, true, gt, "gt r0 r8", "gt_r0_r8"},
     {{gt, r0, r9}, true, gt, "gt r0 r9", "gt_r0_r9"},
     {{gt, r0, r10}, true, gt, "gt r0 r10", "gt_r0_r10"},
     {{gt, r0, r11}, true, gt, "gt r0 r11", "gt_r0_r11"},
     {{gt, r0, r12}, true, gt, "gt r0 r12", "gt_r0_r12"},
     {{gt, r0, r13}, true, gt, "gt r0 r13", "gt_r0_r13"},
     {{gt, r0, r14}, true, gt, "gt r0 r14", "gt_r0_r14"},
     {{gt, r1, r0}, true, gt, "gt r1 r0", "gt_r1_r0"},
     {{gt, r1, r1}, true, gt, "gt r1 r1", "gt_r1_r1"},
     {{gt, r1, r2}, true, gt, "gt r1 r2", "gt_r1_r2"},
     {{gt, r1, r3}, true, gt, "gt r1 r3", "gt_r1_r3"},
     {{gt, r1, r4}, true, gt, "gt r1 r4", "gt_r1_r4"},
     {{gt, r1, r5}, true, gt, "gt r1 r5", "gt_r1_r5"},
     {{gt, r1, r6}, true, gt, "gt r1 r6", "gt_r1_r6"},
     {{gt, r1, r7}, true, gt, "gt r1 r7", "gt_r1_r7"},
     {{gt, r1, r8}, true, gt, "gt r1 r8", "gt_r1_r8"},
     {{gt, r1, r9}, true, gt, "gt r1 r9", "gt_r1_r9"},
     {{gt, r1, r10}, true, gt, "gt r1 r10", "gt_r1_r10"},
     {{gt, r1, r11}, true, gt, "gt r1 r11", "gt_r1_r11"},
     {{gt, r1, r12}, true, gt, "gt r1 r12", "gt_r1_r12"},
     {{gt, r1, r13}, true, gt, "gt r1 r13", "gt_r1_r13"},
     {{gt, r1, r14}, true, gt, "gt r1 r14", "gt_r1_r14"},
     {{gt, r2, r0}, true, gt, "gt r2 r0", "gt_r2_r0"},
     {{gt, r2, r1}, true, gt, "gt r2 r1", "gt_r2_r1"},
     {{gt, r2, r2}, true, gt, "gt r2 r2", "gt_r2_r2"},
     {{gt, r2, r3}, true, gt, "gt r2 r3", "gt_r2_r3"},
     {{gt, r2, r4}, true, gt, "gt r2 r4", "gt_r2_r4"},
     {{gt, r2, r5}, true, gt, "gt r2 r5", "gt_r2_r5"},
     {{gt, r2, r6}, true, gt, "gt r2 r6", "gt_r2_r6"},
     {{gt, r2, r7}, true, gt, "gt r2 r7", "gt_r2_r7"},
     {{gt, r2, r8}, true, gt, "gt r2 r8", "gt_r2_r8"},
     {{gt, r2, r9}, true, gt, "gt r2 r9", "gt_r2_r9"},
     {{gt, r2, r10}, true, gt, "gt r2 r10", "gt_r2_r10"},
     {{gt, r2, r11}, true, gt, "gt r2 r11", "gt_r2_r11"},
     {{gt, r2, r12}, true, gt, "gt r2 r12", "gt_r2_r12"},
     {{gt, r2, r13}, true, gt, "gt r2 r13", "gt_r2_r13"},
     {{gt, r2, r14}, true, gt, "gt r2 r14", "gt_r2_r14"},
     {{gt, r3, r0}, true, gt, "gt r3 r0", "gt_r3_r0"},
     {{gt, r3, r1}, true, gt, "gt r3 r1", "gt_r3_r1"},
     {{gt, r3, r2}, true, gt, "gt r3 r2", "gt_r3_r2"},
     {{gt, r3, r3}, true, gt, "gt r3 r3", "gt_r3_r3"},
     {{gt, r3, r4}, true, gt, "gt r3 r4", "gt_r3_r4"},
     {{gt, r3, r5}, true, gt, "gt r3 r5", "gt_r3_r5"},
     {{gt, r3, r6}, true, gt, "gt r3 r6", "gt_r3_r6"},
     {{gt, r3, r7}, true, gt, "gt r3 r7", "gt_r3_r7"},
     {{gt, r3, r8}, true, gt, "gt r3 r8", "gt_r3_r8"},
     {{gt, r3, r9}, true, gt, "gt r3 r9", "gt_r3_r9"},
     {{gt, r3, r10}, true, gt, "gt r3 r10", "gt_r3_r10"},
     {{gt, r3, r11}, true, gt, "gt r3 r11", "gt_r3_r11"},
     {{gt, r3, r12}, true, gt, "gt r3 r12", "gt_r3_r12"},
     {{gt, r3, r13}, true, gt, "gt r3 r13", "gt_r3_r13"},
     {{gt, r3, r14}, true, gt, "gt r3 r14", "gt_r3_r14"},
     {{gt, r4, r0}, true, gt, "gt r4 r0", "gt_r4_r0"},
     {{gt, r4, r1}, true, gt, "gt r4 r1", "gt_r4_r1"},
     {{gt, r4, r2}, true, gt, "gt r4 r2", "gt_r4_r2"},
     {{gt, r4, r3}, true, gt, "gt r4 r3", "gt_r4_r3"},
     {{gt, r4, r4}, true, gt, "gt r4 r4", "gt_r4_r4"},
     {{gt, r4, r5}, true, gt, "gt r4 r5", "gt_r4_r5"},
     {{gt, r4, r6}, true, gt, "gt r4 r6", "gt_r4_r6"},
     {{gt, r4, r7}, true, gt, "gt r4 r7", "gt_r4_r7"},
     {{gt, r4, r8}, true, gt, "gt r4 r8", "gt_r4_r8"},
     {{gt, r4, r9}, true, gt, "gt r4 r9", "gt_r4_r9"},
     {{gt, r4, r10}, true, gt, "gt r4 r10", "gt_r4_r10"},
     {{gt, r4, r11}, true, gt, "gt r4 r11", "gt_r4_r11"},
     {{gt, r4, r12}, true, gt, "gt r4 r12", "gt_r4_r12"},
     {{gt, r4, r13}, true, gt, "gt r4 r13", "gt_r4_r13"},
     {{gt, r4, r14}, true, gt, "gt r4 r14", "gt_r4_r14"},
     {{gt, r5, r0}, true, gt, "gt r5 r0", "gt_r5_r0"},
     {{gt, r5, r1}, true, gt, "gt r5 r1", "gt_r5_r1"},
     {{gt, r5, r2}, true, gt, "gt r5 r2", "gt_r5_r2"},
     {{gt, r5, r3}, true, gt, "gt r5 r3", "gt_r5_r3"},
     {{gt, r5, r4}, true, gt, "gt r5 r4", "gt_r5_r4"},
     {{gt, r5, r5}, true, gt, "gt r5 r5", "gt_r5_r5"},
     {{gt, r5, r6}, true, gt, "gt r5 r6", "gt_r5_r6"},
     {{gt, r5, r7}, true, gt, "gt r5 r7", "gt_r5_r7"},
     {{gt, r5, r8}, true, gt, "gt r5 r8", "gt_r5_r8"},
     {{gt, r5, r9}, true, gt, "gt r5 r9", "gt_r5_r9"},
     {{gt, r5, r10}, true, gt, "gt r5 r10", "gt_r5_r10"},
     {{gt, r5, r11}, true, gt, "gt r5 r11", "gt_r5_r11"},
     {{gt, r5, r12}, true, gt, "gt r5 r12", "gt_r5_r12"},
     {{gt, r5, r13}, true, gt, "gt r5 r13", "gt_r5_r13"},
     {{gt, r5, r14}, true, gt, "gt r5 r14", "gt_r5_r14"},
     {{gt, r6, r0}, true, gt, "gt r6 r0", "gt_r6_r0"},
     {{gt, r6, r1}, true, gt, "gt r6 r1", "gt_r6_r1"},
     {{gt, r6, r2}, true, gt, "gt r6 r2", "gt_r6_r2"},
     {{gt, r6, r3}, true, gt, "gt r6 r3", "gt_r6_r3"},
     {{gt, r6, r4}, true, gt, "gt r6 r4", "gt_r6_r4"},
     {{gt, r6, r5}, true, gt, "gt r6 r5", "gt_r6_r5"},
     {{gt, r6, r6}, true, gt, "gt r6 r6", "gt_r6_r6"},
     {{gt, r6, r7}, true, gt, "gt r6 r7", "gt_r6_r7"},
     {{gt, r6, r8}, true, gt, "gt r6 r8", "gt_r6_r8"},
     {{gt, r6, r9}, true, gt, "gt r6 r9", "gt_r6_r9"},
     {{gt, r6, r10}, true, gt, "gt r6 r10", "gt_r6_r10"},
     {{gt, r6, r11}, true, gt, "gt r6 r11", "gt_r6_r11"},
     {{gt, r6, r12}, true, gt, "gt r6 r12", "gt_r6_r12"},
     {{gt, r6, r13}, true, gt, "gt r6 r13", "gt_r6_r13"},
     {{gt, r6, r14}, true, gt, "gt r6 r14", "gt_r6_r14"},
     {{gt, r7, r0}, true, gt, "gt r7 r0", "gt_r7_r0"},
     {{gt, r7, r1}, true, gt, "gt r7 r1", "gt_r7_r1"},
     {{gt, r7, r2}, true, gt, "gt r7 r2", "gt_r7_r2"},
     {{gt, r7, r3}, true, gt, "gt r7 r3", "gt_r7_r3"},
     {{gt, r7, r4}, true, gt, "gt r7 r4", "gt_r7_r4"},
     {{gt, r7, r5}, true, gt, "gt r7 r5", "gt_r7_r5"},
     {{gt, r7, r6}, true, gt, "gt r7 r6", "gt_r7_r6"},
     {{gt, r7, r7}, true, gt, "gt r7 r7", "gt_r7_r7"},
     {{gt, r7, r8}, true, gt, "gt r7 r8", "gt_r7_r8"},
     {{gt, r7, r9}, true, gt, "gt r7 r9", "gt_r7_r9"},
     {{gt, r7, r10}, true, gt, "gt r7 r10", "gt_r7_r10"},
     {{gt, r7, r11}, true, gt, "gt r7 r11", "gt_r7_r11"},
     {{gt, r7, r12}, true, gt, "gt r7 r12", "gt_r7_r12"},
     {{gt, r7, r13}, true, gt, "gt r7 r13", "gt_r7_r13"},
     {{gt, r7, r14}, true, gt, "gt r7 r14", "gt_r7_r14"},
     {{gt, r8, r0}, true, gt, "gt r8 r0", "gt_r8_r0"},
     {{gt, r8, r1}, true, gt, "gt r8 r1", "gt_r8_r1"},
     {{gt, r8, r2}, true, gt, "gt r8 r2", "gt_r8_r2"},
     {{gt, r8, r3}, true, gt, "gt r8 r3", "gt_r8_r3"},
     {{gt, r8, r4}, true, gt, "gt r8 r4", "gt_r8_r4"},
     {{gt, r8, r5}, true, gt, "gt r8 r5", "gt_r8_r5"},
     {{gt, r8, r6}, true, gt, "gt r8 r6", "gt_r8_r6"},
     {{gt, r8, r7}, true, gt, "gt r8 r7", "gt_r8_r7"},
     {{gt, r8, r8}, true, gt, "gt r8 r8", "gt_r8_r8"},
     {{gt, r8, r9}, true, gt, "gt r8 r9", "gt_r8_r9"},
     {{gt, r8, r10}, true, gt, "gt r8 r10", "gt_r8_r10"},
     {{gt, r8, r11}, true, gt, "gt r8 r11", "gt_r8_r11"},
     {{gt, r8, r12}, true, gt, "gt r8 r12", "gt_r8_r12"},
     {{gt, r8, r13}, true, gt, "gt r8 r13", "gt_r8_r13"},
     {{gt, r8, r14}, true, gt, "gt r8 r14", "gt_r8_r14"},
     {{gt, r9, r0}, true, gt, "gt r9 r0", "gt_r9_r0"},
     {{gt, r9, r1}, true, gt, "gt r9 r1", "gt_r9_r1"},
     {{gt, r9, r2}, true, gt, "gt r9 r2", "gt_r9_r2"},
     {{gt, r9, r3}, true, gt, "gt r9 r3", "gt_r9_r3"},
     {{gt, r9, r4}, true, gt, "gt r9 r4", "gt_r9_r4"},
     {{gt, r9, r5}, true, gt, "gt r9 r5", "gt_r9_r5"},
     {{gt, r9, r6}, true, gt, "gt r9 r6", "gt_r9_r6"},
     {{gt, r9, r7}, true, gt, "gt r9 r7", "gt_r9_r7"},
     {{gt, r9, r8}, true, gt, "gt r9 r8", "gt_r9_r8"},
     {{gt, r9, r9}, true, gt, "gt r9 r9", "gt_r9_r9"},
     {{gt, r9, r10}, true, gt, "gt r9 r10", "gt_r9_r10"},
     {{gt, r9, r11}, true, gt, "gt r9 r11", "gt_r9_r11"},
     {{gt, r9, r12}, true, gt, "gt r9 r12", "gt_r9_r12"},
     {{gt, r9, r13}, true, gt, "gt r9 r13", "gt_r9_r13"},
     {{gt, r9, r14}, true, gt, "gt r9 r14", "gt_r9_r14"},
     {{gt, r10, r0}, true, gt, "gt r10 r0", "gt_r10_r0"},
     {{gt, r10, r1}, true, gt, "gt r10 r1", "gt_r10_r1"},
     {{gt, r10, r2}, true, gt, "gt r10 r2", "gt_r10_r2"},
     {{gt, r10, r3}, true, gt, "gt r10 r3", "gt_r10_r3"},
     {{gt, r10, r4}, true, gt, "gt r10 r4", "gt_r10_r4"},
     {{gt, r10, r5}, true, gt, "gt r10 r5", "gt_r10_r5"},
     {{gt, r10, r6}, true, gt, "gt r10 r6", "gt_r10_r6"},
     {{gt, r10, r7}, true, gt, "gt r10 r7", "gt_r10_r7"},
     {{gt, r10, r8}, true, gt, "gt r10 r8", "gt_r10_r8"},
     {{gt, r10, r9}, true, gt, "gt r10 r9", "gt_r10_r9"},
     {{gt, r10, r10}, true, gt, "gt r10 r10", "gt_r10_r10"},
     {{gt, r10, r11}, true, gt, "gt r10 r11", "gt_r10_r11"},
     {{gt, r10, r12}, true, gt, "gt r10 r12", "gt_r10_r12"},
     {{gt, r10, r13}, true, gt, "gt r10 r13", "gt_r10_r13"},
     {{gt, r10, r14}, true, gt, "gt r10 r14", "gt_r10_r14"},
     {{gt, r11, r0}, true, gt, "gt r11 r0", "gt_r11_r0"},
     {{gt, r11, r1}, true, gt, "gt r11 r1", "gt_r11_r1"},
     {{gt, r11, r2}, true, gt, "gt r11 r2", "gt_r11_r2"},
     {{gt, r11, r3}, true, gt, "gt r11 r3", "gt_r11_r3"},
     {{gt, r11, r4}, true, gt, "gt r11 r4", "gt_r11_r4"},
     {{gt, r11, r5}, true, gt, "gt r11 r5", "gt_r11_r5"},
     {{gt, r11, r6}, true, gt, "gt r11 r6", "gt_r11_r6"},
     {{gt, r11, r7}, true, gt, "gt r11 r7", "gt_r11_r7"},
     {{gt, r11, r8}, true, gt, "gt r11 r8", "gt_r11_r8"},
     {{gt, r11, r9}, true, gt, "gt r11 r9", "gt_r11_r9"},
     {{gt, r11, r10}, true, gt, "gt r11 r10", "gt_r11_r10"},
     {{gt, r11, r11}, true, gt, "gt r11 r11", "gt_r11_r11"},
     {{gt, r11, r12}, true, gt, "gt r11 r12", "gt_r11_r12"},
     {{gt, r11, r13}, true, gt, "gt r11 r13", "gt_r11_r13"},
     {{gt, r11, r14}, true, gt, "gt r11 r14", "gt_r11_r14"},
     {{gt, r12, r0}, true, gt, "gt r12 r0", "gt_r12_r0"},
     {{gt, r12, r1}, true, gt, "gt r12 r1", "gt_r12_r1"},
     {{gt, r12, r2}, true, gt, "gt r12 r2", "gt_r12_r2"},
     {{gt, r12, r3}, true, gt, "gt r12 r3", "gt_r12_r3"},
     {{gt, r12, r4}, true, gt, "gt r12 r4", "gt_r12_r4"},
     {{gt, r12, r5}, true, gt, "gt r12 r5", "gt_r12_r5"},
     {{gt, r12, r6}, true, gt, "gt r12 r6", "gt_r12_r6"},
     {{gt, r12, r7}, true, gt, "gt r12 r7", "gt_r12_r7"},
     {{gt, r12, r8}, true, gt, "gt r12 r8", "gt_r12_r8"},
     {{gt, r12, r9}, true, gt, "gt r12 r9", "gt_r12_r9"},
     {{gt, r12, r10}, true, gt, "gt r12 r10", "gt_r12_r10"},
     {{gt, r12, r11}, true, gt, "gt r12 r11", "gt_r12_r11"},
     {{gt, r12, r12}, true, gt, "gt r12 r12", "gt_r12_r12"},
     {{gt, r12, r13}, true, gt, "gt r12 r13", "gt_r12_r13"},
     {{gt, r12, r14}, true, gt, "gt r12 r14", "gt_r12_r14"},
     {{gt, r13, r0}, true, gt, "gt r13 r0", "gt_r13_r0"},
     {{gt, r13, r1}, true, gt, "gt r13 r1", "gt_r13_r1"},
     {{gt, r13, r2}, true, gt, "gt r13 r2", "gt_r13_r2"},
     {{gt, r13, r3}, true, gt, "gt r13 r3", "gt_r13_r3"},
     {{gt, r13, r4}, true, gt, "gt r13 r4", "gt_r13_r4"},
     {{gt, r13, r5}, true, gt, "gt r13 r5", "gt_r13_r5"},
     {{gt, r13, r6}, true, gt, "gt r13 r6", "gt_r13_r6"},
     {{gt, r13, r7}, true, gt, "gt r13 r7", "gt_r13_r7"},
     {{gt, r13, r8}, true, gt, "gt r13 r8", "gt_r13_r8"},
     {{gt, r13, r9}, true, gt, "gt r13 r9", "gt_r13_r9"},
     {{gt, r13, r10}, true, gt, "gt r13 r10", "gt_r13_r10"},
     {{gt, r13, r11}, true, gt, "gt r13 r11", "gt_r13_r11"},
     {{gt, r13, r12}, true, gt, "gt r13 r12", "gt_r13_r12"},
     {{gt, r13, r13}, true, gt, "gt r13 r13", "gt_r13_r13"},
     {{gt, r13, r14}, true, gt, "gt r13 r14", "gt_r13_r14"},
     {{gt, r14, r0}, true, gt, "gt r14 r0", "gt_r14_r0"},
     {{gt, r14, r1}, true, gt, "gt r14 r1", "gt_r14_r1"},
     {{gt, r14, r2}, true, gt, "gt r14 r2", "gt_r14_r2"},
     {{gt, r14, r3}, true, gt, "gt r14 r3", "gt_r14_r3"},
     {{gt, r14, r4}, true, gt, "gt r14 r4", "gt_r14_r4"},
     {{gt, r14, r5}, true, gt, "gt r14 r5", "gt_r14_r5"},
     {{gt, r14, r6}, true, gt, "gt r14 r6", "gt_r14_r6"},
     {{gt, r14, r7}, true, gt, "gt r14 r7", "gt_r14_r7"},
     {{gt, r14, r8}, true, gt, "gt r14 r8", "gt_r14_r8"},
     {{gt, r14, r9}, true, gt, "gt r14 r9", "gt_r14_r9"},
     {{gt, r14, r10}, true, gt, "gt r14 r10", "gt_r14_r10"},
     {{gt, r14, r11}, true, gt, "gt r14 r11", "gt_r14_r11"},
     {{gt, r14, r12}, true, gt, "gt r14 r12", "gt_r14_r12"},
     {{gt, r14, r13}, true, gt, "gt r14 r13", "gt_r14_r13"},
     {{gt, r14, r14}, true, gt, "gt r14 r14", "gt_r14_r14"},
     {{le, r0, r0}, true, le, "le r0 r0", "le_r0_r0"},
     {{le, r0, r1}, true, le, "le r0 r1", "le_r0_r1"},
     {{le, r0, r2}, true, le, "le r0 r2", "le_r0_r2"},
     {{le, r0, r3}, true, le, "le r0 r3", "le_r0_r3"},
     {{le, r0, r4}, true, le, "le r0 r4", "le_r0_r4"},
     {{le, r0, r5}, true, le, "le r0 r5", "le_r0_r5"},
     {{le, r0, r6}, true, le, "le r0 r6", "le_r0_r6"},
     {{le, r0, r7}, true, le, "le r0 r7", "le_r0_r7"},
     {{le, r0, r8}, true, le, "le r0 r8", "le_r0_r8"},
     {{le, r0, r9}, true, le, "le r0 r9", "le_r0_r9"},
     {{le, r0, r10}, true, le, "le r0 r10", "le_r0_r10"},
     {{le, r0, r11}, true, le, "le r0 r11", "le_r0_r11"},
     {{le, r0, r12}, true, le, "le r0 r12", "le_r0_r12"},
     {{le, r0, r13}, true, le, "le r0 r13", "le_r0_r13"},
     {{le, r0, r14}, true, le, "le r0 r14", "le_r0_r14"},
     {{le, r1, r0}, true, le, "le r1 r0", "le_r1_r0"},
     {{le, r1, r1}, true, le, "le r1 r1", "le_r1_r1"},
     {{le, r1, r2}, true, le, "le r1 r2", "le_r1_r2"},
     {{le, r1, r3}, true, le, "le r1 r3", "le_r1_r3"},
     {{le, r1, r4}, true, le, "le r1 r4", "le_r1_r4"},
     {{le, r1, r5}, true, le, "le r1 r5", "le_r1_r5"},
     {{le, r1, r6}, true, le, "le r1 r6", "le_r1_r6"},
     {{le, r1, r7}, true, le, "le r1 r7", "le_r1_r7"},
     {{le, r1, r8}, true, le, "le r1 r8", "le_r1_r8"},
     {{le, r1, r9}, true, le, "le r1 r9", "le_r1_r9"},
     {{le, r1, r10}, true, le, "le r1 r10", "le_r1_r10"},
     {{le, r1, r11}, true, le, "le r1 r11", "le_r1_r11"},
     {{le, r1, r12}, true, le, "le r1 r12", "le_r1_r12"},
     {{le, r1, r13}, true, le, "le r1 r13", "le_r1_r13"},
     {{le, r1, r14}, true, le, "le r1 r14", "le_r1_r14"},
     {{le, r2, r0}, true, le, "le r2 r0", "le_r2_r0"},
     {{le, r2, r1}, true, le, "le r2 r1", "le_r2_r1"},
     {{le, r2, r2}, true, le, "le r2 r2", "le_r2_r2"},
     {{le, r2, r3}, true, le, "le r2 r3", "le_r2_r3"},
     {{le, r2, r4}, true, le, "le r2 r4", "le_r2_r4"},
     {{le, r2, r5}, true, le, "le r2 r5", "le_r2_r5"},
     {{le, r2, r6}, true, le, "le r2 r6", "le_r2_r6"},
     {{le, r2, r7}, true, le, "le r2 r7", "le_r2_r7"},
     {{le, r2, r8}, true, le, "le r2 r8", "le_r2_r8"},
     {{le, r2, r9}, true, le, "le r2 r9", "le_r2_r9"},
     {{le, r2, r10}, true, le, "le r2 r10", "le_r2_r10"},
     {{le, r2, r11}, true, le, "le r2 r11", "le_r2_r11"},
     {{le, r2, r12}, true, le, "le r2 r12", "le_r2_r12"},
     {{le, r2, r13}, true, le, "le r2 r13", "le_r2_r13"},
     {{le, r2, r14}, true, le, "le r2 r14", "le_r2_r14"},
     {{le, r3, r0}, true, le, "le r3 r0", "le_r3_r0"},
     {{le, r3, r1}, true, le, "le r3 r1", "le_r3_r1"},
     {{le, r3, r2}, true, le, "le r3 r2", "le_r3_r2"},
     {{le, r3, r3}, true, le, "le r3 r3", "le_r3_r3"},
     {{le, r3, r4}, true, le, "le r3 r4", "le_r3_r4"},
     {{le, r3, r5}, true, le, "le r3 r5", "le_r3_r5"},
     {{le, r3, r6}, true, le, "le r3 r6", "le_r3_r6"},
     {{le, r3, r7}, true, le, "le r3 r7", "le_r3_r7"},
     {{le, r3, r8}, true, le, "le r3 r8", "le_r3_r8"},
     {{le, r3, r9}, true, le, "le r3 r9", "le_r3_r9"},
     {{le, r3, r10}, true, le, "le r3 r10", "le_r3_r10"},
     {{le, r3, r11}, true, le, "le r3 r11", "le_r3_r11"},
     {{le, r3, r12}, true, le, "le r3 r12", "le_r3_r12"},
     {{le, r3, r13}, true, le, "le r3 r13", "le_r3_r13"},
     {{le, r3, r14}, true, le, "le r3 r14", "le_r3_r14"},
     {{le, r4, r0}, true, le, "le r4 r0", "le_r4_r0"},
     {{le, r4, r1}, true, le, "le r4 r1", "le_r4_r1"},
     {{le, r4, r2}, true, le, "le r4 r2", "le_r4_r2"},
     {{le, r4, r3}, true, le, "le r4 r3", "le_r4_r3"},
     {{le, r4, r4}, true, le, "le r4 r4", "le_r4_r4"},
     {{le, r4, r5}, true, le, "le r4 r5", "le_r4_r5"},
     {{le, r4, r6}, true, le, "le r4 r6", "le_r4_r6"},
     {{le, r4, r7}, true, le, "le r4 r7", "le_r4_r7"},
     {{le, r4, r8}, true, le, "le r4 r8", "le_r4_r8"},
     {{le, r4, r9}, true, le, "le r4 r9", "le_r4_r9"},
     {{le, r4, r10}, true, le, "le r4 r10", "le_r4_r10"},
     {{le, r4, r11}, true, le, "le r4 r11", "le_r4_r11"},
     {{le, r4, r12}, true, le, "le r4 r12", "le_r4_r12"},
     {{le, r4, r13}, true, le, "le r4 r13", "le_r4_r13"},
     {{le, r4, r14}, true, le, "le r4 r14", "le_r4_r14"},
     {{le, r5, r0}, true, le, "le r5 r0", "le_r5_r0"},
     {{le, r5, r1}, true, le, "le r5 r1", "le_r5_r1"},
     {{le, r5, r2}, true, le, "le r5 r2", "le_r5_r2"},
     {{le, r5, r3}, true, le, "le r5 r3", "le_r5_r3"},
     {{le, r5, r4}, true, le, "le r5 r4", "le_r5_r4"},
     {{le, r5, r5}, true, le, "le r5 r5", "le_r5_r5"},
     {{le, r5, r6}, true, le, "le r5 r6", "le_r5_r6"},
     {{le, r5, r7}, true, le, "le r5 r7", "le_r5_r7"},
     {{le, r5, r8}, true, le, "le r5 r8", "le_r5_r8"},
     {{le, r5, r9}, true, le, "le r5 r9", "le_r5_r9"},
     {{le, r5, r10}, true, le, "le r5 r10", "le_r5_r10"},
     {{le, r5, r11}, true, le, "le r5 r11", "le_r5_r11"},
     {{le, r5, r12}, true, le, "le r5 r12", "le_r5_r12"},
     {{le, r5, r13}, true, le, "le r5 r13", "le_r5_r13"},
     {{le, r5, r14}, true, le, "le r5 r14", "le_r5_r14"},
     {{le, r6, r0}, true, le, "le r6 r0", "le_r6_r0"},
     {{le, r6, r1}, true, le, "le r6 r1", "le_r6_r1"},
     {{le, r6, r2}, true, le, "le r6 r2", "le_r6_r2"},
     {{le, r6, r3}, true, le, "le r6 r3", "le_r6_r3"},
     {{le, r6, r4}, true, le, "le r6 r4", "le_r6_r4"},
     {{le, r6, r5}, true, le, "le r6 r5", "le_r6_r5"},
     {{le, r6, r6}, true, le, "le r6 r6", "le_r6_r6"},
     {{le, r6, r7}, true, le, "le r6 r7", "le_r6_r7"},
     {{le, r6, r8}, true, le, "le r6 r8", "le_r6_r8"},
     {{le, r6, r9}, true, le, "le r6 r9", "le_r6_r9"},
     {{le, r6, r10}, true, le, "le r6 r10", "le_r6_r10"},
     {{le, r6, r11}, true, le, "le r6 r11", "le_r6_r11"},
     {{le, r6, r12}, true, le, "le r6 r12", "le_r6_r12"},
     {{le, r6, r13}, true, le, "le r6 r13", "le_r6_r13"},
     {{le, r6, r14}, true, le, "le r6 r14", "le_r6_r14"},
     {{le, r7, r0}, true, le, "le r7 r0", "le_r7_r0"},
     {{le, r7, r1}, true, le, "le r7 r1", "le_r7_r1"},
     {{le, r7, r2}, true, le, "le r7 r2", "le_r7_r2"},
     {{le, r7, r3}, true, le, "le r7 r3", "le_r7_r3"},
     {{le, r7, r4}, true, le, "le r7 r4", "le_r7_r4"},
     {{le, r7, r5}, true, le, "le r7 r5", "le_r7_r5"},
     {{le, r7, r6}, true, le, "le r7 r6", "le_r7_r6"},
     {{le, r7, r7}, true, le, "le r7 r7", "le_r7_r7"},
     {{le, r7, r8}, true, le, "le r7 r8", "le_r7_r8"},
     {{le, r7, r9}, true, le, "le r7 r9", "le_r7_r9"},
     {{le, r7, r10}, true, le, "le r7 r10", "le_r7_r10"},
     {{le, r7, r11}, true, le, "le r7 r11", "le_r7_r11"},
     {{le, r7, r12}, true, le, "le r7 r12", "le_r7_r12"},
     {{le, r7, r13}, true, le, "le r7 r13", "le_r7_r13"},
     {{le, r7, r14}, true, le, "le r7 r14", "le_r7_r14"},
     {{le, r8, r0}, true, le, "le r8 r0", "le_r8_r0"},
     {{le, r8, r1}, true, le, "le r8 r1", "le_r8_r1"},
     {{le, r8, r2}, true, le, "le r8 r2", "le_r8_r2"},
     {{le, r8, r3}, true, le, "le r8 r3", "le_r8_r3"},
     {{le, r8, r4}, true, le, "le r8 r4", "le_r8_r4"},
     {{le, r8, r5}, true, le, "le r8 r5", "le_r8_r5"},
     {{le, r8, r6}, true, le, "le r8 r6", "le_r8_r6"},
     {{le, r8, r7}, true, le, "le r8 r7", "le_r8_r7"},
     {{le, r8, r8}, true, le, "le r8 r8", "le_r8_r8"},
     {{le, r8, r9}, true, le, "le r8 r9", "le_r8_r9"},
     {{le, r8, r10}, true, le, "le r8 r10", "le_r8_r10"},
     {{le, r8, r11}, true, le, "le r8 r11", "le_r8_r11"},
     {{le, r8, r12}, true, le, "le r8 r12", "le_r8_r12"},
     {{le, r8, r13}, true, le, "le r8 r13", "le_r8_r13"},
     {{le, r8, r14}, true, le, "le r8 r14", "le_r8_r14"},
     {{le, r9, r0}, true, le, "le r9 r0", "le_r9_r0"},
     {{le, r9, r1}, true, le, "le r9 r1", "le_r9_r1"},
     {{le, r9, r2}, true, le, "le r9 r2", "le_r9_r2"},
     {{le, r9, r3}, true, le, "le r9 r3", "le_r9_r3"},
     {{le, r9, r4}, true, le, "le r9 r4", "le_r9_r4"},
     {{le, r9, r5}, true, le, "le r9 r5", "le_r9_r5"},
     {{le, r9, r6}, true, le, "le r9 r6", "le_r9_r6"},
     {{le, r9, r7}, true, le, "le r9 r7", "le_r9_r7"},
     {{le, r9, r8}, true, le, "le r9 r8", "le_r9_r8"},
     {{le, r9, r9}, true, le, "le r9 r9", "le_r9_r9"},
     {{le, r9, r10}, true, le, "le r9 r10", "le_r9_r10"},
     {{le, r9, r11}, true, le, "le r9 r11", "le_r9_r11"},
     {{le, r9, r12}, true, le, "le r9 r12", "le_r9_r12"},
     {{le, r9, r13}, true, le, "le r9 r13", "le_r9_r13"},
     {{le, r9, r14}, true, le, "le r9 r14", "le_r9_r14"},
     {{le, r10, r0}, true, le, "le r10 r0", "le_r10_r0"},
     {{le, r10, r1}, true, le, "le r10 r1", "le_r10_r1"},
     {{le, r10, r2}, true, le, "le r10 r2", "le_r10_r2"},
     {{le, r10, r3}, true, le, "le r10 r3", "le_r10_r3"},
     {{le, r10, r4}, true, le, "le r10 r4", "le_r10_r4"},
     {{le, r10, r5}, true, le, "le r10 r5", "le_r10_r5"},
     {{le, r10, r6}, true, le, "le r10 r6", "le_r10_r6"},
     {{le, r10, r7}, true, le, "le r10 r7", "le_r10_r7"},
     {{le, r10, r8}, true, le, "le r10 r8", "le_r10_r8"},
     {{le, r10, r9}, true, le, "le r10 r9", "le_r10_r9"},
     {{le, r10, r10}, true, le, "le r10 r10", "le_r10_r10"},
     {{le, r10, r11}, true, le, "le r10 r11", "le_r10_r11"},
     {{le, r10, r12}, true, le, "le r10 r12", "le_r10_r12"},
     {{le, r10, r13}, true, le, "le r10 r13", "le_r10_r13"},
     {{le, r10, r14}, true, le, "le r10 r14", "le_r10_r14"},
     {{le, r11, r0}, true, le, "le r11 r0", "le_r11_r0"},
     {{le, r11, r1}, true, le, "le r11 r1", "le_r11_r1"},
     {{le, r11, r2}, true, le, "le r11 r2", "le_r11_r2"},
     {{le, r11, r3}, true, le, "le r11 r3", "le_r11_r3"},
     {{le, r11, r4}, true, le, "le r11 r4", "le_r11_r4"},
     {{le, r11, r5}, true, le, "le r11 r5", "le_r11_r5"},
     {{le, r11, r6}, true, le, "le r11 r6", "le_r11_r6"},
     {{le, r11, r7}, true, le, "le r11 r7", "le_r11_r7"},
     {{le, r11, r8}, true, le, "le r11 r8", "le_r11_r8"},
     {{le, r11, r9}, true, le, "le r11 r9", "le_r11_r9"},
     {{le, r11, r10}, true, le, "le r11 r10", "le_r11_r10"},
     {{le, r11, r11}, true, le, "le r11 r11", "le_r11_r11"},
     {{le, r11, r12}, true, le, "le r11 r12", "le_r11_r12"},
     {{le, r11, r13}, true, le, "le r11 r13", "le_r11_r13"},
     {{le, r11, r14}, true, le, "le r11 r14", "le_r11_r14"},
     {{le, r12, r0}, true, le, "le r12 r0", "le_r12_r0"},
     {{le, r12, r1}, true, le, "le r12 r1", "le_r12_r1"},
     {{le, r12, r2}, true, le, "le r12 r2", "le_r12_r2"},
     {{le, r12, r3}, true, le, "le r12 r3", "le_r12_r3"},
     {{le, r12, r4}, true, le, "le r12 r4", "le_r12_r4"},
     {{le, r12, r5}, true, le, "le r12 r5", "le_r12_r5"},
     {{le, r12, r6}, true, le, "le r12 r6", "le_r12_r6"},
     {{le, r12, r7}, true, le, "le r12 r7", "le_r12_r7"},
     {{le, r12, r8}, true, le, "le r12 r8", "le_r12_r8"},
     {{le, r12, r9}, true, le, "le r12 r9", "le_r12_r9"},
     {{le, r12, r10}, true, le, "le r12 r10", "le_r12_r10"},
     {{le, r12, r11}, true, le, "le r12 r11", "le_r12_r11"},
     {{le, r12, r12}, true, le, "le r12 r12", "le_r12_r12"},
     {{le, r12, r13}, true, le, "le r12 r13", "le_r12_r13"},
     {{le, r12, r14}, true, le, "le r12 r14", "le_r12_r14"},
     {{le, r13, r0}, true, le, "le r13 r0", "le_r13_r0"},
     {{le, r13, r1}, true, le, "le r13 r1", "le_r13_r1"},
     {{le, r13, r2}, true, le, "le r13 r2", "le_r13_r2"},
     {{le, r13, r3}, true, le, "le r13 r3", "le_r13_r3"},
     {{le, r13, r4}, true, le, "le r13 r4", "le_r13_r4"},
     {{le, r13, r5}, true, le, "le r13 r5", "le_r13_r5"},
     {{le, r13, r6}, true, le, "le r13 r6", "le_r13_r6"},
     {{le, r13, r7}, true, le, "le r13 r7", "le_r13_r7"},
     {{le, r13, r8}, true, le, "le r13 r8", "le_r13_r8"},
     {{le, r13, r9}, true, le, "le r13 r9", "le_r13_r9"},
     {{le, r13, r10}, true, le, "le r13 r10", "le_r13_r10"},
     {{le, r13, r11}, true, le, "le r13 r11", "le_r13_r11"},
     {{le, r13, r12}, true, le, "le r13 r12", "le_r13_r12"},
     {{le, r13, r13}, true, le, "le r13 r13", "le_r13_r13"},
     {{le, r13, r14}, true, le, "le r13 r14", "le_r13_r14"},
     {{le, r14, r0}, true, le, "le r14 r0", "le_r14_r0"},
     {{le, r14, r1}, true, le, "le r14 r1", "le_r14_r1"},
     {{le, r14, r2}, true, le, "le r14 r2", "le_r14_r2"},
     {{le, r14, r3}, true, le, "le r14 r3", "le_r14_r3"},
     {{le, r14, r4}, true, le, "le r14 r4", "le_r14_r4"},
     {{le, r14, r5}, true, le, "le r14 r5", "le_r14_r5"},
     {{le, r14, r6}, true, le, "le r14 r6", "le_r14_r6"},
     {{le, r14, r7}, true, le, "le r14 r7", "le_r14_r7"},
     {{le, r14, r8}, true, le, "le r14 r8", "le_r14_r8"},
     {{le, r14, r9}, true, le, "le r14 r9", "le_r14_r9"},
     {{le, r14, r10}, true, le, "le r14 r10", "le_r14_r10"},
     {{le, r14, r11}, true, le, "le r14 r11", "le_r14_r11"},
     {{le, r14, r12}, true, le, "le r14 r12", "le_r14_r12"},
     {{le, r14, r13}, true, le, "le r14 r13", "le_r14_r13"},
     {{le, r14, r14}, true, le, "le r14 r14", "le_r14_r14"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rd-operand-rn-in-it-block-cmp-t32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-in-it-block-mov-t32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseT32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    Operand op(rn);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_ASSEMBLER_COND_RD_OPERAND_RN_IN_IT_BLOCK_" #mnemonic "_T32", \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
