/* Some standard utility stuff. */

#ifndef UTIL_H
#define UTIL_H

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

/* Error messages. */

extern char *Progname;
extern void fatalerr(const char *, ...);
extern void msg(const char *, ...);

/* A function and some macros for allocating memory. */

extern void *new_(size_t s);

#define new(type) (type *)new_(sizeof(type))
#define new_array(type, size) (type *)new_((size) * sizeof(type))

/* Files. */

extern FILE *fileopen(const char *name, const char *mode);

/* Conversions. */

extern int atoik(char *);

#endif  /* UTIL_H */
