/***************************************************************************
                          dctranslator.h  -  description
                             -------------------
    begin                : Die Nov 19 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCTRANSLATOR_H
#define DCTRANSLATOR_H

#include <qobject.h>
#include <QStringList>
#include <QHash>

class QHttp;
class QWidget;
class DC_TranslationEvent;

/**
  *@author Mathias Küster
  */

class DCTranslator : public QObject  {
Q_OBJECT

public: 
	/** construtor */
	DCTranslator( QObject * parent = 0 );
	/** destructor */
	virtual ~DCTranslator();

	/** */
	QString SelectLanguage( QString lang, QWidget * parent = 0 );
	/** */
	bool Translate( QObject * sender, QString lang, QString text );

private:
	/** */
	static QString GetUserAgent();
	/** */
	QHttp * pHttp;
	/** It maps QHttp request IDs to the DC_TranslationEvent object */
	QHash<int, DC_TranslationEvent*> m_RequestHash;
	/** */
	QString m_sLanguage;
	/** Just in case you need to GET a page before you are allowed to do a POST request */
	/* int m_nGetRequestID; */
	/** Just in case you need to GET a page before you are allowed to do a POST request */
	/* bool m_bReady; */
	/** */
	QString provider;
	/** */
	QStringList langs_ys;
	/** */
	QStringList langs_y;
	/** */
	QStringList langs_gs_from;
	/** */
	QStringList langs_g_from;
	/** */
	QStringList langs_gs_to;
	/** */
	QStringList langs_g_to;

private slots:
	/** */
	/* void slotDataReadProgress( int bytesDone, int bytesTotal ); */
	/** */
	/* void slotGetRequestFinished( int id, bool error ); */
	/** */
	void slotPostRequestFinished( int id, bool error );
};

extern DCTranslator * g_pTranslator;
#endif
