/* strcasecmp.c
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "tua.h"

/* Thanx again Jan! */

int
DEFUN (strcasecmp, (s1, s2),
       CONST char * s1 AND CONST char * s2)
{
  char b1, b2;

  while ((b1 = *s1++) != '\0')
    {
      b2 = *s2++;
      if (b2 == '\0')
        return 1;
      if (b1 != b2)
        {
          if (isupper (b1))
            b1 = tolower (b1);
          if (isupper (b2))
            b2 = tolower (b2);
          if (b1 != b2)
            return b1 - b2;
        }
    }
  if (*s2 == '\0')
    return 0;
  else
    return -1;
}

