# Copyright (C) 2006,2007 Daiki Ueno <ueno@unixuser.org>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

module Treil
  class Writer
    def initialize(output, config)
      @output = output
      @config = config
    end

    @@writer = Array.new
    def self.instance(output, config, class_name = nil)
      if class_name
	klass = Treil.const_get(class_name)
      else
	klass = @@writer.detect {|klass| klass.accept?(output)}
      end
      unless klass
        raise "Can't find writer for #{output}"
      end
      unless klass.accept?(output)
        raise "#{klass} can't write to #{output}"
      end
      klass.new(output, config)
    end

    def self.register(writer)
      @@writer.push(writer)
    end

    def self.list
      @@writer.collect {|klass| klass.name.sub(/\ATreil::/, '')}
    end
  end
end

begin
  require 'treil/cairo'
rescue LoadError
end

begin
  require 'treil/gd'
rescue LoadError
end

begin
  require 'treil/htmlmap'
rescue LoadError
end
