/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2017 Martin Brehm
                  2012-2017 Martin Thomas

    This file written by Martin Brehm and Philipp di Dio.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/


/****************************************************************************

    Sources of Van-der-Waals radii:

    1) R. Scott Rowland, Robin Taylor: Intermolecular Nonbonded Contact Distances in Organic Crystal Structures: Comparison with Distances Expected from van der Waals Radii. In: J. Phys. Chem. 1996, 100, S. 7384-7391, doi:10.1021/jp953141+.
    2) A. Bondi: van der Waals Volumes and Radii. In: J. Phys. Chem. 1964, 68, S. 441-451, doi:10.1021/j100785a001.
    3) Manjeera Mantina, Adam C. Chamberlin, Rosendo Valero, Christopher J. Cramer, Donald G. Truhlar: Consistent van der Waals Radii for the Whole Main Group. In: J. Phys. Chem. A. 2009, 113, S. 5806-5812, doi:10.1021/jp8111556. 


    Coherent Neutron Scattering Cross Sections:

	Published in "Neutron News, Vol. 3, No. 3, 1992, pp. 29-37".
    Taken from "http://www.ncnr.nist.gov/resources/n-lengths/".

*****************************************************************************/


// This must always be the first include directive
#include "config.h"

#include "travis.h"


void AddElementData()
{
	// Element, Ord. Number, Mass, Covalent Radius [pm], VdW Radius [pm], ( Coherent Neutron Scattering Cross Section [barn] )

	// 1st Period
	AddElement("H",    1,   1.01,  37.0, 110.0,  1.7568);
	AddElement("D",    1,   2.01,  37.0, 110.0);
	AddElement("He",   2,   4.00,  32.0, 140.0);


	// 2nd Period
	AddElement("Li",   3,   6.94, 134.0, 182.0);
	AddElement("Be",   4,   9.01,  90.0, 153.0);
	AddElement("B",    5,  10.81,  90.0, 192.0);
	AddElement("C",    6,  12.01,  82.0, 170.0,  5.551);
	AddElement("N",    7,  14.01,  77.0, 155.0, 11.01);
	AddElement("O",    8,  16.00,  75.0, 152.0,  4.232);
	AddElement("F",    9,  18.99,  73.0, 147.0,  4.017);
	AddElement("Ne",  10,  20.18,  69.0, 154.0);


	// 3rd Period
	AddElement("Na",  11,  22.99,  71.0, 227.0);
	AddElement("Mg",  12,  24.31, 130.0, 173.0);
	AddElement("Al",  13,  26.98, 154.0, 184.0);
	AddElement("Si",  14,  28.09, 118.0, 210.0);
	AddElement("P",   15,  30.97, 111.0, 180.0,  3.307);
	AddElement("S",   16,  32.06, 106.0, 180.0,  1.0186);
	AddElement("Cl",  17,  35.45, 102.0, 175.0, 11.5257);
	AddElement("Ar",  18,  39.95,  97.0, 188.0);


	// 4th Period
	AddElement("K",   19,  39.10, 196.0, 275.0);
	AddElement("Ca",  20,  40.08, 174.0, 231.0);

	AddElement("Sc",  21,  44.96, 144.0,   0.0);
	AddElement("Ti",  22,  47.90, 136.0,   0.0);
	AddElement("V",   23,  50.94, 125.0,   0.0);
	AddElement("Cr",  24,  52.00, 127.0,   0.0);
	AddElement("Mn",  25,  54.49, 139.0,   0.0);
	AddElement("Fe",  26,  55.85, 125.0,   0.0);
	AddElement("Co",  27,  58.93, 126.0,   0.0);
	AddElement("Ni",  28,  58.71, 121.0, 163.0);
	AddElement("Cu",  29,  63.54, 138.0, 140.0);
	AddElement("Zn",  30,  65.37, 131.0, 139.0);

	AddElement("Ga",  31,  69.72, 126.0, 187.0);
	AddElement("Ge",  32,  72.59, 122.0, 211.0);
	AddElement("As",  33,  74.92, 121.0, 185.0);
	AddElement("Se",  34,  78.96, 116.0, 190.0);
	AddElement("Br",  35,  79.91, 114.0, 185.0);
	AddElement("Kr",  36,  83.80, 110.0, 202.0);


	// 5th Period
	AddElement("Rb",  37,  85.47, 211.0, 303.0);
	AddElement("Sr",  38,  87.62, 192.0, 249.0);

	AddElement("Y",   39,  88.91, 162.0,   0.0);
	AddElement("Zr",  40,  91.22, 148.0,   0.0);
	AddElement("Nb",  41,  92.91, 137.0,   0.0);
	AddElement("Mo",  42,  95.94, 145.0,   0.0);
	AddElement("Tc",  43,  97.00, 131.0,   0.0);
	AddElement("Ru",  44, 101.07, 126.0,   0.0);
	AddElement("Rh",  45, 102.90, 135.0,   0.0);
	AddElement("Pd",  46, 106.40, 131.0, 163.0);
	AddElement("Ag",  47, 107.87, 153.0, 172.0);
	AddElement("Cd",  48, 112.40, 148.0, 158.0);

	AddElement("In",  49, 114.82, 144.0, 193.0);
	AddElement("Sn",  50, 118.69, 141.0, 217.0);
	AddElement("Sb",  51, 121.75, 138.0, 206.0);
	AddElement("Te",  52, 127.60, 135.0, 206.0);
	AddElement("I",   53, 126.90, 133.0, 198.0);
	AddElement("Xe",  54, 131.30, 130.0, 216.0);


	// 6th Period
	AddElement("Cs",  55, 132.91, 225.0, 343.0);
	AddElement("Ba",  56, 137.34, 198.0, 268.0);

	AddElement("La",  57, 138.91, 169.0,   0.0);

	AddElement("Ce",  58, 140.12, 204.0,   0.0);
	AddElement("Pr",  59, 140.91, 203.0,   0.0);
	AddElement("Nd",  60, 144.24, 201.0,   0.0);
	AddElement("Pm",  61, 146.90, 199.0,   0.0);
	AddElement("Sm",  62, 150.36, 198.0,   0.0);
	AddElement("Eu",  63, 151.96, 198.0,   0.0);
	AddElement("Gd",  64, 157.25, 196.0,   0.0);
	AddElement("Tb",  65, 158.93, 194.0,   0.0);
	AddElement("Dy",  66, 162.50, 192.0,   0.0);
	AddElement("Ho",  67, 164.93, 192.0,   0.0);
	AddElement("Er",  68, 167.26, 189.0,   0.0);
	AddElement("Tm",  69, 168.93, 190.0,   0.0);
	AddElement("Yb",  70, 173.05, 187.0,   0.0);
	AddElement("Lu",  71, 174.97, 187.0,   0.0);

	AddElement("Hf",  72, 178.49, 150.0,   0.0);
	AddElement("Ta",  73, 180.95, 138.0,   0.0);
	AddElement("W",   74, 183.85, 146.0,   0.0);
	AddElement("Re",  75, 186.20, 159.0,   0.0);
	AddElement("Os",  76, 190.20, 128.0,   0.0);
	AddElement("Ir",  77, 192.20, 137.0,   0.0);
	AddElement("Pt",  78, 195.09, 138.0,   0.0);
	AddElement("Au",  79, 196.97, 144.0,   0.0);
	AddElement("Hg",  80, 200.59, 149.0,   0.0);

	AddElement("Tl",  81, 204.37, 148.0,   0.0);
	AddElement("Pb",  82, 207.19, 146.0,   0.0);
	AddElement("Bi",  83, 208.98, 146.0,   0.0);
	AddElement("Po",  84, 209.00, 140.0,   0.0);
	AddElement("At",  85, 210.00, 145.0,   0.0);
	AddElement("Rn",  86, 222.00, 145.0,   0.0);


	/* 7th period */
	AddElement("Fr",  87, 223.00, 260.0,   0.0);
	AddElement("Ra",  88, 226.03, 221.0,   0.0);

	AddElement("Ac",  89, 227.00, 215.0,   0.0);

	AddElement("Th",  90, 232.04, 206.0,   0.0);
	AddElement("Pa",  91, 231.04, 200.0,   0.0);
	AddElement("U",   92, 238.03, 196.0,   0.0);
	AddElement("Np",  93, 237.05, 190.0,   0.0);
	AddElement("Pu",  94, 244.10, 187.0,   0.0);
	AddElement("Am",  95, 243.10, 180.0,   0.0);
	AddElement("Cm",  96, 247.10, 169.0,   0.0);
	AddElement("Bk",  97, 247.10, 160.0,   0.0);
	AddElement("Cf",  98, 251.10, 160.0,   0.0);
	AddElement("Es",  99, 254.10, 160.0,   0.0);
	AddElement("Fm", 100, 257.10, 160.0,   0.0);
	AddElement("Md", 101, 258.00, 160.0,   0.0);
	AddElement("No", 102, 259.00, 160.0,   0.0);
	AddElement("Lr", 103, 260.00, 160.0,   0.0);


	// Virtual Atom
	AddElement("#",    0,   0.00,   0.0,   0.0);

	// Colors for some common atoms. Other atoms have standard color.
	SetElementColor("H",  255, 255, 255, 150, 150, 150 );
	SetElementColor("C",  228, 113,   0, 180, 180, 180 );
	SetElementColor("N",    0,   0, 255, 140, 140, 140 );
	SetElementColor("O",  255,   0,   0, 160, 160, 160 );
	SetElementColor("S",  255, 255,   0, 200, 200, 200 );
}

