# mkdata.awk - used to generate blah.[ch] from blah.data
#
# Copyright (C)1999-2018 Mark Simpson <damned@world.std.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, you can either send email to this
# program's maintainer or write to: The Free Software Foundation,
# Inc.; 59 Temple Place, Suite 330; Boston, MA 02111-1307, USA.
#
# Commentary:
#
# the file x.data was given on the command line
# the output of this script is redirected to the right file
# the environment variable TAG is used for the function name and comments
#

#
# Print headers and such.
#
BEGIN {
    HFILE = sprintf ("%ss.h", ENVIRON["TAG"]);
    HFILEDEF = HFILE;
    HFILEDEF = toupper(HFILEDEF);
    gsub("\\.","_",HFILEDEF);
    CFILE = sprintf ("%ss.c", ENVIRON["TAG"]);
    printf "/* This file generated by names.awk do not edit! */\n" > HFILE;
    printf "#ifndef %s\n", HFILEDEF > HFILE;
    printf "#define %s\n", HFILEDEF > HFILE;
    printf "enum _%s {\n", ENVIRON["TAG"]                         > HFILE;

    printf "/* This file generated by names.awk do not edit! */\n" > CFILE;
    printf "#ifdef HAVE_CONFIG_H\n"                                > CFILE;
    printf "#include \"config.h\"\n"                               > CFILE;
    printf "#endif\n"                                              > CFILE;
    printf "#include \"common.h\"\n"                               > CFILE;
    printf "#include \"%s\"\n", HFILE                              > CFILE;
    printf "char*\n"                                               > CFILE;
    printf "get_%s_str(uint16 d)\n", ENVIRON["TAG"]                > CFILE;
    printf "{\n"                                                   > CFILE;
    printf "    static char buf[128];\n"                           > CFILE;
    printf "    static char* str;\n"                               > CFILE;
    printf "    switch(d) {\n"                                     > CFILE;
}

#
# deal with each line if it doesn't start with a '#'
#
/^[^#]/ {
   NAME = ""
   for (i = 3; i < NF + 1; i=i+1) {
       if ( NAME ) {
           NAME = sprintf ("%s %s", NAME, $(i))
       } else {
           NAME = $(i)
       }
   }

#   printf "#define %-10s\t%s\t/* %s */\n", $1, $2, NAME          > HFILE;
   printf "\t%-45s = %s,\n", $1, $2 > HFILE

   printf "    case %s:\n", $1                                    > CFILE;
   printf "        str=\"%s\";\n", NAME                           > CFILE;
   printf "        break;\n"                                      > CFILE;
}

#
# Finish off the files
#
END {
    printf "};\n" > HFILE;
    printf "typedef enum _%s %s;\n", ENVIRON["TAG"], ENVIRON["TAG"] > HFILE;
    printf "extern char*\n"                                        > HFILE;
    printf "get_%s_str(uint16 d);\n", ENVIRON["TAG"]               > HFILE;
    printf "#endif /* %s */\n", HFILEDEF > HFILE;

    printf "    default:\n"                                        > CFILE;
    printf "        str=NULL;\n"                                   > CFILE;
    printf "        break;\n"                                      > CFILE;
    printf "    }\n"                                               > CFILE;
    printf "    if ( str )\n"                                      > CFILE;
    printf "    {\n"                                               > CFILE;
    printf "        sprintf(buf,\"%%s <%%04x>\",str,d);\n"         > CFILE;
    printf "    }\n"                                               > CFILE;
    printf "    else\n"                                            > CFILE;
    printf "    {\n"                                               > CFILE;
    printf "        sprintf(buf,\"%%04x\",d);\n"                   > CFILE;
    printf "    }\n"                                               > CFILE;
    printf "    return buf;\n"                                     > CFILE;
    printf "}\n"                                                   > CFILE;
}
