[vset VERSION 0.1.2]
[comment {-*- tcl -*- doctools manpage}]
[manpage_begin widget_listsimple n [vset VERSION]]
[keywords {data entry lists}]
[keywords {data entry set of strings}]
[keywords {data entry unordered list}]
[keywords {list entry panel}]
[keywords {set entry panel}]
[keywords widget]
[moddesc   {widget::listsimple widget}]
[titledesc {widget::listsimple widget}]
[require Tcl 8.5]
[require Tk 8.5]
[require widget::listsimple [opt [vset VERSION]]]
[require widget::validator [opt 0.1]]
[require widget::scrolledwindow]
[require snit]
[require tooltip]
[require img::png]
[require msgcat]
[description]

This package provides a megawidget for the interactive entry of unordered lists.

For a megawidget allowing the entry of ordered lists, and more, please see the
package [package widget::listentry].

[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[section {Class API}]

The widget class supports a single command, for the creation of widgets.

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd widget::listsimple] [arg pathname] [opt options]]

This command creates and configures new instances of the widget.

[para] For details on the available options please see section
[sectref {Widget Options}].

[para] The result of the command is the pathname of the new widget.

[list_end]

[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[section {Instance API}]

All widget instances supported the following methods.

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd widgetCmd] [method destroy]]

This method destroys the widget.
Any further access to the widget will generate errors.

[para] The result of the command is the empty string.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd widgetCmd] [method configure]]

This method comes in three variants. This variant here returns a list
containing the current configuration of the widget, i.e. the values
for all options.

[para] For details on the available options please see section
[sectref {Widget Options}].

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd widgetCmd] [method configure] [arg option] [arg value] ...]

This method comes in three variants. This variant here reconfigures
the widget, setting the specified options to the given values.

[para] [emph Note] that it is not possible to change the
construction-time only options.

[para] For details on the available options please see section
[sectref {Widget General Options}].

[para] The result of the command is the empty string.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd widgetCmd] [method configure] [arg option]]

This method comes in three variants. This variant here is an alias
for the method [method cget] below and identical to it.

[call [cmd widgetCmd] [method cget] [arg option]]

This method returns the current value of the specified [arg option].

[para] For details on the available options please see section
[sectref {Widget Options}].

[list_end]

[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[section {Widget Options}]

This section explains all the options available to instances of
[class widget::listsimple]. Please note that a few of the options
can be set only at instance construction time. The majority of the
options can however be set both during construction- and runtime.

[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[subsection {Widget Construction-Time Only Options}]

[list_begin options][comment {--- options -----------------------------}]
[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -values cmdprefix]

This option specifies a callback for the management of a predefined
list of strings a user may enter.

[para] If specified the widget will use a combobox instead of a plain
entry field and fill its list during widget construction using the data
delivered by this callback.

The callback will be further invoked whenever a new value is entered
into the main list, to save the extended list of predefined values.

[para] The signature of this callback is

[list_begin definitions]
[call [arg {{*}cmdprefix}] [method get]]

In this form the callback is expected to return a list of strings.
The strings are loaded into the list of the internal combobox for
quick access by the user.

[para] It will be invoked once, during widget construction, to load the
list of predefined strings a user may enter.

[call [arg {{*}cmdprefix}] [method set] [arg values]]

In this form the callback is given a list of new strings and
expected to save them somewhere for future use.

[para] The return value of the callback is ignored.

[para] This form is invoked whenever the user entered a new string
into the main list. The order of strings in [arg values] represents
the order used to show them in the combobox's list.

[list_end]

[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -validate cmdprefix]

This option specifies a callback which is invoked after every change of
the contents of the internal entry field. The signature of this callback is

[list_begin definitions]
[call [arg {{*}cmdprefix}] [arg text] [arg errvar]]

where [arg text] is the string to validate, and [arg errvar] the name of
a variable the callback can store an error message into when it detects
invalid data.

[para] The system expects that the callback returns a boolean value, where
[const true] indicates that [arg text] is valid.

[list_end]

The default validation, when no callback was specified, will treat the
empty string as invalid, and everything else as valid.

[para] [emph {Please note}] that the widget will prevent the entry of
duplicate values into the main list, regardless of the validity of the
input otherwise. This is in keeping with that this widget is meant for
the entry of unordered lists, essentially a set of strings.

[list_end][comment {--- options ---------------------------------------}]

[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[subsection {Widget General Options}]

[list_begin options]

[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -listvariable varname]

This option specifies the variable holding the list to be manipulated by
the widget. Any changes to the list outside of the widget are automatically
imported into the widget. Similarly, all changes made to the list by the
widget are automatically exported to this variable.

[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -skin-add string]
[opt_def -skin-remove string]
[opt_def -skin-tip-add string]
[opt_def -skin-tip-remove string]
[opt_def -skin-tip-main string]
[opt_def -skin-tip-entry string]
[opt_def -skin-tip-list string]
[opt_def -skin-tip-empty string]
[opt_def -skin-tip-duplicate string]
[opt_def -skin-tip-add-none string]
[opt_def -skin-tip-remove-none string]
[opt_def -skin-img-add image]
[opt_def -skin-img-remove image]
[opt_def -skin-invalid-color color]

These options all modify the appearance of the widget, i.e. its skin.

[para] All options taking a string argument influence the various labels
shown, with the [option -skin-tip-*] options influencing the tooltips
shown on hovering the over various parts in particular.

[para] All the strings are run through [package msgcat] first, enabling
text localization through message catalogs. The default values are keys
into the message catalogs which are part of the package itself.

[para] The options taking images modify the images shown on the buttons
for adding and removing elements of the list. They default to the PNG
images distributed with the package itself.

[para] The single option taking a color value modifies the color used to
highlight invalid data entered into the internal entry field of the
widget. This option defaults to [const yellow].

[list_end]

[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[section Example]
[example {}]
[vset CATEGORY widget::listsimple]
[include ../../support/devel/doc/feedback.inc]
[manpage_end]
