[vset VERSION 0.3]
[comment {-*- tcl -*- doctools manpage}]
[manpage_begin canvas::edit::points n [vset VERSION]]
[keywords canvas]
[keywords editing]
[keywords {point cloud}]
[keywords points]
[moddesc   {Variations on a canvas}]
[titledesc {Editing a cloud of points on a canvas}]
[require Tcl 8.5]
[require Tk 8.5]
[require canvas::edit::points [opt [vset VERSION]]]
[description]

This package provides a class whose instances handle editing a cloud of point markers on a
canvas. Instances can be configured with regard to the visual appearance of markers. Note that
instances do not store the edited points themselves, but delegate this to a configurable object.

[section {Interaction}]

[para] The default bindings enable the creation, removal and dragging of point (markers) using the
mouse buttons 1, 2, and 3. Specifically:

[list_begin enumerated]
[enum] Clicking anywhere with button 1 adds a new point.
[enum] Clicking on a point with button 2 removes that point.
[enum] Clicking on a point with button 3 starts a drag operation ending with the release of the
       button.
[list_end]

[para] The option [option -drag-point] can be used to change the button used to initiate drag
operations. Note that the option value may not only contain the button number, but also modifier
prefix separated from the button by a dash "[const -]".

The recognized modifiers are [const Control], [const Shift], and [const Alt].

[para] The option [option -add-remove-point] can be used to change the button used to add/remove
points. This works because removal is an item binding, while adding is canvas global. The option
recognizes the same syntax for button as [option -drag-point].

[para] In the standard configuration the canvas item representing a point is a circle configured
using the appearance options [option -color], [option -hilit-color], and [option -radius]. Their
defaults are [const Skyblue2], [const red], and [const 3], repsectively.

[para] The option [option -kind] can be used to slightly customize the canvas item to any kind
accepting the item options [option -width], [option -outline], [option -fill], and
[option -activefill].

[para] For more extensive customization its is necessary to configure a creation callback using
option [option -create-cmd]. The callback takes the canvas and x. y coordinates as arguments, in
this order, and is expected to return a list of the canvas items representing the point.

[para] Note the plural. With the callback it is possible to visualize a point using a group of
items.

[para] Further note that when the callback return an empty list no point is created. In other words,
the callback can also be used to perform checks if a point at the given location is desirable, or
not. This can be combined with the default creation behaviour as the option can be queried, and its
default value is the callback for the default behaviour.

[para] Keeping with the callback for a bit, the option [option -active-cmd] sets a callback invoked
whenever the mouse is over one of the created points, i.e. active. This can be used to drive derived
displays. For example highlighting the point's entry in a table or other widget.

[para] The last option of importance is [option -tag]. Its value is the name of the canvas tag used
to mark all the items owned, i.e. created and managed by an. The default is [const POINT].

[para] When attaching multiple instances of this behaviour to the same canvas each instance has to
be configured with a unique tag, to prevent them from interfering with each other.

[section {Class API}]

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd ::canvas::edit] [method points] [arg objectName] [arg canvas] [arg options]...]

This, the class command, creates and configures a new instance of a
point cloud editor, named [arg objectName]. The instance will be
connected to the specified [arg canvas] widget.

[para] The result of the command is the fully qualified name of the
instance command.

[para] The options accepted here, and their values, are explained in
the section [sectref Options].

[list_end]

[section {Instance API}]

Instances of the point cloud editors provide the following API:

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd objectName] [method destroy]]

This method destroys the point cloud editor and releases all its
internal resources.

[para] Note that this operation does not destroy the items of the
point markers the editor managed on the attached canvas, nor the
canvas itself.

[para] The result of the method is an empty string.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd objectName] [method enable]]

This method activates editing of the point cloud on the canvas. This
is the default after instance creation. A call is ignored if the
editor is already active.

[para] The result of the method is an empty string.

[para] The complementary method is [method disable]. The interogatory
method for the current state is [method active].

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd objectName] [method disable]]

This method disables editing of the point cloud on the canvas. A call
is ignored if the editor is already disabled.

[para] The result of the method is an empty string.

[para] The complementary method is [method enable]. The interogatory
method for the current state is [method active].

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd objectName] [method active]]

This method queries the editor state.

[para] The result of the method is a boolean value, [const true] if
the editor is active, and [const false] otherwise, i.e. disabled.

[para] The methods to change the state are [method enable] and
[method disable].

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd objectName] [method add] [arg x] [arg y]]

This method programmatically creates a point at the specified location.

[para] The result of the method is an empty string.

[para] Note that this method goes through the whole set of callbacks
invoked when the user interactively creates a point, i.e.
[option -create-cmd], and, more importantly, [option -data-cmd].

[para] This is the method through which to load pre-existing points
into an editor instance.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd objectName] [method clear]]

This method programmatically removes all points from the editor.

[para] The result of the method is an empty string.

[para] Note that this method goes through the same callback invoked
when the user interactively removes a point, i.e. [option -data-cmd].

[list_end]

[section Options]

The class command accepts the following options

[list_begin options]

[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -active-cmd [arg command-prefix]]

The value of this option is a command prefix the editor will invoke
when the mouse enters or leaves a point managed by the instance.

[para] If not specified it defaults to an empty command which does nothing.

[para] The signature of this command prefix is

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd activeCmd] [arg editorObj] [arg id]]

[para] The [arg id] identifies the point within the editor.

[para] An empty [arg id] indicates that the last entered point was left.

[para] The result of this method is ignored.

[list_end]

[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -add-remove-point [arg eventspec]]

The value of this option is an event specification (without bracketing angles) declaring which event
will trigger adding and removing a point.

[para] This option can only be set at construction time.

[para] The default setup uses different events for adding and removing points, [const ButtonPress-1]
and [const ButtonPress-2] respectively.

[para] When using this option the same event is used for both operations. This is no problem because
adding is bound as canvas-global event while removal is bound to the relevant canvas items.

[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -color [arg colorspec]]

The value of this option is the fill color for the default item created when adding a point, and no
[option -create-cmd] is specified.

[para] The default value is [const SkyBlue2].

[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -create-cmd [arg command-prefix]]

The value of this option is a command prefix the editor will invoke
when it has to create a new point.

[para] While this option can be set after construction, it is recommended to use this feature only
as a means of inserting custom processing to be done at creation time which remembers and calls the
previous value of the option.

[para] If not specified it defaults to a command which will create a
black-bordered blue circle of radius 3 centered on the location of the
new point.

[para] The signature of this command prefix is

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd createCmd] [arg canvas] [arg x] [arg y]]

The result of the command prefix [emph must] be a list of the canvas
items it created to represent the marker. Note here that the visual
representation of a "point" may consist of multiple canvas items in an
arbitrary shape.

[para] The returned list of items is allowed to be empty, and such is
taken as signal that the callback vetoed the creation of the point.

[list_end]

[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -data-cmd [arg command-prefix]]

The value of this option is a command prefix the editor will invoke
when a point was edited in some way. This is how the editor delegates
the actual storage of point information to an outside object.

[para] This option can only be set at construction time.

[para] If not specified it defaults to an empty string and is ignored
by the editor, i.e. not invoked.

[para] The signatures of this command prefix are

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd dataCmd] [method add] [arg editorObj] [arg id] [arg x] [arg y]]

This callback is invoked when a new point was added to the instance,
either interactively, or programmatically.

See instance method [method add] for the latter.

[para] The [arg id] identifies the point within the editor and will be
used by the two other callbacks to specify which point to modify.

[para] The last two arguments [arg x] and [arg y] specify the location
of the new point in canvas coordinates.

[para] The result of this method is ignored.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd dataCmd] [method remove] [arg editorObj] [arg id]]

This callback is invoked when a point removed from the editor
instance.

[para] The [arg id] identifies the removed point within the editor.

[para] The result of this method is ignored.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd dataCmd] [method {move start}] [arg editorObj] [arg id]]

This callback is invoked when the movement of a point in the editor
instance has started.

[para] The [arg id] identifies the point within the editor about to be
moved.

[para] The result of this method is ignored.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd dataCmd] [method {move delta}] [arg editorObj] [arg id] [arg x] [arg y] [arg dx] [arg dy]]

This callback is invoked when the point moved in the editor instance.

[para] The [arg id] identifies the moved point within the editor, and
the remaining arguments [arg x], [arg y], [arg dx], and [arg dy]
provide the new absolute location of the point, and full delta to the
original location.

[para] At the time of the calls the system is [emph not] committed to
the move yet. Only after method [method {move done}] was invoked and
has accepted or rejected the last position will the editor update its
internal data structures, either committing to the new location, or
rolling the move back to the original one.

[para] Given this the location data provided here should be saved only
in temporary storage until then.

[para] The result of this method is ignored.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd dataCmd] [method {move done}] [arg editorObj] [arg id]]

This callback is invoked when the movement of a point in the editor
instance is complete.

[para] The [arg id] identifies the moved point within the editor.

[para] The result of this method must be a boolean value. If the
method returns [const false] the move is vetoed and rollbed back.

[list_end][comment callback-signatures]

[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -drag-point [arg eventspec]]

The value of this option is an event specification (without bracketing angles) declaring which event
will trigger a drag action on points.

[para] This option can only be set at construction time.

[para] The default specification is [const ButtonPress-3].

[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -hilit-color [arg colorspec]]

The value of this option is the highlight color for the default item created when adding a point,
and no [option -highlight-cmd] is specified.

[para] The default value is [const red].

[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -kind [arg name]]

The value of this option is the canvas item type for the default item created when adding a point,
and no [option -create-cmd] is specified.

Only item types specified through a bounding box are suitable.

[para] The default value is [const oval].

[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -radius [arg int]]

The value of this option is the radius for the default item created when adding a point,
and no [option -create-cmd] is specified.

[para] The default value is [const 3].

[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -tag [arg string]]

The value of this option is the name of the canvas tag with which to
identify all items of all points managed by the editor.

[para] This option can only be set at construction time.

[para] If not specified it defaults to [const POINT]

[list_end][comment options]
[vset CATEGORY canvas]
[include ../../support/devel/doc/feedback.inc]
[manpage_end]
