-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-------------------------------------------------------------------------------
--                                                                           --
-- SPARK.Crypto.Debug                                                        --
--                                                                           --
-- Implementation Notes                                                      --
--                                                                           --
-- None                                                                      --
-------------------------------------------------------------------------------

with Ada.Text_IO; use Ada.Text_IO;
with SPARK.Unsigned;

package body SPARK.Crypto.Debug is

   Indent : constant String := "    ";

   procedure Put_Byte (B : in Unsigned.Byte)
   is
      use type Unsigned.Byte;
      subtype Nibble is Unsigned.Byte range 0 .. 15;
      type Nibble_To_Char is array (Nibble) of Character;
      To_Char : constant Nibble_To_Char :=
        Nibble_To_Char'('0', '1', '2', '3', '4', '5', '6', '7',
                        '8', '9', 'A', 'B', 'C', 'D', 'E', 'F');
      MSB : constant Nibble := B / 16;
      LSB : constant Nibble := B mod 16;
   begin
      Put (Standard_Output, To_Char (MSB));
      Put (Standard_Output, To_Char (LSB));
   end Put_Byte;

   procedure Show_8 (S     : in Byte_Seq;
                     Count : in Natural)
   is
   begin

      if Count >= 1 then
         for I in Natural range S'First .. Count - 1 loop
            if (I mod 16) = 0 then
               Put (Indent);
            else
               if (I mod 4) = 0 then
                  Put (' ');
               end if;
            end if;

            Put (' ');
            Put_Byte (S (I));

            if (I mod 16) = 15 or I = S'Last then
               New_Line;
            end if;
         end loop;
      end if;
   end Show_8;

   ----------------
   -- Show_Msg_8 --
   ----------------

   procedure Show_Msg_8
     (Msg   : in String;
      S     : in Crypto.Byte_Seq;
      Count : in Natural)
   is
   begin
      Put_Line (Msg);
      Show_8 (S, Count);
      New_Line;
   end Show_Msg_8;

end SPARK.Crypto.Debug;
