-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem)
procedure Check_Task_Modifier_Consistency
  (The_Own_Var_Type : in     Dictionary.Symbol;
   The_Var_Type     : in     Dictionary.Symbol;
   Modifier_Is_Task : in     Boolean;
   Error_Node       : in     STree.SyntaxNode;
   Consistent       :    out Boolean)
is
   Error_Number : Natural := 0;
begin
   if Modifier_Is_Task then
      -- Do we know anything about the type announcement?
      if Dictionary.Is_Declared (Item => The_Own_Var_Type) or else Dictionary.IsPredefined (The_Own_Var_Type) then
         if not Dictionary.TypeIsTask (The_Own_Var_Type) then
            Error_Number := 855;
         elsif Dictionary.IsSubtype (The_Own_Var_Type) then
            Error_Number := 948;
         end if;
      end if;
      if not Dictionary.Is_Null_Symbol (The_Var_Type) and then not Dictionary.TypeIsTask (The_Var_Type) then
         -- The modifier is 'task', we're declaring a task object but the
         -- type is not a task or task subtype.
         Error_Number := 855;
      end if;
   else -- the modifier is not 'task'

      -- Do we know anything about the type announcement?
      if Dictionary.Is_Declared (Item => The_Own_Var_Type) or else Dictionary.IsPredefined (The_Own_Var_Type) then
         if Dictionary.TypeIsTask (The_Own_Var_Type) then
            -- We know that the announced type is
            -- not a task type (or subtype)
            Error_Number := 855;
         end if;
      end if;
      if not Dictionary.Is_Null_Symbol (The_Var_Type) and then Dictionary.TypeIsTask (The_Var_Type) then
         -- The modifier is not task, we're declaring a task object.
         Error_Number := 855;
      end if;
   end if;
   if Error_Number /= 0 then
      ErrorHandler.Semantic_Error
        (Err_Num   => Error_Number,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Error_Node),
         Id_Str    => Node_Lex_String (Node => Error_Node));
   end if;
   Consistent := Error_Number = 0;
end Check_Task_Modifier_Consistency;
