/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.errorbars;

import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.errorbars.AErrorBarPolicyConfigurable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ErrorBarPolicyRelative
extends AErrorBarPolicyConfigurable {
    private double m_relativeXError = 0.02;
    private double m_relativeYError = 0.02;

    public ErrorBarPolicyRelative(double relativeError) throws IllegalArgumentException {
        this(relativeError, relativeError);
    }

    public ErrorBarPolicyRelative(double relativeXError, double relativeYError) throws IllegalArgumentException {
        this.setRelativeXError(relativeXError);
        this.setRelativeYError(relativeYError);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorBarPolicyRelative other = (ErrorBarPolicyRelative)obj;
        if (Double.doubleToLongBits(this.m_relativeXError) != Double.doubleToLongBits(other.m_relativeXError)) {
            return false;
        }
        return Double.doubleToLongBits(this.m_relativeYError) == Double.doubleToLongBits(other.m_relativeYError);
    }

    public JComponent getCustomConfigurator() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        JLabel xErrorLable = new JLabel("Relative X error (%) ");
        panel.add((Component)xErrorLable, gbc);
        SpinnerNumberModel numberXModel = new SpinnerNumberModel(this.getRelativeXError() * 100.0, 0.0, 100.0, 1.0);
        JSpinner xErrorSelector = new JSpinner(numberXModel);
        gbc.gridx = 1;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        panel.add((Component)xErrorSelector, gbc);
        gbc.gridx = 2;
        gbc.gridheight = 2;
        gbc.fill = 2;
        gbc.weightx = 0.5;
        panel.add(Box.createHorizontalGlue(), gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        JLabel yErrorLable = new JLabel("Relative Y error (%) ");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        panel.add((Component)yErrorLable, gbc);
        SpinnerNumberModel numberYModel = new SpinnerNumberModel(this.getRelativeYError() * 100.0, 0.0, 100.0, 1.0);
        JSpinner yErrorSelector = new JSpinner(numberYModel);
        gbc.gridx = 1;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        panel.add((Component)yErrorSelector, gbc);
        xErrorSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
                Number number = model.getNumber();
                ErrorBarPolicyRelative.this.setRelativeXError(number.doubleValue() / 100.0);
            }
        });
        yErrorSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
                Number number = model.getNumber();
                ErrorBarPolicyRelative.this.setRelativeYError(number.doubleValue() / 100.0);
            }
        });
        return panel;
    }

    public final double getRelativeXError() {
        return this.m_relativeXError;
    }

    public final double getRelativeYError() {
        return this.m_relativeYError;
    }

    public final double getXError(double xValue) {
        return this.m_relativeXError * xValue;
    }

    public final double getYError(double yValue) {
        return this.m_relativeYError * yValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.m_relativeXError);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m_relativeYError);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    protected int internalGetNegativeXError(int xPixel, int yPixel, ITracePoint2D original) {
        double error = (double)(xPixel - this.getTrace().getRenderer().getXChartStart()) * this.m_relativeXError;
        int result = (int)Math.round((double)xPixel - error);
        return result;
    }

    protected int internalGetNegativeYError(int xPixel, int yPixel, ITracePoint2D original) {
        int error = (int)Math.round((double)(this.getTrace().getRenderer().getYChartStart() - yPixel) * this.m_relativeYError);
        return yPixel + error;
    }

    protected int internalGetPositiveXError(int xPixel, int yPixel, ITracePoint2D original) {
        double error = (double)(xPixel - this.getTrace().getRenderer().getXChartStart()) * this.m_relativeXError;
        int result = (int)Math.round((double)xPixel + error);
        return result;
    }

    protected int internalGetPositiveYError(int xPixel, int yPixel, ITracePoint2D original) {
        int error = (int)Math.round((double)(this.getTrace().getRenderer().getYChartStart() - yPixel) * this.m_relativeYError);
        return yPixel - error;
    }

    public final void setRelativeXError(double relativeXError) throws IllegalArgumentException {
        boolean change;
        if (relativeXError <= 0.0 || relativeXError >= 1.0) {
            throw new IllegalArgumentException("Given relative error (" + relativeXError + ")has to be between 0.0 and 1.0.");
        }
        boolean bl = change = this.m_relativeXError != relativeXError;
        if (change) {
            this.m_relativeXError = relativeXError;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }

    public final void setRelativeYError(double relativeYError) throws IllegalArgumentException {
        boolean change;
        if (relativeYError <= 0.0 || relativeYError >= 1.0) {
            throw new IllegalArgumentException("Given relative error (" + relativeYError + ")has to be between 0.0 and 1.0.");
        }
        boolean bl = change = this.m_relativeYError != relativeYError;
        if (change) {
            this.m_relativeYError = relativeYError;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }
}

