#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:27:41 
# uninstall.sh
# shell main uninstall entry point

# P A R S E   C O M M A N D   L I N E
hasfile=
oprev=
for o ;do
	# if the previous option needs an argument, assign it.
  	if [ -n "${oprev}" ]; then
		eval "${oprev}=\${o}"
		oprev=
 		continue
 	fi

  	case "${o}" in
		-f) 
			oprev=file 
			hasfile=true 
		;;
	esac
done
if [ ! -z "${hasfile}" ]; then
	[ -n "${file}" ] || file="sadms.settings"
	i=0
	while read line; do
		name=`echo ${line} | awk 'BEGIN{FS="="}{print $1}'`
		value=`echo ${line} | awk 'BEGIN{FS="="}{print $2}'`
		#echo "+${line} = ${name} + ${value}"
		case ${name} in
			realm) MYREALM="${value}" ; i=$(( i + 1 )) ;;
			dns) MYDNS="${value}" ; i=$(( i + 1 )) ;;
			kdc) MYKDC="${value}" ; i=$(( i + 1 )) ;;
			domain) MYDOMAIN="${value}" ; i=$(( i + 1 )) ;;
			server) MYSERVER="${value}" ; i=$(( i + 1 )) ;;
			hostOu)MYOU="${value}" ; i=$(( i + 1 )) ;;
			administrator) MYADMIN="${value}" ; i=$(( i + 1 )) ;;
			users) MYUSERS="${value}" ; i=$(( i + 1 )) ;;
			hostsAllow) MYHOSTALLOW="${value}" ; i=$(( i + 1 )) ;;
			winsServer) MYWINSSERVER="${value}" ; i=$(( i + 1 )) ;;
			administratorPassword) MYADMINPWD="${value}" ; i=$(( i + 1 )) ;;
		esac
	MYNARGS=${i}		
	done < ${file}
	echo "+read ${MYNARGS} settings from ${file}"
	echo 
else
	# echo no file
	MYNARGS=$#
	MYREALM="$1"
	MYDNS="$2"
	MYKDC="$3"
	MYDOMAIN="$4"
	MYSERVER="$5"
	MYOU="$6"
	MYADMIN="$7"
	MYUSERS="$8"
	MYHOSTALLOW="$9"
	shift
	MYWINSSERVER="$9"
fi

echo "-------------------------------------------------------------------------------"
echo "S A D M S  `cat version | head -n 1`"
echo "Samba as Active Directory Member Server"
echo "bbou@ac-toulouse.fr"
echo "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
echo "uninstall"
echo "-------------------------------------------------------------------------------"

if [ -z "${MYADMIN}" ]; then
	read -p 'Admin login (ex:administrator): ' MYADMIN
fi
echo
echo 'Admin login: ' ${MYADMIN}
echo
read -p 'Do you want to proceed (y/n) ?: ' yes

case ${yes} in
y*|Y*)
	if [ -z "${MYADMINPWD}" ]; then
		read -s -p 'Admin login password : ' MYADMINPWD
		echo
	fi
	./_uninstall-core.sh "${MYADMIN}" "${MYADMINPWD}"
	exit $?
	;;
*)
	exit
	;;
esac
