#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:25:39  
# kerberos-get-tgt.sh

### P A R A M S

MYVERBOSE=
if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	shift
fi
MYREALM="$1"
MYADMIN="$2"
MYADMINPWD="$3"

### I N C L U D E

. ./_include.sh

## F I L E S
krbconffile=/etc/krb5.conf

### S T A R T

result=0
echo "+get Kerberos ticket-granting ticket for principal ${MYADMIN}@${MYREALM}"
echo "${MYADMINPWD}" | ${KINIT} ${MYADMIN}@${MYREALM} > /dev/null 2> /dev/null
if [ "$?" != "0" ]; then
	echo "could not acquire Kerberos ticket" >&2
	echo "+WARNING" >&2 
	echo "Kerberos requires administrator's password" >&2 
	echo "to have been reset once since domain install" >&2
	echo "in order to add DES encryption keys to user" >&2
	echo "account which only has a RC4 key when" >&2
	echo "initially created." >&2
	exit 1
fi
echo -n "got ticket-granting ticket for principal "
${KLIST} -5 | grep "krbtgt/" | awk '{print $5 }'
exit 0
