/* rygel-media-export-dvd-container.c generated by valac 0.36.6, the Vala compiler
 * generated from rygel-media-export-dvd-container.vala, do not modify */

/*
 * Copyright (C) 2015 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;

#define RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER (rygel_media_export_dvd_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainer))
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DVD_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DVD_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainerClass))

typedef struct _RygelMediaExportDVDContainer RygelMediaExportDVDContainer;
typedef struct _RygelMediaExportDVDContainerClass RygelMediaExportDVDContainerClass;
typedef struct _RygelMediaExportDVDContainerPrivate RygelMediaExportDVDContainerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
typedef struct _RygelMediaExportDvdContainerFindObjectData RygelMediaExportDvdContainerFindObjectData;
typedef struct _RygelMediaExportDvdContainerCommitData RygelMediaExportDvdContainerCommitData;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _RygelMediaExportDvdContainerCommitCustomData RygelMediaExportDvdContainerCommitCustomData;

#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DVD_TRACK (rygel_media_export_dvd_track_get_type ())
#define RYGEL_MEDIA_EXPORT_DVD_TRACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_TRACK, RygelMediaExportDVDTrack))
#define RYGEL_MEDIA_EXPORT_DVD_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_TRACK, RygelMediaExportDVDTrackClass))
#define RYGEL_MEDIA_EXPORT_IS_DVD_TRACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_TRACK))
#define RYGEL_MEDIA_EXPORT_IS_DVD_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_TRACK))
#define RYGEL_MEDIA_EXPORT_DVD_TRACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_TRACK, RygelMediaExportDVDTrackClass))

typedef struct _RygelMediaExportDVDTrack RygelMediaExportDVDTrack;
typedef struct _RygelMediaExportDVDTrackClass RygelMediaExportDVDTrackClass;

struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportDVDContainer {
	RygelSimpleContainer parent_instance;
	RygelMediaExportDVDContainerPrivate * priv;
};

struct _RygelMediaExportDVDContainerClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelMediaExportDVDContainerPrivate {
	gchar* _path;
	GUPnPXMLDoc* doc;
};

struct _RygelMediaExportDvdContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelMediaExportDVDContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gchar** parts;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint parts_length1;
	gint _parts_size_;
	gint track;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gint _tmp7_;
	xmlXPathContext* context;
	GUPnPXMLDoc* _tmp8_;
	xmlDoc* _tmp9_;
	xmlXPathContext* _tmp10_;
	xmlXPathObject* xpo;
	xmlXPathContext* _tmp11_;
	xmlXPathObject* _tmp12_;
	gboolean _tmp13_;
	xmlXPathObject* _tmp14_;
	xmlXPathObjectType _tmp15_;
	xmlXPathObject* _tmp16_;
	xmlNodeSet* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	xmlXPathObject* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	RygelMediaFileItem* object;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	gint _tmp25_;
	xmlXPathObject* _tmp26_;
	xmlNodeSet* _tmp27_;
	gint _tmp28_;
	xmlNode* _tmp29_;
	RygelMediaFileItem* _tmp30_;
	xmlXPathObject* _tmp31_;
};

struct _RygelMediaExportDvdContainerCommitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelMediaExportDVDContainer* self;
	GError * _inner_error_;
};

struct _RygelMediaExportDvdContainerCommitCustomData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelMediaExportDVDContainer* self;
	gboolean override_guarded;
	RygelMediaExportMediaCache* _tmp0_;
	RygelMediaExportMediaCache* _tmp1_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_dvd_container_parent_class = NULL;
static RygelMediaExportUpdatableObjectIface * rygel_media_export_dvd_container_rygel_media_export_updatable_object_parent_iface = NULL;

GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dvd_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainerPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_DVD_CONTAINER_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_DVD_CONTAINER_PATH_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_UPNP_CLASS RYGEL_MEDIA_CONTAINER_PLAYLIST ".DVD"
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_PREFIX "dvd"
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_TRACK_PREFIX "dvd-track"
RygelMediaExportDVDContainer* rygel_media_export_dvd_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* path);
RygelMediaExportDVDContainer* rygel_media_export_dvd_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* path);
static void rygel_media_export_dvd_container_real_constructed (GObject* base);
const gchar* rygel_media_export_dvd_container_get_path (RygelMediaExportDVDContainer* self);
static gchar* rygel_media_export_dvd_container_get_cache_path (RygelMediaExportDVDContainer* self, const gchar* image_path);
static RygelMediaFileItem* rygel_media_export_dvd_container_get_item_for_xml (RygelMediaExportDVDContainer* self, gint track, xmlNode* node);
static void rygel_media_export_dvd_container_real_find_object_data_free (gpointer _data);
static void rygel_media_export_dvd_container_real_find_object_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void rygel_media_export_dvd_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_dvd_container_real_find_object_co (RygelMediaExportDvdContainerFindObjectData* _data_);
static void rygel_media_export_dvd_container_commit_data_free (gpointer _data);
static void rygel_media_export_dvd_container_commit_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
void rygel_media_export_dvd_container_commit (RygelMediaExportDVDContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_dvd_container_commit_finish (RygelMediaExportDVDContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_export_dvd_container_commit_co (RygelMediaExportDvdContainerCommitData* _data_);
void rygel_media_export_updatable_object_commit_custom (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_updatable_object_commit_custom_finish (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
static void rygel_media_export_dvd_container_commit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_media_export_dvd_container_real_commit_custom_data_free (gpointer _data);
static void rygel_media_export_dvd_container_real_commit_custom_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void rygel_media_export_dvd_container_real_commit_custom (RygelMediaExportUpdatableObject* base, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_dvd_container_real_commit_custom_co (RygelMediaExportDvdContainerCommitCustomData* _data_);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
static gchar* rygel_media_export_dvd_container_get_track_id (RygelMediaExportDVDContainer* self, gint track);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dvd_track_get_type (void) G_GNUC_CONST;
RygelMediaExportDVDTrack* rygel_media_export_dvd_track_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, gint track, xmlNode* node);
RygelMediaExportDVDTrack* rygel_media_export_dvd_track_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint track, xmlNode* node);
void rygel_media_export_dvd_container_set_path (RygelMediaExportDVDContainer* self, const gchar* value);
static void rygel_media_export_dvd_container_finalize (GObject * obj);
static void _vala_rygel_media_export_dvd_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_dvd_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


RygelMediaExportDVDContainer* rygel_media_export_dvd_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* path) {
	RygelMediaExportDVDContainer * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelMediaContainer* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = title;
	_tmp2_ = parent;
	_tmp3_ = path;
	self = (RygelMediaExportDVDContainer*) g_object_new (object_type, "id", _tmp0_, "upnp-class", RYGEL_MEDIA_EXPORT_DVD_CONTAINER_UPNP_CLASS, "title", _tmp1_, "parent", _tmp2_, "child-count", 0, "path", _tmp3_, NULL);
	return self;
}


RygelMediaExportDVDContainer* rygel_media_export_dvd_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* path) {
	return rygel_media_export_dvd_container_construct (RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, id, parent, title, path);
}


static void rygel_media_export_dvd_container_real_constructed (GObject* base) {
	RygelMediaExportDVDContainer * self;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* cache_path = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	xmlDoc* doc = NULL;
	const gchar* _tmp7_;
	xmlDoc* _tmp8_;
	xmlDoc* _tmp9_;
	GUPnPXMLDoc* _tmp10_;
	xmlXPathContext* context = NULL;
	GUPnPXMLDoc* _tmp11_;
	xmlDoc* _tmp12_;
	xmlXPathContext* _tmp13_;
	xmlXPathObject* xpo = NULL;
	xmlXPathContext* _tmp14_;
	xmlXPathObject* _tmp15_;
	xmlXPathObject* _tmp16_;
	xmlXPathObjectType _tmp17_;
	xmlXPathObject* _tmp32_;
	self = (RygelMediaExportDVDContainer*) base;
	G_OBJECT_CLASS (rygel_media_export_dvd_container_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer));
	_tmp0_ = self->priv->_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	rygel_media_object_add_uri ((RygelMediaObject*) self, _tmp4_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	_tmp5_ = self->priv->_path;
	_tmp6_ = rygel_media_export_dvd_container_get_cache_path (self, _tmp5_);
	cache_path = _tmp6_;
	_tmp7_ = cache_path;
	_tmp8_ = xmlReadFile (_tmp7_, NULL, (gint) (((((XML_PARSE_NOERROR | XML_PARSE_NOWARNING) | XML_PARSE_NOBLANKS) | XML_PARSE_RECOVER) | XML_PARSE_NOENT) | XML_PARSE_NONET));
	doc = _tmp8_;
	_tmp9_ = doc;
	_tmp10_ = gupnp_xml_doc_new (_tmp9_);
	_g_object_unref0 (self->priv->doc);
	self->priv->doc = _tmp10_;
	_tmp11_ = self->priv->doc;
	_tmp12_ = _tmp11_->doc;
	_tmp13_ = xmlXPathNewContext (_tmp12_);
	context = _tmp13_;
	_tmp14_ = context;
	_tmp15_ = xmlXPathEval ((xmlChar*) "/lsdvd/track", _tmp14_);
	xpo = _tmp15_;
	_tmp16_ = xpo;
	_tmp17_ = _tmp16_->type;
	if (_tmp17_ != XPATH_NODESET) {
		g_warning ("rygel-media-export-dvd-container.vala:64: No tracks found in DVD");
	} else {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					gint _tmp20_;
					xmlXPathObject* _tmp21_;
					xmlNodeSet* _tmp22_;
					gint _tmp23_;
					xmlNode* node = NULL;
					xmlXPathObject* _tmp24_;
					xmlNodeSet* _tmp25_;
					gint _tmp26_;
					xmlNode* _tmp27_;
					RygelMediaFileItem* item = NULL;
					gint _tmp28_;
					xmlNode* _tmp29_;
					RygelMediaFileItem* _tmp30_;
					RygelMediaFileItem* _tmp31_;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = i;
						i = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp20_ = i;
					_tmp21_ = xpo;
					_tmp22_ = _tmp21_->nodesetval;
					_tmp23_ = xmlXPathNodeSetGetLength (_tmp22_);
					if (!(_tmp20_ < _tmp23_)) {
						break;
					}
					_tmp24_ = xpo;
					_tmp25_ = _tmp24_->nodesetval;
					_tmp26_ = i;
					_tmp27_ = xmlXPathNodeSetItem (_tmp25_, _tmp26_);
					node = _tmp27_;
					_tmp28_ = i;
					_tmp29_ = node;
					_tmp30_ = rygel_media_export_dvd_container_get_item_for_xml (self, _tmp28_, _tmp29_);
					item = _tmp30_;
					_tmp31_ = item;
					rygel_simple_container_add_child_item ((RygelSimpleContainer*) self, (RygelMediaItem*) _tmp31_);
					_g_object_unref0 (item);
				}
			}
		}
	}
	_tmp32_ = xpo;
	xmlXPathFreeObject (_tmp32_);
	_xmlXPathFreeContext0 (context);
	_g_free0 (cache_path);
}


static void rygel_media_export_dvd_container_real_find_object_data_free (gpointer _data) {
	RygelMediaExportDvdContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportDvdContainerFindObjectData, _data_);
}


static void rygel_media_export_dvd_container_real_find_object_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelMediaExportDvdContainerFindObjectData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_media_export_dvd_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportDVDContainer * self;
	RygelMediaExportDvdContainerFindObjectData* _data_;
	RygelMediaExportDVDContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	self = (RygelMediaExportDVDContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportDvdContainerFindObjectData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_media_export_dvd_container_real_find_object_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_dvd_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_media_export_dvd_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_media_export_dvd_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaExportDvdContainerFindObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean rygel_media_export_dvd_container_real_find_object_co (RygelMediaExportDvdContainerFindObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = g_str_has_prefix (_data_->_tmp0_, RYGEL_MEDIA_EXPORT_DVD_CONTAINER_TRACK_PREFIX);
	if (!_data_->_tmp1_) {
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->id;
	_data_->_tmp4_ = _data_->_tmp3_ = g_strsplit (_data_->_tmp2_, ":", 0);
	_data_->parts = _data_->_tmp4_;
	_data_->parts_length1 = _vala_array_length (_data_->_tmp3_);
	_data_->_parts_size_ = _data_->parts_length1;
	_data_->_tmp5_ = _data_->parts;
	_data_->_tmp5__length1 = _data_->parts_length1;
	_data_->_tmp6_ = _data_->_tmp5_[2];
	_data_->_tmp7_ = atoi (_data_->_tmp6_);
	_data_->track = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->self->priv->doc;
	_data_->_tmp9_ = _data_->_tmp8_->doc;
	_data_->_tmp10_ = xmlXPathNewContext (_data_->_tmp9_);
	_data_->context = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->context;
	_data_->_tmp12_ = xmlXPathEval ((xmlChar*) "/lsdvd/track", _data_->_tmp11_);
	_data_->xpo = _data_->_tmp12_;
	_data_->_tmp14_ = _data_->xpo;
	_data_->_tmp15_ = _data_->_tmp14_->type;
	if (_data_->_tmp15_ == XPATH_NODESET) {
		_data_->_tmp16_ = _data_->xpo;
		_data_->_tmp17_ = _data_->_tmp16_->nodesetval;
		_data_->_tmp18_ = xmlXPathNodeSetGetLength (_data_->_tmp17_);
		_data_->_tmp19_ = _data_->track;
		_data_->_tmp13_ = _data_->_tmp18_ >= _data_->_tmp19_;
	} else {
		_data_->_tmp13_ = FALSE;
	}
	if (!_data_->_tmp13_) {
		_data_->_tmp20_ = _data_->xpo;
		xmlXPathFreeObject (_data_->_tmp20_);
		_data_->_tmp21_ = _data_->parts;
		_data_->_tmp21__length1 = _data_->parts_length1;
		_data_->_tmp22_ = _data_->_tmp21_[2];
		g_warning ("rygel-media-export-dvd-container.vala:91: No track %s in DVD", _data_->_tmp22_);
		_data_->result = NULL;
		_xmlXPathFreeContext0 (_data_->context);
		_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp23_ = _data_->parts;
	_data_->_tmp23__length1 = _data_->parts_length1;
	_data_->_tmp24_ = _data_->_tmp23_[2];
	_data_->_tmp25_ = atoi (_data_->_tmp24_);
	_data_->_tmp26_ = _data_->xpo;
	_data_->_tmp27_ = _data_->_tmp26_->nodesetval;
	_data_->_tmp28_ = _data_->track;
	_data_->_tmp29_ = xmlXPathNodeSetItem (_data_->_tmp27_, _data_->_tmp28_);
	_data_->_tmp30_ = rygel_media_export_dvd_container_get_item_for_xml (_data_->self, _data_->_tmp25_, _data_->_tmp29_);
	_data_->object = _data_->_tmp30_;
	_data_->_tmp31_ = _data_->xpo;
	xmlXPathFreeObject (_data_->_tmp31_);
	_data_->result = (RygelMediaObject*) _data_->object;
	_xmlXPathFreeContext0 (_data_->context);
	_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* rygel_media_export_dvd_container_get_cache_path (RygelMediaExportDVDContainer* self, const gchar* image_path) {
	gchar* result = NULL;
	const gchar* user_cache = NULL;
	const gchar* _tmp0_;
	gchar* id = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* cache_folder = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (image_path != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	user_cache = _tmp0_;
	_tmp1_ = image_path;
	_tmp2_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp1_, (gsize) -1);
	id = _tmp2_;
	_tmp3_ = g_build_filename (user_cache, "rygel", "dvd-content", NULL);
	cache_folder = _tmp3_;
	g_mkdir_with_parents (cache_folder, 0700);
	_tmp4_ = g_build_filename (cache_folder, id, NULL);
	result = _tmp4_;
	_g_free0 (cache_folder);
	_g_free0 (id);
	return result;
}


static void rygel_media_export_dvd_container_commit_data_free (gpointer _data) {
	RygelMediaExportDvdContainerCommitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportDvdContainerCommitData, _data_);
}


static void rygel_media_export_dvd_container_commit_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelMediaExportDvdContainerCommitData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void rygel_media_export_dvd_container_commit (RygelMediaExportDVDContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportDvdContainerCommitData* _data_;
	RygelMediaExportDVDContainer* _tmp0_;
	_data_ = g_slice_new0 (RygelMediaExportDvdContainerCommitData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_media_export_dvd_container_commit_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_dvd_container_commit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_dvd_container_commit_co (_data_);
}


void rygel_media_export_dvd_container_commit_finish (RygelMediaExportDVDContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaExportDvdContainerCommitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static void rygel_media_export_dvd_container_commit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportDvdContainerCommitData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_media_export_dvd_container_commit_co (_data_);
}


static gboolean rygel_media_export_dvd_container_commit_co (RygelMediaExportDvdContainerCommitData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	rygel_media_export_updatable_object_commit_custom ((RygelMediaExportUpdatableObject*) _data_->self, TRUE, rygel_media_export_dvd_container_commit_ready, _data_);
	return FALSE;
	_state_1:
	rygel_media_export_updatable_object_commit_custom_finish ((RygelMediaExportUpdatableObject*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_export_dvd_container_real_commit_custom_data_free (gpointer _data) {
	RygelMediaExportDvdContainerCommitCustomData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportDvdContainerCommitCustomData, _data_);
}


static void rygel_media_export_dvd_container_real_commit_custom_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelMediaExportDvdContainerCommitCustomData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rygel_media_export_dvd_container_real_commit_custom (RygelMediaExportUpdatableObject* base, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportDVDContainer * self;
	RygelMediaExportDvdContainerCommitCustomData* _data_;
	RygelMediaExportDVDContainer* _tmp0_;
	gboolean _tmp1_;
	self = (RygelMediaExportDVDContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportDvdContainerCommitCustomData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_media_export_dvd_container_real_commit_custom_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_dvd_container_real_commit_custom_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = override_guarded;
	_data_->override_guarded = _tmp1_;
	rygel_media_export_dvd_container_real_commit_custom_co (_data_);
}


static void rygel_media_export_dvd_container_real_commit_custom_finish (RygelMediaExportUpdatableObject* base, GAsyncResult* _res_, GError** error) {
	RygelMediaExportDvdContainerCommitCustomData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static gboolean rygel_media_export_dvd_container_real_commit_custom_co (RygelMediaExportDvdContainerCommitCustomData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_media_export_media_cache_get_default ();
	_data_->_tmp1_ = _data_->_tmp0_;
	rygel_media_export_media_cache_save_container (_data_->_tmp1_, (RygelMediaContainer*) _data_->self, &_data_->_inner_error_);
	_g_object_unref0 (_data_->_tmp1_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static gchar* rygel_media_export_dvd_container_get_track_id (RygelMediaExportDVDContainer* self, gint track) {
	gchar* result = NULL;
	gchar** parts = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ":", 0);
	parts = _tmp3_;
	parts_length1 = _vala_array_length (_tmp2_);
	_parts_size_ = parts_length1;
	_tmp4_ = parts;
	_tmp4__length1 = parts_length1;
	_tmp5_ = g_strdup ("dvd-track");
	_g_free0 (_tmp4_[0]);
	_tmp4_[0] = _tmp5_;
	_tmp6_ = _tmp4_[0];
	_tmp7_ = parts;
	_tmp7__length1 = parts_length1;
	_tmp8_ = track;
	_tmp9_ = g_strdup_printf ("%i", _tmp8_);
	_vala_array_add1 (&parts, &parts_length1, &_parts_size_, _tmp9_);
	_tmp10_ = parts;
	_tmp10__length1 = parts_length1;
	_tmp11_ = _vala_g_strjoinv (":", _tmp10_, _tmp10__length1);
	result = _tmp11_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static RygelMediaFileItem* rygel_media_export_dvd_container_get_item_for_xml (RygelMediaExportDVDContainer* self, gint track, xmlNode* node) {
	RygelMediaFileItem* result = NULL;
	RygelMediaExportDVDTrack* item = NULL;
	gint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	xmlNode* _tmp7_;
	RygelMediaExportDVDTrack* _tmp8_;
	RygelMediaExportDVDTrack* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = track;
	_tmp1_ = rygel_media_export_dvd_container_get_track_id (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = track;
	_tmp4_ = g_strdup_printf (_ ("Title %d"), _tmp3_ + 1);
	_tmp5_ = _tmp4_;
	_tmp6_ = track;
	_tmp7_ = node;
	_tmp8_ = rygel_media_export_dvd_track_new (_tmp2_, (RygelMediaContainer*) self, _tmp5_, _tmp6_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	item = _tmp9_;
	rygel_media_object_set_parent_ref ((RygelMediaObject*) item, (RygelMediaContainer*) self);
	result = (RygelMediaFileItem*) item;
	return result;
}


const gchar* rygel_media_export_dvd_container_get_path (RygelMediaExportDVDContainer* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	result = _tmp0_;
	return result;
}


void rygel_media_export_dvd_container_set_path (RygelMediaExportDVDContainer* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_export_dvd_container_get_path (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp1_;
		g_object_notify ((GObject *) self, "path");
	}
}


static void rygel_media_export_dvd_container_class_init (RygelMediaExportDVDContainerClass * klass) {
	rygel_media_export_dvd_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportDVDContainerPrivate));
	((GObjectClass *) klass)->constructed = (void (*) (GObject *)) rygel_media_export_dvd_container_real_constructed;
	((RygelMediaContainerClass *) klass)->find_object = (void (*) (RygelMediaContainer *, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_media_export_dvd_container_real_find_object;
	((RygelMediaContainerClass *) klass)->find_object_finish = (RygelMediaObject* (*) (RygelMediaContainer *, GAsyncResult*, GError**)) rygel_media_export_dvd_container_real_find_object_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_dvd_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_dvd_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_dvd_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_DVD_CONTAINER_PATH_PROPERTY, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void rygel_media_export_dvd_container_rygel_media_export_updatable_object_interface_init (RygelMediaExportUpdatableObjectIface * iface) {
	rygel_media_export_dvd_container_rygel_media_export_updatable_object_parent_iface = g_type_interface_peek_parent (iface);
	iface->commit_custom = (void (*) (RygelMediaExportUpdatableObject *, gboolean, GAsyncReadyCallback, gpointer)) rygel_media_export_dvd_container_real_commit_custom;
	iface->commit_custom_finish = (void (*) (RygelMediaExportUpdatableObject *, GAsyncResult*, GError**)) rygel_media_export_dvd_container_real_commit_custom_finish;
}


static void rygel_media_export_dvd_container_instance_init (RygelMediaExportDVDContainer * self) {
	self->priv = RYGEL_MEDIA_EXPORT_DVD_CONTAINER_GET_PRIVATE (self);
}


static void rygel_media_export_dvd_container_finalize (GObject * obj) {
	RygelMediaExportDVDContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainer);
	_g_free0 (self->priv->_path);
	_g_object_unref0 (self->priv->doc);
	G_OBJECT_CLASS (rygel_media_export_dvd_container_parent_class)->finalize (obj);
}


GType rygel_media_export_dvd_container_get_type (void) {
	static volatile gsize rygel_media_export_dvd_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_dvd_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportDVDContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_dvd_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportDVDContainer), 0, (GInstanceInitFunc) rygel_media_export_dvd_container_instance_init, NULL };
		static const GInterfaceInfo rygel_media_export_updatable_object_info = { (GInterfaceInitFunc) rygel_media_export_dvd_container_rygel_media_export_updatable_object_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_export_dvd_container_type_id;
		rygel_media_export_dvd_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelMediaExportDVDContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_media_export_dvd_container_type_id, RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, &rygel_media_export_updatable_object_info);
		g_once_init_leave (&rygel_media_export_dvd_container_type_id__volatile, rygel_media_export_dvd_container_type_id);
	}
	return rygel_media_export_dvd_container_type_id__volatile;
}


static void _vala_rygel_media_export_dvd_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportDVDContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainer);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_DVD_CONTAINER_PATH_PROPERTY:
		g_value_set_string (value, rygel_media_export_dvd_container_get_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_export_dvd_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportDVDContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainer);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_DVD_CONTAINER_PATH_PROPERTY:
		rygel_media_export_dvd_container_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



