#!/bin/bash
#
# A shell script to verify DB generated by generate_random_db.sh cannot opened and read correct data.
# ./ldb needs to be avaible to be executed.
#
# Usage: <SCRIPT> <DB Path>

scriptpath=`dirname $BASH_SOURCE`
if [ "$#" -lt 2 ]; then
  echo "usage: $BASH_SOURCE <db_directory> <compare_base_db_directory> [dump_file_name]"
  exit 1
fi

db_dir=$1
base_db_dir=$2
dump_file_name=${3:-"dump_file.txt"}
db_dump=$db_dir"/"$dump_file_name
base_db_dump=$base_db_dir"/"$dump_file_name

set -e
echo == Dumping data from $db_dir to $db_dump
./ldb dump --db=$db_dir > $db_dump

echo == Dumping data from $base_db_dir to $base_db_dump
./ldb dump --db=$base_db_dir > $base_db_dump

diff $db_dump $base_db_dir
