#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"."}
GEODIR=${GEODIR-"../../../rheolef/nfem/data"}
BINDIR="../bin"

status=0

command="./form_d_dx_proj_tst P1 P0 -I${GEODIR} carre-v2"
echo "      $command"
eval "      $command 2>/dev/null | \
	diff -bw ${SRCDIR}/carre_d_dx.field - > /dev/null"
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

command="./form_d_dx_proj_tst P1 P0 -I${GEODIR} carre-v2 2>/dev/null | ${BINDIR}/field -field -ndigit 10 -proj -I${GEODIR} -"
echo "      $command"
eval "      $command 2>/dev/null 		| \
	diff -bw ${SRCDIR}/proj-2d.field - > /dev/null"
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

command="./form_d_dx_proj_tst P1 P0 -I${GEODIR} box-T-2-v2 2>/dev/null | ${BINDIR}/field -field -ndigit 10 -proj -I${GEODIR} -"

echo "      $command"
eval "      $command 2>/dev/null | diff -bw ${SRCDIR}/proj-3d.field -";  # > /dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

exit $status

