space cavity_space (const geo& omega_h, std::string approx) {
    space Vh (omega_h, approx, "vector");
    Vh.block("top");  Vh.block("bottom");
    if (omega_h.dimension() == 3) {
      Vh.block("front");  Vh.block("back");
      Vh[1].block("left");  Vh[1].block("right");
    } else {
      Vh.block("left"); Vh.block("right");
    }
    return Vh;
}
field cavity_field (const space& Vh, Float alpha) {
    field uh (Vh, 0.);
    uh[0]["top"] = alpha;
    return uh;
}
