#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "embankment.h"
int main(int argc, char**argv) {
  const Float lambda = 1;
  geo  omega (argv[1]);
  space Vh = embankment_space (omega, argv[2]);
  field uh (Vh, 0.0), fh (Vh, 0.0);
  fh [omega.dimension()-1] = -1.0;
  form m  (Vh, Vh, "mass");
  form a1 (Vh, Vh, "div_div");
  form a2 (Vh, Vh, "2D_D");
  form a = lambda*a1 + a2;
  if (omega.dimension() < 3) {
    ssk<Float> fact = ldlt(a.uu);
    uh.u = fact.solve (m.uu*fh.u + m.ub*fh.b - a.ub*uh.b);
  } else {
    size_t max_iter = 10000;
    Float tol = 1e-15;
    uh.u = 0;
    int status = pcg (a.uu, uh.u, m.uu*fh.u + m.ub*fh.b - a.ub*uh.b,
                  ic0(a.uu), max_iter, tol, &cerr);
  }
  cout << catchmark("lambda")  << lambda << endl
       << catchmark("u")       << uh;
  return 0;
}
