///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "boost/multi_array.hpp"
#include <cassert>
#include <iostream>
using namespace std;

template <class T, class Size>
void f (T subarray, Size kmax)
{
     for (Size k = 0; k != kmax; ++k)
	cout << "subsubarray [" << k << "] = " << subarray[k] << endl;
}
void g (boost::multi_array<double, 3>::reference subarray, 
	size_t jmax, size_t kmax)
{
     for (size_t j = 0; j != jmax; ++j)
       for (size_t k = 0; k != kmax; ++k)
  	 cout << "subarray [" << j << "][" << k << "] = " << subarray[j][k] << endl;
#ifdef TO_CLEAN
#endif // TO_CLEAN
}
int
main () {
  // Create a 3D array that is 3 x 4 x 2
  typedef boost::multi_array<double, 3> array_type;
  typedef array_type::index index;
  array_type A(boost::extents[3][4][2]);

  // Assign values to the elements
  int values = 0;
  for(index i = 0; i != 3; ++i)
    for(index j = 0; j != 4; ++j)
      for(index k = 0; k != 2; ++k)
        A[i][j][k] = values++;

  // Verify values
  int verify = 0;
  for(index i = 0; i != 3; ++i)
    for(index j = 0; j != 4; ++j)
      for(index k = 0; k != 2; ++k)
        assert(A[i][j][k] == verify++);

  f (A[0][0], index(2));
  g (A[0], index(4), index(2));
  return 0;
}
