///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/numeric/ublas/matrix_proxy.hpp>
#include <boost/numeric/ublas/vector.hpp>
#include <boost/numeric/ublas/vector_proxy.hpp>
using namespace boost::numeric;

#include <iostream>
using std::cout;
using std::endl;

// BUG: range refers to a local variable !
// => cannot copy range (core dump)
ublas::vector_range<ublas::vector<double> >
f ()
{
	ublas::vector<double> u(4);
	//u.resize(4);
	u(0) = 1;
	u(1) = 2;
	u(2) = 3;
	u(3) = 4;
	u(3) = 4;
	ublas::vector_range<ublas::vector<double> > u1 (u, ublas::range(0, 2));
	return u1;
}
int main()
{
    ublas::vector_range<ublas::vector<double> > u = f ();
    for (size_t i = 0; i < 2; i++)
      cout << "u(" << i << ") = " << u(i) << endl;

}
