# ifndef _SKIT_OUTML_H
# define _SKIT_OUTML_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// OUT ML: Vector & Matrix Output 
//        in Dump and MatLab format
// 
// author: Pierre.Saramito@imag.fr
//
// date: 21 january 1997
//
# include "rheolef/skitbase.h"
namespace rheolef { 

template <class T>
void
print_matlab (std::ostream& os, const vec<T>& x);

template <class T>
void
print_matlab (std::ostream& os, const avec<T>& sx);

template <class T>
void 
print_matlab (std::ostream& os, const csr<T>& a);

// ml_pref with default output choices
struct ml_preferences {

	inline void reset () {

		// Float "20.16lf" format is the default
		output_max_field_width = 20;
		output_precision       = 16;

		// output formated such that can be read by matlab
		pr_as_read_syntax = true;

		// wrap long lignes
		split_long_rows = true;

		// Should we also print the dimensions of empty matrices?
		print_empty_dimensions = true;

		// Nonzero means always print like dollars and cents.
		bank_format = false;

		// Nonzero means use an e format.
		print_e = 0;

		// Nonzero means print E instead of e for exponent field.
		print_big_e = false;

		// Nonzero means print plus sign for nonzero, blank for zero.
		plus_format = false;

		// True means don't do any fancy formatting.
		free_format = false;
	}
	// cstor
	ml_preferences() { reset(); }
	
	int  output_max_field_width;
	int  output_precision;
	bool pr_as_read_syntax;
	bool print_empty_dimensions;
	bool split_long_rows;
	bool bank_format;
	bool print_e;
	bool print_big_e;
	bool plus_format;
	bool free_format;
};
// global var
extern ml_preferences ml_pref;

}// namespace rheolef
# endif /* _SKIT_OUTML_H */
