#ifndef _SKIT_BLAS1_DENSE_NO_TMPL_H
#define _SKIT_BLAS1_DENSE_NO_TMPL_H
//
// file automatically generated using m4 expansion
//
// blas 1 expressions without template expression
// 
// author: Pierre.Saramito@imag.fr
//
// date: 1 april 1997
//
# include "vec.h"
namespace rheolef { 

// norm
template <class T>
T
norm (const vec<T>& x);

// dot product
template <class T>
T
dot (const vec<T>& x, const vec<T>& y);


// unary operators
template <class T>
vec<T>
operator + (const vec<T>& x);

template <class T>
vec<T>
operator - (const vec<T>& x);

// unary functions

template <class T>
vec<T>
abs (const vec<T>& x);

template <class T>
vec<T>
atan (const vec<T>& x);

template <class T>
vec<T>
cos (const vec<T>& x);

template <class T>
vec<T>
cosh (const vec<T>& x);

template <class T>
vec<T>
exp (const vec<T>& x);

template <class T>
vec<T>
log (const vec<T>& x);

template <class T>
vec<T>
log10 (const vec<T>& x);

template <class T>
vec<T>
sin (const vec<T>& x);

template <class T>
vec<T>
sinh (const vec<T>& x);

template <class T>
vec<T>
sqrt (const vec<T>& x);

template <class T>
vec<T>
tanh (const vec<T>& x);

// binary operators and computed assignments

template <class T>
vec<T>
operator + (const vec<T>& x, const vec<T>& y);

template <class T>
vec<T>
operator + (const vec<T>& x, const Float& lambda);

template <class T>
vec<T>
operator + (const Float& lambda, const vec<T>& y);

template <class T>
vec<T>&
operator += (vec<T>& z, const vec<T>& x);

template <class T>
vec<T>&
operator += (vec<T>& z, const Float& lambda);

template <class T>
vec<T>
operator - (const vec<T>& x, const vec<T>& y);

template <class T>
vec<T>
operator - (const vec<T>& x, const Float& lambda);

template <class T>
vec<T>
operator - (const Float& lambda, const vec<T>& y);

template <class T>
vec<T>&
operator -= (vec<T>& z, const vec<T>& x);

template <class T>
vec<T>&
operator -= (vec<T>& z, const Float& lambda);

template <class T>
vec<T>
operator * (const vec<T>& x, const vec<T>& y);

template <class T>
vec<T>
operator * (const vec<T>& x, const Float& lambda);

template <class T>
vec<T>
operator * (const Float& lambda, const vec<T>& y);

template <class T>
vec<T>&
operator *= (vec<T>& z, const vec<T>& x);

template <class T>
vec<T>&
operator *= (vec<T>& z, const Float& lambda);

template <class T>
vec<T>
operator / (const vec<T>& x, const vec<T>& y);

template <class T>
vec<T>
operator / (const vec<T>& x, const Float& lambda);

template <class T>
vec<T>
operator / (const Float& lambda, const vec<T>& y);

template <class T>
vec<T>&
operator /= (vec<T>& z, const vec<T>& x);

template <class T>
vec<T>&
operator /= (vec<T>& z, const Float& lambda);

// binary functions

template <class T>
vec<T>
atan2 (const vec<T>& x, const vec<T>& y);

template <class T>
vec<T>
atan2 (const vec<T>& x, const Float& lambda);

template <class T>
vec<T>
atan2 (const Float& lambda, const vec<T>& y);

template <class T>
vec<T>
max (const vec<T>& x, const vec<T>& y);

template <class T>
vec<T>
max (const vec<T>& x, const Float& lambda);

template <class T>
vec<T>
max (const Float& lambda, const vec<T>& y);

template <class T>
vec<T>
min (const vec<T>& x, const vec<T>& y);

template <class T>
vec<T>
min (const vec<T>& x, const Float& lambda);

template <class T>
vec<T>
min (const Float& lambda, const vec<T>& y);

template <class T>
vec<T>
pow (const vec<T>& x, const vec<T>& y);

template <class T>
vec<T>
pow (const vec<T>& x, const Float& lambda);

template <class T>
vec<T>
pow (const Float& lambda, const vec<T>& y);

// =====================[ INSTANCIATION IN LIBRARY ]=============================

}// namespace rheolef
#endif // _SKIT_BLAS1_DENSE_NO_TMPL_H
