///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//  compute exactly:
//  	int_Omega x^n y^m dx dy
// with 
//      Omega = { 0 <= x <= 1 and 0 <= y <= 1-x^order }
//
#include <ginac/ginac.h>
using namespace GiNaC;
using namespace std;

static 
void
put_gpl (ostream& out)
{
    out << "///" << endl
	<< "/// This file is part of Rheolef." << endl
	<< "///" << endl
	<< "/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>" << endl
	<< "///" << endl
	<< "/// Rheolef is free software; you can redistribute it and/or modify" << endl
	<< "/// it under the terms of the GNU General Public License as published by" << endl
	<< "/// the Free Software Foundation; either version 2 of the License, or" << endl
	<< "/// (at your option) any later version." << endl
	<< "///" << endl
	<< "/// Rheolef is distributed in the hope that it will be useful," << endl
	<< "/// but WITHOUT ANY WARRANTY; without even the implied warranty of" << endl
	<< "/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the" << endl
	<< "/// GNU General Public License for more details." << endl
	<< "///" << endl
	<< "/// You should have received a copy of the GNU General Public License" << endl
	<< "/// along with Rheolef; if not, write to the Free Software" << endl
	<< "/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA" << endl
	<< "///" << endl
	<< "/// =========================================================================" << endl
	;
}
ex
compute_integral (size_t order, size_t n, size_t m) 
{
  symbol x("x"), y("y");
  /* P_order piola triangle transformation here */
  ex y_bas  = (order == 1) ? 0 : x*pow(1-x,order-1);
  ex y_haut = y_bas + 1-x;
  ex J_bas  = integral (y, 0,y_bas,  pow(y,m)).eval_integ();
  ex J_haut = integral (y, 0,y_haut, pow(y,m)).eval_integ();
  ex I_bas  = integral (x, 0,1, pow(x,n)*J_bas).eval_integ();
  ex I_haut = integral (x, 0,1, pow(x,n)*J_haut).eval_integ();
  return I_haut-I_bas;
}
void
put_header (ostream& out, size_t order_max) 
{
  out << "#ifndef _RHEOLEF_CURVED_PK_H" << endl;
  out << "#define _RHEOLEF_CURVED_PK_H" << endl;
  put_gpl (out);
  out << "// file automatically generated by \"" << __FILE__ << "\"" << endl
      << "#include \"rheolef/compiler.h\"" << endl
      << "namespace rheolef {" << endl
      << "const size_t order_max = " << order_max << ";" << endl
      << "extern Float curved_Pk [order_max+1][2*order_max+1][2*order_max+1];" << endl
      << "} // namespace rheolef" << endl
      << "#endif // _RHEOLEF_CURVED_PK_H" << endl;
}
void
put_body (ostream& out, size_t order_max) 
{
  put_gpl (out);
  out << setprecision(16)
      << "// file automatically generated by \"" << __FILE__ << "\"" << endl
      << "#include \"curved_Pk.h\"" << endl
      << "namespace rheolef {" << endl
      << "Float curved_Pk [order_max+1][2*order_max+1][2*order_max+1] = {" << endl
      << " {" << endl
      << " }," << endl;
  for (size_t order = 1; order <= order_max; order++) {
    out << " {" << endl;
    for (size_t n = 0; n <= 2*order; n++) {
      out << "  {" << endl;
      for (size_t m = 0; m <= 2*order; m++) {
        ex value = compute_integral (order, n, m);
	out << "   ";
        value.print(print_csrc_double(out));
        // out << ex_to<numeric>(value.eval_integ());
	if (m != 2*order) out << ",";
        out << endl;
      }
      out << "  }";
      if (n != 2*order) out << ",";
      out << endl;
    }
    out << " }";
    if (order != order_max) out << ",";
    out << endl;
  }
  out << "};" << endl
      << "} // namespace rheolef" << endl;
}
int main (int argc, char**argv) {
  if (argc == 1) {
    cerr << "usage: " << argv[0] << " order [-h|-c]" << endl
         << "example: " << argv[0] << " 3" << endl;
    exit(1);
  }
  size_t order_max  = (argc > 1) ? atoi(argv[1]) : 3;
  bool   header     = (argc > 2 && string(argv[2]) == "-h");
  if (header) {
    put_header (cout, order_max); 
  } else {
    put_body   (cout, order_max); 
  }
}
