#ifndef _RHEOLEF_GEO_VISU_AUX_H
#define _RHEOLEF_GEO_VISU_AUX_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// visualisation primitives for geometries
//
// authors:
//    	Pierre.Saramito@imag.fr
//
// date: 12 may 1997
//
#include "rheolef/georep.h"
namespace rheolef { 

std::string python (const point& x, size_t d = 3) ;

void 
gnuplot_segment (std::ostream& s, const point& p, const point& q, 
	georep::size_type dim);

void
plotmtv_segment (std::ostream& s, const point& p, const point& q, 
        georep::size_type dim, 
        georep::size_type color = 1, georep::size_type width = 1);

void
atom_segment (std::ostream& s, const point& p, const point& q, 
	georep::size_type dim, Float radius, georep::size_type color);

void
x3d_face (std::ostream& s, const point& p, const point& q, const point& r, 
	georep::size_type dim, 
	Float scale, const point& x0, const point& dx);

void
x3d_face (std::ostream& s, const point& p, const point& q, const point& r, 
	const point& u, georep::size_type dim, 
	Float scale, const point& x0, const point& dx);

void
gnuplot_element (std::ostream& s, const geo_element& g, georep::const_iterator_node x, 
	georep::size_type dim);

void
plotmtv_element(std::ostream& s, const geo_element& g, georep::const_iterator_node x,
        georep::size_type dim,
        georep::size_type color = 1,
        georep::size_type width = 1);

void 
atom_element(std::ostream& s, const geo_element& g, georep::const_iterator_node x, 
	georep::size_type dim, Float r, georep::size_type c);

void
x3d_element(std::ostream& s, const geo_element& g, georep::const_iterator_node x, 
	georep::size_type dim,
        Float scale, const point& x0, const point& dx);

}// namespace rheolef
#endif // _RHEOLEF_GEO_VISU_AUX_H
