#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
# --------------------------------------------------------------------
# run tests on scalar problems
# --------------------------------------------------------------------
SBINDIR=${SBINDIR-"../../nfem/sbin"}
BINDIR=${BINDIR-"../../nfem/bin"}
SRCDIR=${SRCDIR-"../../../rheolef/doc/usrman"}
SRCGEO=${SRCGEO-"../../../rheolef/nfem/data"}

RHEOLEF_BASIS_PATH=${RHEOLEF_BASIS_PATH-"../../nfem/basis"}
RHEOLEF_NUMBERING_PATH=${RHEOLEF_NUMBERING_PATH-"../../nfem/basis"}
RHEOLEF_FORM_ELEMENT_PATH=${RHEOLEF_FORM_ELEMENT_PATH-"../../nfem/form_element"}
export RHEOLEF_BASIS_PATH
export RHEOLEF_NUMBERING_PATH
export RHEOLEF_FORM_ELEMENT_PATH

status=0

command="${SBINDIR}/mkgeo_grid_1d 10       -region > line.geo"
echo "      $command"
eval $command 2>/dev/null
if test $? -ne 0; then echo "        => *NO*"; exit 1; fi

command="${SBINDIR}/mkgeo_grid_2d 10 10    -region > square.geo"
echo "      $command"
eval $command 2>/dev/null
if test $? -ne 0; then echo "        => *NO*"; exit 1; fi

command="${SBINDIR}/mkgeo_grid_3d  4  4  4 -region | ${BINDIR}/geo -upgrade -geo - > cube.geo"
echo "      $command"
eval $command 2>/dev/null
if test $? -ne 0; then echo "        => *NO*"; exit 1; fi


check="transmission-error"
pols="P1"
L="
line 	1e-5
square	1e-5
cube	0.4
"
while test "$L" != ""; do
  geo=`echo $L | awk '{print $1}'`
  L=`echo $L | awk '{for (i=2; i <= NF; i++) print $i}'`
  tol=`echo $L | awk '{print $1}'`
  L=`echo $L | awk '{for (i=2; i <= NF; i++) print $i}'`
  command="./transmission $geo P1 | ./transmission-error $tol"
  echo "      $command"
  eval $command 2>/dev/null
  if test $? -ne 0; then status=1; echo "        => *NO*"; fi
done

# --------------------------------------------------------------------
# clean
# --------------------------------------------------------------------
command="/bin/rm -f line.geo square.geo cube.geo"
echo "      $command"
eval $command 2>/dev/null

exit $status

