#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "navier-stokes-solve.h"
#include "cavity.h"
field criteria (Float Re, const field& uh) {
  space Xh  (uh.get_geo(), "P1d");
  form inv_m  (Xh, Xh, "inv_mass");
  form mpt   (Xh, uh.get_space()[0], "mass");
  form p = inv_m * trans(mpt);
  field c1 = sqr(p*uh[0]) + sqr(p*uh[1]);
  space Th  (uh.get_geo(), "P1d", "tensor");
  form two_D (uh.get_space(), Th, "2D");
  form inv_mt (Th, Th, "inv_mass");
  field two_Duh = inv_mt*(two_D*uh);
  field c2 = sqr(field(two_Duh(0,0))) + sqr(field(two_Duh(1,1))) + 2*sqr(field(two_Duh(0,1)));
  return sqrt(Re*c1 + c2);
}
int main (int argc, char**argv) {
  if (argc < 2) {
    cerr << "usage: " << argv[0] << " <geo> <Re> <Delta t> <n_adapt> <hcoef> <hmin>" << endl;
    exit (1);
  }
  geo    omega_h (argv[1]);
  Float  Re       = (argc > 2) ? atof(argv[2]) : 100;
  Float  delta_t  = (argc > 3) ? atof(argv[3]) : 0.05;
  size_t n_adapt  = (argc > 4) ? atoi(argv[4]) : 3;
  adapt_option_type options;
  options.hcoef   = (argc > 5) ? atof(argv[5]) : 2;
  options.hmin    = (argc > 6) ? atof(argv[6]) : 0.004; // 0.004
  options.hmax    = 0.1;
  space Vh = cavity_space (omega_h, "P2");
  space Qh (omega_h, "P1");
  field uh = cavity_field (Vh, 1.0);
  field ph (Qh, 0.0);
  field fh (Vh, 0.0);
  for (size_t i = 0; true; i++) {
    size_t max_iter = 500;
    Float tol = 1e-10;
    navier_stokes_solve (Re, delta_t, fh, uh, ph, max_iter, tol, &cerr);
    orheostream o (omega_h.name(), "mfield");
    o << setprecision(numeric_limits<Float>::digits10)
      << catchmark("Re") << Re << endl
      << catchmark("delta_t") << delta_t << endl
      << catchmark("u")  << uh
      << catchmark("p")  << ph;
    if (i >= n_adapt) break;
    field ch = criteria(Re,uh);
    omega_h  = geo_adapt(ch, options);
    omega_h.save();
    Vh = cavity_space (omega_h, "P2");
    Qh = space (omega_h, "P1");
    uh = cavity_field (Vh, 1.0);
    ph = field (Qh, 0.0);
    fh = field (Vh, 0);
  }
}
