/*P:demo2_error_grad
NAME: Error analysis for the gradient (@PAKAGE@-@VERSION@)
\cindex{error analysis}

  The following estimation holds for the gradient:
  $$
      \Vert \nabla u - \nabla u_h \Vert_{0,2,\Omega} \approx O(h^k)  
  $$
  $$
      \Vert \nabla u - \nabla u_h \Vert_{0,\infty,\Omega} \approx O(h^k)  
  $$
  The figure~\ref{fig-demo2-err-grad} plots in logarithmic scale the
  error for the gradient versus $nelt^{\frac{1}{2}}$
  for both $P_1$ (on the left) and $P_2$ (on the right) 
  approximations.

  \begin{figure}[H]
   \begin{center}
     \begin{tabular}{cc}
  	\includegraphics[scale=0.9]{demo2-P1-uniform-grad.pdf}
        &
  	\includegraphics[scale=0.9]{demo2-P2-uniform-grad.pdf}
     \end{tabular}
    \end{center}
    \caption{Error analysis for the gradiend: $H^1$ and $W^{1,\infty}$ norms.}
    \label{fig-demo2-err-grad}
  \end{figure}

END:
*/
//<demo2_error_grad:
#include "rheolef/rheolef.h"
using namespace rheolef;
using namespace std;

Float du_dxi (const point& x) { return cos(x[0]+x[1]+x[2]); }

int main(int argc, char**argv)
{
    field qh;
    cin >> qh;
    space Th = qh.get_space();
    field pi_h_q = interpolate(Th, du_dxi);
    field eh = pi_h_q - qh;
    form m(Th, Th, "mass");
    cerr << "error_inf "  << eh.max_abs()       << endl;
    cerr << "error_l2  "  << sqrt(m(eh,eh)) << endl;
    if (argc > 1) cout << eh;
    return 0;
}
//>demo2_error_grad:
