set terminal pslatex auxfile
set output "demo2-P1-uniform-grad.tex"

set logscale
set size square

set xtics (\
        "{$10^{-3}$}" 1e-3, \
	"{$10^{-2}$}" 1e-2, \
	"{$10^{-1}$}" 1e-1 \
	)
set ytics (\
        "[r]{$10^{-3}$}" 1e-3, \
        "[r]{$10^{-2}$}" 1e-2, \
	"[r]{$10^{-1}$}" 1e-1 \
	)
#
# figure label
set label "$P_1$ element" at graph 0.05, 0.90 left

# x-label
set label "[r]{$nelt^{-{1 \\over 2}}$}" at graph 0.95, 0.10 right

set label "[l]{$\\Vert \\nabla(u_h-\\pi_h u)\\Vert_{0,2,\\Omega} $}"       at graph 0.05, 0.15
set label "[l]{$\\Vert \\nabla(u_h-\\pi_h u)\\Vert_{0,\\infty,\\Omega} $}" at graph 0.05, 0.70

# triangle slope: 1
set arrow from graph 0.60, 0.20 to graph 0.80, 0.20 nohead lt 1
set arrow from graph 0.80, 0.20 to graph 0.80, 0.40 nohead lt 1
set arrow from graph 0.80, 0.40 to graph 0.60, 0.20 nohead lt 1
set label "[l]{$\\scriptstyle 1 = k$}" at graph 0.83, 0.30 left

plot [1e-3:1e-1][1e-3:1e-1] \
	"demo2-P1-uniform-grad.gdat" u (1./sqrt($1)):3 notitle with linespoints lt 1, \
	"demo2-P1-uniform-grad.gdat" u (1./sqrt($1)):4 notitle with linespoints lt 1

#pause -1 "<retour>"

