#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "eta.icc"
void usage(string name) {
  derr << name << ": usage: "
       << name << " "
       << "[-|file[.field[.gz]]] "
       << "[-check] "
       << "[-residue] "
       << "[-criteria] "
       << endl;
  exit (1);
}
field residue (Float p, const field& uh) {
  const space& Xh = uh.get_space();
  trial u (Xh); test v (Xh);
  field lh = integrate (v);
  form  m  = integrate (u*v);
  quadrature_option_type qopt;
  qopt.set_family (quadrature_option_type::gauss);
  qopt.set_order  (2*Xh.degree()-1);
  form a  = integrate (compose (eta(p), norm2(grad(uh)))*dot(grad(u),grad(v)), qopt);
  field mrh = a*uh - lh;
  mrh["boundary"] = 0;
  field rh (Xh);
  solver sm = ldlt(m.uu());
  rh.set_u() = sm.solve(mrh.u());
  rh["boundary"] = 0;
  return rh;
}
void check (Float p, const field& uh) {
  field rh = residue(p, uh);
  const space& Xh = rh.get_space();
  trial u (Xh); test v (Xh);
  form m = integrate (u*v);
  Float res = sqrt(m(rh,rh));
  derr << "check: residue = " << res << endl;
  check_macro (res < 1e-3, "unexpected residue");
}
field criteria (Float p, const field& uh) {
  const space& Xh = uh.get_space();
  if (uh.get_approx() == "P1") return interpolate (Xh, abs(uh));
  return interpolate (Xh, pow(norm(grad(uh)), p/2));
}
void
load (idiststream& in, Float& p, field& uh) {
    in >> catchmark("p")     >> p
       >> catchmark("u")     >> uh;
}
int main(int argc, char**argv) {
  environment rheolef (argc,argv);
  if (argc < 3) usage(argv[0]);
  Float p;
  field uh;
  if (string (argv[1]) == "-") {
    load (din, p, uh);
  } else {
    idiststream in;
    in.open(argv[1], "field");
    load (in, p, uh);
  }
  for (int i = 2; i < argc; i++) {
         if (strcmp (argv[i], "-check") == 0) { check (p, uh); }
    else if (strcmp (argv[i], "-residue") == 0) { dout << catchmark("ru")   << residue (p, uh); }
    else if (strcmp (argv[i], "-criteria") == 0) { dout << catchmark("c")   << criteria (p, uh); }
    else {
       derr << argv[0] << ": unknown option \'" << argv[i] << "'" << endl;
       usage(argv[0]);
    }
  }
}
