#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "taylor.icc"
#include "stokes_dirichlet_dg.icc"
#include "inertia_cks.icc"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  space Xh (omega, argv[2], "vector");
  space Qh (omega, argv[2]);
  Float  Re       = (argc > 3) ? atof(argv[3]) : 1;
  size_t max_iter = (argc > 4) ? atoi(argv[4]) : 1;
  form a, b, c, mp;
  field lh, kh;
  stokes_dirichlet_dg (Xh, Qh, a, b, c, mp, lh, kh);
  field uh (Xh, 0), ph (Qh, 0);
  solver_abtb stokes (a.uu(), b.uu(), c.uu(), mp.uu());
  stokes.solve (lh.u(), kh.u(), uh.set_u(), ph.set_u());
  trial u (Xh); test v (Xh);
  form a1 = a + Re*inertia (uh, u, v);
  lh += Re*inertia_fix_rhs (v);
  derr << "#k r as" << endl;
  for (size_t k = 0; k < max_iter; ++k) {
    solver_abtb stokes (a1.uu(), b.uu(), c.uu(), mp.uu());
    stokes.solve (lh.u(), kh.u(), uh.set_u(), ph.set_u());
    form th = inertia (uh, u, v);
    a1 = a + Re*th;
    field rh = a1*uh + b.trans_mult(ph) - lh;
    derr << k << " " << rh.max_abs() << " " << th(uh,uh) << endl;
  }
  dout << catchmark("Re") << Re << endl
       << catchmark("u")  << uh
       << catchmark("p")  << ph;
}
