#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "cosinusprod.icc"
#include "cosinusprod_grad.icc"
int main(int argc, char**argv) {
  environment rheolef(argc, argv);
  field uh; din >> uh;
  space Xh = uh.get_space();
  geo omega = Xh.get_geo();
  size_t k = Xh.degree();
  size_t d = omega.dimension();
  space Vh (omega, "P"+itos(k));
  Vh.block("boundary");
  space Wh (omega["boundary"], "P"+itos(k));
  test u (Vh); trial v (Vh);
  form_option_type fopt;
  fopt.lump = true;
  fopt.set_family(quadrature_option_type::gauss_lobatto);
  fopt.set_order(k);
  form m = integrate (u*v, fopt);
  field lh = integrate (uh*v, fopt);
  field uh_star (Vh, 0);
  uh_star ["boundary"] = interpolate(Wh, u_exact(d));
  solver sm (m.uu());
  uh_star.set_u() = sm.solve(lh.u() - m.ub()*uh_star.b());
  quadrature_option_type qopt;
#define TRUE_ERROR
#ifdef TRUE_ERROR
  qopt.set_family(quadrature_option_type::gauss);
  qopt.set_order(2*k+1);
  space Xh1 (omega, "P"+itos(k+1)+"d");
#else // TRUE_ERROR
  qopt.set_family(quadrature_option_type::gauss_lobatto);
  qopt.set_order(k);
  space Xh1 = Xh;
#endif // TRUE_ERROR
  field eh      = interpolate (Xh1, uh-u_exact(d));
  field eh_star = interpolate (Xh1, uh_star-u_exact(d));
  field eta_h   = eh_star - eh;
  Float err_linf      = eh.max_abs();
  Float err_star_linf = eh_star.max_abs();
  Float eta_linf      = eta_h.max_abs();
  Float err_l2       = sqrt(integrate (omega, sqr(uh-u_exact(d)), qopt));
  Float err_star_l2  = sqrt(integrate (omega, sqr(uh_star-u_exact(d)), qopt));
  Float eta_l2       = sqrt(integrate (omega, sqr(eta_h), qopt));
  Float err_h1       = sqrt(integrate (omega, norm2(grad_h(uh)-grad_u(d)), qopt));
  Float err_star_h1  = sqrt(integrate (omega, norm2(grad(uh_star)-grad_u(d)), qopt));
  Float eta_h1       = sqrt(integrate (omega, norm2(grad_h(eta_h)), qopt));
  // gradient as P0
  space G0h (omega, "P0", "vector");
  field grad_eh    = interpolate (G0h, grad_h(eh));
  field grad_eta_h = interpolate (G0h, grad_h(eta_h));
  // proj gradient as P1
  space G1h (omega, "P1", "vector");
  G1h.block("boundary");
  test uu (G1h); trial vv (G1h);
  form m1v = integrate(dot(uu,vv), fopt);
  solver sm1v (m1v.uu());
  field l1h = integrate (dot(grad_eh,vv));
  field grad_eh_p1 (G1h, 0);
  grad_eh_p1.set_u() = sm1v.solve(l1h.u());
  field l2h = integrate (dot(grad_eta_h,vv));
  field grad_eta_h_p1 (G1h, 0);
  grad_eta_h_p1.set_u() = sm1v.solve(l2h.u());
  // calcul de s_eta_h = sqrt(int_K eta_h^2 dx) : P0
  space X0h (omega, "P0");
  test v0 (X0h);
  field s_eta_h2 = integrate (sqr(eta_h)*v0);
  field s_eta_h = interpolate (X0h, sqrt(s_eta_h2));
  field s_eh2 = integrate (sqr(uh-u_exact(d))*v0);
  field s_eh = interpolate (X0h, sqrt(s_eh2));
  derr << "err_l2        = " << err_l2      << endl
       << "eta_l2        = " << eta_l2      << endl
       << "err_star_l2   = " << err_star_l2 << endl
       << "err_linf      = " << err_linf      << endl
       << "eta_linf      = " << eta_linf      << endl
       << "err_star_linf = " << err_star_linf << endl
       << "err_h1        = " << err_h1      << endl
       << "eta_h1        = " << eta_h1      << endl
       << "err_star_h1   = " << err_star_h1 << endl;
  dout << catchmark ("grad_eta_h")   << grad_eta_h_p1
       << catchmark ("grad_eh")      << grad_eh_p1
       << catchmark ("eta_h")   << eta_h
       << catchmark ("eh")      << eh
       << catchmark ("uh")      << uh
       << catchmark ("uh_star") << uh_star
       << catchmark ("s_eta_h") << s_eta_h
       << catchmark ("s_eh")    << s_eh
    ;
}
