
(*
ree, rom extension extractor

rom layout
byte a desc
1    U id
2     id
3      length in 512-byte pages
4..n   executable rom code, n = byte.offset.3 x 512

scan for following stuff to detect some more stuff
$PnP			PlugandPlay BIOS
$IBU     	Inter BIOS Upgrade
_32_			BIOS 32 API
_MP_  		MultiProcessor Support
RSD PTR  	ACPI (Advanced Configuration Powermanagement Interface)
ASUS_FLASH  Asus FlashROM
AWDFLASH		Award FlashROM
FLASH			FlashROM
*)

uses crt;

var
	id: array[0..254] of char;
	id2: array[0..254] of char;

function SearchBuffer(var Buffer; BufLength : Word; var Match; MatLength : Word) : Word;
{-Search through Buffer for Match. BufLength is length of range to search.
MatLength is length of string to match. Returns number of bytes searched
to find Match, $FFFF if not found.}
begin
	inline(
   $1E/                   {PUSH DS                 ;Save DS}
   $FC/                   {CLD                     ;Go forward}
   $C4/$7E/<Buffer/       {LES  DI,[BP+<Buffer]    ;ES:DI => Buffer}
   $89/$FB/               {MOV  BX,DI              ;BX = Ofs(Buffer)}
   $8B/$4E/<BufLength/    {MOV  CX,[BP+<BufLength] ;CX = Length of range to scan}
   $8B/$56/<MatLength/    {MOV  DX,[BP+<MatLength] ;DX = Length of match string}
   $85/$D2/               {TEST DX,DX              ;Length(Match) = 0?}
   $74/$24/               {JZ   Error              ;If so, we're done}
   $C5/$76/<Match/        {LDS  SI,[BP+<Match]     ;DS:SI => Match buffer}
   $AC/                   {LODSB                   ;AL = Match[1]; DS:SI => Match[2]}
   $4A/                   {DEC  DX                 ;DX = MatLength-1}
   $29/$D1/               {SUB  CX,DX              ;CX = BufLength-(MatLength-1)}
   $76/$1B/               {JBE  Error              ;Error if BufLength is less}
                          {;Search for first character in Match}
                          {Next:}
   $F2/$AE/               {REPNE SCASB             ;Search forward for Match[1]}
   $75/$17/               {JNE  Error              ;Done if not found}
   $85/$D2/               {TEST DX,DX              ;If Length = 1 (DX = 0) ...}
   $74/$0C/               {JZ   Found              ; the "string" was found}
                          {;Search for remainder of Match}
   $51/                   {PUSH CX                 ;Save CX}
   $57/                   {PUSH DI                 ;Save DI}
   $56/                   {PUSH SI                 ;Save SI}
   $89/$D1/               {MOV  CX,DX              ;CX = Length(Match) - 1}
   $F3/$A6/               {REPE CMPSB              ;Does rest of string match?}
   $5E/                   {POP  SI                 ;Restore SI}
   $5F/                   {POP  DI                 ;Restore DI}
   $59/                   {POP  CX                 ;Restore CX}
   $75/$EC/               {JNE  Next               ;Try again if no match}
                          {;Calculate number of bytes searched and return}
                          {Found:}
   $4F/                   {DEC  DI                 ;DX = Offset where found}
   $89/$F8/               {MOV  AX,DI              ;AX = Offset where found}
   $29/$D8/               {SUB  AX,BX              ;Subtract starting offset}
   $EB/$03/               {JMP  SHORT SDone        ;Done}
                          {;Match was not found}
                          {Error:}
   $31/$C0/               {XOR  AX,AX              ;Return $FFFF}
   $48/                   {DEC  AX}
                          {SDone:}
   $1F/                   {POP  DS                 ;Restore DS}
	$89/$46/<SearchBuffer); {MOV [BP+<Search],AX     ;Set func result}
end;

function str_left(str: string; NumChars: Integer): String;
begin
   str_left := Copy(Str, 1, NumChars);
end;

function byte2hex(b: byte): string;
const hexcar: string[16] = ('0123456789ABCDEF');
begin; byte2hex := hexcar[1+(b shr 4)] + hexcar[1+(b and $0F)]; end;

function word2hex(w: word): string;
begin; word2hex := byte2hex(hi(w)) + byte2hex(lo(w)); end;

procedure saverom(psegm: word; size: longint);
var
	f: file;
   res: word;
begin
	assign(f,word2hex(psegm)+'.rom');
   rewrite(f,1);
   blockwrite(f, mem[psegm:0], size, res);
   close(f);
end;

procedure showpage(psegm: word);
var
	l: word;
	c: byte;
   idl: array[0..1] of char;
   answer: string;
begin
   answer:='';
	clrscr;

   write(word2hex(psegm),':0000 id(55AA=ok)=');
   idl[0]:=char(mem[psegm:0]);
	idl[1]:=char(mem[psegm:1]);
	write(byte2hex(mem[psegm:0]),byte2hex(mem[psegm:1]),' size=',word(mem[psegm:2]*512));
   c:=0;
   for l:=0 to (word(mem[psegm:2]*512)-1) do inc(c,mem[psegm:l]);
	write(' checksum(0=ok)=',c);

   if (idl='U') and (c=0) then begin
   	writeln;
   	move(mem[psegm:0],id,sizeof(id));
   	write(id);
   	move(mem[psegm:255],id2,sizeof(id2));
   	writeln(id2);

   	writeln;
		write('extract rom? ');
      readln(answer);

      if (answer='y') or (answer='Y') then begin
         saverom(psegm,mem[psegm:2]*512{-1});
      end;
   end else begin
		{readln;}
   end;

   {if (idl='U') and (psegm>=$e000) then begin
   	writeln;
   	move(mem[psegm:0],id,sizeof(id));
   	write(id);
   	move(mem[psegm:255],id2,sizeof(id2));
   	writeln(id2);

   	writeln;
		write('extract rom? ');
      readln(answer);

      if (answer='y') or (answer='Y') then begin
         saverom(psegm,65535);
      end;
	end;}
end;

var
	f: file;
   res: word;
	scan: word;
	scanstr: string;
   strbuf: string;
begin
	if paramstr(1)='/?' then begin
   	writeln('this program searches for rom extensions in your memory from C000:0000 to');
      writeln('FF00:0000 in 512 byte steps. if it finds one, it asks you; extract? then');
      writeln('you can just press enter to go on or press y and hit enter to extract it');
      writeln('to a file called mmmm.rom, where mmmm is the segment address in hex.');
      writeln;
      writeln('when found a rom, it also print the first 512 bytes to the screen, this');
      writeln('can cause some beeps (#7), just ignore them. the message extract you''ll');
      writeln('see in any case.');
      writeln;
      writeln('/sys for writing system rom to disk F000:0000');
		exit;
   end;

   if paramstr(1)='/sys' then begin
		assign(f,'f000.rom');
   	rewrite(f,1);
   	blockwrite(f, mem[$f000:0], 65535, res);
   	blockwrite(f, mem[$f000:65535], 1, res);
   	close(f);
      exit;
   end;

   if paramstr(1)='/analyse' then begin
   	writeln('scanning for more information...');
   	{for scan:=$c000 to $fff0 do begin}

			scanstr:='(c)';
			if SearchBuffer(mem[$c000:0],65535,scanstr,3)<>65535 then writeln('Plug and Play BIOS');
			if SearchBuffer(mem[$d000:0],65535,scanstr,3)<>65535 then writeln('Plug and Play BIOS');
			if SearchBuffer(mem[$e000:0],65535,scanstr,3)<>65535 then writeln('Plug and Play BIOS');
			if SearchBuffer(mem[$f000:0],65535,scanstr,3)<>65535 then writeln('Plug and Play BIOS');
      	{move(mem[scan:0],strbuf,48);
			if pos('$PnP',strbuf)>0 then writeln(word2hex(scan),' Plug and Play BIOS');
			if pos('$IBU',strbuf)>0 then writeln(word2hex(scan),' Intel BIOS Upgrade');
			if pos('_32_',strbuf)>0 then writeln(word2hex(scan),' BIOS 32 API');
			if pos('_MP_',strbuf)>0 then writeln(word2hex(scan),' MultiProcessor supported');
			if pos('RSD PTR',strbuf)>0 then writeln(word2hex(scan),' ACPI');
			if pos('FLASH',strbuf)>0 then writeln(word2hex(scan),' FlashROM');
			if pos('ASUS_FLASH',strbuf)>0 then writeln(word2hex(scan),' Asus FlashROM');
			if pos('AWDFLASH',strbuf)>0 then writeln(word2hex(scan),' Award FlashROM');
			if pos('VBE',strbuf)>0 then writeln(word2hex(scan),' VBE');
			if pos('VESA',strbuf)>0 then writeln(word2hex(scan),' VESA');
			if pos('Video',strbuf)>0 then writeln(word2hex(scan),' Video');
         if pos('Adaptec BIOS',strbuf)>0 then writeln(word2hex(scan),' Adaptec BIOS');
         }
   	{end;}
		exit;
   end;

	clrscr;
   for scan:=$c000 to $ff00 do begin
   	showpage(scan);

      inc(scan,511);
      if scan>$ff00 then scan:=$ff00;
   end;

   clrscr;
   writeln('rom extension extractor v1.00, (c)oded by tarzeau/carrots ''97');
   writeln;
   writeln('/?       for help');
   writeln('/sys     for writing system rom to disk F000:0000');
   writeln('/analyse for more information about your system');
end.
