#!/bin/bash

########################################################################
#                                                                      #
#  Here you can edit the script runned                                 #
#  each time daemon order this session to be closed                    #
#  WARNING: You can be here in a switch situation,                     #
#           a session can be opened just after.                        #
#                                                                      #
#  You have access the following environment variables                 #
#  RAY_SESSION_PATH : Folder of the current session                    #
#  RAY_FUTURE_SESSION_PATH: Folder of the session that will be opened  #
#     just after current session close.                                #
#  RAY_SCRIPTS_DIR  : Folder containing this script                    #
#     ray-scripts folder can be directly in current session            #
#     or in a parent folder.                                           #
#  RAY_PARENT_SCRIPT_DIR : Folder containing the scripts that would    #
#     be runned if RAY_SCRIPTS_DIR would not exists                    #
#  RAY_SWITCHING_SESSION: 'true' or 'false'                            #
#     'true' if session is switching from another session              #
#     and probably some clients are still alive.                       #
#                                                                      #
#  To get any other session informations, refers to ray_control help   #
#     typing: ray_control --help                                       #
#                                                                      #
########################################################################

# set it to 'false' if you want the script
# not to handle the ports of the PulseAudio -> JACK bridge
export RAY_MANAGE_PULSEAUDIO=true

# set it to 'false' if you want the script
# if you want the script to trust the parameters of JACK
export RAY_JACK_RELIABILITY_CHECK=true

# set it to 'false' if you want the script to not consider hostname
# then, a session can not be open on another machine
# if it doesn't have the same sound interface
export RAY_HOSTNAME_SENSIBLE=true


close_all_if_needed=''

if [[ "$RAY_FUTURE_SCRIPTS_DIR" != "$RAY_SCRIPTS_DIR" ]] &&\
        ! [ -f "$RAY_FUTURE_SCRIPTS_DIR/.jack_config_script" ];then
    close_all_if_needed=close_all
fi

ray_control run_step $close_all_if_needed

if [ -n "$close_all_if_needed" ];then
    ray-jack_config_script putback && ray_control hide_script_info
fi

exit 0
