# Announce: Rakudo Perl 6 compiler, Development Release #87 ("Vladivostok")

On behalf of the Rakudo development team, I'm happy to announce the April
2015 release of Rakudo Perl 6 #87 "Vladivostok". Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1] and the Java Virtual Machine. The
tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it's announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The Rakudo Perl compiler follows a monthly release cycle, with each
release named after a Perl Mongers group. This month's release is named after
Vladivostok, because we've run out of .pm groups in China.

Some of the changes in this release are outlined below:

* Installation directory layout changed: it now uses $PREFIX/share instead of
   $PREFIX/languages
* "0" (0 as a string) is now True, no special-casing anymore
* an Int() coercion type in a multi now creates two candidates: Any and Int
* numerous small fixes
* native arrays
* 'bit' and 'byte' native types
* starts-with/substr-eq/ends-with for comparing strings inside other strings
* basic implementation of Uni, NFC, NFD, NFKC, and NFKD on Moar backend
* where constraints on variable and attribute declarations
* 'is rw' parameters implemented for native subs (they get passed as a pointer)
* Str.codes/chars/uc/lc/tc/tclc/ord/flip about 25% faster
* use Foo:from\<Perl5\> and EVAL $code, :lang\<perl5\> are now supported as
   long as Inline::Perl5 is installed. Allows passing most of S01 spec tests.
* many smaller speedups

These are only some of the changes in this release. For a more
detailed list, see "docs/ChangeLog".

The development team thanks all of our contributors and sponsors for
making Rakudo Perl possible, as well as those people who worked on
Parrot, the Perl 6 test suite, MoarVM and the specification.

The following people contributed to this release:

Jonathan Worthington, Larry Wall, Elizabeth Mattijsen, Tobias Leich, Pepe
Schwarz, Moritz Lenz, Will "Coke" Coleda, Carl Mäsak, Alexander Moquin,
raydiak, Brent Laabs, Christian Bartolomäus, Timo Paulssen, Jonathan Stowe,
Stefan Seifert, Jonathan Scott Duff, Rob Hoelz, Edwin Steiner, Geoffrey
Broadwell, nwc10, eli-se, lucasb

If you would like to contribute, see <http://rakudo.org/how-to-help>,
ask on the <perl6-compiler@perl.org> mailing list, or ask on IRC #perl6
on freenode.

The next release of Rakudo (#88), is scheduled for 21 May 2015.
A list of the other planned release dates and code names for future
releases is available in the "docs/release_guide.pod" file. A Rakudo
development release typically occurs a few days (often two) after the
third Tuesday of each month.

The development team appreciates feedback! If you're using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

[^1]: See <http://moarvm.org/>

[^2]: What's the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the "Using Perl 6" book, and other software that can
be used with the Rakudo compiler to enhance its utility.  Rakudo Star
is meant for early adopters who wish to explore what's possible with
Rakudo Perl 6 and provide feedback on what works, what doesn't, and
what else they would like to see included in the distribution.
