% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ascat.prepareHTS.R
\name{ascat.getBAFsAndLogRs}
\alias{ascat.getBAFsAndLogRs}
\title{Obtain BAF and LogR from the allele counts.}
\usage{
ascat.getBAFsAndLogRs(
  samplename,
  tumourAlleleCountsFile.prefix,
  normalAlleleCountsFile.prefix,
  tumourLogR_file,
  tumourBAF_file,
  normalLogR_file,
  normalBAF_file,
  alleles.prefix,
  gender,
  genomeVersion,
  chrom_names = c(1:22, "X"),
  minCounts = 20,
  BED_file = NA,
  probloci_file = NA,
  seed = as.integer(Sys.time())
)
}
\arguments{
\item{samplename}{String, name of the sample.}

\item{tumourAlleleCountsFile.prefix}{Prefix of the allele counts files for the tumour (e.g. "Tumour_alleleFrequencies_chr").}

\item{normalAlleleCountsFile.prefix}{Prefix of the allele counts files for the normal (e.g. "Normal_alleleFrequencies_chr").}

\item{tumourLogR_file}{File where LogR from the tumour will be written.}

\item{tumourBAF_file}{File where BAF from the tumour will be written.}

\item{normalLogR_file}{File where LogR from the normal will be written.}

\item{normalBAF_file}{File where BAF from the normal will be written.}

\item{alleles.prefix}{Prefix path to the allele data (e.g. "G1000_alleles_chr")}

\item{gender}{Gender information, either 'XX' (=female) or 'XY' (=male).}

\item{genomeVersion}{Genome version, either 'hg19' or 'hg38'.}

\item{chrom_names}{A vector with allowed chromosome names (optional, default=c(1:22,'X')). Do not set it to paste0('chr',c(1:22,'X')) if data is 'chr'-based.}

\item{minCounts}{Minimum depth, in normal samples, required for a SNP to be considered (optional, default=20).}

\item{BED_file}{A BED file for only looking at SNPs within specific intervals (optional, default=NA).}

\item{probloci_file}{A file (chromosome <tab> position; no header) containing specific loci to ignore (optional, default=NA).}

\item{seed}{A seed to be set when randomising the alleles (optional, default=as.integer(Sys.time())).}
}
\description{
Obtain BAF and LogR from the allele counts.
}
\author{
dw9, sd11, tl
}
