#include "qzion.h"
#include <QtGui>

#define printrgb(color) \
    printf("R: %d  G: %d  B: %d  A: %d\n", color.red(), color.green(), \
           color.blue(), color.alpha());

QZionRectangle *createRect(QColor color, int x, int w, QZionCanvas &canvas) {
    QZionRectangle *rect = new QZionRectangle(&canvas);
    rect->setColor(color);
    rect->setSize(QSize(w,600));
    rect->setPos(x, 0);
    rect->show();
    return rect;
}

int main(int argc, char** argv) {

    QApplication app(argc, argv);
    QZionCanvas canvas;
    QList<QZionObject*> list;

    canvas.setSize(QSize(800, 600));

    /**************************************************/
    /****            RECTANGLES TEST               ****/
    /**************************************************/


    QZionRectangle *bg = new QZionRectangle(&canvas);
    bg->setColor(Qt::black);
    bg->setSize(QSize(800, 600));
    bg->setPos(0, 0);
    bg->show();
//    list.append(bg);


    // Red Rect
    QZionRectangle *rect1 = createRect(Qt::red, 0, 114, canvas);
    list.append(rect1);

    // Green Rect
    QZionRectangle *rect2 = createRect(Qt::green, 114, 114, canvas);
    list.append(rect2);

    // Blue Rect
    QZionRectangle *rect3 = createRect(Qt::blue, 228, 114, canvas);
    list.append(rect3);

    // White Rect
    QZionRectangle *rect4 = createRect(Qt::white, 353, 94, canvas);
    list.append(rect4);

    // Cyan Rect
    QZionRectangle *rect5 = createRect(Qt::cyan, 458, 114, canvas);
    list.append(rect5);

    // Magenta Rect
    QZionRectangle *rect6 = createRect(Qt::magenta, 572, 114, canvas);
    list.append(rect6);

    // Yellow Rect
    QZionRectangle *rect7 = createRect(Qt::yellow, 686, 114, canvas);
    list.append(rect7);


    // Clipper
    QZionRectangle *clip3 = new QZionRectangle(&canvas);
    clip3->setColor(QColor(255, 255, 255, 255));
    clip3->setSize(QSize(800, 600));
    clip3->setPos(20, 100);
    clip3->show();

    QZionGroup *group = new QZionGroup(&canvas);
    group->setColor(QColor(255, 255, 255, 128));
    group->setSize(QSize(800, 600));
    group->setPos(0, 0);
    group->show();

    QZionGroup *group2 = new QZionGroup(&canvas);
    group2->setColor(QColor(255, 255, 255, 128));
    group2->setSize(QSize(300, 200));
    group2->setPos(0, 0);
    group2->show();


    foreach(QZionObject *obj, list) {
        //obj->setClipper(clip3);
        group->addObject(obj);
    }

    group2->addObject(group);
    group->setClipper(clip3);
    list.append(clip3);

    QZionRectangle *clip2 = new QZionRectangle(&canvas);
    clip2->setColor(QColor(255, 255, 255, 128));
    clip2->setSize(QSize(800, 300));
    clip2->setPos(0, 0);
    clip2->show();
    list.append(clip2);
    clip3->setClipper(clip2);


    /**************************************************/
    /****              IMAGES TEST                 ****/
    /**************************************************/


    QZionImage *img1 = new QZionImage(&canvas, "../images/image.png");

    img1->setPos(350, 10);
    img1->show();
    img1->setClipper(clip3);
    list.append(img1);



    /**************************************************/
    /****               TEXT  TEST                 ****/
    /**************************************************/

/*
    QZionText *text1 = new QZionText(&canvas);
//    text1->setTextColor(Qt::white);
    text1->setShadowColor(Qt::white);
//    text1->setColor(Qt::magenta);
    text1->setText("Hello World");
    text1->setFont(QFont("Nokia Sans", 25));
    text1->setPos(QPoint(205, 85));
    text1->setSize(QSize(200, 50));
    text1->show();
    text1->setClipper(clip3);
//    text1->setOpacity(200);
    text1->setStyle(QZionText::Shadow);
*/


    /**************************************************/
    /****             TEXTBLOCK TEST               ****/
    /**************************************************/

    QZionTextBlock *tblock = new QZionTextBlock(&canvas);
    tblock->setSize(QSize(300, 300));
    tblock->setPos(100, 76);
    tblock->setText("<font size=20 color=#fff>TESTE</font><br><font size=20 color=#ff0>LOREMIPSUM</font>");
    tblock->show();
    tblock->setClipper(clip3);

    list.append(tblock);

    /**************************************************/
    /****             RUN EVERYTHING               ****/
    /**************************************************/

    canvas.show();
    app.exec();

    foreach(QZionObject *obj, list) {
        delete obj;
    }


//    delete img1;
//    delete clip1;

}
